;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns vectio.middleware.mtls
  (:require [fides.tls-credential :as fides])
  (:import [java.security.cert X509Certificate]))

(defn middleware
  "Validates the TLSCredential by calling the `authorizer` with it.
  The `authorizer` should return a map that will be merged with
  the request under an `:auth` key or a nil if the certificate
  is considered invalid"
  [authorizer handler]
  (fn [{:keys [peer-cert-chain] :as request}]
    (let [^X509Certificate peer-cert (first peer-cert-chain)
          cred (fides/x509-> peer-cert)]
      (if-let [auth-map (authorizer cred)]
        (handler
         (assoc request :auth auth-map))
        {:status 403}))))
