goog.provide('utilis.string');
/**
 * Replaces a trimmed version of 's' with all consecutive runs of whitespace
 *   characters replaced with a single space.
 */
utilis.string.collapse_whitespace = (function utilis$string$collapse_whitespace(s){
return clojure.string.trim(clojure.string.replace(s,/\s+/," "));
});
/**
 * Returns a boolean indicating whether 's' represents a numeric value
 */
utilis.string.numeric_QMARK_ = (function utilis$string$numeric_QMARK_(s){
var re = /(?:NaN|-?(?:(?:\d+|\d*(\.|\/)\d+)(?:[E|e][+|-]?\d+)?|Infinity))/;
return cljs.core.boolean$((new RegExp(re.source)).exec(s));
});
/**
 * Add 'prefix' to 's' if 's' does not already start with 'prefix'
 */
utilis.string.ensure_starts_with = (function utilis$string$ensure_starts_with(s,prefix){
var G__53887 = s;
if((!(clojure.string.starts_with_QMARK_(s,prefix)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefix),cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__53887)].join('');
} else {
return G__53887;
}
});
/**
 * Add 'suffix' to 's' if 's' does not already end with 'suffix'
 */
utilis.string.ensure_ends_with = (function utilis$string$ensure_ends_with(s,suffix){
var G__53890 = s;
if((!(clojure.string.ends_with_QMARK_(s,suffix)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__53890),cljs.core.str.cljs$core$IFn$_invoke$arity$1(suffix)].join('');
} else {
return G__53890;
}
});
utilis.string.format = goog.string.format;
/**
 * Returns the same substring as clojure.core/subs, additionally allows
 *   for start and/or end to be negative, in which case the index is
 *   taken from the end of the string.
 */
utilis.string.subs = (function utilis$string$subs(var_args){
var G__53904 = arguments.length;
switch (G__53904) {
case 2:
return utilis.string.subs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return utilis.string.subs.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(utilis.string.subs.cljs$core$IFn$_invoke$arity$2 = (function (s,start){
var start__$1 = (((start < (0)))?(cljs.core.count(s) + start):start);
return s.substring(start__$1);
}));

(utilis.string.subs.cljs$core$IFn$_invoke$arity$3 = (function (s,start,end){
var start__$1 = (((start < (0)))?(cljs.core.count(s) + start):start);
var end__$1 = (((end < (0)))?(cljs.core.count(s) + end):end);
return s.substring(start__$1,end__$1);
}));

(utilis.string.subs.cljs$lang$maxFixedArity = 3);

/**
 * Splits a string into 2 at the given index.  If the index is negative,
 *   it is split from the end of the string.
 */
utilis.string.split_at = (function utilis$string$split_at(s,ind){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [utilis.string.subs.cljs$core$IFn$_invoke$arity$3(s,(0),ind),utilis.string.subs.cljs$core$IFn$_invoke$arity$3(s,ind,cljs.core.count(s))], null);
});

//# sourceMappingURL=utilis.string.js.map
