goog.provide('cljs.core.async');
goog.scope(function(){
  cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async49790 = (function (f,blockable,meta49791){
this.f = f;
this.blockable = blockable;
this.meta49791 = meta49791;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async49790.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_49792,meta49791__$1){
var self__ = this;
var _49792__$1 = this;
return (new cljs.core.async.t_cljs$core$async49790(self__.f,self__.blockable,meta49791__$1));
}));

(cljs.core.async.t_cljs$core$async49790.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_49792){
var self__ = this;
var _49792__$1 = this;
return self__.meta49791;
}));

(cljs.core.async.t_cljs$core$async49790.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async49790.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async49790.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async49790.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async49790.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta49791","meta49791",-627292529,null)], null);
}));

(cljs.core.async.t_cljs$core$async49790.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async49790.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async49790");

(cljs.core.async.t_cljs$core$async49790.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async49790");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async49790.
 */
cljs.core.async.__GT_t_cljs$core$async49790 = (function cljs$core$async$__GT_t_cljs$core$async49790(f,blockable,meta49791){
return (new cljs.core.async.t_cljs$core$async49790(f,blockable,meta49791));
});


cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__49786 = arguments.length;
switch (G__49786) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
return (new cljs.core.async.t_cljs$core$async49790(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__49815 = arguments.length;
switch (G__49815) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed, then return the value (or nil) forever. See chan for the
 *   semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__49830 = arguments.length;
switch (G__49830) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__49858 = arguments.length;
switch (G__49858) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_52107 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_52107) : fn1.call(null, val_52107));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_52107) : fn1.call(null, val_52107));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__49864 = arguments.length;
switch (G__49864) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5821__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5821__auto__)){
var ret = temp__5821__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5821__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5821__auto__)){
var retb = temp__5821__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null, ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null, ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5593__auto___52112 = n;
var x_52114 = (0);
while(true){
if((x_52114 < n__5593__auto___52112)){
(a[x_52114] = x_52114);

var G__52115 = (x_52114 + (1));
x_52114 = G__52115;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle(a);

return a;
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async49886 = (function (flag,meta49887){
this.flag = flag;
this.meta49887 = meta49887;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async49886.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_49888,meta49887__$1){
var self__ = this;
var _49888__$1 = this;
return (new cljs.core.async.t_cljs$core$async49886(self__.flag,meta49887__$1));
}));

(cljs.core.async.t_cljs$core$async49886.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_49888){
var self__ = this;
var _49888__$1 = this;
return self__.meta49887;
}));

(cljs.core.async.t_cljs$core$async49886.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async49886.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async49886.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async49886.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async49886.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta49887","meta49887",-226452152,null)], null);
}));

(cljs.core.async.t_cljs$core$async49886.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async49886.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async49886");

(cljs.core.async.t_cljs$core$async49886.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async49886");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async49886.
 */
cljs.core.async.__GT_t_cljs$core$async49886 = (function cljs$core$async$__GT_t_cljs$core$async49886(flag,meta49887){
return (new cljs.core.async.t_cljs$core$async49886(flag,meta49887));
});


cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
return (new cljs.core.async.t_cljs$core$async49886(flag,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async49891 = (function (flag,cb,meta49892){
this.flag = flag;
this.cb = cb;
this.meta49892 = meta49892;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async49891.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_49893,meta49892__$1){
var self__ = this;
var _49893__$1 = this;
return (new cljs.core.async.t_cljs$core$async49891(self__.flag,self__.cb,meta49892__$1));
}));

(cljs.core.async.t_cljs$core$async49891.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_49893){
var self__ = this;
var _49893__$1 = this;
return self__.meta49892;
}));

(cljs.core.async.t_cljs$core$async49891.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async49891.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async49891.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async49891.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async49891.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta49892","meta49892",315002879,null)], null);
}));

(cljs.core.async.t_cljs$core$async49891.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async49891.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async49891");

(cljs.core.async.t_cljs$core$async49891.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async49891");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async49891.
 */
cljs.core.async.__GT_t_cljs$core$async49891 = (function cljs$core$async$__GT_t_cljs$core$async49891(flag,cb,meta49892){
return (new cljs.core.async.t_cljs$core$async49891(flag,cb,meta49892));
});


cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
return (new cljs.core.async.t_cljs$core$async49891(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var ports__$1 = cljs.core.vec(ports);
var n = cljs.core.count(ports__$1);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports__$1,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null, (0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null, (1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,ports__$1,n,idxs,priority){
return (function (p1__49896_SHARP_){
var G__49899 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__49896_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__49899) : fret.call(null, G__49899));
});})(i,val,idx,port,wport,flag,ports__$1,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,ports__$1,n,idxs,priority){
return (function (p1__49897_SHARP_){
var G__49900 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__49897_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__49900) : fret.call(null, G__49900));
});})(i,idx,port,wport,flag,ports__$1,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__5002__auto__ = wport;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return port;
}
})()], null));
} else {
var G__52128 = (i + (1));
i = G__52128;
continue;
}
} else {
return null;
}
break;
}
})();
var or__5002__auto__ = ret;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5823__auto__ = (function (){var and__5000__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null, );
if(cljs.core.truth_(and__5000__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null, );
} else {
return and__5000__auto__;
}
})();
if(cljs.core.truth_(temp__5823__auto__)){
var got = temp__5823__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5732__auto__ = [];
var len__5726__auto___52129 = arguments.length;
var i__5727__auto___52131 = (0);
while(true){
if((i__5727__auto___52131 < len__5726__auto___52129)){
args__5732__auto__.push((arguments[i__5727__auto___52131]));

var G__52133 = (i__5727__auto___52131 + (1));
i__5727__auto___52131 = G__52133;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__49928){
var map__49929 = p__49928;
var map__49929__$1 = cljs.core.__destructure_map(map__49929);
var opts = map__49929__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq49915){
var G__49916 = cljs.core.first(seq49915);
var seq49915__$1 = cljs.core.next(seq49915);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__49916,seq49915__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__49935 = arguments.length;
switch (G__49935) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__49699__auto___52138 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__49700__auto__ = (function (){var switch__49490__auto__ = (function (state_50026){
var state_val_50028 = (state_50026[(1)]);
if((state_val_50028 === (7))){
var inst_50022 = (state_50026[(2)]);
var state_50026__$1 = state_50026;
var statearr_50031_52140 = state_50026__$1;
(statearr_50031_52140[(2)] = inst_50022);

(statearr_50031_52140[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50028 === (1))){
var state_50026__$1 = state_50026;
var statearr_50036_52142 = state_50026__$1;
(statearr_50036_52142[(2)] = null);

(statearr_50036_52142[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50028 === (4))){
var inst_49987 = (state_50026[(7)]);
var inst_49987__$1 = (state_50026[(2)]);
var inst_50005 = (inst_49987__$1 == null);
var state_50026__$1 = (function (){var statearr_50041 = state_50026;
(statearr_50041[(7)] = inst_49987__$1);

return statearr_50041;
})();
if(cljs.core.truth_(inst_50005)){
var statearr_50046_52144 = state_50026__$1;
(statearr_50046_52144[(1)] = (5));

} else {
var statearr_50047_52146 = state_50026__$1;
(statearr_50047_52146[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50028 === (13))){
var state_50026__$1 = state_50026;
var statearr_50049_52148 = state_50026__$1;
(statearr_50049_52148[(2)] = null);

(statearr_50049_52148[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50028 === (6))){
var inst_49987 = (state_50026[(7)]);
var state_50026__$1 = state_50026;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_50026__$1,(11),to,inst_49987);
} else {
if((state_val_50028 === (3))){
var inst_50024 = (state_50026[(2)]);
var state_50026__$1 = state_50026;
return cljs.core.async.impl.ioc_helpers.return_chan(state_50026__$1,inst_50024);
} else {
if((state_val_50028 === (12))){
var state_50026__$1 = state_50026;
var statearr_50051_52149 = state_50026__$1;
(statearr_50051_52149[(2)] = null);

(statearr_50051_52149[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50028 === (2))){
var state_50026__$1 = state_50026;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50026__$1,(4),from);
} else {
if((state_val_50028 === (11))){
var inst_50015 = (state_50026[(2)]);
var state_50026__$1 = state_50026;
if(cljs.core.truth_(inst_50015)){
var statearr_50052_52150 = state_50026__$1;
(statearr_50052_52150[(1)] = (12));

} else {
var statearr_50053_52151 = state_50026__$1;
(statearr_50053_52151[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50028 === (9))){
var state_50026__$1 = state_50026;
var statearr_50055_52152 = state_50026__$1;
(statearr_50055_52152[(2)] = null);

(statearr_50055_52152[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50028 === (5))){
var state_50026__$1 = state_50026;
if(cljs.core.truth_(close_QMARK_)){
var statearr_50056_52153 = state_50026__$1;
(statearr_50056_52153[(1)] = (8));

} else {
var statearr_50057_52154 = state_50026__$1;
(statearr_50057_52154[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50028 === (14))){
var inst_50020 = (state_50026[(2)]);
var state_50026__$1 = state_50026;
var statearr_50058_52155 = state_50026__$1;
(statearr_50058_52155[(2)] = inst_50020);

(statearr_50058_52155[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50028 === (10))){
var inst_50011 = (state_50026[(2)]);
var state_50026__$1 = state_50026;
var statearr_50059_52156 = state_50026__$1;
(statearr_50059_52156[(2)] = inst_50011);

(statearr_50059_52156[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50028 === (8))){
var inst_50008 = cljs.core.async.close_BANG_(to);
var state_50026__$1 = state_50026;
var statearr_50060_52157 = state_50026__$1;
(statearr_50060_52157[(2)] = inst_50008);

(statearr_50060_52157[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__49491__auto__ = null;
var cljs$core$async$state_machine__49491__auto____0 = (function (){
var statearr_50062 = [null,null,null,null,null,null,null,null];
(statearr_50062[(0)] = cljs$core$async$state_machine__49491__auto__);

(statearr_50062[(1)] = (1));

return statearr_50062;
});
var cljs$core$async$state_machine__49491__auto____1 = (function (state_50026){
while(true){
var ret_value__49492__auto__ = (function (){try{while(true){
var result__49493__auto__ = switch__49490__auto__(state_50026);
if(cljs.core.keyword_identical_QMARK_(result__49493__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__49493__auto__;
}
break;
}
}catch (e50063){var ex__49494__auto__ = e50063;
var statearr_50064_52158 = state_50026;
(statearr_50064_52158[(2)] = ex__49494__auto__);


if(cljs.core.seq((state_50026[(4)]))){
var statearr_50065_52159 = state_50026;
(statearr_50065_52159[(1)] = cljs.core.first((state_50026[(4)])));

} else {
throw ex__49494__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__49492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52163 = state_50026;
state_50026 = G__52163;
continue;
} else {
return ret_value__49492__auto__;
}
break;
}
});
cljs$core$async$state_machine__49491__auto__ = function(state_50026){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__49491__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__49491__auto____1.call(this,state_50026);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__49491__auto____0;
cljs$core$async$state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__49491__auto____1;
return cljs$core$async$state_machine__49491__auto__;
})()
})();
var state__49701__auto__ = (function (){var statearr_50066 = f__49700__auto__();
(statearr_50066[(6)] = c__49699__auto___52138);

return statearr_50066;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__49701__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process__$1 = (function (p__50068){
var vec__50069 = p__50068;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50069,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50069,(1),null);
var job = vec__50069;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__49699__auto___52168 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__49700__auto__ = (function (){var switch__49490__auto__ = (function (state_50076){
var state_val_50077 = (state_50076[(1)]);
if((state_val_50077 === (1))){
var state_50076__$1 = state_50076;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_50076__$1,(2),res,v);
} else {
if((state_val_50077 === (2))){
var inst_50073 = (state_50076[(2)]);
var inst_50074 = cljs.core.async.close_BANG_(res);
var state_50076__$1 = (function (){var statearr_50079 = state_50076;
(statearr_50079[(7)] = inst_50073);

return statearr_50079;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_50076__$1,inst_50074);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__49491__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__49491__auto____0 = (function (){
var statearr_50080 = [null,null,null,null,null,null,null,null];
(statearr_50080[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__49491__auto__);

(statearr_50080[(1)] = (1));

return statearr_50080;
});
var cljs$core$async$pipeline_STAR__$_state_machine__49491__auto____1 = (function (state_50076){
while(true){
var ret_value__49492__auto__ = (function (){try{while(true){
var result__49493__auto__ = switch__49490__auto__(state_50076);
if(cljs.core.keyword_identical_QMARK_(result__49493__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__49493__auto__;
}
break;
}
}catch (e50081){var ex__49494__auto__ = e50081;
var statearr_50082_52176 = state_50076;
(statearr_50082_52176[(2)] = ex__49494__auto__);


if(cljs.core.seq((state_50076[(4)]))){
var statearr_50083_52177 = state_50076;
(statearr_50083_52177[(1)] = cljs.core.first((state_50076[(4)])));

} else {
throw ex__49494__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__49492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52178 = state_50076;
state_50076 = G__52178;
continue;
} else {
return ret_value__49492__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__49491__auto__ = function(state_50076){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__49491__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__49491__auto____1.call(this,state_50076);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__49491__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__49491__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__49491__auto__;
})()
})();
var state__49701__auto__ = (function (){var statearr_50084 = f__49700__auto__();
(statearr_50084[(6)] = c__49699__auto___52168);

return statearr_50084;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__49701__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__50086){
var vec__50087 = p__50086;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50087,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50087,(1),null);
var job = vec__50087;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null, v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__5593__auto___52179 = n;
var __52180 = (0);
while(true){
if((__52180 < n__5593__auto___52179)){
var G__50090_52181 = type;
var G__50090_52182__$1 = (((G__50090_52181 instanceof cljs.core.Keyword))?G__50090_52181.fqn:null);
switch (G__50090_52182__$1) {
case "compute":
var c__49699__auto___52184 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__52180,c__49699__auto___52184,G__50090_52181,G__50090_52182__$1,n__5593__auto___52179,jobs,results,process__$1,async){
return (function (){
var f__49700__auto__ = (function (){var switch__49490__auto__ = ((function (__52180,c__49699__auto___52184,G__50090_52181,G__50090_52182__$1,n__5593__auto___52179,jobs,results,process__$1,async){
return (function (state_50104){
var state_val_50105 = (state_50104[(1)]);
if((state_val_50105 === (1))){
var state_50104__$1 = state_50104;
var statearr_50106_52185 = state_50104__$1;
(statearr_50106_52185[(2)] = null);

(statearr_50106_52185[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50105 === (2))){
var state_50104__$1 = state_50104;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50104__$1,(4),jobs);
} else {
if((state_val_50105 === (3))){
var inst_50102 = (state_50104[(2)]);
var state_50104__$1 = state_50104;
return cljs.core.async.impl.ioc_helpers.return_chan(state_50104__$1,inst_50102);
} else {
if((state_val_50105 === (4))){
var inst_50094 = (state_50104[(2)]);
var inst_50095 = process__$1(inst_50094);
var state_50104__$1 = state_50104;
if(cljs.core.truth_(inst_50095)){
var statearr_50107_52186 = state_50104__$1;
(statearr_50107_52186[(1)] = (5));

} else {
var statearr_50108_52187 = state_50104__$1;
(statearr_50108_52187[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50105 === (5))){
var state_50104__$1 = state_50104;
var statearr_50110_52188 = state_50104__$1;
(statearr_50110_52188[(2)] = null);

(statearr_50110_52188[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50105 === (6))){
var state_50104__$1 = state_50104;
var statearr_50111_52189 = state_50104__$1;
(statearr_50111_52189[(2)] = null);

(statearr_50111_52189[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50105 === (7))){
var inst_50100 = (state_50104[(2)]);
var state_50104__$1 = state_50104;
var statearr_50112_52194 = state_50104__$1;
(statearr_50112_52194[(2)] = inst_50100);

(statearr_50112_52194[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__52180,c__49699__auto___52184,G__50090_52181,G__50090_52182__$1,n__5593__auto___52179,jobs,results,process__$1,async))
;
return ((function (__52180,switch__49490__auto__,c__49699__auto___52184,G__50090_52181,G__50090_52182__$1,n__5593__auto___52179,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__49491__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__49491__auto____0 = (function (){
var statearr_50113 = [null,null,null,null,null,null,null];
(statearr_50113[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__49491__auto__);

(statearr_50113[(1)] = (1));

return statearr_50113;
});
var cljs$core$async$pipeline_STAR__$_state_machine__49491__auto____1 = (function (state_50104){
while(true){
var ret_value__49492__auto__ = (function (){try{while(true){
var result__49493__auto__ = switch__49490__auto__(state_50104);
if(cljs.core.keyword_identical_QMARK_(result__49493__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__49493__auto__;
}
break;
}
}catch (e50114){var ex__49494__auto__ = e50114;
var statearr_50115_52195 = state_50104;
(statearr_50115_52195[(2)] = ex__49494__auto__);


if(cljs.core.seq((state_50104[(4)]))){
var statearr_50116_52196 = state_50104;
(statearr_50116_52196[(1)] = cljs.core.first((state_50104[(4)])));

} else {
throw ex__49494__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__49492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52198 = state_50104;
state_50104 = G__52198;
continue;
} else {
return ret_value__49492__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__49491__auto__ = function(state_50104){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__49491__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__49491__auto____1.call(this,state_50104);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__49491__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__49491__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__49491__auto__;
})()
;})(__52180,switch__49490__auto__,c__49699__auto___52184,G__50090_52181,G__50090_52182__$1,n__5593__auto___52179,jobs,results,process__$1,async))
})();
var state__49701__auto__ = (function (){var statearr_50118 = f__49700__auto__();
(statearr_50118[(6)] = c__49699__auto___52184);

return statearr_50118;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__49701__auto__);
});})(__52180,c__49699__auto___52184,G__50090_52181,G__50090_52182__$1,n__5593__auto___52179,jobs,results,process__$1,async))
);


break;
case "async":
var c__49699__auto___52199 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__52180,c__49699__auto___52199,G__50090_52181,G__50090_52182__$1,n__5593__auto___52179,jobs,results,process__$1,async){
return (function (){
var f__49700__auto__ = (function (){var switch__49490__auto__ = ((function (__52180,c__49699__auto___52199,G__50090_52181,G__50090_52182__$1,n__5593__auto___52179,jobs,results,process__$1,async){
return (function (state_50131){
var state_val_50132 = (state_50131[(1)]);
if((state_val_50132 === (1))){
var state_50131__$1 = state_50131;
var statearr_50133_52200 = state_50131__$1;
(statearr_50133_52200[(2)] = null);

(statearr_50133_52200[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50132 === (2))){
var state_50131__$1 = state_50131;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50131__$1,(4),jobs);
} else {
if((state_val_50132 === (3))){
var inst_50129 = (state_50131[(2)]);
var state_50131__$1 = state_50131;
return cljs.core.async.impl.ioc_helpers.return_chan(state_50131__$1,inst_50129);
} else {
if((state_val_50132 === (4))){
var inst_50121 = (state_50131[(2)]);
var inst_50122 = async(inst_50121);
var state_50131__$1 = state_50131;
if(cljs.core.truth_(inst_50122)){
var statearr_50135_52201 = state_50131__$1;
(statearr_50135_52201[(1)] = (5));

} else {
var statearr_50136_52202 = state_50131__$1;
(statearr_50136_52202[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50132 === (5))){
var state_50131__$1 = state_50131;
var statearr_50137_52203 = state_50131__$1;
(statearr_50137_52203[(2)] = null);

(statearr_50137_52203[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50132 === (6))){
var state_50131__$1 = state_50131;
var statearr_50138_52207 = state_50131__$1;
(statearr_50138_52207[(2)] = null);

(statearr_50138_52207[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50132 === (7))){
var inst_50127 = (state_50131[(2)]);
var state_50131__$1 = state_50131;
var statearr_50139_52208 = state_50131__$1;
(statearr_50139_52208[(2)] = inst_50127);

(statearr_50139_52208[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__52180,c__49699__auto___52199,G__50090_52181,G__50090_52182__$1,n__5593__auto___52179,jobs,results,process__$1,async))
;
return ((function (__52180,switch__49490__auto__,c__49699__auto___52199,G__50090_52181,G__50090_52182__$1,n__5593__auto___52179,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__49491__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__49491__auto____0 = (function (){
var statearr_50140 = [null,null,null,null,null,null,null];
(statearr_50140[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__49491__auto__);

(statearr_50140[(1)] = (1));

return statearr_50140;
});
var cljs$core$async$pipeline_STAR__$_state_machine__49491__auto____1 = (function (state_50131){
while(true){
var ret_value__49492__auto__ = (function (){try{while(true){
var result__49493__auto__ = switch__49490__auto__(state_50131);
if(cljs.core.keyword_identical_QMARK_(result__49493__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__49493__auto__;
}
break;
}
}catch (e50142){var ex__49494__auto__ = e50142;
var statearr_50143_52209 = state_50131;
(statearr_50143_52209[(2)] = ex__49494__auto__);


if(cljs.core.seq((state_50131[(4)]))){
var statearr_50144_52213 = state_50131;
(statearr_50144_52213[(1)] = cljs.core.first((state_50131[(4)])));

} else {
throw ex__49494__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__49492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52214 = state_50131;
state_50131 = G__52214;
continue;
} else {
return ret_value__49492__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__49491__auto__ = function(state_50131){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__49491__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__49491__auto____1.call(this,state_50131);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__49491__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__49491__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__49491__auto__;
})()
;})(__52180,switch__49490__auto__,c__49699__auto___52199,G__50090_52181,G__50090_52182__$1,n__5593__auto___52179,jobs,results,process__$1,async))
})();
var state__49701__auto__ = (function (){var statearr_50145 = f__49700__auto__();
(statearr_50145[(6)] = c__49699__auto___52199);

return statearr_50145;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__49701__auto__);
});})(__52180,c__49699__auto___52199,G__50090_52181,G__50090_52182__$1,n__5593__auto___52179,jobs,results,process__$1,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__50090_52182__$1)].join('')));

}

var G__52215 = (__52180 + (1));
__52180 = G__52215;
continue;
} else {
}
break;
}

var c__49699__auto___52216 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__49700__auto__ = (function (){var switch__49490__auto__ = (function (state_50168){
var state_val_50169 = (state_50168[(1)]);
if((state_val_50169 === (7))){
var inst_50164 = (state_50168[(2)]);
var state_50168__$1 = state_50168;
var statearr_50170_52217 = state_50168__$1;
(statearr_50170_52217[(2)] = inst_50164);

(statearr_50170_52217[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50169 === (1))){
var state_50168__$1 = state_50168;
var statearr_50171_52218 = state_50168__$1;
(statearr_50171_52218[(2)] = null);

(statearr_50171_52218[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50169 === (4))){
var inst_50148 = (state_50168[(7)]);
var inst_50148__$1 = (state_50168[(2)]);
var inst_50149 = (inst_50148__$1 == null);
var state_50168__$1 = (function (){var statearr_50173 = state_50168;
(statearr_50173[(7)] = inst_50148__$1);

return statearr_50173;
})();
if(cljs.core.truth_(inst_50149)){
var statearr_50174_52222 = state_50168__$1;
(statearr_50174_52222[(1)] = (5));

} else {
var statearr_50175_52223 = state_50168__$1;
(statearr_50175_52223[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50169 === (6))){
var inst_50148 = (state_50168[(7)]);
var inst_50153 = (state_50168[(8)]);
var inst_50153__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_50155 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_50156 = [inst_50148,inst_50153__$1];
var inst_50157 = (new cljs.core.PersistentVector(null,2,(5),inst_50155,inst_50156,null));
var state_50168__$1 = (function (){var statearr_50176 = state_50168;
(statearr_50176[(8)] = inst_50153__$1);

return statearr_50176;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_50168__$1,(8),jobs,inst_50157);
} else {
if((state_val_50169 === (3))){
var inst_50166 = (state_50168[(2)]);
var state_50168__$1 = state_50168;
return cljs.core.async.impl.ioc_helpers.return_chan(state_50168__$1,inst_50166);
} else {
if((state_val_50169 === (2))){
var state_50168__$1 = state_50168;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50168__$1,(4),from);
} else {
if((state_val_50169 === (9))){
var inst_50161 = (state_50168[(2)]);
var state_50168__$1 = (function (){var statearr_50178 = state_50168;
(statearr_50178[(9)] = inst_50161);

return statearr_50178;
})();
var statearr_50179_52224 = state_50168__$1;
(statearr_50179_52224[(2)] = null);

(statearr_50179_52224[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50169 === (5))){
var inst_50151 = cljs.core.async.close_BANG_(jobs);
var state_50168__$1 = state_50168;
var statearr_50180_52225 = state_50168__$1;
(statearr_50180_52225[(2)] = inst_50151);

(statearr_50180_52225[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50169 === (8))){
var inst_50153 = (state_50168[(8)]);
var inst_50159 = (state_50168[(2)]);
var state_50168__$1 = (function (){var statearr_50181 = state_50168;
(statearr_50181[(10)] = inst_50159);

return statearr_50181;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_50168__$1,(9),results,inst_50153);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__49491__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__49491__auto____0 = (function (){
var statearr_50182 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_50182[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__49491__auto__);

(statearr_50182[(1)] = (1));

return statearr_50182;
});
var cljs$core$async$pipeline_STAR__$_state_machine__49491__auto____1 = (function (state_50168){
while(true){
var ret_value__49492__auto__ = (function (){try{while(true){
var result__49493__auto__ = switch__49490__auto__(state_50168);
if(cljs.core.keyword_identical_QMARK_(result__49493__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__49493__auto__;
}
break;
}
}catch (e50183){var ex__49494__auto__ = e50183;
var statearr_50184_52226 = state_50168;
(statearr_50184_52226[(2)] = ex__49494__auto__);


if(cljs.core.seq((state_50168[(4)]))){
var statearr_50185_52227 = state_50168;
(statearr_50185_52227[(1)] = cljs.core.first((state_50168[(4)])));

} else {
throw ex__49494__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__49492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52231 = state_50168;
state_50168 = G__52231;
continue;
} else {
return ret_value__49492__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__49491__auto__ = function(state_50168){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__49491__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__49491__auto____1.call(this,state_50168);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__49491__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__49491__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__49491__auto__;
})()
})();
var state__49701__auto__ = (function (){var statearr_50187 = f__49700__auto__();
(statearr_50187[(6)] = c__49699__auto___52216);

return statearr_50187;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__49701__auto__);
}));


var c__49699__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__49700__auto__ = (function (){var switch__49490__auto__ = (function (state_50225){
var state_val_50226 = (state_50225[(1)]);
if((state_val_50226 === (7))){
var inst_50221 = (state_50225[(2)]);
var state_50225__$1 = state_50225;
var statearr_50228_52232 = state_50225__$1;
(statearr_50228_52232[(2)] = inst_50221);

(statearr_50228_52232[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50226 === (20))){
var state_50225__$1 = state_50225;
var statearr_50229_52233 = state_50225__$1;
(statearr_50229_52233[(2)] = null);

(statearr_50229_52233[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50226 === (1))){
var state_50225__$1 = state_50225;
var statearr_50230_52234 = state_50225__$1;
(statearr_50230_52234[(2)] = null);

(statearr_50230_52234[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50226 === (4))){
var inst_50190 = (state_50225[(7)]);
var inst_50190__$1 = (state_50225[(2)]);
var inst_50191 = (inst_50190__$1 == null);
var state_50225__$1 = (function (){var statearr_50231 = state_50225;
(statearr_50231[(7)] = inst_50190__$1);

return statearr_50231;
})();
if(cljs.core.truth_(inst_50191)){
var statearr_50232_52235 = state_50225__$1;
(statearr_50232_52235[(1)] = (5));

} else {
var statearr_50233_52236 = state_50225__$1;
(statearr_50233_52236[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50226 === (15))){
var inst_50203 = (state_50225[(8)]);
var state_50225__$1 = state_50225;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_50225__$1,(18),to,inst_50203);
} else {
if((state_val_50226 === (21))){
var inst_50216 = (state_50225[(2)]);
var state_50225__$1 = state_50225;
var statearr_50235_52237 = state_50225__$1;
(statearr_50235_52237[(2)] = inst_50216);

(statearr_50235_52237[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50226 === (13))){
var inst_50218 = (state_50225[(2)]);
var state_50225__$1 = (function (){var statearr_50236 = state_50225;
(statearr_50236[(9)] = inst_50218);

return statearr_50236;
})();
var statearr_50237_52238 = state_50225__$1;
(statearr_50237_52238[(2)] = null);

(statearr_50237_52238[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50226 === (6))){
var inst_50190 = (state_50225[(7)]);
var state_50225__$1 = state_50225;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50225__$1,(11),inst_50190);
} else {
if((state_val_50226 === (17))){
var inst_50211 = (state_50225[(2)]);
var state_50225__$1 = state_50225;
if(cljs.core.truth_(inst_50211)){
var statearr_50238_52240 = state_50225__$1;
(statearr_50238_52240[(1)] = (19));

} else {
var statearr_50239_52241 = state_50225__$1;
(statearr_50239_52241[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50226 === (3))){
var inst_50223 = (state_50225[(2)]);
var state_50225__$1 = state_50225;
return cljs.core.async.impl.ioc_helpers.return_chan(state_50225__$1,inst_50223);
} else {
if((state_val_50226 === (12))){
var inst_50200 = (state_50225[(10)]);
var state_50225__$1 = state_50225;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50225__$1,(14),inst_50200);
} else {
if((state_val_50226 === (2))){
var state_50225__$1 = state_50225;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50225__$1,(4),results);
} else {
if((state_val_50226 === (19))){
var state_50225__$1 = state_50225;
var statearr_50241_52244 = state_50225__$1;
(statearr_50241_52244[(2)] = null);

(statearr_50241_52244[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50226 === (11))){
var inst_50200 = (state_50225[(2)]);
var state_50225__$1 = (function (){var statearr_50242 = state_50225;
(statearr_50242[(10)] = inst_50200);

return statearr_50242;
})();
var statearr_50243_52245 = state_50225__$1;
(statearr_50243_52245[(2)] = null);

(statearr_50243_52245[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50226 === (9))){
var state_50225__$1 = state_50225;
var statearr_50244_52246 = state_50225__$1;
(statearr_50244_52246[(2)] = null);

(statearr_50244_52246[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50226 === (5))){
var state_50225__$1 = state_50225;
if(cljs.core.truth_(close_QMARK_)){
var statearr_50245_52247 = state_50225__$1;
(statearr_50245_52247[(1)] = (8));

} else {
var statearr_50246_52248 = state_50225__$1;
(statearr_50246_52248[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50226 === (14))){
var inst_50203 = (state_50225[(8)]);
var inst_50205 = (state_50225[(11)]);
var inst_50203__$1 = (state_50225[(2)]);
var inst_50204 = (inst_50203__$1 == null);
var inst_50205__$1 = cljs.core.not(inst_50204);
var state_50225__$1 = (function (){var statearr_50247 = state_50225;
(statearr_50247[(8)] = inst_50203__$1);

(statearr_50247[(11)] = inst_50205__$1);

return statearr_50247;
})();
if(inst_50205__$1){
var statearr_50249_52249 = state_50225__$1;
(statearr_50249_52249[(1)] = (15));

} else {
var statearr_50250_52250 = state_50225__$1;
(statearr_50250_52250[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50226 === (16))){
var inst_50205 = (state_50225[(11)]);
var state_50225__$1 = state_50225;
var statearr_50251_52251 = state_50225__$1;
(statearr_50251_52251[(2)] = inst_50205);

(statearr_50251_52251[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50226 === (10))){
var inst_50197 = (state_50225[(2)]);
var state_50225__$1 = state_50225;
var statearr_50252_52252 = state_50225__$1;
(statearr_50252_52252[(2)] = inst_50197);

(statearr_50252_52252[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50226 === (18))){
var inst_50208 = (state_50225[(2)]);
var state_50225__$1 = state_50225;
var statearr_50253_52255 = state_50225__$1;
(statearr_50253_52255[(2)] = inst_50208);

(statearr_50253_52255[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50226 === (8))){
var inst_50194 = cljs.core.async.close_BANG_(to);
var state_50225__$1 = state_50225;
var statearr_50254_52256 = state_50225__$1;
(statearr_50254_52256[(2)] = inst_50194);

(statearr_50254_52256[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__49491__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__49491__auto____0 = (function (){
var statearr_50256 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_50256[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__49491__auto__);

(statearr_50256[(1)] = (1));

return statearr_50256;
});
var cljs$core$async$pipeline_STAR__$_state_machine__49491__auto____1 = (function (state_50225){
while(true){
var ret_value__49492__auto__ = (function (){try{while(true){
var result__49493__auto__ = switch__49490__auto__(state_50225);
if(cljs.core.keyword_identical_QMARK_(result__49493__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__49493__auto__;
}
break;
}
}catch (e50257){var ex__49494__auto__ = e50257;
var statearr_50258_52259 = state_50225;
(statearr_50258_52259[(2)] = ex__49494__auto__);


if(cljs.core.seq((state_50225[(4)]))){
var statearr_50259_52260 = state_50225;
(statearr_50259_52260[(1)] = cljs.core.first((state_50225[(4)])));

} else {
throw ex__49494__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__49492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52261 = state_50225;
state_50225 = G__52261;
continue;
} else {
return ret_value__49492__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__49491__auto__ = function(state_50225){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__49491__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__49491__auto____1.call(this,state_50225);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__49491__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__49491__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__49491__auto__;
})()
})();
var state__49701__auto__ = (function (){var statearr_50260 = f__49700__auto__();
(statearr_50260[(6)] = c__49699__auto__);

return statearr_50260;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__49701__auto__);
}));

return c__49699__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__50263 = arguments.length;
switch (G__50263) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__50266 = arguments.length;
switch (G__50266) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__50269 = arguments.length;
switch (G__50269) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__49699__auto___52276 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__49700__auto__ = (function (){var switch__49490__auto__ = (function (state_50296){
var state_val_50297 = (state_50296[(1)]);
if((state_val_50297 === (7))){
var inst_50292 = (state_50296[(2)]);
var state_50296__$1 = state_50296;
var statearr_50300_52277 = state_50296__$1;
(statearr_50300_52277[(2)] = inst_50292);

(statearr_50300_52277[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50297 === (1))){
var state_50296__$1 = state_50296;
var statearr_50301_52278 = state_50296__$1;
(statearr_50301_52278[(2)] = null);

(statearr_50301_52278[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50297 === (4))){
var inst_50273 = (state_50296[(7)]);
var inst_50273__$1 = (state_50296[(2)]);
var inst_50274 = (inst_50273__$1 == null);
var state_50296__$1 = (function (){var statearr_50302 = state_50296;
(statearr_50302[(7)] = inst_50273__$1);

return statearr_50302;
})();
if(cljs.core.truth_(inst_50274)){
var statearr_50303_52286 = state_50296__$1;
(statearr_50303_52286[(1)] = (5));

} else {
var statearr_50304_52287 = state_50296__$1;
(statearr_50304_52287[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50297 === (13))){
var state_50296__$1 = state_50296;
var statearr_50305_52288 = state_50296__$1;
(statearr_50305_52288[(2)] = null);

(statearr_50305_52288[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50297 === (6))){
var inst_50273 = (state_50296[(7)]);
var inst_50279 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_50273) : p.call(null, inst_50273));
var state_50296__$1 = state_50296;
if(cljs.core.truth_(inst_50279)){
var statearr_50306_52289 = state_50296__$1;
(statearr_50306_52289[(1)] = (9));

} else {
var statearr_50307_52290 = state_50296__$1;
(statearr_50307_52290[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50297 === (3))){
var inst_50294 = (state_50296[(2)]);
var state_50296__$1 = state_50296;
return cljs.core.async.impl.ioc_helpers.return_chan(state_50296__$1,inst_50294);
} else {
if((state_val_50297 === (12))){
var state_50296__$1 = state_50296;
var statearr_50308_52291 = state_50296__$1;
(statearr_50308_52291[(2)] = null);

(statearr_50308_52291[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50297 === (2))){
var state_50296__$1 = state_50296;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50296__$1,(4),ch);
} else {
if((state_val_50297 === (11))){
var inst_50273 = (state_50296[(7)]);
var inst_50283 = (state_50296[(2)]);
var state_50296__$1 = state_50296;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_50296__$1,(8),inst_50283,inst_50273);
} else {
if((state_val_50297 === (9))){
var state_50296__$1 = state_50296;
var statearr_50311_52295 = state_50296__$1;
(statearr_50311_52295[(2)] = tc);

(statearr_50311_52295[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50297 === (5))){
var inst_50276 = cljs.core.async.close_BANG_(tc);
var inst_50277 = cljs.core.async.close_BANG_(fc);
var state_50296__$1 = (function (){var statearr_50312 = state_50296;
(statearr_50312[(8)] = inst_50276);

return statearr_50312;
})();
var statearr_50313_52296 = state_50296__$1;
(statearr_50313_52296[(2)] = inst_50277);

(statearr_50313_52296[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50297 === (14))){
var inst_50290 = (state_50296[(2)]);
var state_50296__$1 = state_50296;
var statearr_50314_52297 = state_50296__$1;
(statearr_50314_52297[(2)] = inst_50290);

(statearr_50314_52297[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50297 === (10))){
var state_50296__$1 = state_50296;
var statearr_50315_52298 = state_50296__$1;
(statearr_50315_52298[(2)] = fc);

(statearr_50315_52298[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50297 === (8))){
var inst_50285 = (state_50296[(2)]);
var state_50296__$1 = state_50296;
if(cljs.core.truth_(inst_50285)){
var statearr_50316_52299 = state_50296__$1;
(statearr_50316_52299[(1)] = (12));

} else {
var statearr_50317_52300 = state_50296__$1;
(statearr_50317_52300[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__49491__auto__ = null;
var cljs$core$async$state_machine__49491__auto____0 = (function (){
var statearr_50318 = [null,null,null,null,null,null,null,null,null];
(statearr_50318[(0)] = cljs$core$async$state_machine__49491__auto__);

(statearr_50318[(1)] = (1));

return statearr_50318;
});
var cljs$core$async$state_machine__49491__auto____1 = (function (state_50296){
while(true){
var ret_value__49492__auto__ = (function (){try{while(true){
var result__49493__auto__ = switch__49490__auto__(state_50296);
if(cljs.core.keyword_identical_QMARK_(result__49493__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__49493__auto__;
}
break;
}
}catch (e50319){var ex__49494__auto__ = e50319;
var statearr_50320_52304 = state_50296;
(statearr_50320_52304[(2)] = ex__49494__auto__);


if(cljs.core.seq((state_50296[(4)]))){
var statearr_50321_52305 = state_50296;
(statearr_50321_52305[(1)] = cljs.core.first((state_50296[(4)])));

} else {
throw ex__49494__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__49492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52306 = state_50296;
state_50296 = G__52306;
continue;
} else {
return ret_value__49492__auto__;
}
break;
}
});
cljs$core$async$state_machine__49491__auto__ = function(state_50296){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__49491__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__49491__auto____1.call(this,state_50296);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__49491__auto____0;
cljs$core$async$state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__49491__auto____1;
return cljs$core$async$state_machine__49491__auto__;
})()
})();
var state__49701__auto__ = (function (){var statearr_50322 = f__49700__auto__();
(statearr_50322[(6)] = c__49699__auto___52276);

return statearr_50322;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__49701__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__49699__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__49700__auto__ = (function (){var switch__49490__auto__ = (function (state_50346){
var state_val_50347 = (state_50346[(1)]);
if((state_val_50347 === (7))){
var inst_50342 = (state_50346[(2)]);
var state_50346__$1 = state_50346;
var statearr_50348_52307 = state_50346__$1;
(statearr_50348_52307[(2)] = inst_50342);

(statearr_50348_52307[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50347 === (1))){
var inst_50323 = init;
var inst_50324 = inst_50323;
var state_50346__$1 = (function (){var statearr_50349 = state_50346;
(statearr_50349[(7)] = inst_50324);

return statearr_50349;
})();
var statearr_50350_52308 = state_50346__$1;
(statearr_50350_52308[(2)] = null);

(statearr_50350_52308[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50347 === (4))){
var inst_50328 = (state_50346[(8)]);
var inst_50328__$1 = (state_50346[(2)]);
var inst_50329 = (inst_50328__$1 == null);
var state_50346__$1 = (function (){var statearr_50351 = state_50346;
(statearr_50351[(8)] = inst_50328__$1);

return statearr_50351;
})();
if(cljs.core.truth_(inst_50329)){
var statearr_50352_52309 = state_50346__$1;
(statearr_50352_52309[(1)] = (5));

} else {
var statearr_50353_52310 = state_50346__$1;
(statearr_50353_52310[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50347 === (6))){
var inst_50324 = (state_50346[(7)]);
var inst_50328 = (state_50346[(8)]);
var inst_50333 = (state_50346[(9)]);
var inst_50333__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_50324,inst_50328) : f.call(null, inst_50324,inst_50328));
var inst_50334 = cljs.core.reduced_QMARK_(inst_50333__$1);
var state_50346__$1 = (function (){var statearr_50354 = state_50346;
(statearr_50354[(9)] = inst_50333__$1);

return statearr_50354;
})();
if(inst_50334){
var statearr_50355_52315 = state_50346__$1;
(statearr_50355_52315[(1)] = (8));

} else {
var statearr_50356_52316 = state_50346__$1;
(statearr_50356_52316[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50347 === (3))){
var inst_50344 = (state_50346[(2)]);
var state_50346__$1 = state_50346;
return cljs.core.async.impl.ioc_helpers.return_chan(state_50346__$1,inst_50344);
} else {
if((state_val_50347 === (2))){
var state_50346__$1 = state_50346;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50346__$1,(4),ch);
} else {
if((state_val_50347 === (9))){
var inst_50333 = (state_50346[(9)]);
var inst_50324 = inst_50333;
var state_50346__$1 = (function (){var statearr_50357 = state_50346;
(statearr_50357[(7)] = inst_50324);

return statearr_50357;
})();
var statearr_50358_52319 = state_50346__$1;
(statearr_50358_52319[(2)] = null);

(statearr_50358_52319[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50347 === (5))){
var inst_50324 = (state_50346[(7)]);
var state_50346__$1 = state_50346;
var statearr_50359_52320 = state_50346__$1;
(statearr_50359_52320[(2)] = inst_50324);

(statearr_50359_52320[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50347 === (10))){
var inst_50340 = (state_50346[(2)]);
var state_50346__$1 = state_50346;
var statearr_50360_52321 = state_50346__$1;
(statearr_50360_52321[(2)] = inst_50340);

(statearr_50360_52321[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50347 === (8))){
var inst_50333 = (state_50346[(9)]);
var inst_50336 = cljs.core.deref(inst_50333);
var state_50346__$1 = state_50346;
var statearr_50361_52322 = state_50346__$1;
(statearr_50361_52322[(2)] = inst_50336);

(statearr_50361_52322[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__49491__auto__ = null;
var cljs$core$async$reduce_$_state_machine__49491__auto____0 = (function (){
var statearr_50362 = [null,null,null,null,null,null,null,null,null,null];
(statearr_50362[(0)] = cljs$core$async$reduce_$_state_machine__49491__auto__);

(statearr_50362[(1)] = (1));

return statearr_50362;
});
var cljs$core$async$reduce_$_state_machine__49491__auto____1 = (function (state_50346){
while(true){
var ret_value__49492__auto__ = (function (){try{while(true){
var result__49493__auto__ = switch__49490__auto__(state_50346);
if(cljs.core.keyword_identical_QMARK_(result__49493__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__49493__auto__;
}
break;
}
}catch (e50363){var ex__49494__auto__ = e50363;
var statearr_50364_52324 = state_50346;
(statearr_50364_52324[(2)] = ex__49494__auto__);


if(cljs.core.seq((state_50346[(4)]))){
var statearr_50366_52329 = state_50346;
(statearr_50366_52329[(1)] = cljs.core.first((state_50346[(4)])));

} else {
throw ex__49494__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__49492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52330 = state_50346;
state_50346 = G__52330;
continue;
} else {
return ret_value__49492__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__49491__auto__ = function(state_50346){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__49491__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__49491__auto____1.call(this,state_50346);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__49491__auto____0;
cljs$core$async$reduce_$_state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__49491__auto____1;
return cljs$core$async$reduce_$_state_machine__49491__auto__;
})()
})();
var state__49701__auto__ = (function (){var statearr_50369 = f__49700__auto__();
(statearr_50369[(6)] = c__49699__auto__);

return statearr_50369;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__49701__auto__);
}));

return c__49699__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null, f));
var c__49699__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__49700__auto__ = (function (){var switch__49490__auto__ = (function (state_50381){
var state_val_50382 = (state_50381[(1)]);
if((state_val_50382 === (1))){
var inst_50373 = cljs.core.async.reduce(f__$1,init,ch);
var state_50381__$1 = state_50381;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50381__$1,(2),inst_50373);
} else {
if((state_val_50382 === (2))){
var inst_50375 = (state_50381[(2)]);
var inst_50376 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_50375) : f__$1.call(null, inst_50375));
var state_50381__$1 = state_50381;
return cljs.core.async.impl.ioc_helpers.return_chan(state_50381__$1,inst_50376);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__49491__auto__ = null;
var cljs$core$async$transduce_$_state_machine__49491__auto____0 = (function (){
var statearr_50383 = [null,null,null,null,null,null,null];
(statearr_50383[(0)] = cljs$core$async$transduce_$_state_machine__49491__auto__);

(statearr_50383[(1)] = (1));

return statearr_50383;
});
var cljs$core$async$transduce_$_state_machine__49491__auto____1 = (function (state_50381){
while(true){
var ret_value__49492__auto__ = (function (){try{while(true){
var result__49493__auto__ = switch__49490__auto__(state_50381);
if(cljs.core.keyword_identical_QMARK_(result__49493__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__49493__auto__;
}
break;
}
}catch (e50385){var ex__49494__auto__ = e50385;
var statearr_50386_52333 = state_50381;
(statearr_50386_52333[(2)] = ex__49494__auto__);


if(cljs.core.seq((state_50381[(4)]))){
var statearr_50387_52334 = state_50381;
(statearr_50387_52334[(1)] = cljs.core.first((state_50381[(4)])));

} else {
throw ex__49494__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__49492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52337 = state_50381;
state_50381 = G__52337;
continue;
} else {
return ret_value__49492__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__49491__auto__ = function(state_50381){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__49491__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__49491__auto____1.call(this,state_50381);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__49491__auto____0;
cljs$core$async$transduce_$_state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__49491__auto____1;
return cljs$core$async$transduce_$_state_machine__49491__auto__;
})()
})();
var state__49701__auto__ = (function (){var statearr_50391 = f__49700__auto__();
(statearr_50391[(6)] = c__49699__auto__);

return statearr_50391;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__49701__auto__);
}));

return c__49699__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__50397 = arguments.length;
switch (G__50397) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__49699__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__49700__auto__ = (function (){var switch__49490__auto__ = (function (state_50429){
var state_val_50430 = (state_50429[(1)]);
if((state_val_50430 === (7))){
var inst_50409 = (state_50429[(2)]);
var state_50429__$1 = state_50429;
var statearr_50433_52341 = state_50429__$1;
(statearr_50433_52341[(2)] = inst_50409);

(statearr_50433_52341[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50430 === (1))){
var inst_50402 = cljs.core.seq(coll);
var inst_50403 = inst_50402;
var state_50429__$1 = (function (){var statearr_50437 = state_50429;
(statearr_50437[(7)] = inst_50403);

return statearr_50437;
})();
var statearr_50438_52342 = state_50429__$1;
(statearr_50438_52342[(2)] = null);

(statearr_50438_52342[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50430 === (4))){
var inst_50403 = (state_50429[(7)]);
var inst_50406 = cljs.core.first(inst_50403);
var state_50429__$1 = state_50429;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_50429__$1,(7),ch,inst_50406);
} else {
if((state_val_50430 === (13))){
var inst_50421 = (state_50429[(2)]);
var state_50429__$1 = state_50429;
var statearr_50440_52349 = state_50429__$1;
(statearr_50440_52349[(2)] = inst_50421);

(statearr_50440_52349[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50430 === (6))){
var inst_50412 = (state_50429[(2)]);
var state_50429__$1 = state_50429;
if(cljs.core.truth_(inst_50412)){
var statearr_50444_52354 = state_50429__$1;
(statearr_50444_52354[(1)] = (8));

} else {
var statearr_50445_52355 = state_50429__$1;
(statearr_50445_52355[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50430 === (3))){
var inst_50425 = (state_50429[(2)]);
var state_50429__$1 = state_50429;
return cljs.core.async.impl.ioc_helpers.return_chan(state_50429__$1,inst_50425);
} else {
if((state_val_50430 === (12))){
var state_50429__$1 = state_50429;
var statearr_50447_52356 = state_50429__$1;
(statearr_50447_52356[(2)] = null);

(statearr_50447_52356[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50430 === (2))){
var inst_50403 = (state_50429[(7)]);
var state_50429__$1 = state_50429;
if(cljs.core.truth_(inst_50403)){
var statearr_50451_52358 = state_50429__$1;
(statearr_50451_52358[(1)] = (4));

} else {
var statearr_50452_52359 = state_50429__$1;
(statearr_50452_52359[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50430 === (11))){
var inst_50418 = cljs.core.async.close_BANG_(ch);
var state_50429__$1 = state_50429;
var statearr_50453_52364 = state_50429__$1;
(statearr_50453_52364[(2)] = inst_50418);

(statearr_50453_52364[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50430 === (9))){
var state_50429__$1 = state_50429;
if(cljs.core.truth_(close_QMARK_)){
var statearr_50455_52365 = state_50429__$1;
(statearr_50455_52365[(1)] = (11));

} else {
var statearr_50456_52366 = state_50429__$1;
(statearr_50456_52366[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50430 === (5))){
var inst_50403 = (state_50429[(7)]);
var state_50429__$1 = state_50429;
var statearr_50460_52367 = state_50429__$1;
(statearr_50460_52367[(2)] = inst_50403);

(statearr_50460_52367[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50430 === (10))){
var inst_50423 = (state_50429[(2)]);
var state_50429__$1 = state_50429;
var statearr_50461_52368 = state_50429__$1;
(statearr_50461_52368[(2)] = inst_50423);

(statearr_50461_52368[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50430 === (8))){
var inst_50403 = (state_50429[(7)]);
var inst_50414 = cljs.core.next(inst_50403);
var inst_50403__$1 = inst_50414;
var state_50429__$1 = (function (){var statearr_50463 = state_50429;
(statearr_50463[(7)] = inst_50403__$1);

return statearr_50463;
})();
var statearr_50464_52373 = state_50429__$1;
(statearr_50464_52373[(2)] = null);

(statearr_50464_52373[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__49491__auto__ = null;
var cljs$core$async$state_machine__49491__auto____0 = (function (){
var statearr_50468 = [null,null,null,null,null,null,null,null];
(statearr_50468[(0)] = cljs$core$async$state_machine__49491__auto__);

(statearr_50468[(1)] = (1));

return statearr_50468;
});
var cljs$core$async$state_machine__49491__auto____1 = (function (state_50429){
while(true){
var ret_value__49492__auto__ = (function (){try{while(true){
var result__49493__auto__ = switch__49490__auto__(state_50429);
if(cljs.core.keyword_identical_QMARK_(result__49493__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__49493__auto__;
}
break;
}
}catch (e50470){var ex__49494__auto__ = e50470;
var statearr_50471_52376 = state_50429;
(statearr_50471_52376[(2)] = ex__49494__auto__);


if(cljs.core.seq((state_50429[(4)]))){
var statearr_50474_52377 = state_50429;
(statearr_50474_52377[(1)] = cljs.core.first((state_50429[(4)])));

} else {
throw ex__49494__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__49492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52382 = state_50429;
state_50429 = G__52382;
continue;
} else {
return ret_value__49492__auto__;
}
break;
}
});
cljs$core$async$state_machine__49491__auto__ = function(state_50429){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__49491__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__49491__auto____1.call(this,state_50429);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__49491__auto____0;
cljs$core$async$state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__49491__auto____1;
return cljs$core$async$state_machine__49491__auto__;
})()
})();
var state__49701__auto__ = (function (){var statearr_50476 = f__49700__auto__();
(statearr_50476[(6)] = c__49699__auto__);

return statearr_50476;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__49701__auto__);
}));

return c__49699__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__50483 = arguments.length;
switch (G__50483) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_52391 = (function (_){
var x__5350__auto__ = (((_ == null))?null:_);
var m__5351__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5351__auto__.call(null, _));
} else {
var m__5349__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5349__auto__.call(null, _));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_52391(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_52397 = (function (m,ch,close_QMARK_){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5351__auto__.call(null, m,ch,close_QMARK_));
} else {
var m__5349__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5349__auto__.call(null, m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_52397(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_52399 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null, m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null, m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_52399(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_52401 = (function (m){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5351__auto__.call(null, m));
} else {
var m__5349__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5349__auto__.call(null, m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_52401(m);
}
});


/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async50523 = (function (ch,cs,meta50524){
this.ch = ch;
this.cs = cs;
this.meta50524 = meta50524;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async50523.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_50525,meta50524__$1){
var self__ = this;
var _50525__$1 = this;
return (new cljs.core.async.t_cljs$core$async50523(self__.ch,self__.cs,meta50524__$1));
}));

(cljs.core.async.t_cljs$core$async50523.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_50525){
var self__ = this;
var _50525__$1 = this;
return self__.meta50524;
}));

(cljs.core.async.t_cljs$core$async50523.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async50523.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async50523.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async50523.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async50523.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async50523.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async50523.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta50524","meta50524",-1365476221,null)], null);
}));

(cljs.core.async.t_cljs$core$async50523.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async50523.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async50523");

(cljs.core.async.t_cljs$core$async50523.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async50523");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async50523.
 */
cljs.core.async.__GT_t_cljs$core$async50523 = (function cljs$core$async$__GT_t_cljs$core$async50523(ch,cs,meta50524){
return (new cljs.core.async.t_cljs$core$async50523(ch,cs,meta50524));
});


/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (new cljs.core.async.t_cljs$core$async50523(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__49699__auto___52408 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__49700__auto__ = (function (){var switch__49490__auto__ = (function (state_50692){
var state_val_50693 = (state_50692[(1)]);
if((state_val_50693 === (7))){
var inst_50687 = (state_50692[(2)]);
var state_50692__$1 = state_50692;
var statearr_50700_52411 = state_50692__$1;
(statearr_50700_52411[(2)] = inst_50687);

(statearr_50700_52411[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (20))){
var inst_50580 = (state_50692[(7)]);
var inst_50595 = cljs.core.first(inst_50580);
var inst_50597 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_50595,(0),null);
var inst_50598 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_50595,(1),null);
var state_50692__$1 = (function (){var statearr_50703 = state_50692;
(statearr_50703[(8)] = inst_50597);

return statearr_50703;
})();
if(cljs.core.truth_(inst_50598)){
var statearr_50705_52412 = state_50692__$1;
(statearr_50705_52412[(1)] = (22));

} else {
var statearr_50706_52415 = state_50692__$1;
(statearr_50706_52415[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (27))){
var inst_50627 = (state_50692[(9)]);
var inst_50629 = (state_50692[(10)]);
var inst_50636 = (state_50692[(11)]);
var inst_50545 = (state_50692[(12)]);
var inst_50636__$1 = cljs.core._nth(inst_50627,inst_50629);
var inst_50638 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_50636__$1,inst_50545,done);
var state_50692__$1 = (function (){var statearr_50711 = state_50692;
(statearr_50711[(11)] = inst_50636__$1);

return statearr_50711;
})();
if(cljs.core.truth_(inst_50638)){
var statearr_50712_52418 = state_50692__$1;
(statearr_50712_52418[(1)] = (30));

} else {
var statearr_50713_52419 = state_50692__$1;
(statearr_50713_52419[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (1))){
var state_50692__$1 = state_50692;
var statearr_50715_52420 = state_50692__$1;
(statearr_50715_52420[(2)] = null);

(statearr_50715_52420[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (24))){
var inst_50580 = (state_50692[(7)]);
var inst_50603 = (state_50692[(2)]);
var inst_50604 = cljs.core.next(inst_50580);
var inst_50555 = inst_50604;
var inst_50556 = null;
var inst_50557 = (0);
var inst_50558 = (0);
var state_50692__$1 = (function (){var statearr_50718 = state_50692;
(statearr_50718[(13)] = inst_50603);

(statearr_50718[(14)] = inst_50555);

(statearr_50718[(15)] = inst_50556);

(statearr_50718[(16)] = inst_50557);

(statearr_50718[(17)] = inst_50558);

return statearr_50718;
})();
var statearr_50720_52423 = state_50692__$1;
(statearr_50720_52423[(2)] = null);

(statearr_50720_52423[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (39))){
var state_50692__$1 = state_50692;
var statearr_50728_52425 = state_50692__$1;
(statearr_50728_52425[(2)] = null);

(statearr_50728_52425[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (4))){
var inst_50545 = (state_50692[(12)]);
var inst_50545__$1 = (state_50692[(2)]);
var inst_50546 = (inst_50545__$1 == null);
var state_50692__$1 = (function (){var statearr_50730 = state_50692;
(statearr_50730[(12)] = inst_50545__$1);

return statearr_50730;
})();
if(cljs.core.truth_(inst_50546)){
var statearr_50731_52431 = state_50692__$1;
(statearr_50731_52431[(1)] = (5));

} else {
var statearr_50732_52436 = state_50692__$1;
(statearr_50732_52436[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (15))){
var inst_50558 = (state_50692[(17)]);
var inst_50555 = (state_50692[(14)]);
var inst_50556 = (state_50692[(15)]);
var inst_50557 = (state_50692[(16)]);
var inst_50576 = (state_50692[(2)]);
var inst_50577 = (inst_50558 + (1));
var tmp50722 = inst_50557;
var tmp50723 = inst_50556;
var tmp50724 = inst_50555;
var inst_50555__$1 = tmp50724;
var inst_50556__$1 = tmp50723;
var inst_50557__$1 = tmp50722;
var inst_50558__$1 = inst_50577;
var state_50692__$1 = (function (){var statearr_50736 = state_50692;
(statearr_50736[(18)] = inst_50576);

(statearr_50736[(14)] = inst_50555__$1);

(statearr_50736[(15)] = inst_50556__$1);

(statearr_50736[(16)] = inst_50557__$1);

(statearr_50736[(17)] = inst_50558__$1);

return statearr_50736;
})();
var statearr_50738_52449 = state_50692__$1;
(statearr_50738_52449[(2)] = null);

(statearr_50738_52449[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (21))){
var inst_50607 = (state_50692[(2)]);
var state_50692__$1 = state_50692;
var statearr_50745_52453 = state_50692__$1;
(statearr_50745_52453[(2)] = inst_50607);

(statearr_50745_52453[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (31))){
var inst_50636 = (state_50692[(11)]);
var inst_50641 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null, inst_50636);
var state_50692__$1 = state_50692;
var statearr_50747_52462 = state_50692__$1;
(statearr_50747_52462[(2)] = inst_50641);

(statearr_50747_52462[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (32))){
var inst_50629 = (state_50692[(10)]);
var inst_50626 = (state_50692[(19)]);
var inst_50627 = (state_50692[(9)]);
var inst_50628 = (state_50692[(20)]);
var inst_50643 = (state_50692[(2)]);
var inst_50644 = (inst_50629 + (1));
var tmp50740 = inst_50628;
var tmp50741 = inst_50627;
var tmp50742 = inst_50626;
var inst_50626__$1 = tmp50742;
var inst_50627__$1 = tmp50741;
var inst_50628__$1 = tmp50740;
var inst_50629__$1 = inst_50644;
var state_50692__$1 = (function (){var statearr_50751 = state_50692;
(statearr_50751[(21)] = inst_50643);

(statearr_50751[(19)] = inst_50626__$1);

(statearr_50751[(9)] = inst_50627__$1);

(statearr_50751[(20)] = inst_50628__$1);

(statearr_50751[(10)] = inst_50629__$1);

return statearr_50751;
})();
var statearr_50753_52466 = state_50692__$1;
(statearr_50753_52466[(2)] = null);

(statearr_50753_52466[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (40))){
var inst_50657 = (state_50692[(22)]);
var inst_50663 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null, inst_50657);
var state_50692__$1 = state_50692;
var statearr_50756_52474 = state_50692__$1;
(statearr_50756_52474[(2)] = inst_50663);

(statearr_50756_52474[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (33))){
var inst_50647 = (state_50692[(23)]);
var inst_50650 = cljs.core.chunked_seq_QMARK_(inst_50647);
var state_50692__$1 = state_50692;
if(inst_50650){
var statearr_50760_52482 = state_50692__$1;
(statearr_50760_52482[(1)] = (36));

} else {
var statearr_50761_52483 = state_50692__$1;
(statearr_50761_52483[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (13))){
var inst_50569 = (state_50692[(24)]);
var inst_50573 = cljs.core.async.close_BANG_(inst_50569);
var state_50692__$1 = state_50692;
var statearr_50763_52488 = state_50692__$1;
(statearr_50763_52488[(2)] = inst_50573);

(statearr_50763_52488[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (22))){
var inst_50597 = (state_50692[(8)]);
var inst_50600 = cljs.core.async.close_BANG_(inst_50597);
var state_50692__$1 = state_50692;
var statearr_50767_52490 = state_50692__$1;
(statearr_50767_52490[(2)] = inst_50600);

(statearr_50767_52490[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (36))){
var inst_50647 = (state_50692[(23)]);
var inst_50652 = cljs.core.chunk_first(inst_50647);
var inst_50653 = cljs.core.chunk_rest(inst_50647);
var inst_50654 = cljs.core.count(inst_50652);
var inst_50626 = inst_50653;
var inst_50627 = inst_50652;
var inst_50628 = inst_50654;
var inst_50629 = (0);
var state_50692__$1 = (function (){var statearr_50777 = state_50692;
(statearr_50777[(19)] = inst_50626);

(statearr_50777[(9)] = inst_50627);

(statearr_50777[(20)] = inst_50628);

(statearr_50777[(10)] = inst_50629);

return statearr_50777;
})();
var statearr_50781_52515 = state_50692__$1;
(statearr_50781_52515[(2)] = null);

(statearr_50781_52515[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (41))){
var inst_50647 = (state_50692[(23)]);
var inst_50665 = (state_50692[(2)]);
var inst_50666 = cljs.core.next(inst_50647);
var inst_50626 = inst_50666;
var inst_50627 = null;
var inst_50628 = (0);
var inst_50629 = (0);
var state_50692__$1 = (function (){var statearr_50783 = state_50692;
(statearr_50783[(25)] = inst_50665);

(statearr_50783[(19)] = inst_50626);

(statearr_50783[(9)] = inst_50627);

(statearr_50783[(20)] = inst_50628);

(statearr_50783[(10)] = inst_50629);

return statearr_50783;
})();
var statearr_50785_52517 = state_50692__$1;
(statearr_50785_52517[(2)] = null);

(statearr_50785_52517[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (43))){
var state_50692__$1 = state_50692;
var statearr_50789_52518 = state_50692__$1;
(statearr_50789_52518[(2)] = null);

(statearr_50789_52518[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (29))){
var inst_50675 = (state_50692[(2)]);
var state_50692__$1 = state_50692;
var statearr_50795_52523 = state_50692__$1;
(statearr_50795_52523[(2)] = inst_50675);

(statearr_50795_52523[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (44))){
var inst_50684 = (state_50692[(2)]);
var state_50692__$1 = (function (){var statearr_50800 = state_50692;
(statearr_50800[(26)] = inst_50684);

return statearr_50800;
})();
var statearr_50803_52527 = state_50692__$1;
(statearr_50803_52527[(2)] = null);

(statearr_50803_52527[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (6))){
var inst_50618 = (state_50692[(27)]);
var inst_50617 = cljs.core.deref(cs);
var inst_50618__$1 = cljs.core.keys(inst_50617);
var inst_50619 = cljs.core.count(inst_50618__$1);
var inst_50620 = cljs.core.reset_BANG_(dctr,inst_50619);
var inst_50625 = cljs.core.seq(inst_50618__$1);
var inst_50626 = inst_50625;
var inst_50627 = null;
var inst_50628 = (0);
var inst_50629 = (0);
var state_50692__$1 = (function (){var statearr_50806 = state_50692;
(statearr_50806[(27)] = inst_50618__$1);

(statearr_50806[(28)] = inst_50620);

(statearr_50806[(19)] = inst_50626);

(statearr_50806[(9)] = inst_50627);

(statearr_50806[(20)] = inst_50628);

(statearr_50806[(10)] = inst_50629);

return statearr_50806;
})();
var statearr_50813_52542 = state_50692__$1;
(statearr_50813_52542[(2)] = null);

(statearr_50813_52542[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (28))){
var inst_50626 = (state_50692[(19)]);
var inst_50647 = (state_50692[(23)]);
var inst_50647__$1 = cljs.core.seq(inst_50626);
var state_50692__$1 = (function (){var statearr_50815 = state_50692;
(statearr_50815[(23)] = inst_50647__$1);

return statearr_50815;
})();
if(inst_50647__$1){
var statearr_50816_52546 = state_50692__$1;
(statearr_50816_52546[(1)] = (33));

} else {
var statearr_50822_52547 = state_50692__$1;
(statearr_50822_52547[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (25))){
var inst_50629 = (state_50692[(10)]);
var inst_50628 = (state_50692[(20)]);
var inst_50632 = (inst_50629 < inst_50628);
var inst_50633 = inst_50632;
var state_50692__$1 = state_50692;
if(cljs.core.truth_(inst_50633)){
var statearr_50825_52556 = state_50692__$1;
(statearr_50825_52556[(1)] = (27));

} else {
var statearr_50826_52558 = state_50692__$1;
(statearr_50826_52558[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (34))){
var state_50692__$1 = state_50692;
var statearr_50827_52560 = state_50692__$1;
(statearr_50827_52560[(2)] = null);

(statearr_50827_52560[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (17))){
var state_50692__$1 = state_50692;
var statearr_50831_52561 = state_50692__$1;
(statearr_50831_52561[(2)] = null);

(statearr_50831_52561[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (3))){
var inst_50689 = (state_50692[(2)]);
var state_50692__$1 = state_50692;
return cljs.core.async.impl.ioc_helpers.return_chan(state_50692__$1,inst_50689);
} else {
if((state_val_50693 === (12))){
var inst_50612 = (state_50692[(2)]);
var state_50692__$1 = state_50692;
var statearr_50833_52566 = state_50692__$1;
(statearr_50833_52566[(2)] = inst_50612);

(statearr_50833_52566[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (2))){
var state_50692__$1 = state_50692;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50692__$1,(4),ch);
} else {
if((state_val_50693 === (23))){
var state_50692__$1 = state_50692;
var statearr_50834_52567 = state_50692__$1;
(statearr_50834_52567[(2)] = null);

(statearr_50834_52567[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (35))){
var inst_50672 = (state_50692[(2)]);
var state_50692__$1 = state_50692;
var statearr_50836_52568 = state_50692__$1;
(statearr_50836_52568[(2)] = inst_50672);

(statearr_50836_52568[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (19))){
var inst_50580 = (state_50692[(7)]);
var inst_50585 = cljs.core.chunk_first(inst_50580);
var inst_50586 = cljs.core.chunk_rest(inst_50580);
var inst_50587 = cljs.core.count(inst_50585);
var inst_50555 = inst_50586;
var inst_50556 = inst_50585;
var inst_50557 = inst_50587;
var inst_50558 = (0);
var state_50692__$1 = (function (){var statearr_50837 = state_50692;
(statearr_50837[(14)] = inst_50555);

(statearr_50837[(15)] = inst_50556);

(statearr_50837[(16)] = inst_50557);

(statearr_50837[(17)] = inst_50558);

return statearr_50837;
})();
var statearr_50838_52570 = state_50692__$1;
(statearr_50838_52570[(2)] = null);

(statearr_50838_52570[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (11))){
var inst_50555 = (state_50692[(14)]);
var inst_50580 = (state_50692[(7)]);
var inst_50580__$1 = cljs.core.seq(inst_50555);
var state_50692__$1 = (function (){var statearr_50843 = state_50692;
(statearr_50843[(7)] = inst_50580__$1);

return statearr_50843;
})();
if(inst_50580__$1){
var statearr_50847_52580 = state_50692__$1;
(statearr_50847_52580[(1)] = (16));

} else {
var statearr_50848_52581 = state_50692__$1;
(statearr_50848_52581[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (9))){
var inst_50614 = (state_50692[(2)]);
var state_50692__$1 = state_50692;
var statearr_50850_52582 = state_50692__$1;
(statearr_50850_52582[(2)] = inst_50614);

(statearr_50850_52582[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (5))){
var inst_50553 = cljs.core.deref(cs);
var inst_50554 = cljs.core.seq(inst_50553);
var inst_50555 = inst_50554;
var inst_50556 = null;
var inst_50557 = (0);
var inst_50558 = (0);
var state_50692__$1 = (function (){var statearr_50851 = state_50692;
(statearr_50851[(14)] = inst_50555);

(statearr_50851[(15)] = inst_50556);

(statearr_50851[(16)] = inst_50557);

(statearr_50851[(17)] = inst_50558);

return statearr_50851;
})();
var statearr_50855_52584 = state_50692__$1;
(statearr_50855_52584[(2)] = null);

(statearr_50855_52584[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (14))){
var state_50692__$1 = state_50692;
var statearr_50857_52590 = state_50692__$1;
(statearr_50857_52590[(2)] = null);

(statearr_50857_52590[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (45))){
var inst_50681 = (state_50692[(2)]);
var state_50692__$1 = state_50692;
var statearr_50858_52591 = state_50692__$1;
(statearr_50858_52591[(2)] = inst_50681);

(statearr_50858_52591[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (26))){
var inst_50618 = (state_50692[(27)]);
var inst_50677 = (state_50692[(2)]);
var inst_50678 = cljs.core.seq(inst_50618);
var state_50692__$1 = (function (){var statearr_50863 = state_50692;
(statearr_50863[(29)] = inst_50677);

return statearr_50863;
})();
if(inst_50678){
var statearr_50864_52602 = state_50692__$1;
(statearr_50864_52602[(1)] = (42));

} else {
var statearr_50865_52603 = state_50692__$1;
(statearr_50865_52603[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (16))){
var inst_50580 = (state_50692[(7)]);
var inst_50583 = cljs.core.chunked_seq_QMARK_(inst_50580);
var state_50692__$1 = state_50692;
if(inst_50583){
var statearr_50866_52604 = state_50692__$1;
(statearr_50866_52604[(1)] = (19));

} else {
var statearr_50870_52609 = state_50692__$1;
(statearr_50870_52609[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (38))){
var inst_50669 = (state_50692[(2)]);
var state_50692__$1 = state_50692;
var statearr_50872_52610 = state_50692__$1;
(statearr_50872_52610[(2)] = inst_50669);

(statearr_50872_52610[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (30))){
var state_50692__$1 = state_50692;
var statearr_50873_52615 = state_50692__$1;
(statearr_50873_52615[(2)] = null);

(statearr_50873_52615[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (10))){
var inst_50556 = (state_50692[(15)]);
var inst_50558 = (state_50692[(17)]);
var inst_50567 = cljs.core._nth(inst_50556,inst_50558);
var inst_50569 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_50567,(0),null);
var inst_50571 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_50567,(1),null);
var state_50692__$1 = (function (){var statearr_50875 = state_50692;
(statearr_50875[(24)] = inst_50569);

return statearr_50875;
})();
if(cljs.core.truth_(inst_50571)){
var statearr_50876_52617 = state_50692__$1;
(statearr_50876_52617[(1)] = (13));

} else {
var statearr_50877_52618 = state_50692__$1;
(statearr_50877_52618[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (18))){
var inst_50610 = (state_50692[(2)]);
var state_50692__$1 = state_50692;
var statearr_50878_52619 = state_50692__$1;
(statearr_50878_52619[(2)] = inst_50610);

(statearr_50878_52619[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (42))){
var state_50692__$1 = state_50692;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50692__$1,(45),dchan);
} else {
if((state_val_50693 === (37))){
var inst_50647 = (state_50692[(23)]);
var inst_50657 = (state_50692[(22)]);
var inst_50545 = (state_50692[(12)]);
var inst_50657__$1 = cljs.core.first(inst_50647);
var inst_50658 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_50657__$1,inst_50545,done);
var state_50692__$1 = (function (){var statearr_50886 = state_50692;
(statearr_50886[(22)] = inst_50657__$1);

return statearr_50886;
})();
if(cljs.core.truth_(inst_50658)){
var statearr_50888_52630 = state_50692__$1;
(statearr_50888_52630[(1)] = (39));

} else {
var statearr_50889_52632 = state_50692__$1;
(statearr_50889_52632[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50693 === (8))){
var inst_50558 = (state_50692[(17)]);
var inst_50557 = (state_50692[(16)]);
var inst_50560 = (inst_50558 < inst_50557);
var inst_50561 = inst_50560;
var state_50692__$1 = state_50692;
if(cljs.core.truth_(inst_50561)){
var statearr_50890_52633 = state_50692__$1;
(statearr_50890_52633[(1)] = (10));

} else {
var statearr_50891_52634 = state_50692__$1;
(statearr_50891_52634[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__49491__auto__ = null;
var cljs$core$async$mult_$_state_machine__49491__auto____0 = (function (){
var statearr_50899 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_50899[(0)] = cljs$core$async$mult_$_state_machine__49491__auto__);

(statearr_50899[(1)] = (1));

return statearr_50899;
});
var cljs$core$async$mult_$_state_machine__49491__auto____1 = (function (state_50692){
while(true){
var ret_value__49492__auto__ = (function (){try{while(true){
var result__49493__auto__ = switch__49490__auto__(state_50692);
if(cljs.core.keyword_identical_QMARK_(result__49493__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__49493__auto__;
}
break;
}
}catch (e50901){var ex__49494__auto__ = e50901;
var statearr_50902_52637 = state_50692;
(statearr_50902_52637[(2)] = ex__49494__auto__);


if(cljs.core.seq((state_50692[(4)]))){
var statearr_50903_52638 = state_50692;
(statearr_50903_52638[(1)] = cljs.core.first((state_50692[(4)])));

} else {
throw ex__49494__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__49492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52640 = state_50692;
state_50692 = G__52640;
continue;
} else {
return ret_value__49492__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__49491__auto__ = function(state_50692){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__49491__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__49491__auto____1.call(this,state_50692);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__49491__auto____0;
cljs$core$async$mult_$_state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__49491__auto____1;
return cljs$core$async$mult_$_state_machine__49491__auto__;
})()
})();
var state__49701__auto__ = (function (){var statearr_50908 = f__49700__auto__();
(statearr_50908[(6)] = c__49699__auto___52408);

return statearr_50908;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__49701__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__50911 = arguments.length;
switch (G__50911) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_52666 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null, m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null, m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_52666(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_52671 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null, m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null, m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_52671(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_52682 = (function (m){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5351__auto__.call(null, m));
} else {
var m__5349__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5349__auto__.call(null, m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_52682(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_52700 = (function (m,state_map){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5351__auto__.call(null, m,state_map));
} else {
var m__5349__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5349__auto__.call(null, m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_52700(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_52707 = (function (m,mode){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5351__auto__.call(null, m,mode));
} else {
var m__5349__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5349__auto__.call(null, m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_52707(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5732__auto__ = [];
var len__5726__auto___52720 = arguments.length;
var i__5727__auto___52721 = (0);
while(true){
if((i__5727__auto___52721 < len__5726__auto___52720)){
args__5732__auto__.push((arguments[i__5727__auto___52721]));

var G__52723 = (i__5727__auto___52721 + (1));
i__5727__auto___52721 = G__52723;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((3) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5733__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__50943){
var map__50944 = p__50943;
var map__50944__$1 = cljs.core.__destructure_map(map__50944);
var opts = map__50944__$1;
var statearr_50945_52731 = state;
(statearr_50945_52731[(1)] = cont_block);


var temp__5823__auto__ = cljs.core.async.do_alts((function (val){
var statearr_50946_52734 = state;
(statearr_50946_52734[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5823__auto__)){
var cb = temp__5823__auto__;
var statearr_50947_52739 = state;
(statearr_50947_52739[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq50937){
var G__50938 = cljs.core.first(seq50937);
var seq50937__$1 = cljs.core.next(seq50937);
var G__50939 = cljs.core.first(seq50937__$1);
var seq50937__$2 = cljs.core.next(seq50937__$1);
var G__50940 = cljs.core.first(seq50937__$2);
var seq50937__$3 = cljs.core.next(seq50937__$2);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__50938,G__50939,G__50940,seq50937__$3);
}));


/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async50948 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta50949){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta50949 = meta50949;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async50948.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_50950,meta50949__$1){
var self__ = this;
var _50950__$1 = this;
return (new cljs.core.async.t_cljs$core$async50948(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta50949__$1));
}));

(cljs.core.async.t_cljs$core$async50948.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_50950){
var self__ = this;
var _50950__$1 = this;
return self__.meta50949;
}));

(cljs.core.async.t_cljs$core$async50948.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async50948.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async50948.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async50948.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null, ));
}));

(cljs.core.async.t_cljs$core$async50948.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null, ));
}));

(cljs.core.async.t_cljs$core$async50948.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null, ));
}));

(cljs.core.async.t_cljs$core$async50948.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null, ));
}));

(cljs.core.async.t_cljs$core$async50948.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null, mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null, ));
}));

(cljs.core.async.t_cljs$core$async50948.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta50949","meta50949",1877377701,null)], null);
}));

(cljs.core.async.t_cljs$core$async50948.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async50948.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async50948");

(cljs.core.async.t_cljs$core$async50948.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async50948");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async50948.
 */
cljs.core.async.__GT_t_cljs$core$async50948 = (function cljs$core$async$__GT_t_cljs$core$async50948(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta50949){
return (new cljs.core.async.t_cljs$core$async50948(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta50949));
});


/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null, v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (cljs.core.seq(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (new cljs.core.async.t_cljs$core$async50948(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
var c__49699__auto___52752 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__49700__auto__ = (function (){var switch__49490__auto__ = (function (state_51022){
var state_val_51023 = (state_51022[(1)]);
if((state_val_51023 === (7))){
var inst_50982 = (state_51022[(2)]);
var state_51022__$1 = state_51022;
if(cljs.core.truth_(inst_50982)){
var statearr_51026_52753 = state_51022__$1;
(statearr_51026_52753[(1)] = (8));

} else {
var statearr_51027_52754 = state_51022__$1;
(statearr_51027_52754[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51023 === (20))){
var inst_50975 = (state_51022[(7)]);
var state_51022__$1 = state_51022;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_51022__$1,(23),out,inst_50975);
} else {
if((state_val_51023 === (1))){
var inst_50956 = calc_state();
var inst_50957 = cljs.core.__destructure_map(inst_50956);
var inst_50958 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_50957,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_50959 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_50957,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_50960 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_50957,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_50961 = inst_50956;
var state_51022__$1 = (function (){var statearr_51028 = state_51022;
(statearr_51028[(8)] = inst_50958);

(statearr_51028[(9)] = inst_50959);

(statearr_51028[(10)] = inst_50960);

(statearr_51028[(11)] = inst_50961);

return statearr_51028;
})();
var statearr_51029_52755 = state_51022__$1;
(statearr_51029_52755[(2)] = null);

(statearr_51029_52755[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51023 === (24))){
var inst_50965 = (state_51022[(12)]);
var inst_50961 = inst_50965;
var state_51022__$1 = (function (){var statearr_51030 = state_51022;
(statearr_51030[(11)] = inst_50961);

return statearr_51030;
})();
var statearr_51031_52756 = state_51022__$1;
(statearr_51031_52756[(2)] = null);

(statearr_51031_52756[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51023 === (4))){
var inst_50975 = (state_51022[(7)]);
var inst_50977 = (state_51022[(13)]);
var inst_50974 = (state_51022[(2)]);
var inst_50975__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_50974,(0),null);
var inst_50976 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_50974,(1),null);
var inst_50977__$1 = (inst_50975__$1 == null);
var state_51022__$1 = (function (){var statearr_51032 = state_51022;
(statearr_51032[(7)] = inst_50975__$1);

(statearr_51032[(14)] = inst_50976);

(statearr_51032[(13)] = inst_50977__$1);

return statearr_51032;
})();
if(cljs.core.truth_(inst_50977__$1)){
var statearr_51033_52757 = state_51022__$1;
(statearr_51033_52757[(1)] = (5));

} else {
var statearr_51034_52758 = state_51022__$1;
(statearr_51034_52758[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51023 === (15))){
var inst_50966 = (state_51022[(15)]);
var inst_50996 = (state_51022[(16)]);
var inst_50996__$1 = cljs.core.empty_QMARK_(inst_50966);
var state_51022__$1 = (function (){var statearr_51035 = state_51022;
(statearr_51035[(16)] = inst_50996__$1);

return statearr_51035;
})();
if(inst_50996__$1){
var statearr_51036_52763 = state_51022__$1;
(statearr_51036_52763[(1)] = (17));

} else {
var statearr_51037_52768 = state_51022__$1;
(statearr_51037_52768[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51023 === (21))){
var inst_50965 = (state_51022[(12)]);
var inst_50961 = inst_50965;
var state_51022__$1 = (function (){var statearr_51038 = state_51022;
(statearr_51038[(11)] = inst_50961);

return statearr_51038;
})();
var statearr_51039_52770 = state_51022__$1;
(statearr_51039_52770[(2)] = null);

(statearr_51039_52770[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51023 === (13))){
var inst_50989 = (state_51022[(2)]);
var inst_50990 = calc_state();
var inst_50961 = inst_50990;
var state_51022__$1 = (function (){var statearr_51041 = state_51022;
(statearr_51041[(17)] = inst_50989);

(statearr_51041[(11)] = inst_50961);

return statearr_51041;
})();
var statearr_51043_52774 = state_51022__$1;
(statearr_51043_52774[(2)] = null);

(statearr_51043_52774[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51023 === (22))){
var inst_51016 = (state_51022[(2)]);
var state_51022__$1 = state_51022;
var statearr_51044_52775 = state_51022__$1;
(statearr_51044_52775[(2)] = inst_51016);

(statearr_51044_52775[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51023 === (6))){
var inst_50976 = (state_51022[(14)]);
var inst_50980 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_50976,change);
var state_51022__$1 = state_51022;
var statearr_51045_52776 = state_51022__$1;
(statearr_51045_52776[(2)] = inst_50980);

(statearr_51045_52776[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51023 === (25))){
var state_51022__$1 = state_51022;
var statearr_51046_52777 = state_51022__$1;
(statearr_51046_52777[(2)] = null);

(statearr_51046_52777[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51023 === (17))){
var inst_50967 = (state_51022[(18)]);
var inst_50976 = (state_51022[(14)]);
var inst_50998 = (inst_50967.cljs$core$IFn$_invoke$arity$1 ? inst_50967.cljs$core$IFn$_invoke$arity$1(inst_50976) : inst_50967.call(null, inst_50976));
var inst_50999 = cljs.core.not(inst_50998);
var state_51022__$1 = state_51022;
var statearr_51051_52778 = state_51022__$1;
(statearr_51051_52778[(2)] = inst_50999);

(statearr_51051_52778[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51023 === (3))){
var inst_51020 = (state_51022[(2)]);
var state_51022__$1 = state_51022;
return cljs.core.async.impl.ioc_helpers.return_chan(state_51022__$1,inst_51020);
} else {
if((state_val_51023 === (12))){
var state_51022__$1 = state_51022;
var statearr_51052_52784 = state_51022__$1;
(statearr_51052_52784[(2)] = null);

(statearr_51052_52784[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51023 === (2))){
var inst_50961 = (state_51022[(11)]);
var inst_50965 = (state_51022[(12)]);
var inst_50965__$1 = cljs.core.__destructure_map(inst_50961);
var inst_50966 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_50965__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_50967 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_50965__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_50968 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_50965__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_51022__$1 = (function (){var statearr_51054 = state_51022;
(statearr_51054[(12)] = inst_50965__$1);

(statearr_51054[(15)] = inst_50966);

(statearr_51054[(18)] = inst_50967);

return statearr_51054;
})();
return cljs.core.async.ioc_alts_BANG_(state_51022__$1,(4),inst_50968);
} else {
if((state_val_51023 === (23))){
var inst_51007 = (state_51022[(2)]);
var state_51022__$1 = state_51022;
if(cljs.core.truth_(inst_51007)){
var statearr_51056_52786 = state_51022__$1;
(statearr_51056_52786[(1)] = (24));

} else {
var statearr_51057_52787 = state_51022__$1;
(statearr_51057_52787[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51023 === (19))){
var inst_51002 = (state_51022[(2)]);
var state_51022__$1 = state_51022;
var statearr_51058_52788 = state_51022__$1;
(statearr_51058_52788[(2)] = inst_51002);

(statearr_51058_52788[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51023 === (11))){
var inst_50976 = (state_51022[(14)]);
var inst_50986 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_50976);
var state_51022__$1 = state_51022;
var statearr_51060_52793 = state_51022__$1;
(statearr_51060_52793[(2)] = inst_50986);

(statearr_51060_52793[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51023 === (9))){
var inst_50966 = (state_51022[(15)]);
var inst_50976 = (state_51022[(14)]);
var inst_50993 = (state_51022[(19)]);
var inst_50993__$1 = (inst_50966.cljs$core$IFn$_invoke$arity$1 ? inst_50966.cljs$core$IFn$_invoke$arity$1(inst_50976) : inst_50966.call(null, inst_50976));
var state_51022__$1 = (function (){var statearr_51063 = state_51022;
(statearr_51063[(19)] = inst_50993__$1);

return statearr_51063;
})();
if(cljs.core.truth_(inst_50993__$1)){
var statearr_51064_52798 = state_51022__$1;
(statearr_51064_52798[(1)] = (14));

} else {
var statearr_51065_52799 = state_51022__$1;
(statearr_51065_52799[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51023 === (5))){
var inst_50977 = (state_51022[(13)]);
var state_51022__$1 = state_51022;
var statearr_51066_52800 = state_51022__$1;
(statearr_51066_52800[(2)] = inst_50977);

(statearr_51066_52800[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51023 === (14))){
var inst_50993 = (state_51022[(19)]);
var state_51022__$1 = state_51022;
var statearr_51070_52802 = state_51022__$1;
(statearr_51070_52802[(2)] = inst_50993);

(statearr_51070_52802[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51023 === (26))){
var inst_51012 = (state_51022[(2)]);
var state_51022__$1 = state_51022;
var statearr_51071_52807 = state_51022__$1;
(statearr_51071_52807[(2)] = inst_51012);

(statearr_51071_52807[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51023 === (16))){
var inst_51004 = (state_51022[(2)]);
var state_51022__$1 = state_51022;
if(cljs.core.truth_(inst_51004)){
var statearr_51072_52808 = state_51022__$1;
(statearr_51072_52808[(1)] = (20));

} else {
var statearr_51073_52809 = state_51022__$1;
(statearr_51073_52809[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51023 === (10))){
var inst_51018 = (state_51022[(2)]);
var state_51022__$1 = state_51022;
var statearr_51074_52810 = state_51022__$1;
(statearr_51074_52810[(2)] = inst_51018);

(statearr_51074_52810[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51023 === (18))){
var inst_50996 = (state_51022[(16)]);
var state_51022__$1 = state_51022;
var statearr_51075_52814 = state_51022__$1;
(statearr_51075_52814[(2)] = inst_50996);

(statearr_51075_52814[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51023 === (8))){
var inst_50975 = (state_51022[(7)]);
var inst_50984 = (inst_50975 == null);
var state_51022__$1 = state_51022;
if(cljs.core.truth_(inst_50984)){
var statearr_51076_52815 = state_51022__$1;
(statearr_51076_52815[(1)] = (11));

} else {
var statearr_51084_52816 = state_51022__$1;
(statearr_51084_52816[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__49491__auto__ = null;
var cljs$core$async$mix_$_state_machine__49491__auto____0 = (function (){
var statearr_51097 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_51097[(0)] = cljs$core$async$mix_$_state_machine__49491__auto__);

(statearr_51097[(1)] = (1));

return statearr_51097;
});
var cljs$core$async$mix_$_state_machine__49491__auto____1 = (function (state_51022){
while(true){
var ret_value__49492__auto__ = (function (){try{while(true){
var result__49493__auto__ = switch__49490__auto__(state_51022);
if(cljs.core.keyword_identical_QMARK_(result__49493__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__49493__auto__;
}
break;
}
}catch (e51098){var ex__49494__auto__ = e51098;
var statearr_51099_52820 = state_51022;
(statearr_51099_52820[(2)] = ex__49494__auto__);


if(cljs.core.seq((state_51022[(4)]))){
var statearr_51100_52821 = state_51022;
(statearr_51100_52821[(1)] = cljs.core.first((state_51022[(4)])));

} else {
throw ex__49494__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__49492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52822 = state_51022;
state_51022 = G__52822;
continue;
} else {
return ret_value__49492__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__49491__auto__ = function(state_51022){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__49491__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__49491__auto____1.call(this,state_51022);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__49491__auto____0;
cljs$core$async$mix_$_state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__49491__auto____1;
return cljs$core$async$mix_$_state_machine__49491__auto__;
})()
})();
var state__49701__auto__ = (function (){var statearr_51101 = f__49700__auto__();
(statearr_51101[(6)] = c__49699__auto___52752);

return statearr_51101;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__49701__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_52824 = (function (p,v,ch,close_QMARK_){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5351__auto__.call(null, p,v,ch,close_QMARK_));
} else {
var m__5349__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5349__auto__.call(null, p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_52824(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_52828 = (function (p,v,ch){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5351__auto__.call(null, p,v,ch));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5349__auto__.call(null, p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_52828(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_52832 = (function() {
var G__52833 = null;
var G__52833__1 = (function (p){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5351__auto__.call(null, p));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5349__auto__.call(null, p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__52833__2 = (function (p,v){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5351__auto__.call(null, p,v));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5349__auto__.call(null, p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__52833 = function(p,v){
switch(arguments.length){
case 1:
return G__52833__1.call(this,p);
case 2:
return G__52833__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__52833.cljs$core$IFn$_invoke$arity$1 = G__52833__1;
G__52833.cljs$core$IFn$_invoke$arity$2 = G__52833__2;
return G__52833;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__51127 = arguments.length;
switch (G__51127) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_52832(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_52832(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);



/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async51134 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta51135){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta51135 = meta51135;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async51134.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_51136,meta51135__$1){
var self__ = this;
var _51136__$1 = this;
return (new cljs.core.async.t_cljs$core$async51134(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta51135__$1));
}));

(cljs.core.async.t_cljs$core$async51134.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_51136){
var self__ = this;
var _51136__$1 = this;
return self__.meta51135;
}));

(cljs.core.async.t_cljs$core$async51134.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async51134.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async51134.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async51134.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null, topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async51134.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5823__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5823__auto__)){
var m = temp__5823__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async51134.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async51134.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async51134.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta51135","meta51135",-678290095,null)], null);
}));

(cljs.core.async.t_cljs$core$async51134.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async51134.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async51134");

(cljs.core.async.t_cljs$core$async51134.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async51134");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async51134.
 */
cljs.core.async.__GT_t_cljs$core$async51134 = (function cljs$core$async$__GT_t_cljs$core$async51134(ch,topic_fn,buf_fn,mults,ensure_mult,meta51135){
return (new cljs.core.async.t_cljs$core$async51134(ch,topic_fn,buf_fn,mults,ensure_mult,meta51135));
});


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__51131 = arguments.length;
switch (G__51131) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__5002__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__51129_SHARP_){
if(cljs.core.truth_((p1__51129_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__51129_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__51129_SHARP_.call(null, topic)))){
return p1__51129_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__51129_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null, topic)))));
}
})),topic);
}
});
var p = (new cljs.core.async.t_cljs$core$async51134(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
var c__49699__auto___52854 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__49700__auto__ = (function (){var switch__49490__auto__ = (function (state_51218){
var state_val_51219 = (state_51218[(1)]);
if((state_val_51219 === (7))){
var inst_51214 = (state_51218[(2)]);
var state_51218__$1 = state_51218;
var statearr_51220_52855 = state_51218__$1;
(statearr_51220_52855[(2)] = inst_51214);

(statearr_51220_52855[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51219 === (20))){
var state_51218__$1 = state_51218;
var statearr_51222_52859 = state_51218__$1;
(statearr_51222_52859[(2)] = null);

(statearr_51222_52859[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51219 === (1))){
var state_51218__$1 = state_51218;
var statearr_51224_52862 = state_51218__$1;
(statearr_51224_52862[(2)] = null);

(statearr_51224_52862[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51219 === (24))){
var inst_51196 = (state_51218[(7)]);
var inst_51206 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_51196);
var state_51218__$1 = state_51218;
var statearr_51225_52864 = state_51218__$1;
(statearr_51225_52864[(2)] = inst_51206);

(statearr_51225_52864[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51219 === (4))){
var inst_51144 = (state_51218[(8)]);
var inst_51144__$1 = (state_51218[(2)]);
var inst_51145 = (inst_51144__$1 == null);
var state_51218__$1 = (function (){var statearr_51226 = state_51218;
(statearr_51226[(8)] = inst_51144__$1);

return statearr_51226;
})();
if(cljs.core.truth_(inst_51145)){
var statearr_51227_52868 = state_51218__$1;
(statearr_51227_52868[(1)] = (5));

} else {
var statearr_51228_52869 = state_51218__$1;
(statearr_51228_52869[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51219 === (15))){
var inst_51187 = (state_51218[(2)]);
var state_51218__$1 = state_51218;
var statearr_51230_52870 = state_51218__$1;
(statearr_51230_52870[(2)] = inst_51187);

(statearr_51230_52870[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51219 === (21))){
var inst_51211 = (state_51218[(2)]);
var state_51218__$1 = (function (){var statearr_51232 = state_51218;
(statearr_51232[(9)] = inst_51211);

return statearr_51232;
})();
var statearr_51236_52877 = state_51218__$1;
(statearr_51236_52877[(2)] = null);

(statearr_51236_52877[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51219 === (13))){
var inst_51168 = (state_51218[(10)]);
var inst_51170 = cljs.core.chunked_seq_QMARK_(inst_51168);
var state_51218__$1 = state_51218;
if(inst_51170){
var statearr_51237_52878 = state_51218__$1;
(statearr_51237_52878[(1)] = (16));

} else {
var statearr_51238_52879 = state_51218__$1;
(statearr_51238_52879[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51219 === (22))){
var inst_51203 = (state_51218[(2)]);
var state_51218__$1 = state_51218;
if(cljs.core.truth_(inst_51203)){
var statearr_51239_52880 = state_51218__$1;
(statearr_51239_52880[(1)] = (23));

} else {
var statearr_51240_52881 = state_51218__$1;
(statearr_51240_52881[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51219 === (6))){
var inst_51144 = (state_51218[(8)]);
var inst_51196 = (state_51218[(7)]);
var inst_51199 = (state_51218[(11)]);
var inst_51196__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_51144) : topic_fn.call(null, inst_51144));
var inst_51198 = cljs.core.deref(mults);
var inst_51199__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_51198,inst_51196__$1);
var state_51218__$1 = (function (){var statearr_51241 = state_51218;
(statearr_51241[(7)] = inst_51196__$1);

(statearr_51241[(11)] = inst_51199__$1);

return statearr_51241;
})();
if(cljs.core.truth_(inst_51199__$1)){
var statearr_51242_52885 = state_51218__$1;
(statearr_51242_52885[(1)] = (19));

} else {
var statearr_51243_52886 = state_51218__$1;
(statearr_51243_52886[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51219 === (25))){
var inst_51208 = (state_51218[(2)]);
var state_51218__$1 = state_51218;
var statearr_51244_52887 = state_51218__$1;
(statearr_51244_52887[(2)] = inst_51208);

(statearr_51244_52887[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51219 === (17))){
var inst_51168 = (state_51218[(10)]);
var inst_51177 = cljs.core.first(inst_51168);
var inst_51178 = cljs.core.async.muxch_STAR_(inst_51177);
var inst_51179 = cljs.core.async.close_BANG_(inst_51178);
var inst_51180 = cljs.core.next(inst_51168);
var inst_51154 = inst_51180;
var inst_51155 = null;
var inst_51156 = (0);
var inst_51157 = (0);
var state_51218__$1 = (function (){var statearr_51245 = state_51218;
(statearr_51245[(12)] = inst_51179);

(statearr_51245[(13)] = inst_51154);

(statearr_51245[(14)] = inst_51155);

(statearr_51245[(15)] = inst_51156);

(statearr_51245[(16)] = inst_51157);

return statearr_51245;
})();
var statearr_51246_52892 = state_51218__$1;
(statearr_51246_52892[(2)] = null);

(statearr_51246_52892[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51219 === (3))){
var inst_51216 = (state_51218[(2)]);
var state_51218__$1 = state_51218;
return cljs.core.async.impl.ioc_helpers.return_chan(state_51218__$1,inst_51216);
} else {
if((state_val_51219 === (12))){
var inst_51189 = (state_51218[(2)]);
var state_51218__$1 = state_51218;
var statearr_51247_52896 = state_51218__$1;
(statearr_51247_52896[(2)] = inst_51189);

(statearr_51247_52896[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51219 === (2))){
var state_51218__$1 = state_51218;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51218__$1,(4),ch);
} else {
if((state_val_51219 === (23))){
var state_51218__$1 = state_51218;
var statearr_51248_52902 = state_51218__$1;
(statearr_51248_52902[(2)] = null);

(statearr_51248_52902[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51219 === (19))){
var inst_51199 = (state_51218[(11)]);
var inst_51144 = (state_51218[(8)]);
var inst_51201 = cljs.core.async.muxch_STAR_(inst_51199);
var state_51218__$1 = state_51218;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_51218__$1,(22),inst_51201,inst_51144);
} else {
if((state_val_51219 === (11))){
var inst_51154 = (state_51218[(13)]);
var inst_51168 = (state_51218[(10)]);
var inst_51168__$1 = cljs.core.seq(inst_51154);
var state_51218__$1 = (function (){var statearr_51253 = state_51218;
(statearr_51253[(10)] = inst_51168__$1);

return statearr_51253;
})();
if(inst_51168__$1){
var statearr_51254_52905 = state_51218__$1;
(statearr_51254_52905[(1)] = (13));

} else {
var statearr_51255_52906 = state_51218__$1;
(statearr_51255_52906[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51219 === (9))){
var inst_51191 = (state_51218[(2)]);
var state_51218__$1 = state_51218;
var statearr_51256_52907 = state_51218__$1;
(statearr_51256_52907[(2)] = inst_51191);

(statearr_51256_52907[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51219 === (5))){
var inst_51151 = cljs.core.deref(mults);
var inst_51152 = cljs.core.vals(inst_51151);
var inst_51153 = cljs.core.seq(inst_51152);
var inst_51154 = inst_51153;
var inst_51155 = null;
var inst_51156 = (0);
var inst_51157 = (0);
var state_51218__$1 = (function (){var statearr_51257 = state_51218;
(statearr_51257[(13)] = inst_51154);

(statearr_51257[(14)] = inst_51155);

(statearr_51257[(15)] = inst_51156);

(statearr_51257[(16)] = inst_51157);

return statearr_51257;
})();
var statearr_51262_52914 = state_51218__$1;
(statearr_51262_52914[(2)] = null);

(statearr_51262_52914[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51219 === (14))){
var state_51218__$1 = state_51218;
var statearr_51266_52915 = state_51218__$1;
(statearr_51266_52915[(2)] = null);

(statearr_51266_52915[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51219 === (16))){
var inst_51168 = (state_51218[(10)]);
var inst_51172 = cljs.core.chunk_first(inst_51168);
var inst_51173 = cljs.core.chunk_rest(inst_51168);
var inst_51174 = cljs.core.count(inst_51172);
var inst_51154 = inst_51173;
var inst_51155 = inst_51172;
var inst_51156 = inst_51174;
var inst_51157 = (0);
var state_51218__$1 = (function (){var statearr_51267 = state_51218;
(statearr_51267[(13)] = inst_51154);

(statearr_51267[(14)] = inst_51155);

(statearr_51267[(15)] = inst_51156);

(statearr_51267[(16)] = inst_51157);

return statearr_51267;
})();
var statearr_51268_52918 = state_51218__$1;
(statearr_51268_52918[(2)] = null);

(statearr_51268_52918[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51219 === (10))){
var inst_51155 = (state_51218[(14)]);
var inst_51157 = (state_51218[(16)]);
var inst_51154 = (state_51218[(13)]);
var inst_51156 = (state_51218[(15)]);
var inst_51162 = cljs.core._nth(inst_51155,inst_51157);
var inst_51163 = cljs.core.async.muxch_STAR_(inst_51162);
var inst_51164 = cljs.core.async.close_BANG_(inst_51163);
var inst_51165 = (inst_51157 + (1));
var tmp51263 = inst_51154;
var tmp51264 = inst_51155;
var tmp51265 = inst_51156;
var inst_51154__$1 = tmp51263;
var inst_51155__$1 = tmp51264;
var inst_51156__$1 = tmp51265;
var inst_51157__$1 = inst_51165;
var state_51218__$1 = (function (){var statearr_51269 = state_51218;
(statearr_51269[(17)] = inst_51164);

(statearr_51269[(13)] = inst_51154__$1);

(statearr_51269[(14)] = inst_51155__$1);

(statearr_51269[(15)] = inst_51156__$1);

(statearr_51269[(16)] = inst_51157__$1);

return statearr_51269;
})();
var statearr_51270_52924 = state_51218__$1;
(statearr_51270_52924[(2)] = null);

(statearr_51270_52924[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51219 === (18))){
var inst_51183 = (state_51218[(2)]);
var state_51218__$1 = state_51218;
var statearr_51271_52925 = state_51218__$1;
(statearr_51271_52925[(2)] = inst_51183);

(statearr_51271_52925[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51219 === (8))){
var inst_51157 = (state_51218[(16)]);
var inst_51156 = (state_51218[(15)]);
var inst_51159 = (inst_51157 < inst_51156);
var inst_51160 = inst_51159;
var state_51218__$1 = state_51218;
if(cljs.core.truth_(inst_51160)){
var statearr_51272_52929 = state_51218__$1;
(statearr_51272_52929[(1)] = (10));

} else {
var statearr_51273_52930 = state_51218__$1;
(statearr_51273_52930[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__49491__auto__ = null;
var cljs$core$async$state_machine__49491__auto____0 = (function (){
var statearr_51274 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_51274[(0)] = cljs$core$async$state_machine__49491__auto__);

(statearr_51274[(1)] = (1));

return statearr_51274;
});
var cljs$core$async$state_machine__49491__auto____1 = (function (state_51218){
while(true){
var ret_value__49492__auto__ = (function (){try{while(true){
var result__49493__auto__ = switch__49490__auto__(state_51218);
if(cljs.core.keyword_identical_QMARK_(result__49493__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__49493__auto__;
}
break;
}
}catch (e51275){var ex__49494__auto__ = e51275;
var statearr_51276_52931 = state_51218;
(statearr_51276_52931[(2)] = ex__49494__auto__);


if(cljs.core.seq((state_51218[(4)]))){
var statearr_51278_52936 = state_51218;
(statearr_51278_52936[(1)] = cljs.core.first((state_51218[(4)])));

} else {
throw ex__49494__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__49492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52937 = state_51218;
state_51218 = G__52937;
continue;
} else {
return ret_value__49492__auto__;
}
break;
}
});
cljs$core$async$state_machine__49491__auto__ = function(state_51218){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__49491__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__49491__auto____1.call(this,state_51218);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__49491__auto____0;
cljs$core$async$state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__49491__auto____1;
return cljs$core$async$state_machine__49491__auto__;
})()
})();
var state__49701__auto__ = (function (){var statearr_51280 = f__49700__auto__();
(statearr_51280[(6)] = c__49699__auto___52854);

return statearr_51280;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__49701__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__51282 = arguments.length;
switch (G__51282) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__51287 = arguments.length;
switch (G__51287) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__51289 = arguments.length;
switch (G__51289) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_(out);
} else {
var c__49699__auto___52944 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__49700__auto__ = (function (){var switch__49490__auto__ = (function (state_51332){
var state_val_51333 = (state_51332[(1)]);
if((state_val_51333 === (7))){
var state_51332__$1 = state_51332;
var statearr_51334_52946 = state_51332__$1;
(statearr_51334_52946[(2)] = null);

(statearr_51334_52946[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51333 === (1))){
var state_51332__$1 = state_51332;
var statearr_51335_52947 = state_51332__$1;
(statearr_51335_52947[(2)] = null);

(statearr_51335_52947[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51333 === (4))){
var inst_51293 = (state_51332[(7)]);
var inst_51292 = (state_51332[(8)]);
var inst_51295 = (inst_51293 < inst_51292);
var state_51332__$1 = state_51332;
if(cljs.core.truth_(inst_51295)){
var statearr_51336_52948 = state_51332__$1;
(statearr_51336_52948[(1)] = (6));

} else {
var statearr_51337_52949 = state_51332__$1;
(statearr_51337_52949[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51333 === (15))){
var inst_51318 = (state_51332[(9)]);
var inst_51323 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_51318);
var state_51332__$1 = state_51332;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_51332__$1,(17),out,inst_51323);
} else {
if((state_val_51333 === (13))){
var inst_51318 = (state_51332[(9)]);
var inst_51318__$1 = (state_51332[(2)]);
var inst_51319 = cljs.core.some(cljs.core.nil_QMARK_,inst_51318__$1);
var state_51332__$1 = (function (){var statearr_51339 = state_51332;
(statearr_51339[(9)] = inst_51318__$1);

return statearr_51339;
})();
if(cljs.core.truth_(inst_51319)){
var statearr_51340_52955 = state_51332__$1;
(statearr_51340_52955[(1)] = (14));

} else {
var statearr_51341_52956 = state_51332__$1;
(statearr_51341_52956[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51333 === (6))){
var state_51332__$1 = state_51332;
var statearr_51342_52957 = state_51332__$1;
(statearr_51342_52957[(2)] = null);

(statearr_51342_52957[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51333 === (17))){
var inst_51325 = (state_51332[(2)]);
var state_51332__$1 = (function (){var statearr_51344 = state_51332;
(statearr_51344[(10)] = inst_51325);

return statearr_51344;
})();
var statearr_51345_52964 = state_51332__$1;
(statearr_51345_52964[(2)] = null);

(statearr_51345_52964[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51333 === (3))){
var inst_51330 = (state_51332[(2)]);
var state_51332__$1 = state_51332;
return cljs.core.async.impl.ioc_helpers.return_chan(state_51332__$1,inst_51330);
} else {
if((state_val_51333 === (12))){
var _ = (function (){var statearr_51349 = state_51332;
(statearr_51349[(4)] = cljs.core.rest((state_51332[(4)])));

return statearr_51349;
})();
var state_51332__$1 = state_51332;
var ex51343 = (state_51332__$1[(2)]);
var statearr_51350_52972 = state_51332__$1;
(statearr_51350_52972[(5)] = ex51343);


if((ex51343 instanceof Object)){
var statearr_51351_52973 = state_51332__$1;
(statearr_51351_52973[(1)] = (11));

(statearr_51351_52973[(5)] = null);

} else {
throw ex51343;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51333 === (2))){
var inst_51291 = cljs.core.reset_BANG_(dctr,cnt);
var inst_51292 = cnt;
var inst_51293 = (0);
var state_51332__$1 = (function (){var statearr_51352 = state_51332;
(statearr_51352[(11)] = inst_51291);

(statearr_51352[(8)] = inst_51292);

(statearr_51352[(7)] = inst_51293);

return statearr_51352;
})();
var statearr_51357_52974 = state_51332__$1;
(statearr_51357_52974[(2)] = null);

(statearr_51357_52974[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51333 === (11))){
var inst_51297 = (state_51332[(2)]);
var inst_51298 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_51332__$1 = (function (){var statearr_51358 = state_51332;
(statearr_51358[(12)] = inst_51297);

return statearr_51358;
})();
var statearr_51359_52985 = state_51332__$1;
(statearr_51359_52985[(2)] = inst_51298);

(statearr_51359_52985[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51333 === (9))){
var inst_51293 = (state_51332[(7)]);
var _ = (function (){var statearr_51360 = state_51332;
(statearr_51360[(4)] = cljs.core.cons((12),(state_51332[(4)])));

return statearr_51360;
})();
var inst_51304 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_51293) : chs__$1.call(null, inst_51293));
var inst_51305 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_51293) : done.call(null, inst_51293));
var inst_51306 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_51304,inst_51305);
var ___$1 = (function (){var statearr_51361 = state_51332;
(statearr_51361[(4)] = cljs.core.rest((state_51332[(4)])));

return statearr_51361;
})();
var state_51332__$1 = state_51332;
var statearr_51362_52992 = state_51332__$1;
(statearr_51362_52992[(2)] = inst_51306);

(statearr_51362_52992[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51333 === (5))){
var inst_51316 = (state_51332[(2)]);
var state_51332__$1 = (function (){var statearr_51363 = state_51332;
(statearr_51363[(13)] = inst_51316);

return statearr_51363;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51332__$1,(13),dchan);
} else {
if((state_val_51333 === (14))){
var inst_51321 = cljs.core.async.close_BANG_(out);
var state_51332__$1 = state_51332;
var statearr_51364_52997 = state_51332__$1;
(statearr_51364_52997[(2)] = inst_51321);

(statearr_51364_52997[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51333 === (16))){
var inst_51328 = (state_51332[(2)]);
var state_51332__$1 = state_51332;
var statearr_51365_52998 = state_51332__$1;
(statearr_51365_52998[(2)] = inst_51328);

(statearr_51365_52998[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51333 === (10))){
var inst_51293 = (state_51332[(7)]);
var inst_51309 = (state_51332[(2)]);
var inst_51310 = (inst_51293 + (1));
var inst_51293__$1 = inst_51310;
var state_51332__$1 = (function (){var statearr_51366 = state_51332;
(statearr_51366[(14)] = inst_51309);

(statearr_51366[(7)] = inst_51293__$1);

return statearr_51366;
})();
var statearr_51367_53006 = state_51332__$1;
(statearr_51367_53006[(2)] = null);

(statearr_51367_53006[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51333 === (8))){
var inst_51314 = (state_51332[(2)]);
var state_51332__$1 = state_51332;
var statearr_51368_53007 = state_51332__$1;
(statearr_51368_53007[(2)] = inst_51314);

(statearr_51368_53007[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__49491__auto__ = null;
var cljs$core$async$state_machine__49491__auto____0 = (function (){
var statearr_51369 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_51369[(0)] = cljs$core$async$state_machine__49491__auto__);

(statearr_51369[(1)] = (1));

return statearr_51369;
});
var cljs$core$async$state_machine__49491__auto____1 = (function (state_51332){
while(true){
var ret_value__49492__auto__ = (function (){try{while(true){
var result__49493__auto__ = switch__49490__auto__(state_51332);
if(cljs.core.keyword_identical_QMARK_(result__49493__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__49493__auto__;
}
break;
}
}catch (e51370){var ex__49494__auto__ = e51370;
var statearr_51371_53008 = state_51332;
(statearr_51371_53008[(2)] = ex__49494__auto__);


if(cljs.core.seq((state_51332[(4)]))){
var statearr_51372_53009 = state_51332;
(statearr_51372_53009[(1)] = cljs.core.first((state_51332[(4)])));

} else {
throw ex__49494__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__49492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53013 = state_51332;
state_51332 = G__53013;
continue;
} else {
return ret_value__49492__auto__;
}
break;
}
});
cljs$core$async$state_machine__49491__auto__ = function(state_51332){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__49491__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__49491__auto____1.call(this,state_51332);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__49491__auto____0;
cljs$core$async$state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__49491__auto____1;
return cljs$core$async$state_machine__49491__auto__;
})()
})();
var state__49701__auto__ = (function (){var statearr_51373 = f__49700__auto__();
(statearr_51373[(6)] = c__49699__auto___52944);

return statearr_51373;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__49701__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__51396 = arguments.length;
switch (G__51396) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__49699__auto___53023 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__49700__auto__ = (function (){var switch__49490__auto__ = (function (state_51448){
var state_val_51449 = (state_51448[(1)]);
if((state_val_51449 === (7))){
var inst_51407 = (state_51448[(7)]);
var inst_51419 = (state_51448[(8)]);
var inst_51407__$1 = (state_51448[(2)]);
var inst_51419__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_51407__$1,(0),null);
var inst_51423 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_51407__$1,(1),null);
var inst_51424 = (inst_51419__$1 == null);
var state_51448__$1 = (function (){var statearr_51452 = state_51448;
(statearr_51452[(7)] = inst_51407__$1);

(statearr_51452[(8)] = inst_51419__$1);

(statearr_51452[(9)] = inst_51423);

return statearr_51452;
})();
if(cljs.core.truth_(inst_51424)){
var statearr_51453_53026 = state_51448__$1;
(statearr_51453_53026[(1)] = (8));

} else {
var statearr_51454_53028 = state_51448__$1;
(statearr_51454_53028[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51449 === (1))){
var inst_51397 = cljs.core.vec(chs);
var inst_51398 = inst_51397;
var state_51448__$1 = (function (){var statearr_51456 = state_51448;
(statearr_51456[(10)] = inst_51398);

return statearr_51456;
})();
var statearr_51457_53030 = state_51448__$1;
(statearr_51457_53030[(2)] = null);

(statearr_51457_53030[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51449 === (4))){
var inst_51398 = (state_51448[(10)]);
var state_51448__$1 = state_51448;
return cljs.core.async.ioc_alts_BANG_(state_51448__$1,(7),inst_51398);
} else {
if((state_val_51449 === (6))){
var inst_51444 = (state_51448[(2)]);
var state_51448__$1 = state_51448;
var statearr_51458_53031 = state_51448__$1;
(statearr_51458_53031[(2)] = inst_51444);

(statearr_51458_53031[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51449 === (3))){
var inst_51446 = (state_51448[(2)]);
var state_51448__$1 = state_51448;
return cljs.core.async.impl.ioc_helpers.return_chan(state_51448__$1,inst_51446);
} else {
if((state_val_51449 === (2))){
var inst_51398 = (state_51448[(10)]);
var inst_51400 = cljs.core.count(inst_51398);
var inst_51401 = (inst_51400 > (0));
var state_51448__$1 = state_51448;
if(cljs.core.truth_(inst_51401)){
var statearr_51460_53035 = state_51448__$1;
(statearr_51460_53035[(1)] = (4));

} else {
var statearr_51461_53036 = state_51448__$1;
(statearr_51461_53036[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51449 === (11))){
var inst_51398 = (state_51448[(10)]);
var inst_51437 = (state_51448[(2)]);
var tmp51459 = inst_51398;
var inst_51398__$1 = tmp51459;
var state_51448__$1 = (function (){var statearr_51465 = state_51448;
(statearr_51465[(11)] = inst_51437);

(statearr_51465[(10)] = inst_51398__$1);

return statearr_51465;
})();
var statearr_51466_53037 = state_51448__$1;
(statearr_51466_53037[(2)] = null);

(statearr_51466_53037[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51449 === (9))){
var inst_51419 = (state_51448[(8)]);
var state_51448__$1 = state_51448;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_51448__$1,(11),out,inst_51419);
} else {
if((state_val_51449 === (5))){
var inst_51442 = cljs.core.async.close_BANG_(out);
var state_51448__$1 = state_51448;
var statearr_51467_53038 = state_51448__$1;
(statearr_51467_53038[(2)] = inst_51442);

(statearr_51467_53038[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51449 === (10))){
var inst_51440 = (state_51448[(2)]);
var state_51448__$1 = state_51448;
var statearr_51468_53039 = state_51448__$1;
(statearr_51468_53039[(2)] = inst_51440);

(statearr_51468_53039[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51449 === (8))){
var inst_51398 = (state_51448[(10)]);
var inst_51407 = (state_51448[(7)]);
var inst_51419 = (state_51448[(8)]);
var inst_51423 = (state_51448[(9)]);
var inst_51432 = (function (){var cs = inst_51398;
var vec__51403 = inst_51407;
var v = inst_51419;
var c = inst_51423;
return (function (p1__51388_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__51388_SHARP_);
});
})();
var inst_51433 = cljs.core.filterv(inst_51432,inst_51398);
var inst_51398__$1 = inst_51433;
var state_51448__$1 = (function (){var statearr_51469 = state_51448;
(statearr_51469[(10)] = inst_51398__$1);

return statearr_51469;
})();
var statearr_51470_53043 = state_51448__$1;
(statearr_51470_53043[(2)] = null);

(statearr_51470_53043[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__49491__auto__ = null;
var cljs$core$async$state_machine__49491__auto____0 = (function (){
var statearr_51471 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_51471[(0)] = cljs$core$async$state_machine__49491__auto__);

(statearr_51471[(1)] = (1));

return statearr_51471;
});
var cljs$core$async$state_machine__49491__auto____1 = (function (state_51448){
while(true){
var ret_value__49492__auto__ = (function (){try{while(true){
var result__49493__auto__ = switch__49490__auto__(state_51448);
if(cljs.core.keyword_identical_QMARK_(result__49493__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__49493__auto__;
}
break;
}
}catch (e51472){var ex__49494__auto__ = e51472;
var statearr_51473_53050 = state_51448;
(statearr_51473_53050[(2)] = ex__49494__auto__);


if(cljs.core.seq((state_51448[(4)]))){
var statearr_51474_53051 = state_51448;
(statearr_51474_53051[(1)] = cljs.core.first((state_51448[(4)])));

} else {
throw ex__49494__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__49492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53053 = state_51448;
state_51448 = G__53053;
continue;
} else {
return ret_value__49492__auto__;
}
break;
}
});
cljs$core$async$state_machine__49491__auto__ = function(state_51448){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__49491__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__49491__auto____1.call(this,state_51448);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__49491__auto____0;
cljs$core$async$state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__49491__auto____1;
return cljs$core$async$state_machine__49491__auto__;
})()
})();
var state__49701__auto__ = (function (){var statearr_51475 = f__49700__auto__();
(statearr_51475[(6)] = c__49699__auto___53023);

return statearr_51475;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__49701__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__51477 = arguments.length;
switch (G__51477) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__49699__auto___53058 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__49700__auto__ = (function (){var switch__49490__auto__ = (function (state_51501){
var state_val_51502 = (state_51501[(1)]);
if((state_val_51502 === (7))){
var inst_51483 = (state_51501[(7)]);
var inst_51483__$1 = (state_51501[(2)]);
var inst_51484 = (inst_51483__$1 == null);
var inst_51485 = cljs.core.not(inst_51484);
var state_51501__$1 = (function (){var statearr_51503 = state_51501;
(statearr_51503[(7)] = inst_51483__$1);

return statearr_51503;
})();
if(inst_51485){
var statearr_51504_53063 = state_51501__$1;
(statearr_51504_53063[(1)] = (8));

} else {
var statearr_51505_53065 = state_51501__$1;
(statearr_51505_53065[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51502 === (1))){
var inst_51478 = (0);
var state_51501__$1 = (function (){var statearr_51506 = state_51501;
(statearr_51506[(8)] = inst_51478);

return statearr_51506;
})();
var statearr_51507_53069 = state_51501__$1;
(statearr_51507_53069[(2)] = null);

(statearr_51507_53069[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51502 === (4))){
var state_51501__$1 = state_51501;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51501__$1,(7),ch);
} else {
if((state_val_51502 === (6))){
var inst_51496 = (state_51501[(2)]);
var state_51501__$1 = state_51501;
var statearr_51508_53072 = state_51501__$1;
(statearr_51508_53072[(2)] = inst_51496);

(statearr_51508_53072[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51502 === (3))){
var inst_51498 = (state_51501[(2)]);
var inst_51499 = cljs.core.async.close_BANG_(out);
var state_51501__$1 = (function (){var statearr_51509 = state_51501;
(statearr_51509[(9)] = inst_51498);

return statearr_51509;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_51501__$1,inst_51499);
} else {
if((state_val_51502 === (2))){
var inst_51478 = (state_51501[(8)]);
var inst_51480 = (inst_51478 < n);
var state_51501__$1 = state_51501;
if(cljs.core.truth_(inst_51480)){
var statearr_51513_53078 = state_51501__$1;
(statearr_51513_53078[(1)] = (4));

} else {
var statearr_51516_53079 = state_51501__$1;
(statearr_51516_53079[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51502 === (11))){
var inst_51478 = (state_51501[(8)]);
var inst_51488 = (state_51501[(2)]);
var inst_51489 = (inst_51478 + (1));
var inst_51478__$1 = inst_51489;
var state_51501__$1 = (function (){var statearr_51520 = state_51501;
(statearr_51520[(10)] = inst_51488);

(statearr_51520[(8)] = inst_51478__$1);

return statearr_51520;
})();
var statearr_51521_53082 = state_51501__$1;
(statearr_51521_53082[(2)] = null);

(statearr_51521_53082[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51502 === (9))){
var state_51501__$1 = state_51501;
var statearr_51525_53086 = state_51501__$1;
(statearr_51525_53086[(2)] = null);

(statearr_51525_53086[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51502 === (5))){
var state_51501__$1 = state_51501;
var statearr_51526_53087 = state_51501__$1;
(statearr_51526_53087[(2)] = null);

(statearr_51526_53087[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51502 === (10))){
var inst_51493 = (state_51501[(2)]);
var state_51501__$1 = state_51501;
var statearr_51527_53090 = state_51501__$1;
(statearr_51527_53090[(2)] = inst_51493);

(statearr_51527_53090[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51502 === (8))){
var inst_51483 = (state_51501[(7)]);
var state_51501__$1 = state_51501;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_51501__$1,(11),out,inst_51483);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__49491__auto__ = null;
var cljs$core$async$state_machine__49491__auto____0 = (function (){
var statearr_51528 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_51528[(0)] = cljs$core$async$state_machine__49491__auto__);

(statearr_51528[(1)] = (1));

return statearr_51528;
});
var cljs$core$async$state_machine__49491__auto____1 = (function (state_51501){
while(true){
var ret_value__49492__auto__ = (function (){try{while(true){
var result__49493__auto__ = switch__49490__auto__(state_51501);
if(cljs.core.keyword_identical_QMARK_(result__49493__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__49493__auto__;
}
break;
}
}catch (e51529){var ex__49494__auto__ = e51529;
var statearr_51530_53095 = state_51501;
(statearr_51530_53095[(2)] = ex__49494__auto__);


if(cljs.core.seq((state_51501[(4)]))){
var statearr_51531_53096 = state_51501;
(statearr_51531_53096[(1)] = cljs.core.first((state_51501[(4)])));

} else {
throw ex__49494__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__49492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53097 = state_51501;
state_51501 = G__53097;
continue;
} else {
return ret_value__49492__auto__;
}
break;
}
});
cljs$core$async$state_machine__49491__auto__ = function(state_51501){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__49491__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__49491__auto____1.call(this,state_51501);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__49491__auto____0;
cljs$core$async$state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__49491__auto____1;
return cljs$core$async$state_machine__49491__auto__;
})()
})();
var state__49701__auto__ = (function (){var statearr_51532 = f__49700__auto__();
(statearr_51532[(6)] = c__49699__auto___53058);

return statearr_51532;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__49701__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async51537 = (function (f,ch,meta51535,_,fn1,meta51538){
this.f = f;
this.ch = ch;
this.meta51535 = meta51535;
this._ = _;
this.fn1 = fn1;
this.meta51538 = meta51538;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async51537.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_51539,meta51538__$1){
var self__ = this;
var _51539__$1 = this;
return (new cljs.core.async.t_cljs$core$async51537(self__.f,self__.ch,self__.meta51535,self__._,self__.fn1,meta51538__$1));
}));

(cljs.core.async.t_cljs$core$async51537.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_51539){
var self__ = this;
var _51539__$1 = this;
return self__.meta51538;
}));

(cljs.core.async.t_cljs$core$async51537.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async51537.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async51537.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async51537.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__51533_SHARP_){
var G__51542 = (((p1__51533_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__51533_SHARP_) : self__.f.call(null, p1__51533_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__51542) : f1.call(null, G__51542));
});
}));

(cljs.core.async.t_cljs$core$async51537.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta51535","meta51535",1638937878,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async51534","cljs.core.async/t_cljs$core$async51534",381340954,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta51538","meta51538",-1183072360,null)], null);
}));

(cljs.core.async.t_cljs$core$async51537.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async51537.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async51537");

(cljs.core.async.t_cljs$core$async51537.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async51537");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async51537.
 */
cljs.core.async.__GT_t_cljs$core$async51537 = (function cljs$core$async$__GT_t_cljs$core$async51537(f,ch,meta51535,_,fn1,meta51538){
return (new cljs.core.async.t_cljs$core$async51537(f,ch,meta51535,_,fn1,meta51538));
});



/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async51534 = (function (f,ch,meta51535){
this.f = f;
this.ch = ch;
this.meta51535 = meta51535;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async51534.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_51536,meta51535__$1){
var self__ = this;
var _51536__$1 = this;
return (new cljs.core.async.t_cljs$core$async51534(self__.f,self__.ch,meta51535__$1));
}));

(cljs.core.async.t_cljs$core$async51534.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_51536){
var self__ = this;
var _51536__$1 = this;
return self__.meta51535;
}));

(cljs.core.async.t_cljs$core$async51534.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async51534.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async51534.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async51534.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async51534.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(new cljs.core.async.t_cljs$core$async51537(self__.f,self__.ch,self__.meta51535,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY)));
if(cljs.core.truth_((function (){var and__5000__auto__ = ret;
if(cljs.core.truth_(and__5000__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__5000__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__51547 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__51547) : self__.f.call(null, G__51547));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async51534.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async51534.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async51534.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta51535","meta51535",1638937878,null)], null);
}));

(cljs.core.async.t_cljs$core$async51534.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async51534.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async51534");

(cljs.core.async.t_cljs$core$async51534.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async51534");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async51534.
 */
cljs.core.async.__GT_t_cljs$core$async51534 = (function cljs$core$async$__GT_t_cljs$core$async51534(f,ch,meta51535){
return (new cljs.core.async.t_cljs$core$async51534(f,ch,meta51535));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
return (new cljs.core.async.t_cljs$core$async51534(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async51550 = (function (f,ch,meta51551){
this.f = f;
this.ch = ch;
this.meta51551 = meta51551;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async51550.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_51552,meta51551__$1){
var self__ = this;
var _51552__$1 = this;
return (new cljs.core.async.t_cljs$core$async51550(self__.f,self__.ch,meta51551__$1));
}));

(cljs.core.async.t_cljs$core$async51550.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_51552){
var self__ = this;
var _51552__$1 = this;
return self__.meta51551;
}));

(cljs.core.async.t_cljs$core$async51550.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async51550.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async51550.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async51550.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async51550.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async51550.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null, val)),fn1);
}));

(cljs.core.async.t_cljs$core$async51550.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta51551","meta51551",-2093087765,null)], null);
}));

(cljs.core.async.t_cljs$core$async51550.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async51550.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async51550");

(cljs.core.async.t_cljs$core$async51550.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async51550");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async51550.
 */
cljs.core.async.__GT_t_cljs$core$async51550 = (function cljs$core$async$__GT_t_cljs$core$async51550(f,ch,meta51551){
return (new cljs.core.async.t_cljs$core$async51550(f,ch,meta51551));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
return (new cljs.core.async.t_cljs$core$async51550(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async51556 = (function (p,ch,meta51557){
this.p = p;
this.ch = ch;
this.meta51557 = meta51557;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async51556.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_51558,meta51557__$1){
var self__ = this;
var _51558__$1 = this;
return (new cljs.core.async.t_cljs$core$async51556(self__.p,self__.ch,meta51557__$1));
}));

(cljs.core.async.t_cljs$core$async51556.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_51558){
var self__ = this;
var _51558__$1 = this;
return self__.meta51557;
}));

(cljs.core.async.t_cljs$core$async51556.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async51556.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async51556.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async51556.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async51556.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async51556.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async51556.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null, val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async51556.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta51557","meta51557",1562390934,null)], null);
}));

(cljs.core.async.t_cljs$core$async51556.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async51556.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async51556");

(cljs.core.async.t_cljs$core$async51556.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async51556");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async51556.
 */
cljs.core.async.__GT_t_cljs$core$async51556 = (function cljs$core$async$__GT_t_cljs$core$async51556(p,ch,meta51557){
return (new cljs.core.async.t_cljs$core$async51556(p,ch,meta51557));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
return (new cljs.core.async.t_cljs$core$async51556(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__51580 = arguments.length;
switch (G__51580) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__49699__auto___53156 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__49700__auto__ = (function (){var switch__49490__auto__ = (function (state_51607){
var state_val_51608 = (state_51607[(1)]);
if((state_val_51608 === (7))){
var inst_51603 = (state_51607[(2)]);
var state_51607__$1 = state_51607;
var statearr_51619_53163 = state_51607__$1;
(statearr_51619_53163[(2)] = inst_51603);

(statearr_51619_53163[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51608 === (1))){
var state_51607__$1 = state_51607;
var statearr_51624_53168 = state_51607__$1;
(statearr_51624_53168[(2)] = null);

(statearr_51624_53168[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51608 === (4))){
var inst_51586 = (state_51607[(7)]);
var inst_51586__$1 = (state_51607[(2)]);
var inst_51587 = (inst_51586__$1 == null);
var state_51607__$1 = (function (){var statearr_51625 = state_51607;
(statearr_51625[(7)] = inst_51586__$1);

return statearr_51625;
})();
if(cljs.core.truth_(inst_51587)){
var statearr_51626_53172 = state_51607__$1;
(statearr_51626_53172[(1)] = (5));

} else {
var statearr_51627_53173 = state_51607__$1;
(statearr_51627_53173[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51608 === (6))){
var inst_51586 = (state_51607[(7)]);
var inst_51591 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_51586) : p.call(null, inst_51586));
var state_51607__$1 = state_51607;
if(cljs.core.truth_(inst_51591)){
var statearr_51630_53174 = state_51607__$1;
(statearr_51630_53174[(1)] = (8));

} else {
var statearr_51631_53175 = state_51607__$1;
(statearr_51631_53175[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51608 === (3))){
var inst_51605 = (state_51607[(2)]);
var state_51607__$1 = state_51607;
return cljs.core.async.impl.ioc_helpers.return_chan(state_51607__$1,inst_51605);
} else {
if((state_val_51608 === (2))){
var state_51607__$1 = state_51607;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51607__$1,(4),ch);
} else {
if((state_val_51608 === (11))){
var inst_51597 = (state_51607[(2)]);
var state_51607__$1 = state_51607;
var statearr_51632_53181 = state_51607__$1;
(statearr_51632_53181[(2)] = inst_51597);

(statearr_51632_53181[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51608 === (9))){
var state_51607__$1 = state_51607;
var statearr_51633_53187 = state_51607__$1;
(statearr_51633_53187[(2)] = null);

(statearr_51633_53187[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51608 === (5))){
var inst_51589 = cljs.core.async.close_BANG_(out);
var state_51607__$1 = state_51607;
var statearr_51634_53191 = state_51607__$1;
(statearr_51634_53191[(2)] = inst_51589);

(statearr_51634_53191[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51608 === (10))){
var inst_51600 = (state_51607[(2)]);
var state_51607__$1 = (function (){var statearr_51635 = state_51607;
(statearr_51635[(8)] = inst_51600);

return statearr_51635;
})();
var statearr_51636_53193 = state_51607__$1;
(statearr_51636_53193[(2)] = null);

(statearr_51636_53193[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51608 === (8))){
var inst_51586 = (state_51607[(7)]);
var state_51607__$1 = state_51607;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_51607__$1,(11),out,inst_51586);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__49491__auto__ = null;
var cljs$core$async$state_machine__49491__auto____0 = (function (){
var statearr_51637 = [null,null,null,null,null,null,null,null,null];
(statearr_51637[(0)] = cljs$core$async$state_machine__49491__auto__);

(statearr_51637[(1)] = (1));

return statearr_51637;
});
var cljs$core$async$state_machine__49491__auto____1 = (function (state_51607){
while(true){
var ret_value__49492__auto__ = (function (){try{while(true){
var result__49493__auto__ = switch__49490__auto__(state_51607);
if(cljs.core.keyword_identical_QMARK_(result__49493__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__49493__auto__;
}
break;
}
}catch (e51638){var ex__49494__auto__ = e51638;
var statearr_51639_53199 = state_51607;
(statearr_51639_53199[(2)] = ex__49494__auto__);


if(cljs.core.seq((state_51607[(4)]))){
var statearr_51640_53200 = state_51607;
(statearr_51640_53200[(1)] = cljs.core.first((state_51607[(4)])));

} else {
throw ex__49494__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__49492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53201 = state_51607;
state_51607 = G__53201;
continue;
} else {
return ret_value__49492__auto__;
}
break;
}
});
cljs$core$async$state_machine__49491__auto__ = function(state_51607){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__49491__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__49491__auto____1.call(this,state_51607);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__49491__auto____0;
cljs$core$async$state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__49491__auto____1;
return cljs$core$async$state_machine__49491__auto__;
})()
})();
var state__49701__auto__ = (function (){var statearr_51641 = f__49700__auto__();
(statearr_51641[(6)] = c__49699__auto___53156);

return statearr_51641;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__49701__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__51643 = arguments.length;
switch (G__51643) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__49699__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__49700__auto__ = (function (){var switch__49490__auto__ = (function (state_51707){
var state_val_51708 = (state_51707[(1)]);
if((state_val_51708 === (7))){
var inst_51703 = (state_51707[(2)]);
var state_51707__$1 = state_51707;
var statearr_51720_53205 = state_51707__$1;
(statearr_51720_53205[(2)] = inst_51703);

(statearr_51720_53205[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51708 === (20))){
var inst_51671 = (state_51707[(7)]);
var inst_51684 = (state_51707[(2)]);
var inst_51685 = cljs.core.next(inst_51671);
var inst_51657 = inst_51685;
var inst_51658 = null;
var inst_51659 = (0);
var inst_51660 = (0);
var state_51707__$1 = (function (){var statearr_51721 = state_51707;
(statearr_51721[(8)] = inst_51684);

(statearr_51721[(9)] = inst_51657);

(statearr_51721[(10)] = inst_51658);

(statearr_51721[(11)] = inst_51659);

(statearr_51721[(12)] = inst_51660);

return statearr_51721;
})();
var statearr_51723_53209 = state_51707__$1;
(statearr_51723_53209[(2)] = null);

(statearr_51723_53209[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51708 === (1))){
var state_51707__$1 = state_51707;
var statearr_51724_53210 = state_51707__$1;
(statearr_51724_53210[(2)] = null);

(statearr_51724_53210[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51708 === (4))){
var inst_51646 = (state_51707[(13)]);
var inst_51646__$1 = (state_51707[(2)]);
var inst_51647 = (inst_51646__$1 == null);
var state_51707__$1 = (function (){var statearr_51726 = state_51707;
(statearr_51726[(13)] = inst_51646__$1);

return statearr_51726;
})();
if(cljs.core.truth_(inst_51647)){
var statearr_51727_53211 = state_51707__$1;
(statearr_51727_53211[(1)] = (5));

} else {
var statearr_51728_53212 = state_51707__$1;
(statearr_51728_53212[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51708 === (15))){
var state_51707__$1 = state_51707;
var statearr_51732_53213 = state_51707__$1;
(statearr_51732_53213[(2)] = null);

(statearr_51732_53213[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51708 === (21))){
var state_51707__$1 = state_51707;
var statearr_51733_53215 = state_51707__$1;
(statearr_51733_53215[(2)] = null);

(statearr_51733_53215[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51708 === (13))){
var inst_51660 = (state_51707[(12)]);
var inst_51657 = (state_51707[(9)]);
var inst_51658 = (state_51707[(10)]);
var inst_51659 = (state_51707[(11)]);
var inst_51667 = (state_51707[(2)]);
var inst_51668 = (inst_51660 + (1));
var tmp51729 = inst_51658;
var tmp51730 = inst_51659;
var tmp51731 = inst_51657;
var inst_51657__$1 = tmp51731;
var inst_51658__$1 = tmp51729;
var inst_51659__$1 = tmp51730;
var inst_51660__$1 = inst_51668;
var state_51707__$1 = (function (){var statearr_51734 = state_51707;
(statearr_51734[(14)] = inst_51667);

(statearr_51734[(9)] = inst_51657__$1);

(statearr_51734[(10)] = inst_51658__$1);

(statearr_51734[(11)] = inst_51659__$1);

(statearr_51734[(12)] = inst_51660__$1);

return statearr_51734;
})();
var statearr_51735_53220 = state_51707__$1;
(statearr_51735_53220[(2)] = null);

(statearr_51735_53220[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51708 === (22))){
var state_51707__$1 = state_51707;
var statearr_51736_53225 = state_51707__$1;
(statearr_51736_53225[(2)] = null);

(statearr_51736_53225[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51708 === (6))){
var inst_51646 = (state_51707[(13)]);
var inst_51655 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_51646) : f.call(null, inst_51646));
var inst_51656 = cljs.core.seq(inst_51655);
var inst_51657 = inst_51656;
var inst_51658 = null;
var inst_51659 = (0);
var inst_51660 = (0);
var state_51707__$1 = (function (){var statearr_51737 = state_51707;
(statearr_51737[(9)] = inst_51657);

(statearr_51737[(10)] = inst_51658);

(statearr_51737[(11)] = inst_51659);

(statearr_51737[(12)] = inst_51660);

return statearr_51737;
})();
var statearr_51738_53228 = state_51707__$1;
(statearr_51738_53228[(2)] = null);

(statearr_51738_53228[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51708 === (17))){
var inst_51671 = (state_51707[(7)]);
var inst_51677 = cljs.core.chunk_first(inst_51671);
var inst_51678 = cljs.core.chunk_rest(inst_51671);
var inst_51679 = cljs.core.count(inst_51677);
var inst_51657 = inst_51678;
var inst_51658 = inst_51677;
var inst_51659 = inst_51679;
var inst_51660 = (0);
var state_51707__$1 = (function (){var statearr_51739 = state_51707;
(statearr_51739[(9)] = inst_51657);

(statearr_51739[(10)] = inst_51658);

(statearr_51739[(11)] = inst_51659);

(statearr_51739[(12)] = inst_51660);

return statearr_51739;
})();
var statearr_51740_53237 = state_51707__$1;
(statearr_51740_53237[(2)] = null);

(statearr_51740_53237[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51708 === (3))){
var inst_51705 = (state_51707[(2)]);
var state_51707__$1 = state_51707;
return cljs.core.async.impl.ioc_helpers.return_chan(state_51707__$1,inst_51705);
} else {
if((state_val_51708 === (12))){
var inst_51693 = (state_51707[(2)]);
var state_51707__$1 = state_51707;
var statearr_51743_53240 = state_51707__$1;
(statearr_51743_53240[(2)] = inst_51693);

(statearr_51743_53240[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51708 === (2))){
var state_51707__$1 = state_51707;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51707__$1,(4),in$);
} else {
if((state_val_51708 === (23))){
var inst_51701 = (state_51707[(2)]);
var state_51707__$1 = state_51707;
var statearr_51745_53243 = state_51707__$1;
(statearr_51745_53243[(2)] = inst_51701);

(statearr_51745_53243[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51708 === (19))){
var inst_51688 = (state_51707[(2)]);
var state_51707__$1 = state_51707;
var statearr_51746_53247 = state_51707__$1;
(statearr_51746_53247[(2)] = inst_51688);

(statearr_51746_53247[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51708 === (11))){
var inst_51657 = (state_51707[(9)]);
var inst_51671 = (state_51707[(7)]);
var inst_51671__$1 = cljs.core.seq(inst_51657);
var state_51707__$1 = (function (){var statearr_51747 = state_51707;
(statearr_51747[(7)] = inst_51671__$1);

return statearr_51747;
})();
if(inst_51671__$1){
var statearr_51748_53257 = state_51707__$1;
(statearr_51748_53257[(1)] = (14));

} else {
var statearr_51749_53259 = state_51707__$1;
(statearr_51749_53259[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51708 === (9))){
var inst_51695 = (state_51707[(2)]);
var inst_51696 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_51707__$1 = (function (){var statearr_51750 = state_51707;
(statearr_51750[(15)] = inst_51695);

return statearr_51750;
})();
if(cljs.core.truth_(inst_51696)){
var statearr_51751_53262 = state_51707__$1;
(statearr_51751_53262[(1)] = (21));

} else {
var statearr_51752_53263 = state_51707__$1;
(statearr_51752_53263[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51708 === (5))){
var inst_51649 = cljs.core.async.close_BANG_(out);
var state_51707__$1 = state_51707;
var statearr_51753_53265 = state_51707__$1;
(statearr_51753_53265[(2)] = inst_51649);

(statearr_51753_53265[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51708 === (14))){
var inst_51671 = (state_51707[(7)]);
var inst_51675 = cljs.core.chunked_seq_QMARK_(inst_51671);
var state_51707__$1 = state_51707;
if(inst_51675){
var statearr_51763_53271 = state_51707__$1;
(statearr_51763_53271[(1)] = (17));

} else {
var statearr_51764_53272 = state_51707__$1;
(statearr_51764_53272[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51708 === (16))){
var inst_51691 = (state_51707[(2)]);
var state_51707__$1 = state_51707;
var statearr_51765_53274 = state_51707__$1;
(statearr_51765_53274[(2)] = inst_51691);

(statearr_51765_53274[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51708 === (10))){
var inst_51658 = (state_51707[(10)]);
var inst_51660 = (state_51707[(12)]);
var inst_51665 = cljs.core._nth(inst_51658,inst_51660);
var state_51707__$1 = state_51707;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_51707__$1,(13),out,inst_51665);
} else {
if((state_val_51708 === (18))){
var inst_51671 = (state_51707[(7)]);
var inst_51682 = cljs.core.first(inst_51671);
var state_51707__$1 = state_51707;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_51707__$1,(20),out,inst_51682);
} else {
if((state_val_51708 === (8))){
var inst_51660 = (state_51707[(12)]);
var inst_51659 = (state_51707[(11)]);
var inst_51662 = (inst_51660 < inst_51659);
var inst_51663 = inst_51662;
var state_51707__$1 = state_51707;
if(cljs.core.truth_(inst_51663)){
var statearr_51767_53283 = state_51707__$1;
(statearr_51767_53283[(1)] = (10));

} else {
var statearr_51768_53284 = state_51707__$1;
(statearr_51768_53284[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__49491__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__49491__auto____0 = (function (){
var statearr_51769 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_51769[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__49491__auto__);

(statearr_51769[(1)] = (1));

return statearr_51769;
});
var cljs$core$async$mapcat_STAR__$_state_machine__49491__auto____1 = (function (state_51707){
while(true){
var ret_value__49492__auto__ = (function (){try{while(true){
var result__49493__auto__ = switch__49490__auto__(state_51707);
if(cljs.core.keyword_identical_QMARK_(result__49493__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__49493__auto__;
}
break;
}
}catch (e51770){var ex__49494__auto__ = e51770;
var statearr_51771_53295 = state_51707;
(statearr_51771_53295[(2)] = ex__49494__auto__);


if(cljs.core.seq((state_51707[(4)]))){
var statearr_51772_53298 = state_51707;
(statearr_51772_53298[(1)] = cljs.core.first((state_51707[(4)])));

} else {
throw ex__49494__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__49492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53299 = state_51707;
state_51707 = G__53299;
continue;
} else {
return ret_value__49492__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__49491__auto__ = function(state_51707){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__49491__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__49491__auto____1.call(this,state_51707);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__49491__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__49491__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__49491__auto__;
})()
})();
var state__49701__auto__ = (function (){var statearr_51773 = f__49700__auto__();
(statearr_51773[(6)] = c__49699__auto__);

return statearr_51773;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__49701__auto__);
}));

return c__49699__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__51775 = arguments.length;
switch (G__51775) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__51779 = arguments.length;
switch (G__51779) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__51783 = arguments.length;
switch (G__51783) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__49699__auto___53324 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__49700__auto__ = (function (){var switch__49490__auto__ = (function (state_51814){
var state_val_51815 = (state_51814[(1)]);
if((state_val_51815 === (7))){
var inst_51803 = (state_51814[(2)]);
var state_51814__$1 = state_51814;
var statearr_51817_53325 = state_51814__$1;
(statearr_51817_53325[(2)] = inst_51803);

(statearr_51817_53325[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51815 === (1))){
var inst_51784 = null;
var state_51814__$1 = (function (){var statearr_51818 = state_51814;
(statearr_51818[(7)] = inst_51784);

return statearr_51818;
})();
var statearr_51819_53327 = state_51814__$1;
(statearr_51819_53327[(2)] = null);

(statearr_51819_53327[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51815 === (4))){
var inst_51787 = (state_51814[(8)]);
var inst_51787__$1 = (state_51814[(2)]);
var inst_51788 = (inst_51787__$1 == null);
var inst_51789 = cljs.core.not(inst_51788);
var state_51814__$1 = (function (){var statearr_51829 = state_51814;
(statearr_51829[(8)] = inst_51787__$1);

return statearr_51829;
})();
if(inst_51789){
var statearr_51830_53331 = state_51814__$1;
(statearr_51830_53331[(1)] = (5));

} else {
var statearr_51831_53332 = state_51814__$1;
(statearr_51831_53332[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51815 === (6))){
var state_51814__$1 = state_51814;
var statearr_51835_53333 = state_51814__$1;
(statearr_51835_53333[(2)] = null);

(statearr_51835_53333[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51815 === (3))){
var inst_51811 = (state_51814[(2)]);
var inst_51812 = cljs.core.async.close_BANG_(out);
var state_51814__$1 = (function (){var statearr_51837 = state_51814;
(statearr_51837[(9)] = inst_51811);

return statearr_51837;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_51814__$1,inst_51812);
} else {
if((state_val_51815 === (2))){
var state_51814__$1 = state_51814;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51814__$1,(4),ch);
} else {
if((state_val_51815 === (11))){
var inst_51787 = (state_51814[(8)]);
var inst_51796 = (state_51814[(2)]);
var inst_51784 = inst_51787;
var state_51814__$1 = (function (){var statearr_51845 = state_51814;
(statearr_51845[(10)] = inst_51796);

(statearr_51845[(7)] = inst_51784);

return statearr_51845;
})();
var statearr_51846_53335 = state_51814__$1;
(statearr_51846_53335[(2)] = null);

(statearr_51846_53335[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51815 === (9))){
var inst_51787 = (state_51814[(8)]);
var state_51814__$1 = state_51814;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_51814__$1,(11),out,inst_51787);
} else {
if((state_val_51815 === (5))){
var inst_51787 = (state_51814[(8)]);
var inst_51784 = (state_51814[(7)]);
var inst_51791 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_51787,inst_51784);
var state_51814__$1 = state_51814;
if(inst_51791){
var statearr_51849_53338 = state_51814__$1;
(statearr_51849_53338[(1)] = (8));

} else {
var statearr_51850_53339 = state_51814__$1;
(statearr_51850_53339[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51815 === (10))){
var inst_51799 = (state_51814[(2)]);
var state_51814__$1 = state_51814;
var statearr_51851_53340 = state_51814__$1;
(statearr_51851_53340[(2)] = inst_51799);

(statearr_51851_53340[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51815 === (8))){
var inst_51784 = (state_51814[(7)]);
var tmp51847 = inst_51784;
var inst_51784__$1 = tmp51847;
var state_51814__$1 = (function (){var statearr_51852 = state_51814;
(statearr_51852[(7)] = inst_51784__$1);

return statearr_51852;
})();
var statearr_51853_53341 = state_51814__$1;
(statearr_51853_53341[(2)] = null);

(statearr_51853_53341[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__49491__auto__ = null;
var cljs$core$async$state_machine__49491__auto____0 = (function (){
var statearr_51856 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_51856[(0)] = cljs$core$async$state_machine__49491__auto__);

(statearr_51856[(1)] = (1));

return statearr_51856;
});
var cljs$core$async$state_machine__49491__auto____1 = (function (state_51814){
while(true){
var ret_value__49492__auto__ = (function (){try{while(true){
var result__49493__auto__ = switch__49490__auto__(state_51814);
if(cljs.core.keyword_identical_QMARK_(result__49493__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__49493__auto__;
}
break;
}
}catch (e51860){var ex__49494__auto__ = e51860;
var statearr_51861_53342 = state_51814;
(statearr_51861_53342[(2)] = ex__49494__auto__);


if(cljs.core.seq((state_51814[(4)]))){
var statearr_51864_53343 = state_51814;
(statearr_51864_53343[(1)] = cljs.core.first((state_51814[(4)])));

} else {
throw ex__49494__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__49492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53344 = state_51814;
state_51814 = G__53344;
continue;
} else {
return ret_value__49492__auto__;
}
break;
}
});
cljs$core$async$state_machine__49491__auto__ = function(state_51814){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__49491__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__49491__auto____1.call(this,state_51814);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__49491__auto____0;
cljs$core$async$state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__49491__auto____1;
return cljs$core$async$state_machine__49491__auto__;
})()
})();
var state__49701__auto__ = (function (){var statearr_51865 = f__49700__auto__();
(statearr_51865[(6)] = c__49699__auto___53324);

return statearr_51865;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__49701__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__51871 = arguments.length;
switch (G__51871) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__49699__auto___53346 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__49700__auto__ = (function (){var switch__49490__auto__ = (function (state_51910){
var state_val_51911 = (state_51910[(1)]);
if((state_val_51911 === (7))){
var inst_51906 = (state_51910[(2)]);
var state_51910__$1 = state_51910;
var statearr_51913_53347 = state_51910__$1;
(statearr_51913_53347[(2)] = inst_51906);

(statearr_51913_53347[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51911 === (1))){
var inst_51873 = (new Array(n));
var inst_51874 = inst_51873;
var inst_51875 = (0);
var state_51910__$1 = (function (){var statearr_51921 = state_51910;
(statearr_51921[(7)] = inst_51874);

(statearr_51921[(8)] = inst_51875);

return statearr_51921;
})();
var statearr_51922_53348 = state_51910__$1;
(statearr_51922_53348[(2)] = null);

(statearr_51922_53348[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51911 === (4))){
var inst_51878 = (state_51910[(9)]);
var inst_51878__$1 = (state_51910[(2)]);
var inst_51879 = (inst_51878__$1 == null);
var inst_51880 = cljs.core.not(inst_51879);
var state_51910__$1 = (function (){var statearr_51924 = state_51910;
(statearr_51924[(9)] = inst_51878__$1);

return statearr_51924;
})();
if(inst_51880){
var statearr_51925_53350 = state_51910__$1;
(statearr_51925_53350[(1)] = (5));

} else {
var statearr_51926_53351 = state_51910__$1;
(statearr_51926_53351[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51911 === (15))){
var inst_51900 = (state_51910[(2)]);
var state_51910__$1 = state_51910;
var statearr_51927_53352 = state_51910__$1;
(statearr_51927_53352[(2)] = inst_51900);

(statearr_51927_53352[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51911 === (13))){
var state_51910__$1 = state_51910;
var statearr_51928_53356 = state_51910__$1;
(statearr_51928_53356[(2)] = null);

(statearr_51928_53356[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51911 === (6))){
var inst_51875 = (state_51910[(8)]);
var inst_51896 = (inst_51875 > (0));
var state_51910__$1 = state_51910;
if(cljs.core.truth_(inst_51896)){
var statearr_51929_53365 = state_51910__$1;
(statearr_51929_53365[(1)] = (12));

} else {
var statearr_51932_53366 = state_51910__$1;
(statearr_51932_53366[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51911 === (3))){
var inst_51908 = (state_51910[(2)]);
var state_51910__$1 = state_51910;
return cljs.core.async.impl.ioc_helpers.return_chan(state_51910__$1,inst_51908);
} else {
if((state_val_51911 === (12))){
var inst_51874 = (state_51910[(7)]);
var inst_51898 = cljs.core.vec(inst_51874);
var state_51910__$1 = state_51910;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_51910__$1,(15),out,inst_51898);
} else {
if((state_val_51911 === (2))){
var state_51910__$1 = state_51910;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51910__$1,(4),ch);
} else {
if((state_val_51911 === (11))){
var inst_51890 = (state_51910[(2)]);
var inst_51891 = (new Array(n));
var inst_51874 = inst_51891;
var inst_51875 = (0);
var state_51910__$1 = (function (){var statearr_51935 = state_51910;
(statearr_51935[(10)] = inst_51890);

(statearr_51935[(7)] = inst_51874);

(statearr_51935[(8)] = inst_51875);

return statearr_51935;
})();
var statearr_51936_53379 = state_51910__$1;
(statearr_51936_53379[(2)] = null);

(statearr_51936_53379[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51911 === (9))){
var inst_51874 = (state_51910[(7)]);
var inst_51888 = cljs.core.vec(inst_51874);
var state_51910__$1 = state_51910;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_51910__$1,(11),out,inst_51888);
} else {
if((state_val_51911 === (5))){
var inst_51874 = (state_51910[(7)]);
var inst_51875 = (state_51910[(8)]);
var inst_51878 = (state_51910[(9)]);
var inst_51883 = (state_51910[(11)]);
var inst_51882 = (inst_51874[inst_51875] = inst_51878);
var inst_51883__$1 = (inst_51875 + (1));
var inst_51884 = (inst_51883__$1 < n);
var state_51910__$1 = (function (){var statearr_51938 = state_51910;
(statearr_51938[(12)] = inst_51882);

(statearr_51938[(11)] = inst_51883__$1);

return statearr_51938;
})();
if(cljs.core.truth_(inst_51884)){
var statearr_51939_53400 = state_51910__$1;
(statearr_51939_53400[(1)] = (8));

} else {
var statearr_51941_53401 = state_51910__$1;
(statearr_51941_53401[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51911 === (14))){
var inst_51903 = (state_51910[(2)]);
var inst_51904 = cljs.core.async.close_BANG_(out);
var state_51910__$1 = (function (){var statearr_51943 = state_51910;
(statearr_51943[(13)] = inst_51903);

return statearr_51943;
})();
var statearr_51944_53407 = state_51910__$1;
(statearr_51944_53407[(2)] = inst_51904);

(statearr_51944_53407[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51911 === (10))){
var inst_51894 = (state_51910[(2)]);
var state_51910__$1 = state_51910;
var statearr_51945_53409 = state_51910__$1;
(statearr_51945_53409[(2)] = inst_51894);

(statearr_51945_53409[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51911 === (8))){
var inst_51874 = (state_51910[(7)]);
var inst_51883 = (state_51910[(11)]);
var tmp51942 = inst_51874;
var inst_51874__$1 = tmp51942;
var inst_51875 = inst_51883;
var state_51910__$1 = (function (){var statearr_51946 = state_51910;
(statearr_51946[(7)] = inst_51874__$1);

(statearr_51946[(8)] = inst_51875);

return statearr_51946;
})();
var statearr_51947_53410 = state_51910__$1;
(statearr_51947_53410[(2)] = null);

(statearr_51947_53410[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__49491__auto__ = null;
var cljs$core$async$state_machine__49491__auto____0 = (function (){
var statearr_51948 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_51948[(0)] = cljs$core$async$state_machine__49491__auto__);

(statearr_51948[(1)] = (1));

return statearr_51948;
});
var cljs$core$async$state_machine__49491__auto____1 = (function (state_51910){
while(true){
var ret_value__49492__auto__ = (function (){try{while(true){
var result__49493__auto__ = switch__49490__auto__(state_51910);
if(cljs.core.keyword_identical_QMARK_(result__49493__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__49493__auto__;
}
break;
}
}catch (e51949){var ex__49494__auto__ = e51949;
var statearr_51950_53412 = state_51910;
(statearr_51950_53412[(2)] = ex__49494__auto__);


if(cljs.core.seq((state_51910[(4)]))){
var statearr_51951_53413 = state_51910;
(statearr_51951_53413[(1)] = cljs.core.first((state_51910[(4)])));

} else {
throw ex__49494__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__49492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53415 = state_51910;
state_51910 = G__53415;
continue;
} else {
return ret_value__49492__auto__;
}
break;
}
});
cljs$core$async$state_machine__49491__auto__ = function(state_51910){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__49491__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__49491__auto____1.call(this,state_51910);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__49491__auto____0;
cljs$core$async$state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__49491__auto____1;
return cljs$core$async$state_machine__49491__auto__;
})()
})();
var state__49701__auto__ = (function (){var statearr_51952 = f__49700__auto__();
(statearr_51952[(6)] = c__49699__auto___53346);

return statearr_51952;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__49701__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__51958 = arguments.length;
switch (G__51958) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__49699__auto___53418 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__49700__auto__ = (function (){var switch__49490__auto__ = (function (state_52013){
var state_val_52014 = (state_52013[(1)]);
if((state_val_52014 === (7))){
var inst_52009 = (state_52013[(2)]);
var state_52013__$1 = state_52013;
var statearr_52019_53423 = state_52013__$1;
(statearr_52019_53423[(2)] = inst_52009);

(statearr_52019_53423[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52014 === (1))){
var inst_51960 = [];
var inst_51961 = inst_51960;
var inst_51962 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_52013__$1 = (function (){var statearr_52020 = state_52013;
(statearr_52020[(7)] = inst_51961);

(statearr_52020[(8)] = inst_51962);

return statearr_52020;
})();
var statearr_52021_53424 = state_52013__$1;
(statearr_52021_53424[(2)] = null);

(statearr_52021_53424[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52014 === (4))){
var inst_51965 = (state_52013[(9)]);
var inst_51965__$1 = (state_52013[(2)]);
var inst_51972 = (inst_51965__$1 == null);
var inst_51973 = cljs.core.not(inst_51972);
var state_52013__$1 = (function (){var statearr_52028 = state_52013;
(statearr_52028[(9)] = inst_51965__$1);

return statearr_52028;
})();
if(inst_51973){
var statearr_52029_53430 = state_52013__$1;
(statearr_52029_53430[(1)] = (5));

} else {
var statearr_52030_53432 = state_52013__$1;
(statearr_52030_53432[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52014 === (15))){
var inst_51961 = (state_52013[(7)]);
var inst_52001 = cljs.core.vec(inst_51961);
var state_52013__$1 = state_52013;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_52013__$1,(18),out,inst_52001);
} else {
if((state_val_52014 === (13))){
var inst_51996 = (state_52013[(2)]);
var state_52013__$1 = state_52013;
var statearr_52037_53434 = state_52013__$1;
(statearr_52037_53434[(2)] = inst_51996);

(statearr_52037_53434[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52014 === (6))){
var inst_51961 = (state_52013[(7)]);
var inst_51998 = inst_51961.length;
var inst_51999 = (inst_51998 > (0));
var state_52013__$1 = state_52013;
if(cljs.core.truth_(inst_51999)){
var statearr_52038_53435 = state_52013__$1;
(statearr_52038_53435[(1)] = (15));

} else {
var statearr_52039_53436 = state_52013__$1;
(statearr_52039_53436[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52014 === (17))){
var inst_52006 = (state_52013[(2)]);
var inst_52007 = cljs.core.async.close_BANG_(out);
var state_52013__$1 = (function (){var statearr_52040 = state_52013;
(statearr_52040[(10)] = inst_52006);

return statearr_52040;
})();
var statearr_52042_53437 = state_52013__$1;
(statearr_52042_53437[(2)] = inst_52007);

(statearr_52042_53437[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52014 === (3))){
var inst_52011 = (state_52013[(2)]);
var state_52013__$1 = state_52013;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52013__$1,inst_52011);
} else {
if((state_val_52014 === (12))){
var inst_51961 = (state_52013[(7)]);
var inst_51986 = cljs.core.vec(inst_51961);
var state_52013__$1 = state_52013;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_52013__$1,(14),out,inst_51986);
} else {
if((state_val_52014 === (2))){
var state_52013__$1 = state_52013;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52013__$1,(4),ch);
} else {
if((state_val_52014 === (11))){
var inst_51961 = (state_52013[(7)]);
var inst_51965 = (state_52013[(9)]);
var inst_51975 = (state_52013[(11)]);
var inst_51983 = inst_51961.push(inst_51965);
var tmp52043 = inst_51961;
var inst_51961__$1 = tmp52043;
var inst_51962 = inst_51975;
var state_52013__$1 = (function (){var statearr_52045 = state_52013;
(statearr_52045[(12)] = inst_51983);

(statearr_52045[(7)] = inst_51961__$1);

(statearr_52045[(8)] = inst_51962);

return statearr_52045;
})();
var statearr_52046_53451 = state_52013__$1;
(statearr_52046_53451[(2)] = null);

(statearr_52046_53451[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52014 === (9))){
var inst_51962 = (state_52013[(8)]);
var inst_51979 = cljs.core.keyword_identical_QMARK_(inst_51962,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_52013__$1 = state_52013;
var statearr_52047_53453 = state_52013__$1;
(statearr_52047_53453[(2)] = inst_51979);

(statearr_52047_53453[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52014 === (5))){
var inst_51965 = (state_52013[(9)]);
var inst_51975 = (state_52013[(11)]);
var inst_51962 = (state_52013[(8)]);
var inst_51976 = (state_52013[(13)]);
var inst_51975__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_51965) : f.call(null, inst_51965));
var inst_51976__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_51975__$1,inst_51962);
var state_52013__$1 = (function (){var statearr_52053 = state_52013;
(statearr_52053[(11)] = inst_51975__$1);

(statearr_52053[(13)] = inst_51976__$1);

return statearr_52053;
})();
if(inst_51976__$1){
var statearr_52054_53462 = state_52013__$1;
(statearr_52054_53462[(1)] = (8));

} else {
var statearr_52060_53466 = state_52013__$1;
(statearr_52060_53466[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52014 === (14))){
var inst_51965 = (state_52013[(9)]);
var inst_51975 = (state_52013[(11)]);
var inst_51988 = (state_52013[(2)]);
var inst_51992 = [];
var inst_51993 = inst_51992.push(inst_51965);
var inst_51961 = inst_51992;
var inst_51962 = inst_51975;
var state_52013__$1 = (function (){var statearr_52061 = state_52013;
(statearr_52061[(14)] = inst_51988);

(statearr_52061[(15)] = inst_51993);

(statearr_52061[(7)] = inst_51961);

(statearr_52061[(8)] = inst_51962);

return statearr_52061;
})();
var statearr_52062_53489 = state_52013__$1;
(statearr_52062_53489[(2)] = null);

(statearr_52062_53489[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52014 === (16))){
var state_52013__$1 = state_52013;
var statearr_52063_53490 = state_52013__$1;
(statearr_52063_53490[(2)] = null);

(statearr_52063_53490[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52014 === (10))){
var inst_51981 = (state_52013[(2)]);
var state_52013__$1 = state_52013;
if(cljs.core.truth_(inst_51981)){
var statearr_52064_53491 = state_52013__$1;
(statearr_52064_53491[(1)] = (11));

} else {
var statearr_52066_53496 = state_52013__$1;
(statearr_52066_53496[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52014 === (18))){
var inst_52003 = (state_52013[(2)]);
var state_52013__$1 = state_52013;
var statearr_52067_53497 = state_52013__$1;
(statearr_52067_53497[(2)] = inst_52003);

(statearr_52067_53497[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52014 === (8))){
var inst_51976 = (state_52013[(13)]);
var state_52013__$1 = state_52013;
var statearr_52068_53499 = state_52013__$1;
(statearr_52068_53499[(2)] = inst_51976);

(statearr_52068_53499[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__49491__auto__ = null;
var cljs$core$async$state_machine__49491__auto____0 = (function (){
var statearr_52070 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_52070[(0)] = cljs$core$async$state_machine__49491__auto__);

(statearr_52070[(1)] = (1));

return statearr_52070;
});
var cljs$core$async$state_machine__49491__auto____1 = (function (state_52013){
while(true){
var ret_value__49492__auto__ = (function (){try{while(true){
var result__49493__auto__ = switch__49490__auto__(state_52013);
if(cljs.core.keyword_identical_QMARK_(result__49493__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__49493__auto__;
}
break;
}
}catch (e52076){var ex__49494__auto__ = e52076;
var statearr_52077_53504 = state_52013;
(statearr_52077_53504[(2)] = ex__49494__auto__);


if(cljs.core.seq((state_52013[(4)]))){
var statearr_52078_53505 = state_52013;
(statearr_52078_53505[(1)] = cljs.core.first((state_52013[(4)])));

} else {
throw ex__49494__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__49492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53507 = state_52013;
state_52013 = G__53507;
continue;
} else {
return ret_value__49492__auto__;
}
break;
}
});
cljs$core$async$state_machine__49491__auto__ = function(state_52013){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__49491__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__49491__auto____1.call(this,state_52013);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__49491__auto____0;
cljs$core$async$state_machine__49491__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__49491__auto____1;
return cljs$core$async$state_machine__49491__auto__;
})()
})();
var state__49701__auto__ = (function (){var statearr_52079 = f__49700__auto__();
(statearr_52079[(6)] = c__49699__auto___53418);

return statearr_52079;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__49701__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
