;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns utilis.let
  (:refer-clojure :exclude [when-let if-let])
  #?(:cljs (:require-macros [utilis.let])))

(declare assert-bindings)

(defmacro if-let
  ([bindings then]
   `(if-let ~bindings ~then nil))
  ([bindings then else]
   (assert-bindings bindings)
   (let [bindings (destructure bindings)]
     (if (not-empty bindings)
       (let [val# (second bindings)]
         `(clojure.core/if-let [~(first bindings) ~val#]
            (if-let ~(vec (drop 2 bindings)) ~then ~else)
            ~else))
       then))))

(defmacro when-let
  [bindings & body]
  `(if-let ~bindings (do ~@body)))


;;; Private

(defn- assert-bindings
  [bindings]
  (when-not (vector? bindings)
    (throw (ex-info "No binding vector provided" {})))
  (when-not (even? (count bindings))
    (throw (ex-info "Binding vector must have an even number of forms" {}))))
