;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns utilis.exception
  #?(:cljs (:require-macros [utilis.exception]))
  #?(:cljs (:require [utilis.js :as j])))

#?(:clj
   (defmacro throw-if
     [v]
     `(let [v# ~v] ; Ensure the 'v' is not evaluated more than once
        (cond-> v# (instance? #?(:clj Throwable
                                 :cljs js/Error) v#) throw))))

#?(:clj
   (defmacro with-exception->value
     [exception-mapping & body]
     `(try
        ~@body
        ~@(->> exception-mapping
               (partition 2)
               (map (fn [[exception val]]
                      `(catch ~exception _# ~val)))))))

(defn handle-uncaught
  [handler]
  #?(:clj
     (Thread/setDefaultUncaughtExceptionHandler
      (reify Thread$UncaughtExceptionHandler
        (uncaughtException [_ thread e]
          (handler thread e))))
     :cljs
     (j/call js/window :addEventListener "error"
             (fn [event] (handler (j/get event :error))))))
