;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns utilis.timer
  (:import [java.util.concurrent Future ScheduledThreadPoolExecutor TimeUnit]))

(defonce ^:private timer
  (delay
    (let [executor (ScheduledThreadPoolExecutor. 1)]
      (.addShutdownHook
       (Runtime/getRuntime)
       (Thread. ^Runnable (fn [] (.shutdownNow executor))))
      executor)))

(defn run-after
  "Runs `f` after `delay-ms` have elapsed"
  [f delay-ms]
  (.schedule
   ^ScheduledThreadPoolExecutor @timer
   ^Runnable f
   ^long delay-ms
   TimeUnit/MILLISECONDS))

(defn run-every
  "Runs `f` every `interval-ms` until cancelled"
  [f interval-ms]
  (.scheduleAtFixedRate
   ^ScheduledThreadPoolExecutor @timer
   ^Runnable f
   0
   ^long interval-ms
   TimeUnit/MILLISECONDS))

(defn cancel
  "Cancels a previously scheduled execution of a `task`"
  [^Future task]
  (.cancel task true))
