;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns utilis.exception
  #?(:cljs (:require-macros [utilis.exception])))

#?(:clj
   (defmacro throw-if
     {:style/indent 1}
     [v]
     `(let [v# ~v] ; Ensure the 'v' is not evaluated more than once
        (cond-> v# (instance? #?(:clj Throwable
                                 :cljs js/Error) v#) throw))))

#?(:clj
   (defmacro with-exception->value
     {:style/indent 1}
     [exception-mapping & body]
     `(try
        ~@body
        ~@(->> exception-mapping
               (partition 2)
               (map (fn [[exception val]]
                      `(catch ~exception _# ~val)))))))
