;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns utilis.window)

(defn scroll-offset
  []
  (let [doc (.-documentElement js/document)]
    {:left (- (or (.-pageXOffset js/window) (.-scrollLeft doc))
              (or (.-clientLeft doc) 0))
     :top (- (or (.-pageYOffset js/window) (.-scrollTop doc))
             (or (.-clientTop doc) 0))}))
