;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns utilis.hash
  (:require [clojure.java.io :as io])
  (:import [java.security MessageDigest DigestInputStream]
           [java.io File]))

(defn sha256
  [s]
  (let [digest (MessageDigest/getInstance "sha256")
        digested (cond
                   (instance? File s)
                   (let [fis (io/input-stream s)
                         dis (DigestInputStream. fis digest)]
                     (try (while (not= -1 (.read dis)))
                          (.digest digest)
                          (finally
                            (.close fis)
                            (.close dis))))

                   (string? s)
                   (.digest digest (.getBytes s)))]
    (->> digested
         (map #(.substring
                (Integer/toString
                 (+ (bit-and % 0xff) 0x100) 16) 1))
         (apply str))))
