;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns spectator-slf4j.service-provider
  (:gen-class
   :name com.7theta.spectator.slf4j.SpectatorServiceProvider
   :implements [org.slf4j.spi.SLF4JServiceProvider]
   :state state
   :init init)
  (:require
   [spectator.log :as log])
  (:import
   [com.7theta.spectator.slf4j SpectatorLoggerFactory SpectatorServiceProvider]
   [org.slf4j.helpers BasicMarkerFactory NOPMDCAdapter]))

(defn -init
  []
  (log/debug [:spectator.slf4j/provider :start])
  [[] (atom {})])

(defn -initialize
  [^SpectatorServiceProvider this]
  (reset! (.state this)
          {:logger-factory (SpectatorLoggerFactory.)
           :marker-factory (BasicMarkerFactory.)
           :mdc-adapter (NOPMDCAdapter.)}))

(defn -getLoggerFactory
  [^SpectatorServiceProvider this]
  (:logger-factory @(.state this)))

(defn -getMarkerFactory
  [^SpectatorServiceProvider this]
  (:marker-factory @(.state this)))

(defn -getMDCAdapter
  [^SpectatorServiceProvider this]
  (:mdc-adapter @(.state this)))

(defn -getRequestedApiVersion
  [_]
  "2.0.99")
