;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns spectator-slf4j.factory
  (:gen-class :name com.7theta.spectator.slf4j.SpectatorLoggerFactory
              :implements [org.slf4j.ILoggerFactory]
              :state state
              :init init)
  (:require [spectator-slf4j.adapter])
  (:import [com.7theta.spectator.slf4j SpectatorLoggerFactory SpectatorLoggerAdapter]))

(defonce bootstrapped? (atom false))

(defn -init
  []
  [[] (atom {})])

(defn -getLogger
  [^SpectatorLoggerFactory this logger-name]
  (let [loggers (.state this)]
    (or
     (get @loggers logger-name)
     (let [new-logger (SpectatorLoggerAdapter. logger-name)]
       (-> loggers
           (swap! update logger-name #(or % new-logger))
           (get logger-name)))
     (throw (ex-info (str "Failed to get a logger for " logger-name) {:this this
                                                                      :logger logger-name})))))
