;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns signum.core
  (:require [signum.subs :as ss]
            [signum.events :as se]
            #?(:cljs [signum.debounce :as sd])))

(defn subscribe
  [query-v]
  (ss/subscribe query-v))

(defn dispatch
  ([query-v] (dispatch nil query-v))
  ([coeffects query-v]
   (se/dispatch coeffects query-v)))

#?(:cljs (defn dispatch-debounce
           [dispatch-map-or-seq]
           (sd/dispatch-debounce dispatch-map-or-seq)))
