;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns signum.hooks
  (:require [signum.subs :refer [subscribe]]
            [signum.signal :refer [hot?]]
            [helix.hooks :refer [use-state use-effect use-ref]]
            [utilis.js :as j]))

(defn use-signal
  ([signal] (use-signal signal nil))
  ([signal default]
   (let [[value set-value] (use-state default)
         mounted (use-ref true)]
     (use-effect
      :once
      (reset! mounted true)
      #(reset! mounted false))
     (use-effect
      [signal]
      (let [watch-key (str (random-uuid))]
        (add-watch signal watch-key
                   (fn [_ _ _ new-value]
                     (when (and @mounted (hot? signal))
                       (set-value new-value))))
        #(remove-watch signal watch-key)))
     value)))
