;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns signum.stream
  (:require #?@(:clj  [[manifold.deferred :as d]
                       [manifold.stream :as s]]
                :cljs [[manifold-cljs.deferred :as d]
                       [manifold-cljs.stream :as s]])))

(defn sliding-stream
  "Wraps the `source` stream with a buffer of size `n` which will drop the oldest
  items when capacity is hit.

  If no source is specified, creates a new stream with the provided capacity. "
  ([n]
   (let [in  (s/stream)
         out (sliding-stream n in)]
     (s/splice in out)))
  ([n source]
   (let [result (s/stream n)]
     (s/connect-via
      source
      (fn [val]
        (d/loop []
          (d/chain
           (s/try-put! result val 0 :timeout)
           (fn [put-result]
             (case put-result
               true     true
               false    false
               :timeout (d/chain (s/take! result) (fn [_] (d/recur))))))))
      result
      {:upstream?   true
       :downstream? true})
     result)))
