;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns signum.SignalColdException
  (:require [goog.object :as gobj]))

;; Thomas Heller proposed the below solution for extending JS prototypes
;; before implementing `shadow.cljs.modern/defclass`. `defclass` outputs
;; ES6 JS class syntax, even when targeting ES5. This is problematic for
;; React Native's Hermes JS engine, which only supports ES5 currently.
;;
;; https://stackoverflow.com/a/61040931

(defn SignalColdException
  {:jsdoc ["@constructor"]}
  [data]
  (this-as this
    (.call cljs.core.ExceptionInfo this "signum.signal/deref cold signal" data nil)
    this))

(gobj/extend
 (.-prototype SignalColdException)
  (.-prototype cljs.core.ExceptionInfo))
