(ns signum.SignalColdException
  (:require [goog.object :as gobj]))

;;; Thomas Heller proposed the below solution for extending JS prototypes
;;; before implementing `shadow.cljs.modern/defclass`. `defclass` outputs
;;; ES6 JS class syntax, even when targeting ES5. This is problematic for
;;; React Native's Hermes JS engine, which only supports ES5 currently.
;;;
;;; https://stackoverflow.com/a/61040931

(defn SignalColdException
  {:jsdoc ["@constructor"]}
  [data cause]
  (this-as this
           (.call cljs.core.ExceptionInfo this "signum.signal/deref cold signal" data cause)
           this))

(gobj/extend
 (.-prototype SignalColdException)
  (.-prototype cljs.core.ExceptionInfo))
