# com.7theta/schema

A library that provides the ability to define functions that enforce
malli schemas for parameters and return values.

_(Documentation on malli schemas can be viewed at https://github.com/metosin/malli)_

```clj
(>defn add->str
  "A function that takes two parameters, adds them together, and returns the value
  as a string."
  [a b]
  [:int :int => :string]
  (str (+ a b)))

(add->str 4 5) => "9"
```

Schema definition format is `[arg1 arg2 ... => return]`.  An argument can be wildcarded
with `_`.

`>defn`, `>defn-`, and `>fn` macros are included.  Multi-arity is not suported.
