;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns schema.core
  #?(:cljs (:require-macros [schema.core]))
  (:require #?(:clj [schema.util.parse :refer [parse-meta parse-args]])
            #?(:clj [malli.core :as m])))

#?(:clj (defmacro >fn
          [& args]
          (let [{:keys [params in-schema out-schema body]} (parse-args args)
                in-schema (into [:tuple] in-schema)]
            `(let [in-schema# ~in-schema
                   out-schema# ~out-schema
                   valid-in# (m/validator in-schema#)
                   valid-out# (m/validator out-schema#)
                   explain-in# (m/explainer in-schema#)
                   explain-out# (m/explainer out-schema#)]
               (fn ~params
                 (when-not (valid-in# ~params)
                   (throw (ex-info "Arguments do not conform to schema"
                                   (explain-in# ~params))))
                 (let [result# (do ~@body)]
                   (if (valid-out# result#)
                     result#
                     (throw (ex-info "Result does not conform to schema"
                                     (explain-out# result#))))))))))

#?(:clj (defmacro >defn
          [name & args]
          (let [{:keys [meta-map params]} (parse-meta args)]
            `(def ~(with-meta name meta-map)
               (>fn ~@params)))))

#?(:clj (defmacro >defn-
          [name & args]
          (let [{:keys [meta-map params]} (parse-meta args)]
            `(def ~(with-meta name (assoc meta-map :private true))
               (>fn ~@params)))))
