;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(defproject com.7theta/sarcina "0.3.7"
  :url "https://github.com/7theta/sarcina"
  :license {:name "MIT License"
            :url "https://opensource.org/licenses/MIT"}
  :scm {:name "git"
        :url "https://github.com/7theta/sarcina"}
  :dependencies [[com.7theta/signum "11.1.0"]
                 [com.7theta/fs-watch "0.2.0"]
                 [com.7theta/spectator "0.8.0"]

                 [net.dongliu/apk-parser "2.6.10"
                  :exclusions [com.google.code.findbugs/jsr305
                               org.bouncycastle/bcprov-jdk15on
                               org.bouncycastle/bcpkix-jdk15on
                               junit/junit]]

                 [integrant "0.13.1"]]
  :jvm-opts ["--enable-preview"]
  :profiles {:repl
             {:source-paths ["dev"]
              :dependencies [[org.clojure/clojure "1.12.1"]
                             [com.7theta/via "14.1.5"]
                             [com.7theta/vectio "3.4.0"]
                             [metosin/reitit-ring "0.9.1"]
                             [integrant/repl "0.4.0"]]}}
  :prep-tasks ["compile"])
