;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns fs-watch.core
  (:require [clojure.string :as st])
  (:import  [io.methvin.watcher DirectoryWatcher DirectoryChangeListener]
            [java.nio.file Paths]
            [java.net URI]))

(defn watch
  [callback-fn paths]
  (let [watcher (-> (DirectoryWatcher/builder)
                    (.paths (mapv #(Paths/get (URI. (str "file://" %))) paths))
                    (.listener (reify DirectoryChangeListener
                                 (onEvent [_this event]
                                   (callback-fn {:type (->> event .eventType str st/lower-case keyword)
                                                 :path (->> event .path str)
                                                 :root (->> event .rootPath str)}))))
                    (.fileHashing false)
                    .build)]
    {:watcher watcher
     :monitor (future (.watch watcher))}))

(defn stop
  [{:keys [monitor watcher]}]
  (future-cancel monitor)
  (.close watcher))
