(ns formal.hooks
  (:require [formal.form :refer [FormContext]]
            [helix.hooks :refer [use-context]]
            [ventus.hooks :refer [use-signal]]
            [signum.subs :refer [reg-sub subscribe]]))

(declare warn-nil-registry)

(defn use-input-value
  [input-id]
  (let [registry (use-context FormContext)]
    (when (not registry)
      (js/console.warn "Using formal.hooks/use-input-value outside of a formal.form/FormContext. You must use formal hooks inside of formal.form/form component."))
    (use-signal (subscribe [:formal.hooks/input-value registry input-id]))))

(reg-sub
 :formal.hooks/input-value
 (fn [[_ registry input-id]]
   (let [registry @registry]
     (when-let [input (get-in registry [:inputs input-id])]
       (:value @input)))))
