(ns formal.form
  (:require [formal.form.validation :refer [watcher registry-values]]
            [ventus.macros :refer [defnc]]
            [helix.core :refer [$ <>] :as h]
            [helix.dom :as dom]
            [helix.children :as hch]
            [helix.hooks :refer [use-effect use-ref use-state]]
            [signum.signal :refer [signal alter!]]
            [react :as react]
            [utilis.js :as j]))

(def FormContext (react/createContext))

(defnc form
  [props]
  (let [registry @(use-ref (signal {:inputs {}
                                    :input-key-mappings {}}))
        on-submit (when-let [on-submit (:on-submit props)]
                    (fn [event]
                      (doto event
                        (j/call :stopPropagation)
                        (j/call :preventDefault))
                      (let [{:keys [value
                                    error?
                                    has-all-inputs?]} (registry-values @registry {:subscribe-signals? false})]
                        (when (and has-all-inputs? (not error?))
                          (on-submit value)))
                      false))
        form-ref (use-ref nil)]
    (use-effect [on-submit] (alter! registry assoc :on-submit on-submit))
    (h/provider
     {:context FormContext
      :value registry}
     (<> ($ watcher
            {:form-ref form-ref
             :& (-> props
                    (select-keys [:on-value :on-error :on-incomplete :on-change])
                    (merge {:registry registry}))})
         (dom/form
          {:ref form-ref
           :& (-> props
                  (dissoc :on-value :on-error :on-incomplete :on-change)
                  (assoc :on-submit on-submit))}
          (hch/children props))))))
