(ns formal.error
  (:require [formal.form :as form]
            [helix.core :refer [$ <>]]
            [helix.dom :refer [div]]
            [helix.children :as hch]
            [helix.hooks :refer [use-state use-effect use-context]]
            [ventus.hooks :refer [use-signal]]
            [ventus.macros :refer [defnc]]))

(defnc input-state-error-watcher
  [{:keys [input-state on-error]}]
  (let [{:keys [error]} (use-signal input-state)]
    (use-effect [error] (on-error error))
    (<>)))

(defnc input-error-watcher
  [{:keys [input-id on-error]}]
  (when (not input-id)
    (js/console.warn "Using a formal/error component without an :input-id prop. You must provide an :input-id prop to get any errors."))
  (let [registry (use-signal (use-context form/FormContext))
        input-id (get-in registry [:input-key-mappings input-id])]
    (if-let [input-state (get-in registry [:inputs input-id])]
      ($ input-state-error-watcher
         {:input-state input-state
          :on-error on-error})
      (<>))))

(defnc error
  [props]
  (let [[input-error set-input-error] (use-state nil)]
    (<>
     ($ input-error-watcher
        {:on-error set-input-error
         :& (select-keys props [:input-id])})
     (if input-error
       (div {:& (dissoc props :input-id)}
            (hch/children props))
       (<>)))))
