(ns formal.core
  (:require [formal.form :as form]
            [formal.input :as input]
            [formal.select :as select]
            [formal.error :as error]
            [ventus.macros :refer [defnc]]
            [helix.core :refer [$]]
            [helix.children :as hch]))

(defnc form
  [props]
  ($ form/form {:& props}
     (hch/children props)))

(defnc input
  [props]
  ($ input/input {:& props}
     (hch/children props)))

(defnc textarea
  [props]
  ($ input/input
     {:component :textarea
      :& props}
     (hch/children props)))

(defnc select
  [props]
  ($ select/select {:& props}
     (hch/children props)))

(defnc select-option
  [props]
  ($ select/option {:& props}
     (hch/children props)))

(defnc error
  [props]
  ($ error/error {:& props}
     (hch/children props)))

(defn into-map
  [input-seq]
  (->> input-seq
       (map-indexed (fn [index {:keys [id name value] :as input}]
                      (when (contains? input :value)
                        [(or name id index) value])))
       (remove nil?)
       (reduce (fn [m [key value]]
                 (if (sequential? key)
                   (assoc-in m key value)
                   (assoc m key value)))
               {})))
