(ns formal.select
  (:require [formal.input :as input]
            [malli.core :as m]
            [malli.transform :as mt]
            [helix.core :refer [$ <> defnc]]
            [helix.dom :refer [div]]
            [helix.children :as hch]
            [react :as react]
            [utilis.fn :refer [fsafe]]
            [utilis.js :as j]))

(defnc select
  [props]
  ($ input/input {& (assoc props :component :select)}
     (hch/children props)))

(defnc option
  [props]
  ($ :option {& props}
     (hch/children props)))
