(ns formal.error
  (:require [formal.form :as form]
            [reagent.core :as r]
            [react :as react]
            [utilis.js :as j]))

(declare input-error)

(defn -error
  [props & children]
  (let [registry (react/useContext form/FormContext)]
    (r/as-element
     (when (input-error registry props)
       (into [:div (dissoc props :input-key)]
             children)))))

;;; Private

(defn- input-error
  [registry {:keys [input-key]}]
  (if (not input-key)
    (js/console.warn "Using a formal/error component without an :input-key prop. You must provide an :input-key prop to get any errors.")
    (when-let [input-id (get-in @registry [:input-key-mappings input-key])]
      (when-let [input-state (get-in @registry [:inputs input-id])]
        (:error @input-state)))))
