(ns formal.core
  (:require [formal.form :as form]
            [formal.input :as input]
            [formal.select :as select]
            [formal.error :as error]
            [reagent.core :as r]))

(defn form
  []
  (let [this (r/current-component)]
    (into [:f> form/-form (r/props this)]
          (r/children this))))

(defn input
  []
  (let [this (r/current-component)]
    (into [:f> input/-input (r/props this)]
          (r/children this))))

(defn select
  []
  (let [this (r/current-component)]
    (into [:f> select/-select (r/props this)]
          (r/children this))))

(defn select-option
  []
  (let [this (r/current-component)]
    (into [:f> select/-option (r/props this)]
          (r/children this))))

(defn error
  []
  (let [this (r/current-component)]
    (into [:f> error/-error (r/props this)]
          (r/children this))))

(defn into-map
  [input-seq]
  (->> input-seq
       (map-indexed (fn [index {:keys [key name value] :as input}]
                      (when value
                        [(or name key index) value])))
       (remove nil?)
       (into {})))
