;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns fluxus.scheduler
  (:require [fluxus.flow :as f]
            [tempus.core :as t]
            #?(:clj  [clojure.core.async :as a]
               :cljs [cljs.core.async :as a])))

(defn at
  [ts-seq]
  (let [control-ch (a/chan)
        output (f/flow {:buffer [:sliding 1]
                        :on-close (fn [_]
                                    (a/close! control-ch))})]
    (a/go
      (loop [ts-seq ts-seq]
        (when-let [ts (first ts-seq)]
          (let [delta (-> (t/into :long ts)
                          (- (t/into :long (t/now))))]
            (if (pos? delta)
              (a/alt!
                control-ch nil
                (a/timeout delta) (do (f/put! output ts)
                                      (recur (next ts-seq))))
              (recur (next ts-seq)))))))
    output))
