;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns fluxus.lock
  #?(:cljs (:require-macros [fluxus.lock])
     :clj  (:import [java.util.concurrent.locks ReentrantLock])))

#?(:clj
   (defmacro with-lock
     [[lock] & body]
     (let [typed-lock (vary-meta lock assoc :tag `ReentrantLock)]
       `(try
          (some-> ~typed-lock .lock)
          ~@body
          (finally
            (some-> ~typed-lock .unlock))))))
