;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns dev
  "Tools for interactive development with the REPL. This file should
  not be included in a production build of the application."
  (:require [structor.test-runner :refer [test-all test-clj test-cljs
                                          run-tests run-all-tests]]

            [clojure.tools.namespace.repl :refer [refresh refresh-all disable-reload!]]
            [clojure.repl :refer [apropos dir doc find-doc pst source]]
            [clojure.pprint :refer [pprint]]
            [clojure.reflect :refer [reflect]]

            [integrant.core :as ig]
            [integrant.repl :refer [clear go halt init reset reset-all]]
            [integrant.repl.state :refer [system]]))

(disable-reload! (find-ns 'integrant.core))

(def dev-config
  {:structor.test-runner/watcher-clj {}
   :structor.test-runner/watcher-cljs {}})

(ig/load-namespaces dev-config)

(integrant.repl/set-prep! (constantly dev-config))
