;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns fluxus.thread
  (:require [fluxus.promise :as p])
  (:import [java.lang Thread]))

(defonce ^:private thread-counter (atom 0))

(defmacro thread
  "Executes the body in a virtual thread, returning immediately to the
  calling thread. Returns a promise which will receive the result of
  the body when completed."
  [& body]
  `(let [result# (p/promise)]
     (Thread/startVirtualThread
      (^:once fn* []
       (.setName (Thread/currentThread)
                 (str "fluxus-" (swap! thread-counter inc)))
       (try
         (p/resolve! result# (do ~@body))
         (catch Throwable e#
           (p/reject! result# e#)))))
     result#))
