;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(defproject com.7theta/distantia "0.4.3"
  :description "diff and patch implementations for clojure data structures"
  :url "https://github.com/7theta/distantia"
  :license {:name "MIT License"
            :url "https://opensource.org/licenses/MIT"}
  :dependencies [[com.7theta/utilis "2.8.2"]]
  :profiles {:repl
             {:global-vars {*warn-on-reflection* true}
              :dependencies [[org.clojure/clojure "1.11.1"]]}
             :test
             {:dependencies [[org.clojure/clojurescript "1.11.60"]
                             [org.clojure/test.check "1.1.1"]
                             [com.gfredericks/test.chuck "0.2.14"]
                             [thheller/shadow-cljs "2.24.1"]
                             [criterium "0.4.6"]]}}
  :prep-tasks ["javac" "compile"]
  :clean-targets ^{:protect false} ["out" "target"]
  :java-source-paths ["src"]
  :scm {:name "git"
        :url "https://github.com/7theta/distantia"})
