;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(defproject com.7theta/distantia "0.4.0"
  :description "diff and patch implementations for clojure data structures"
  :url "https://github.com/7theta/distantia"
  :license {:name "MIT License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :profiles {:dev {:global-vars {*warn-on-reflection* true}
                   :dependencies [[org.clojure/clojure "1.10.3"]
                                  [org.clojure/clojurescript "1.11.4"]
                                  [org.clojure/tools.namespace "1.2.0"]
                                  [org.clojure/test.check "1.1.1"]
                                  [com.gfredericks/test.chuck "0.2.13"]
                                  [thheller/shadow-cljs "2.16.12"]
                                  [criterium "0.4.6"]]
                   :source-paths ["dev"]}}
  :prep-tasks ["javac" "compile"]
  :clean-targets ^{:protect false} ["out" "target"]
  :java-source-paths ["src"]
  :scm {:name "git"
        :url "https://github.com/7theta/distantia"})
