(ns orcl.analyzer.macro
  (:require [orcl.utils.cursor :as cursor]
            [orcl.analyzer.vars :as vars]
            [orcl.analyzer.patterns :as patterns]))

(defmacro with-fresh [bind & body]
  `(binding [vars/*fresh* (inc vars/*fresh*)]
     (let [~bind (str "__fresh" vars/*fresh*)]
       ~@body)))

(defmacro with-freshs [i bind & body]
  `(let [i# (+ vars/*fresh* ~i)
         ~bind (mapv #(str "__fresh" %) (range (inc vars/*fresh*) (inc i#)))]
    (binding [vars/*fresh* i#]
      ~@body)))

(defmacro as-cursor
  [[bind v] & body]
  `(let [~bind (cursor/make ~v)]
     ~@body))

(defmacro with-env [bind v & body]
  `(binding [vars/*env* (assoc vars/*env* ~bind ~v)]
     ~@body))


(defmacro with-envs [kvs & body]
  `(binding [vars/*env* (merge vars/*env* ~kvs)]
     ~@body))

(defmacro with-pattern [pattern source & body]
  `(with-envs (patterns/pattern-envs ~pattern ~source)
              ~@body))