(ns orcl.parser.filesystems
  (:require [orcl.parser :as parser]
            [clojure.java.io :as io])
  (:import [java.net URI]))

(defn filesystem [prefix]
  (reify parser/FileSystem
    (parser/read-file [this file] (slurp (io/file prefix file)))))

(defn preread-prefix [prefix]
  (let [prefix-uri (.toURI (io/file prefix))]
    (into {}
          (for [f (file-seq (io/file prefix))
                :when (.isFile f)
                :let [uri (.toURI f)]]
            [(str (.relativize prefix-uri uri)) (slurp f)]))))

(defmacro precompile-fs [prefix]
  `(let [m# ~(preread-prefix prefix)]
    (reify parser/FileSystem
      (parser/read-file [this# file#] (get m# file#)))))