// Compiled by ClojureScript 1.9.908 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__38863 = arguments.length;
switch (G__38863) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async38864 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38864 = (function (f,blockable,meta38865){
this.f = f;
this.blockable = blockable;
this.meta38865 = meta38865;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async38864.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38866,meta38865__$1){
var self__ = this;
var _38866__$1 = this;
return (new cljs.core.async.t_cljs$core$async38864(self__.f,self__.blockable,meta38865__$1));
});

cljs.core.async.t_cljs$core$async38864.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38866){
var self__ = this;
var _38866__$1 = this;
return self__.meta38865;
});

cljs.core.async.t_cljs$core$async38864.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38864.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async38864.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async38864.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async38864.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta38865","meta38865",-1813523570,null)], null);
});

cljs.core.async.t_cljs$core$async38864.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38864.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38864";

cljs.core.async.t_cljs$core$async38864.cljs$lang$ctorPrWriter = (function (this__28614__auto__,writer__28615__auto__,opt__28616__auto__){
return cljs.core._write.call(null,writer__28615__auto__,"cljs.core.async/t_cljs$core$async38864");
});

cljs.core.async.__GT_t_cljs$core$async38864 = (function cljs$core$async$__GT_t_cljs$core$async38864(f__$1,blockable__$1,meta38865){
return (new cljs.core.async.t_cljs$core$async38864(f__$1,blockable__$1,meta38865));
});

}

return (new cljs.core.async.t_cljs$core$async38864(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__38870 = arguments.length;
switch (G__38870) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__38873 = arguments.length;
switch (G__38873) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__38876 = arguments.length;
switch (G__38876) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_38878 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_38878);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_38878,ret){
return (function (){
return fn1.call(null,val_38878);
});})(val_38878,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__38880 = arguments.length;
switch (G__38880) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__28934__auto___38882 = n;
var x_38883 = (0);
while(true){
if((x_38883 < n__28934__auto___38882)){
(a[x_38883] = (0));

var G__38884 = (x_38883 + (1));
x_38883 = G__38884;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__38885 = (i + (1));
i = G__38885;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async38886 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38886 = (function (flag,meta38887){
this.flag = flag;
this.meta38887 = meta38887;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async38886.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_38888,meta38887__$1){
var self__ = this;
var _38888__$1 = this;
return (new cljs.core.async.t_cljs$core$async38886(self__.flag,meta38887__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async38886.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_38888){
var self__ = this;
var _38888__$1 = this;
return self__.meta38887;
});})(flag))
;

cljs.core.async.t_cljs$core$async38886.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38886.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async38886.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async38886.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async38886.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta38887","meta38887",199987112,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async38886.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38886.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38886";

cljs.core.async.t_cljs$core$async38886.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__28614__auto__,writer__28615__auto__,opt__28616__auto__){
return cljs.core._write.call(null,writer__28615__auto__,"cljs.core.async/t_cljs$core$async38886");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async38886 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async38886(flag__$1,meta38887){
return (new cljs.core.async.t_cljs$core$async38886(flag__$1,meta38887));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async38886(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async38889 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38889 = (function (flag,cb,meta38890){
this.flag = flag;
this.cb = cb;
this.meta38890 = meta38890;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async38889.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38891,meta38890__$1){
var self__ = this;
var _38891__$1 = this;
return (new cljs.core.async.t_cljs$core$async38889(self__.flag,self__.cb,meta38890__$1));
});

cljs.core.async.t_cljs$core$async38889.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38891){
var self__ = this;
var _38891__$1 = this;
return self__.meta38890;
});

cljs.core.async.t_cljs$core$async38889.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38889.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async38889.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async38889.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async38889.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta38890","meta38890",381803689,null)], null);
});

cljs.core.async.t_cljs$core$async38889.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38889.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38889";

cljs.core.async.t_cljs$core$async38889.cljs$lang$ctorPrWriter = (function (this__28614__auto__,writer__28615__auto__,opt__28616__auto__){
return cljs.core._write.call(null,writer__28615__auto__,"cljs.core.async/t_cljs$core$async38889");
});

cljs.core.async.__GT_t_cljs$core$async38889 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async38889(flag__$1,cb__$1,meta38890){
return (new cljs.core.async.t_cljs$core$async38889(flag__$1,cb__$1,meta38890));
});

}

return (new cljs.core.async.t_cljs$core$async38889(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__38892_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__38892_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__38893_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__38893_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__27989__auto__ = wport;
if(cljs.core.truth_(or__27989__auto__)){
return or__27989__auto__;
} else {
return port;
}
})()], null));
} else {
var G__38894 = (i + (1));
i = G__38894;
continue;
}
} else {
return null;
}
break;
}
})();
var or__27989__auto__ = ret;
if(cljs.core.truth_(or__27989__auto__)){
return or__27989__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__27977__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__27977__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__27977__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__29165__auto__ = [];
var len__29158__auto___38900 = arguments.length;
var i__29159__auto___38901 = (0);
while(true){
if((i__29159__auto___38901 < len__29158__auto___38900)){
args__29165__auto__.push((arguments[i__29159__auto___38901]));

var G__38902 = (i__29159__auto___38901 + (1));
i__29159__auto___38901 = G__38902;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((1) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29166__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__38897){
var map__38898 = p__38897;
var map__38898__$1 = ((((!((map__38898 == null)))?((((map__38898.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38898.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38898):map__38898);
var opts = map__38898__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq38895){
var G__38896 = cljs.core.first.call(null,seq38895);
var seq38895__$1 = cljs.core.next.call(null,seq38895);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__38896,seq38895__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__38904 = arguments.length;
switch (G__38904) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__38817__auto___38950 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38817__auto___38950){
return (function (){
var f__38818__auto__ = (function (){var switch__38764__auto__ = ((function (c__38817__auto___38950){
return (function (state_38928){
var state_val_38929 = (state_38928[(1)]);
if((state_val_38929 === (7))){
var inst_38924 = (state_38928[(2)]);
var state_38928__$1 = state_38928;
var statearr_38930_38951 = state_38928__$1;
(statearr_38930_38951[(2)] = inst_38924);

(statearr_38930_38951[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38929 === (1))){
var state_38928__$1 = state_38928;
var statearr_38931_38952 = state_38928__$1;
(statearr_38931_38952[(2)] = null);

(statearr_38931_38952[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38929 === (4))){
var inst_38907 = (state_38928[(7)]);
var inst_38907__$1 = (state_38928[(2)]);
var inst_38908 = (inst_38907__$1 == null);
var state_38928__$1 = (function (){var statearr_38932 = state_38928;
(statearr_38932[(7)] = inst_38907__$1);

return statearr_38932;
})();
if(cljs.core.truth_(inst_38908)){
var statearr_38933_38953 = state_38928__$1;
(statearr_38933_38953[(1)] = (5));

} else {
var statearr_38934_38954 = state_38928__$1;
(statearr_38934_38954[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38929 === (13))){
var state_38928__$1 = state_38928;
var statearr_38935_38955 = state_38928__$1;
(statearr_38935_38955[(2)] = null);

(statearr_38935_38955[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38929 === (6))){
var inst_38907 = (state_38928[(7)]);
var state_38928__$1 = state_38928;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_38928__$1,(11),to,inst_38907);
} else {
if((state_val_38929 === (3))){
var inst_38926 = (state_38928[(2)]);
var state_38928__$1 = state_38928;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38928__$1,inst_38926);
} else {
if((state_val_38929 === (12))){
var state_38928__$1 = state_38928;
var statearr_38936_38956 = state_38928__$1;
(statearr_38936_38956[(2)] = null);

(statearr_38936_38956[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38929 === (2))){
var state_38928__$1 = state_38928;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38928__$1,(4),from);
} else {
if((state_val_38929 === (11))){
var inst_38917 = (state_38928[(2)]);
var state_38928__$1 = state_38928;
if(cljs.core.truth_(inst_38917)){
var statearr_38937_38957 = state_38928__$1;
(statearr_38937_38957[(1)] = (12));

} else {
var statearr_38938_38958 = state_38928__$1;
(statearr_38938_38958[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38929 === (9))){
var state_38928__$1 = state_38928;
var statearr_38939_38959 = state_38928__$1;
(statearr_38939_38959[(2)] = null);

(statearr_38939_38959[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38929 === (5))){
var state_38928__$1 = state_38928;
if(cljs.core.truth_(close_QMARK_)){
var statearr_38940_38960 = state_38928__$1;
(statearr_38940_38960[(1)] = (8));

} else {
var statearr_38941_38961 = state_38928__$1;
(statearr_38941_38961[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38929 === (14))){
var inst_38922 = (state_38928[(2)]);
var state_38928__$1 = state_38928;
var statearr_38942_38962 = state_38928__$1;
(statearr_38942_38962[(2)] = inst_38922);

(statearr_38942_38962[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38929 === (10))){
var inst_38914 = (state_38928[(2)]);
var state_38928__$1 = state_38928;
var statearr_38943_38963 = state_38928__$1;
(statearr_38943_38963[(2)] = inst_38914);

(statearr_38943_38963[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38929 === (8))){
var inst_38911 = cljs.core.async.close_BANG_.call(null,to);
var state_38928__$1 = state_38928;
var statearr_38944_38964 = state_38928__$1;
(statearr_38944_38964[(2)] = inst_38911);

(statearr_38944_38964[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38817__auto___38950))
;
return ((function (switch__38764__auto__,c__38817__auto___38950){
return (function() {
var cljs$core$async$state_machine__38765__auto__ = null;
var cljs$core$async$state_machine__38765__auto____0 = (function (){
var statearr_38945 = [null,null,null,null,null,null,null,null];
(statearr_38945[(0)] = cljs$core$async$state_machine__38765__auto__);

(statearr_38945[(1)] = (1));

return statearr_38945;
});
var cljs$core$async$state_machine__38765__auto____1 = (function (state_38928){
while(true){
var ret_value__38766__auto__ = (function (){try{while(true){
var result__38767__auto__ = switch__38764__auto__.call(null,state_38928);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38767__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38767__auto__;
}
break;
}
}catch (e38946){if((e38946 instanceof Object)){
var ex__38768__auto__ = e38946;
var statearr_38947_38965 = state_38928;
(statearr_38947_38965[(5)] = ex__38768__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38928);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38946;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38766__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38966 = state_38928;
state_38928 = G__38966;
continue;
} else {
return ret_value__38766__auto__;
}
break;
}
});
cljs$core$async$state_machine__38765__auto__ = function(state_38928){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38765__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38765__auto____1.call(this,state_38928);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38765__auto____0;
cljs$core$async$state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38765__auto____1;
return cljs$core$async$state_machine__38765__auto__;
})()
;})(switch__38764__auto__,c__38817__auto___38950))
})();
var state__38819__auto__ = (function (){var statearr_38948 = f__38818__auto__.call(null);
(statearr_38948[(6)] = c__38817__auto___38950);

return statearr_38948;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38819__auto__);
});})(c__38817__auto___38950))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__38967){
var vec__38968 = p__38967;
var v = cljs.core.nth.call(null,vec__38968,(0),null);
var p = cljs.core.nth.call(null,vec__38968,(1),null);
var job = vec__38968;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__38817__auto___39139 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38817__auto___39139,res,vec__38968,v,p,job,jobs,results){
return (function (){
var f__38818__auto__ = (function (){var switch__38764__auto__ = ((function (c__38817__auto___39139,res,vec__38968,v,p,job,jobs,results){
return (function (state_38975){
var state_val_38976 = (state_38975[(1)]);
if((state_val_38976 === (1))){
var state_38975__$1 = state_38975;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_38975__$1,(2),res,v);
} else {
if((state_val_38976 === (2))){
var inst_38972 = (state_38975[(2)]);
var inst_38973 = cljs.core.async.close_BANG_.call(null,res);
var state_38975__$1 = (function (){var statearr_38977 = state_38975;
(statearr_38977[(7)] = inst_38972);

return statearr_38977;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38975__$1,inst_38973);
} else {
return null;
}
}
});})(c__38817__auto___39139,res,vec__38968,v,p,job,jobs,results))
;
return ((function (switch__38764__auto__,c__38817__auto___39139,res,vec__38968,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__38765__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__38765__auto____0 = (function (){
var statearr_38978 = [null,null,null,null,null,null,null,null];
(statearr_38978[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__38765__auto__);

(statearr_38978[(1)] = (1));

return statearr_38978;
});
var cljs$core$async$pipeline_STAR__$_state_machine__38765__auto____1 = (function (state_38975){
while(true){
var ret_value__38766__auto__ = (function (){try{while(true){
var result__38767__auto__ = switch__38764__auto__.call(null,state_38975);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38767__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38767__auto__;
}
break;
}
}catch (e38979){if((e38979 instanceof Object)){
var ex__38768__auto__ = e38979;
var statearr_38980_39140 = state_38975;
(statearr_38980_39140[(5)] = ex__38768__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38975);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38979;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38766__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39141 = state_38975;
state_38975 = G__39141;
continue;
} else {
return ret_value__38766__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__38765__auto__ = function(state_38975){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__38765__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__38765__auto____1.call(this,state_38975);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__38765__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__38765__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__38765__auto__;
})()
;})(switch__38764__auto__,c__38817__auto___39139,res,vec__38968,v,p,job,jobs,results))
})();
var state__38819__auto__ = (function (){var statearr_38981 = f__38818__auto__.call(null);
(statearr_38981[(6)] = c__38817__auto___39139);

return statearr_38981;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38819__auto__);
});})(c__38817__auto___39139,res,vec__38968,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__38982){
var vec__38983 = p__38982;
var v = cljs.core.nth.call(null,vec__38983,(0),null);
var p = cljs.core.nth.call(null,vec__38983,(1),null);
var job = vec__38983;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__28934__auto___39142 = n;
var __39143 = (0);
while(true){
if((__39143 < n__28934__auto___39142)){
var G__38986_39144 = type;
var G__38986_39145__$1 = (((G__38986_39144 instanceof cljs.core.Keyword))?G__38986_39144.fqn:null);
switch (G__38986_39145__$1) {
case "compute":
var c__38817__auto___39147 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__39143,c__38817__auto___39147,G__38986_39144,G__38986_39145__$1,n__28934__auto___39142,jobs,results,process,async){
return (function (){
var f__38818__auto__ = (function (){var switch__38764__auto__ = ((function (__39143,c__38817__auto___39147,G__38986_39144,G__38986_39145__$1,n__28934__auto___39142,jobs,results,process,async){
return (function (state_38999){
var state_val_39000 = (state_38999[(1)]);
if((state_val_39000 === (1))){
var state_38999__$1 = state_38999;
var statearr_39001_39148 = state_38999__$1;
(statearr_39001_39148[(2)] = null);

(statearr_39001_39148[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39000 === (2))){
var state_38999__$1 = state_38999;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38999__$1,(4),jobs);
} else {
if((state_val_39000 === (3))){
var inst_38997 = (state_38999[(2)]);
var state_38999__$1 = state_38999;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38999__$1,inst_38997);
} else {
if((state_val_39000 === (4))){
var inst_38989 = (state_38999[(2)]);
var inst_38990 = process.call(null,inst_38989);
var state_38999__$1 = state_38999;
if(cljs.core.truth_(inst_38990)){
var statearr_39002_39149 = state_38999__$1;
(statearr_39002_39149[(1)] = (5));

} else {
var statearr_39003_39150 = state_38999__$1;
(statearr_39003_39150[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39000 === (5))){
var state_38999__$1 = state_38999;
var statearr_39004_39151 = state_38999__$1;
(statearr_39004_39151[(2)] = null);

(statearr_39004_39151[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39000 === (6))){
var state_38999__$1 = state_38999;
var statearr_39005_39152 = state_38999__$1;
(statearr_39005_39152[(2)] = null);

(statearr_39005_39152[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39000 === (7))){
var inst_38995 = (state_38999[(2)]);
var state_38999__$1 = state_38999;
var statearr_39006_39153 = state_38999__$1;
(statearr_39006_39153[(2)] = inst_38995);

(statearr_39006_39153[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__39143,c__38817__auto___39147,G__38986_39144,G__38986_39145__$1,n__28934__auto___39142,jobs,results,process,async))
;
return ((function (__39143,switch__38764__auto__,c__38817__auto___39147,G__38986_39144,G__38986_39145__$1,n__28934__auto___39142,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__38765__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__38765__auto____0 = (function (){
var statearr_39007 = [null,null,null,null,null,null,null];
(statearr_39007[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__38765__auto__);

(statearr_39007[(1)] = (1));

return statearr_39007;
});
var cljs$core$async$pipeline_STAR__$_state_machine__38765__auto____1 = (function (state_38999){
while(true){
var ret_value__38766__auto__ = (function (){try{while(true){
var result__38767__auto__ = switch__38764__auto__.call(null,state_38999);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38767__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38767__auto__;
}
break;
}
}catch (e39008){if((e39008 instanceof Object)){
var ex__38768__auto__ = e39008;
var statearr_39009_39154 = state_38999;
(statearr_39009_39154[(5)] = ex__38768__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38999);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39008;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38766__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39155 = state_38999;
state_38999 = G__39155;
continue;
} else {
return ret_value__38766__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__38765__auto__ = function(state_38999){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__38765__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__38765__auto____1.call(this,state_38999);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__38765__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__38765__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__38765__auto__;
})()
;})(__39143,switch__38764__auto__,c__38817__auto___39147,G__38986_39144,G__38986_39145__$1,n__28934__auto___39142,jobs,results,process,async))
})();
var state__38819__auto__ = (function (){var statearr_39010 = f__38818__auto__.call(null);
(statearr_39010[(6)] = c__38817__auto___39147);

return statearr_39010;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38819__auto__);
});})(__39143,c__38817__auto___39147,G__38986_39144,G__38986_39145__$1,n__28934__auto___39142,jobs,results,process,async))
);


break;
case "async":
var c__38817__auto___39156 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__39143,c__38817__auto___39156,G__38986_39144,G__38986_39145__$1,n__28934__auto___39142,jobs,results,process,async){
return (function (){
var f__38818__auto__ = (function (){var switch__38764__auto__ = ((function (__39143,c__38817__auto___39156,G__38986_39144,G__38986_39145__$1,n__28934__auto___39142,jobs,results,process,async){
return (function (state_39023){
var state_val_39024 = (state_39023[(1)]);
if((state_val_39024 === (1))){
var state_39023__$1 = state_39023;
var statearr_39025_39157 = state_39023__$1;
(statearr_39025_39157[(2)] = null);

(statearr_39025_39157[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39024 === (2))){
var state_39023__$1 = state_39023;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39023__$1,(4),jobs);
} else {
if((state_val_39024 === (3))){
var inst_39021 = (state_39023[(2)]);
var state_39023__$1 = state_39023;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39023__$1,inst_39021);
} else {
if((state_val_39024 === (4))){
var inst_39013 = (state_39023[(2)]);
var inst_39014 = async.call(null,inst_39013);
var state_39023__$1 = state_39023;
if(cljs.core.truth_(inst_39014)){
var statearr_39026_39158 = state_39023__$1;
(statearr_39026_39158[(1)] = (5));

} else {
var statearr_39027_39159 = state_39023__$1;
(statearr_39027_39159[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39024 === (5))){
var state_39023__$1 = state_39023;
var statearr_39028_39160 = state_39023__$1;
(statearr_39028_39160[(2)] = null);

(statearr_39028_39160[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39024 === (6))){
var state_39023__$1 = state_39023;
var statearr_39029_39161 = state_39023__$1;
(statearr_39029_39161[(2)] = null);

(statearr_39029_39161[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39024 === (7))){
var inst_39019 = (state_39023[(2)]);
var state_39023__$1 = state_39023;
var statearr_39030_39162 = state_39023__$1;
(statearr_39030_39162[(2)] = inst_39019);

(statearr_39030_39162[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__39143,c__38817__auto___39156,G__38986_39144,G__38986_39145__$1,n__28934__auto___39142,jobs,results,process,async))
;
return ((function (__39143,switch__38764__auto__,c__38817__auto___39156,G__38986_39144,G__38986_39145__$1,n__28934__auto___39142,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__38765__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__38765__auto____0 = (function (){
var statearr_39031 = [null,null,null,null,null,null,null];
(statearr_39031[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__38765__auto__);

(statearr_39031[(1)] = (1));

return statearr_39031;
});
var cljs$core$async$pipeline_STAR__$_state_machine__38765__auto____1 = (function (state_39023){
while(true){
var ret_value__38766__auto__ = (function (){try{while(true){
var result__38767__auto__ = switch__38764__auto__.call(null,state_39023);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38767__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38767__auto__;
}
break;
}
}catch (e39032){if((e39032 instanceof Object)){
var ex__38768__auto__ = e39032;
var statearr_39033_39163 = state_39023;
(statearr_39033_39163[(5)] = ex__38768__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_39023);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39032;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38766__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39164 = state_39023;
state_39023 = G__39164;
continue;
} else {
return ret_value__38766__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__38765__auto__ = function(state_39023){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__38765__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__38765__auto____1.call(this,state_39023);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__38765__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__38765__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__38765__auto__;
})()
;})(__39143,switch__38764__auto__,c__38817__auto___39156,G__38986_39144,G__38986_39145__$1,n__28934__auto___39142,jobs,results,process,async))
})();
var state__38819__auto__ = (function (){var statearr_39034 = f__38818__auto__.call(null);
(statearr_39034[(6)] = c__38817__auto___39156);

return statearr_39034;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38819__auto__);
});})(__39143,c__38817__auto___39156,G__38986_39144,G__38986_39145__$1,n__28934__auto___39142,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__38986_39145__$1)].join('')));

}

var G__39165 = (__39143 + (1));
__39143 = G__39165;
continue;
} else {
}
break;
}

var c__38817__auto___39166 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38817__auto___39166,jobs,results,process,async){
return (function (){
var f__38818__auto__ = (function (){var switch__38764__auto__ = ((function (c__38817__auto___39166,jobs,results,process,async){
return (function (state_39056){
var state_val_39057 = (state_39056[(1)]);
if((state_val_39057 === (1))){
var state_39056__$1 = state_39056;
var statearr_39058_39167 = state_39056__$1;
(statearr_39058_39167[(2)] = null);

(statearr_39058_39167[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39057 === (2))){
var state_39056__$1 = state_39056;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39056__$1,(4),from);
} else {
if((state_val_39057 === (3))){
var inst_39054 = (state_39056[(2)]);
var state_39056__$1 = state_39056;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39056__$1,inst_39054);
} else {
if((state_val_39057 === (4))){
var inst_39037 = (state_39056[(7)]);
var inst_39037__$1 = (state_39056[(2)]);
var inst_39038 = (inst_39037__$1 == null);
var state_39056__$1 = (function (){var statearr_39059 = state_39056;
(statearr_39059[(7)] = inst_39037__$1);

return statearr_39059;
})();
if(cljs.core.truth_(inst_39038)){
var statearr_39060_39168 = state_39056__$1;
(statearr_39060_39168[(1)] = (5));

} else {
var statearr_39061_39169 = state_39056__$1;
(statearr_39061_39169[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39057 === (5))){
var inst_39040 = cljs.core.async.close_BANG_.call(null,jobs);
var state_39056__$1 = state_39056;
var statearr_39062_39170 = state_39056__$1;
(statearr_39062_39170[(2)] = inst_39040);

(statearr_39062_39170[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39057 === (6))){
var inst_39037 = (state_39056[(7)]);
var inst_39042 = (state_39056[(8)]);
var inst_39042__$1 = cljs.core.async.chan.call(null,(1));
var inst_39043 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39044 = [inst_39037,inst_39042__$1];
var inst_39045 = (new cljs.core.PersistentVector(null,2,(5),inst_39043,inst_39044,null));
var state_39056__$1 = (function (){var statearr_39063 = state_39056;
(statearr_39063[(8)] = inst_39042__$1);

return statearr_39063;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_39056__$1,(8),jobs,inst_39045);
} else {
if((state_val_39057 === (7))){
var inst_39052 = (state_39056[(2)]);
var state_39056__$1 = state_39056;
var statearr_39064_39171 = state_39056__$1;
(statearr_39064_39171[(2)] = inst_39052);

(statearr_39064_39171[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39057 === (8))){
var inst_39042 = (state_39056[(8)]);
var inst_39047 = (state_39056[(2)]);
var state_39056__$1 = (function (){var statearr_39065 = state_39056;
(statearr_39065[(9)] = inst_39047);

return statearr_39065;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_39056__$1,(9),results,inst_39042);
} else {
if((state_val_39057 === (9))){
var inst_39049 = (state_39056[(2)]);
var state_39056__$1 = (function (){var statearr_39066 = state_39056;
(statearr_39066[(10)] = inst_39049);

return statearr_39066;
})();
var statearr_39067_39172 = state_39056__$1;
(statearr_39067_39172[(2)] = null);

(statearr_39067_39172[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__38817__auto___39166,jobs,results,process,async))
;
return ((function (switch__38764__auto__,c__38817__auto___39166,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__38765__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__38765__auto____0 = (function (){
var statearr_39068 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_39068[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__38765__auto__);

(statearr_39068[(1)] = (1));

return statearr_39068;
});
var cljs$core$async$pipeline_STAR__$_state_machine__38765__auto____1 = (function (state_39056){
while(true){
var ret_value__38766__auto__ = (function (){try{while(true){
var result__38767__auto__ = switch__38764__auto__.call(null,state_39056);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38767__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38767__auto__;
}
break;
}
}catch (e39069){if((e39069 instanceof Object)){
var ex__38768__auto__ = e39069;
var statearr_39070_39173 = state_39056;
(statearr_39070_39173[(5)] = ex__38768__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_39056);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39069;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38766__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39174 = state_39056;
state_39056 = G__39174;
continue;
} else {
return ret_value__38766__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__38765__auto__ = function(state_39056){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__38765__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__38765__auto____1.call(this,state_39056);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__38765__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__38765__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__38765__auto__;
})()
;})(switch__38764__auto__,c__38817__auto___39166,jobs,results,process,async))
})();
var state__38819__auto__ = (function (){var statearr_39071 = f__38818__auto__.call(null);
(statearr_39071[(6)] = c__38817__auto___39166);

return statearr_39071;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38819__auto__);
});})(c__38817__auto___39166,jobs,results,process,async))
);


var c__38817__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38817__auto__,jobs,results,process,async){
return (function (){
var f__38818__auto__ = (function (){var switch__38764__auto__ = ((function (c__38817__auto__,jobs,results,process,async){
return (function (state_39109){
var state_val_39110 = (state_39109[(1)]);
if((state_val_39110 === (7))){
var inst_39105 = (state_39109[(2)]);
var state_39109__$1 = state_39109;
var statearr_39111_39175 = state_39109__$1;
(statearr_39111_39175[(2)] = inst_39105);

(statearr_39111_39175[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39110 === (20))){
var state_39109__$1 = state_39109;
var statearr_39112_39176 = state_39109__$1;
(statearr_39112_39176[(2)] = null);

(statearr_39112_39176[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39110 === (1))){
var state_39109__$1 = state_39109;
var statearr_39113_39177 = state_39109__$1;
(statearr_39113_39177[(2)] = null);

(statearr_39113_39177[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39110 === (4))){
var inst_39074 = (state_39109[(7)]);
var inst_39074__$1 = (state_39109[(2)]);
var inst_39075 = (inst_39074__$1 == null);
var state_39109__$1 = (function (){var statearr_39114 = state_39109;
(statearr_39114[(7)] = inst_39074__$1);

return statearr_39114;
})();
if(cljs.core.truth_(inst_39075)){
var statearr_39115_39178 = state_39109__$1;
(statearr_39115_39178[(1)] = (5));

} else {
var statearr_39116_39179 = state_39109__$1;
(statearr_39116_39179[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39110 === (15))){
var inst_39087 = (state_39109[(8)]);
var state_39109__$1 = state_39109;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_39109__$1,(18),to,inst_39087);
} else {
if((state_val_39110 === (21))){
var inst_39100 = (state_39109[(2)]);
var state_39109__$1 = state_39109;
var statearr_39117_39180 = state_39109__$1;
(statearr_39117_39180[(2)] = inst_39100);

(statearr_39117_39180[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39110 === (13))){
var inst_39102 = (state_39109[(2)]);
var state_39109__$1 = (function (){var statearr_39118 = state_39109;
(statearr_39118[(9)] = inst_39102);

return statearr_39118;
})();
var statearr_39119_39181 = state_39109__$1;
(statearr_39119_39181[(2)] = null);

(statearr_39119_39181[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39110 === (6))){
var inst_39074 = (state_39109[(7)]);
var state_39109__$1 = state_39109;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39109__$1,(11),inst_39074);
} else {
if((state_val_39110 === (17))){
var inst_39095 = (state_39109[(2)]);
var state_39109__$1 = state_39109;
if(cljs.core.truth_(inst_39095)){
var statearr_39120_39182 = state_39109__$1;
(statearr_39120_39182[(1)] = (19));

} else {
var statearr_39121_39183 = state_39109__$1;
(statearr_39121_39183[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39110 === (3))){
var inst_39107 = (state_39109[(2)]);
var state_39109__$1 = state_39109;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39109__$1,inst_39107);
} else {
if((state_val_39110 === (12))){
var inst_39084 = (state_39109[(10)]);
var state_39109__$1 = state_39109;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39109__$1,(14),inst_39084);
} else {
if((state_val_39110 === (2))){
var state_39109__$1 = state_39109;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39109__$1,(4),results);
} else {
if((state_val_39110 === (19))){
var state_39109__$1 = state_39109;
var statearr_39122_39184 = state_39109__$1;
(statearr_39122_39184[(2)] = null);

(statearr_39122_39184[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39110 === (11))){
var inst_39084 = (state_39109[(2)]);
var state_39109__$1 = (function (){var statearr_39123 = state_39109;
(statearr_39123[(10)] = inst_39084);

return statearr_39123;
})();
var statearr_39124_39185 = state_39109__$1;
(statearr_39124_39185[(2)] = null);

(statearr_39124_39185[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39110 === (9))){
var state_39109__$1 = state_39109;
var statearr_39125_39186 = state_39109__$1;
(statearr_39125_39186[(2)] = null);

(statearr_39125_39186[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39110 === (5))){
var state_39109__$1 = state_39109;
if(cljs.core.truth_(close_QMARK_)){
var statearr_39126_39187 = state_39109__$1;
(statearr_39126_39187[(1)] = (8));

} else {
var statearr_39127_39188 = state_39109__$1;
(statearr_39127_39188[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39110 === (14))){
var inst_39087 = (state_39109[(8)]);
var inst_39089 = (state_39109[(11)]);
var inst_39087__$1 = (state_39109[(2)]);
var inst_39088 = (inst_39087__$1 == null);
var inst_39089__$1 = cljs.core.not.call(null,inst_39088);
var state_39109__$1 = (function (){var statearr_39128 = state_39109;
(statearr_39128[(8)] = inst_39087__$1);

(statearr_39128[(11)] = inst_39089__$1);

return statearr_39128;
})();
if(inst_39089__$1){
var statearr_39129_39189 = state_39109__$1;
(statearr_39129_39189[(1)] = (15));

} else {
var statearr_39130_39190 = state_39109__$1;
(statearr_39130_39190[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39110 === (16))){
var inst_39089 = (state_39109[(11)]);
var state_39109__$1 = state_39109;
var statearr_39131_39191 = state_39109__$1;
(statearr_39131_39191[(2)] = inst_39089);

(statearr_39131_39191[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39110 === (10))){
var inst_39081 = (state_39109[(2)]);
var state_39109__$1 = state_39109;
var statearr_39132_39192 = state_39109__$1;
(statearr_39132_39192[(2)] = inst_39081);

(statearr_39132_39192[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39110 === (18))){
var inst_39092 = (state_39109[(2)]);
var state_39109__$1 = state_39109;
var statearr_39133_39193 = state_39109__$1;
(statearr_39133_39193[(2)] = inst_39092);

(statearr_39133_39193[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39110 === (8))){
var inst_39078 = cljs.core.async.close_BANG_.call(null,to);
var state_39109__$1 = state_39109;
var statearr_39134_39194 = state_39109__$1;
(statearr_39134_39194[(2)] = inst_39078);

(statearr_39134_39194[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38817__auto__,jobs,results,process,async))
;
return ((function (switch__38764__auto__,c__38817__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__38765__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__38765__auto____0 = (function (){
var statearr_39135 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39135[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__38765__auto__);

(statearr_39135[(1)] = (1));

return statearr_39135;
});
var cljs$core$async$pipeline_STAR__$_state_machine__38765__auto____1 = (function (state_39109){
while(true){
var ret_value__38766__auto__ = (function (){try{while(true){
var result__38767__auto__ = switch__38764__auto__.call(null,state_39109);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38767__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38767__auto__;
}
break;
}
}catch (e39136){if((e39136 instanceof Object)){
var ex__38768__auto__ = e39136;
var statearr_39137_39195 = state_39109;
(statearr_39137_39195[(5)] = ex__38768__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_39109);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39136;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38766__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39196 = state_39109;
state_39109 = G__39196;
continue;
} else {
return ret_value__38766__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__38765__auto__ = function(state_39109){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__38765__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__38765__auto____1.call(this,state_39109);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__38765__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__38765__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__38765__auto__;
})()
;})(switch__38764__auto__,c__38817__auto__,jobs,results,process,async))
})();
var state__38819__auto__ = (function (){var statearr_39138 = f__38818__auto__.call(null);
(statearr_39138[(6)] = c__38817__auto__);

return statearr_39138;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38819__auto__);
});})(c__38817__auto__,jobs,results,process,async))
);

return c__38817__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__39198 = arguments.length;
switch (G__39198) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__39201 = arguments.length;
switch (G__39201) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__39204 = arguments.length;
switch (G__39204) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__38817__auto___39253 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38817__auto___39253,tc,fc){
return (function (){
var f__38818__auto__ = (function (){var switch__38764__auto__ = ((function (c__38817__auto___39253,tc,fc){
return (function (state_39230){
var state_val_39231 = (state_39230[(1)]);
if((state_val_39231 === (7))){
var inst_39226 = (state_39230[(2)]);
var state_39230__$1 = state_39230;
var statearr_39232_39254 = state_39230__$1;
(statearr_39232_39254[(2)] = inst_39226);

(statearr_39232_39254[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (1))){
var state_39230__$1 = state_39230;
var statearr_39233_39255 = state_39230__$1;
(statearr_39233_39255[(2)] = null);

(statearr_39233_39255[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (4))){
var inst_39207 = (state_39230[(7)]);
var inst_39207__$1 = (state_39230[(2)]);
var inst_39208 = (inst_39207__$1 == null);
var state_39230__$1 = (function (){var statearr_39234 = state_39230;
(statearr_39234[(7)] = inst_39207__$1);

return statearr_39234;
})();
if(cljs.core.truth_(inst_39208)){
var statearr_39235_39256 = state_39230__$1;
(statearr_39235_39256[(1)] = (5));

} else {
var statearr_39236_39257 = state_39230__$1;
(statearr_39236_39257[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (13))){
var state_39230__$1 = state_39230;
var statearr_39237_39258 = state_39230__$1;
(statearr_39237_39258[(2)] = null);

(statearr_39237_39258[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (6))){
var inst_39207 = (state_39230[(7)]);
var inst_39213 = p.call(null,inst_39207);
var state_39230__$1 = state_39230;
if(cljs.core.truth_(inst_39213)){
var statearr_39238_39259 = state_39230__$1;
(statearr_39238_39259[(1)] = (9));

} else {
var statearr_39239_39260 = state_39230__$1;
(statearr_39239_39260[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (3))){
var inst_39228 = (state_39230[(2)]);
var state_39230__$1 = state_39230;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39230__$1,inst_39228);
} else {
if((state_val_39231 === (12))){
var state_39230__$1 = state_39230;
var statearr_39240_39261 = state_39230__$1;
(statearr_39240_39261[(2)] = null);

(statearr_39240_39261[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (2))){
var state_39230__$1 = state_39230;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39230__$1,(4),ch);
} else {
if((state_val_39231 === (11))){
var inst_39207 = (state_39230[(7)]);
var inst_39217 = (state_39230[(2)]);
var state_39230__$1 = state_39230;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_39230__$1,(8),inst_39217,inst_39207);
} else {
if((state_val_39231 === (9))){
var state_39230__$1 = state_39230;
var statearr_39241_39262 = state_39230__$1;
(statearr_39241_39262[(2)] = tc);

(statearr_39241_39262[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (5))){
var inst_39210 = cljs.core.async.close_BANG_.call(null,tc);
var inst_39211 = cljs.core.async.close_BANG_.call(null,fc);
var state_39230__$1 = (function (){var statearr_39242 = state_39230;
(statearr_39242[(8)] = inst_39210);

return statearr_39242;
})();
var statearr_39243_39263 = state_39230__$1;
(statearr_39243_39263[(2)] = inst_39211);

(statearr_39243_39263[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (14))){
var inst_39224 = (state_39230[(2)]);
var state_39230__$1 = state_39230;
var statearr_39244_39264 = state_39230__$1;
(statearr_39244_39264[(2)] = inst_39224);

(statearr_39244_39264[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (10))){
var state_39230__$1 = state_39230;
var statearr_39245_39265 = state_39230__$1;
(statearr_39245_39265[(2)] = fc);

(statearr_39245_39265[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (8))){
var inst_39219 = (state_39230[(2)]);
var state_39230__$1 = state_39230;
if(cljs.core.truth_(inst_39219)){
var statearr_39246_39266 = state_39230__$1;
(statearr_39246_39266[(1)] = (12));

} else {
var statearr_39247_39267 = state_39230__$1;
(statearr_39247_39267[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38817__auto___39253,tc,fc))
;
return ((function (switch__38764__auto__,c__38817__auto___39253,tc,fc){
return (function() {
var cljs$core$async$state_machine__38765__auto__ = null;
var cljs$core$async$state_machine__38765__auto____0 = (function (){
var statearr_39248 = [null,null,null,null,null,null,null,null,null];
(statearr_39248[(0)] = cljs$core$async$state_machine__38765__auto__);

(statearr_39248[(1)] = (1));

return statearr_39248;
});
var cljs$core$async$state_machine__38765__auto____1 = (function (state_39230){
while(true){
var ret_value__38766__auto__ = (function (){try{while(true){
var result__38767__auto__ = switch__38764__auto__.call(null,state_39230);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38767__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38767__auto__;
}
break;
}
}catch (e39249){if((e39249 instanceof Object)){
var ex__38768__auto__ = e39249;
var statearr_39250_39268 = state_39230;
(statearr_39250_39268[(5)] = ex__38768__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_39230);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39249;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38766__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39269 = state_39230;
state_39230 = G__39269;
continue;
} else {
return ret_value__38766__auto__;
}
break;
}
});
cljs$core$async$state_machine__38765__auto__ = function(state_39230){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38765__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38765__auto____1.call(this,state_39230);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38765__auto____0;
cljs$core$async$state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38765__auto____1;
return cljs$core$async$state_machine__38765__auto__;
})()
;})(switch__38764__auto__,c__38817__auto___39253,tc,fc))
})();
var state__38819__auto__ = (function (){var statearr_39251 = f__38818__auto__.call(null);
(statearr_39251[(6)] = c__38817__auto___39253);

return statearr_39251;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38819__auto__);
});})(c__38817__auto___39253,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__38817__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38817__auto__){
return (function (){
var f__38818__auto__ = (function (){var switch__38764__auto__ = ((function (c__38817__auto__){
return (function (state_39290){
var state_val_39291 = (state_39290[(1)]);
if((state_val_39291 === (7))){
var inst_39286 = (state_39290[(2)]);
var state_39290__$1 = state_39290;
var statearr_39292_39310 = state_39290__$1;
(statearr_39292_39310[(2)] = inst_39286);

(statearr_39292_39310[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39291 === (1))){
var inst_39270 = init;
var state_39290__$1 = (function (){var statearr_39293 = state_39290;
(statearr_39293[(7)] = inst_39270);

return statearr_39293;
})();
var statearr_39294_39311 = state_39290__$1;
(statearr_39294_39311[(2)] = null);

(statearr_39294_39311[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39291 === (4))){
var inst_39273 = (state_39290[(8)]);
var inst_39273__$1 = (state_39290[(2)]);
var inst_39274 = (inst_39273__$1 == null);
var state_39290__$1 = (function (){var statearr_39295 = state_39290;
(statearr_39295[(8)] = inst_39273__$1);

return statearr_39295;
})();
if(cljs.core.truth_(inst_39274)){
var statearr_39296_39312 = state_39290__$1;
(statearr_39296_39312[(1)] = (5));

} else {
var statearr_39297_39313 = state_39290__$1;
(statearr_39297_39313[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39291 === (6))){
var inst_39270 = (state_39290[(7)]);
var inst_39273 = (state_39290[(8)]);
var inst_39277 = (state_39290[(9)]);
var inst_39277__$1 = f.call(null,inst_39270,inst_39273);
var inst_39278 = cljs.core.reduced_QMARK_.call(null,inst_39277__$1);
var state_39290__$1 = (function (){var statearr_39298 = state_39290;
(statearr_39298[(9)] = inst_39277__$1);

return statearr_39298;
})();
if(inst_39278){
var statearr_39299_39314 = state_39290__$1;
(statearr_39299_39314[(1)] = (8));

} else {
var statearr_39300_39315 = state_39290__$1;
(statearr_39300_39315[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39291 === (3))){
var inst_39288 = (state_39290[(2)]);
var state_39290__$1 = state_39290;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39290__$1,inst_39288);
} else {
if((state_val_39291 === (2))){
var state_39290__$1 = state_39290;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39290__$1,(4),ch);
} else {
if((state_val_39291 === (9))){
var inst_39277 = (state_39290[(9)]);
var inst_39270 = inst_39277;
var state_39290__$1 = (function (){var statearr_39301 = state_39290;
(statearr_39301[(7)] = inst_39270);

return statearr_39301;
})();
var statearr_39302_39316 = state_39290__$1;
(statearr_39302_39316[(2)] = null);

(statearr_39302_39316[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39291 === (5))){
var inst_39270 = (state_39290[(7)]);
var state_39290__$1 = state_39290;
var statearr_39303_39317 = state_39290__$1;
(statearr_39303_39317[(2)] = inst_39270);

(statearr_39303_39317[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39291 === (10))){
var inst_39284 = (state_39290[(2)]);
var state_39290__$1 = state_39290;
var statearr_39304_39318 = state_39290__$1;
(statearr_39304_39318[(2)] = inst_39284);

(statearr_39304_39318[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39291 === (8))){
var inst_39277 = (state_39290[(9)]);
var inst_39280 = cljs.core.deref.call(null,inst_39277);
var state_39290__$1 = state_39290;
var statearr_39305_39319 = state_39290__$1;
(statearr_39305_39319[(2)] = inst_39280);

(statearr_39305_39319[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__38817__auto__))
;
return ((function (switch__38764__auto__,c__38817__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__38765__auto__ = null;
var cljs$core$async$reduce_$_state_machine__38765__auto____0 = (function (){
var statearr_39306 = [null,null,null,null,null,null,null,null,null,null];
(statearr_39306[(0)] = cljs$core$async$reduce_$_state_machine__38765__auto__);

(statearr_39306[(1)] = (1));

return statearr_39306;
});
var cljs$core$async$reduce_$_state_machine__38765__auto____1 = (function (state_39290){
while(true){
var ret_value__38766__auto__ = (function (){try{while(true){
var result__38767__auto__ = switch__38764__auto__.call(null,state_39290);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38767__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38767__auto__;
}
break;
}
}catch (e39307){if((e39307 instanceof Object)){
var ex__38768__auto__ = e39307;
var statearr_39308_39320 = state_39290;
(statearr_39308_39320[(5)] = ex__38768__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_39290);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39307;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38766__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39321 = state_39290;
state_39290 = G__39321;
continue;
} else {
return ret_value__38766__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__38765__auto__ = function(state_39290){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__38765__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__38765__auto____1.call(this,state_39290);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__38765__auto____0;
cljs$core$async$reduce_$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__38765__auto____1;
return cljs$core$async$reduce_$_state_machine__38765__auto__;
})()
;})(switch__38764__auto__,c__38817__auto__))
})();
var state__38819__auto__ = (function (){var statearr_39309 = f__38818__auto__.call(null);
(statearr_39309[(6)] = c__38817__auto__);

return statearr_39309;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38819__auto__);
});})(c__38817__auto__))
);

return c__38817__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__38817__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38817__auto__,f__$1){
return (function (){
var f__38818__auto__ = (function (){var switch__38764__auto__ = ((function (c__38817__auto__,f__$1){
return (function (state_39327){
var state_val_39328 = (state_39327[(1)]);
if((state_val_39328 === (1))){
var inst_39322 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_39327__$1 = state_39327;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39327__$1,(2),inst_39322);
} else {
if((state_val_39328 === (2))){
var inst_39324 = (state_39327[(2)]);
var inst_39325 = f__$1.call(null,inst_39324);
var state_39327__$1 = state_39327;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39327__$1,inst_39325);
} else {
return null;
}
}
});})(c__38817__auto__,f__$1))
;
return ((function (switch__38764__auto__,c__38817__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__38765__auto__ = null;
var cljs$core$async$transduce_$_state_machine__38765__auto____0 = (function (){
var statearr_39329 = [null,null,null,null,null,null,null];
(statearr_39329[(0)] = cljs$core$async$transduce_$_state_machine__38765__auto__);

(statearr_39329[(1)] = (1));

return statearr_39329;
});
var cljs$core$async$transduce_$_state_machine__38765__auto____1 = (function (state_39327){
while(true){
var ret_value__38766__auto__ = (function (){try{while(true){
var result__38767__auto__ = switch__38764__auto__.call(null,state_39327);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38767__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38767__auto__;
}
break;
}
}catch (e39330){if((e39330 instanceof Object)){
var ex__38768__auto__ = e39330;
var statearr_39331_39333 = state_39327;
(statearr_39331_39333[(5)] = ex__38768__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_39327);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39330;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38766__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39334 = state_39327;
state_39327 = G__39334;
continue;
} else {
return ret_value__38766__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__38765__auto__ = function(state_39327){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__38765__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__38765__auto____1.call(this,state_39327);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__38765__auto____0;
cljs$core$async$transduce_$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__38765__auto____1;
return cljs$core$async$transduce_$_state_machine__38765__auto__;
})()
;})(switch__38764__auto__,c__38817__auto__,f__$1))
})();
var state__38819__auto__ = (function (){var statearr_39332 = f__38818__auto__.call(null);
(statearr_39332[(6)] = c__38817__auto__);

return statearr_39332;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38819__auto__);
});})(c__38817__auto__,f__$1))
);

return c__38817__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__39336 = arguments.length;
switch (G__39336) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__38817__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38817__auto__){
return (function (){
var f__38818__auto__ = (function (){var switch__38764__auto__ = ((function (c__38817__auto__){
return (function (state_39361){
var state_val_39362 = (state_39361[(1)]);
if((state_val_39362 === (7))){
var inst_39343 = (state_39361[(2)]);
var state_39361__$1 = state_39361;
var statearr_39363_39384 = state_39361__$1;
(statearr_39363_39384[(2)] = inst_39343);

(statearr_39363_39384[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39362 === (1))){
var inst_39337 = cljs.core.seq.call(null,coll);
var inst_39338 = inst_39337;
var state_39361__$1 = (function (){var statearr_39364 = state_39361;
(statearr_39364[(7)] = inst_39338);

return statearr_39364;
})();
var statearr_39365_39385 = state_39361__$1;
(statearr_39365_39385[(2)] = null);

(statearr_39365_39385[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39362 === (4))){
var inst_39338 = (state_39361[(7)]);
var inst_39341 = cljs.core.first.call(null,inst_39338);
var state_39361__$1 = state_39361;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_39361__$1,(7),ch,inst_39341);
} else {
if((state_val_39362 === (13))){
var inst_39355 = (state_39361[(2)]);
var state_39361__$1 = state_39361;
var statearr_39366_39386 = state_39361__$1;
(statearr_39366_39386[(2)] = inst_39355);

(statearr_39366_39386[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39362 === (6))){
var inst_39346 = (state_39361[(2)]);
var state_39361__$1 = state_39361;
if(cljs.core.truth_(inst_39346)){
var statearr_39367_39387 = state_39361__$1;
(statearr_39367_39387[(1)] = (8));

} else {
var statearr_39368_39388 = state_39361__$1;
(statearr_39368_39388[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39362 === (3))){
var inst_39359 = (state_39361[(2)]);
var state_39361__$1 = state_39361;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39361__$1,inst_39359);
} else {
if((state_val_39362 === (12))){
var state_39361__$1 = state_39361;
var statearr_39369_39389 = state_39361__$1;
(statearr_39369_39389[(2)] = null);

(statearr_39369_39389[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39362 === (2))){
var inst_39338 = (state_39361[(7)]);
var state_39361__$1 = state_39361;
if(cljs.core.truth_(inst_39338)){
var statearr_39370_39390 = state_39361__$1;
(statearr_39370_39390[(1)] = (4));

} else {
var statearr_39371_39391 = state_39361__$1;
(statearr_39371_39391[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39362 === (11))){
var inst_39352 = cljs.core.async.close_BANG_.call(null,ch);
var state_39361__$1 = state_39361;
var statearr_39372_39392 = state_39361__$1;
(statearr_39372_39392[(2)] = inst_39352);

(statearr_39372_39392[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39362 === (9))){
var state_39361__$1 = state_39361;
if(cljs.core.truth_(close_QMARK_)){
var statearr_39373_39393 = state_39361__$1;
(statearr_39373_39393[(1)] = (11));

} else {
var statearr_39374_39394 = state_39361__$1;
(statearr_39374_39394[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39362 === (5))){
var inst_39338 = (state_39361[(7)]);
var state_39361__$1 = state_39361;
var statearr_39375_39395 = state_39361__$1;
(statearr_39375_39395[(2)] = inst_39338);

(statearr_39375_39395[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39362 === (10))){
var inst_39357 = (state_39361[(2)]);
var state_39361__$1 = state_39361;
var statearr_39376_39396 = state_39361__$1;
(statearr_39376_39396[(2)] = inst_39357);

(statearr_39376_39396[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39362 === (8))){
var inst_39338 = (state_39361[(7)]);
var inst_39348 = cljs.core.next.call(null,inst_39338);
var inst_39338__$1 = inst_39348;
var state_39361__$1 = (function (){var statearr_39377 = state_39361;
(statearr_39377[(7)] = inst_39338__$1);

return statearr_39377;
})();
var statearr_39378_39397 = state_39361__$1;
(statearr_39378_39397[(2)] = null);

(statearr_39378_39397[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38817__auto__))
;
return ((function (switch__38764__auto__,c__38817__auto__){
return (function() {
var cljs$core$async$state_machine__38765__auto__ = null;
var cljs$core$async$state_machine__38765__auto____0 = (function (){
var statearr_39379 = [null,null,null,null,null,null,null,null];
(statearr_39379[(0)] = cljs$core$async$state_machine__38765__auto__);

(statearr_39379[(1)] = (1));

return statearr_39379;
});
var cljs$core$async$state_machine__38765__auto____1 = (function (state_39361){
while(true){
var ret_value__38766__auto__ = (function (){try{while(true){
var result__38767__auto__ = switch__38764__auto__.call(null,state_39361);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38767__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38767__auto__;
}
break;
}
}catch (e39380){if((e39380 instanceof Object)){
var ex__38768__auto__ = e39380;
var statearr_39381_39398 = state_39361;
(statearr_39381_39398[(5)] = ex__38768__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_39361);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39380;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38766__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39399 = state_39361;
state_39361 = G__39399;
continue;
} else {
return ret_value__38766__auto__;
}
break;
}
});
cljs$core$async$state_machine__38765__auto__ = function(state_39361){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38765__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38765__auto____1.call(this,state_39361);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38765__auto____0;
cljs$core$async$state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38765__auto____1;
return cljs$core$async$state_machine__38765__auto__;
})()
;})(switch__38764__auto__,c__38817__auto__))
})();
var state__38819__auto__ = (function (){var statearr_39382 = f__38818__auto__.call(null);
(statearr_39382[(6)] = c__38817__auto__);

return statearr_39382;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38819__auto__);
});})(c__38817__auto__))
);

return c__38817__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__28672__auto__ = (((_ == null))?null:_);
var m__28673__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__28672__auto__)]);
if(!((m__28673__auto__ == null))){
return m__28673__auto__.call(null,_);
} else {
var m__28673__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__28673__auto____$1 == null))){
return m__28673__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__28672__auto__ = (((m == null))?null:m);
var m__28673__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__28672__auto__)]);
if(!((m__28673__auto__ == null))){
return m__28673__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__28673__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__28673__auto____$1 == null))){
return m__28673__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__28672__auto__ = (((m == null))?null:m);
var m__28673__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__28672__auto__)]);
if(!((m__28673__auto__ == null))){
return m__28673__auto__.call(null,m,ch);
} else {
var m__28673__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__28673__auto____$1 == null))){
return m__28673__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__28672__auto__ = (((m == null))?null:m);
var m__28673__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__28672__auto__)]);
if(!((m__28673__auto__ == null))){
return m__28673__auto__.call(null,m);
} else {
var m__28673__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__28673__auto____$1 == null))){
return m__28673__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async39400 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async39400 = (function (ch,cs,meta39401){
this.ch = ch;
this.cs = cs;
this.meta39401 = meta39401;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async39400.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_39402,meta39401__$1){
var self__ = this;
var _39402__$1 = this;
return (new cljs.core.async.t_cljs$core$async39400(self__.ch,self__.cs,meta39401__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async39400.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_39402){
var self__ = this;
var _39402__$1 = this;
return self__.meta39401;
});})(cs))
;

cljs.core.async.t_cljs$core$async39400.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async39400.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async39400.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async39400.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async39400.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async39400.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async39400.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta39401","meta39401",2049644721,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async39400.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async39400.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async39400";

cljs.core.async.t_cljs$core$async39400.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__28614__auto__,writer__28615__auto__,opt__28616__auto__){
return cljs.core._write.call(null,writer__28615__auto__,"cljs.core.async/t_cljs$core$async39400");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async39400 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async39400(ch__$1,cs__$1,meta39401){
return (new cljs.core.async.t_cljs$core$async39400(ch__$1,cs__$1,meta39401));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async39400(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__38817__auto___39622 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38817__auto___39622,cs,m,dchan,dctr,done){
return (function (){
var f__38818__auto__ = (function (){var switch__38764__auto__ = ((function (c__38817__auto___39622,cs,m,dchan,dctr,done){
return (function (state_39537){
var state_val_39538 = (state_39537[(1)]);
if((state_val_39538 === (7))){
var inst_39533 = (state_39537[(2)]);
var state_39537__$1 = state_39537;
var statearr_39539_39623 = state_39537__$1;
(statearr_39539_39623[(2)] = inst_39533);

(statearr_39539_39623[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (20))){
var inst_39436 = (state_39537[(7)]);
var inst_39448 = cljs.core.first.call(null,inst_39436);
var inst_39449 = cljs.core.nth.call(null,inst_39448,(0),null);
var inst_39450 = cljs.core.nth.call(null,inst_39448,(1),null);
var state_39537__$1 = (function (){var statearr_39540 = state_39537;
(statearr_39540[(8)] = inst_39449);

return statearr_39540;
})();
if(cljs.core.truth_(inst_39450)){
var statearr_39541_39624 = state_39537__$1;
(statearr_39541_39624[(1)] = (22));

} else {
var statearr_39542_39625 = state_39537__$1;
(statearr_39542_39625[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (27))){
var inst_39480 = (state_39537[(9)]);
var inst_39485 = (state_39537[(10)]);
var inst_39478 = (state_39537[(11)]);
var inst_39405 = (state_39537[(12)]);
var inst_39485__$1 = cljs.core._nth.call(null,inst_39478,inst_39480);
var inst_39486 = cljs.core.async.put_BANG_.call(null,inst_39485__$1,inst_39405,done);
var state_39537__$1 = (function (){var statearr_39543 = state_39537;
(statearr_39543[(10)] = inst_39485__$1);

return statearr_39543;
})();
if(cljs.core.truth_(inst_39486)){
var statearr_39544_39626 = state_39537__$1;
(statearr_39544_39626[(1)] = (30));

} else {
var statearr_39545_39627 = state_39537__$1;
(statearr_39545_39627[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (1))){
var state_39537__$1 = state_39537;
var statearr_39546_39628 = state_39537__$1;
(statearr_39546_39628[(2)] = null);

(statearr_39546_39628[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (24))){
var inst_39436 = (state_39537[(7)]);
var inst_39455 = (state_39537[(2)]);
var inst_39456 = cljs.core.next.call(null,inst_39436);
var inst_39414 = inst_39456;
var inst_39415 = null;
var inst_39416 = (0);
var inst_39417 = (0);
var state_39537__$1 = (function (){var statearr_39547 = state_39537;
(statearr_39547[(13)] = inst_39455);

(statearr_39547[(14)] = inst_39415);

(statearr_39547[(15)] = inst_39416);

(statearr_39547[(16)] = inst_39417);

(statearr_39547[(17)] = inst_39414);

return statearr_39547;
})();
var statearr_39548_39629 = state_39537__$1;
(statearr_39548_39629[(2)] = null);

(statearr_39548_39629[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (39))){
var state_39537__$1 = state_39537;
var statearr_39552_39630 = state_39537__$1;
(statearr_39552_39630[(2)] = null);

(statearr_39552_39630[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (4))){
var inst_39405 = (state_39537[(12)]);
var inst_39405__$1 = (state_39537[(2)]);
var inst_39406 = (inst_39405__$1 == null);
var state_39537__$1 = (function (){var statearr_39553 = state_39537;
(statearr_39553[(12)] = inst_39405__$1);

return statearr_39553;
})();
if(cljs.core.truth_(inst_39406)){
var statearr_39554_39631 = state_39537__$1;
(statearr_39554_39631[(1)] = (5));

} else {
var statearr_39555_39632 = state_39537__$1;
(statearr_39555_39632[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (15))){
var inst_39415 = (state_39537[(14)]);
var inst_39416 = (state_39537[(15)]);
var inst_39417 = (state_39537[(16)]);
var inst_39414 = (state_39537[(17)]);
var inst_39432 = (state_39537[(2)]);
var inst_39433 = (inst_39417 + (1));
var tmp39549 = inst_39415;
var tmp39550 = inst_39416;
var tmp39551 = inst_39414;
var inst_39414__$1 = tmp39551;
var inst_39415__$1 = tmp39549;
var inst_39416__$1 = tmp39550;
var inst_39417__$1 = inst_39433;
var state_39537__$1 = (function (){var statearr_39556 = state_39537;
(statearr_39556[(18)] = inst_39432);

(statearr_39556[(14)] = inst_39415__$1);

(statearr_39556[(15)] = inst_39416__$1);

(statearr_39556[(16)] = inst_39417__$1);

(statearr_39556[(17)] = inst_39414__$1);

return statearr_39556;
})();
var statearr_39557_39633 = state_39537__$1;
(statearr_39557_39633[(2)] = null);

(statearr_39557_39633[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (21))){
var inst_39459 = (state_39537[(2)]);
var state_39537__$1 = state_39537;
var statearr_39561_39634 = state_39537__$1;
(statearr_39561_39634[(2)] = inst_39459);

(statearr_39561_39634[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (31))){
var inst_39485 = (state_39537[(10)]);
var inst_39489 = done.call(null,null);
var inst_39490 = cljs.core.async.untap_STAR_.call(null,m,inst_39485);
var state_39537__$1 = (function (){var statearr_39562 = state_39537;
(statearr_39562[(19)] = inst_39489);

return statearr_39562;
})();
var statearr_39563_39635 = state_39537__$1;
(statearr_39563_39635[(2)] = inst_39490);

(statearr_39563_39635[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (32))){
var inst_39479 = (state_39537[(20)]);
var inst_39477 = (state_39537[(21)]);
var inst_39480 = (state_39537[(9)]);
var inst_39478 = (state_39537[(11)]);
var inst_39492 = (state_39537[(2)]);
var inst_39493 = (inst_39480 + (1));
var tmp39558 = inst_39479;
var tmp39559 = inst_39477;
var tmp39560 = inst_39478;
var inst_39477__$1 = tmp39559;
var inst_39478__$1 = tmp39560;
var inst_39479__$1 = tmp39558;
var inst_39480__$1 = inst_39493;
var state_39537__$1 = (function (){var statearr_39564 = state_39537;
(statearr_39564[(20)] = inst_39479__$1);

(statearr_39564[(21)] = inst_39477__$1);

(statearr_39564[(22)] = inst_39492);

(statearr_39564[(9)] = inst_39480__$1);

(statearr_39564[(11)] = inst_39478__$1);

return statearr_39564;
})();
var statearr_39565_39636 = state_39537__$1;
(statearr_39565_39636[(2)] = null);

(statearr_39565_39636[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (40))){
var inst_39505 = (state_39537[(23)]);
var inst_39509 = done.call(null,null);
var inst_39510 = cljs.core.async.untap_STAR_.call(null,m,inst_39505);
var state_39537__$1 = (function (){var statearr_39566 = state_39537;
(statearr_39566[(24)] = inst_39509);

return statearr_39566;
})();
var statearr_39567_39637 = state_39537__$1;
(statearr_39567_39637[(2)] = inst_39510);

(statearr_39567_39637[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (33))){
var inst_39496 = (state_39537[(25)]);
var inst_39498 = cljs.core.chunked_seq_QMARK_.call(null,inst_39496);
var state_39537__$1 = state_39537;
if(inst_39498){
var statearr_39568_39638 = state_39537__$1;
(statearr_39568_39638[(1)] = (36));

} else {
var statearr_39569_39639 = state_39537__$1;
(statearr_39569_39639[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (13))){
var inst_39426 = (state_39537[(26)]);
var inst_39429 = cljs.core.async.close_BANG_.call(null,inst_39426);
var state_39537__$1 = state_39537;
var statearr_39570_39640 = state_39537__$1;
(statearr_39570_39640[(2)] = inst_39429);

(statearr_39570_39640[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (22))){
var inst_39449 = (state_39537[(8)]);
var inst_39452 = cljs.core.async.close_BANG_.call(null,inst_39449);
var state_39537__$1 = state_39537;
var statearr_39571_39641 = state_39537__$1;
(statearr_39571_39641[(2)] = inst_39452);

(statearr_39571_39641[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (36))){
var inst_39496 = (state_39537[(25)]);
var inst_39500 = cljs.core.chunk_first.call(null,inst_39496);
var inst_39501 = cljs.core.chunk_rest.call(null,inst_39496);
var inst_39502 = cljs.core.count.call(null,inst_39500);
var inst_39477 = inst_39501;
var inst_39478 = inst_39500;
var inst_39479 = inst_39502;
var inst_39480 = (0);
var state_39537__$1 = (function (){var statearr_39572 = state_39537;
(statearr_39572[(20)] = inst_39479);

(statearr_39572[(21)] = inst_39477);

(statearr_39572[(9)] = inst_39480);

(statearr_39572[(11)] = inst_39478);

return statearr_39572;
})();
var statearr_39573_39642 = state_39537__$1;
(statearr_39573_39642[(2)] = null);

(statearr_39573_39642[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (41))){
var inst_39496 = (state_39537[(25)]);
var inst_39512 = (state_39537[(2)]);
var inst_39513 = cljs.core.next.call(null,inst_39496);
var inst_39477 = inst_39513;
var inst_39478 = null;
var inst_39479 = (0);
var inst_39480 = (0);
var state_39537__$1 = (function (){var statearr_39574 = state_39537;
(statearr_39574[(20)] = inst_39479);

(statearr_39574[(21)] = inst_39477);

(statearr_39574[(9)] = inst_39480);

(statearr_39574[(11)] = inst_39478);

(statearr_39574[(27)] = inst_39512);

return statearr_39574;
})();
var statearr_39575_39643 = state_39537__$1;
(statearr_39575_39643[(2)] = null);

(statearr_39575_39643[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (43))){
var state_39537__$1 = state_39537;
var statearr_39576_39644 = state_39537__$1;
(statearr_39576_39644[(2)] = null);

(statearr_39576_39644[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (29))){
var inst_39521 = (state_39537[(2)]);
var state_39537__$1 = state_39537;
var statearr_39577_39645 = state_39537__$1;
(statearr_39577_39645[(2)] = inst_39521);

(statearr_39577_39645[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (44))){
var inst_39530 = (state_39537[(2)]);
var state_39537__$1 = (function (){var statearr_39578 = state_39537;
(statearr_39578[(28)] = inst_39530);

return statearr_39578;
})();
var statearr_39579_39646 = state_39537__$1;
(statearr_39579_39646[(2)] = null);

(statearr_39579_39646[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (6))){
var inst_39469 = (state_39537[(29)]);
var inst_39468 = cljs.core.deref.call(null,cs);
var inst_39469__$1 = cljs.core.keys.call(null,inst_39468);
var inst_39470 = cljs.core.count.call(null,inst_39469__$1);
var inst_39471 = cljs.core.reset_BANG_.call(null,dctr,inst_39470);
var inst_39476 = cljs.core.seq.call(null,inst_39469__$1);
var inst_39477 = inst_39476;
var inst_39478 = null;
var inst_39479 = (0);
var inst_39480 = (0);
var state_39537__$1 = (function (){var statearr_39580 = state_39537;
(statearr_39580[(20)] = inst_39479);

(statearr_39580[(21)] = inst_39477);

(statearr_39580[(30)] = inst_39471);

(statearr_39580[(9)] = inst_39480);

(statearr_39580[(11)] = inst_39478);

(statearr_39580[(29)] = inst_39469__$1);

return statearr_39580;
})();
var statearr_39581_39647 = state_39537__$1;
(statearr_39581_39647[(2)] = null);

(statearr_39581_39647[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (28))){
var inst_39477 = (state_39537[(21)]);
var inst_39496 = (state_39537[(25)]);
var inst_39496__$1 = cljs.core.seq.call(null,inst_39477);
var state_39537__$1 = (function (){var statearr_39582 = state_39537;
(statearr_39582[(25)] = inst_39496__$1);

return statearr_39582;
})();
if(inst_39496__$1){
var statearr_39583_39648 = state_39537__$1;
(statearr_39583_39648[(1)] = (33));

} else {
var statearr_39584_39649 = state_39537__$1;
(statearr_39584_39649[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (25))){
var inst_39479 = (state_39537[(20)]);
var inst_39480 = (state_39537[(9)]);
var inst_39482 = (inst_39480 < inst_39479);
var inst_39483 = inst_39482;
var state_39537__$1 = state_39537;
if(cljs.core.truth_(inst_39483)){
var statearr_39585_39650 = state_39537__$1;
(statearr_39585_39650[(1)] = (27));

} else {
var statearr_39586_39651 = state_39537__$1;
(statearr_39586_39651[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (34))){
var state_39537__$1 = state_39537;
var statearr_39587_39652 = state_39537__$1;
(statearr_39587_39652[(2)] = null);

(statearr_39587_39652[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (17))){
var state_39537__$1 = state_39537;
var statearr_39588_39653 = state_39537__$1;
(statearr_39588_39653[(2)] = null);

(statearr_39588_39653[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (3))){
var inst_39535 = (state_39537[(2)]);
var state_39537__$1 = state_39537;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39537__$1,inst_39535);
} else {
if((state_val_39538 === (12))){
var inst_39464 = (state_39537[(2)]);
var state_39537__$1 = state_39537;
var statearr_39589_39654 = state_39537__$1;
(statearr_39589_39654[(2)] = inst_39464);

(statearr_39589_39654[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (2))){
var state_39537__$1 = state_39537;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39537__$1,(4),ch);
} else {
if((state_val_39538 === (23))){
var state_39537__$1 = state_39537;
var statearr_39590_39655 = state_39537__$1;
(statearr_39590_39655[(2)] = null);

(statearr_39590_39655[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (35))){
var inst_39519 = (state_39537[(2)]);
var state_39537__$1 = state_39537;
var statearr_39591_39656 = state_39537__$1;
(statearr_39591_39656[(2)] = inst_39519);

(statearr_39591_39656[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (19))){
var inst_39436 = (state_39537[(7)]);
var inst_39440 = cljs.core.chunk_first.call(null,inst_39436);
var inst_39441 = cljs.core.chunk_rest.call(null,inst_39436);
var inst_39442 = cljs.core.count.call(null,inst_39440);
var inst_39414 = inst_39441;
var inst_39415 = inst_39440;
var inst_39416 = inst_39442;
var inst_39417 = (0);
var state_39537__$1 = (function (){var statearr_39592 = state_39537;
(statearr_39592[(14)] = inst_39415);

(statearr_39592[(15)] = inst_39416);

(statearr_39592[(16)] = inst_39417);

(statearr_39592[(17)] = inst_39414);

return statearr_39592;
})();
var statearr_39593_39657 = state_39537__$1;
(statearr_39593_39657[(2)] = null);

(statearr_39593_39657[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (11))){
var inst_39436 = (state_39537[(7)]);
var inst_39414 = (state_39537[(17)]);
var inst_39436__$1 = cljs.core.seq.call(null,inst_39414);
var state_39537__$1 = (function (){var statearr_39594 = state_39537;
(statearr_39594[(7)] = inst_39436__$1);

return statearr_39594;
})();
if(inst_39436__$1){
var statearr_39595_39658 = state_39537__$1;
(statearr_39595_39658[(1)] = (16));

} else {
var statearr_39596_39659 = state_39537__$1;
(statearr_39596_39659[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (9))){
var inst_39466 = (state_39537[(2)]);
var state_39537__$1 = state_39537;
var statearr_39597_39660 = state_39537__$1;
(statearr_39597_39660[(2)] = inst_39466);

(statearr_39597_39660[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (5))){
var inst_39412 = cljs.core.deref.call(null,cs);
var inst_39413 = cljs.core.seq.call(null,inst_39412);
var inst_39414 = inst_39413;
var inst_39415 = null;
var inst_39416 = (0);
var inst_39417 = (0);
var state_39537__$1 = (function (){var statearr_39598 = state_39537;
(statearr_39598[(14)] = inst_39415);

(statearr_39598[(15)] = inst_39416);

(statearr_39598[(16)] = inst_39417);

(statearr_39598[(17)] = inst_39414);

return statearr_39598;
})();
var statearr_39599_39661 = state_39537__$1;
(statearr_39599_39661[(2)] = null);

(statearr_39599_39661[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (14))){
var state_39537__$1 = state_39537;
var statearr_39600_39662 = state_39537__$1;
(statearr_39600_39662[(2)] = null);

(statearr_39600_39662[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (45))){
var inst_39527 = (state_39537[(2)]);
var state_39537__$1 = state_39537;
var statearr_39601_39663 = state_39537__$1;
(statearr_39601_39663[(2)] = inst_39527);

(statearr_39601_39663[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (26))){
var inst_39469 = (state_39537[(29)]);
var inst_39523 = (state_39537[(2)]);
var inst_39524 = cljs.core.seq.call(null,inst_39469);
var state_39537__$1 = (function (){var statearr_39602 = state_39537;
(statearr_39602[(31)] = inst_39523);

return statearr_39602;
})();
if(inst_39524){
var statearr_39603_39664 = state_39537__$1;
(statearr_39603_39664[(1)] = (42));

} else {
var statearr_39604_39665 = state_39537__$1;
(statearr_39604_39665[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (16))){
var inst_39436 = (state_39537[(7)]);
var inst_39438 = cljs.core.chunked_seq_QMARK_.call(null,inst_39436);
var state_39537__$1 = state_39537;
if(inst_39438){
var statearr_39605_39666 = state_39537__$1;
(statearr_39605_39666[(1)] = (19));

} else {
var statearr_39606_39667 = state_39537__$1;
(statearr_39606_39667[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (38))){
var inst_39516 = (state_39537[(2)]);
var state_39537__$1 = state_39537;
var statearr_39607_39668 = state_39537__$1;
(statearr_39607_39668[(2)] = inst_39516);

(statearr_39607_39668[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (30))){
var state_39537__$1 = state_39537;
var statearr_39608_39669 = state_39537__$1;
(statearr_39608_39669[(2)] = null);

(statearr_39608_39669[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (10))){
var inst_39415 = (state_39537[(14)]);
var inst_39417 = (state_39537[(16)]);
var inst_39425 = cljs.core._nth.call(null,inst_39415,inst_39417);
var inst_39426 = cljs.core.nth.call(null,inst_39425,(0),null);
var inst_39427 = cljs.core.nth.call(null,inst_39425,(1),null);
var state_39537__$1 = (function (){var statearr_39609 = state_39537;
(statearr_39609[(26)] = inst_39426);

return statearr_39609;
})();
if(cljs.core.truth_(inst_39427)){
var statearr_39610_39670 = state_39537__$1;
(statearr_39610_39670[(1)] = (13));

} else {
var statearr_39611_39671 = state_39537__$1;
(statearr_39611_39671[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (18))){
var inst_39462 = (state_39537[(2)]);
var state_39537__$1 = state_39537;
var statearr_39612_39672 = state_39537__$1;
(statearr_39612_39672[(2)] = inst_39462);

(statearr_39612_39672[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (42))){
var state_39537__$1 = state_39537;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39537__$1,(45),dchan);
} else {
if((state_val_39538 === (37))){
var inst_39496 = (state_39537[(25)]);
var inst_39505 = (state_39537[(23)]);
var inst_39405 = (state_39537[(12)]);
var inst_39505__$1 = cljs.core.first.call(null,inst_39496);
var inst_39506 = cljs.core.async.put_BANG_.call(null,inst_39505__$1,inst_39405,done);
var state_39537__$1 = (function (){var statearr_39613 = state_39537;
(statearr_39613[(23)] = inst_39505__$1);

return statearr_39613;
})();
if(cljs.core.truth_(inst_39506)){
var statearr_39614_39673 = state_39537__$1;
(statearr_39614_39673[(1)] = (39));

} else {
var statearr_39615_39674 = state_39537__$1;
(statearr_39615_39674[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39538 === (8))){
var inst_39416 = (state_39537[(15)]);
var inst_39417 = (state_39537[(16)]);
var inst_39419 = (inst_39417 < inst_39416);
var inst_39420 = inst_39419;
var state_39537__$1 = state_39537;
if(cljs.core.truth_(inst_39420)){
var statearr_39616_39675 = state_39537__$1;
(statearr_39616_39675[(1)] = (10));

} else {
var statearr_39617_39676 = state_39537__$1;
(statearr_39617_39676[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38817__auto___39622,cs,m,dchan,dctr,done))
;
return ((function (switch__38764__auto__,c__38817__auto___39622,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__38765__auto__ = null;
var cljs$core$async$mult_$_state_machine__38765__auto____0 = (function (){
var statearr_39618 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39618[(0)] = cljs$core$async$mult_$_state_machine__38765__auto__);

(statearr_39618[(1)] = (1));

return statearr_39618;
});
var cljs$core$async$mult_$_state_machine__38765__auto____1 = (function (state_39537){
while(true){
var ret_value__38766__auto__ = (function (){try{while(true){
var result__38767__auto__ = switch__38764__auto__.call(null,state_39537);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38767__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38767__auto__;
}
break;
}
}catch (e39619){if((e39619 instanceof Object)){
var ex__38768__auto__ = e39619;
var statearr_39620_39677 = state_39537;
(statearr_39620_39677[(5)] = ex__38768__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_39537);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39619;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38766__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39678 = state_39537;
state_39537 = G__39678;
continue;
} else {
return ret_value__38766__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__38765__auto__ = function(state_39537){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__38765__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__38765__auto____1.call(this,state_39537);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__38765__auto____0;
cljs$core$async$mult_$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__38765__auto____1;
return cljs$core$async$mult_$_state_machine__38765__auto__;
})()
;})(switch__38764__auto__,c__38817__auto___39622,cs,m,dchan,dctr,done))
})();
var state__38819__auto__ = (function (){var statearr_39621 = f__38818__auto__.call(null);
(statearr_39621[(6)] = c__38817__auto___39622);

return statearr_39621;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38819__auto__);
});})(c__38817__auto___39622,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__39680 = arguments.length;
switch (G__39680) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__28672__auto__ = (((m == null))?null:m);
var m__28673__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__28672__auto__)]);
if(!((m__28673__auto__ == null))){
return m__28673__auto__.call(null,m,ch);
} else {
var m__28673__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__28673__auto____$1 == null))){
return m__28673__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__28672__auto__ = (((m == null))?null:m);
var m__28673__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__28672__auto__)]);
if(!((m__28673__auto__ == null))){
return m__28673__auto__.call(null,m,ch);
} else {
var m__28673__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__28673__auto____$1 == null))){
return m__28673__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__28672__auto__ = (((m == null))?null:m);
var m__28673__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__28672__auto__)]);
if(!((m__28673__auto__ == null))){
return m__28673__auto__.call(null,m);
} else {
var m__28673__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__28673__auto____$1 == null))){
return m__28673__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__28672__auto__ = (((m == null))?null:m);
var m__28673__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__28672__auto__)]);
if(!((m__28673__auto__ == null))){
return m__28673__auto__.call(null,m,state_map);
} else {
var m__28673__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__28673__auto____$1 == null))){
return m__28673__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__28672__auto__ = (((m == null))?null:m);
var m__28673__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__28672__auto__)]);
if(!((m__28673__auto__ == null))){
return m__28673__auto__.call(null,m,mode);
} else {
var m__28673__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__28673__auto____$1 == null))){
return m__28673__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__29165__auto__ = [];
var len__29158__auto___39692 = arguments.length;
var i__29159__auto___39693 = (0);
while(true){
if((i__29159__auto___39693 < len__29158__auto___39692)){
args__29165__auto__.push((arguments[i__29159__auto___39693]));

var G__39694 = (i__29159__auto___39693 + (1));
i__29159__auto___39693 = G__39694;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((3) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29166__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__39686){
var map__39687 = p__39686;
var map__39687__$1 = ((((!((map__39687 == null)))?((((map__39687.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39687.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__39687):map__39687);
var opts = map__39687__$1;
var statearr_39689_39695 = state;
(statearr_39689_39695[(1)] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__39687,map__39687__$1,opts){
return (function (val){
var statearr_39690_39696 = state;
(statearr_39690_39696[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__39687,map__39687__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_39691_39697 = state;
(statearr_39691_39697[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq39682){
var G__39683 = cljs.core.first.call(null,seq39682);
var seq39682__$1 = cljs.core.next.call(null,seq39682);
var G__39684 = cljs.core.first.call(null,seq39682__$1);
var seq39682__$2 = cljs.core.next.call(null,seq39682__$1);
var G__39685 = cljs.core.first.call(null,seq39682__$2);
var seq39682__$3 = cljs.core.next.call(null,seq39682__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__39683,G__39684,G__39685,seq39682__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async39698 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async39698 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta39699){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta39699 = meta39699;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async39698.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_39700,meta39699__$1){
var self__ = this;
var _39700__$1 = this;
return (new cljs.core.async.t_cljs$core$async39698(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta39699__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39698.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_39700){
var self__ = this;
var _39700__$1 = this;
return self__.meta39699;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39698.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async39698.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39698.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async39698.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39698.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39698.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39698.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39698.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39698.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta39699","meta39699",402063616,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39698.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async39698.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async39698";

cljs.core.async.t_cljs$core$async39698.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__28614__auto__,writer__28615__auto__,opt__28616__auto__){
return cljs.core._write.call(null,writer__28615__auto__,"cljs.core.async/t_cljs$core$async39698");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async39698 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async39698(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta39699){
return (new cljs.core.async.t_cljs$core$async39698(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta39699));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async39698(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__38817__auto___39862 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38817__auto___39862,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__38818__auto__ = (function (){var switch__38764__auto__ = ((function (c__38817__auto___39862,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_39802){
var state_val_39803 = (state_39802[(1)]);
if((state_val_39803 === (7))){
var inst_39717 = (state_39802[(2)]);
var state_39802__$1 = state_39802;
var statearr_39804_39863 = state_39802__$1;
(statearr_39804_39863[(2)] = inst_39717);

(statearr_39804_39863[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (20))){
var inst_39729 = (state_39802[(7)]);
var state_39802__$1 = state_39802;
var statearr_39805_39864 = state_39802__$1;
(statearr_39805_39864[(2)] = inst_39729);

(statearr_39805_39864[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (27))){
var state_39802__$1 = state_39802;
var statearr_39806_39865 = state_39802__$1;
(statearr_39806_39865[(2)] = null);

(statearr_39806_39865[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (1))){
var inst_39704 = (state_39802[(8)]);
var inst_39704__$1 = calc_state.call(null);
var inst_39706 = (inst_39704__$1 == null);
var inst_39707 = cljs.core.not.call(null,inst_39706);
var state_39802__$1 = (function (){var statearr_39807 = state_39802;
(statearr_39807[(8)] = inst_39704__$1);

return statearr_39807;
})();
if(inst_39707){
var statearr_39808_39866 = state_39802__$1;
(statearr_39808_39866[(1)] = (2));

} else {
var statearr_39809_39867 = state_39802__$1;
(statearr_39809_39867[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (24))){
var inst_39762 = (state_39802[(9)]);
var inst_39776 = (state_39802[(10)]);
var inst_39753 = (state_39802[(11)]);
var inst_39776__$1 = inst_39753.call(null,inst_39762);
var state_39802__$1 = (function (){var statearr_39810 = state_39802;
(statearr_39810[(10)] = inst_39776__$1);

return statearr_39810;
})();
if(cljs.core.truth_(inst_39776__$1)){
var statearr_39811_39868 = state_39802__$1;
(statearr_39811_39868[(1)] = (29));

} else {
var statearr_39812_39869 = state_39802__$1;
(statearr_39812_39869[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (4))){
var inst_39720 = (state_39802[(2)]);
var state_39802__$1 = state_39802;
if(cljs.core.truth_(inst_39720)){
var statearr_39813_39870 = state_39802__$1;
(statearr_39813_39870[(1)] = (8));

} else {
var statearr_39814_39871 = state_39802__$1;
(statearr_39814_39871[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (15))){
var inst_39747 = (state_39802[(2)]);
var state_39802__$1 = state_39802;
if(cljs.core.truth_(inst_39747)){
var statearr_39815_39872 = state_39802__$1;
(statearr_39815_39872[(1)] = (19));

} else {
var statearr_39816_39873 = state_39802__$1;
(statearr_39816_39873[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (21))){
var inst_39752 = (state_39802[(12)]);
var inst_39752__$1 = (state_39802[(2)]);
var inst_39753 = cljs.core.get.call(null,inst_39752__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_39754 = cljs.core.get.call(null,inst_39752__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_39755 = cljs.core.get.call(null,inst_39752__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_39802__$1 = (function (){var statearr_39817 = state_39802;
(statearr_39817[(12)] = inst_39752__$1);

(statearr_39817[(13)] = inst_39754);

(statearr_39817[(11)] = inst_39753);

return statearr_39817;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_39802__$1,(22),inst_39755);
} else {
if((state_val_39803 === (31))){
var inst_39784 = (state_39802[(2)]);
var state_39802__$1 = state_39802;
if(cljs.core.truth_(inst_39784)){
var statearr_39818_39874 = state_39802__$1;
(statearr_39818_39874[(1)] = (32));

} else {
var statearr_39819_39875 = state_39802__$1;
(statearr_39819_39875[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (32))){
var inst_39761 = (state_39802[(14)]);
var state_39802__$1 = state_39802;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_39802__$1,(35),out,inst_39761);
} else {
if((state_val_39803 === (33))){
var inst_39752 = (state_39802[(12)]);
var inst_39729 = inst_39752;
var state_39802__$1 = (function (){var statearr_39820 = state_39802;
(statearr_39820[(7)] = inst_39729);

return statearr_39820;
})();
var statearr_39821_39876 = state_39802__$1;
(statearr_39821_39876[(2)] = null);

(statearr_39821_39876[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (13))){
var inst_39729 = (state_39802[(7)]);
var inst_39736 = inst_39729.cljs$lang$protocol_mask$partition0$;
var inst_39737 = (inst_39736 & (64));
var inst_39738 = inst_39729.cljs$core$ISeq$;
var inst_39739 = (cljs.core.PROTOCOL_SENTINEL === inst_39738);
var inst_39740 = (inst_39737) || (inst_39739);
var state_39802__$1 = state_39802;
if(cljs.core.truth_(inst_39740)){
var statearr_39822_39877 = state_39802__$1;
(statearr_39822_39877[(1)] = (16));

} else {
var statearr_39823_39878 = state_39802__$1;
(statearr_39823_39878[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (22))){
var inst_39761 = (state_39802[(14)]);
var inst_39762 = (state_39802[(9)]);
var inst_39760 = (state_39802[(2)]);
var inst_39761__$1 = cljs.core.nth.call(null,inst_39760,(0),null);
var inst_39762__$1 = cljs.core.nth.call(null,inst_39760,(1),null);
var inst_39763 = (inst_39761__$1 == null);
var inst_39764 = cljs.core._EQ_.call(null,inst_39762__$1,change);
var inst_39765 = (inst_39763) || (inst_39764);
var state_39802__$1 = (function (){var statearr_39824 = state_39802;
(statearr_39824[(14)] = inst_39761__$1);

(statearr_39824[(9)] = inst_39762__$1);

return statearr_39824;
})();
if(cljs.core.truth_(inst_39765)){
var statearr_39825_39879 = state_39802__$1;
(statearr_39825_39879[(1)] = (23));

} else {
var statearr_39826_39880 = state_39802__$1;
(statearr_39826_39880[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (36))){
var inst_39752 = (state_39802[(12)]);
var inst_39729 = inst_39752;
var state_39802__$1 = (function (){var statearr_39827 = state_39802;
(statearr_39827[(7)] = inst_39729);

return statearr_39827;
})();
var statearr_39828_39881 = state_39802__$1;
(statearr_39828_39881[(2)] = null);

(statearr_39828_39881[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (29))){
var inst_39776 = (state_39802[(10)]);
var state_39802__$1 = state_39802;
var statearr_39829_39882 = state_39802__$1;
(statearr_39829_39882[(2)] = inst_39776);

(statearr_39829_39882[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (6))){
var state_39802__$1 = state_39802;
var statearr_39830_39883 = state_39802__$1;
(statearr_39830_39883[(2)] = false);

(statearr_39830_39883[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (28))){
var inst_39772 = (state_39802[(2)]);
var inst_39773 = calc_state.call(null);
var inst_39729 = inst_39773;
var state_39802__$1 = (function (){var statearr_39831 = state_39802;
(statearr_39831[(15)] = inst_39772);

(statearr_39831[(7)] = inst_39729);

return statearr_39831;
})();
var statearr_39832_39884 = state_39802__$1;
(statearr_39832_39884[(2)] = null);

(statearr_39832_39884[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (25))){
var inst_39798 = (state_39802[(2)]);
var state_39802__$1 = state_39802;
var statearr_39833_39885 = state_39802__$1;
(statearr_39833_39885[(2)] = inst_39798);

(statearr_39833_39885[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (34))){
var inst_39796 = (state_39802[(2)]);
var state_39802__$1 = state_39802;
var statearr_39834_39886 = state_39802__$1;
(statearr_39834_39886[(2)] = inst_39796);

(statearr_39834_39886[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (17))){
var state_39802__$1 = state_39802;
var statearr_39835_39887 = state_39802__$1;
(statearr_39835_39887[(2)] = false);

(statearr_39835_39887[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (3))){
var state_39802__$1 = state_39802;
var statearr_39836_39888 = state_39802__$1;
(statearr_39836_39888[(2)] = false);

(statearr_39836_39888[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (12))){
var inst_39800 = (state_39802[(2)]);
var state_39802__$1 = state_39802;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39802__$1,inst_39800);
} else {
if((state_val_39803 === (2))){
var inst_39704 = (state_39802[(8)]);
var inst_39709 = inst_39704.cljs$lang$protocol_mask$partition0$;
var inst_39710 = (inst_39709 & (64));
var inst_39711 = inst_39704.cljs$core$ISeq$;
var inst_39712 = (cljs.core.PROTOCOL_SENTINEL === inst_39711);
var inst_39713 = (inst_39710) || (inst_39712);
var state_39802__$1 = state_39802;
if(cljs.core.truth_(inst_39713)){
var statearr_39837_39889 = state_39802__$1;
(statearr_39837_39889[(1)] = (5));

} else {
var statearr_39838_39890 = state_39802__$1;
(statearr_39838_39890[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (23))){
var inst_39761 = (state_39802[(14)]);
var inst_39767 = (inst_39761 == null);
var state_39802__$1 = state_39802;
if(cljs.core.truth_(inst_39767)){
var statearr_39839_39891 = state_39802__$1;
(statearr_39839_39891[(1)] = (26));

} else {
var statearr_39840_39892 = state_39802__$1;
(statearr_39840_39892[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (35))){
var inst_39787 = (state_39802[(2)]);
var state_39802__$1 = state_39802;
if(cljs.core.truth_(inst_39787)){
var statearr_39841_39893 = state_39802__$1;
(statearr_39841_39893[(1)] = (36));

} else {
var statearr_39842_39894 = state_39802__$1;
(statearr_39842_39894[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (19))){
var inst_39729 = (state_39802[(7)]);
var inst_39749 = cljs.core.apply.call(null,cljs.core.hash_map,inst_39729);
var state_39802__$1 = state_39802;
var statearr_39843_39895 = state_39802__$1;
(statearr_39843_39895[(2)] = inst_39749);

(statearr_39843_39895[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (11))){
var inst_39729 = (state_39802[(7)]);
var inst_39733 = (inst_39729 == null);
var inst_39734 = cljs.core.not.call(null,inst_39733);
var state_39802__$1 = state_39802;
if(inst_39734){
var statearr_39844_39896 = state_39802__$1;
(statearr_39844_39896[(1)] = (13));

} else {
var statearr_39845_39897 = state_39802__$1;
(statearr_39845_39897[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (9))){
var inst_39704 = (state_39802[(8)]);
var state_39802__$1 = state_39802;
var statearr_39846_39898 = state_39802__$1;
(statearr_39846_39898[(2)] = inst_39704);

(statearr_39846_39898[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (5))){
var state_39802__$1 = state_39802;
var statearr_39847_39899 = state_39802__$1;
(statearr_39847_39899[(2)] = true);

(statearr_39847_39899[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (14))){
var state_39802__$1 = state_39802;
var statearr_39848_39900 = state_39802__$1;
(statearr_39848_39900[(2)] = false);

(statearr_39848_39900[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (26))){
var inst_39762 = (state_39802[(9)]);
var inst_39769 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_39762);
var state_39802__$1 = state_39802;
var statearr_39849_39901 = state_39802__$1;
(statearr_39849_39901[(2)] = inst_39769);

(statearr_39849_39901[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (16))){
var state_39802__$1 = state_39802;
var statearr_39850_39902 = state_39802__$1;
(statearr_39850_39902[(2)] = true);

(statearr_39850_39902[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (38))){
var inst_39792 = (state_39802[(2)]);
var state_39802__$1 = state_39802;
var statearr_39851_39903 = state_39802__$1;
(statearr_39851_39903[(2)] = inst_39792);

(statearr_39851_39903[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (30))){
var inst_39754 = (state_39802[(13)]);
var inst_39762 = (state_39802[(9)]);
var inst_39753 = (state_39802[(11)]);
var inst_39779 = cljs.core.empty_QMARK_.call(null,inst_39753);
var inst_39780 = inst_39754.call(null,inst_39762);
var inst_39781 = cljs.core.not.call(null,inst_39780);
var inst_39782 = (inst_39779) && (inst_39781);
var state_39802__$1 = state_39802;
var statearr_39852_39904 = state_39802__$1;
(statearr_39852_39904[(2)] = inst_39782);

(statearr_39852_39904[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (10))){
var inst_39704 = (state_39802[(8)]);
var inst_39725 = (state_39802[(2)]);
var inst_39726 = cljs.core.get.call(null,inst_39725,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_39727 = cljs.core.get.call(null,inst_39725,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_39728 = cljs.core.get.call(null,inst_39725,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_39729 = inst_39704;
var state_39802__$1 = (function (){var statearr_39853 = state_39802;
(statearr_39853[(16)] = inst_39727);

(statearr_39853[(17)] = inst_39728);

(statearr_39853[(7)] = inst_39729);

(statearr_39853[(18)] = inst_39726);

return statearr_39853;
})();
var statearr_39854_39905 = state_39802__$1;
(statearr_39854_39905[(2)] = null);

(statearr_39854_39905[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (18))){
var inst_39744 = (state_39802[(2)]);
var state_39802__$1 = state_39802;
var statearr_39855_39906 = state_39802__$1;
(statearr_39855_39906[(2)] = inst_39744);

(statearr_39855_39906[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (37))){
var state_39802__$1 = state_39802;
var statearr_39856_39907 = state_39802__$1;
(statearr_39856_39907[(2)] = null);

(statearr_39856_39907[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39803 === (8))){
var inst_39704 = (state_39802[(8)]);
var inst_39722 = cljs.core.apply.call(null,cljs.core.hash_map,inst_39704);
var state_39802__$1 = state_39802;
var statearr_39857_39908 = state_39802__$1;
(statearr_39857_39908[(2)] = inst_39722);

(statearr_39857_39908[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38817__auto___39862,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__38764__auto__,c__38817__auto___39862,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__38765__auto__ = null;
var cljs$core$async$mix_$_state_machine__38765__auto____0 = (function (){
var statearr_39858 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39858[(0)] = cljs$core$async$mix_$_state_machine__38765__auto__);

(statearr_39858[(1)] = (1));

return statearr_39858;
});
var cljs$core$async$mix_$_state_machine__38765__auto____1 = (function (state_39802){
while(true){
var ret_value__38766__auto__ = (function (){try{while(true){
var result__38767__auto__ = switch__38764__auto__.call(null,state_39802);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38767__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38767__auto__;
}
break;
}
}catch (e39859){if((e39859 instanceof Object)){
var ex__38768__auto__ = e39859;
var statearr_39860_39909 = state_39802;
(statearr_39860_39909[(5)] = ex__38768__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_39802);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39859;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38766__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39910 = state_39802;
state_39802 = G__39910;
continue;
} else {
return ret_value__38766__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__38765__auto__ = function(state_39802){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__38765__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__38765__auto____1.call(this,state_39802);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__38765__auto____0;
cljs$core$async$mix_$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__38765__auto____1;
return cljs$core$async$mix_$_state_machine__38765__auto__;
})()
;})(switch__38764__auto__,c__38817__auto___39862,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__38819__auto__ = (function (){var statearr_39861 = f__38818__auto__.call(null);
(statearr_39861[(6)] = c__38817__auto___39862);

return statearr_39861;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38819__auto__);
});})(c__38817__auto___39862,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__28672__auto__ = (((p == null))?null:p);
var m__28673__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__28672__auto__)]);
if(!((m__28673__auto__ == null))){
return m__28673__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__28673__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__28673__auto____$1 == null))){
return m__28673__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__28672__auto__ = (((p == null))?null:p);
var m__28673__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__28672__auto__)]);
if(!((m__28673__auto__ == null))){
return m__28673__auto__.call(null,p,v,ch);
} else {
var m__28673__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__28673__auto____$1 == null))){
return m__28673__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__39912 = arguments.length;
switch (G__39912) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__28672__auto__ = (((p == null))?null:p);
var m__28673__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__28672__auto__)]);
if(!((m__28673__auto__ == null))){
return m__28673__auto__.call(null,p);
} else {
var m__28673__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__28673__auto____$1 == null))){
return m__28673__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__28672__auto__ = (((p == null))?null:p);
var m__28673__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__28672__auto__)]);
if(!((m__28673__auto__ == null))){
return m__28673__auto__.call(null,p,v);
} else {
var m__28673__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__28673__auto____$1 == null))){
return m__28673__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__39916 = arguments.length;
switch (G__39916) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__27989__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__27989__auto__)){
return or__27989__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__27989__auto__,mults){
return (function (p1__39914_SHARP_){
if(cljs.core.truth_(p1__39914_SHARP_.call(null,topic))){
return p1__39914_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__39914_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__27989__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async39917 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async39917 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta39918){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta39918 = meta39918;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async39917.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_39919,meta39918__$1){
var self__ = this;
var _39919__$1 = this;
return (new cljs.core.async.t_cljs$core$async39917(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta39918__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async39917.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_39919){
var self__ = this;
var _39919__$1 = this;
return self__.meta39918;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async39917.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async39917.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async39917.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async39917.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async39917.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async39917.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async39917.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async39917.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta39918","meta39918",1233787673,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async39917.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async39917.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async39917";

cljs.core.async.t_cljs$core$async39917.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__28614__auto__,writer__28615__auto__,opt__28616__auto__){
return cljs.core._write.call(null,writer__28615__auto__,"cljs.core.async/t_cljs$core$async39917");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async39917 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async39917(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta39918){
return (new cljs.core.async.t_cljs$core$async39917(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta39918));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async39917(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__38817__auto___40037 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38817__auto___40037,mults,ensure_mult,p){
return (function (){
var f__38818__auto__ = (function (){var switch__38764__auto__ = ((function (c__38817__auto___40037,mults,ensure_mult,p){
return (function (state_39991){
var state_val_39992 = (state_39991[(1)]);
if((state_val_39992 === (7))){
var inst_39987 = (state_39991[(2)]);
var state_39991__$1 = state_39991;
var statearr_39993_40038 = state_39991__$1;
(statearr_39993_40038[(2)] = inst_39987);

(statearr_39993_40038[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39992 === (20))){
var state_39991__$1 = state_39991;
var statearr_39994_40039 = state_39991__$1;
(statearr_39994_40039[(2)] = null);

(statearr_39994_40039[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39992 === (1))){
var state_39991__$1 = state_39991;
var statearr_39995_40040 = state_39991__$1;
(statearr_39995_40040[(2)] = null);

(statearr_39995_40040[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39992 === (24))){
var inst_39970 = (state_39991[(7)]);
var inst_39979 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_39970);
var state_39991__$1 = state_39991;
var statearr_39996_40041 = state_39991__$1;
(statearr_39996_40041[(2)] = inst_39979);

(statearr_39996_40041[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39992 === (4))){
var inst_39922 = (state_39991[(8)]);
var inst_39922__$1 = (state_39991[(2)]);
var inst_39923 = (inst_39922__$1 == null);
var state_39991__$1 = (function (){var statearr_39997 = state_39991;
(statearr_39997[(8)] = inst_39922__$1);

return statearr_39997;
})();
if(cljs.core.truth_(inst_39923)){
var statearr_39998_40042 = state_39991__$1;
(statearr_39998_40042[(1)] = (5));

} else {
var statearr_39999_40043 = state_39991__$1;
(statearr_39999_40043[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39992 === (15))){
var inst_39964 = (state_39991[(2)]);
var state_39991__$1 = state_39991;
var statearr_40000_40044 = state_39991__$1;
(statearr_40000_40044[(2)] = inst_39964);

(statearr_40000_40044[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39992 === (21))){
var inst_39984 = (state_39991[(2)]);
var state_39991__$1 = (function (){var statearr_40001 = state_39991;
(statearr_40001[(9)] = inst_39984);

return statearr_40001;
})();
var statearr_40002_40045 = state_39991__$1;
(statearr_40002_40045[(2)] = null);

(statearr_40002_40045[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39992 === (13))){
var inst_39946 = (state_39991[(10)]);
var inst_39948 = cljs.core.chunked_seq_QMARK_.call(null,inst_39946);
var state_39991__$1 = state_39991;
if(inst_39948){
var statearr_40003_40046 = state_39991__$1;
(statearr_40003_40046[(1)] = (16));

} else {
var statearr_40004_40047 = state_39991__$1;
(statearr_40004_40047[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39992 === (22))){
var inst_39976 = (state_39991[(2)]);
var state_39991__$1 = state_39991;
if(cljs.core.truth_(inst_39976)){
var statearr_40005_40048 = state_39991__$1;
(statearr_40005_40048[(1)] = (23));

} else {
var statearr_40006_40049 = state_39991__$1;
(statearr_40006_40049[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39992 === (6))){
var inst_39972 = (state_39991[(11)]);
var inst_39970 = (state_39991[(7)]);
var inst_39922 = (state_39991[(8)]);
var inst_39970__$1 = topic_fn.call(null,inst_39922);
var inst_39971 = cljs.core.deref.call(null,mults);
var inst_39972__$1 = cljs.core.get.call(null,inst_39971,inst_39970__$1);
var state_39991__$1 = (function (){var statearr_40007 = state_39991;
(statearr_40007[(11)] = inst_39972__$1);

(statearr_40007[(7)] = inst_39970__$1);

return statearr_40007;
})();
if(cljs.core.truth_(inst_39972__$1)){
var statearr_40008_40050 = state_39991__$1;
(statearr_40008_40050[(1)] = (19));

} else {
var statearr_40009_40051 = state_39991__$1;
(statearr_40009_40051[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39992 === (25))){
var inst_39981 = (state_39991[(2)]);
var state_39991__$1 = state_39991;
var statearr_40010_40052 = state_39991__$1;
(statearr_40010_40052[(2)] = inst_39981);

(statearr_40010_40052[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39992 === (17))){
var inst_39946 = (state_39991[(10)]);
var inst_39955 = cljs.core.first.call(null,inst_39946);
var inst_39956 = cljs.core.async.muxch_STAR_.call(null,inst_39955);
var inst_39957 = cljs.core.async.close_BANG_.call(null,inst_39956);
var inst_39958 = cljs.core.next.call(null,inst_39946);
var inst_39932 = inst_39958;
var inst_39933 = null;
var inst_39934 = (0);
var inst_39935 = (0);
var state_39991__$1 = (function (){var statearr_40011 = state_39991;
(statearr_40011[(12)] = inst_39934);

(statearr_40011[(13)] = inst_39933);

(statearr_40011[(14)] = inst_39935);

(statearr_40011[(15)] = inst_39932);

(statearr_40011[(16)] = inst_39957);

return statearr_40011;
})();
var statearr_40012_40053 = state_39991__$1;
(statearr_40012_40053[(2)] = null);

(statearr_40012_40053[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39992 === (3))){
var inst_39989 = (state_39991[(2)]);
var state_39991__$1 = state_39991;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39991__$1,inst_39989);
} else {
if((state_val_39992 === (12))){
var inst_39966 = (state_39991[(2)]);
var state_39991__$1 = state_39991;
var statearr_40013_40054 = state_39991__$1;
(statearr_40013_40054[(2)] = inst_39966);

(statearr_40013_40054[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39992 === (2))){
var state_39991__$1 = state_39991;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39991__$1,(4),ch);
} else {
if((state_val_39992 === (23))){
var state_39991__$1 = state_39991;
var statearr_40014_40055 = state_39991__$1;
(statearr_40014_40055[(2)] = null);

(statearr_40014_40055[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39992 === (19))){
var inst_39972 = (state_39991[(11)]);
var inst_39922 = (state_39991[(8)]);
var inst_39974 = cljs.core.async.muxch_STAR_.call(null,inst_39972);
var state_39991__$1 = state_39991;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_39991__$1,(22),inst_39974,inst_39922);
} else {
if((state_val_39992 === (11))){
var inst_39946 = (state_39991[(10)]);
var inst_39932 = (state_39991[(15)]);
var inst_39946__$1 = cljs.core.seq.call(null,inst_39932);
var state_39991__$1 = (function (){var statearr_40015 = state_39991;
(statearr_40015[(10)] = inst_39946__$1);

return statearr_40015;
})();
if(inst_39946__$1){
var statearr_40016_40056 = state_39991__$1;
(statearr_40016_40056[(1)] = (13));

} else {
var statearr_40017_40057 = state_39991__$1;
(statearr_40017_40057[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39992 === (9))){
var inst_39968 = (state_39991[(2)]);
var state_39991__$1 = state_39991;
var statearr_40018_40058 = state_39991__$1;
(statearr_40018_40058[(2)] = inst_39968);

(statearr_40018_40058[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39992 === (5))){
var inst_39929 = cljs.core.deref.call(null,mults);
var inst_39930 = cljs.core.vals.call(null,inst_39929);
var inst_39931 = cljs.core.seq.call(null,inst_39930);
var inst_39932 = inst_39931;
var inst_39933 = null;
var inst_39934 = (0);
var inst_39935 = (0);
var state_39991__$1 = (function (){var statearr_40019 = state_39991;
(statearr_40019[(12)] = inst_39934);

(statearr_40019[(13)] = inst_39933);

(statearr_40019[(14)] = inst_39935);

(statearr_40019[(15)] = inst_39932);

return statearr_40019;
})();
var statearr_40020_40059 = state_39991__$1;
(statearr_40020_40059[(2)] = null);

(statearr_40020_40059[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39992 === (14))){
var state_39991__$1 = state_39991;
var statearr_40024_40060 = state_39991__$1;
(statearr_40024_40060[(2)] = null);

(statearr_40024_40060[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39992 === (16))){
var inst_39946 = (state_39991[(10)]);
var inst_39950 = cljs.core.chunk_first.call(null,inst_39946);
var inst_39951 = cljs.core.chunk_rest.call(null,inst_39946);
var inst_39952 = cljs.core.count.call(null,inst_39950);
var inst_39932 = inst_39951;
var inst_39933 = inst_39950;
var inst_39934 = inst_39952;
var inst_39935 = (0);
var state_39991__$1 = (function (){var statearr_40025 = state_39991;
(statearr_40025[(12)] = inst_39934);

(statearr_40025[(13)] = inst_39933);

(statearr_40025[(14)] = inst_39935);

(statearr_40025[(15)] = inst_39932);

return statearr_40025;
})();
var statearr_40026_40061 = state_39991__$1;
(statearr_40026_40061[(2)] = null);

(statearr_40026_40061[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39992 === (10))){
var inst_39934 = (state_39991[(12)]);
var inst_39933 = (state_39991[(13)]);
var inst_39935 = (state_39991[(14)]);
var inst_39932 = (state_39991[(15)]);
var inst_39940 = cljs.core._nth.call(null,inst_39933,inst_39935);
var inst_39941 = cljs.core.async.muxch_STAR_.call(null,inst_39940);
var inst_39942 = cljs.core.async.close_BANG_.call(null,inst_39941);
var inst_39943 = (inst_39935 + (1));
var tmp40021 = inst_39934;
var tmp40022 = inst_39933;
var tmp40023 = inst_39932;
var inst_39932__$1 = tmp40023;
var inst_39933__$1 = tmp40022;
var inst_39934__$1 = tmp40021;
var inst_39935__$1 = inst_39943;
var state_39991__$1 = (function (){var statearr_40027 = state_39991;
(statearr_40027[(17)] = inst_39942);

(statearr_40027[(12)] = inst_39934__$1);

(statearr_40027[(13)] = inst_39933__$1);

(statearr_40027[(14)] = inst_39935__$1);

(statearr_40027[(15)] = inst_39932__$1);

return statearr_40027;
})();
var statearr_40028_40062 = state_39991__$1;
(statearr_40028_40062[(2)] = null);

(statearr_40028_40062[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39992 === (18))){
var inst_39961 = (state_39991[(2)]);
var state_39991__$1 = state_39991;
var statearr_40029_40063 = state_39991__$1;
(statearr_40029_40063[(2)] = inst_39961);

(statearr_40029_40063[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39992 === (8))){
var inst_39934 = (state_39991[(12)]);
var inst_39935 = (state_39991[(14)]);
var inst_39937 = (inst_39935 < inst_39934);
var inst_39938 = inst_39937;
var state_39991__$1 = state_39991;
if(cljs.core.truth_(inst_39938)){
var statearr_40030_40064 = state_39991__$1;
(statearr_40030_40064[(1)] = (10));

} else {
var statearr_40031_40065 = state_39991__$1;
(statearr_40031_40065[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38817__auto___40037,mults,ensure_mult,p))
;
return ((function (switch__38764__auto__,c__38817__auto___40037,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__38765__auto__ = null;
var cljs$core$async$state_machine__38765__auto____0 = (function (){
var statearr_40032 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40032[(0)] = cljs$core$async$state_machine__38765__auto__);

(statearr_40032[(1)] = (1));

return statearr_40032;
});
var cljs$core$async$state_machine__38765__auto____1 = (function (state_39991){
while(true){
var ret_value__38766__auto__ = (function (){try{while(true){
var result__38767__auto__ = switch__38764__auto__.call(null,state_39991);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38767__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38767__auto__;
}
break;
}
}catch (e40033){if((e40033 instanceof Object)){
var ex__38768__auto__ = e40033;
var statearr_40034_40066 = state_39991;
(statearr_40034_40066[(5)] = ex__38768__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_39991);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40033;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38766__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40067 = state_39991;
state_39991 = G__40067;
continue;
} else {
return ret_value__38766__auto__;
}
break;
}
});
cljs$core$async$state_machine__38765__auto__ = function(state_39991){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38765__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38765__auto____1.call(this,state_39991);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38765__auto____0;
cljs$core$async$state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38765__auto____1;
return cljs$core$async$state_machine__38765__auto__;
})()
;})(switch__38764__auto__,c__38817__auto___40037,mults,ensure_mult,p))
})();
var state__38819__auto__ = (function (){var statearr_40035 = f__38818__auto__.call(null);
(statearr_40035[(6)] = c__38817__auto___40037);

return statearr_40035;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38819__auto__);
});})(c__38817__auto___40037,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__40069 = arguments.length;
switch (G__40069) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__40072 = arguments.length;
switch (G__40072) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__40075 = arguments.length;
switch (G__40075) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__38817__auto___40142 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38817__auto___40142,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__38818__auto__ = (function (){var switch__38764__auto__ = ((function (c__38817__auto___40142,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_40114){
var state_val_40115 = (state_40114[(1)]);
if((state_val_40115 === (7))){
var state_40114__$1 = state_40114;
var statearr_40116_40143 = state_40114__$1;
(statearr_40116_40143[(2)] = null);

(statearr_40116_40143[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40115 === (1))){
var state_40114__$1 = state_40114;
var statearr_40117_40144 = state_40114__$1;
(statearr_40117_40144[(2)] = null);

(statearr_40117_40144[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40115 === (4))){
var inst_40078 = (state_40114[(7)]);
var inst_40080 = (inst_40078 < cnt);
var state_40114__$1 = state_40114;
if(cljs.core.truth_(inst_40080)){
var statearr_40118_40145 = state_40114__$1;
(statearr_40118_40145[(1)] = (6));

} else {
var statearr_40119_40146 = state_40114__$1;
(statearr_40119_40146[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40115 === (15))){
var inst_40110 = (state_40114[(2)]);
var state_40114__$1 = state_40114;
var statearr_40120_40147 = state_40114__$1;
(statearr_40120_40147[(2)] = inst_40110);

(statearr_40120_40147[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40115 === (13))){
var inst_40103 = cljs.core.async.close_BANG_.call(null,out);
var state_40114__$1 = state_40114;
var statearr_40121_40148 = state_40114__$1;
(statearr_40121_40148[(2)] = inst_40103);

(statearr_40121_40148[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40115 === (6))){
var state_40114__$1 = state_40114;
var statearr_40122_40149 = state_40114__$1;
(statearr_40122_40149[(2)] = null);

(statearr_40122_40149[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40115 === (3))){
var inst_40112 = (state_40114[(2)]);
var state_40114__$1 = state_40114;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40114__$1,inst_40112);
} else {
if((state_val_40115 === (12))){
var inst_40100 = (state_40114[(8)]);
var inst_40100__$1 = (state_40114[(2)]);
var inst_40101 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_40100__$1);
var state_40114__$1 = (function (){var statearr_40123 = state_40114;
(statearr_40123[(8)] = inst_40100__$1);

return statearr_40123;
})();
if(cljs.core.truth_(inst_40101)){
var statearr_40124_40150 = state_40114__$1;
(statearr_40124_40150[(1)] = (13));

} else {
var statearr_40125_40151 = state_40114__$1;
(statearr_40125_40151[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40115 === (2))){
var inst_40077 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_40078 = (0);
var state_40114__$1 = (function (){var statearr_40126 = state_40114;
(statearr_40126[(7)] = inst_40078);

(statearr_40126[(9)] = inst_40077);

return statearr_40126;
})();
var statearr_40127_40152 = state_40114__$1;
(statearr_40127_40152[(2)] = null);

(statearr_40127_40152[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40115 === (11))){
var inst_40078 = (state_40114[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_40114,(10),Object,null,(9));
var inst_40087 = chs__$1.call(null,inst_40078);
var inst_40088 = done.call(null,inst_40078);
var inst_40089 = cljs.core.async.take_BANG_.call(null,inst_40087,inst_40088);
var state_40114__$1 = state_40114;
var statearr_40128_40153 = state_40114__$1;
(statearr_40128_40153[(2)] = inst_40089);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40114__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40115 === (9))){
var inst_40078 = (state_40114[(7)]);
var inst_40091 = (state_40114[(2)]);
var inst_40092 = (inst_40078 + (1));
var inst_40078__$1 = inst_40092;
var state_40114__$1 = (function (){var statearr_40129 = state_40114;
(statearr_40129[(7)] = inst_40078__$1);

(statearr_40129[(10)] = inst_40091);

return statearr_40129;
})();
var statearr_40130_40154 = state_40114__$1;
(statearr_40130_40154[(2)] = null);

(statearr_40130_40154[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40115 === (5))){
var inst_40098 = (state_40114[(2)]);
var state_40114__$1 = (function (){var statearr_40131 = state_40114;
(statearr_40131[(11)] = inst_40098);

return statearr_40131;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40114__$1,(12),dchan);
} else {
if((state_val_40115 === (14))){
var inst_40100 = (state_40114[(8)]);
var inst_40105 = cljs.core.apply.call(null,f,inst_40100);
var state_40114__$1 = state_40114;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_40114__$1,(16),out,inst_40105);
} else {
if((state_val_40115 === (16))){
var inst_40107 = (state_40114[(2)]);
var state_40114__$1 = (function (){var statearr_40132 = state_40114;
(statearr_40132[(12)] = inst_40107);

return statearr_40132;
})();
var statearr_40133_40155 = state_40114__$1;
(statearr_40133_40155[(2)] = null);

(statearr_40133_40155[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40115 === (10))){
var inst_40082 = (state_40114[(2)]);
var inst_40083 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_40114__$1 = (function (){var statearr_40134 = state_40114;
(statearr_40134[(13)] = inst_40082);

return statearr_40134;
})();
var statearr_40135_40156 = state_40114__$1;
(statearr_40135_40156[(2)] = inst_40083);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40114__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40115 === (8))){
var inst_40096 = (state_40114[(2)]);
var state_40114__$1 = state_40114;
var statearr_40136_40157 = state_40114__$1;
(statearr_40136_40157[(2)] = inst_40096);

(statearr_40136_40157[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38817__auto___40142,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__38764__auto__,c__38817__auto___40142,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__38765__auto__ = null;
var cljs$core$async$state_machine__38765__auto____0 = (function (){
var statearr_40137 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40137[(0)] = cljs$core$async$state_machine__38765__auto__);

(statearr_40137[(1)] = (1));

return statearr_40137;
});
var cljs$core$async$state_machine__38765__auto____1 = (function (state_40114){
while(true){
var ret_value__38766__auto__ = (function (){try{while(true){
var result__38767__auto__ = switch__38764__auto__.call(null,state_40114);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38767__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38767__auto__;
}
break;
}
}catch (e40138){if((e40138 instanceof Object)){
var ex__38768__auto__ = e40138;
var statearr_40139_40158 = state_40114;
(statearr_40139_40158[(5)] = ex__38768__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40114);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40138;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38766__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40159 = state_40114;
state_40114 = G__40159;
continue;
} else {
return ret_value__38766__auto__;
}
break;
}
});
cljs$core$async$state_machine__38765__auto__ = function(state_40114){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38765__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38765__auto____1.call(this,state_40114);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38765__auto____0;
cljs$core$async$state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38765__auto____1;
return cljs$core$async$state_machine__38765__auto__;
})()
;})(switch__38764__auto__,c__38817__auto___40142,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__38819__auto__ = (function (){var statearr_40140 = f__38818__auto__.call(null);
(statearr_40140[(6)] = c__38817__auto___40142);

return statearr_40140;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38819__auto__);
});})(c__38817__auto___40142,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__40162 = arguments.length;
switch (G__40162) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__38817__auto___40216 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38817__auto___40216,out){
return (function (){
var f__38818__auto__ = (function (){var switch__38764__auto__ = ((function (c__38817__auto___40216,out){
return (function (state_40194){
var state_val_40195 = (state_40194[(1)]);
if((state_val_40195 === (7))){
var inst_40173 = (state_40194[(7)]);
var inst_40174 = (state_40194[(8)]);
var inst_40173__$1 = (state_40194[(2)]);
var inst_40174__$1 = cljs.core.nth.call(null,inst_40173__$1,(0),null);
var inst_40175 = cljs.core.nth.call(null,inst_40173__$1,(1),null);
var inst_40176 = (inst_40174__$1 == null);
var state_40194__$1 = (function (){var statearr_40196 = state_40194;
(statearr_40196[(7)] = inst_40173__$1);

(statearr_40196[(8)] = inst_40174__$1);

(statearr_40196[(9)] = inst_40175);

return statearr_40196;
})();
if(cljs.core.truth_(inst_40176)){
var statearr_40197_40217 = state_40194__$1;
(statearr_40197_40217[(1)] = (8));

} else {
var statearr_40198_40218 = state_40194__$1;
(statearr_40198_40218[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40195 === (1))){
var inst_40163 = cljs.core.vec.call(null,chs);
var inst_40164 = inst_40163;
var state_40194__$1 = (function (){var statearr_40199 = state_40194;
(statearr_40199[(10)] = inst_40164);

return statearr_40199;
})();
var statearr_40200_40219 = state_40194__$1;
(statearr_40200_40219[(2)] = null);

(statearr_40200_40219[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40195 === (4))){
var inst_40164 = (state_40194[(10)]);
var state_40194__$1 = state_40194;
return cljs.core.async.ioc_alts_BANG_.call(null,state_40194__$1,(7),inst_40164);
} else {
if((state_val_40195 === (6))){
var inst_40190 = (state_40194[(2)]);
var state_40194__$1 = state_40194;
var statearr_40201_40220 = state_40194__$1;
(statearr_40201_40220[(2)] = inst_40190);

(statearr_40201_40220[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40195 === (3))){
var inst_40192 = (state_40194[(2)]);
var state_40194__$1 = state_40194;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40194__$1,inst_40192);
} else {
if((state_val_40195 === (2))){
var inst_40164 = (state_40194[(10)]);
var inst_40166 = cljs.core.count.call(null,inst_40164);
var inst_40167 = (inst_40166 > (0));
var state_40194__$1 = state_40194;
if(cljs.core.truth_(inst_40167)){
var statearr_40203_40221 = state_40194__$1;
(statearr_40203_40221[(1)] = (4));

} else {
var statearr_40204_40222 = state_40194__$1;
(statearr_40204_40222[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40195 === (11))){
var inst_40164 = (state_40194[(10)]);
var inst_40183 = (state_40194[(2)]);
var tmp40202 = inst_40164;
var inst_40164__$1 = tmp40202;
var state_40194__$1 = (function (){var statearr_40205 = state_40194;
(statearr_40205[(11)] = inst_40183);

(statearr_40205[(10)] = inst_40164__$1);

return statearr_40205;
})();
var statearr_40206_40223 = state_40194__$1;
(statearr_40206_40223[(2)] = null);

(statearr_40206_40223[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40195 === (9))){
var inst_40174 = (state_40194[(8)]);
var state_40194__$1 = state_40194;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_40194__$1,(11),out,inst_40174);
} else {
if((state_val_40195 === (5))){
var inst_40188 = cljs.core.async.close_BANG_.call(null,out);
var state_40194__$1 = state_40194;
var statearr_40207_40224 = state_40194__$1;
(statearr_40207_40224[(2)] = inst_40188);

(statearr_40207_40224[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40195 === (10))){
var inst_40186 = (state_40194[(2)]);
var state_40194__$1 = state_40194;
var statearr_40208_40225 = state_40194__$1;
(statearr_40208_40225[(2)] = inst_40186);

(statearr_40208_40225[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40195 === (8))){
var inst_40173 = (state_40194[(7)]);
var inst_40174 = (state_40194[(8)]);
var inst_40175 = (state_40194[(9)]);
var inst_40164 = (state_40194[(10)]);
var inst_40178 = (function (){var cs = inst_40164;
var vec__40169 = inst_40173;
var v = inst_40174;
var c = inst_40175;
return ((function (cs,vec__40169,v,c,inst_40173,inst_40174,inst_40175,inst_40164,state_val_40195,c__38817__auto___40216,out){
return (function (p1__40160_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__40160_SHARP_);
});
;})(cs,vec__40169,v,c,inst_40173,inst_40174,inst_40175,inst_40164,state_val_40195,c__38817__auto___40216,out))
})();
var inst_40179 = cljs.core.filterv.call(null,inst_40178,inst_40164);
var inst_40164__$1 = inst_40179;
var state_40194__$1 = (function (){var statearr_40209 = state_40194;
(statearr_40209[(10)] = inst_40164__$1);

return statearr_40209;
})();
var statearr_40210_40226 = state_40194__$1;
(statearr_40210_40226[(2)] = null);

(statearr_40210_40226[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__38817__auto___40216,out))
;
return ((function (switch__38764__auto__,c__38817__auto___40216,out){
return (function() {
var cljs$core$async$state_machine__38765__auto__ = null;
var cljs$core$async$state_machine__38765__auto____0 = (function (){
var statearr_40211 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40211[(0)] = cljs$core$async$state_machine__38765__auto__);

(statearr_40211[(1)] = (1));

return statearr_40211;
});
var cljs$core$async$state_machine__38765__auto____1 = (function (state_40194){
while(true){
var ret_value__38766__auto__ = (function (){try{while(true){
var result__38767__auto__ = switch__38764__auto__.call(null,state_40194);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38767__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38767__auto__;
}
break;
}
}catch (e40212){if((e40212 instanceof Object)){
var ex__38768__auto__ = e40212;
var statearr_40213_40227 = state_40194;
(statearr_40213_40227[(5)] = ex__38768__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40194);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40212;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38766__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40228 = state_40194;
state_40194 = G__40228;
continue;
} else {
return ret_value__38766__auto__;
}
break;
}
});
cljs$core$async$state_machine__38765__auto__ = function(state_40194){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38765__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38765__auto____1.call(this,state_40194);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38765__auto____0;
cljs$core$async$state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38765__auto____1;
return cljs$core$async$state_machine__38765__auto__;
})()
;})(switch__38764__auto__,c__38817__auto___40216,out))
})();
var state__38819__auto__ = (function (){var statearr_40214 = f__38818__auto__.call(null);
(statearr_40214[(6)] = c__38817__auto___40216);

return statearr_40214;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38819__auto__);
});})(c__38817__auto___40216,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__40230 = arguments.length;
switch (G__40230) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__38817__auto___40275 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38817__auto___40275,out){
return (function (){
var f__38818__auto__ = (function (){var switch__38764__auto__ = ((function (c__38817__auto___40275,out){
return (function (state_40254){
var state_val_40255 = (state_40254[(1)]);
if((state_val_40255 === (7))){
var inst_40236 = (state_40254[(7)]);
var inst_40236__$1 = (state_40254[(2)]);
var inst_40237 = (inst_40236__$1 == null);
var inst_40238 = cljs.core.not.call(null,inst_40237);
var state_40254__$1 = (function (){var statearr_40256 = state_40254;
(statearr_40256[(7)] = inst_40236__$1);

return statearr_40256;
})();
if(inst_40238){
var statearr_40257_40276 = state_40254__$1;
(statearr_40257_40276[(1)] = (8));

} else {
var statearr_40258_40277 = state_40254__$1;
(statearr_40258_40277[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40255 === (1))){
var inst_40231 = (0);
var state_40254__$1 = (function (){var statearr_40259 = state_40254;
(statearr_40259[(8)] = inst_40231);

return statearr_40259;
})();
var statearr_40260_40278 = state_40254__$1;
(statearr_40260_40278[(2)] = null);

(statearr_40260_40278[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40255 === (4))){
var state_40254__$1 = state_40254;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40254__$1,(7),ch);
} else {
if((state_val_40255 === (6))){
var inst_40249 = (state_40254[(2)]);
var state_40254__$1 = state_40254;
var statearr_40261_40279 = state_40254__$1;
(statearr_40261_40279[(2)] = inst_40249);

(statearr_40261_40279[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40255 === (3))){
var inst_40251 = (state_40254[(2)]);
var inst_40252 = cljs.core.async.close_BANG_.call(null,out);
var state_40254__$1 = (function (){var statearr_40262 = state_40254;
(statearr_40262[(9)] = inst_40251);

return statearr_40262;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40254__$1,inst_40252);
} else {
if((state_val_40255 === (2))){
var inst_40231 = (state_40254[(8)]);
var inst_40233 = (inst_40231 < n);
var state_40254__$1 = state_40254;
if(cljs.core.truth_(inst_40233)){
var statearr_40263_40280 = state_40254__$1;
(statearr_40263_40280[(1)] = (4));

} else {
var statearr_40264_40281 = state_40254__$1;
(statearr_40264_40281[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40255 === (11))){
var inst_40231 = (state_40254[(8)]);
var inst_40241 = (state_40254[(2)]);
var inst_40242 = (inst_40231 + (1));
var inst_40231__$1 = inst_40242;
var state_40254__$1 = (function (){var statearr_40265 = state_40254;
(statearr_40265[(8)] = inst_40231__$1);

(statearr_40265[(10)] = inst_40241);

return statearr_40265;
})();
var statearr_40266_40282 = state_40254__$1;
(statearr_40266_40282[(2)] = null);

(statearr_40266_40282[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40255 === (9))){
var state_40254__$1 = state_40254;
var statearr_40267_40283 = state_40254__$1;
(statearr_40267_40283[(2)] = null);

(statearr_40267_40283[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40255 === (5))){
var state_40254__$1 = state_40254;
var statearr_40268_40284 = state_40254__$1;
(statearr_40268_40284[(2)] = null);

(statearr_40268_40284[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40255 === (10))){
var inst_40246 = (state_40254[(2)]);
var state_40254__$1 = state_40254;
var statearr_40269_40285 = state_40254__$1;
(statearr_40269_40285[(2)] = inst_40246);

(statearr_40269_40285[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40255 === (8))){
var inst_40236 = (state_40254[(7)]);
var state_40254__$1 = state_40254;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_40254__$1,(11),out,inst_40236);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__38817__auto___40275,out))
;
return ((function (switch__38764__auto__,c__38817__auto___40275,out){
return (function() {
var cljs$core$async$state_machine__38765__auto__ = null;
var cljs$core$async$state_machine__38765__auto____0 = (function (){
var statearr_40270 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_40270[(0)] = cljs$core$async$state_machine__38765__auto__);

(statearr_40270[(1)] = (1));

return statearr_40270;
});
var cljs$core$async$state_machine__38765__auto____1 = (function (state_40254){
while(true){
var ret_value__38766__auto__ = (function (){try{while(true){
var result__38767__auto__ = switch__38764__auto__.call(null,state_40254);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38767__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38767__auto__;
}
break;
}
}catch (e40271){if((e40271 instanceof Object)){
var ex__38768__auto__ = e40271;
var statearr_40272_40286 = state_40254;
(statearr_40272_40286[(5)] = ex__38768__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40254);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40271;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38766__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40287 = state_40254;
state_40254 = G__40287;
continue;
} else {
return ret_value__38766__auto__;
}
break;
}
});
cljs$core$async$state_machine__38765__auto__ = function(state_40254){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38765__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38765__auto____1.call(this,state_40254);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38765__auto____0;
cljs$core$async$state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38765__auto____1;
return cljs$core$async$state_machine__38765__auto__;
})()
;})(switch__38764__auto__,c__38817__auto___40275,out))
})();
var state__38819__auto__ = (function (){var statearr_40273 = f__38818__auto__.call(null);
(statearr_40273[(6)] = c__38817__auto___40275);

return statearr_40273;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38819__auto__);
});})(c__38817__auto___40275,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async40289 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async40289 = (function (f,ch,meta40290){
this.f = f;
this.ch = ch;
this.meta40290 = meta40290;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async40289.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_40291,meta40290__$1){
var self__ = this;
var _40291__$1 = this;
return (new cljs.core.async.t_cljs$core$async40289(self__.f,self__.ch,meta40290__$1));
});

cljs.core.async.t_cljs$core$async40289.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_40291){
var self__ = this;
var _40291__$1 = this;
return self__.meta40290;
});

cljs.core.async.t_cljs$core$async40289.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async40289.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async40289.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async40289.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async40289.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async40292 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async40292 = (function (f,ch,meta40290,_,fn1,meta40293){
this.f = f;
this.ch = ch;
this.meta40290 = meta40290;
this._ = _;
this.fn1 = fn1;
this.meta40293 = meta40293;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async40292.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_40294,meta40293__$1){
var self__ = this;
var _40294__$1 = this;
return (new cljs.core.async.t_cljs$core$async40292(self__.f,self__.ch,self__.meta40290,self__._,self__.fn1,meta40293__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async40292.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_40294){
var self__ = this;
var _40294__$1 = this;
return self__.meta40293;
});})(___$1))
;

cljs.core.async.t_cljs$core$async40292.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async40292.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async40292.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async40292.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__40288_SHARP_){
return f1.call(null,(((p1__40288_SHARP_ == null))?null:self__.f.call(null,p1__40288_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async40292.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta40290","meta40290",-943213903,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async40289","cljs.core.async/t_cljs$core$async40289",-1873383052,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta40293","meta40293",-23414619,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async40292.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async40292.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async40292";

cljs.core.async.t_cljs$core$async40292.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__28614__auto__,writer__28615__auto__,opt__28616__auto__){
return cljs.core._write.call(null,writer__28615__auto__,"cljs.core.async/t_cljs$core$async40292");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async40292 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async40292(f__$1,ch__$1,meta40290__$1,___$2,fn1__$1,meta40293){
return (new cljs.core.async.t_cljs$core$async40292(f__$1,ch__$1,meta40290__$1,___$2,fn1__$1,meta40293));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async40292(self__.f,self__.ch,self__.meta40290,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__27977__auto__ = ret;
if(cljs.core.truth_(and__27977__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__27977__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async40289.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async40289.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async40289.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta40290","meta40290",-943213903,null)], null);
});

cljs.core.async.t_cljs$core$async40289.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async40289.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async40289";

cljs.core.async.t_cljs$core$async40289.cljs$lang$ctorPrWriter = (function (this__28614__auto__,writer__28615__auto__,opt__28616__auto__){
return cljs.core._write.call(null,writer__28615__auto__,"cljs.core.async/t_cljs$core$async40289");
});

cljs.core.async.__GT_t_cljs$core$async40289 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async40289(f__$1,ch__$1,meta40290){
return (new cljs.core.async.t_cljs$core$async40289(f__$1,ch__$1,meta40290));
});

}

return (new cljs.core.async.t_cljs$core$async40289(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async40295 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async40295 = (function (f,ch,meta40296){
this.f = f;
this.ch = ch;
this.meta40296 = meta40296;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async40295.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_40297,meta40296__$1){
var self__ = this;
var _40297__$1 = this;
return (new cljs.core.async.t_cljs$core$async40295(self__.f,self__.ch,meta40296__$1));
});

cljs.core.async.t_cljs$core$async40295.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_40297){
var self__ = this;
var _40297__$1 = this;
return self__.meta40296;
});

cljs.core.async.t_cljs$core$async40295.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async40295.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async40295.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async40295.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async40295.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async40295.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async40295.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta40296","meta40296",-1579998356,null)], null);
});

cljs.core.async.t_cljs$core$async40295.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async40295.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async40295";

cljs.core.async.t_cljs$core$async40295.cljs$lang$ctorPrWriter = (function (this__28614__auto__,writer__28615__auto__,opt__28616__auto__){
return cljs.core._write.call(null,writer__28615__auto__,"cljs.core.async/t_cljs$core$async40295");
});

cljs.core.async.__GT_t_cljs$core$async40295 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async40295(f__$1,ch__$1,meta40296){
return (new cljs.core.async.t_cljs$core$async40295(f__$1,ch__$1,meta40296));
});

}

return (new cljs.core.async.t_cljs$core$async40295(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async40298 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async40298 = (function (p,ch,meta40299){
this.p = p;
this.ch = ch;
this.meta40299 = meta40299;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async40298.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_40300,meta40299__$1){
var self__ = this;
var _40300__$1 = this;
return (new cljs.core.async.t_cljs$core$async40298(self__.p,self__.ch,meta40299__$1));
});

cljs.core.async.t_cljs$core$async40298.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_40300){
var self__ = this;
var _40300__$1 = this;
return self__.meta40299;
});

cljs.core.async.t_cljs$core$async40298.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async40298.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async40298.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async40298.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async40298.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async40298.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async40298.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async40298.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta40299","meta40299",779416207,null)], null);
});

cljs.core.async.t_cljs$core$async40298.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async40298.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async40298";

cljs.core.async.t_cljs$core$async40298.cljs$lang$ctorPrWriter = (function (this__28614__auto__,writer__28615__auto__,opt__28616__auto__){
return cljs.core._write.call(null,writer__28615__auto__,"cljs.core.async/t_cljs$core$async40298");
});

cljs.core.async.__GT_t_cljs$core$async40298 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async40298(p__$1,ch__$1,meta40299){
return (new cljs.core.async.t_cljs$core$async40298(p__$1,ch__$1,meta40299));
});

}

return (new cljs.core.async.t_cljs$core$async40298(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__40302 = arguments.length;
switch (G__40302) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__38817__auto___40342 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38817__auto___40342,out){
return (function (){
var f__38818__auto__ = (function (){var switch__38764__auto__ = ((function (c__38817__auto___40342,out){
return (function (state_40323){
var state_val_40324 = (state_40323[(1)]);
if((state_val_40324 === (7))){
var inst_40319 = (state_40323[(2)]);
var state_40323__$1 = state_40323;
var statearr_40325_40343 = state_40323__$1;
(statearr_40325_40343[(2)] = inst_40319);

(statearr_40325_40343[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40324 === (1))){
var state_40323__$1 = state_40323;
var statearr_40326_40344 = state_40323__$1;
(statearr_40326_40344[(2)] = null);

(statearr_40326_40344[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40324 === (4))){
var inst_40305 = (state_40323[(7)]);
var inst_40305__$1 = (state_40323[(2)]);
var inst_40306 = (inst_40305__$1 == null);
var state_40323__$1 = (function (){var statearr_40327 = state_40323;
(statearr_40327[(7)] = inst_40305__$1);

return statearr_40327;
})();
if(cljs.core.truth_(inst_40306)){
var statearr_40328_40345 = state_40323__$1;
(statearr_40328_40345[(1)] = (5));

} else {
var statearr_40329_40346 = state_40323__$1;
(statearr_40329_40346[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40324 === (6))){
var inst_40305 = (state_40323[(7)]);
var inst_40310 = p.call(null,inst_40305);
var state_40323__$1 = state_40323;
if(cljs.core.truth_(inst_40310)){
var statearr_40330_40347 = state_40323__$1;
(statearr_40330_40347[(1)] = (8));

} else {
var statearr_40331_40348 = state_40323__$1;
(statearr_40331_40348[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40324 === (3))){
var inst_40321 = (state_40323[(2)]);
var state_40323__$1 = state_40323;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40323__$1,inst_40321);
} else {
if((state_val_40324 === (2))){
var state_40323__$1 = state_40323;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40323__$1,(4),ch);
} else {
if((state_val_40324 === (11))){
var inst_40313 = (state_40323[(2)]);
var state_40323__$1 = state_40323;
var statearr_40332_40349 = state_40323__$1;
(statearr_40332_40349[(2)] = inst_40313);

(statearr_40332_40349[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40324 === (9))){
var state_40323__$1 = state_40323;
var statearr_40333_40350 = state_40323__$1;
(statearr_40333_40350[(2)] = null);

(statearr_40333_40350[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40324 === (5))){
var inst_40308 = cljs.core.async.close_BANG_.call(null,out);
var state_40323__$1 = state_40323;
var statearr_40334_40351 = state_40323__$1;
(statearr_40334_40351[(2)] = inst_40308);

(statearr_40334_40351[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40324 === (10))){
var inst_40316 = (state_40323[(2)]);
var state_40323__$1 = (function (){var statearr_40335 = state_40323;
(statearr_40335[(8)] = inst_40316);

return statearr_40335;
})();
var statearr_40336_40352 = state_40323__$1;
(statearr_40336_40352[(2)] = null);

(statearr_40336_40352[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40324 === (8))){
var inst_40305 = (state_40323[(7)]);
var state_40323__$1 = state_40323;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_40323__$1,(11),out,inst_40305);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__38817__auto___40342,out))
;
return ((function (switch__38764__auto__,c__38817__auto___40342,out){
return (function() {
var cljs$core$async$state_machine__38765__auto__ = null;
var cljs$core$async$state_machine__38765__auto____0 = (function (){
var statearr_40337 = [null,null,null,null,null,null,null,null,null];
(statearr_40337[(0)] = cljs$core$async$state_machine__38765__auto__);

(statearr_40337[(1)] = (1));

return statearr_40337;
});
var cljs$core$async$state_machine__38765__auto____1 = (function (state_40323){
while(true){
var ret_value__38766__auto__ = (function (){try{while(true){
var result__38767__auto__ = switch__38764__auto__.call(null,state_40323);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38767__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38767__auto__;
}
break;
}
}catch (e40338){if((e40338 instanceof Object)){
var ex__38768__auto__ = e40338;
var statearr_40339_40353 = state_40323;
(statearr_40339_40353[(5)] = ex__38768__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40323);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40338;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38766__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40354 = state_40323;
state_40323 = G__40354;
continue;
} else {
return ret_value__38766__auto__;
}
break;
}
});
cljs$core$async$state_machine__38765__auto__ = function(state_40323){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38765__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38765__auto____1.call(this,state_40323);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38765__auto____0;
cljs$core$async$state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38765__auto____1;
return cljs$core$async$state_machine__38765__auto__;
})()
;})(switch__38764__auto__,c__38817__auto___40342,out))
})();
var state__38819__auto__ = (function (){var statearr_40340 = f__38818__auto__.call(null);
(statearr_40340[(6)] = c__38817__auto___40342);

return statearr_40340;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38819__auto__);
});})(c__38817__auto___40342,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__40356 = arguments.length;
switch (G__40356) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__38817__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38817__auto__){
return (function (){
var f__38818__auto__ = (function (){var switch__38764__auto__ = ((function (c__38817__auto__){
return (function (state_40419){
var state_val_40420 = (state_40419[(1)]);
if((state_val_40420 === (7))){
var inst_40415 = (state_40419[(2)]);
var state_40419__$1 = state_40419;
var statearr_40421_40459 = state_40419__$1;
(statearr_40421_40459[(2)] = inst_40415);

(statearr_40421_40459[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40420 === (20))){
var inst_40385 = (state_40419[(7)]);
var inst_40396 = (state_40419[(2)]);
var inst_40397 = cljs.core.next.call(null,inst_40385);
var inst_40371 = inst_40397;
var inst_40372 = null;
var inst_40373 = (0);
var inst_40374 = (0);
var state_40419__$1 = (function (){var statearr_40422 = state_40419;
(statearr_40422[(8)] = inst_40373);

(statearr_40422[(9)] = inst_40396);

(statearr_40422[(10)] = inst_40371);

(statearr_40422[(11)] = inst_40372);

(statearr_40422[(12)] = inst_40374);

return statearr_40422;
})();
var statearr_40423_40460 = state_40419__$1;
(statearr_40423_40460[(2)] = null);

(statearr_40423_40460[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40420 === (1))){
var state_40419__$1 = state_40419;
var statearr_40424_40461 = state_40419__$1;
(statearr_40424_40461[(2)] = null);

(statearr_40424_40461[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40420 === (4))){
var inst_40360 = (state_40419[(13)]);
var inst_40360__$1 = (state_40419[(2)]);
var inst_40361 = (inst_40360__$1 == null);
var state_40419__$1 = (function (){var statearr_40425 = state_40419;
(statearr_40425[(13)] = inst_40360__$1);

return statearr_40425;
})();
if(cljs.core.truth_(inst_40361)){
var statearr_40426_40462 = state_40419__$1;
(statearr_40426_40462[(1)] = (5));

} else {
var statearr_40427_40463 = state_40419__$1;
(statearr_40427_40463[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40420 === (15))){
var state_40419__$1 = state_40419;
var statearr_40431_40464 = state_40419__$1;
(statearr_40431_40464[(2)] = null);

(statearr_40431_40464[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40420 === (21))){
var state_40419__$1 = state_40419;
var statearr_40432_40465 = state_40419__$1;
(statearr_40432_40465[(2)] = null);

(statearr_40432_40465[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40420 === (13))){
var inst_40373 = (state_40419[(8)]);
var inst_40371 = (state_40419[(10)]);
var inst_40372 = (state_40419[(11)]);
var inst_40374 = (state_40419[(12)]);
var inst_40381 = (state_40419[(2)]);
var inst_40382 = (inst_40374 + (1));
var tmp40428 = inst_40373;
var tmp40429 = inst_40371;
var tmp40430 = inst_40372;
var inst_40371__$1 = tmp40429;
var inst_40372__$1 = tmp40430;
var inst_40373__$1 = tmp40428;
var inst_40374__$1 = inst_40382;
var state_40419__$1 = (function (){var statearr_40433 = state_40419;
(statearr_40433[(8)] = inst_40373__$1);

(statearr_40433[(10)] = inst_40371__$1);

(statearr_40433[(14)] = inst_40381);

(statearr_40433[(11)] = inst_40372__$1);

(statearr_40433[(12)] = inst_40374__$1);

return statearr_40433;
})();
var statearr_40434_40466 = state_40419__$1;
(statearr_40434_40466[(2)] = null);

(statearr_40434_40466[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40420 === (22))){
var state_40419__$1 = state_40419;
var statearr_40435_40467 = state_40419__$1;
(statearr_40435_40467[(2)] = null);

(statearr_40435_40467[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40420 === (6))){
var inst_40360 = (state_40419[(13)]);
var inst_40369 = f.call(null,inst_40360);
var inst_40370 = cljs.core.seq.call(null,inst_40369);
var inst_40371 = inst_40370;
var inst_40372 = null;
var inst_40373 = (0);
var inst_40374 = (0);
var state_40419__$1 = (function (){var statearr_40436 = state_40419;
(statearr_40436[(8)] = inst_40373);

(statearr_40436[(10)] = inst_40371);

(statearr_40436[(11)] = inst_40372);

(statearr_40436[(12)] = inst_40374);

return statearr_40436;
})();
var statearr_40437_40468 = state_40419__$1;
(statearr_40437_40468[(2)] = null);

(statearr_40437_40468[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40420 === (17))){
var inst_40385 = (state_40419[(7)]);
var inst_40389 = cljs.core.chunk_first.call(null,inst_40385);
var inst_40390 = cljs.core.chunk_rest.call(null,inst_40385);
var inst_40391 = cljs.core.count.call(null,inst_40389);
var inst_40371 = inst_40390;
var inst_40372 = inst_40389;
var inst_40373 = inst_40391;
var inst_40374 = (0);
var state_40419__$1 = (function (){var statearr_40438 = state_40419;
(statearr_40438[(8)] = inst_40373);

(statearr_40438[(10)] = inst_40371);

(statearr_40438[(11)] = inst_40372);

(statearr_40438[(12)] = inst_40374);

return statearr_40438;
})();
var statearr_40439_40469 = state_40419__$1;
(statearr_40439_40469[(2)] = null);

(statearr_40439_40469[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40420 === (3))){
var inst_40417 = (state_40419[(2)]);
var state_40419__$1 = state_40419;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40419__$1,inst_40417);
} else {
if((state_val_40420 === (12))){
var inst_40405 = (state_40419[(2)]);
var state_40419__$1 = state_40419;
var statearr_40440_40470 = state_40419__$1;
(statearr_40440_40470[(2)] = inst_40405);

(statearr_40440_40470[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40420 === (2))){
var state_40419__$1 = state_40419;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40419__$1,(4),in$);
} else {
if((state_val_40420 === (23))){
var inst_40413 = (state_40419[(2)]);
var state_40419__$1 = state_40419;
var statearr_40441_40471 = state_40419__$1;
(statearr_40441_40471[(2)] = inst_40413);

(statearr_40441_40471[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40420 === (19))){
var inst_40400 = (state_40419[(2)]);
var state_40419__$1 = state_40419;
var statearr_40442_40472 = state_40419__$1;
(statearr_40442_40472[(2)] = inst_40400);

(statearr_40442_40472[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40420 === (11))){
var inst_40385 = (state_40419[(7)]);
var inst_40371 = (state_40419[(10)]);
var inst_40385__$1 = cljs.core.seq.call(null,inst_40371);
var state_40419__$1 = (function (){var statearr_40443 = state_40419;
(statearr_40443[(7)] = inst_40385__$1);

return statearr_40443;
})();
if(inst_40385__$1){
var statearr_40444_40473 = state_40419__$1;
(statearr_40444_40473[(1)] = (14));

} else {
var statearr_40445_40474 = state_40419__$1;
(statearr_40445_40474[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40420 === (9))){
var inst_40407 = (state_40419[(2)]);
var inst_40408 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_40419__$1 = (function (){var statearr_40446 = state_40419;
(statearr_40446[(15)] = inst_40407);

return statearr_40446;
})();
if(cljs.core.truth_(inst_40408)){
var statearr_40447_40475 = state_40419__$1;
(statearr_40447_40475[(1)] = (21));

} else {
var statearr_40448_40476 = state_40419__$1;
(statearr_40448_40476[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40420 === (5))){
var inst_40363 = cljs.core.async.close_BANG_.call(null,out);
var state_40419__$1 = state_40419;
var statearr_40449_40477 = state_40419__$1;
(statearr_40449_40477[(2)] = inst_40363);

(statearr_40449_40477[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40420 === (14))){
var inst_40385 = (state_40419[(7)]);
var inst_40387 = cljs.core.chunked_seq_QMARK_.call(null,inst_40385);
var state_40419__$1 = state_40419;
if(inst_40387){
var statearr_40450_40478 = state_40419__$1;
(statearr_40450_40478[(1)] = (17));

} else {
var statearr_40451_40479 = state_40419__$1;
(statearr_40451_40479[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40420 === (16))){
var inst_40403 = (state_40419[(2)]);
var state_40419__$1 = state_40419;
var statearr_40452_40480 = state_40419__$1;
(statearr_40452_40480[(2)] = inst_40403);

(statearr_40452_40480[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40420 === (10))){
var inst_40372 = (state_40419[(11)]);
var inst_40374 = (state_40419[(12)]);
var inst_40379 = cljs.core._nth.call(null,inst_40372,inst_40374);
var state_40419__$1 = state_40419;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_40419__$1,(13),out,inst_40379);
} else {
if((state_val_40420 === (18))){
var inst_40385 = (state_40419[(7)]);
var inst_40394 = cljs.core.first.call(null,inst_40385);
var state_40419__$1 = state_40419;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_40419__$1,(20),out,inst_40394);
} else {
if((state_val_40420 === (8))){
var inst_40373 = (state_40419[(8)]);
var inst_40374 = (state_40419[(12)]);
var inst_40376 = (inst_40374 < inst_40373);
var inst_40377 = inst_40376;
var state_40419__$1 = state_40419;
if(cljs.core.truth_(inst_40377)){
var statearr_40453_40481 = state_40419__$1;
(statearr_40453_40481[(1)] = (10));

} else {
var statearr_40454_40482 = state_40419__$1;
(statearr_40454_40482[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38817__auto__))
;
return ((function (switch__38764__auto__,c__38817__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__38765__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__38765__auto____0 = (function (){
var statearr_40455 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40455[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__38765__auto__);

(statearr_40455[(1)] = (1));

return statearr_40455;
});
var cljs$core$async$mapcat_STAR__$_state_machine__38765__auto____1 = (function (state_40419){
while(true){
var ret_value__38766__auto__ = (function (){try{while(true){
var result__38767__auto__ = switch__38764__auto__.call(null,state_40419);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38767__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38767__auto__;
}
break;
}
}catch (e40456){if((e40456 instanceof Object)){
var ex__38768__auto__ = e40456;
var statearr_40457_40483 = state_40419;
(statearr_40457_40483[(5)] = ex__38768__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40419);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40456;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38766__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40484 = state_40419;
state_40419 = G__40484;
continue;
} else {
return ret_value__38766__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__38765__auto__ = function(state_40419){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__38765__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__38765__auto____1.call(this,state_40419);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__38765__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__38765__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__38765__auto__;
})()
;})(switch__38764__auto__,c__38817__auto__))
})();
var state__38819__auto__ = (function (){var statearr_40458 = f__38818__auto__.call(null);
(statearr_40458[(6)] = c__38817__auto__);

return statearr_40458;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38819__auto__);
});})(c__38817__auto__))
);

return c__38817__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__40486 = arguments.length;
switch (G__40486) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__40489 = arguments.length;
switch (G__40489) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__40492 = arguments.length;
switch (G__40492) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__38817__auto___40539 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38817__auto___40539,out){
return (function (){
var f__38818__auto__ = (function (){var switch__38764__auto__ = ((function (c__38817__auto___40539,out){
return (function (state_40516){
var state_val_40517 = (state_40516[(1)]);
if((state_val_40517 === (7))){
var inst_40511 = (state_40516[(2)]);
var state_40516__$1 = state_40516;
var statearr_40518_40540 = state_40516__$1;
(statearr_40518_40540[(2)] = inst_40511);

(statearr_40518_40540[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40517 === (1))){
var inst_40493 = null;
var state_40516__$1 = (function (){var statearr_40519 = state_40516;
(statearr_40519[(7)] = inst_40493);

return statearr_40519;
})();
var statearr_40520_40541 = state_40516__$1;
(statearr_40520_40541[(2)] = null);

(statearr_40520_40541[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40517 === (4))){
var inst_40496 = (state_40516[(8)]);
var inst_40496__$1 = (state_40516[(2)]);
var inst_40497 = (inst_40496__$1 == null);
var inst_40498 = cljs.core.not.call(null,inst_40497);
var state_40516__$1 = (function (){var statearr_40521 = state_40516;
(statearr_40521[(8)] = inst_40496__$1);

return statearr_40521;
})();
if(inst_40498){
var statearr_40522_40542 = state_40516__$1;
(statearr_40522_40542[(1)] = (5));

} else {
var statearr_40523_40543 = state_40516__$1;
(statearr_40523_40543[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40517 === (6))){
var state_40516__$1 = state_40516;
var statearr_40524_40544 = state_40516__$1;
(statearr_40524_40544[(2)] = null);

(statearr_40524_40544[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40517 === (3))){
var inst_40513 = (state_40516[(2)]);
var inst_40514 = cljs.core.async.close_BANG_.call(null,out);
var state_40516__$1 = (function (){var statearr_40525 = state_40516;
(statearr_40525[(9)] = inst_40513);

return statearr_40525;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40516__$1,inst_40514);
} else {
if((state_val_40517 === (2))){
var state_40516__$1 = state_40516;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40516__$1,(4),ch);
} else {
if((state_val_40517 === (11))){
var inst_40496 = (state_40516[(8)]);
var inst_40505 = (state_40516[(2)]);
var inst_40493 = inst_40496;
var state_40516__$1 = (function (){var statearr_40526 = state_40516;
(statearr_40526[(10)] = inst_40505);

(statearr_40526[(7)] = inst_40493);

return statearr_40526;
})();
var statearr_40527_40545 = state_40516__$1;
(statearr_40527_40545[(2)] = null);

(statearr_40527_40545[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40517 === (9))){
var inst_40496 = (state_40516[(8)]);
var state_40516__$1 = state_40516;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_40516__$1,(11),out,inst_40496);
} else {
if((state_val_40517 === (5))){
var inst_40493 = (state_40516[(7)]);
var inst_40496 = (state_40516[(8)]);
var inst_40500 = cljs.core._EQ_.call(null,inst_40496,inst_40493);
var state_40516__$1 = state_40516;
if(inst_40500){
var statearr_40529_40546 = state_40516__$1;
(statearr_40529_40546[(1)] = (8));

} else {
var statearr_40530_40547 = state_40516__$1;
(statearr_40530_40547[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40517 === (10))){
var inst_40508 = (state_40516[(2)]);
var state_40516__$1 = state_40516;
var statearr_40531_40548 = state_40516__$1;
(statearr_40531_40548[(2)] = inst_40508);

(statearr_40531_40548[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40517 === (8))){
var inst_40493 = (state_40516[(7)]);
var tmp40528 = inst_40493;
var inst_40493__$1 = tmp40528;
var state_40516__$1 = (function (){var statearr_40532 = state_40516;
(statearr_40532[(7)] = inst_40493__$1);

return statearr_40532;
})();
var statearr_40533_40549 = state_40516__$1;
(statearr_40533_40549[(2)] = null);

(statearr_40533_40549[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__38817__auto___40539,out))
;
return ((function (switch__38764__auto__,c__38817__auto___40539,out){
return (function() {
var cljs$core$async$state_machine__38765__auto__ = null;
var cljs$core$async$state_machine__38765__auto____0 = (function (){
var statearr_40534 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_40534[(0)] = cljs$core$async$state_machine__38765__auto__);

(statearr_40534[(1)] = (1));

return statearr_40534;
});
var cljs$core$async$state_machine__38765__auto____1 = (function (state_40516){
while(true){
var ret_value__38766__auto__ = (function (){try{while(true){
var result__38767__auto__ = switch__38764__auto__.call(null,state_40516);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38767__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38767__auto__;
}
break;
}
}catch (e40535){if((e40535 instanceof Object)){
var ex__38768__auto__ = e40535;
var statearr_40536_40550 = state_40516;
(statearr_40536_40550[(5)] = ex__38768__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40516);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40535;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38766__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40551 = state_40516;
state_40516 = G__40551;
continue;
} else {
return ret_value__38766__auto__;
}
break;
}
});
cljs$core$async$state_machine__38765__auto__ = function(state_40516){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38765__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38765__auto____1.call(this,state_40516);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38765__auto____0;
cljs$core$async$state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38765__auto____1;
return cljs$core$async$state_machine__38765__auto__;
})()
;})(switch__38764__auto__,c__38817__auto___40539,out))
})();
var state__38819__auto__ = (function (){var statearr_40537 = f__38818__auto__.call(null);
(statearr_40537[(6)] = c__38817__auto___40539);

return statearr_40537;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38819__auto__);
});})(c__38817__auto___40539,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__40553 = arguments.length;
switch (G__40553) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__38817__auto___40619 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38817__auto___40619,out){
return (function (){
var f__38818__auto__ = (function (){var switch__38764__auto__ = ((function (c__38817__auto___40619,out){
return (function (state_40591){
var state_val_40592 = (state_40591[(1)]);
if((state_val_40592 === (7))){
var inst_40587 = (state_40591[(2)]);
var state_40591__$1 = state_40591;
var statearr_40593_40620 = state_40591__$1;
(statearr_40593_40620[(2)] = inst_40587);

(statearr_40593_40620[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40592 === (1))){
var inst_40554 = (new Array(n));
var inst_40555 = inst_40554;
var inst_40556 = (0);
var state_40591__$1 = (function (){var statearr_40594 = state_40591;
(statearr_40594[(7)] = inst_40556);

(statearr_40594[(8)] = inst_40555);

return statearr_40594;
})();
var statearr_40595_40621 = state_40591__$1;
(statearr_40595_40621[(2)] = null);

(statearr_40595_40621[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40592 === (4))){
var inst_40559 = (state_40591[(9)]);
var inst_40559__$1 = (state_40591[(2)]);
var inst_40560 = (inst_40559__$1 == null);
var inst_40561 = cljs.core.not.call(null,inst_40560);
var state_40591__$1 = (function (){var statearr_40596 = state_40591;
(statearr_40596[(9)] = inst_40559__$1);

return statearr_40596;
})();
if(inst_40561){
var statearr_40597_40622 = state_40591__$1;
(statearr_40597_40622[(1)] = (5));

} else {
var statearr_40598_40623 = state_40591__$1;
(statearr_40598_40623[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40592 === (15))){
var inst_40581 = (state_40591[(2)]);
var state_40591__$1 = state_40591;
var statearr_40599_40624 = state_40591__$1;
(statearr_40599_40624[(2)] = inst_40581);

(statearr_40599_40624[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40592 === (13))){
var state_40591__$1 = state_40591;
var statearr_40600_40625 = state_40591__$1;
(statearr_40600_40625[(2)] = null);

(statearr_40600_40625[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40592 === (6))){
var inst_40556 = (state_40591[(7)]);
var inst_40577 = (inst_40556 > (0));
var state_40591__$1 = state_40591;
if(cljs.core.truth_(inst_40577)){
var statearr_40601_40626 = state_40591__$1;
(statearr_40601_40626[(1)] = (12));

} else {
var statearr_40602_40627 = state_40591__$1;
(statearr_40602_40627[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40592 === (3))){
var inst_40589 = (state_40591[(2)]);
var state_40591__$1 = state_40591;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40591__$1,inst_40589);
} else {
if((state_val_40592 === (12))){
var inst_40555 = (state_40591[(8)]);
var inst_40579 = cljs.core.vec.call(null,inst_40555);
var state_40591__$1 = state_40591;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_40591__$1,(15),out,inst_40579);
} else {
if((state_val_40592 === (2))){
var state_40591__$1 = state_40591;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40591__$1,(4),ch);
} else {
if((state_val_40592 === (11))){
var inst_40571 = (state_40591[(2)]);
var inst_40572 = (new Array(n));
var inst_40555 = inst_40572;
var inst_40556 = (0);
var state_40591__$1 = (function (){var statearr_40603 = state_40591;
(statearr_40603[(7)] = inst_40556);

(statearr_40603[(10)] = inst_40571);

(statearr_40603[(8)] = inst_40555);

return statearr_40603;
})();
var statearr_40604_40628 = state_40591__$1;
(statearr_40604_40628[(2)] = null);

(statearr_40604_40628[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40592 === (9))){
var inst_40555 = (state_40591[(8)]);
var inst_40569 = cljs.core.vec.call(null,inst_40555);
var state_40591__$1 = state_40591;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_40591__$1,(11),out,inst_40569);
} else {
if((state_val_40592 === (5))){
var inst_40556 = (state_40591[(7)]);
var inst_40559 = (state_40591[(9)]);
var inst_40555 = (state_40591[(8)]);
var inst_40564 = (state_40591[(11)]);
var inst_40563 = (inst_40555[inst_40556] = inst_40559);
var inst_40564__$1 = (inst_40556 + (1));
var inst_40565 = (inst_40564__$1 < n);
var state_40591__$1 = (function (){var statearr_40605 = state_40591;
(statearr_40605[(12)] = inst_40563);

(statearr_40605[(11)] = inst_40564__$1);

return statearr_40605;
})();
if(cljs.core.truth_(inst_40565)){
var statearr_40606_40629 = state_40591__$1;
(statearr_40606_40629[(1)] = (8));

} else {
var statearr_40607_40630 = state_40591__$1;
(statearr_40607_40630[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40592 === (14))){
var inst_40584 = (state_40591[(2)]);
var inst_40585 = cljs.core.async.close_BANG_.call(null,out);
var state_40591__$1 = (function (){var statearr_40609 = state_40591;
(statearr_40609[(13)] = inst_40584);

return statearr_40609;
})();
var statearr_40610_40631 = state_40591__$1;
(statearr_40610_40631[(2)] = inst_40585);

(statearr_40610_40631[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40592 === (10))){
var inst_40575 = (state_40591[(2)]);
var state_40591__$1 = state_40591;
var statearr_40611_40632 = state_40591__$1;
(statearr_40611_40632[(2)] = inst_40575);

(statearr_40611_40632[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40592 === (8))){
var inst_40555 = (state_40591[(8)]);
var inst_40564 = (state_40591[(11)]);
var tmp40608 = inst_40555;
var inst_40555__$1 = tmp40608;
var inst_40556 = inst_40564;
var state_40591__$1 = (function (){var statearr_40612 = state_40591;
(statearr_40612[(7)] = inst_40556);

(statearr_40612[(8)] = inst_40555__$1);

return statearr_40612;
})();
var statearr_40613_40633 = state_40591__$1;
(statearr_40613_40633[(2)] = null);

(statearr_40613_40633[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38817__auto___40619,out))
;
return ((function (switch__38764__auto__,c__38817__auto___40619,out){
return (function() {
var cljs$core$async$state_machine__38765__auto__ = null;
var cljs$core$async$state_machine__38765__auto____0 = (function (){
var statearr_40614 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40614[(0)] = cljs$core$async$state_machine__38765__auto__);

(statearr_40614[(1)] = (1));

return statearr_40614;
});
var cljs$core$async$state_machine__38765__auto____1 = (function (state_40591){
while(true){
var ret_value__38766__auto__ = (function (){try{while(true){
var result__38767__auto__ = switch__38764__auto__.call(null,state_40591);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38767__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38767__auto__;
}
break;
}
}catch (e40615){if((e40615 instanceof Object)){
var ex__38768__auto__ = e40615;
var statearr_40616_40634 = state_40591;
(statearr_40616_40634[(5)] = ex__38768__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40591);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40615;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38766__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40635 = state_40591;
state_40591 = G__40635;
continue;
} else {
return ret_value__38766__auto__;
}
break;
}
});
cljs$core$async$state_machine__38765__auto__ = function(state_40591){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38765__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38765__auto____1.call(this,state_40591);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38765__auto____0;
cljs$core$async$state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38765__auto____1;
return cljs$core$async$state_machine__38765__auto__;
})()
;})(switch__38764__auto__,c__38817__auto___40619,out))
})();
var state__38819__auto__ = (function (){var statearr_40617 = f__38818__auto__.call(null);
(statearr_40617[(6)] = c__38817__auto___40619);

return statearr_40617;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38819__auto__);
});})(c__38817__auto___40619,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__40637 = arguments.length;
switch (G__40637) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__38817__auto___40707 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38817__auto___40707,out){
return (function (){
var f__38818__auto__ = (function (){var switch__38764__auto__ = ((function (c__38817__auto___40707,out){
return (function (state_40679){
var state_val_40680 = (state_40679[(1)]);
if((state_val_40680 === (7))){
var inst_40675 = (state_40679[(2)]);
var state_40679__$1 = state_40679;
var statearr_40681_40708 = state_40679__$1;
(statearr_40681_40708[(2)] = inst_40675);

(statearr_40681_40708[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40680 === (1))){
var inst_40638 = [];
var inst_40639 = inst_40638;
var inst_40640 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_40679__$1 = (function (){var statearr_40682 = state_40679;
(statearr_40682[(7)] = inst_40640);

(statearr_40682[(8)] = inst_40639);

return statearr_40682;
})();
var statearr_40683_40709 = state_40679__$1;
(statearr_40683_40709[(2)] = null);

(statearr_40683_40709[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40680 === (4))){
var inst_40643 = (state_40679[(9)]);
var inst_40643__$1 = (state_40679[(2)]);
var inst_40644 = (inst_40643__$1 == null);
var inst_40645 = cljs.core.not.call(null,inst_40644);
var state_40679__$1 = (function (){var statearr_40684 = state_40679;
(statearr_40684[(9)] = inst_40643__$1);

return statearr_40684;
})();
if(inst_40645){
var statearr_40685_40710 = state_40679__$1;
(statearr_40685_40710[(1)] = (5));

} else {
var statearr_40686_40711 = state_40679__$1;
(statearr_40686_40711[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40680 === (15))){
var inst_40669 = (state_40679[(2)]);
var state_40679__$1 = state_40679;
var statearr_40687_40712 = state_40679__$1;
(statearr_40687_40712[(2)] = inst_40669);

(statearr_40687_40712[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40680 === (13))){
var state_40679__$1 = state_40679;
var statearr_40688_40713 = state_40679__$1;
(statearr_40688_40713[(2)] = null);

(statearr_40688_40713[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40680 === (6))){
var inst_40639 = (state_40679[(8)]);
var inst_40664 = inst_40639.length;
var inst_40665 = (inst_40664 > (0));
var state_40679__$1 = state_40679;
if(cljs.core.truth_(inst_40665)){
var statearr_40689_40714 = state_40679__$1;
(statearr_40689_40714[(1)] = (12));

} else {
var statearr_40690_40715 = state_40679__$1;
(statearr_40690_40715[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40680 === (3))){
var inst_40677 = (state_40679[(2)]);
var state_40679__$1 = state_40679;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40679__$1,inst_40677);
} else {
if((state_val_40680 === (12))){
var inst_40639 = (state_40679[(8)]);
var inst_40667 = cljs.core.vec.call(null,inst_40639);
var state_40679__$1 = state_40679;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_40679__$1,(15),out,inst_40667);
} else {
if((state_val_40680 === (2))){
var state_40679__$1 = state_40679;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40679__$1,(4),ch);
} else {
if((state_val_40680 === (11))){
var inst_40643 = (state_40679[(9)]);
var inst_40647 = (state_40679[(10)]);
var inst_40657 = (state_40679[(2)]);
var inst_40658 = [];
var inst_40659 = inst_40658.push(inst_40643);
var inst_40639 = inst_40658;
var inst_40640 = inst_40647;
var state_40679__$1 = (function (){var statearr_40691 = state_40679;
(statearr_40691[(7)] = inst_40640);

(statearr_40691[(11)] = inst_40659);

(statearr_40691[(8)] = inst_40639);

(statearr_40691[(12)] = inst_40657);

return statearr_40691;
})();
var statearr_40692_40716 = state_40679__$1;
(statearr_40692_40716[(2)] = null);

(statearr_40692_40716[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40680 === (9))){
var inst_40639 = (state_40679[(8)]);
var inst_40655 = cljs.core.vec.call(null,inst_40639);
var state_40679__$1 = state_40679;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_40679__$1,(11),out,inst_40655);
} else {
if((state_val_40680 === (5))){
var inst_40640 = (state_40679[(7)]);
var inst_40643 = (state_40679[(9)]);
var inst_40647 = (state_40679[(10)]);
var inst_40647__$1 = f.call(null,inst_40643);
var inst_40648 = cljs.core._EQ_.call(null,inst_40647__$1,inst_40640);
var inst_40649 = cljs.core.keyword_identical_QMARK_.call(null,inst_40640,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_40650 = (inst_40648) || (inst_40649);
var state_40679__$1 = (function (){var statearr_40693 = state_40679;
(statearr_40693[(10)] = inst_40647__$1);

return statearr_40693;
})();
if(cljs.core.truth_(inst_40650)){
var statearr_40694_40717 = state_40679__$1;
(statearr_40694_40717[(1)] = (8));

} else {
var statearr_40695_40718 = state_40679__$1;
(statearr_40695_40718[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40680 === (14))){
var inst_40672 = (state_40679[(2)]);
var inst_40673 = cljs.core.async.close_BANG_.call(null,out);
var state_40679__$1 = (function (){var statearr_40697 = state_40679;
(statearr_40697[(13)] = inst_40672);

return statearr_40697;
})();
var statearr_40698_40719 = state_40679__$1;
(statearr_40698_40719[(2)] = inst_40673);

(statearr_40698_40719[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40680 === (10))){
var inst_40662 = (state_40679[(2)]);
var state_40679__$1 = state_40679;
var statearr_40699_40720 = state_40679__$1;
(statearr_40699_40720[(2)] = inst_40662);

(statearr_40699_40720[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40680 === (8))){
var inst_40643 = (state_40679[(9)]);
var inst_40639 = (state_40679[(8)]);
var inst_40647 = (state_40679[(10)]);
var inst_40652 = inst_40639.push(inst_40643);
var tmp40696 = inst_40639;
var inst_40639__$1 = tmp40696;
var inst_40640 = inst_40647;
var state_40679__$1 = (function (){var statearr_40700 = state_40679;
(statearr_40700[(7)] = inst_40640);

(statearr_40700[(8)] = inst_40639__$1);

(statearr_40700[(14)] = inst_40652);

return statearr_40700;
})();
var statearr_40701_40721 = state_40679__$1;
(statearr_40701_40721[(2)] = null);

(statearr_40701_40721[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38817__auto___40707,out))
;
return ((function (switch__38764__auto__,c__38817__auto___40707,out){
return (function() {
var cljs$core$async$state_machine__38765__auto__ = null;
var cljs$core$async$state_machine__38765__auto____0 = (function (){
var statearr_40702 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40702[(0)] = cljs$core$async$state_machine__38765__auto__);

(statearr_40702[(1)] = (1));

return statearr_40702;
});
var cljs$core$async$state_machine__38765__auto____1 = (function (state_40679){
while(true){
var ret_value__38766__auto__ = (function (){try{while(true){
var result__38767__auto__ = switch__38764__auto__.call(null,state_40679);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38767__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38767__auto__;
}
break;
}
}catch (e40703){if((e40703 instanceof Object)){
var ex__38768__auto__ = e40703;
var statearr_40704_40722 = state_40679;
(statearr_40704_40722[(5)] = ex__38768__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40679);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40703;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38766__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40723 = state_40679;
state_40679 = G__40723;
continue;
} else {
return ret_value__38766__auto__;
}
break;
}
});
cljs$core$async$state_machine__38765__auto__ = function(state_40679){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38765__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38765__auto____1.call(this,state_40679);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38765__auto____0;
cljs$core$async$state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38765__auto____1;
return cljs$core$async$state_machine__38765__auto__;
})()
;})(switch__38764__auto__,c__38817__auto___40707,out))
})();
var state__38819__auto__ = (function (){var statearr_40705 = f__38818__auto__.call(null);
(statearr_40705[(6)] = c__38817__auto___40707);

return statearr_40705;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38819__auto__);
});})(c__38817__auto___40707,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1503590937222
