// Compiled by ClojureScript 1.9.908 {}
goog.provide('orcl.analyzer');
goog.require('cljs.core');
goog.require('orcl.utils.cursor');
goog.require('orcl.utils');
goog.require('clojure.set');
goog.require('orcl.analyzer.vars');
goog.require('orcl.analyzer.patterns');
orcl.analyzer.primitive_QMARK_ = (function orcl$analyzer$primitive_QMARK_(n){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"const","const",1709929842),null,new cljs.core.Keyword(null,"var","var",-769682797),null], null), null).call(null,new cljs.core.Keyword(null,"node","node",581201198).cljs$core$IFn$_invoke$arity$1(n));
});
orcl.analyzer.deflate_values = (function orcl$analyzer$deflate_values(p__32221,node){
while(true){
var vec__32222 = p__32221;
var seq__32223 = cljs.core.seq.call(null,vec__32222);
var first__32224 = cljs.core.first.call(null,seq__32223);
var seq__32223__$1 = cljs.core.next.call(null,seq__32223);
var c = first__32224;
var cursors = seq__32223__$1;
if((c == null)){
return cljs.core.deref.call(null,node);
} else {
if(cljs.core.truth_(orcl.analyzer.primitive_QMARK_.call(null,cljs.core.deref.call(null,c)))){
var G__32226 = cursors;
var G__32227 = node;
p__32221 = G__32226;
node = G__32227;
continue;
} else {
var _STAR_fresh_STAR_32225 = orcl.analyzer.vars._STAR_fresh_STAR_;
orcl.analyzer.vars._STAR_fresh_STAR_ = (orcl.analyzer.vars._STAR_fresh_STAR_ + (1));

try{var fresh = ["__fresh",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orcl.analyzer.vars._STAR_fresh_STAR_)].join('');
var orig = cljs.core.deref.call(null,c);
orcl.utils.cursor.reset_BANG_.call(null,c,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"node","node",581201198),new cljs.core.Keyword(null,"var","var",-769682797),new cljs.core.Keyword(null,"var","var",-769682797),fresh], null));

return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"node","node",581201198),new cljs.core.Keyword(null,"pruning","pruning",-1224456546),new cljs.core.Keyword(null,"pattern","pattern",242135423),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"var","var",-769682797),new cljs.core.Keyword(null,"var","var",-769682797),fresh], null),new cljs.core.Keyword(null,"left","left",-399115937),orcl.analyzer.deflate_values.call(null,cursors,node),new cljs.core.Keyword(null,"right","right",-452581833),orig], null);
}finally {orcl.analyzer.vars._STAR_fresh_STAR_ = _STAR_fresh_STAR_32225;
}
}
}
break;
}
});
orcl.analyzer.bindings = (function orcl$analyzer$bindings(ast){
var G__32228 = new cljs.core.Keyword(null,"node","node",581201198).cljs$core$IFn$_invoke$arity$1(ast);
var G__32228__$1 = (((G__32228 instanceof cljs.core.Keyword))?G__32228.fqn:null);
switch (G__32228__$1) {
case "var":
return cljs.core.PersistentHashSet.createAsIfByAssoc([new cljs.core.Keyword(null,"var","var",-769682797).cljs$core$IFn$_invoke$arity$1(ast)]);

break;
case "pruning":
return clojure.set.union.call(null,clojure.set.difference.call(null,orcl.analyzer.bindings.call(null,new cljs.core.Keyword(null,"left","left",-399115937).cljs$core$IFn$_invoke$arity$1(ast)),clojure.set.difference.call(null,new cljs.core.Keyword(null,"pattern","pattern",242135423).cljs$core$IFn$_invoke$arity$1(ast))),orcl.analyzer.bindings.call(null,new cljs.core.Keyword(null,"right","right",-452581833).cljs$core$IFn$_invoke$arity$1(ast)));

break;
case "sequential":
return clojure.set.union.call(null,orcl.analyzer.bindings.call(null,new cljs.core.Keyword(null,"left","left",-399115937).cljs$core$IFn$_invoke$arity$1(ast)),clojure.set.difference.call(null,orcl.analyzer.bindings.call(null,new cljs.core.Keyword(null,"right","right",-452581833).cljs$core$IFn$_invoke$arity$1(ast)),clojure.set.difference.call(null,new cljs.core.Keyword(null,"pattern","pattern",242135423).cljs$core$IFn$_invoke$arity$1(ast))));

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__32228__$1)].join('')));

}
});
orcl.analyzer.normalize_declarations = (function orcl$analyzer$normalize_declarations(p__32230){
var map__32231 = p__32230;
var map__32231__$1 = ((((!((map__32231 == null)))?((((map__32231.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32231.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32231):map__32231);
var decls = cljs.core.get.call(null,map__32231__$1,new cljs.core.Keyword(null,"decls","decls",1343324492));
var expr = cljs.core.get.call(null,map__32231__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var flat_defs = ((function (map__32231,map__32231__$1,decls,expr){
return (function orcl$analyzer$normalize_declarations_$_flat_defs(defs){
return null;
});})(map__32231,map__32231__$1,decls,expr))
;
var G__32236 = decls;
var vec__32237 = G__32236;
var seq__32238 = cljs.core.seq.call(null,vec__32237);
var first__32239 = cljs.core.first.call(null,seq__32238);
var seq__32238__$1 = cljs.core.next.call(null,seq__32238);
var d = first__32239;
var decls__$1 = seq__32238__$1;
var defs = cljs.core.PersistentArrayMap.EMPTY;
var G__32236__$1 = G__32236;
var defs__$1 = defs;
while(true){
var vec__32240 = G__32236__$1;
var seq__32241 = cljs.core.seq.call(null,vec__32240);
var first__32242 = cljs.core.first.call(null,seq__32241);
var seq__32241__$1 = cljs.core.next.call(null,seq__32241);
var d__$1 = first__32242;
var decls__$2 = seq__32241__$1;
var defs__$2 = defs__$1;
if(cljs.core.truth_(d__$1)){
var G__32243 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(d__$1);
var G__32243__$1 = (((G__32243 instanceof cljs.core.Keyword))?G__32243.fqn:null);
switch (G__32243__$1) {
case "include":
var G__32245 = cljs.core.concat.call(null,new cljs.core.Keyword(null,"decls","decls",1343324492).cljs$core$IFn$_invoke$arity$1(d__$1),decls__$2);
var G__32246 = defs__$2;
G__32236__$1 = G__32245;
defs__$1 = G__32246;
continue;

break;
case "val":
var n = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"node","node",581201198),new cljs.core.Keyword(null,"pruning","pruning",-1224456546),new cljs.core.Keyword(null,"pattern","pattern",242135423),new cljs.core.Keyword(null,"pattern","pattern",242135423).cljs$core$IFn$_invoke$arity$1(d__$1),new cljs.core.Keyword(null,"left","left",-399115937),((cljs.core.seq.call(null,decls__$2))?new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"node","node",581201198),new cljs.core.Keyword(null,"declarations","declarations",1621100858),new cljs.core.Keyword(null,"decls","decls",1343324492),decls__$2,new cljs.core.Keyword(null,"expr","expr",745722291),expr], null):expr),new cljs.core.Keyword(null,"right","right",-452581833),new cljs.core.Keyword(null,"expr","expr",745722291).cljs$core$IFn$_invoke$arity$1(d__$1)], null);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"node","node",581201198),new cljs.core.Keyword(null,"defs-group","defs-group",-1605838115),new cljs.core.Keyword(null,"defs","defs",1398449717),cljs.core.vals.call(null,defs__$2),new cljs.core.Keyword(null,"expr","expr",745722291),n], null);

break;
case "def":
var inst = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(d__$1),new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(d__$1),new cljs.core.Keyword(null,"guard","guard",-873147811),new cljs.core.Keyword(null,"guard","guard",-873147811).cljs$core$IFn$_invoke$arity$1(d__$1)], null);
var def = cljs.core.get.call(null,defs__$2,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(d__$1),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(d__$1),new cljs.core.Keyword(null,"instances","instances",-335364781),cljs.core.PersistentVector.EMPTY], null));
var G__32247 = decls__$2;
var G__32248 = cljs.core.assoc.call(null,defs__$2,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(d__$1),cljs.core.update.call(null,def,new cljs.core.Keyword(null,"instances","instances",-335364781),cljs.core.conj,inst));
G__32236__$1 = G__32247;
defs__$1 = G__32248;
continue;

break;
case "def-sig":
var G__32249 = decls__$2;
var G__32250 = defs__$2;
G__32236__$1 = G__32249;
defs__$1 = G__32250;
continue;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__32243__$1)].join('')));

}
} else {
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"node","node",581201198),new cljs.core.Keyword(null,"defs-group","defs-group",-1605838115),new cljs.core.Keyword(null,"defs","defs",1398449717),cljs.core.vals.call(null,defs__$2),new cljs.core.Keyword(null,"expr","expr",745722291),expr], null);
}
break;
}
});
orcl.analyzer.normalize_STAR_ = (function orcl$analyzer$normalize_STAR_(ast){
var G__32251 = new cljs.core.Keyword(null,"node","node",581201198).cljs$core$IFn$_invoke$arity$1(ast);
var G__32251__$1 = (((G__32251 instanceof cljs.core.Keyword))?G__32251.fqn:null);
switch (G__32251__$1) {
case "declarations":
return orcl.analyzer.normalize_declarations.call(null,ast);

break;
case "lambda":
var body = new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(ast);
var n = ["__def_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orcl.utils.sha.call(null,body))].join('');
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"node","node",581201198),new cljs.core.Keyword(null,"defs-group","defs-group",-1605838115),new cljs.core.Keyword(null,"defs","defs",1398449717),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),n,new cljs.core.Keyword(null,"instances","instances",-335364781),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"guard","guard",-873147811),new cljs.core.Keyword(null,"guard","guard",-873147811).cljs$core$IFn$_invoke$arity$1(ast),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(ast),new cljs.core.Keyword(null,"body","body",-2049205669),body], null)], null)], null)], null),new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"node","node",581201198),new cljs.core.Keyword(null,"var","var",-769682797),new cljs.core.Keyword(null,"var","var",-769682797),n], null)], null);

break;
case "list":
case "tuple":
var c = orcl.utils.cursor.make.call(null,ast);
return orcl.analyzer.deflate_values.call(null,cljs.core.seq.call(null,new cljs.core.Keyword(null,"values","values",372645556).cljs$core$IFn$_invoke$arity$1(c)),c);

break;
case "record":
var c = orcl.utils.cursor.make.call(null,ast);
return orcl.analyzer.deflate_values.call(null,cljs.core.map.call(null,cljs.core.second,new cljs.core.Keyword(null,"pairs","pairs",614609779).cljs$core$IFn$_invoke$arity$1(c)),c);

break;
case "call":
var c = orcl.utils.cursor.make.call(null,ast);
return orcl.analyzer.deflate_values.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"target","target",253001721).cljs$core$IFn$_invoke$arity$1(c)], null),new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(c)),c);

break;
case "field-access":
var c = orcl.utils.cursor.make.call(null,ast);
return orcl.analyzer.deflate_values.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"target","target",253001721).cljs$core$IFn$_invoke$arity$1(c)], null),c);

break;
case "conditional":
var v = ["__v_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orcl.utils.sha.call(null,ast))].join('');
var then = ["__then_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orcl.utils.sha.call(null,new cljs.core.Keyword(null,"then","then",460598070).cljs$core$IFn$_invoke$arity$1(ast)))].join('');
var else$ = ["__else_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orcl.utils.sha.call(null,new cljs.core.Keyword(null,"else","else",-1508377146).cljs$core$IFn$_invoke$arity$1(ast)))].join('');
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"node","node",581201198),new cljs.core.Keyword(null,"defs-group","defs-group",-1605838115),new cljs.core.Keyword(null,"defs","defs",1398449717),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),then,new cljs.core.Keyword(null,"instances","instances",-335364781),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"params","params",710516235),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.Keyword(null,"then","then",460598070).cljs$core$IFn$_invoke$arity$1(ast)], null)], null)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),else$,new cljs.core.Keyword(null,"instances","instances",-335364781),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"params","params",710516235),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.Keyword(null,"else","else",-1508377146).cljs$core$IFn$_invoke$arity$1(ast)], null)], null)], null)], null),new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"node","node",581201198),new cljs.core.Keyword(null,"sequential","sequential",-1082983960),new cljs.core.Keyword(null,"pattern","pattern",242135423),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"var","var",-769682797),new cljs.core.Keyword(null,"var","var",-769682797),v], null),new cljs.core.Keyword(null,"left","left",-399115937),new cljs.core.Keyword(null,"if","if",-458814265).cljs$core$IFn$_invoke$arity$1(ast),new cljs.core.Keyword(null,"right","right",-452581833),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"node","node",581201198),new cljs.core.Keyword(null,"normalized-conditional","normalized-conditional",-1179416019),new cljs.core.Keyword(null,"if","if",-458814265),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"node","node",581201198),new cljs.core.Keyword(null,"var","var",-769682797),new cljs.core.Keyword(null,"var","var",-769682797),v], null),new cljs.core.Keyword(null,"then","then",460598070),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"node","node",581201198),new cljs.core.Keyword(null,"var","var",-769682797),new cljs.core.Keyword(null,"var","var",-769682797),then], null),new cljs.core.Keyword(null,"else","else",-1508377146),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"node","node",581201198),new cljs.core.Keyword(null,"var","var",-769682797),new cljs.core.Keyword(null,"var","var",-769682797),else$], null)], null)], null)], null);

break;
default:
return ast;

}
});
orcl.analyzer.normalize = (function orcl$analyzer$normalize(ast){
return orcl.utils.ast_prewalk.call(null,orcl.analyzer.normalize_STAR_,ast);
});
orcl.analyzer.with_sha = (function orcl$analyzer$with_sha(ast){
return orcl.utils.ast_postwalk.call(null,orcl.utils.with_sha,ast);
});
orcl.analyzer.flatten_def = (function orcl$analyzer$flatten_def(var_args){
var G__32254 = arguments.length;
switch (G__32254) {
case 1:
return orcl.analyzer.flatten_def.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return orcl.analyzer.flatten_def.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

orcl.analyzer.flatten_def.cljs$core$IFn$_invoke$arity$1 = (function (ast){
return orcl.analyzer.flatten_def.call(null,ast,cljs.core.PersistentVector.EMPTY);
});

orcl.analyzer.flatten_def.cljs$core$IFn$_invoke$arity$2 = (function (ast,acc){
if((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"declaration","declaration",-1819933768),new cljs.core.Keyword(null,"node","node",581201198).cljs$core$IFn$_invoke$arity$1(ast))) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"def","def",-1043430536),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"decl","decl",-1498869485).cljs$core$IFn$_invoke$arity$1(ast))))){
return orcl.analyzer.flatten_def.call(null,new cljs.core.Keyword(null,"expr","expr",745722291).cljs$core$IFn$_invoke$arity$1(ast),cljs.core.conj.call(null,acc,new cljs.core.Keyword(null,"decl","decl",-1498869485).cljs$core$IFn$_invoke$arity$1(ast)));
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ast,acc], null);
}
});

orcl.analyzer.flatten_def.cljs$lang$maxFixedArity = 2;

orcl.analyzer.analyze_instance = (function orcl$analyzer$analyze_instance(id,instance){
var argument_envs = (function (i,p){
return cljs.core.map.call(null,(function (binding){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [binding,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"argument","argument",1183001841),new cljs.core.Keyword(null,"position","position",-2011731912),i,new cljs.core.Keyword(null,"instance-sha","instance-sha",51010913),new cljs.core.Keyword(null,"sha","sha",-950317251).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(instance)),new cljs.core.Keyword(null,"id","id",-1388402092),id], null)], null);
}),orcl.analyzer.patterns.pattern_bindings.call(null,p));
});
var _STAR_env_STAR_32256 = orcl.analyzer.vars._STAR_env_STAR_;
orcl.analyzer.vars._STAR_env_STAR_ = cljs.core.merge.call(null,orcl.analyzer.vars._STAR_env_STAR_,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.mapcat.call(null,argument_envs,cljs.core.range.call(null),new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(instance))));

try{var _STAR_tail_pos_STAR_32257 = orcl.analyzer._STAR_tail_pos_STAR_;
orcl.analyzer._STAR_tail_pos_STAR_ = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",-1388402092),id], null);

try{return cljs.core.update.call(null,instance,new cljs.core.Keyword(null,"body","body",-2049205669),orcl.analyzer.analyze_env);
}finally {orcl.analyzer._STAR_tail_pos_STAR_ = _STAR_tail_pos_STAR_32257;
}}finally {orcl.analyzer.vars._STAR_env_STAR_ = _STAR_env_STAR_32256;
}});
orcl.analyzer.analyze_def = (function orcl$analyzer$analyze_def(defs,p__32258){
var map__32259 = p__32258;
var map__32259__$1 = ((((!((map__32259 == null)))?((((map__32259.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32259.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32259):map__32259);
var node = map__32259__$1;
var name = cljs.core.get.call(null,map__32259__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var usages = cljs.core.get.call(null,map__32259__$1,new cljs.core.Keyword(null,"usages","usages",-1094756749));
var sha = cljs.core.get.call(null,map__32259__$1,new cljs.core.Keyword(null,"sha","sha",-950317251));
var instances = cljs.core.get.call(null,map__32259__$1,new cljs.core.Keyword(null,"instances","instances",-335364781));
var _STAR_env_STAR_32261 = orcl.analyzer.vars._STAR_env_STAR_;
orcl.analyzer.vars._STAR_env_STAR_ = cljs.core.merge.call(null,orcl.analyzer.vars._STAR_env_STAR_,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__28797__auto__ = ((function (_STAR_env_STAR_32261,map__32259,map__32259__$1,node,name,usages,sha,instances){
return (function orcl$analyzer$analyze_def_$_iter__32262(s__32263){
return (new cljs.core.LazySeq(null,((function (_STAR_env_STAR_32261,map__32259,map__32259__$1,node,name,usages,sha,instances){
return (function (){
var s__32263__$1 = s__32263;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__32263__$1);
if(temp__4657__auto__){
var s__32263__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__32263__$2)){
var c__28795__auto__ = cljs.core.chunk_first.call(null,s__32263__$2);
var size__28796__auto__ = cljs.core.count.call(null,c__28795__auto__);
var b__32265 = cljs.core.chunk_buffer.call(null,size__28796__auto__);
if((function (){var i__32264 = (0);
while(true){
if((i__32264 < size__28796__auto__)){
var map__32266 = cljs.core._nth.call(null,c__28795__auto__,i__32264);
var map__32266__$1 = ((((!((map__32266 == null)))?((((map__32266.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32266.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32266):map__32266);
var name__$1 = cljs.core.get.call(null,map__32266__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var usages__$1 = cljs.core.get.call(null,map__32266__$1,new cljs.core.Keyword(null,"usages","usages",-1094756749));
var node__$1 = cljs.core.get.call(null,map__32266__$1,new cljs.core.Keyword(null,"node","node",581201198));
var sha__$1 = cljs.core.get.call(null,map__32266__$1,new cljs.core.Keyword(null,"sha","sha",-950317251));
cljs.core.chunk_append.call(null,b__32265,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"def","def",-1043430536),new cljs.core.Keyword(null,"id","id",-1388402092),sha__$1,new cljs.core.Keyword(null,"usages","usages",-1094756749),usages__$1], null)], null));

var G__32270 = (i__32264 + (1));
i__32264 = G__32270;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__32265),orcl$analyzer$analyze_def_$_iter__32262.call(null,cljs.core.chunk_rest.call(null,s__32263__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__32265),null);
}
} else {
var map__32268 = cljs.core.first.call(null,s__32263__$2);
var map__32268__$1 = ((((!((map__32268 == null)))?((((map__32268.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32268.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32268):map__32268);
var name__$1 = cljs.core.get.call(null,map__32268__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var usages__$1 = cljs.core.get.call(null,map__32268__$1,new cljs.core.Keyword(null,"usages","usages",-1094756749));
var node__$1 = cljs.core.get.call(null,map__32268__$1,new cljs.core.Keyword(null,"node","node",581201198));
var sha__$1 = cljs.core.get.call(null,map__32268__$1,new cljs.core.Keyword(null,"sha","sha",-950317251));
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"def","def",-1043430536),new cljs.core.Keyword(null,"id","id",-1388402092),sha__$1,new cljs.core.Keyword(null,"usages","usages",-1094756749),usages__$1], null)], null),orcl$analyzer$analyze_def_$_iter__32262.call(null,cljs.core.rest.call(null,s__32263__$2)));
}
} else {
return null;
}
break;
}
});})(_STAR_env_STAR_32261,map__32259,map__32259__$1,node,name,usages,sha,instances))
,null,null));
});})(_STAR_env_STAR_32261,map__32259,map__32259__$1,node,name,usages,sha,instances))
;
return iter__28797__auto__.call(null,defs);
})()));

try{return cljs.core.assoc.call(null,node,new cljs.core.Keyword(null,"arity","arity",-1808556135),cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,instances))),new cljs.core.Keyword(null,"instances","instances",-335364781),cljs.core.mapv.call(null,cljs.core.partial.call(null,orcl.analyzer.analyze_instance,sha),instances));
}finally {orcl.analyzer.vars._STAR_env_STAR_ = _STAR_env_STAR_32261;
}});
orcl.analyzer.analyze_defs = (function orcl$analyzer$analyze_defs(defs){
var defs_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__32271_SHARP_){
return cljs.core.assoc.call(null,p1__32271_SHARP_,new cljs.core.Keyword(null,"usages","usages",-1094756749),cljs.core.atom.call(null,(0)),new cljs.core.Keyword(null,"sha","sha",-950317251),orcl.utils.sha.call(null,p1__32271_SHARP_));
}),defs);
return cljs.core.mapv.call(null,cljs.core.partial.call(null,orcl.analyzer.analyze_def,defs_SINGLEQUOTE_),defs_SINGLEQUOTE_);
});
orcl.analyzer.check_call_BANG_ = (function orcl$analyzer$check_call_BANG_(call){
return null;
});
orcl.analyzer.analyze_env = (function orcl$analyzer$analyze_env(ast){
var G__32272 = new cljs.core.Keyword(null,"node","node",581201198).cljs$core$IFn$_invoke$arity$1(ast);
var G__32272__$1 = (((G__32272 instanceof cljs.core.Keyword))?G__32272.fqn:null);
switch (G__32272__$1) {
case "pruning":
return cljs.core.assoc.call(null,ast,new cljs.core.Keyword(null,"left","left",-399115937),(function (){var _STAR_env_STAR_32273 = orcl.analyzer.vars._STAR_env_STAR_;
orcl.analyzer.vars._STAR_env_STAR_ = cljs.core.merge.call(null,orcl.analyzer.vars._STAR_env_STAR_,orcl.analyzer.patterns.pattern_envs.call(null,new cljs.core.Keyword(null,"pattern","pattern",242135423).cljs$core$IFn$_invoke$arity$1(ast),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pruning","pruning",-1224456546),new cljs.core.Keyword(null,"node-sha","node-sha",-418411289),new cljs.core.Keyword(null,"sha","sha",-950317251).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"right","right",-452581833).cljs$core$IFn$_invoke$arity$1(ast))], null)));

try{return orcl.analyzer.analyze_env.call(null,new cljs.core.Keyword(null,"left","left",-399115937).cljs$core$IFn$_invoke$arity$1(ast));
}finally {orcl.analyzer.vars._STAR_env_STAR_ = _STAR_env_STAR_32273;
}})(),new cljs.core.Keyword(null,"right","right",-452581833),(function (){var _STAR_tail_pos_STAR_32274 = orcl.analyzer._STAR_tail_pos_STAR_;
orcl.analyzer._STAR_tail_pos_STAR_ = null;

try{return orcl.analyzer.analyze_env.call(null,new cljs.core.Keyword(null,"right","right",-452581833).cljs$core$IFn$_invoke$arity$1(ast));
}finally {orcl.analyzer._STAR_tail_pos_STAR_ = _STAR_tail_pos_STAR_32274;
}})());

break;
case "sequential":
return cljs.core.assoc.call(null,ast,new cljs.core.Keyword(null,"right","right",-452581833),(function (){var _STAR_env_STAR_32275 = orcl.analyzer.vars._STAR_env_STAR_;
orcl.analyzer.vars._STAR_env_STAR_ = cljs.core.merge.call(null,orcl.analyzer.vars._STAR_env_STAR_,orcl.analyzer.patterns.pattern_envs.call(null,new cljs.core.Keyword(null,"pattern","pattern",242135423).cljs$core$IFn$_invoke$arity$1(ast),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"sequential","sequential",-1082983960),new cljs.core.Keyword(null,"node-sha","node-sha",-418411289),new cljs.core.Keyword(null,"sha","sha",-950317251).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"left","left",-399115937).cljs$core$IFn$_invoke$arity$1(ast))], null)));

try{var _STAR_tail_pos_STAR_32276 = orcl.analyzer._STAR_tail_pos_STAR_;
orcl.analyzer._STAR_tail_pos_STAR_ = null;

try{return orcl.analyzer.analyze_env.call(null,new cljs.core.Keyword(null,"right","right",-452581833).cljs$core$IFn$_invoke$arity$1(ast));
}finally {orcl.analyzer._STAR_tail_pos_STAR_ = _STAR_tail_pos_STAR_32276;
}}finally {orcl.analyzer.vars._STAR_env_STAR_ = _STAR_env_STAR_32275;
}})(),new cljs.core.Keyword(null,"left","left",-399115937),(function (){var _STAR_tail_pos_STAR_32277 = orcl.analyzer._STAR_tail_pos_STAR_;
orcl.analyzer._STAR_tail_pos_STAR_ = null;

try{return orcl.analyzer.analyze_env.call(null,new cljs.core.Keyword(null,"left","left",-399115937).cljs$core$IFn$_invoke$arity$1(ast));
}finally {orcl.analyzer._STAR_tail_pos_STAR_ = _STAR_tail_pos_STAR_32277;
}})());

break;
case "otherwise":
return cljs.core.assoc.call(null,ast,new cljs.core.Keyword(null,"right","right",-452581833),(function (){var _STAR_tail_pos_STAR_32278 = orcl.analyzer._STAR_tail_pos_STAR_;
orcl.analyzer._STAR_tail_pos_STAR_ = null;

try{return orcl.analyzer.analyze_env.call(null,new cljs.core.Keyword(null,"right","right",-452581833).cljs$core$IFn$_invoke$arity$1(ast));
}finally {orcl.analyzer._STAR_tail_pos_STAR_ = _STAR_tail_pos_STAR_32278;
}})(),new cljs.core.Keyword(null,"left","left",-399115937),(function (){var _STAR_tail_pos_STAR_32279 = orcl.analyzer._STAR_tail_pos_STAR_;
orcl.analyzer._STAR_tail_pos_STAR_ = null;

try{return orcl.analyzer.analyze_env.call(null,new cljs.core.Keyword(null,"left","left",-399115937).cljs$core$IFn$_invoke$arity$1(ast));
}finally {orcl.analyzer._STAR_tail_pos_STAR_ = _STAR_tail_pos_STAR_32279;
}})());

break;
case "parallel":
return cljs.core.assoc.call(null,ast,new cljs.core.Keyword(null,"left","left",-399115937),(function (){var _STAR_tail_pos_STAR_32280 = orcl.analyzer._STAR_tail_pos_STAR_;
orcl.analyzer._STAR_tail_pos_STAR_ = null;

try{return orcl.analyzer.analyze_env.call(null,new cljs.core.Keyword(null,"left","left",-399115937).cljs$core$IFn$_invoke$arity$1(ast));
}finally {orcl.analyzer._STAR_tail_pos_STAR_ = _STAR_tail_pos_STAR_32280;
}})(),new cljs.core.Keyword(null,"right","right",-452581833),(function (){var _STAR_tail_pos_STAR_32281 = orcl.analyzer._STAR_tail_pos_STAR_;
orcl.analyzer._STAR_tail_pos_STAR_ = null;

try{return orcl.analyzer.analyze_env.call(null,new cljs.core.Keyword(null,"right","right",-452581833).cljs$core$IFn$_invoke$arity$1(ast));
}finally {orcl.analyzer._STAR_tail_pos_STAR_ = _STAR_tail_pos_STAR_32281;
}})());

break;
case "defs-group":
var defs = orcl.analyzer.analyze_defs.call(null,new cljs.core.Keyword(null,"defs","defs",1398449717).cljs$core$IFn$_invoke$arity$1(ast));
var _STAR_env_STAR_32282 = orcl.analyzer.vars._STAR_env_STAR_;
orcl.analyzer.vars._STAR_env_STAR_ = cljs.core.merge.call(null,orcl.analyzer.vars._STAR_env_STAR_,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__28797__auto__ = ((function (_STAR_env_STAR_32282,defs,G__32272,G__32272__$1){
return (function orcl$analyzer$analyze_env_$_iter__32283(s__32284){
return (new cljs.core.LazySeq(null,((function (_STAR_env_STAR_32282,defs,G__32272,G__32272__$1){
return (function (){
var s__32284__$1 = s__32284;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__32284__$1);
if(temp__4657__auto__){
var s__32284__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__32284__$2)){
var c__28795__auto__ = cljs.core.chunk_first.call(null,s__32284__$2);
var size__28796__auto__ = cljs.core.count.call(null,c__28795__auto__);
var b__32286 = cljs.core.chunk_buffer.call(null,size__28796__auto__);
if((function (){var i__32285 = (0);
while(true){
if((i__32285 < size__28796__auto__)){
var map__32287 = cljs.core._nth.call(null,c__28795__auto__,i__32285);
var map__32287__$1 = ((((!((map__32287 == null)))?((((map__32287.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32287.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32287):map__32287);
var name = cljs.core.get.call(null,map__32287__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var sha = cljs.core.get.call(null,map__32287__$1,new cljs.core.Keyword(null,"sha","sha",-950317251));
var usages = cljs.core.get.call(null,map__32287__$1,new cljs.core.Keyword(null,"usages","usages",-1094756749));
cljs.core.chunk_append.call(null,b__32286,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [name,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"def","def",-1043430536),new cljs.core.Keyword(null,"id","id",-1388402092),sha,new cljs.core.Keyword(null,"usages","usages",-1094756749),usages], null)], null));

var G__32292 = (i__32285 + (1));
i__32285 = G__32292;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__32286),orcl$analyzer$analyze_env_$_iter__32283.call(null,cljs.core.chunk_rest.call(null,s__32284__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__32286),null);
}
} else {
var map__32289 = cljs.core.first.call(null,s__32284__$2);
var map__32289__$1 = ((((!((map__32289 == null)))?((((map__32289.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32289.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32289):map__32289);
var name = cljs.core.get.call(null,map__32289__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var sha = cljs.core.get.call(null,map__32289__$1,new cljs.core.Keyword(null,"sha","sha",-950317251));
var usages = cljs.core.get.call(null,map__32289__$1,new cljs.core.Keyword(null,"usages","usages",-1094756749));
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [name,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"def","def",-1043430536),new cljs.core.Keyword(null,"id","id",-1388402092),sha,new cljs.core.Keyword(null,"usages","usages",-1094756749),usages], null)], null),orcl$analyzer$analyze_env_$_iter__32283.call(null,cljs.core.rest.call(null,s__32284__$2)));
}
} else {
return null;
}
break;
}
});})(_STAR_env_STAR_32282,defs,G__32272,G__32272__$1))
,null,null));
});})(_STAR_env_STAR_32282,defs,G__32272,G__32272__$1))
;
return iter__28797__auto__.call(null,defs);
})()));

try{return cljs.core.assoc.call(null,ast,new cljs.core.Keyword(null,"defs","defs",1398449717),defs,new cljs.core.Keyword(null,"expr","expr",745722291),orcl.analyzer.analyze_env.call(null,new cljs.core.Keyword(null,"expr","expr",745722291).cljs$core$IFn$_invoke$arity$1(ast)));
}finally {orcl.analyzer.vars._STAR_env_STAR_ = _STAR_env_STAR_32282;
}
break;
case "call":
var ast_SINGLEQUOTE_ = cljs.core.assoc.call(null,cljs.core.update.call(null,ast,new cljs.core.Keyword(null,"target","target",253001721),orcl.analyzer.analyze_env),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.mapv.call(null,orcl.analyzer.analyze_env,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(ast)));
orcl.analyzer.check_call_BANG_.call(null,ast_SINGLEQUOTE_);

var s = cljs.core.get_in.call(null,ast_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"target","target",253001721),new cljs.core.Keyword(null,"source","source",-433931539)], null));
if(cljs.core.truth_((function (){var and__27977__auto__ = orcl.analyzer._STAR_tail_pos_STAR_;
if(cljs.core.truth_(and__27977__auto__)){
return (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"def","def",-1043430536),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(s))) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(s),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(orcl.analyzer._STAR_tail_pos_STAR_)));
} else {
return and__27977__auto__;
}
})())){
return cljs.core.assoc.call(null,ast_SINGLEQUOTE_,new cljs.core.Keyword(null,"tail-pos","tail-pos",1500172733),orcl.analyzer._STAR_tail_pos_STAR_);
} else {
return ast_SINGLEQUOTE_;
}

break;
case "var":
var temp__4655__auto__ = cljs.core.get.call(null,orcl.analyzer.vars._STAR_env_STAR_,new cljs.core.Keyword(null,"var","var",-769682797).cljs$core$IFn$_invoke$arity$1(ast));
if(cljs.core.truth_(temp__4655__auto__)){
var source = temp__4655__auto__;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"def","def",-1043430536),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(source))){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"usages","usages",-1094756749).cljs$core$IFn$_invoke$arity$1(source),cljs.core.inc);
} else {
}

return cljs.core.assoc.call(null,ast,new cljs.core.Keyword(null,"source","source",-433931539),cljs.core.dissoc.call(null,source,new cljs.core.Keyword(null,"usages","usages",-1094756749)));
} else {
throw cljs.core.ex_info.call(null,"Undefined variable",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("orcl","error-pos","orcl/error-pos",-459808101),new cljs.core.Keyword(null,"pos","pos",-864607220).cljs$core$IFn$_invoke$arity$1(ast),new cljs.core.Keyword("orcl","error","orcl/error",-985000796),"Undefined variable",new cljs.core.Keyword(null,"variable","variable",-281346492),new cljs.core.Keyword(null,"var","var",-769682797).cljs$core$IFn$_invoke$arity$1(ast)], null));
}

break;
default:
return orcl.utils.ast_walk.call(null,orcl.analyzer.analyze_env,cljs.core.identity,ast);

}
});
orcl.analyzer.def_instance_locals = (function orcl$analyzer$def_instance_locals(instance){
return cljs.core.apply.call(null,clojure.set.difference,new cljs.core.Keyword(null,"locals","locals",535295783).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(instance)),cljs.core.map.call(null,orcl.analyzer.patterns.pattern_bindings,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(instance)));
});
orcl.analyzer.def_locals = (function orcl$analyzer$def_locals(def){
return cljs.core.set.call(null,cljs.core.mapcat.call(null,orcl.analyzer.def_instance_locals,new cljs.core.Keyword(null,"instances","instances",-335364781).cljs$core$IFn$_invoke$arity$1(def)));
});
orcl.analyzer.analyze_stage2 = (function orcl$analyzer$analyze_stage2(ast){
var set_locals = (function (ast__$1){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"defs-group","defs-group",-1605838115),new cljs.core.Keyword(null,"node","node",581201198).cljs$core$IFn$_invoke$arity$1(ast__$1))){
var defs_SINGLEQUOTE_ = cljs.core.mapv.call(null,(function (p1__32293_SHARP_){
return cljs.core.assoc.call(null,p1__32293_SHARP_,new cljs.core.Keyword(null,"locals","locals",535295783),orcl.analyzer.def_locals.call(null,p1__32293_SHARP_));
}),new cljs.core.Keyword(null,"defs","defs",1398449717).cljs$core$IFn$_invoke$arity$1(ast__$1));
return cljs.core.assoc.call(null,ast__$1,new cljs.core.Keyword(null,"defs","defs",1398449717),defs_SINGLEQUOTE_,new cljs.core.Keyword(null,"locals","locals",535295783),cljs.core.set.call(null,cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"locals","locals",535295783),defs_SINGLEQUOTE_)));
} else {
return cljs.core.assoc.call(null,ast__$1,new cljs.core.Keyword(null,"locals","locals",535295783),(function (){var G__32296 = new cljs.core.Keyword(null,"node","node",581201198).cljs$core$IFn$_invoke$arity$1(ast__$1);
var G__32296__$1 = (((G__32296 instanceof cljs.core.Keyword))?G__32296.fqn:null);
switch (G__32296__$1) {
case "otherwise":
case "parallel":
return clojure.set.union.call(null,new cljs.core.Keyword(null,"locals","locals",535295783).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"left","left",-399115937).cljs$core$IFn$_invoke$arity$1(ast__$1)),new cljs.core.Keyword(null,"locals","locals",535295783).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"right","right",-452581833).cljs$core$IFn$_invoke$arity$1(ast__$1)));

break;
case "sequential":
case "pruning":
return clojure.set.difference.call(null,clojure.set.union.call(null,new cljs.core.Keyword(null,"locals","locals",535295783).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"left","left",-399115937).cljs$core$IFn$_invoke$arity$1(ast__$1)),new cljs.core.Keyword(null,"locals","locals",535295783).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"right","right",-452581833).cljs$core$IFn$_invoke$arity$1(ast__$1))),orcl.analyzer.patterns.pattern_bindings.call(null,new cljs.core.Keyword(null,"pattern","pattern",242135423).cljs$core$IFn$_invoke$arity$1(ast__$1)));

break;
case "normalized-conditional":
return clojure.set.union.call(null,new cljs.core.Keyword(null,"locals","locals",535295783).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"var","var",-769682797).cljs$core$IFn$_invoke$arity$1(ast__$1)),new cljs.core.Keyword(null,"locals","locals",535295783).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"then","then",460598070).cljs$core$IFn$_invoke$arity$1(ast__$1)),new cljs.core.Keyword(null,"locals","locals",535295783).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"else","else",-1508377146).cljs$core$IFn$_invoke$arity$1(ast__$1)));

break;
case "field-access":
case "call":
return cljs.core.apply.call(null,clojure.set.union,cljs.core.get_in.call(null,ast__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"target","target",253001721),new cljs.core.Keyword(null,"locals","locals",535295783)], null)),cljs.core.map.call(null,new cljs.core.Keyword(null,"locals","locals",535295783),new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(ast__$1)));

break;
case "tuple":
case "list":
return cljs.core.apply.call(null,clojure.set.union,cljs.core.map.call(null,new cljs.core.Keyword(null,"locals","locals",535295783),new cljs.core.Keyword(null,"values","values",372645556).cljs$core$IFn$_invoke$arity$1(ast__$1)));

break;
case "record":
return cljs.core.apply.call(null,clojure.set.union,cljs.core.map.call(null,cljs.core.comp.call(null,new cljs.core.Keyword(null,"locals","locals",535295783),cljs.core.second),new cljs.core.Keyword(null,"pairs","pairs",614609779).cljs$core$IFn$_invoke$arity$1(ast__$1)));

break;
case "var":
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"site","site",-1852581499),null,new cljs.core.Keyword(null,"def","def",-1043430536),null], null), null).call(null,cljs.core.get_in.call(null,ast__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source","source",-433931539),new cljs.core.Keyword(null,"type","type",1174270348)], null))))){
return cljs.core.PersistentHashSet.EMPTY;
} else {
return cljs.core.PersistentHashSet.createAsIfByAssoc([new cljs.core.Keyword(null,"var","var",-769682797).cljs$core$IFn$_invoke$arity$1(ast__$1)]);
}

break;
case "const":
case "stop":
return cljs.core.PersistentHashSet.EMPTY;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__32296__$1)].join('')));

}
})());
}
});
var remove_unused = ((function (set_locals){
return (function (ast__$1){
var G__32297 = new cljs.core.Keyword(null,"node","node",581201198).cljs$core$IFn$_invoke$arity$1(ast__$1);
var G__32297__$1 = (((G__32297 instanceof cljs.core.Keyword))?G__32297.fqn:null);
switch (G__32297__$1) {
case "defs-group":
var in_use = cljs.core.filterv.call(null,((function (G__32297,G__32297__$1,set_locals){
return (function (p1__32294_SHARP_){
return (new cljs.core.Keyword(null,"usages","usages",-1094756749).cljs$core$IFn$_invoke$arity$1(p1__32294_SHARP_) > (0));
});})(G__32297,G__32297__$1,set_locals))
,cljs.core.map.call(null,((function (G__32297,G__32297__$1,set_locals){
return (function (p1__32295_SHARP_){
return cljs.core.update.call(null,p1__32295_SHARP_,new cljs.core.Keyword(null,"usages","usages",-1094756749),cljs.core.deref);
});})(G__32297,G__32297__$1,set_locals))
,new cljs.core.Keyword(null,"defs","defs",1398449717).cljs$core$IFn$_invoke$arity$1(ast__$1)));
if(cljs.core.truth_(cljs.core.not_empty.call(null,in_use))){
return cljs.core.assoc.call(null,ast__$1,new cljs.core.Keyword(null,"defs","defs",1398449717),in_use);
} else {
return new cljs.core.Keyword(null,"expr","expr",745722291).cljs$core$IFn$_invoke$arity$1(ast__$1);
}

break;
default:
return ast__$1;

}
});})(set_locals))
;
return orcl.utils.ast_postwalk.call(null,cljs.core.comp.call(null,set_locals,remove_unused),ast);
});
orcl.analyzer.analyze_final = (function orcl$analyzer$analyze_final(var_args){
var G__32301 = arguments.length;
switch (G__32301) {
case 1:
return orcl.analyzer.analyze_final.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return orcl.analyzer.analyze_final.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

orcl.analyzer.analyze_final.cljs$core$IFn$_invoke$arity$1 = (function (ast){
return orcl.analyzer.analyze_final.call(null,ast,cljs.core.PersistentArrayMap.EMPTY);
});

orcl.analyzer.analyze_final.cljs$core$IFn$_invoke$arity$2 = (function (ast,env){
var _STAR_env_STAR_32302 = orcl.analyzer.vars._STAR_env_STAR_;
var _STAR_tail_pos_STAR_32303 = orcl.analyzer._STAR_tail_pos_STAR_;
orcl.analyzer.vars._STAR_env_STAR_ = env;

orcl.analyzer._STAR_tail_pos_STAR_ = null;

try{var ast_SINGLEQUOTE_ = orcl.analyzer.analyze_env.call(null,ast);
return orcl.analyzer.analyze_stage2.call(null,ast_SINGLEQUOTE_);
}finally {orcl.analyzer._STAR_tail_pos_STAR_ = _STAR_tail_pos_STAR_32303;

orcl.analyzer.vars._STAR_env_STAR_ = _STAR_env_STAR_32302;
}});

orcl.analyzer.analyze_final.cljs$lang$maxFixedArity = 2;

orcl.analyzer.analyze = (function orcl$analyzer$analyze(var_args){
var G__32306 = arguments.length;
switch (G__32306) {
case 1:
return orcl.analyzer.analyze.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return orcl.analyzer.analyze.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

orcl.analyzer.analyze.cljs$core$IFn$_invoke$arity$1 = (function (ast){
return orcl.analyzer.analyze_final.call(null,orcl.analyzer.with_sha.call(null,orcl.analyzer.normalize.call(null,ast)));
});

orcl.analyzer.analyze.cljs$core$IFn$_invoke$arity$2 = (function (ast,env){
return orcl.analyzer.analyze_final.call(null,orcl.analyzer.with_sha.call(null,orcl.analyzer.normalize.call(null,ast)),env);
});

orcl.analyzer.analyze.cljs$lang$maxFixedArity = 2;


//# sourceMappingURL=analyzer.js.map?rel=1504016574005
