(ns orcl.naive.lib
  (:require [orcl.naive.impl :as impl]
            [orcl.naive.vars :as vars]
    #?(:clj
            [orcl.naive.macro :as macro :refer [defsite]]))
  #?(:cljs (:require-macros
             [orcl.naive.macro :as macro :refer [defsite]])))

(defsite Let (impl/basic-site (fn [& args]
                                (case (count args)
                                  0 ::impl/signal
                                  1 (first args)
                                  (vec args)))))

(defsite Ift (impl/basic-site (fn [x] (if x ::impl/signal ::impl/halt))))

(defsite Iff (impl/basic-site (fn [x] (if-not x ::impl/signal ::impl/halt))))

(defsite ^{:site "+"} plus (impl/basic-site
                             (fn [a b] (cond
                                         (string? a) (str a b)
                                         (map? a) (merge a b)
                                         :else (+ a b)))))
(defsite ^{:site "-"} minus (impl/basic-site -))
(defsite ^{:site "0-"} negative (impl/basic-site -))
(defsite ^{:site "*"} mult (impl/basic-site *))
(defsite ^{:site "**"} pow (impl/basic-site (fn [base pow] #?(:clj  (Math/pow base pow)
                                                              :cljs (.pow js/Math base pow)))))
(defsite ^{:site "/"} div (impl/basic-site /))
(defsite ^{:site "%"} rem-op (impl/basic-site rem))
(defsite ^{:site "<:"} less (impl/basic-site <))
(defsite ^{:site "<="} less-or-eq (impl/basic-site <=))
(defsite ^{:site ":>"} greater (impl/basic-site >))
(defsite ^{:site ">="} greater-or-eq (impl/basic-site >=))
(defsite ^{:site "="} eq (impl/basic-site =))
(defsite ^{:site "/="} not-eq (impl/basic-site not=))
(defsite ^{:site "~"} not-op (impl/basic-site not))
(defsite ^{:site "&&"} and-op (impl/basic-site (fn [a b] (and a b))))
(defsite ^{:site "||"} or-op (impl/basic-site (fn [a b] (or a b))))
(defsite ^{:site ":"} cons-op (impl/basic-site cons))

;;  All father stuff should be implemented in stdlib

;(defsite abs (sfn [x] (if (< x 0) (- x) x)))
;(defsite signum (sfn [x] (cond
;                           (< x 0) -1
;                           (= x 0) 0
;                           :else 1)))
;(defsite ^{:site "min"} min-op (sfn [a b] (min a b)))
;(defsite ^{:site "max"} max-op (sfn [a b] (max a b)))
(defsite floor (impl/basic-site (fn [x] #?(:clj (long (Math/floor x)) :cljs (.floor js/Math x)))))
(defsite ceil (impl/basic-site (fn [x] #?(:clj (long (Math/ceil x)) :cljs (.ceil js/Math x)))))
(defsite sqrt (impl/basic-site (fn [x] (if (< x 0)
                                         ::impl/halt
                                         #?(:clj (Math/sqrt x) :cljs (.sqrt js/Math x))))))
;(defsite curry (sfn [f] (sfn [x] (fn [y] (f x y)))))
;(defsite curry3 (sfn [f] (sfn [x] (sfn [y] (fn [z] (f x y z))))))
;(defsite uncurry (sfn [f] (fn [x y] ((first (f x)) y))))
;(defsite flip (sfn [f] (fn [x y] (f y x))))
;(defsite constant (sfn [x] (sfn [] x)))
;(defsite ^{:site "defer"} defer-op (sfn [f x] (fn [] (f x))))
;(defsite defer2 (sfn [f x y] (fn [] (f x y))))
;(defsite ignore (sfn [f] (fn [_] (f))))
;(defsite ignore2 (sfn [f] (fn [_ _] (f))))
;(defsite compose (sfn [f g] (fn [x] (f (first (g x))))))
;(defsite ^{:site "while"} while-op
;         (sfn [p f]
;           (fn [x]
;             (loop [[v & tail :as res] (list x)]
;               (let [v1 (first (p v))]
;                 (cond
;                   (= ::impl/pending v1) (conj res ::impl/pending)
;                   v1 (let [v2 (first (f v))]
;                        (if (= ::impl/pending v2)
;                          (reverse (cons ::impl/pending res))
;                          (recur (cons v2 res))))
;                   :else (reverse tail)))))))


(defn coeffect-id []
  #?(:clj  (str (java.util.UUID/randomUUID))
     :cljs (str (random-uuid))))

(defsite Coeffect
         (impl/site
           (fn [ch definition]
             (swap! impl/*coeffects* assoc (coeffect-id) {:definition definition
                                                          :channel    ch}))))

;(defsite Cell
;         (sfn []
;              (macro/with-counter c
;                {"read"  (sfn [] (impl/internal-block c))
;                 "readD" (sfn [] (let [v (get @(:internal vars/*state*) c ::not-found)]
;                                   (if (and (= ::not-found v) (impl/pending? v))
;                                     ::impl/halt
;                                     v)))
;                 "write" (sfn [v]
;                              (let [x (get @(:internal vars/*state*) c ::not-found)]
;                                (if (or (= ::not-found x) (impl/pending? x))
;                                  (do (impl/internal-unblock c v)
;                                      ::impl/signal)
;                                  ::impl/halt)))})))

(defsite Println (impl/basic-site (fn [x] (prn x) ::impl/signal)))
(defsite ^{:site "Error"} error-op (impl/basic-site (fn [x] (prn "Error" x) ::impl/halt)))

(def make-tuple (impl/basic-site (fn [& args] (vec args))))

(def make-list (impl/basic-site (fn [& args] (apply list args))))

(def field-access (impl/basic-site (fn [m k] (get m k))))

(def extract-pattern (impl/basic-site
                       (fn [p v]
                         (if (impl/check-pattern p v)
                           (impl/extract-pattern p v)
                           ::impl/halt))))

(def check-pattern (impl/basic-site
                       (fn [p v]
                         (if (impl/check-pattern p v)
                           v
                           ::impl/halt))))

(defn make-record [keys]
  (impl/basic-site (fn [& vs]
                     (zipmap keys vs))))

(def prelude
  (into {} (for [x (keys @vars/prelude)] [x {:type :site :source {:type :prelude} :definition x}])))