// Compiled by ClojureScript 1.9.908 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('goog.html.legacyconversions');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
goog.require('goog.async.Deferred');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__27989__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__27989__auto__){
return or__27989__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return goog.object.get(goog.dependencies_.nameToPath,ns);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return goog.object.get(goog.dependencies_.written,figwheel.client.file_reloading.name__GT_path.call(null,ns));
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__27989__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["cljs.nodejs",null,"goog",null,"cljs.core",null], null), null).call(null,name);
if(cljs.core.truth_(or__27989__auto__)){
return or__27989__auto__;
} else {
var or__27989__auto____$1 = goog.string.startsWith("clojure.",name);
if(cljs.core.truth_(or__27989__auto____$1)){
return or__27989__auto____$1;
} else {
return goog.string.startsWith("goog.",name);
}
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__40786_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__40786_SHARP_));
}),goog.object.getKeys(goog.object.get(goog.dependencies_.requires,figwheel.client.file_reloading.name__GT_path.call(null,ns)))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name]));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([parent_ns]));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__40787 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__40788 = null;
var count__40789 = (0);
var i__40790 = (0);
while(true){
if((i__40790 < count__40789)){
var n = cljs.core._nth.call(null,chunk__40788,i__40790);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__40791 = seq__40787;
var G__40792 = chunk__40788;
var G__40793 = count__40789;
var G__40794 = (i__40790 + (1));
seq__40787 = G__40791;
chunk__40788 = G__40792;
count__40789 = G__40793;
i__40790 = G__40794;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__40787);
if(temp__4657__auto__){
var seq__40787__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__40787__$1)){
var c__28828__auto__ = cljs.core.chunk_first.call(null,seq__40787__$1);
var G__40795 = cljs.core.chunk_rest.call(null,seq__40787__$1);
var G__40796 = c__28828__auto__;
var G__40797 = cljs.core.count.call(null,c__28828__auto__);
var G__40798 = (0);
seq__40787 = G__40795;
chunk__40788 = G__40796;
count__40789 = G__40797;
i__40790 = G__40798;
continue;
} else {
var n = cljs.core.first.call(null,seq__40787__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__40799 = cljs.core.next.call(null,seq__40787__$1);
var G__40800 = null;
var G__40801 = (0);
var G__40802 = (0);
seq__40787 = G__40799;
chunk__40788 = G__40800;
count__40789 = G__40801;
i__40790 = G__40802;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__40812_40820 = cljs.core.seq.call(null,deps);
var chunk__40813_40821 = null;
var count__40814_40822 = (0);
var i__40815_40823 = (0);
while(true){
if((i__40815_40823 < count__40814_40822)){
var dep_40824 = cljs.core._nth.call(null,chunk__40813_40821,i__40815_40823);
topo_sort_helper_STAR_.call(null,dep_40824,(depth + (1)),state);

var G__40825 = seq__40812_40820;
var G__40826 = chunk__40813_40821;
var G__40827 = count__40814_40822;
var G__40828 = (i__40815_40823 + (1));
seq__40812_40820 = G__40825;
chunk__40813_40821 = G__40826;
count__40814_40822 = G__40827;
i__40815_40823 = G__40828;
continue;
} else {
var temp__4657__auto___40829 = cljs.core.seq.call(null,seq__40812_40820);
if(temp__4657__auto___40829){
var seq__40812_40830__$1 = temp__4657__auto___40829;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__40812_40830__$1)){
var c__28828__auto___40831 = cljs.core.chunk_first.call(null,seq__40812_40830__$1);
var G__40832 = cljs.core.chunk_rest.call(null,seq__40812_40830__$1);
var G__40833 = c__28828__auto___40831;
var G__40834 = cljs.core.count.call(null,c__28828__auto___40831);
var G__40835 = (0);
seq__40812_40820 = G__40832;
chunk__40813_40821 = G__40833;
count__40814_40822 = G__40834;
i__40815_40823 = G__40835;
continue;
} else {
var dep_40836 = cljs.core.first.call(null,seq__40812_40830__$1);
topo_sort_helper_STAR_.call(null,dep_40836,(depth + (1)),state);

var G__40837 = cljs.core.next.call(null,seq__40812_40830__$1);
var G__40838 = null;
var G__40839 = (0);
var G__40840 = (0);
seq__40812_40820 = G__40837;
chunk__40813_40821 = G__40838;
count__40814_40822 = G__40839;
i__40815_40823 = G__40840;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__40816){
var vec__40817 = p__40816;
var seq__40818 = cljs.core.seq.call(null,vec__40817);
var first__40819 = cljs.core.first.call(null,seq__40818);
var seq__40818__$1 = cljs.core.next.call(null,seq__40818);
var x = first__40819;
var xs = seq__40818__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__40817,seq__40818,first__40819,seq__40818__$1,x,xs,get_deps__$1){
return (function (p1__40803_SHARP_){
return clojure.set.difference.call(null,p1__40803_SHARP_,x);
});})(vec__40817,seq__40818,first__40819,seq__40818__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,figwheel.client.file_reloading.immutable_ns_QMARK_),cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss)))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__40841 = cljs.core.seq.call(null,provides);
var chunk__40842 = null;
var count__40843 = (0);
var i__40844 = (0);
while(true){
if((i__40844 < count__40843)){
var prov = cljs.core._nth.call(null,chunk__40842,i__40844);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__40845_40853 = cljs.core.seq.call(null,requires);
var chunk__40846_40854 = null;
var count__40847_40855 = (0);
var i__40848_40856 = (0);
while(true){
if((i__40848_40856 < count__40847_40855)){
var req_40857 = cljs.core._nth.call(null,chunk__40846_40854,i__40848_40856);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_40857,prov);

var G__40858 = seq__40845_40853;
var G__40859 = chunk__40846_40854;
var G__40860 = count__40847_40855;
var G__40861 = (i__40848_40856 + (1));
seq__40845_40853 = G__40858;
chunk__40846_40854 = G__40859;
count__40847_40855 = G__40860;
i__40848_40856 = G__40861;
continue;
} else {
var temp__4657__auto___40862 = cljs.core.seq.call(null,seq__40845_40853);
if(temp__4657__auto___40862){
var seq__40845_40863__$1 = temp__4657__auto___40862;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__40845_40863__$1)){
var c__28828__auto___40864 = cljs.core.chunk_first.call(null,seq__40845_40863__$1);
var G__40865 = cljs.core.chunk_rest.call(null,seq__40845_40863__$1);
var G__40866 = c__28828__auto___40864;
var G__40867 = cljs.core.count.call(null,c__28828__auto___40864);
var G__40868 = (0);
seq__40845_40853 = G__40865;
chunk__40846_40854 = G__40866;
count__40847_40855 = G__40867;
i__40848_40856 = G__40868;
continue;
} else {
var req_40869 = cljs.core.first.call(null,seq__40845_40863__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_40869,prov);

var G__40870 = cljs.core.next.call(null,seq__40845_40863__$1);
var G__40871 = null;
var G__40872 = (0);
var G__40873 = (0);
seq__40845_40853 = G__40870;
chunk__40846_40854 = G__40871;
count__40847_40855 = G__40872;
i__40848_40856 = G__40873;
continue;
}
} else {
}
}
break;
}

var G__40874 = seq__40841;
var G__40875 = chunk__40842;
var G__40876 = count__40843;
var G__40877 = (i__40844 + (1));
seq__40841 = G__40874;
chunk__40842 = G__40875;
count__40843 = G__40876;
i__40844 = G__40877;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__40841);
if(temp__4657__auto__){
var seq__40841__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__40841__$1)){
var c__28828__auto__ = cljs.core.chunk_first.call(null,seq__40841__$1);
var G__40878 = cljs.core.chunk_rest.call(null,seq__40841__$1);
var G__40879 = c__28828__auto__;
var G__40880 = cljs.core.count.call(null,c__28828__auto__);
var G__40881 = (0);
seq__40841 = G__40878;
chunk__40842 = G__40879;
count__40843 = G__40880;
i__40844 = G__40881;
continue;
} else {
var prov = cljs.core.first.call(null,seq__40841__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__40849_40882 = cljs.core.seq.call(null,requires);
var chunk__40850_40883 = null;
var count__40851_40884 = (0);
var i__40852_40885 = (0);
while(true){
if((i__40852_40885 < count__40851_40884)){
var req_40886 = cljs.core._nth.call(null,chunk__40850_40883,i__40852_40885);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_40886,prov);

var G__40887 = seq__40849_40882;
var G__40888 = chunk__40850_40883;
var G__40889 = count__40851_40884;
var G__40890 = (i__40852_40885 + (1));
seq__40849_40882 = G__40887;
chunk__40850_40883 = G__40888;
count__40851_40884 = G__40889;
i__40852_40885 = G__40890;
continue;
} else {
var temp__4657__auto___40891__$1 = cljs.core.seq.call(null,seq__40849_40882);
if(temp__4657__auto___40891__$1){
var seq__40849_40892__$1 = temp__4657__auto___40891__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__40849_40892__$1)){
var c__28828__auto___40893 = cljs.core.chunk_first.call(null,seq__40849_40892__$1);
var G__40894 = cljs.core.chunk_rest.call(null,seq__40849_40892__$1);
var G__40895 = c__28828__auto___40893;
var G__40896 = cljs.core.count.call(null,c__28828__auto___40893);
var G__40897 = (0);
seq__40849_40882 = G__40894;
chunk__40850_40883 = G__40895;
count__40851_40884 = G__40896;
i__40852_40885 = G__40897;
continue;
} else {
var req_40898 = cljs.core.first.call(null,seq__40849_40892__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_40898,prov);

var G__40899 = cljs.core.next.call(null,seq__40849_40892__$1);
var G__40900 = null;
var G__40901 = (0);
var G__40902 = (0);
seq__40849_40882 = G__40899;
chunk__40850_40883 = G__40900;
count__40851_40884 = G__40901;
i__40852_40885 = G__40902;
continue;
}
} else {
}
}
break;
}

var G__40903 = cljs.core.next.call(null,seq__40841__$1);
var G__40904 = null;
var G__40905 = (0);
var G__40906 = (0);
seq__40841 = G__40903;
chunk__40842 = G__40904;
count__40843 = G__40905;
i__40844 = G__40906;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__40907_40911 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__40908_40912 = null;
var count__40909_40913 = (0);
var i__40910_40914 = (0);
while(true){
if((i__40910_40914 < count__40909_40913)){
var ns_40915 = cljs.core._nth.call(null,chunk__40908_40912,i__40910_40914);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_40915);

var G__40916 = seq__40907_40911;
var G__40917 = chunk__40908_40912;
var G__40918 = count__40909_40913;
var G__40919 = (i__40910_40914 + (1));
seq__40907_40911 = G__40916;
chunk__40908_40912 = G__40917;
count__40909_40913 = G__40918;
i__40910_40914 = G__40919;
continue;
} else {
var temp__4657__auto___40920 = cljs.core.seq.call(null,seq__40907_40911);
if(temp__4657__auto___40920){
var seq__40907_40921__$1 = temp__4657__auto___40920;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__40907_40921__$1)){
var c__28828__auto___40922 = cljs.core.chunk_first.call(null,seq__40907_40921__$1);
var G__40923 = cljs.core.chunk_rest.call(null,seq__40907_40921__$1);
var G__40924 = c__28828__auto___40922;
var G__40925 = cljs.core.count.call(null,c__28828__auto___40922);
var G__40926 = (0);
seq__40907_40911 = G__40923;
chunk__40908_40912 = G__40924;
count__40909_40913 = G__40925;
i__40910_40914 = G__40926;
continue;
} else {
var ns_40927 = cljs.core.first.call(null,seq__40907_40921__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_40927);

var G__40928 = cljs.core.next.call(null,seq__40907_40921__$1);
var G__40929 = null;
var G__40930 = (0);
var G__40931 = (0);
seq__40907_40911 = G__40928;
chunk__40908_40912 = G__40929;
count__40909_40913 = G__40930;
i__40910_40914 = G__40931;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__27989__auto__ = goog.require__;
if(cljs.core.truth_(or__27989__auto__)){
return or__27989__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__40932__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__40932 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__40933__i = 0, G__40933__a = new Array(arguments.length -  0);
while (G__40933__i < G__40933__a.length) {G__40933__a[G__40933__i] = arguments[G__40933__i + 0]; ++G__40933__i;}
  args = new cljs.core.IndexedSeq(G__40933__a,0,null);
} 
return G__40932__delegate.call(this,args);};
G__40932.cljs$lang$maxFixedArity = 0;
G__40932.cljs$lang$applyTo = (function (arglist__40934){
var args = cljs.core.seq(arglist__40934);
return G__40932__delegate(args);
});
G__40932.cljs$core$IFn$_invoke$arity$variadic = G__40932__delegate;
return G__40932;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.gloader = ((typeof goog.net.jsloader.safeLoad !== 'undefined')?(function (p1__40935_SHARP_,p2__40936_SHARP_){
return goog.net.jsloader.safeLoad(goog.html.legacyconversions.trustedResourceUrlFromString([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__40935_SHARP_)].join('')),p2__40936_SHARP_);
}):((typeof goog.net.jsloader.load !== 'undefined')?(function (p1__40937_SHARP_,p2__40938_SHARP_){
return goog.net.jsloader.load([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__40937_SHARP_)].join(''),p2__40938_SHARP_);
}):(function(){throw cljs.core.ex_info.call(null,"No remote script loading function found.",cljs.core.PersistentArrayMap.EMPTY)})()
));
figwheel.client.file_reloading.reload_file_in_html_env = (function figwheel$client$file_reloading$reload_file_in_html_env(request_url,callback){

var G__40939 = figwheel.client.file_reloading.gloader.call(null,figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
G__40939.addCallback(((function (G__40939){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(G__40939))
);

G__40939.addErrback(((function (G__40939){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(G__40939))
);

return G__40939;
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__40940 = cljs.core._EQ_;
var expr__40941 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__40940.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__40941))){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,((function (node_path_lib,util_pattern,pred__40940,expr__40941){
return (function (v,k,o){
return goog.string.endsWith(k,util_pattern);
});})(node_path_lib,util_pattern,pred__40940,expr__40941))
);
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return ((function (node_path_lib,util_pattern,util_path,parts,root_path,pred__40940,expr__40941){
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e40943){if((e40943 instanceof Error)){
var e = e40943;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e40943;

}
}})());
});
;})(node_path_lib,util_pattern,util_path,parts,root_path,pred__40940,expr__40941))
} else {
if(cljs.core.truth_(pred__40940.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__40941))){
return figwheel.client.file_reloading.reload_file_in_html_env;
} else {
if(cljs.core.truth_(pred__40940.call(null,new cljs.core.Keyword(null,"react-native","react-native",-1543085138),expr__40941))){
return figwheel.client.file_reloading.reload_file_in_html_env;
} else {
if(cljs.core.truth_(pred__40940.call(null,new cljs.core.Keyword(null,"worker","worker",938239996),expr__40941))){
return ((function (pred__40940,expr__40941){
return (function (request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e40944){if((e40944 instanceof Error)){
var e = e40944;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e40944;

}
}})());
});
;})(pred__40940,expr__40941))
} else {
return ((function (pred__40940,expr__40941){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__40940,expr__40941))
}
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__40945,callback){
var map__40946 = p__40945;
var map__40946__$1 = ((((!((map__40946 == null)))?((((map__40946.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40946.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__40946):map__40946);
var file_msg = map__40946__$1;
var request_url = cljs.core.get.call(null,map__40946__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,["FigWheel: Attempting to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__40946,map__40946__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,["FigWheel: Successfully loaded ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__40946,map__40946__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__38817__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38817__auto__){
return (function (){
var f__38818__auto__ = (function (){var switch__38764__auto__ = ((function (c__38817__auto__){
return (function (state_40970){
var state_val_40971 = (state_40970[(1)]);
if((state_val_40971 === (7))){
var inst_40966 = (state_40970[(2)]);
var state_40970__$1 = state_40970;
var statearr_40972_40989 = state_40970__$1;
(statearr_40972_40989[(2)] = inst_40966);

(statearr_40972_40989[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40971 === (1))){
var state_40970__$1 = state_40970;
var statearr_40973_40990 = state_40970__$1;
(statearr_40973_40990[(2)] = null);

(statearr_40973_40990[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40971 === (4))){
var inst_40950 = (state_40970[(7)]);
var inst_40950__$1 = (state_40970[(2)]);
var state_40970__$1 = (function (){var statearr_40974 = state_40970;
(statearr_40974[(7)] = inst_40950__$1);

return statearr_40974;
})();
if(cljs.core.truth_(inst_40950__$1)){
var statearr_40975_40991 = state_40970__$1;
(statearr_40975_40991[(1)] = (5));

} else {
var statearr_40976_40992 = state_40970__$1;
(statearr_40976_40992[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40971 === (6))){
var state_40970__$1 = state_40970;
var statearr_40977_40993 = state_40970__$1;
(statearr_40977_40993[(2)] = null);

(statearr_40977_40993[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40971 === (3))){
var inst_40968 = (state_40970[(2)]);
var state_40970__$1 = state_40970;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40970__$1,inst_40968);
} else {
if((state_val_40971 === (2))){
var state_40970__$1 = state_40970;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40970__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_40971 === (11))){
var inst_40962 = (state_40970[(2)]);
var state_40970__$1 = (function (){var statearr_40978 = state_40970;
(statearr_40978[(8)] = inst_40962);

return statearr_40978;
})();
var statearr_40979_40994 = state_40970__$1;
(statearr_40979_40994[(2)] = null);

(statearr_40979_40994[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40971 === (9))){
var inst_40956 = (state_40970[(9)]);
var inst_40954 = (state_40970[(10)]);
var inst_40958 = inst_40956.call(null,inst_40954);
var state_40970__$1 = state_40970;
var statearr_40980_40995 = state_40970__$1;
(statearr_40980_40995[(2)] = inst_40958);

(statearr_40980_40995[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40971 === (5))){
var inst_40950 = (state_40970[(7)]);
var inst_40952 = figwheel.client.file_reloading.blocking_load.call(null,inst_40950);
var state_40970__$1 = state_40970;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40970__$1,(8),inst_40952);
} else {
if((state_val_40971 === (10))){
var inst_40954 = (state_40970[(10)]);
var inst_40960 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_40954);
var state_40970__$1 = state_40970;
var statearr_40981_40996 = state_40970__$1;
(statearr_40981_40996[(2)] = inst_40960);

(statearr_40981_40996[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40971 === (8))){
var inst_40950 = (state_40970[(7)]);
var inst_40956 = (state_40970[(9)]);
var inst_40954 = (state_40970[(2)]);
var inst_40955 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_40956__$1 = cljs.core.get.call(null,inst_40955,inst_40950);
var state_40970__$1 = (function (){var statearr_40982 = state_40970;
(statearr_40982[(9)] = inst_40956__$1);

(statearr_40982[(10)] = inst_40954);

return statearr_40982;
})();
if(cljs.core.truth_(inst_40956__$1)){
var statearr_40983_40997 = state_40970__$1;
(statearr_40983_40997[(1)] = (9));

} else {
var statearr_40984_40998 = state_40970__$1;
(statearr_40984_40998[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__38817__auto__))
;
return ((function (switch__38764__auto__,c__38817__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__38765__auto__ = null;
var figwheel$client$file_reloading$state_machine__38765__auto____0 = (function (){
var statearr_40985 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_40985[(0)] = figwheel$client$file_reloading$state_machine__38765__auto__);

(statearr_40985[(1)] = (1));

return statearr_40985;
});
var figwheel$client$file_reloading$state_machine__38765__auto____1 = (function (state_40970){
while(true){
var ret_value__38766__auto__ = (function (){try{while(true){
var result__38767__auto__ = switch__38764__auto__.call(null,state_40970);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38767__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38767__auto__;
}
break;
}
}catch (e40986){if((e40986 instanceof Object)){
var ex__38768__auto__ = e40986;
var statearr_40987_40999 = state_40970;
(statearr_40987_40999[(5)] = ex__38768__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40970);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40986;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38766__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41000 = state_40970;
state_40970 = G__41000;
continue;
} else {
return ret_value__38766__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__38765__auto__ = function(state_40970){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__38765__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__38765__auto____1.call(this,state_40970);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__38765__auto____0;
figwheel$client$file_reloading$state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__38765__auto____1;
return figwheel$client$file_reloading$state_machine__38765__auto__;
})()
;})(switch__38764__auto__,c__38817__auto__))
})();
var state__38819__auto__ = (function (){var statearr_40988 = f__38818__auto__.call(null);
(statearr_40988[(6)] = c__38817__auto__);

return statearr_40988;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38819__auto__);
});})(c__38817__auto__))
);

return c__38817__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__41001,callback){
var map__41002 = p__41001;
var map__41002__$1 = ((((!((map__41002 == null)))?((((map__41002.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41002.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41002):map__41002);
var file_msg = map__41002__$1;
var namespace = cljs.core.get.call(null,map__41002__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__41002,map__41002__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__41002,map__41002__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__41004){
var map__41005 = p__41004;
var map__41005__$1 = ((((!((map__41005 == null)))?((((map__41005.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41005.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41005):map__41005);
var file_msg = map__41005__$1;
var namespace = cljs.core.get.call(null,map__41005__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__41007){
var map__41008 = p__41007;
var map__41008__$1 = ((((!((map__41008 == null)))?((((map__41008.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41008.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41008):map__41008);
var file_msg = map__41008__$1;
var namespace = cljs.core.get.call(null,map__41008__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__27977__auto__ = cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg));
if(and__27977__auto__){
var or__27989__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__27989__auto__)){
return or__27989__auto__;
} else {
var or__27989__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__27989__auto____$1)){
return or__27989__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__27977__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__41010,callback){
var map__41011 = p__41010;
var map__41011__$1 = ((((!((map__41011 == null)))?((((map__41011.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41011.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41011):map__41011);
var file_msg = map__41011__$1;
var request_url = cljs.core.get.call(null,map__41011__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__41011__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,["Figwheel: Not trying to load file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__38817__auto___41061 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38817__auto___41061,out){
return (function (){
var f__38818__auto__ = (function (){var switch__38764__auto__ = ((function (c__38817__auto___41061,out){
return (function (state_41046){
var state_val_41047 = (state_41046[(1)]);
if((state_val_41047 === (1))){
var inst_41020 = cljs.core.seq.call(null,files);
var inst_41021 = cljs.core.first.call(null,inst_41020);
var inst_41022 = cljs.core.next.call(null,inst_41020);
var inst_41023 = files;
var state_41046__$1 = (function (){var statearr_41048 = state_41046;
(statearr_41048[(7)] = inst_41021);

(statearr_41048[(8)] = inst_41023);

(statearr_41048[(9)] = inst_41022);

return statearr_41048;
})();
var statearr_41049_41062 = state_41046__$1;
(statearr_41049_41062[(2)] = null);

(statearr_41049_41062[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41047 === (2))){
var inst_41029 = (state_41046[(10)]);
var inst_41023 = (state_41046[(8)]);
var inst_41028 = cljs.core.seq.call(null,inst_41023);
var inst_41029__$1 = cljs.core.first.call(null,inst_41028);
var inst_41030 = cljs.core.next.call(null,inst_41028);
var inst_41031 = (inst_41029__$1 == null);
var inst_41032 = cljs.core.not.call(null,inst_41031);
var state_41046__$1 = (function (){var statearr_41050 = state_41046;
(statearr_41050[(11)] = inst_41030);

(statearr_41050[(10)] = inst_41029__$1);

return statearr_41050;
})();
if(inst_41032){
var statearr_41051_41063 = state_41046__$1;
(statearr_41051_41063[(1)] = (4));

} else {
var statearr_41052_41064 = state_41046__$1;
(statearr_41052_41064[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41047 === (3))){
var inst_41044 = (state_41046[(2)]);
var state_41046__$1 = state_41046;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_41046__$1,inst_41044);
} else {
if((state_val_41047 === (4))){
var inst_41029 = (state_41046[(10)]);
var inst_41034 = figwheel.client.file_reloading.reload_js_file.call(null,inst_41029);
var state_41046__$1 = state_41046;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41046__$1,(7),inst_41034);
} else {
if((state_val_41047 === (5))){
var inst_41040 = cljs.core.async.close_BANG_.call(null,out);
var state_41046__$1 = state_41046;
var statearr_41053_41065 = state_41046__$1;
(statearr_41053_41065[(2)] = inst_41040);

(statearr_41053_41065[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41047 === (6))){
var inst_41042 = (state_41046[(2)]);
var state_41046__$1 = state_41046;
var statearr_41054_41066 = state_41046__$1;
(statearr_41054_41066[(2)] = inst_41042);

(statearr_41054_41066[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41047 === (7))){
var inst_41030 = (state_41046[(11)]);
var inst_41036 = (state_41046[(2)]);
var inst_41037 = cljs.core.async.put_BANG_.call(null,out,inst_41036);
var inst_41023 = inst_41030;
var state_41046__$1 = (function (){var statearr_41055 = state_41046;
(statearr_41055[(12)] = inst_41037);

(statearr_41055[(8)] = inst_41023);

return statearr_41055;
})();
var statearr_41056_41067 = state_41046__$1;
(statearr_41056_41067[(2)] = null);

(statearr_41056_41067[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__38817__auto___41061,out))
;
return ((function (switch__38764__auto__,c__38817__auto___41061,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__38765__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__38765__auto____0 = (function (){
var statearr_41057 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41057[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__38765__auto__);

(statearr_41057[(1)] = (1));

return statearr_41057;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__38765__auto____1 = (function (state_41046){
while(true){
var ret_value__38766__auto__ = (function (){try{while(true){
var result__38767__auto__ = switch__38764__auto__.call(null,state_41046);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38767__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38767__auto__;
}
break;
}
}catch (e41058){if((e41058 instanceof Object)){
var ex__38768__auto__ = e41058;
var statearr_41059_41068 = state_41046;
(statearr_41059_41068[(5)] = ex__38768__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_41046);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e41058;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38766__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41069 = state_41046;
state_41046 = G__41069;
continue;
} else {
return ret_value__38766__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__38765__auto__ = function(state_41046){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__38765__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__38765__auto____1.call(this,state_41046);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__38765__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__38765__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__38765__auto__;
})()
;})(switch__38764__auto__,c__38817__auto___41061,out))
})();
var state__38819__auto__ = (function (){var statearr_41060 = f__38818__auto__.call(null);
(statearr_41060[(6)] = c__38817__auto___41061);

return statearr_41060;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38819__auto__);
});})(c__38817__auto___41061,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__41070,opts){
var map__41071 = p__41070;
var map__41071__$1 = ((((!((map__41071 == null)))?((((map__41071.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41071.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41071):map__41071);
var eval_body = cljs.core.get.call(null,map__41071__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__41071__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__27977__auto__ = eval_body;
if(cljs.core.truth_(and__27977__auto__)){
return typeof eval_body === 'string';
} else {
return and__27977__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,["Evaling file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e41073){var e = e41073;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Unable to evaluate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4655__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__41074_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__41074_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4655__auto__)){
var file_msg = temp__4655__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__41075){
var vec__41076 = p__41075;
var k = cljs.core.nth.call(null,vec__41076,(0),null);
var v = cljs.core.nth.call(null,vec__41076,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__41079){
var vec__41080 = p__41079;
var k = cljs.core.nth.call(null,vec__41080,(0),null);
var v = cljs.core.nth.call(null,vec__41080,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__41086,p__41087){
var map__41088 = p__41086;
var map__41088__$1 = ((((!((map__41088 == null)))?((((map__41088.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41088.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41088):map__41088);
var opts = map__41088__$1;
var before_jsload = cljs.core.get.call(null,map__41088__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__41088__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__41088__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__41089 = p__41087;
var map__41089__$1 = ((((!((map__41089 == null)))?((((map__41089.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41089.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41089):map__41089);
var msg = map__41089__$1;
var files = cljs.core.get.call(null,map__41089__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__41089__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__41089__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__38817__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38817__auto__,map__41088,map__41088__$1,opts,before_jsload,on_jsload,reload_dependents,map__41089,map__41089__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__38818__auto__ = (function (){var switch__38764__auto__ = ((function (c__38817__auto__,map__41088,map__41088__$1,opts,before_jsload,on_jsload,reload_dependents,map__41089,map__41089__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_41243){
var state_val_41244 = (state_41243[(1)]);
if((state_val_41244 === (7))){
var inst_41104 = (state_41243[(7)]);
var inst_41103 = (state_41243[(8)]);
var inst_41105 = (state_41243[(9)]);
var inst_41106 = (state_41243[(10)]);
var inst_41111 = cljs.core._nth.call(null,inst_41104,inst_41106);
var inst_41112 = figwheel.client.file_reloading.eval_body.call(null,inst_41111,opts);
var inst_41113 = (inst_41106 + (1));
var tmp41245 = inst_41104;
var tmp41246 = inst_41103;
var tmp41247 = inst_41105;
var inst_41103__$1 = tmp41246;
var inst_41104__$1 = tmp41245;
var inst_41105__$1 = tmp41247;
var inst_41106__$1 = inst_41113;
var state_41243__$1 = (function (){var statearr_41248 = state_41243;
(statearr_41248[(7)] = inst_41104__$1);

(statearr_41248[(8)] = inst_41103__$1);

(statearr_41248[(9)] = inst_41105__$1);

(statearr_41248[(10)] = inst_41106__$1);

(statearr_41248[(11)] = inst_41112);

return statearr_41248;
})();
var statearr_41249_41332 = state_41243__$1;
(statearr_41249_41332[(2)] = null);

(statearr_41249_41332[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (20))){
var inst_41146 = (state_41243[(12)]);
var inst_41154 = figwheel.client.file_reloading.sort_files.call(null,inst_41146);
var state_41243__$1 = state_41243;
var statearr_41250_41333 = state_41243__$1;
(statearr_41250_41333[(2)] = inst_41154);

(statearr_41250_41333[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (27))){
var state_41243__$1 = state_41243;
var statearr_41251_41334 = state_41243__$1;
(statearr_41251_41334[(2)] = null);

(statearr_41251_41334[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (1))){
var inst_41095 = (state_41243[(13)]);
var inst_41092 = before_jsload.call(null,files);
var inst_41093 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_41094 = (function (){return ((function (inst_41095,inst_41092,inst_41093,state_val_41244,c__38817__auto__,map__41088,map__41088__$1,opts,before_jsload,on_jsload,reload_dependents,map__41089,map__41089__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__41083_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__41083_SHARP_);
});
;})(inst_41095,inst_41092,inst_41093,state_val_41244,c__38817__auto__,map__41088,map__41088__$1,opts,before_jsload,on_jsload,reload_dependents,map__41089,map__41089__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_41095__$1 = cljs.core.filter.call(null,inst_41094,files);
var inst_41096 = cljs.core.not_empty.call(null,inst_41095__$1);
var state_41243__$1 = (function (){var statearr_41252 = state_41243;
(statearr_41252[(14)] = inst_41093);

(statearr_41252[(15)] = inst_41092);

(statearr_41252[(13)] = inst_41095__$1);

return statearr_41252;
})();
if(cljs.core.truth_(inst_41096)){
var statearr_41253_41335 = state_41243__$1;
(statearr_41253_41335[(1)] = (2));

} else {
var statearr_41254_41336 = state_41243__$1;
(statearr_41254_41336[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (24))){
var state_41243__$1 = state_41243;
var statearr_41255_41337 = state_41243__$1;
(statearr_41255_41337[(2)] = null);

(statearr_41255_41337[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (39))){
var inst_41196 = (state_41243[(16)]);
var state_41243__$1 = state_41243;
var statearr_41256_41338 = state_41243__$1;
(statearr_41256_41338[(2)] = inst_41196);

(statearr_41256_41338[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (46))){
var inst_41238 = (state_41243[(2)]);
var state_41243__$1 = state_41243;
var statearr_41257_41339 = state_41243__$1;
(statearr_41257_41339[(2)] = inst_41238);

(statearr_41257_41339[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (4))){
var inst_41140 = (state_41243[(2)]);
var inst_41141 = cljs.core.List.EMPTY;
var inst_41142 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_41141);
var inst_41143 = (function (){return ((function (inst_41140,inst_41141,inst_41142,state_val_41244,c__38817__auto__,map__41088,map__41088__$1,opts,before_jsload,on_jsload,reload_dependents,map__41089,map__41089__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__41084_SHARP_){
var and__27977__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__41084_SHARP_);
if(cljs.core.truth_(and__27977__auto__)){
return (cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__41084_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__41084_SHARP_)));
} else {
return and__27977__auto__;
}
});
;})(inst_41140,inst_41141,inst_41142,state_val_41244,c__38817__auto__,map__41088,map__41088__$1,opts,before_jsload,on_jsload,reload_dependents,map__41089,map__41089__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_41144 = cljs.core.filter.call(null,inst_41143,files);
var inst_41145 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_41146 = cljs.core.concat.call(null,inst_41144,inst_41145);
var state_41243__$1 = (function (){var statearr_41258 = state_41243;
(statearr_41258[(17)] = inst_41142);

(statearr_41258[(18)] = inst_41140);

(statearr_41258[(12)] = inst_41146);

return statearr_41258;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_41259_41340 = state_41243__$1;
(statearr_41259_41340[(1)] = (16));

} else {
var statearr_41260_41341 = state_41243__$1;
(statearr_41260_41341[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (15))){
var inst_41130 = (state_41243[(2)]);
var state_41243__$1 = state_41243;
var statearr_41261_41342 = state_41243__$1;
(statearr_41261_41342[(2)] = inst_41130);

(statearr_41261_41342[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (21))){
var inst_41156 = (state_41243[(19)]);
var inst_41156__$1 = (state_41243[(2)]);
var inst_41157 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_41156__$1);
var state_41243__$1 = (function (){var statearr_41262 = state_41243;
(statearr_41262[(19)] = inst_41156__$1);

return statearr_41262;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41243__$1,(22),inst_41157);
} else {
if((state_val_41244 === (31))){
var inst_41241 = (state_41243[(2)]);
var state_41243__$1 = state_41243;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_41243__$1,inst_41241);
} else {
if((state_val_41244 === (32))){
var inst_41196 = (state_41243[(16)]);
var inst_41201 = inst_41196.cljs$lang$protocol_mask$partition0$;
var inst_41202 = (inst_41201 & (64));
var inst_41203 = inst_41196.cljs$core$ISeq$;
var inst_41204 = (cljs.core.PROTOCOL_SENTINEL === inst_41203);
var inst_41205 = (inst_41202) || (inst_41204);
var state_41243__$1 = state_41243;
if(cljs.core.truth_(inst_41205)){
var statearr_41263_41343 = state_41243__$1;
(statearr_41263_41343[(1)] = (35));

} else {
var statearr_41264_41344 = state_41243__$1;
(statearr_41264_41344[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (40))){
var inst_41218 = (state_41243[(20)]);
var inst_41217 = (state_41243[(2)]);
var inst_41218__$1 = cljs.core.get.call(null,inst_41217,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_41219 = cljs.core.get.call(null,inst_41217,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_41220 = cljs.core.not_empty.call(null,inst_41218__$1);
var state_41243__$1 = (function (){var statearr_41265 = state_41243;
(statearr_41265[(21)] = inst_41219);

(statearr_41265[(20)] = inst_41218__$1);

return statearr_41265;
})();
if(cljs.core.truth_(inst_41220)){
var statearr_41266_41345 = state_41243__$1;
(statearr_41266_41345[(1)] = (41));

} else {
var statearr_41267_41346 = state_41243__$1;
(statearr_41267_41346[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (33))){
var state_41243__$1 = state_41243;
var statearr_41268_41347 = state_41243__$1;
(statearr_41268_41347[(2)] = false);

(statearr_41268_41347[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (13))){
var inst_41116 = (state_41243[(22)]);
var inst_41120 = cljs.core.chunk_first.call(null,inst_41116);
var inst_41121 = cljs.core.chunk_rest.call(null,inst_41116);
var inst_41122 = cljs.core.count.call(null,inst_41120);
var inst_41103 = inst_41121;
var inst_41104 = inst_41120;
var inst_41105 = inst_41122;
var inst_41106 = (0);
var state_41243__$1 = (function (){var statearr_41269 = state_41243;
(statearr_41269[(7)] = inst_41104);

(statearr_41269[(8)] = inst_41103);

(statearr_41269[(9)] = inst_41105);

(statearr_41269[(10)] = inst_41106);

return statearr_41269;
})();
var statearr_41270_41348 = state_41243__$1;
(statearr_41270_41348[(2)] = null);

(statearr_41270_41348[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (22))){
var inst_41156 = (state_41243[(19)]);
var inst_41160 = (state_41243[(23)]);
var inst_41159 = (state_41243[(24)]);
var inst_41164 = (state_41243[(25)]);
var inst_41159__$1 = (state_41243[(2)]);
var inst_41160__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_41159__$1);
var inst_41161 = (function (){var all_files = inst_41156;
var res_SINGLEQUOTE_ = inst_41159__$1;
var res = inst_41160__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_41156,inst_41160,inst_41159,inst_41164,inst_41159__$1,inst_41160__$1,state_val_41244,c__38817__auto__,map__41088,map__41088__$1,opts,before_jsload,on_jsload,reload_dependents,map__41089,map__41089__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__41085_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__41085_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_41156,inst_41160,inst_41159,inst_41164,inst_41159__$1,inst_41160__$1,state_val_41244,c__38817__auto__,map__41088,map__41088__$1,opts,before_jsload,on_jsload,reload_dependents,map__41089,map__41089__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_41162 = cljs.core.filter.call(null,inst_41161,inst_41159__$1);
var inst_41163 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_41164__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_41163);
var inst_41165 = cljs.core.not_empty.call(null,inst_41164__$1);
var state_41243__$1 = (function (){var statearr_41271 = state_41243;
(statearr_41271[(26)] = inst_41162);

(statearr_41271[(23)] = inst_41160__$1);

(statearr_41271[(24)] = inst_41159__$1);

(statearr_41271[(25)] = inst_41164__$1);

return statearr_41271;
})();
if(cljs.core.truth_(inst_41165)){
var statearr_41272_41349 = state_41243__$1;
(statearr_41272_41349[(1)] = (23));

} else {
var statearr_41273_41350 = state_41243__$1;
(statearr_41273_41350[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (36))){
var state_41243__$1 = state_41243;
var statearr_41274_41351 = state_41243__$1;
(statearr_41274_41351[(2)] = false);

(statearr_41274_41351[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (41))){
var inst_41218 = (state_41243[(20)]);
var inst_41222 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_41223 = cljs.core.map.call(null,inst_41222,inst_41218);
var inst_41224 = cljs.core.pr_str.call(null,inst_41223);
var inst_41225 = ["figwheel-no-load meta-data: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_41224)].join('');
var inst_41226 = figwheel.client.utils.log.call(null,inst_41225);
var state_41243__$1 = state_41243;
var statearr_41275_41352 = state_41243__$1;
(statearr_41275_41352[(2)] = inst_41226);

(statearr_41275_41352[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (43))){
var inst_41219 = (state_41243[(21)]);
var inst_41229 = (state_41243[(2)]);
var inst_41230 = cljs.core.not_empty.call(null,inst_41219);
var state_41243__$1 = (function (){var statearr_41276 = state_41243;
(statearr_41276[(27)] = inst_41229);

return statearr_41276;
})();
if(cljs.core.truth_(inst_41230)){
var statearr_41277_41353 = state_41243__$1;
(statearr_41277_41353[(1)] = (44));

} else {
var statearr_41278_41354 = state_41243__$1;
(statearr_41278_41354[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (29))){
var inst_41156 = (state_41243[(19)]);
var inst_41196 = (state_41243[(16)]);
var inst_41162 = (state_41243[(26)]);
var inst_41160 = (state_41243[(23)]);
var inst_41159 = (state_41243[(24)]);
var inst_41164 = (state_41243[(25)]);
var inst_41192 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_41195 = (function (){var all_files = inst_41156;
var res_SINGLEQUOTE_ = inst_41159;
var res = inst_41160;
var files_not_loaded = inst_41162;
var dependencies_that_loaded = inst_41164;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_41156,inst_41196,inst_41162,inst_41160,inst_41159,inst_41164,inst_41192,state_val_41244,c__38817__auto__,map__41088,map__41088__$1,opts,before_jsload,on_jsload,reload_dependents,map__41089,map__41089__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__41194){
var map__41279 = p__41194;
var map__41279__$1 = ((((!((map__41279 == null)))?((((map__41279.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41279.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41279):map__41279);
var namespace = cljs.core.get.call(null,map__41279__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_41156,inst_41196,inst_41162,inst_41160,inst_41159,inst_41164,inst_41192,state_val_41244,c__38817__auto__,map__41088,map__41088__$1,opts,before_jsload,on_jsload,reload_dependents,map__41089,map__41089__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_41196__$1 = cljs.core.group_by.call(null,inst_41195,inst_41162);
var inst_41198 = (inst_41196__$1 == null);
var inst_41199 = cljs.core.not.call(null,inst_41198);
var state_41243__$1 = (function (){var statearr_41281 = state_41243;
(statearr_41281[(16)] = inst_41196__$1);

(statearr_41281[(28)] = inst_41192);

return statearr_41281;
})();
if(inst_41199){
var statearr_41282_41355 = state_41243__$1;
(statearr_41282_41355[(1)] = (32));

} else {
var statearr_41283_41356 = state_41243__$1;
(statearr_41283_41356[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (44))){
var inst_41219 = (state_41243[(21)]);
var inst_41232 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_41219);
var inst_41233 = cljs.core.pr_str.call(null,inst_41232);
var inst_41234 = ["not required: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_41233)].join('');
var inst_41235 = figwheel.client.utils.log.call(null,inst_41234);
var state_41243__$1 = state_41243;
var statearr_41284_41357 = state_41243__$1;
(statearr_41284_41357[(2)] = inst_41235);

(statearr_41284_41357[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (6))){
var inst_41137 = (state_41243[(2)]);
var state_41243__$1 = state_41243;
var statearr_41285_41358 = state_41243__$1;
(statearr_41285_41358[(2)] = inst_41137);

(statearr_41285_41358[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (28))){
var inst_41162 = (state_41243[(26)]);
var inst_41189 = (state_41243[(2)]);
var inst_41190 = cljs.core.not_empty.call(null,inst_41162);
var state_41243__$1 = (function (){var statearr_41286 = state_41243;
(statearr_41286[(29)] = inst_41189);

return statearr_41286;
})();
if(cljs.core.truth_(inst_41190)){
var statearr_41287_41359 = state_41243__$1;
(statearr_41287_41359[(1)] = (29));

} else {
var statearr_41288_41360 = state_41243__$1;
(statearr_41288_41360[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (25))){
var inst_41160 = (state_41243[(23)]);
var inst_41176 = (state_41243[(2)]);
var inst_41177 = cljs.core.not_empty.call(null,inst_41160);
var state_41243__$1 = (function (){var statearr_41289 = state_41243;
(statearr_41289[(30)] = inst_41176);

return statearr_41289;
})();
if(cljs.core.truth_(inst_41177)){
var statearr_41290_41361 = state_41243__$1;
(statearr_41290_41361[(1)] = (26));

} else {
var statearr_41291_41362 = state_41243__$1;
(statearr_41291_41362[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (34))){
var inst_41212 = (state_41243[(2)]);
var state_41243__$1 = state_41243;
if(cljs.core.truth_(inst_41212)){
var statearr_41292_41363 = state_41243__$1;
(statearr_41292_41363[(1)] = (38));

} else {
var statearr_41293_41364 = state_41243__$1;
(statearr_41293_41364[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (17))){
var state_41243__$1 = state_41243;
var statearr_41294_41365 = state_41243__$1;
(statearr_41294_41365[(2)] = recompile_dependents);

(statearr_41294_41365[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (3))){
var state_41243__$1 = state_41243;
var statearr_41295_41366 = state_41243__$1;
(statearr_41295_41366[(2)] = null);

(statearr_41295_41366[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (12))){
var inst_41133 = (state_41243[(2)]);
var state_41243__$1 = state_41243;
var statearr_41296_41367 = state_41243__$1;
(statearr_41296_41367[(2)] = inst_41133);

(statearr_41296_41367[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (2))){
var inst_41095 = (state_41243[(13)]);
var inst_41102 = cljs.core.seq.call(null,inst_41095);
var inst_41103 = inst_41102;
var inst_41104 = null;
var inst_41105 = (0);
var inst_41106 = (0);
var state_41243__$1 = (function (){var statearr_41297 = state_41243;
(statearr_41297[(7)] = inst_41104);

(statearr_41297[(8)] = inst_41103);

(statearr_41297[(9)] = inst_41105);

(statearr_41297[(10)] = inst_41106);

return statearr_41297;
})();
var statearr_41298_41368 = state_41243__$1;
(statearr_41298_41368[(2)] = null);

(statearr_41298_41368[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (23))){
var inst_41156 = (state_41243[(19)]);
var inst_41162 = (state_41243[(26)]);
var inst_41160 = (state_41243[(23)]);
var inst_41159 = (state_41243[(24)]);
var inst_41164 = (state_41243[(25)]);
var inst_41167 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_41169 = (function (){var all_files = inst_41156;
var res_SINGLEQUOTE_ = inst_41159;
var res = inst_41160;
var files_not_loaded = inst_41162;
var dependencies_that_loaded = inst_41164;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_41156,inst_41162,inst_41160,inst_41159,inst_41164,inst_41167,state_val_41244,c__38817__auto__,map__41088,map__41088__$1,opts,before_jsload,on_jsload,reload_dependents,map__41089,map__41089__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__41168){
var map__41299 = p__41168;
var map__41299__$1 = ((((!((map__41299 == null)))?((((map__41299.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41299.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41299):map__41299);
var request_url = cljs.core.get.call(null,map__41299__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_41156,inst_41162,inst_41160,inst_41159,inst_41164,inst_41167,state_val_41244,c__38817__auto__,map__41088,map__41088__$1,opts,before_jsload,on_jsload,reload_dependents,map__41089,map__41089__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_41170 = cljs.core.reverse.call(null,inst_41164);
var inst_41171 = cljs.core.map.call(null,inst_41169,inst_41170);
var inst_41172 = cljs.core.pr_str.call(null,inst_41171);
var inst_41173 = figwheel.client.utils.log.call(null,inst_41172);
var state_41243__$1 = (function (){var statearr_41301 = state_41243;
(statearr_41301[(31)] = inst_41167);

return statearr_41301;
})();
var statearr_41302_41369 = state_41243__$1;
(statearr_41302_41369[(2)] = inst_41173);

(statearr_41302_41369[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (35))){
var state_41243__$1 = state_41243;
var statearr_41303_41370 = state_41243__$1;
(statearr_41303_41370[(2)] = true);

(statearr_41303_41370[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (19))){
var inst_41146 = (state_41243[(12)]);
var inst_41152 = figwheel.client.file_reloading.expand_files.call(null,inst_41146);
var state_41243__$1 = state_41243;
var statearr_41304_41371 = state_41243__$1;
(statearr_41304_41371[(2)] = inst_41152);

(statearr_41304_41371[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (11))){
var state_41243__$1 = state_41243;
var statearr_41305_41372 = state_41243__$1;
(statearr_41305_41372[(2)] = null);

(statearr_41305_41372[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (9))){
var inst_41135 = (state_41243[(2)]);
var state_41243__$1 = state_41243;
var statearr_41306_41373 = state_41243__$1;
(statearr_41306_41373[(2)] = inst_41135);

(statearr_41306_41373[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (5))){
var inst_41105 = (state_41243[(9)]);
var inst_41106 = (state_41243[(10)]);
var inst_41108 = (inst_41106 < inst_41105);
var inst_41109 = inst_41108;
var state_41243__$1 = state_41243;
if(cljs.core.truth_(inst_41109)){
var statearr_41307_41374 = state_41243__$1;
(statearr_41307_41374[(1)] = (7));

} else {
var statearr_41308_41375 = state_41243__$1;
(statearr_41308_41375[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (14))){
var inst_41116 = (state_41243[(22)]);
var inst_41125 = cljs.core.first.call(null,inst_41116);
var inst_41126 = figwheel.client.file_reloading.eval_body.call(null,inst_41125,opts);
var inst_41127 = cljs.core.next.call(null,inst_41116);
var inst_41103 = inst_41127;
var inst_41104 = null;
var inst_41105 = (0);
var inst_41106 = (0);
var state_41243__$1 = (function (){var statearr_41309 = state_41243;
(statearr_41309[(7)] = inst_41104);

(statearr_41309[(8)] = inst_41103);

(statearr_41309[(9)] = inst_41105);

(statearr_41309[(10)] = inst_41106);

(statearr_41309[(32)] = inst_41126);

return statearr_41309;
})();
var statearr_41310_41376 = state_41243__$1;
(statearr_41310_41376[(2)] = null);

(statearr_41310_41376[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (45))){
var state_41243__$1 = state_41243;
var statearr_41311_41377 = state_41243__$1;
(statearr_41311_41377[(2)] = null);

(statearr_41311_41377[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (26))){
var inst_41156 = (state_41243[(19)]);
var inst_41162 = (state_41243[(26)]);
var inst_41160 = (state_41243[(23)]);
var inst_41159 = (state_41243[(24)]);
var inst_41164 = (state_41243[(25)]);
var inst_41179 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_41181 = (function (){var all_files = inst_41156;
var res_SINGLEQUOTE_ = inst_41159;
var res = inst_41160;
var files_not_loaded = inst_41162;
var dependencies_that_loaded = inst_41164;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_41156,inst_41162,inst_41160,inst_41159,inst_41164,inst_41179,state_val_41244,c__38817__auto__,map__41088,map__41088__$1,opts,before_jsload,on_jsload,reload_dependents,map__41089,map__41089__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__41180){
var map__41312 = p__41180;
var map__41312__$1 = ((((!((map__41312 == null)))?((((map__41312.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41312.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41312):map__41312);
var namespace = cljs.core.get.call(null,map__41312__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__41312__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_41156,inst_41162,inst_41160,inst_41159,inst_41164,inst_41179,state_val_41244,c__38817__auto__,map__41088,map__41088__$1,opts,before_jsload,on_jsload,reload_dependents,map__41089,map__41089__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_41182 = cljs.core.map.call(null,inst_41181,inst_41160);
var inst_41183 = cljs.core.pr_str.call(null,inst_41182);
var inst_41184 = figwheel.client.utils.log.call(null,inst_41183);
var inst_41185 = (function (){var all_files = inst_41156;
var res_SINGLEQUOTE_ = inst_41159;
var res = inst_41160;
var files_not_loaded = inst_41162;
var dependencies_that_loaded = inst_41164;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_41156,inst_41162,inst_41160,inst_41159,inst_41164,inst_41179,inst_41181,inst_41182,inst_41183,inst_41184,state_val_41244,c__38817__auto__,map__41088,map__41088__$1,opts,before_jsload,on_jsload,reload_dependents,map__41089,map__41089__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_41156,inst_41162,inst_41160,inst_41159,inst_41164,inst_41179,inst_41181,inst_41182,inst_41183,inst_41184,state_val_41244,c__38817__auto__,map__41088,map__41088__$1,opts,before_jsload,on_jsload,reload_dependents,map__41089,map__41089__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_41186 = setTimeout(inst_41185,(10));
var state_41243__$1 = (function (){var statearr_41314 = state_41243;
(statearr_41314[(33)] = inst_41184);

(statearr_41314[(34)] = inst_41179);

return statearr_41314;
})();
var statearr_41315_41378 = state_41243__$1;
(statearr_41315_41378[(2)] = inst_41186);

(statearr_41315_41378[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (16))){
var state_41243__$1 = state_41243;
var statearr_41316_41379 = state_41243__$1;
(statearr_41316_41379[(2)] = reload_dependents);

(statearr_41316_41379[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (38))){
var inst_41196 = (state_41243[(16)]);
var inst_41214 = cljs.core.apply.call(null,cljs.core.hash_map,inst_41196);
var state_41243__$1 = state_41243;
var statearr_41317_41380 = state_41243__$1;
(statearr_41317_41380[(2)] = inst_41214);

(statearr_41317_41380[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (30))){
var state_41243__$1 = state_41243;
var statearr_41318_41381 = state_41243__$1;
(statearr_41318_41381[(2)] = null);

(statearr_41318_41381[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (10))){
var inst_41116 = (state_41243[(22)]);
var inst_41118 = cljs.core.chunked_seq_QMARK_.call(null,inst_41116);
var state_41243__$1 = state_41243;
if(inst_41118){
var statearr_41319_41382 = state_41243__$1;
(statearr_41319_41382[(1)] = (13));

} else {
var statearr_41320_41383 = state_41243__$1;
(statearr_41320_41383[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (18))){
var inst_41150 = (state_41243[(2)]);
var state_41243__$1 = state_41243;
if(cljs.core.truth_(inst_41150)){
var statearr_41321_41384 = state_41243__$1;
(statearr_41321_41384[(1)] = (19));

} else {
var statearr_41322_41385 = state_41243__$1;
(statearr_41322_41385[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (42))){
var state_41243__$1 = state_41243;
var statearr_41323_41386 = state_41243__$1;
(statearr_41323_41386[(2)] = null);

(statearr_41323_41386[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (37))){
var inst_41209 = (state_41243[(2)]);
var state_41243__$1 = state_41243;
var statearr_41324_41387 = state_41243__$1;
(statearr_41324_41387[(2)] = inst_41209);

(statearr_41324_41387[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41244 === (8))){
var inst_41103 = (state_41243[(8)]);
var inst_41116 = (state_41243[(22)]);
var inst_41116__$1 = cljs.core.seq.call(null,inst_41103);
var state_41243__$1 = (function (){var statearr_41325 = state_41243;
(statearr_41325[(22)] = inst_41116__$1);

return statearr_41325;
})();
if(inst_41116__$1){
var statearr_41326_41388 = state_41243__$1;
(statearr_41326_41388[(1)] = (10));

} else {
var statearr_41327_41389 = state_41243__$1;
(statearr_41327_41389[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38817__auto__,map__41088,map__41088__$1,opts,before_jsload,on_jsload,reload_dependents,map__41089,map__41089__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__38764__auto__,c__38817__auto__,map__41088,map__41088__$1,opts,before_jsload,on_jsload,reload_dependents,map__41089,map__41089__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__38765__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__38765__auto____0 = (function (){
var statearr_41328 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41328[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__38765__auto__);

(statearr_41328[(1)] = (1));

return statearr_41328;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__38765__auto____1 = (function (state_41243){
while(true){
var ret_value__38766__auto__ = (function (){try{while(true){
var result__38767__auto__ = switch__38764__auto__.call(null,state_41243);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38767__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38767__auto__;
}
break;
}
}catch (e41329){if((e41329 instanceof Object)){
var ex__38768__auto__ = e41329;
var statearr_41330_41390 = state_41243;
(statearr_41330_41390[(5)] = ex__38768__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_41243);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e41329;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38766__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41391 = state_41243;
state_41243 = G__41391;
continue;
} else {
return ret_value__38766__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__38765__auto__ = function(state_41243){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__38765__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__38765__auto____1.call(this,state_41243);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__38765__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__38765__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__38765__auto__;
})()
;})(switch__38764__auto__,c__38817__auto__,map__41088,map__41088__$1,opts,before_jsload,on_jsload,reload_dependents,map__41089,map__41089__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__38819__auto__ = (function (){var statearr_41331 = f__38818__auto__.call(null);
(statearr_41331[(6)] = c__38817__auto__);

return statearr_41331;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38819__auto__);
});})(c__38817__auto__,map__41088,map__41088__$1,opts,before_jsload,on_jsload,reload_dependents,map__41089,map__41089__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__38817__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),"//"].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__41394,link){
var map__41395 = p__41394;
var map__41395__$1 = ((((!((map__41395 == null)))?((((map__41395.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41395.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41395):map__41395);
var file = cljs.core.get.call(null,map__41395__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = link.href;
if(cljs.core.truth_(temp__4657__auto__)){
var link_href = temp__4657__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4657__auto__,map__41395,map__41395__$1,file){
return (function (p1__41392_SHARP_,p2__41393_SHARP_){
if(cljs.core._EQ_.call(null,p1__41392_SHARP_,p2__41393_SHARP_)){
return p1__41392_SHARP_;
} else {
return false;
}
});})(link_href,temp__4657__auto__,map__41395,map__41395__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4657__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__41398){
var map__41399 = p__41398;
var map__41399__$1 = ((((!((map__41399 == null)))?((((map__41399.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41399.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41399):map__41399);
var match_length = cljs.core.get.call(null,map__41399__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__41399__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__41397_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__41397_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4657__auto__)){
var res = temp__4657__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__41401_SHARP_,p2__41402_SHARP_){
return cljs.core.assoc.call(null,p1__41401_SHARP_,cljs.core.get.call(null,p2__41402_SHARP_,key),p2__41402_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
});})(parent))
,(300));
});
if(typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__4655__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4655__auto__)){
var link = temp__4655__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),((function (link,temp__4655__auto__){
return (function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),true));
});})(link,temp__4655__auto__))
);
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_41403 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_41403);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_41403);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__41404,p__41405){
var map__41406 = p__41404;
var map__41406__$1 = ((((!((map__41406 == null)))?((((map__41406.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41406.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41406):map__41406);
var on_cssload = cljs.core.get.call(null,map__41406__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__41407 = p__41405;
var map__41407__$1 = ((((!((map__41407 == null)))?((((map__41407.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41407.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41407):map__41407);
var files_msg = map__41407__$1;
var files = cljs.core.get.call(null,map__41407__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var temp__4657__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
if(cljs.core.truth_(temp__4657__auto__)){
var f_datas = temp__4657__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1503590937879
