(ns orcl.naive2.tests-runner
  (:require [orcl.naive2 :as naive]
            [orcl.analyzer :as analyzer]
            [orcl.testkit.proto :as proto]
            [orcl.naive2.lib :as lib]))

(defn compiler []
  (reify proto/OrcCompiler
    (compile [this ast]
      (let [analyzed (analyzer/analyze ast lib/prelude {:deflate? true
                                                        :patterns? true
                                                        :clauses? true
                                                        :conditional? true})
            compiled (naive/compile analyzed)
            values (atom [])]
        ;(prn "---P" compiled)
        (reify proto/Program
          (run [_]
            (naive/run compiled))
          (unblock [_ state id value]
            (let [res (naive/unblock state id value)]
              (swap! values #(into % (:values res)))
              res)))))))
