(ns orcl.naive.tests-runner
  (:require [orcl.naive :as naive]
            [orcl.analyzer :as analyzer]
            [orcl.testkit.proto :as proto]
            [orcl.naive.lib :as lib]))

(defn compiler []
  (reify proto/OrcCompiler
    (compile [this ast]
      (let [analyzed (analyzer/analyze ast lib/prelude {:deflate? true})
            compiled (naive/compile analyzed)
            values (atom [])]
        (prn "---P" compiled)
        (reify proto/Program
          (run [_]
            (naive/run compiled))
          (unblock [_ state id value]
            (let [res (naive/unblock state id value)]
              (swap! values #(into % (:values res)))
              res)))))))
