// Compiled by ClojureScript 1.9.908 {}
goog.provide('orcl.utils');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('orcl.utils.hashify');
orcl.utils.sha = (function orcl$utils$sha(x){
if(cljs.core.map_QMARK_.call(null,x)){
var temp__4655__auto__ = new cljs.core.Keyword(null,"sha","sha",-950317251).cljs$core$IFn$_invoke$arity$1(x);
if(cljs.core.truth_(temp__4655__auto__)){
var sha = temp__4655__auto__;
return x;
} else {
return orcl.utils.sha.call(null,cljs.core.sort_by.call(null,cljs.core.first,x));
}
} else {
if(cljs.core.sequential_QMARK_.call(null,x)){
return orcl.utils.sha.call(null,clojure.string.join.call(null,"",cljs.core.map.call(null,orcl.utils.sha,x)));
} else {
if(typeof x === 'string'){
return orcl.utils.hashify.hashify.call(null,x);
} else {
if((x instanceof cljs.core.Keyword)){
return orcl.utils.sha.call(null,cljs.core.name.call(null,x));
} else {
if((x instanceof cljs.core.Symbol)){
return orcl.utils.sha.call(null,cljs.core.name.call(null,x));
} else {
return orcl.utils.sha.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''));

}
}
}
}
}
});
orcl.utils.with_sha = (function orcl$utils$with_sha(node){
return cljs.core.assoc.call(null,node,new cljs.core.Keyword(null,"sha","sha",-950317251),orcl.utils.sha.call(null,node));
});
/**
 * Build map k -> (f v) for [k v] in map, preserving the initial type
 */
orcl.utils.map_vals = (function orcl$utils$map_vals(f,m){
if(cljs.core.sorted_QMARK_.call(null,m)){
return cljs.core.reduce_kv.call(null,(function (out_m,k,v){
return cljs.core.assoc.call(null,out_m,k,f.call(null,v));
}),cljs.core.sorted_map.call(null),m);
} else {
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce_kv.call(null,(function (out_m,k,v){
return cljs.core.assoc_BANG_.call(null,out_m,k,f.call(null,v));
}),cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),m));
} else {
var m_atom__29542__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));
var seq__29551_29561 = cljs.core.seq.call(null,m);
var chunk__29552_29562 = null;
var count__29553_29563 = (0);
var i__29554_29564 = (0);
while(true){
if((i__29554_29564 < count__29553_29563)){
var vec__29555_29565 = cljs.core._nth.call(null,chunk__29552_29562,i__29554_29564);
var k_29566 = cljs.core.nth.call(null,vec__29555_29565,(0),null);
var v_29567 = cljs.core.nth.call(null,vec__29555_29565,(1),null);
var m29550_29568 = cljs.core.deref.call(null,m_atom__29542__auto__);
cljs.core.reset_BANG_.call(null,m_atom__29542__auto__,cljs.core.assoc_BANG_.call(null,m29550_29568,k_29566,f.call(null,v_29567)));

var G__29569 = seq__29551_29561;
var G__29570 = chunk__29552_29562;
var G__29571 = count__29553_29563;
var G__29572 = (i__29554_29564 + (1));
seq__29551_29561 = G__29569;
chunk__29552_29562 = G__29570;
count__29553_29563 = G__29571;
i__29554_29564 = G__29572;
continue;
} else {
var temp__4657__auto___29573 = cljs.core.seq.call(null,seq__29551_29561);
if(temp__4657__auto___29573){
var seq__29551_29574__$1 = temp__4657__auto___29573;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__29551_29574__$1)){
var c__28828__auto___29575 = cljs.core.chunk_first.call(null,seq__29551_29574__$1);
var G__29576 = cljs.core.chunk_rest.call(null,seq__29551_29574__$1);
var G__29577 = c__28828__auto___29575;
var G__29578 = cljs.core.count.call(null,c__28828__auto___29575);
var G__29579 = (0);
seq__29551_29561 = G__29576;
chunk__29552_29562 = G__29577;
count__29553_29563 = G__29578;
i__29554_29564 = G__29579;
continue;
} else {
var vec__29558_29580 = cljs.core.first.call(null,seq__29551_29574__$1);
var k_29581 = cljs.core.nth.call(null,vec__29558_29580,(0),null);
var v_29582 = cljs.core.nth.call(null,vec__29558_29580,(1),null);
var m29550_29583 = cljs.core.deref.call(null,m_atom__29542__auto__);
cljs.core.reset_BANG_.call(null,m_atom__29542__auto__,cljs.core.assoc_BANG_.call(null,m29550_29583,k_29581,f.call(null,v_29582)));

var G__29584 = cljs.core.next.call(null,seq__29551_29574__$1);
var G__29585 = null;
var G__29586 = (0);
var G__29587 = (0);
seq__29551_29561 = G__29584;
chunk__29552_29562 = G__29585;
count__29553_29563 = G__29586;
i__29554_29564 = G__29587;
continue;
}
} else {
}
}
break;
}

return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__29542__auto__));

}
}
});
/**
 * Returns a map of the elements of `coll` keyed by the result of `f` on each
 * element.  The value at each key will be a single element (in contrast to
 * `clojure.core/group-by`).  Therefore `f` should generally return an unique
 * key for every element - otherwise elements get discarded.
 */
orcl.utils.index_by = (function orcl$utils$index_by(f,coll){
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce.call(null,(function (p1__29588_SHARP_,p2__29589_SHARP_){
return cljs.core.assoc_BANG_.call(null,p1__29588_SHARP_,f.call(null,p2__29589_SHARP_),p2__29589_SHARP_);
}),cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),coll));
});
/**
 * Like assoc but only assocs when value is truthy
 */
orcl.utils.assoc_when = (function orcl$utils$assoc_when(var_args){
var args__29165__auto__ = [];
var len__29158__auto___29602 = arguments.length;
var i__29159__auto___29603 = (0);
while(true){
if((i__29159__auto___29603 < len__29158__auto___29602)){
args__29165__auto__.push((arguments[i__29159__auto___29603]));

var G__29604 = (i__29159__auto___29603 + (1));
i__29159__auto___29603 = G__29604;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((1) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((1)),(0),null)):null);
return orcl.utils.assoc_when.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29166__auto__);
});

orcl.utils.assoc_when.cljs$core$IFn$_invoke$arity$variadic = (function (m,kvs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

return cljs.core.into.call(null,(function (){var or__27989__auto__ = m;
if(cljs.core.truth_(or__27989__auto__)){
return or__27989__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),(function (){var iter__28797__auto__ = (function orcl$utils$iter__29592(s__29593){
return (new cljs.core.LazySeq(null,(function (){
var s__29593__$1 = s__29593;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__29593__$1);
if(temp__4657__auto__){
var s__29593__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__29593__$2)){
var c__28795__auto__ = cljs.core.chunk_first.call(null,s__29593__$2);
var size__28796__auto__ = cljs.core.count.call(null,c__28795__auto__);
var b__29595 = cljs.core.chunk_buffer.call(null,size__28796__auto__);
if((function (){var i__29594 = (0);
while(true){
if((i__29594 < size__28796__auto__)){
var vec__29596 = cljs.core._nth.call(null,c__28795__auto__,i__29594);
var k = cljs.core.nth.call(null,vec__29596,(0),null);
var v = cljs.core.nth.call(null,vec__29596,(1),null);
if(cljs.core.truth_(v)){
cljs.core.chunk_append.call(null,b__29595,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));

var G__29605 = (i__29594 + (1));
i__29594 = G__29605;
continue;
} else {
var G__29606 = (i__29594 + (1));
i__29594 = G__29606;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__29595),orcl$utils$iter__29592.call(null,cljs.core.chunk_rest.call(null,s__29593__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__29595),null);
}
} else {
var vec__29599 = cljs.core.first.call(null,s__29593__$2);
var k = cljs.core.nth.call(null,vec__29599,(0),null);
var v = cljs.core.nth.call(null,vec__29599,(1),null);
if(cljs.core.truth_(v)){
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),orcl$utils$iter__29592.call(null,cljs.core.rest.call(null,s__29593__$2)));
} else {
var G__29607 = cljs.core.rest.call(null,s__29593__$2);
s__29593__$1 = G__29607;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__28797__auto__.call(null,cljs.core.partition.call(null,(2),kvs));
})());
});

orcl.utils.assoc_when.cljs$lang$maxFixedArity = (1);

orcl.utils.assoc_when.cljs$lang$applyTo = (function (seq29590){
var G__29591 = cljs.core.first.call(null,seq29590);
var seq29590__$1 = cljs.core.next.call(null,seq29590);
return orcl.utils.assoc_when.cljs$core$IFn$_invoke$arity$variadic(G__29591,seq29590__$1);
});

orcl.utils.def_walk = (function orcl$utils$def_walk(f,def){
return cljs.core.assoc.call(null,def,new cljs.core.Keyword(null,"instances","instances",-335364781),cljs.core.mapv.call(null,(function (p1__29608_SHARP_){
return cljs.core.update.call(null,p1__29608_SHARP_,new cljs.core.Keyword(null,"body","body",-2049205669),f);
}),new cljs.core.Keyword(null,"instances","instances",-335364781).cljs$core$IFn$_invoke$arity$1(def)));
});
orcl.utils.ast_walk = (function orcl$utils$ast_walk(inner,outer,ast){
var G__29610 = new cljs.core.Keyword(null,"node","node",581201198).cljs$core$IFn$_invoke$arity$1(ast);
var G__29610__$1 = (((G__29610 instanceof cljs.core.Keyword))?G__29610.fqn:null);
switch (G__29610__$1) {
case "pruning":
case "sequential":
case "parallel":
case "otherwise":
return outer.call(null,cljs.core.update.call(null,cljs.core.update.call(null,ast,new cljs.core.Keyword(null,"left","left",-399115937),inner),new cljs.core.Keyword(null,"right","right",-452581833),inner));

break;
case "conditional":
return outer.call(null,cljs.core.update.call(null,cljs.core.update.call(null,cljs.core.update.call(null,ast,new cljs.core.Keyword(null,"if","if",-458814265),inner),new cljs.core.Keyword(null,"then","then",460598070),inner),new cljs.core.Keyword(null,"else","else",-1508377146),inner));

break;
case "lambda":
return outer.call(null,cljs.core.update.call(null,cljs.core.assoc.call(null,cljs.core.update.call(null,ast,new cljs.core.Keyword(null,"body","body",-2049205669),inner),new cljs.core.Keyword(null,"params","params",710516235),cljs.core.mapv.call(null,inner,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(ast))),new cljs.core.Keyword(null,"guard","guard",-873147811),inner));

break;
case "declarations":
return outer.call(null,cljs.core.assoc.call(null,cljs.core.update.call(null,ast,new cljs.core.Keyword(null,"expr","expr",745722291),inner),new cljs.core.Keyword(null,"decls","decls",1343324492),cljs.core.mapv.call(null,((function (G__29610,G__29610__$1){
return (function (p1__29609_SHARP_){
var G__29611 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(p1__29609_SHARP_);
var G__29611__$1 = (((G__29611 instanceof cljs.core.Keyword))?G__29611.fqn:null);
switch (G__29611__$1) {
case "def":
return cljs.core.update.call(null,p1__29609_SHARP_,new cljs.core.Keyword(null,"body","body",-2049205669),inner);

break;
default:
return p1__29609_SHARP_;

}
});})(G__29610,G__29610__$1))
,new cljs.core.Keyword(null,"decls","decls",1343324492).cljs$core$IFn$_invoke$arity$1(ast))));

break;
case "defs-group":
return outer.call(null,cljs.core.assoc.call(null,cljs.core.update.call(null,ast,new cljs.core.Keyword(null,"expr","expr",745722291),inner),new cljs.core.Keyword(null,"defs","defs",1398449717),cljs.core.mapv.call(null,cljs.core.partial.call(null,orcl.utils.def_walk,inner),new cljs.core.Keyword(null,"defs","defs",1398449717).cljs$core$IFn$_invoke$arity$1(ast))));

break;
case "call":
return outer.call(null,cljs.core.assoc.call(null,cljs.core.update.call(null,ast,new cljs.core.Keyword(null,"target","target",253001721),inner),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.mapv.call(null,inner,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(ast))));

break;
case "list":
case "tuple":
return outer.call(null,cljs.core.assoc.call(null,ast,new cljs.core.Keyword(null,"values","values",372645556),cljs.core.mapv.call(null,inner,new cljs.core.Keyword(null,"values","values",372645556).cljs$core$IFn$_invoke$arity$1(ast))));

break;
case "record":
return outer.call(null,cljs.core.assoc.call(null,ast,new cljs.core.Keyword(null,"pairs","pairs",614609779),cljs.core.mapv.call(null,((function (G__29610,G__29610__$1){
return (function (p__29612){
var vec__29613 = p__29612;
var k = cljs.core.nth.call(null,vec__29613,(0),null);
var v = cljs.core.nth.call(null,vec__29613,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,inner.call(null,v)], null);
});})(G__29610,G__29610__$1))
,new cljs.core.Keyword(null,"pairs","pairs",614609779).cljs$core$IFn$_invoke$arity$1(ast))));

break;
case "field-access":
case "dereference":
return outer.call(null,cljs.core.update.call(null,ast,new cljs.core.Keyword(null,"target","target",253001721),inner));

break;
case "normalized-conditional":
return outer.call(null,cljs.core.update.call(null,cljs.core.update.call(null,cljs.core.update.call(null,ast,new cljs.core.Keyword(null,"if","if",-458814265),inner),new cljs.core.Keyword(null,"then","then",460598070),inner),new cljs.core.Keyword(null,"else","else",-1508377146),inner));

break;
case "stop":
case "const":
case "var":
return outer.call(null,ast);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__29610__$1)].join('')));

}
});
orcl.utils.ast_postwalk = (function orcl$utils$ast_postwalk(f,form){
return orcl.utils.ast_walk.call(null,cljs.core.partial.call(null,orcl.utils.ast_postwalk,f),f,form);
});
orcl.utils.ast_prewalk = (function orcl$utils$ast_prewalk(f,form){
return orcl.utils.ast_walk.call(null,cljs.core.partial.call(null,orcl.utils.ast_prewalk,f),cljs.core.identity,f.call(null,form));
});
orcl.utils.todo_exception = (function orcl$utils$todo_exception(){
throw (new Error());
});

//# sourceMappingURL=utils.js.map?rel=1504016569146
