(ns orcl.naive.tests-runner
  (:require [orcl.naive :as naive]
            [orcl.testkit.proto :as proto]
            [orcl.naive.lib :as lib]))

(defn compiler []
  (reify proto/OrcCompiler
    (prelude [this]
      lib/prelude)
    (compile [this ast]
      (let [compiled (naive/compile ast)
            values (atom [])]
        (prn "---P" compiled)
        (reify proto/Program
          (run [_]
            (naive/run compiled))
          (unblock [_ state id value]
            (let [res (naive/unblock state id value)]
              (swap! values #(into % (:values res)))
              res)))))))
