// Compiled by ClojureScript 1.9.908 {}
goog.provide('orcl.utils');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('orcl.utils.hashify');
orcl.utils.sha = (function orcl$utils$sha(x){
if(cljs.core.map_QMARK_.call(null,x)){
var temp__4655__auto__ = new cljs.core.Keyword(null,"sha","sha",-950317251).cljs$core$IFn$_invoke$arity$1(x);
if(cljs.core.truth_(temp__4655__auto__)){
var sha = temp__4655__auto__;
return x;
} else {
return orcl.utils.sha.call(null,cljs.core.sort_by.call(null,cljs.core.first,x));
}
} else {
if(cljs.core.sequential_QMARK_.call(null,x)){
return orcl.utils.sha.call(null,clojure.string.join.call(null,"",cljs.core.map.call(null,orcl.utils.sha,x)));
} else {
if(typeof x === 'string'){
return orcl.utils.hashify.hashify.call(null,x);
} else {
if((x instanceof cljs.core.Keyword)){
return orcl.utils.sha.call(null,cljs.core.name.call(null,x));
} else {
if((x instanceof cljs.core.Symbol)){
return orcl.utils.sha.call(null,cljs.core.name.call(null,x));
} else {
return orcl.utils.sha.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''));

}
}
}
}
}
});
orcl.utils.with_sha = (function orcl$utils$with_sha(node){
return cljs.core.assoc.call(null,node,new cljs.core.Keyword(null,"sha","sha",-950317251),orcl.utils.sha.call(null,node));
});
/**
 * Build map k -> (f v) for [k v] in map, preserving the initial type
 */
orcl.utils.map_vals = (function orcl$utils$map_vals(f,m){
if(cljs.core.sorted_QMARK_.call(null,m)){
return cljs.core.reduce_kv.call(null,(function (out_m,k,v){
return cljs.core.assoc.call(null,out_m,k,f.call(null,v));
}),cljs.core.sorted_map.call(null),m);
} else {
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce_kv.call(null,(function (out_m,k,v){
return cljs.core.assoc_BANG_.call(null,out_m,k,f.call(null,v));
}),cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),m));
} else {
var m_atom__35702__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));
var seq__35711_35721 = cljs.core.seq.call(null,m);
var chunk__35712_35722 = null;
var count__35713_35723 = (0);
var i__35714_35724 = (0);
while(true){
if((i__35714_35724 < count__35713_35723)){
var vec__35715_35725 = cljs.core._nth.call(null,chunk__35712_35722,i__35714_35724);
var k_35726 = cljs.core.nth.call(null,vec__35715_35725,(0),null);
var v_35727 = cljs.core.nth.call(null,vec__35715_35725,(1),null);
var m35710_35728 = cljs.core.deref.call(null,m_atom__35702__auto__);
cljs.core.reset_BANG_.call(null,m_atom__35702__auto__,cljs.core.assoc_BANG_.call(null,m35710_35728,k_35726,f.call(null,v_35727)));

var G__35729 = seq__35711_35721;
var G__35730 = chunk__35712_35722;
var G__35731 = count__35713_35723;
var G__35732 = (i__35714_35724 + (1));
seq__35711_35721 = G__35729;
chunk__35712_35722 = G__35730;
count__35713_35723 = G__35731;
i__35714_35724 = G__35732;
continue;
} else {
var temp__4657__auto___35733 = cljs.core.seq.call(null,seq__35711_35721);
if(temp__4657__auto___35733){
var seq__35711_35734__$1 = temp__4657__auto___35733;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35711_35734__$1)){
var c__28828__auto___35735 = cljs.core.chunk_first.call(null,seq__35711_35734__$1);
var G__35736 = cljs.core.chunk_rest.call(null,seq__35711_35734__$1);
var G__35737 = c__28828__auto___35735;
var G__35738 = cljs.core.count.call(null,c__28828__auto___35735);
var G__35739 = (0);
seq__35711_35721 = G__35736;
chunk__35712_35722 = G__35737;
count__35713_35723 = G__35738;
i__35714_35724 = G__35739;
continue;
} else {
var vec__35718_35740 = cljs.core.first.call(null,seq__35711_35734__$1);
var k_35741 = cljs.core.nth.call(null,vec__35718_35740,(0),null);
var v_35742 = cljs.core.nth.call(null,vec__35718_35740,(1),null);
var m35710_35743 = cljs.core.deref.call(null,m_atom__35702__auto__);
cljs.core.reset_BANG_.call(null,m_atom__35702__auto__,cljs.core.assoc_BANG_.call(null,m35710_35743,k_35741,f.call(null,v_35742)));

var G__35744 = cljs.core.next.call(null,seq__35711_35734__$1);
var G__35745 = null;
var G__35746 = (0);
var G__35747 = (0);
seq__35711_35721 = G__35744;
chunk__35712_35722 = G__35745;
count__35713_35723 = G__35746;
i__35714_35724 = G__35747;
continue;
}
} else {
}
}
break;
}

return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__35702__auto__));

}
}
});
/**
 * Returns a map of the elements of `coll` keyed by the result of `f` on each
 * element.  The value at each key will be a single element (in contrast to
 * `clojure.core/group-by`).  Therefore `f` should generally return an unique
 * key for every element - otherwise elements get discarded.
 */
orcl.utils.index_by = (function orcl$utils$index_by(f,coll){
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce.call(null,(function (p1__35748_SHARP_,p2__35749_SHARP_){
return cljs.core.assoc_BANG_.call(null,p1__35748_SHARP_,f.call(null,p2__35749_SHARP_),p2__35749_SHARP_);
}),cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),coll));
});
/**
 * Like assoc but only assocs when value is truthy
 */
orcl.utils.assoc_when = (function orcl$utils$assoc_when(var_args){
var args__29165__auto__ = [];
var len__29158__auto___35762 = arguments.length;
var i__29159__auto___35763 = (0);
while(true){
if((i__29159__auto___35763 < len__29158__auto___35762)){
args__29165__auto__.push((arguments[i__29159__auto___35763]));

var G__35764 = (i__29159__auto___35763 + (1));
i__29159__auto___35763 = G__35764;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((1) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((1)),(0),null)):null);
return orcl.utils.assoc_when.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29166__auto__);
});

orcl.utils.assoc_when.cljs$core$IFn$_invoke$arity$variadic = (function (m,kvs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

return cljs.core.into.call(null,(function (){var or__27989__auto__ = m;
if(cljs.core.truth_(or__27989__auto__)){
return or__27989__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),(function (){var iter__28797__auto__ = (function orcl$utils$iter__35752(s__35753){
return (new cljs.core.LazySeq(null,(function (){
var s__35753__$1 = s__35753;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__35753__$1);
if(temp__4657__auto__){
var s__35753__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__35753__$2)){
var c__28795__auto__ = cljs.core.chunk_first.call(null,s__35753__$2);
var size__28796__auto__ = cljs.core.count.call(null,c__28795__auto__);
var b__35755 = cljs.core.chunk_buffer.call(null,size__28796__auto__);
if((function (){var i__35754 = (0);
while(true){
if((i__35754 < size__28796__auto__)){
var vec__35756 = cljs.core._nth.call(null,c__28795__auto__,i__35754);
var k = cljs.core.nth.call(null,vec__35756,(0),null);
var v = cljs.core.nth.call(null,vec__35756,(1),null);
if(cljs.core.truth_(v)){
cljs.core.chunk_append.call(null,b__35755,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));

var G__35765 = (i__35754 + (1));
i__35754 = G__35765;
continue;
} else {
var G__35766 = (i__35754 + (1));
i__35754 = G__35766;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__35755),orcl$utils$iter__35752.call(null,cljs.core.chunk_rest.call(null,s__35753__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__35755),null);
}
} else {
var vec__35759 = cljs.core.first.call(null,s__35753__$2);
var k = cljs.core.nth.call(null,vec__35759,(0),null);
var v = cljs.core.nth.call(null,vec__35759,(1),null);
if(cljs.core.truth_(v)){
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),orcl$utils$iter__35752.call(null,cljs.core.rest.call(null,s__35753__$2)));
} else {
var G__35767 = cljs.core.rest.call(null,s__35753__$2);
s__35753__$1 = G__35767;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__28797__auto__.call(null,cljs.core.partition.call(null,(2),kvs));
})());
});

orcl.utils.assoc_when.cljs$lang$maxFixedArity = (1);

orcl.utils.assoc_when.cljs$lang$applyTo = (function (seq35750){
var G__35751 = cljs.core.first.call(null,seq35750);
var seq35750__$1 = cljs.core.next.call(null,seq35750);
return orcl.utils.assoc_when.cljs$core$IFn$_invoke$arity$variadic(G__35751,seq35750__$1);
});

orcl.utils.ast_walk = (function orcl$utils$ast_walk(inner,outer,ast){
var G__35769 = new cljs.core.Keyword(null,"node","node",581201198).cljs$core$IFn$_invoke$arity$1(ast);
var G__35769__$1 = (((G__35769 instanceof cljs.core.Keyword))?G__35769.fqn:null);
switch (G__35769__$1) {
case "pruning":
case "sequential":
case "parallel":
case "otherwise":
return outer.call(null,cljs.core.update.call(null,cljs.core.update.call(null,ast,new cljs.core.Keyword(null,"left","left",-399115937),inner),new cljs.core.Keyword(null,"right","right",-452581833),inner));

break;
case "conditional":
return outer.call(null,cljs.core.update.call(null,cljs.core.update.call(null,cljs.core.update.call(null,ast,new cljs.core.Keyword(null,"if","if",-458814265),inner),new cljs.core.Keyword(null,"then","then",460598070),inner),new cljs.core.Keyword(null,"else","else",-1508377146),inner));

break;
case "lambda":
return outer.call(null,cljs.core.update.call(null,cljs.core.assoc.call(null,cljs.core.update.call(null,ast,new cljs.core.Keyword(null,"body","body",-2049205669),inner),new cljs.core.Keyword(null,"params","params",710516235),cljs.core.mapv.call(null,inner,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(ast))),new cljs.core.Keyword(null,"guard","guard",-873147811),inner));

break;
case "declaration":
return outer.call(null,(function (){var G__35770 = cljs.core.update.call(null,ast,new cljs.core.Keyword(null,"expr","expr",745722291),inner);
var G__35770__$1 = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"def","def",-1043430536),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"decl","decl",-1498869485).cljs$core$IFn$_invoke$arity$1(ast))))?cljs.core.update_in.call(null,G__35770,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"decl","decl",-1498869485),new cljs.core.Keyword(null,"body","body",-2049205669)], null),inner):G__35770);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"include","include",153360230),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"decl","decl",-1498869485).cljs$core$IFn$_invoke$arity$1(ast)))){
return cljs.core.update_in.call(null,G__35770__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"decl","decl",-1498869485),new cljs.core.Keyword(null,"declarations","declarations",1621100858)], null),((function (G__35770,G__35770__$1,G__35769,G__35769__$1){
return (function (p1__35768_SHARP_){
return cljs.core.map.call(null,inner,p1__35768_SHARP_);
});})(G__35770,G__35770__$1,G__35769,G__35769__$1))
);
} else {
return G__35770__$1;
}
})());

break;
case "defs-group":
return outer.call(null,cljs.core.assoc.call(null,cljs.core.update.call(null,ast,new cljs.core.Keyword(null,"expr","expr",745722291),inner),new cljs.core.Keyword(null,"defs","defs",1398449717),cljs.core.mapv.call(null,inner,new cljs.core.Keyword(null,"defs","defs",1398449717).cljs$core$IFn$_invoke$arity$1(ast))));

break;
case "def":
return outer.call(null,cljs.core.assoc.call(null,ast,new cljs.core.Keyword(null,"instances","instances",-335364781),cljs.core.mapv.call(null,inner,new cljs.core.Keyword(null,"instances","instances",-335364781).cljs$core$IFn$_invoke$arity$1(ast))));

break;
case "def-instance":
return outer.call(null,cljs.core.assoc.call(null,ast,new cljs.core.Keyword(null,"body","body",-2049205669),inner.call(null,new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(ast))));

break;
case "call":
return outer.call(null,cljs.core.assoc.call(null,cljs.core.update.call(null,ast,new cljs.core.Keyword(null,"target","target",253001721),inner),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.mapv.call(null,inner,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(ast))));

break;
case "list":
case "tuple":
return outer.call(null,cljs.core.assoc.call(null,ast,new cljs.core.Keyword(null,"values","values",372645556),cljs.core.mapv.call(null,inner,new cljs.core.Keyword(null,"values","values",372645556).cljs$core$IFn$_invoke$arity$1(ast))));

break;
case "record":
return outer.call(null,cljs.core.assoc.call(null,ast,new cljs.core.Keyword(null,"pairs","pairs",614609779),cljs.core.mapv.call(null,((function (G__35769,G__35769__$1){
return (function (p__35771){
var vec__35772 = p__35771;
var k = cljs.core.nth.call(null,vec__35772,(0),null);
var v = cljs.core.nth.call(null,vec__35772,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,inner.call(null,v)], null);
});})(G__35769,G__35769__$1))
,new cljs.core.Keyword(null,"pairs","pairs",614609779).cljs$core$IFn$_invoke$arity$1(ast))));

break;
case "field-access":
case "dereference":
return outer.call(null,cljs.core.update.call(null,ast,new cljs.core.Keyword(null,"target","target",253001721),inner));

break;
case "normalized-conditional":
return outer.call(null,cljs.core.update.call(null,cljs.core.update.call(null,cljs.core.update.call(null,ast,new cljs.core.Keyword(null,"if","if",-458814265),inner),new cljs.core.Keyword(null,"then","then",460598070),inner),new cljs.core.Keyword(null,"else","else",-1508377146),inner));

break;
case "stop":
case "const":
case "var":
return outer.call(null,ast);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__35769__$1)].join('')));

}
});
orcl.utils.ast_postwalk = (function orcl$utils$ast_postwalk(f,form){
return orcl.utils.ast_walk.call(null,cljs.core.partial.call(null,orcl.utils.ast_postwalk,f),f,form);
});
orcl.utils.ast_prewalk = (function orcl$utils$ast_prewalk(f,form){
return orcl.utils.ast_walk.call(null,cljs.core.partial.call(null,orcl.utils.ast_prewalk,f),cljs.core.identity,f.call(null,form));
});
orcl.utils.todo_exception = (function orcl$utils$todo_exception(){
throw (new Error());
});

//# sourceMappingURL=utils.js.map?rel=1503590924978
