// Compiled by ClojureScript 1.9.908 {}
goog.provide('orcl.analyzer');
goog.require('cljs.core');
goog.require('orcl.utils.cursor');
goog.require('orcl.utils');
goog.require('clojure.set');
goog.require('orcl.analyzer.vars');
goog.require('orcl.analyzer.patterns');
orcl.analyzer.primitive_QMARK_ = (function orcl$analyzer$primitive_QMARK_(n){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"const","const",1709929842),null,new cljs.core.Keyword(null,"var","var",-769682797),null], null), null).call(null,new cljs.core.Keyword(null,"node","node",581201198).cljs$core$IFn$_invoke$arity$1(n));
});
orcl.analyzer.deflate_values = (function orcl$analyzer$deflate_values(p__42463,node){
while(true){
var vec__42464 = p__42463;
var seq__42465 = cljs.core.seq.call(null,vec__42464);
var first__42466 = cljs.core.first.call(null,seq__42465);
var seq__42465__$1 = cljs.core.next.call(null,seq__42465);
var c = first__42466;
var cursors = seq__42465__$1;
if((c == null)){
return cljs.core.deref.call(null,node);
} else {
if(cljs.core.truth_(orcl.analyzer.primitive_QMARK_.call(null,cljs.core.deref.call(null,c)))){
var G__42468 = cursors;
var G__42469 = node;
p__42463 = G__42468;
node = G__42469;
continue;
} else {
var _STAR_fresh_STAR_42467 = orcl.analyzer.vars._STAR_fresh_STAR_;
orcl.analyzer.vars._STAR_fresh_STAR_ = (orcl.analyzer.vars._STAR_fresh_STAR_ + (1));

try{var fresh = ["__fresh",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orcl.analyzer.vars._STAR_fresh_STAR_)].join('');
var orig = cljs.core.deref.call(null,c);
orcl.utils.cursor.reset_BANG_.call(null,c,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"node","node",581201198),new cljs.core.Keyword(null,"var","var",-769682797),new cljs.core.Keyword(null,"var","var",-769682797),fresh], null));

return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"node","node",581201198),new cljs.core.Keyword(null,"pruning","pruning",-1224456546),new cljs.core.Keyword(null,"pattern","pattern",242135423),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"var","var",-769682797),new cljs.core.Keyword(null,"var","var",-769682797),fresh], null),new cljs.core.Keyword(null,"left","left",-399115937),orcl.analyzer.deflate_values.call(null,cursors,node),new cljs.core.Keyword(null,"right","right",-452581833),orig], null);
}finally {orcl.analyzer.vars._STAR_fresh_STAR_ = _STAR_fresh_STAR_42467;
}
}
}
break;
}
});
orcl.analyzer.bindings = (function orcl$analyzer$bindings(ast){
var G__42470 = new cljs.core.Keyword(null,"node","node",581201198).cljs$core$IFn$_invoke$arity$1(ast);
var G__42470__$1 = (((G__42470 instanceof cljs.core.Keyword))?G__42470.fqn:null);
switch (G__42470__$1) {
case "var":
return cljs.core.PersistentHashSet.createAsIfByAssoc([new cljs.core.Keyword(null,"var","var",-769682797).cljs$core$IFn$_invoke$arity$1(ast)]);

break;
case "pruning":
return clojure.set.union.call(null,clojure.set.difference.call(null,orcl.analyzer.bindings.call(null,new cljs.core.Keyword(null,"left","left",-399115937).cljs$core$IFn$_invoke$arity$1(ast)),clojure.set.difference.call(null,new cljs.core.Keyword(null,"pattern","pattern",242135423).cljs$core$IFn$_invoke$arity$1(ast))),orcl.analyzer.bindings.call(null,new cljs.core.Keyword(null,"right","right",-452581833).cljs$core$IFn$_invoke$arity$1(ast)));

break;
case "sequential":
return clojure.set.union.call(null,orcl.analyzer.bindings.call(null,new cljs.core.Keyword(null,"left","left",-399115937).cljs$core$IFn$_invoke$arity$1(ast)),clojure.set.difference.call(null,orcl.analyzer.bindings.call(null,new cljs.core.Keyword(null,"right","right",-452581833).cljs$core$IFn$_invoke$arity$1(ast)),clojure.set.difference.call(null,new cljs.core.Keyword(null,"pattern","pattern",242135423).cljs$core$IFn$_invoke$arity$1(ast))));

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__42470__$1)].join('')));

}
});
orcl.analyzer.normalize_STAR_ = (function orcl$analyzer$normalize_STAR_(ast){
var G__42472 = new cljs.core.Keyword(null,"node","node",581201198).cljs$core$IFn$_invoke$arity$1(ast);
var G__42472__$1 = (((G__42472 instanceof cljs.core.Keyword))?G__42472.fqn:null);
switch (G__42472__$1) {
case "declaration":
var decl = new cljs.core.Keyword(null,"decl","decl",-1498869485).cljs$core$IFn$_invoke$arity$1(ast);
var G__42473 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(decl);
var G__42473__$1 = (((G__42473 instanceof cljs.core.Keyword))?G__42473.fqn:null);
switch (G__42473__$1) {
case "include":
var enfold = ((function (G__42473,G__42473__$1,decl,G__42472,G__42472__$1){
return (function orcl$analyzer$normalize_STAR__$_enfold(p__42478){
var vec__42479 = p__42478;
var seq__42480 = cljs.core.seq.call(null,vec__42479);
var first__42481 = cljs.core.first.call(null,seq__42480);
var seq__42480__$1 = cljs.core.next.call(null,seq__42480);
var d = first__42481;
var declarations = seq__42480__$1;
if(cljs.core.truth_(d)){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"node","node",581201198),new cljs.core.Keyword(null,"declaration","declaration",-1819933768),new cljs.core.Keyword(null,"decl","decl",-1498869485),d,new cljs.core.Keyword(null,"expr","expr",745722291),orcl$analyzer$normalize_STAR__$_enfold.call(null,declarations)], null);
} else {
return new cljs.core.Keyword(null,"expr","expr",745722291).cljs$core$IFn$_invoke$arity$1(ast);
}
});})(G__42473,G__42473__$1,decl,G__42472,G__42472__$1))
;
return enfold.call(null,new cljs.core.Keyword(null,"declarations","declarations",1621100858).cljs$core$IFn$_invoke$arity$1(decl));

break;
case "val":
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"node","node",581201198),new cljs.core.Keyword(null,"pruning","pruning",-1224456546),new cljs.core.Keyword(null,"pattern","pattern",242135423),new cljs.core.Keyword(null,"pattern","pattern",242135423).cljs$core$IFn$_invoke$arity$1(decl),new cljs.core.Keyword(null,"left","left",-399115937),new cljs.core.Keyword(null,"expr","expr",745722291).cljs$core$IFn$_invoke$arity$1(ast),new cljs.core.Keyword(null,"right","right",-452581833),new cljs.core.Keyword(null,"expr","expr",745722291).cljs$core$IFn$_invoke$arity$1(decl)], null);

break;
case "def":
return cljs.core.update.call(null,cljs.core.assoc.call(null,ast,new cljs.core.Keyword(null,"decl","decl",-1498869485),cljs.core.update.call(null,decl,new cljs.core.Keyword(null,"body","body",-2049205669),orcl.analyzer.normalize)),new cljs.core.Keyword(null,"expr","expr",745722291),orcl.analyzer.normalize);

break;
default:
return ast;

}

break;
case "lambda":
var body = new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(ast);
var n = ["__def_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orcl.utils.sha.call(null,body))].join('');
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"node","node",581201198),new cljs.core.Keyword(null,"declaration","declaration",-1819933768),new cljs.core.Keyword(null,"decl","decl",-1498869485),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"def","def",-1043430536),new cljs.core.Keyword(null,"name","name",1843675177),n,new cljs.core.Keyword(null,"guard","guard",-873147811),new cljs.core.Keyword(null,"guard","guard",-873147811).cljs$core$IFn$_invoke$arity$1(ast),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(ast),new cljs.core.Keyword(null,"body","body",-2049205669),body], null),new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"node","node",581201198),new cljs.core.Keyword(null,"var","var",-769682797),new cljs.core.Keyword(null,"var","var",-769682797),n], null)], null);

break;
case "list":
case "tuple":
var c = orcl.utils.cursor.make.call(null,ast);
return orcl.analyzer.deflate_values.call(null,cljs.core.seq.call(null,new cljs.core.Keyword(null,"values","values",372645556).cljs$core$IFn$_invoke$arity$1(c)),c);

break;
case "record":
var c = orcl.utils.cursor.make.call(null,ast);
return orcl.analyzer.deflate_values.call(null,cljs.core.map.call(null,cljs.core.second,new cljs.core.Keyword(null,"pairs","pairs",614609779).cljs$core$IFn$_invoke$arity$1(c)),c);

break;
case "call":
var c = orcl.utils.cursor.make.call(null,ast);
return orcl.analyzer.deflate_values.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"target","target",253001721).cljs$core$IFn$_invoke$arity$1(c)], null),new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(c)),c);

break;
case "field-access":
var c = orcl.utils.cursor.make.call(null,ast);
return orcl.analyzer.deflate_values.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"target","target",253001721).cljs$core$IFn$_invoke$arity$1(c)], null),c);

break;
case "conditional":
var v = ["__v_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orcl.utils.sha.call(null,ast))].join('');
var then = ["__then_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orcl.utils.sha.call(null,new cljs.core.Keyword(null,"then","then",460598070).cljs$core$IFn$_invoke$arity$1(ast)))].join('');
var else$ = ["__else_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orcl.utils.sha.call(null,new cljs.core.Keyword(null,"else","else",-1508377146).cljs$core$IFn$_invoke$arity$1(ast)))].join('');
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"node","node",581201198),new cljs.core.Keyword(null,"declaration","declaration",-1819933768),new cljs.core.Keyword(null,"decl","decl",-1498869485),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"def","def",-1043430536),new cljs.core.Keyword(null,"name","name",1843675177),then,new cljs.core.Keyword(null,"params","params",710516235),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.Keyword(null,"then","then",460598070).cljs$core$IFn$_invoke$arity$1(ast)], null),new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"node","node",581201198),new cljs.core.Keyword(null,"declaration","declaration",-1819933768),new cljs.core.Keyword(null,"decl","decl",-1498869485),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"def","def",-1043430536),new cljs.core.Keyword(null,"name","name",1843675177),else$,new cljs.core.Keyword(null,"params","params",710516235),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.Keyword(null,"else","else",-1508377146).cljs$core$IFn$_invoke$arity$1(ast)], null),new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"node","node",581201198),new cljs.core.Keyword(null,"sequential","sequential",-1082983960),new cljs.core.Keyword(null,"pattern","pattern",242135423),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"var","var",-769682797),new cljs.core.Keyword(null,"var","var",-769682797),v], null),new cljs.core.Keyword(null,"left","left",-399115937),new cljs.core.Keyword(null,"if","if",-458814265).cljs$core$IFn$_invoke$arity$1(ast),new cljs.core.Keyword(null,"right","right",-452581833),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"node","node",581201198),new cljs.core.Keyword(null,"normalized-conditional","normalized-conditional",-1179416019),new cljs.core.Keyword(null,"if","if",-458814265),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"node","node",581201198),new cljs.core.Keyword(null,"var","var",-769682797),new cljs.core.Keyword(null,"var","var",-769682797),v], null),new cljs.core.Keyword(null,"then","then",460598070),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"node","node",581201198),new cljs.core.Keyword(null,"var","var",-769682797),new cljs.core.Keyword(null,"var","var",-769682797),then], null),new cljs.core.Keyword(null,"else","else",-1508377146),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"node","node",581201198),new cljs.core.Keyword(null,"var","var",-769682797),new cljs.core.Keyword(null,"var","var",-769682797),else$], null)], null)], null)], null)], null);

break;
default:
return ast;

}
});
orcl.analyzer.normalize = (function orcl$analyzer$normalize(ast){
return orcl.utils.ast_prewalk.call(null,orcl.analyzer.normalize_STAR_,ast);
});
orcl.analyzer.with_sha = (function orcl$analyzer$with_sha(ast){
return orcl.utils.ast_postwalk.call(null,orcl.utils.with_sha,ast);
});
orcl.analyzer.flatten_def = (function orcl$analyzer$flatten_def(var_args){
var G__42485 = arguments.length;
switch (G__42485) {
case 1:
return orcl.analyzer.flatten_def.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return orcl.analyzer.flatten_def.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

orcl.analyzer.flatten_def.cljs$core$IFn$_invoke$arity$1 = (function (ast){
return orcl.analyzer.flatten_def.call(null,ast,cljs.core.PersistentVector.EMPTY);
});

orcl.analyzer.flatten_def.cljs$core$IFn$_invoke$arity$2 = (function (ast,acc){
if((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"declaration","declaration",-1819933768),new cljs.core.Keyword(null,"node","node",581201198).cljs$core$IFn$_invoke$arity$1(ast))) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"def","def",-1043430536),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"decl","decl",-1498869485).cljs$core$IFn$_invoke$arity$1(ast))))){
return orcl.analyzer.flatten_def.call(null,new cljs.core.Keyword(null,"expr","expr",745722291).cljs$core$IFn$_invoke$arity$1(ast),cljs.core.conj.call(null,acc,new cljs.core.Keyword(null,"decl","decl",-1498869485).cljs$core$IFn$_invoke$arity$1(ast)));
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ast,acc], null);
}
});

orcl.analyzer.flatten_def.cljs$lang$maxFixedArity = 2;

orcl.analyzer.analyze_instance = (function orcl$analyzer$analyze_instance(id,instance){
var argument_envs = (function (i,p){
return cljs.core.map.call(null,(function (binding){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [binding,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"argument","argument",1183001841),new cljs.core.Keyword(null,"position","position",-2011731912),i,new cljs.core.Keyword(null,"instance-sha","instance-sha",51010913),new cljs.core.Keyword(null,"sha","sha",-950317251).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(instance)),new cljs.core.Keyword(null,"id","id",-1388402092),id], null)], null);
}),orcl.analyzer.patterns.pattern_bindings.call(null,p));
});
var _STAR_env_STAR_42487 = orcl.analyzer.vars._STAR_env_STAR_;
orcl.analyzer.vars._STAR_env_STAR_ = cljs.core.merge.call(null,orcl.analyzer.vars._STAR_env_STAR_,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.mapcat.call(null,argument_envs,cljs.core.range.call(null),new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(instance))));

try{var _STAR_tail_pos_STAR_42488 = orcl.analyzer._STAR_tail_pos_STAR_;
orcl.analyzer._STAR_tail_pos_STAR_ = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",-1388402092),id], null);

try{return cljs.core.assoc.call(null,cljs.core.update.call(null,instance,new cljs.core.Keyword(null,"body","body",-2049205669),orcl.analyzer.analyze_env),new cljs.core.Keyword(null,"node","node",581201198),new cljs.core.Keyword(null,"def-instance","def-instance",1087585554));
}finally {orcl.analyzer._STAR_tail_pos_STAR_ = _STAR_tail_pos_STAR_42488;
}}finally {orcl.analyzer.vars._STAR_env_STAR_ = _STAR_env_STAR_42487;
}});
orcl.analyzer.analyze_def_STAR_ = (function orcl$analyzer$analyze_def_STAR_(defs_in_group,p__42489){
var vec__42490 = p__42489;
var n = cljs.core.nth.call(null,vec__42490,(0),null);
var instances = cljs.core.nth.call(null,vec__42490,(1),null);
var _STAR_env_STAR_42493 = orcl.analyzer.vars._STAR_env_STAR_;
orcl.analyzer.vars._STAR_env_STAR_ = cljs.core.merge.call(null,orcl.analyzer.vars._STAR_env_STAR_,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__28797__auto__ = ((function (_STAR_env_STAR_42493,vec__42490,n,instances){
return (function orcl$analyzer$analyze_def_STAR__$_iter__42494(s__42495){
return (new cljs.core.LazySeq(null,((function (_STAR_env_STAR_42493,vec__42490,n,instances){
return (function (){
var s__42495__$1 = s__42495;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__42495__$1);
if(temp__4657__auto__){
var s__42495__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__42495__$2)){
var c__28795__auto__ = cljs.core.chunk_first.call(null,s__42495__$2);
var size__28796__auto__ = cljs.core.count.call(null,c__28795__auto__);
var b__42497 = cljs.core.chunk_buffer.call(null,size__28796__auto__);
if((function (){var i__42496 = (0);
while(true){
if((i__42496 < size__28796__auto__)){
var vec__42498 = cljs.core._nth.call(null,c__28795__auto__,i__42496);
var _ = cljs.core.nth.call(null,vec__42498,(0),null);
var map__42501 = cljs.core.nth.call(null,vec__42498,(1),null);
var map__42501__$1 = ((((!((map__42501 == null)))?((((map__42501.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42501.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42501):map__42501);
var name = cljs.core.get.call(null,map__42501__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var usages = cljs.core.get.call(null,map__42501__$1,new cljs.core.Keyword(null,"usages","usages",-1094756749));
var node = cljs.core.get.call(null,map__42501__$1,new cljs.core.Keyword(null,"node","node",581201198));
cljs.core.chunk_append.call(null,b__42497,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [name,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"def","def",-1043430536),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sha","sha",-950317251).cljs$core$IFn$_invoke$arity$1(node),new cljs.core.Keyword(null,"usages","usages",-1094756749),usages], null)], null));

var G__42508 = (i__42496 + (1));
i__42496 = G__42508;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__42497),orcl$analyzer$analyze_def_STAR__$_iter__42494.call(null,cljs.core.chunk_rest.call(null,s__42495__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__42497),null);
}
} else {
var vec__42503 = cljs.core.first.call(null,s__42495__$2);
var _ = cljs.core.nth.call(null,vec__42503,(0),null);
var map__42506 = cljs.core.nth.call(null,vec__42503,(1),null);
var map__42506__$1 = ((((!((map__42506 == null)))?((((map__42506.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42506.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42506):map__42506);
var name = cljs.core.get.call(null,map__42506__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var usages = cljs.core.get.call(null,map__42506__$1,new cljs.core.Keyword(null,"usages","usages",-1094756749));
var node = cljs.core.get.call(null,map__42506__$1,new cljs.core.Keyword(null,"node","node",581201198));
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [name,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"def","def",-1043430536),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sha","sha",-950317251).cljs$core$IFn$_invoke$arity$1(node),new cljs.core.Keyword(null,"usages","usages",-1094756749),usages], null)], null),orcl$analyzer$analyze_def_STAR__$_iter__42494.call(null,cljs.core.rest.call(null,s__42495__$2)));
}
} else {
return null;
}
break;
}
});})(_STAR_env_STAR_42493,vec__42490,n,instances))
,null,null));
});})(_STAR_env_STAR_42493,vec__42490,n,instances))
;
return iter__28797__auto__.call(null,defs_in_group);
})()));

try{return cljs.core.assoc.call(null,cljs.core.get_in.call(null,defs_in_group,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [n,new cljs.core.Keyword(null,"node","node",581201198)], null)),new cljs.core.Keyword(null,"usages","usages",-1094756749),cljs.core.get_in.call(null,defs_in_group,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [n,new cljs.core.Keyword(null,"usages","usages",-1094756749)], null)),new cljs.core.Keyword(null,"arity","arity",-1808556135),cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,instances))),new cljs.core.Keyword(null,"instances","instances",-335364781),cljs.core.mapv.call(null,cljs.core.partial.call(null,orcl.analyzer.analyze_instance,cljs.core.get_in.call(null,defs_in_group,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [n,new cljs.core.Keyword(null,"node","node",581201198),new cljs.core.Keyword(null,"sha","sha",-950317251)], null))),instances));
}finally {orcl.analyzer.vars._STAR_env_STAR_ = _STAR_env_STAR_42493;
}});
orcl.analyzer.analyze_defs = (function orcl$analyzer$analyze_defs(ast){
var vec__42509 = orcl.analyzer.flatten_def.call(null,ast);
var ast_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__42509,(0),null);
var def_instances = cljs.core.nth.call(null,vec__42509,(1),null);
var grouped = cljs.core.group_by.call(null,new cljs.core.Keyword(null,"name","name",1843675177),def_instances);
var defs_in_group = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,((function (vec__42509,ast_SINGLEQUOTE_,def_instances,grouped){
return (function (p__42512){
var vec__42513 = p__42512;
var n = cljs.core.nth.call(null,vec__42513,(0),null);
var instances = cljs.core.nth.call(null,vec__42513,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [n,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),n,new cljs.core.Keyword(null,"usages","usages",-1094756749),cljs.core.atom.call(null,(0)),new cljs.core.Keyword(null,"node","node",581201198),orcl.utils.with_sha.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"node","node",581201198),new cljs.core.Keyword(null,"def","def",-1043430536),new cljs.core.Keyword(null,"name","name",1843675177),n,new cljs.core.Keyword(null,"instances","instances",-335364781),instances], null))], null)], null);
});})(vec__42509,ast_SINGLEQUOTE_,def_instances,grouped))
,grouped));
var defs = cljs.core.map.call(null,cljs.core.partial.call(null,orcl.analyzer.analyze_def_STAR_,defs_in_group),grouped);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ast_SINGLEQUOTE_,defs], null);
});
orcl.analyzer.check_call_BANG_ = (function orcl$analyzer$check_call_BANG_(call){
return null;
});
orcl.analyzer.analyze_env = (function orcl$analyzer$analyze_env(ast){
var G__42516 = new cljs.core.Keyword(null,"node","node",581201198).cljs$core$IFn$_invoke$arity$1(ast);
var G__42516__$1 = (((G__42516 instanceof cljs.core.Keyword))?G__42516.fqn:null);
switch (G__42516__$1) {
case "pruning":
return cljs.core.assoc.call(null,ast,new cljs.core.Keyword(null,"left","left",-399115937),(function (){var _STAR_env_STAR_42517 = orcl.analyzer.vars._STAR_env_STAR_;
orcl.analyzer.vars._STAR_env_STAR_ = cljs.core.merge.call(null,orcl.analyzer.vars._STAR_env_STAR_,orcl.analyzer.patterns.pattern_envs.call(null,new cljs.core.Keyword(null,"pattern","pattern",242135423).cljs$core$IFn$_invoke$arity$1(ast),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pruning","pruning",-1224456546),new cljs.core.Keyword(null,"node-sha","node-sha",-418411289),new cljs.core.Keyword(null,"sha","sha",-950317251).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"right","right",-452581833).cljs$core$IFn$_invoke$arity$1(ast))], null)));

try{return orcl.analyzer.analyze_env.call(null,new cljs.core.Keyword(null,"left","left",-399115937).cljs$core$IFn$_invoke$arity$1(ast));
}finally {orcl.analyzer.vars._STAR_env_STAR_ = _STAR_env_STAR_42517;
}})(),new cljs.core.Keyword(null,"right","right",-452581833),(function (){var _STAR_tail_pos_STAR_42518 = orcl.analyzer._STAR_tail_pos_STAR_;
orcl.analyzer._STAR_tail_pos_STAR_ = null;

try{return orcl.analyzer.analyze_env.call(null,new cljs.core.Keyword(null,"right","right",-452581833).cljs$core$IFn$_invoke$arity$1(ast));
}finally {orcl.analyzer._STAR_tail_pos_STAR_ = _STAR_tail_pos_STAR_42518;
}})());

break;
case "sequential":
return cljs.core.assoc.call(null,ast,new cljs.core.Keyword(null,"right","right",-452581833),(function (){var _STAR_env_STAR_42519 = orcl.analyzer.vars._STAR_env_STAR_;
orcl.analyzer.vars._STAR_env_STAR_ = cljs.core.merge.call(null,orcl.analyzer.vars._STAR_env_STAR_,orcl.analyzer.patterns.pattern_envs.call(null,new cljs.core.Keyword(null,"pattern","pattern",242135423).cljs$core$IFn$_invoke$arity$1(ast),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"sequential","sequential",-1082983960),new cljs.core.Keyword(null,"node-sha","node-sha",-418411289),new cljs.core.Keyword(null,"sha","sha",-950317251).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"left","left",-399115937).cljs$core$IFn$_invoke$arity$1(ast))], null)));

try{return orcl.analyzer.analyze_env.call(null,new cljs.core.Keyword(null,"right","right",-452581833).cljs$core$IFn$_invoke$arity$1(ast));
}finally {orcl.analyzer.vars._STAR_env_STAR_ = _STAR_env_STAR_42519;
}})(),new cljs.core.Keyword(null,"left","left",-399115937),(function (){var _STAR_tail_pos_STAR_42520 = orcl.analyzer._STAR_tail_pos_STAR_;
orcl.analyzer._STAR_tail_pos_STAR_ = null;

try{return orcl.analyzer.analyze_env.call(null,new cljs.core.Keyword(null,"left","left",-399115937).cljs$core$IFn$_invoke$arity$1(ast));
}finally {orcl.analyzer._STAR_tail_pos_STAR_ = _STAR_tail_pos_STAR_42520;
}})());

break;
case "otherwise":
return cljs.core.assoc.call(null,ast,new cljs.core.Keyword(null,"right","right",-452581833),orcl.analyzer.analyze_env.call(null,new cljs.core.Keyword(null,"right","right",-452581833).cljs$core$IFn$_invoke$arity$1(ast)),new cljs.core.Keyword(null,"left","left",-399115937),(function (){var _STAR_tail_pos_STAR_42521 = orcl.analyzer._STAR_tail_pos_STAR_;
orcl.analyzer._STAR_tail_pos_STAR_ = null;

try{return orcl.analyzer.analyze_env.call(null,new cljs.core.Keyword(null,"left","left",-399115937).cljs$core$IFn$_invoke$arity$1(ast));
}finally {orcl.analyzer._STAR_tail_pos_STAR_ = _STAR_tail_pos_STAR_42521;
}})());

break;
case "declaration":
var decl = new cljs.core.Keyword(null,"decl","decl",-1498869485).cljs$core$IFn$_invoke$arity$1(ast);
var G__42522 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(decl);
var G__42522__$1 = (((G__42522 instanceof cljs.core.Keyword))?G__42522.fqn:null);
switch (G__42522__$1) {
case "site":
var _STAR_env_STAR_42523 = orcl.analyzer.vars._STAR_env_STAR_;
orcl.analyzer.vars._STAR_env_STAR_ = cljs.core.assoc.call(null,orcl.analyzer.vars._STAR_env_STAR_,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(decl),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"site","site",-1852581499),new cljs.core.Keyword(null,"source","source",-433931539),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"import","import",-1399500709),new cljs.core.Keyword(null,"pos","pos",-864607220),new cljs.core.Keyword(null,"pos","pos",-864607220).cljs$core$IFn$_invoke$arity$1(decl)], null),new cljs.core.Keyword(null,"definition","definition",-1198729982),new cljs.core.Keyword(null,"definition","definition",-1198729982).cljs$core$IFn$_invoke$arity$1(decl)], null));

try{return orcl.analyzer.analyze_env.call(null,new cljs.core.Keyword(null,"expr","expr",745722291).cljs$core$IFn$_invoke$arity$1(ast));
}finally {orcl.analyzer.vars._STAR_env_STAR_ = _STAR_env_STAR_42523;
}
break;
case "def":
var vec__42524 = orcl.analyzer.analyze_defs.call(null,ast);
var ast_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__42524,(0),null);
var defs = cljs.core.nth.call(null,vec__42524,(1),null);
var _STAR_env_STAR_42527 = orcl.analyzer.vars._STAR_env_STAR_;
orcl.analyzer.vars._STAR_env_STAR_ = cljs.core.merge.call(null,orcl.analyzer.vars._STAR_env_STAR_,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__28797__auto__ = ((function (_STAR_env_STAR_42527,vec__42524,ast_SINGLEQUOTE_,defs,G__42522,G__42522__$1,decl,G__42516,G__42516__$1){
return (function orcl$analyzer$analyze_env_$_iter__42528(s__42529){
return (new cljs.core.LazySeq(null,((function (_STAR_env_STAR_42527,vec__42524,ast_SINGLEQUOTE_,defs,G__42522,G__42522__$1,decl,G__42516,G__42516__$1){
return (function (){
var s__42529__$1 = s__42529;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__42529__$1);
if(temp__4657__auto__){
var s__42529__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__42529__$2)){
var c__28795__auto__ = cljs.core.chunk_first.call(null,s__42529__$2);
var size__28796__auto__ = cljs.core.count.call(null,c__28795__auto__);
var b__42531 = cljs.core.chunk_buffer.call(null,size__28796__auto__);
if((function (){var i__42530 = (0);
while(true){
if((i__42530 < size__28796__auto__)){
var map__42532 = cljs.core._nth.call(null,c__28795__auto__,i__42530);
var map__42532__$1 = ((((!((map__42532 == null)))?((((map__42532.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42532.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42532):map__42532);
var name = cljs.core.get.call(null,map__42532__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var sha = cljs.core.get.call(null,map__42532__$1,new cljs.core.Keyword(null,"sha","sha",-950317251));
var usages = cljs.core.get.call(null,map__42532__$1,new cljs.core.Keyword(null,"usages","usages",-1094756749));
cljs.core.chunk_append.call(null,b__42531,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [name,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"def","def",-1043430536),new cljs.core.Keyword(null,"id","id",-1388402092),sha,new cljs.core.Keyword(null,"usages","usages",-1094756749),usages], null)], null));

var G__42538 = (i__42530 + (1));
i__42530 = G__42538;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__42531),orcl$analyzer$analyze_env_$_iter__42528.call(null,cljs.core.chunk_rest.call(null,s__42529__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__42531),null);
}
} else {
var map__42534 = cljs.core.first.call(null,s__42529__$2);
var map__42534__$1 = ((((!((map__42534 == null)))?((((map__42534.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42534.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42534):map__42534);
var name = cljs.core.get.call(null,map__42534__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var sha = cljs.core.get.call(null,map__42534__$1,new cljs.core.Keyword(null,"sha","sha",-950317251));
var usages = cljs.core.get.call(null,map__42534__$1,new cljs.core.Keyword(null,"usages","usages",-1094756749));
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [name,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"def","def",-1043430536),new cljs.core.Keyword(null,"id","id",-1388402092),sha,new cljs.core.Keyword(null,"usages","usages",-1094756749),usages], null)], null),orcl$analyzer$analyze_env_$_iter__42528.call(null,cljs.core.rest.call(null,s__42529__$2)));
}
} else {
return null;
}
break;
}
});})(_STAR_env_STAR_42527,vec__42524,ast_SINGLEQUOTE_,defs,G__42522,G__42522__$1,decl,G__42516,G__42516__$1))
,null,null));
});})(_STAR_env_STAR_42527,vec__42524,ast_SINGLEQUOTE_,defs,G__42522,G__42522__$1,decl,G__42516,G__42516__$1))
;
return iter__28797__auto__.call(null,defs);
})()));

try{return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"node","node",581201198),new cljs.core.Keyword(null,"defs-group","defs-group",-1605838115),new cljs.core.Keyword(null,"defs","defs",1398449717),defs,new cljs.core.Keyword(null,"expr","expr",745722291),orcl.analyzer.analyze_env.call(null,ast_SINGLEQUOTE_)], null);
}finally {orcl.analyzer.vars._STAR_env_STAR_ = _STAR_env_STAR_42527;
}
break;
case "def-sig":
return orcl.analyzer.analyze_env.call(null,new cljs.core.Keyword(null,"expr","expr",745722291).cljs$core$IFn$_invoke$arity$1(ast));

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__42522__$1)].join('')));

}

break;
case "call":
var ast_SINGLEQUOTE_ = cljs.core.assoc.call(null,cljs.core.update.call(null,ast,new cljs.core.Keyword(null,"target","target",253001721),orcl.analyzer.analyze_env),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.mapv.call(null,orcl.analyzer.analyze_env,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(ast)));
orcl.analyzer.check_call_BANG_.call(null,ast_SINGLEQUOTE_);

var s = cljs.core.get_in.call(null,ast_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"target","target",253001721),new cljs.core.Keyword(null,"source","source",-433931539)], null));
if(cljs.core.truth_((function (){var and__27977__auto__ = orcl.analyzer._STAR_tail_pos_STAR_;
if(cljs.core.truth_(and__27977__auto__)){
return (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"def","def",-1043430536),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(s))) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(s),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(orcl.analyzer._STAR_tail_pos_STAR_)));
} else {
return and__27977__auto__;
}
})())){
return cljs.core.assoc.call(null,ast_SINGLEQUOTE_,new cljs.core.Keyword(null,"tail-pos","tail-pos",1500172733),orcl.analyzer._STAR_tail_pos_STAR_);
} else {
return ast_SINGLEQUOTE_;
}

break;
case "var":
var temp__4655__auto__ = cljs.core.get.call(null,orcl.analyzer.vars._STAR_env_STAR_,new cljs.core.Keyword(null,"var","var",-769682797).cljs$core$IFn$_invoke$arity$1(ast));
if(cljs.core.truth_(temp__4655__auto__)){
var source = temp__4655__auto__;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"def","def",-1043430536),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(source))){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"usages","usages",-1094756749).cljs$core$IFn$_invoke$arity$1(source),cljs.core.inc);
} else {
}

return cljs.core.assoc.call(null,ast,new cljs.core.Keyword(null,"source","source",-433931539),cljs.core.dissoc.call(null,source,new cljs.core.Keyword(null,"usages","usages",-1094756749)));
} else {
throw cljs.core.ex_info.call(null,"Undefined variable",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("orcl","error-pos","orcl/error-pos",-459808101),new cljs.core.Keyword(null,"pos","pos",-864607220).cljs$core$IFn$_invoke$arity$1(ast),new cljs.core.Keyword("orcl","error","orcl/error",-985000796),"Undefined variable"], null));
}

break;
default:
return orcl.utils.ast_walk.call(null,orcl.analyzer.analyze_env,cljs.core.identity,ast);

}
});
orcl.analyzer.analyze_stage2 = (function orcl$analyzer$analyze_stage2(ast){
var set_locals = (function (ast__$1){
return cljs.core.assoc.call(null,ast__$1,new cljs.core.Keyword(null,"locals","locals",535295783),(function (){var G__42540 = new cljs.core.Keyword(null,"node","node",581201198).cljs$core$IFn$_invoke$arity$1(ast__$1);
var G__42540__$1 = (((G__42540 instanceof cljs.core.Keyword))?G__42540.fqn:null);
switch (G__42540__$1) {
case "otherwise":
case "parallel":
return clojure.set.union.call(null,new cljs.core.Keyword(null,"locals","locals",535295783).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"left","left",-399115937).cljs$core$IFn$_invoke$arity$1(ast__$1)),new cljs.core.Keyword(null,"locals","locals",535295783).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"right","right",-452581833).cljs$core$IFn$_invoke$arity$1(ast__$1)));

break;
case "sequential":
case "pruning":
return clojure.set.difference.call(null,clojure.set.union.call(null,new cljs.core.Keyword(null,"locals","locals",535295783).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"left","left",-399115937).cljs$core$IFn$_invoke$arity$1(ast__$1)),new cljs.core.Keyword(null,"locals","locals",535295783).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"right","right",-452581833).cljs$core$IFn$_invoke$arity$1(ast__$1))),orcl.analyzer.patterns.pattern_bindings.call(null,new cljs.core.Keyword(null,"pattern","pattern",242135423).cljs$core$IFn$_invoke$arity$1(ast__$1)));

break;
case "normalized-conditional":
return clojure.set.union.call(null,new cljs.core.Keyword(null,"locals","locals",535295783).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"var","var",-769682797).cljs$core$IFn$_invoke$arity$1(ast__$1)),new cljs.core.Keyword(null,"locals","locals",535295783).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"then","then",460598070).cljs$core$IFn$_invoke$arity$1(ast__$1)),new cljs.core.Keyword(null,"locals","locals",535295783).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"else","else",-1508377146).cljs$core$IFn$_invoke$arity$1(ast__$1)));

break;
case "field-access":
case "call":
return cljs.core.apply.call(null,clojure.set.union,cljs.core.get_in.call(null,ast__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"target","target",253001721),new cljs.core.Keyword(null,"locals","locals",535295783)], null)),cljs.core.map.call(null,new cljs.core.Keyword(null,"locals","locals",535295783),new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(ast__$1)));

break;
case "tuple":
case "list":
return cljs.core.apply.call(null,clojure.set.union,cljs.core.map.call(null,new cljs.core.Keyword(null,"locals","locals",535295783),new cljs.core.Keyword(null,"values","values",372645556).cljs$core$IFn$_invoke$arity$1(ast__$1)));

break;
case "record":
return cljs.core.apply.call(null,clojure.set.union,cljs.core.map.call(null,cljs.core.comp.call(null,new cljs.core.Keyword(null,"locals","locals",535295783),cljs.core.second),new cljs.core.Keyword(null,"pairs","pairs",614609779).cljs$core$IFn$_invoke$arity$1(ast__$1)));

break;
case "var":
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"site","site",-1852581499),null,new cljs.core.Keyword(null,"def","def",-1043430536),null], null), null).call(null,cljs.core.get_in.call(null,ast__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source","source",-433931539),new cljs.core.Keyword(null,"type","type",1174270348)], null))))){
return cljs.core.PersistentHashSet.EMPTY;
} else {
return cljs.core.PersistentHashSet.createAsIfByAssoc([new cljs.core.Keyword(null,"var","var",-769682797).cljs$core$IFn$_invoke$arity$1(ast__$1)]);
}

break;
case "defs-group":
return cljs.core.set.call(null,cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"locals","locals",535295783),new cljs.core.Keyword(null,"defs","defs",1398449717).cljs$core$IFn$_invoke$arity$1(ast__$1)));

break;
case "def":
return cljs.core.set.call(null,cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"locals","locals",535295783),new cljs.core.Keyword(null,"instances","instances",-335364781).cljs$core$IFn$_invoke$arity$1(ast__$1)));

break;
case "def-instance":
return cljs.core.apply.call(null,clojure.set.difference,new cljs.core.Keyword(null,"locals","locals",535295783).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(ast__$1)),cljs.core.map.call(null,orcl.analyzer.patterns.pattern_bindings,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(ast__$1)));

break;
case "const":
case "stop":
return cljs.core.PersistentHashSet.EMPTY;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__42540__$1)].join('')));

}
})());
});
var remove_unused = ((function (set_locals){
return (function (ast__$1){
var G__42541 = new cljs.core.Keyword(null,"node","node",581201198).cljs$core$IFn$_invoke$arity$1(ast__$1);
var G__42541__$1 = (((G__42541 instanceof cljs.core.Keyword))?G__42541.fqn:null);
switch (G__42541__$1) {
case "def":
return cljs.core.update.call(null,ast__$1,new cljs.core.Keyword(null,"usages","usages",-1094756749),cljs.core.deref);

break;
case "defs-group":
var in_use = cljs.core.filterv.call(null,((function (G__42541,G__42541__$1,set_locals){
return (function (p1__42539_SHARP_){
return (new cljs.core.Keyword(null,"usages","usages",-1094756749).cljs$core$IFn$_invoke$arity$1(p1__42539_SHARP_) > (0));
});})(G__42541,G__42541__$1,set_locals))
,new cljs.core.Keyword(null,"defs","defs",1398449717).cljs$core$IFn$_invoke$arity$1(ast__$1));
if(cljs.core.truth_(cljs.core.not_empty.call(null,in_use))){
return cljs.core.assoc.call(null,ast__$1,new cljs.core.Keyword(null,"defs","defs",1398449717),in_use);
} else {
return new cljs.core.Keyword(null,"expr","expr",745722291).cljs$core$IFn$_invoke$arity$1(ast__$1);
}

break;
default:
return ast__$1;

}
});})(set_locals))
;
return orcl.utils.ast_postwalk.call(null,cljs.core.comp.call(null,set_locals,remove_unused),ast);
});
orcl.analyzer.analyze_final = (function orcl$analyzer$analyze_final(var_args){
var G__42545 = arguments.length;
switch (G__42545) {
case 1:
return orcl.analyzer.analyze_final.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return orcl.analyzer.analyze_final.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

orcl.analyzer.analyze_final.cljs$core$IFn$_invoke$arity$1 = (function (ast){
return orcl.analyzer.analyze_final.call(null,ast,cljs.core.PersistentArrayMap.EMPTY);
});

orcl.analyzer.analyze_final.cljs$core$IFn$_invoke$arity$2 = (function (ast,env){
var _STAR_env_STAR_42546 = orcl.analyzer.vars._STAR_env_STAR_;
var _STAR_tail_pos_STAR_42547 = orcl.analyzer._STAR_tail_pos_STAR_;
orcl.analyzer.vars._STAR_env_STAR_ = env;

orcl.analyzer._STAR_tail_pos_STAR_ = null;

try{var ast_SINGLEQUOTE_ = orcl.analyzer.analyze_env.call(null,ast);
return orcl.analyzer.analyze_stage2.call(null,ast_SINGLEQUOTE_);
}finally {orcl.analyzer._STAR_tail_pos_STAR_ = _STAR_tail_pos_STAR_42547;

orcl.analyzer.vars._STAR_env_STAR_ = _STAR_env_STAR_42546;
}});

orcl.analyzer.analyze_final.cljs$lang$maxFixedArity = 2;

orcl.analyzer.analyze = (function orcl$analyzer$analyze(var_args){
var G__42550 = arguments.length;
switch (G__42550) {
case 1:
return orcl.analyzer.analyze.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return orcl.analyzer.analyze.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

orcl.analyzer.analyze.cljs$core$IFn$_invoke$arity$1 = (function (ast){
return orcl.analyzer.analyze_final.call(null,orcl.analyzer.with_sha.call(null,orcl.analyzer.normalize.call(null,ast)));
});

orcl.analyzer.analyze.cljs$core$IFn$_invoke$arity$2 = (function (ast,env){
return orcl.analyzer.analyze_final.call(null,orcl.analyzer.with_sha.call(null,orcl.analyzer.normalize.call(null,ast)),env);
});

orcl.analyzer.analyze.cljs$lang$maxFixedArity = 2;


//# sourceMappingURL=analyzer.js.map?rel=1503590939034
