(ns orcl.naive.macro
  (:require [orcl.naive.vars :as vars]))

(defmacro with-counter [binding & body]
  `(let [~binding @(:counter vars/*state*)
         res# (do ~@body)]
     (swap! (:counter vars/*state*) inc)
     res#))

(defmacro defsite [n f]
  `(do
     (def ~n ~f)
     (swap! vars/prelude assoc ~(get (meta n) :site (str n)) ~n)))

(defmacro sfn [bindings & body]
  `(fn [~@bindings]
     (let [res# (try
                 ~@body
                 (catch Exception e#
                   ;; FIXME
                   (prn "Site exception" e#)
                   :orcl.naive.impl/halt))]
       (if (= :orcl.naive.impl/halt res#)
         nil
         [res#]))))