// Compiled by ClojureScript 1.9.908 {}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.call(null,(function (m,p__32495){
var vec__32496 = p__32495;
var i = cljs.core.nth.call(null,vec__32496,(0),null);
var v = cljs.core.nth.call(null,vec__32496,(1),null);
return cljs.core.assoc.call(null,m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.call(null,(function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources.call(null,sources);
return ((function (sources__$1){
return (function (a,b){
return cljs.core.compare.call(null,sources__$1.call(null,a),sources__$1.call(null,b));
});
;})(sources__$1))
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__32499 = seg;
var gcol = cljs.core.nth.call(null,vec__32499,(0),null);
var source = cljs.core.nth.call(null,vec__32499,(1),null);
var line = cljs.core.nth.call(null,vec__32499,(2),null);
var col = cljs.core.nth.call(null,vec__32499,(3),null);
var name = cljs.core.nth.call(null,vec__32499,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__4657__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,seg));
if(cljs.core.truth_(temp__4657__auto__)){
var name__$1 = temp__4657__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__32502 = seg;
var gcol = cljs.core.nth.call(null,vec__32502,(0),null);
var source = cljs.core.nth.call(null,vec__32502,(1),null);
var line = cljs.core.nth.call(null,vec__32502,(2),null);
var col = cljs.core.nth.call(null,vec__32502,(3),null);
var name = cljs.core.nth.call(null,vec__32502,(4),null);
var vec__32505 = relseg;
var rgcol = cljs.core.nth.call(null,vec__32505,(0),null);
var rsource = cljs.core.nth.call(null,vec__32505,(1),null);
var rline = cljs.core.nth.call(null,vec__32505,(2),null);
var rcol = cljs.core.nth.call(null,vec__32505,(3),null);
var rname = cljs.core.nth.call(null,vec__32505,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__27989__auto__ = source;
if(cljs.core.truth_(or__27989__auto__)){
return or__27989__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__27989__auto__ = line;
if(cljs.core.truth_(or__27989__auto__)){
return or__27989__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__27989__auto__ = col;
if(cljs.core.truth_(or__27989__auto__)){
return or__27989__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__27989__auto__ = name;
if(cljs.core.truth_(or__27989__auto__)){
return or__27989__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta.call(null,nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__32508 = segmap;
var map__32508__$1 = ((((!((map__32508 == null)))?((((map__32508.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32508.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32508):map__32508);
var gcol = cljs.core.get.call(null,map__32508__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.call(null,map__32508__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.call(null,map__32508__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.call(null,map__32508__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.call(null,map__32508__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.call(null,d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.call(null,((function (map__32508,map__32508__$1,gcol,source,line,col,name,d,d__$1){
return (function (m){
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.call(null,((function (map__32508,map__32508__$1,gcol,source,line,col,name,d,d__$1){
return (function (m__$1){
return cljs.core.update_in.call(null,m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.call(null,((function (map__32508,map__32508__$1,gcol,source,line,col,name,d,d__$1){
return (function (v){
return cljs.core.conj.call(null,v,d__$1);
});})(map__32508,map__32508__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.PersistentVector.EMPTY));
});})(map__32508,map__32508__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.sorted_map.call(null)));
});})(map__32508,map__32508__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.sorted_map.call(null)));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__32511 = arguments.length;
switch (G__32511) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.call(null,goog.object.get(source_map,"mappings"),source_map);
});

cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq.call(null,clojure.string.split.call(null,mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by.call(null,cljs.source_map.source_compare.call(null,sources));
while(true){
if(lines__$1){
var line = cljs.core.first.call(null,lines__$1);
var vec__32512 = ((clojure.string.blank_QMARK_.call(null,line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq.call(null,clojure.string.split.call(null,line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first.call(null,segs__$1);
var nrelseg = cljs.source_map.seg_combine.call(null,cljs.source_map.base64_vlq.decode.call(null,seg),relseg__$1);
var G__32516 = cljs.core.next.call(null,segs__$1);
var G__32517 = nrelseg;
var G__32518 = cljs.source_map.update_reverse_result.call(null,result__$1,cljs.source_map.seg__GT_map.call(null,nrelseg,source_map),gline);
segs__$1 = G__32516;
relseg__$1 = G__32517;
result__$1 = G__32518;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.call(null,vec__32512,(0),null);
var relseg__$1 = cljs.core.nth.call(null,vec__32512,(1),null);
var G__32519 = (gline + (1));
var G__32520 = cljs.core.next.call(null,lines__$1);
var G__32521 = cljs.core.assoc.call(null,relseg__$1,(0),(0));
var G__32522 = result__$1;
gline = G__32519;
lines__$1 = G__32520;
relseg = G__32521;
result = G__32522;
continue;
} else {
return result;
}
break;
}
});

cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2;

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__32524 = segmap;
var map__32524__$1 = ((((!((map__32524 == null)))?((((map__32524.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32524.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32524):map__32524);
var gcol = cljs.core.get.call(null,map__32524__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.call(null,map__32524__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.call(null,map__32524__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.call(null,map__32524__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.call(null,map__32524__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.call(null,d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.call(null,((function (map__32524,map__32524__$1,gcol,source,line,col,name,d,d__$1){
return (function (m){
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.call(null,((function (map__32524,map__32524__$1,gcol,source,line,col,name,d,d__$1){
return (function (p1__32523_SHARP_){
return cljs.core.conj.call(null,p1__32523_SHARP_,d__$1);
});})(map__32524,map__32524__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.PersistentVector.EMPTY));
});})(map__32524,map__32524__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.sorted_map.call(null)));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__32527 = arguments.length;
switch (G__32527) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.call(null,goog.object.get(source_map,"mappings"),source_map);
});

cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq.call(null,clojure.string.split.call(null,mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first.call(null,lines__$1);
var vec__32528 = ((clojure.string.blank_QMARK_.call(null,line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq.call(null,clojure.string.split.call(null,line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first.call(null,segs__$1);
var nrelseg = cljs.source_map.seg_combine.call(null,cljs.source_map.base64_vlq.decode.call(null,seg),relseg__$1);
var G__32532 = cljs.core.next.call(null,segs__$1);
var G__32533 = nrelseg;
var G__32534 = cljs.source_map.update_result.call(null,result__$1,cljs.source_map.seg__GT_map.call(null,nrelseg,source_map),gline);
segs__$1 = G__32532;
relseg__$1 = G__32533;
result__$1 = G__32534;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.call(null,vec__32528,(0),null);
var relseg__$1 = cljs.core.nth.call(null,vec__32528,(1),null);
var G__32535 = (gline + (1));
var G__32536 = cljs.core.next.call(null,lines__$1);
var G__32537 = cljs.core.assoc.call(null,relseg__$1,(0),(0));
var G__32538 = result__$1;
gline = G__32535;
lines__$1 = G__32536;
relseg = G__32537;
result = G__32538;
continue;
} else {
return result;
}
break;
}
});

cljs.source_map.decode.cljs$lang$maxFixedArity = 2;

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.call(null,((function (relseg){
return (function (segs,cols){
cljs.core.swap_BANG_.call(null,relseg,((function (relseg){
return (function (p__32539){
var vec__32540 = p__32539;
var _ = cljs.core.nth.call(null,vec__32540,(0),null);
var source = cljs.core.nth.call(null,vec__32540,(1),null);
var line = cljs.core.nth.call(null,vec__32540,(2),null);
var col = cljs.core.nth.call(null,vec__32540,(3),null);
var name = cljs.core.nth.call(null,vec__32540,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
});})(relseg))
);

return cljs.core.conj.call(null,segs,cljs.core.reduce.call(null,((function (relseg){
return (function (cols__$1,p__32543){
var vec__32544 = p__32543;
var gcol = cljs.core.nth.call(null,vec__32544,(0),null);
var sidx = cljs.core.nth.call(null,vec__32544,(1),null);
var line = cljs.core.nth.call(null,vec__32544,(2),null);
var col = cljs.core.nth.call(null,vec__32544,(3),null);
var name = cljs.core.nth.call(null,vec__32544,(4),null);
var seg = vec__32544;
var offset = cljs.core.map.call(null,cljs.core._,seg,cljs.core.deref.call(null,relseg));
cljs.core.swap_BANG_.call(null,relseg,((function (offset,vec__32544,gcol,sidx,line,col,name,seg,relseg){
return (function (p__32547){
var vec__32548 = p__32547;
var _ = cljs.core.nth.call(null,vec__32548,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__32548,(1),null);
var ___$2 = cljs.core.nth.call(null,vec__32548,(2),null);
var ___$3 = cljs.core.nth.call(null,vec__32548,(3),null);
var lname = cljs.core.nth.call(null,vec__32548,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__27989__auto__ = name;
if(cljs.core.truth_(or__27989__auto__)){
return or__27989__auto__;
} else {
return lname;
}
})()], null);
});})(offset,vec__32544,gcol,sidx,line,col,name,seg,relseg))
);

return cljs.core.conj.call(null,cols__$1,cljs.source_map.base64_vlq.encode.call(null,offset));
});})(relseg))
,cljs.core.PersistentVector.EMPTY,cols));
});})(relseg))
,cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.call(null,(0));
var preamble_lines = cljs.core.take.call(null,(function (){var or__27989__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__27989__auto__)){
return or__27989__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.call(null,cljs.core.PersistentVector.EMPTY));
var info__GT_segv = ((function (lines,names__GT_idx,name_idx,preamble_lines){
return (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__4655__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__4655__auto__)){
var name = temp__4655__auto__;
var idx = (function (){var temp__4655__auto____$1 = cljs.core.get.call(null,cljs.core.deref.call(null,names__GT_idx),name);
if(cljs.core.truth_(temp__4655__auto____$1)){
var idx = temp__4655__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref.call(null,name_idx);
cljs.core.swap_BANG_.call(null,names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.call(null,name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.call(null,segv,idx);
} else {
return segv;
}
});})(lines,names__GT_idx,name_idx,preamble_lines))
;
var encode_cols = ((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (infos,source_idx,line,col){
var seq__32554 = cljs.core.seq.call(null,infos);
var chunk__32555 = null;
var count__32556 = (0);
var i__32557 = (0);
while(true){
if((i__32557 < count__32556)){
var info = cljs.core._nth.call(null,chunk__32555,i__32557);
var segv_32636 = info__GT_segv.call(null,info,source_idx,line,col);
var gline_32637 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_32638 = cljs.core.count.call(null,cljs.core.deref.call(null,lines));
if((gline_32637 > (lc_32638 - (1)))){
cljs.core.swap_BANG_.call(null,lines,((function (seq__32554,chunk__32555,count__32556,i__32557,segv_32636,gline_32637,lc_32638,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.call(null,cljs.core.into.call(null,lines__$1,cljs.core.repeat.call(null,((gline_32637 - (lc_32638 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_32636], null));
});})(seq__32554,chunk__32555,count__32556,i__32557,segv_32636,gline_32637,lc_32638,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.call(null,lines,((function (seq__32554,chunk__32555,count__32556,i__32557,segv_32636,gline_32637,lc_32638,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.call(null,lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_32637], null),cljs.core.conj,segv_32636);
});})(seq__32554,chunk__32555,count__32556,i__32557,segv_32636,gline_32637,lc_32638,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}

var G__32639 = seq__32554;
var G__32640 = chunk__32555;
var G__32641 = count__32556;
var G__32642 = (i__32557 + (1));
seq__32554 = G__32639;
chunk__32555 = G__32640;
count__32556 = G__32641;
i__32557 = G__32642;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__32554);
if(temp__4657__auto__){
var seq__32554__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32554__$1)){
var c__28828__auto__ = cljs.core.chunk_first.call(null,seq__32554__$1);
var G__32643 = cljs.core.chunk_rest.call(null,seq__32554__$1);
var G__32644 = c__28828__auto__;
var G__32645 = cljs.core.count.call(null,c__28828__auto__);
var G__32646 = (0);
seq__32554 = G__32643;
chunk__32555 = G__32644;
count__32556 = G__32645;
i__32557 = G__32646;
continue;
} else {
var info = cljs.core.first.call(null,seq__32554__$1);
var segv_32647 = info__GT_segv.call(null,info,source_idx,line,col);
var gline_32648 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_32649 = cljs.core.count.call(null,cljs.core.deref.call(null,lines));
if((gline_32648 > (lc_32649 - (1)))){
cljs.core.swap_BANG_.call(null,lines,((function (seq__32554,chunk__32555,count__32556,i__32557,segv_32647,gline_32648,lc_32649,info,seq__32554__$1,temp__4657__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.call(null,cljs.core.into.call(null,lines__$1,cljs.core.repeat.call(null,((gline_32648 - (lc_32649 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_32647], null));
});})(seq__32554,chunk__32555,count__32556,i__32557,segv_32647,gline_32648,lc_32649,info,seq__32554__$1,temp__4657__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.call(null,lines,((function (seq__32554,chunk__32555,count__32556,i__32557,segv_32647,gline_32648,lc_32649,info,seq__32554__$1,temp__4657__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.call(null,lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_32648], null),cljs.core.conj,segv_32647);
});})(seq__32554,chunk__32555,count__32556,i__32557,segv_32647,gline_32648,lc_32649,info,seq__32554__$1,temp__4657__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}

var G__32650 = cljs.core.next.call(null,seq__32554__$1);
var G__32651 = null;
var G__32652 = (0);
var G__32653 = (0);
seq__32554 = G__32650;
chunk__32555 = G__32651;
count__32556 = G__32652;
i__32557 = G__32653;
continue;
}
} else {
return null;
}
}
break;
}
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
;
var seq__32558_32654 = cljs.core.seq.call(null,cljs.core.map_indexed.call(null,((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__32559_32655 = null;
var count__32560_32656 = (0);
var i__32561_32657 = (0);
while(true){
if((i__32561_32657 < count__32560_32656)){
var vec__32562_32658 = cljs.core._nth.call(null,chunk__32559_32655,i__32561_32657);
var source_idx_32659 = cljs.core.nth.call(null,vec__32562_32658,(0),null);
var vec__32565_32660 = cljs.core.nth.call(null,vec__32562_32658,(1),null);
var __32661 = cljs.core.nth.call(null,vec__32565_32660,(0),null);
var lines_32662__$1 = cljs.core.nth.call(null,vec__32565_32660,(1),null);
var seq__32568_32663 = cljs.core.seq.call(null,lines_32662__$1);
var chunk__32569_32664 = null;
var count__32570_32665 = (0);
var i__32571_32666 = (0);
while(true){
if((i__32571_32666 < count__32570_32665)){
var vec__32572_32667 = cljs.core._nth.call(null,chunk__32569_32664,i__32571_32666);
var line_32668 = cljs.core.nth.call(null,vec__32572_32667,(0),null);
var cols_32669 = cljs.core.nth.call(null,vec__32572_32667,(1),null);
var seq__32575_32670 = cljs.core.seq.call(null,cols_32669);
var chunk__32576_32671 = null;
var count__32577_32672 = (0);
var i__32578_32673 = (0);
while(true){
if((i__32578_32673 < count__32577_32672)){
var vec__32579_32674 = cljs.core._nth.call(null,chunk__32576_32671,i__32578_32673);
var col_32675 = cljs.core.nth.call(null,vec__32579_32674,(0),null);
var infos_32676 = cljs.core.nth.call(null,vec__32579_32674,(1),null);
encode_cols.call(null,infos_32676,source_idx_32659,line_32668,col_32675);

var G__32677 = seq__32575_32670;
var G__32678 = chunk__32576_32671;
var G__32679 = count__32577_32672;
var G__32680 = (i__32578_32673 + (1));
seq__32575_32670 = G__32677;
chunk__32576_32671 = G__32678;
count__32577_32672 = G__32679;
i__32578_32673 = G__32680;
continue;
} else {
var temp__4657__auto___32681 = cljs.core.seq.call(null,seq__32575_32670);
if(temp__4657__auto___32681){
var seq__32575_32682__$1 = temp__4657__auto___32681;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32575_32682__$1)){
var c__28828__auto___32683 = cljs.core.chunk_first.call(null,seq__32575_32682__$1);
var G__32684 = cljs.core.chunk_rest.call(null,seq__32575_32682__$1);
var G__32685 = c__28828__auto___32683;
var G__32686 = cljs.core.count.call(null,c__28828__auto___32683);
var G__32687 = (0);
seq__32575_32670 = G__32684;
chunk__32576_32671 = G__32685;
count__32577_32672 = G__32686;
i__32578_32673 = G__32687;
continue;
} else {
var vec__32582_32688 = cljs.core.first.call(null,seq__32575_32682__$1);
var col_32689 = cljs.core.nth.call(null,vec__32582_32688,(0),null);
var infos_32690 = cljs.core.nth.call(null,vec__32582_32688,(1),null);
encode_cols.call(null,infos_32690,source_idx_32659,line_32668,col_32689);

var G__32691 = cljs.core.next.call(null,seq__32575_32682__$1);
var G__32692 = null;
var G__32693 = (0);
var G__32694 = (0);
seq__32575_32670 = G__32691;
chunk__32576_32671 = G__32692;
count__32577_32672 = G__32693;
i__32578_32673 = G__32694;
continue;
}
} else {
}
}
break;
}

var G__32695 = seq__32568_32663;
var G__32696 = chunk__32569_32664;
var G__32697 = count__32570_32665;
var G__32698 = (i__32571_32666 + (1));
seq__32568_32663 = G__32695;
chunk__32569_32664 = G__32696;
count__32570_32665 = G__32697;
i__32571_32666 = G__32698;
continue;
} else {
var temp__4657__auto___32699 = cljs.core.seq.call(null,seq__32568_32663);
if(temp__4657__auto___32699){
var seq__32568_32700__$1 = temp__4657__auto___32699;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32568_32700__$1)){
var c__28828__auto___32701 = cljs.core.chunk_first.call(null,seq__32568_32700__$1);
var G__32702 = cljs.core.chunk_rest.call(null,seq__32568_32700__$1);
var G__32703 = c__28828__auto___32701;
var G__32704 = cljs.core.count.call(null,c__28828__auto___32701);
var G__32705 = (0);
seq__32568_32663 = G__32702;
chunk__32569_32664 = G__32703;
count__32570_32665 = G__32704;
i__32571_32666 = G__32705;
continue;
} else {
var vec__32585_32706 = cljs.core.first.call(null,seq__32568_32700__$1);
var line_32707 = cljs.core.nth.call(null,vec__32585_32706,(0),null);
var cols_32708 = cljs.core.nth.call(null,vec__32585_32706,(1),null);
var seq__32588_32709 = cljs.core.seq.call(null,cols_32708);
var chunk__32589_32710 = null;
var count__32590_32711 = (0);
var i__32591_32712 = (0);
while(true){
if((i__32591_32712 < count__32590_32711)){
var vec__32592_32713 = cljs.core._nth.call(null,chunk__32589_32710,i__32591_32712);
var col_32714 = cljs.core.nth.call(null,vec__32592_32713,(0),null);
var infos_32715 = cljs.core.nth.call(null,vec__32592_32713,(1),null);
encode_cols.call(null,infos_32715,source_idx_32659,line_32707,col_32714);

var G__32716 = seq__32588_32709;
var G__32717 = chunk__32589_32710;
var G__32718 = count__32590_32711;
var G__32719 = (i__32591_32712 + (1));
seq__32588_32709 = G__32716;
chunk__32589_32710 = G__32717;
count__32590_32711 = G__32718;
i__32591_32712 = G__32719;
continue;
} else {
var temp__4657__auto___32720__$1 = cljs.core.seq.call(null,seq__32588_32709);
if(temp__4657__auto___32720__$1){
var seq__32588_32721__$1 = temp__4657__auto___32720__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32588_32721__$1)){
var c__28828__auto___32722 = cljs.core.chunk_first.call(null,seq__32588_32721__$1);
var G__32723 = cljs.core.chunk_rest.call(null,seq__32588_32721__$1);
var G__32724 = c__28828__auto___32722;
var G__32725 = cljs.core.count.call(null,c__28828__auto___32722);
var G__32726 = (0);
seq__32588_32709 = G__32723;
chunk__32589_32710 = G__32724;
count__32590_32711 = G__32725;
i__32591_32712 = G__32726;
continue;
} else {
var vec__32595_32727 = cljs.core.first.call(null,seq__32588_32721__$1);
var col_32728 = cljs.core.nth.call(null,vec__32595_32727,(0),null);
var infos_32729 = cljs.core.nth.call(null,vec__32595_32727,(1),null);
encode_cols.call(null,infos_32729,source_idx_32659,line_32707,col_32728);

var G__32730 = cljs.core.next.call(null,seq__32588_32721__$1);
var G__32731 = null;
var G__32732 = (0);
var G__32733 = (0);
seq__32588_32709 = G__32730;
chunk__32589_32710 = G__32731;
count__32590_32711 = G__32732;
i__32591_32712 = G__32733;
continue;
}
} else {
}
}
break;
}

var G__32734 = cljs.core.next.call(null,seq__32568_32700__$1);
var G__32735 = null;
var G__32736 = (0);
var G__32737 = (0);
seq__32568_32663 = G__32734;
chunk__32569_32664 = G__32735;
count__32570_32665 = G__32736;
i__32571_32666 = G__32737;
continue;
}
} else {
}
}
break;
}

var G__32738 = seq__32558_32654;
var G__32739 = chunk__32559_32655;
var G__32740 = count__32560_32656;
var G__32741 = (i__32561_32657 + (1));
seq__32558_32654 = G__32738;
chunk__32559_32655 = G__32739;
count__32560_32656 = G__32740;
i__32561_32657 = G__32741;
continue;
} else {
var temp__4657__auto___32742 = cljs.core.seq.call(null,seq__32558_32654);
if(temp__4657__auto___32742){
var seq__32558_32743__$1 = temp__4657__auto___32742;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32558_32743__$1)){
var c__28828__auto___32744 = cljs.core.chunk_first.call(null,seq__32558_32743__$1);
var G__32745 = cljs.core.chunk_rest.call(null,seq__32558_32743__$1);
var G__32746 = c__28828__auto___32744;
var G__32747 = cljs.core.count.call(null,c__28828__auto___32744);
var G__32748 = (0);
seq__32558_32654 = G__32745;
chunk__32559_32655 = G__32746;
count__32560_32656 = G__32747;
i__32561_32657 = G__32748;
continue;
} else {
var vec__32598_32749 = cljs.core.first.call(null,seq__32558_32743__$1);
var source_idx_32750 = cljs.core.nth.call(null,vec__32598_32749,(0),null);
var vec__32601_32751 = cljs.core.nth.call(null,vec__32598_32749,(1),null);
var __32752 = cljs.core.nth.call(null,vec__32601_32751,(0),null);
var lines_32753__$1 = cljs.core.nth.call(null,vec__32601_32751,(1),null);
var seq__32604_32754 = cljs.core.seq.call(null,lines_32753__$1);
var chunk__32605_32755 = null;
var count__32606_32756 = (0);
var i__32607_32757 = (0);
while(true){
if((i__32607_32757 < count__32606_32756)){
var vec__32608_32758 = cljs.core._nth.call(null,chunk__32605_32755,i__32607_32757);
var line_32759 = cljs.core.nth.call(null,vec__32608_32758,(0),null);
var cols_32760 = cljs.core.nth.call(null,vec__32608_32758,(1),null);
var seq__32611_32761 = cljs.core.seq.call(null,cols_32760);
var chunk__32612_32762 = null;
var count__32613_32763 = (0);
var i__32614_32764 = (0);
while(true){
if((i__32614_32764 < count__32613_32763)){
var vec__32615_32765 = cljs.core._nth.call(null,chunk__32612_32762,i__32614_32764);
var col_32766 = cljs.core.nth.call(null,vec__32615_32765,(0),null);
var infos_32767 = cljs.core.nth.call(null,vec__32615_32765,(1),null);
encode_cols.call(null,infos_32767,source_idx_32750,line_32759,col_32766);

var G__32768 = seq__32611_32761;
var G__32769 = chunk__32612_32762;
var G__32770 = count__32613_32763;
var G__32771 = (i__32614_32764 + (1));
seq__32611_32761 = G__32768;
chunk__32612_32762 = G__32769;
count__32613_32763 = G__32770;
i__32614_32764 = G__32771;
continue;
} else {
var temp__4657__auto___32772__$1 = cljs.core.seq.call(null,seq__32611_32761);
if(temp__4657__auto___32772__$1){
var seq__32611_32773__$1 = temp__4657__auto___32772__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32611_32773__$1)){
var c__28828__auto___32774 = cljs.core.chunk_first.call(null,seq__32611_32773__$1);
var G__32775 = cljs.core.chunk_rest.call(null,seq__32611_32773__$1);
var G__32776 = c__28828__auto___32774;
var G__32777 = cljs.core.count.call(null,c__28828__auto___32774);
var G__32778 = (0);
seq__32611_32761 = G__32775;
chunk__32612_32762 = G__32776;
count__32613_32763 = G__32777;
i__32614_32764 = G__32778;
continue;
} else {
var vec__32618_32779 = cljs.core.first.call(null,seq__32611_32773__$1);
var col_32780 = cljs.core.nth.call(null,vec__32618_32779,(0),null);
var infos_32781 = cljs.core.nth.call(null,vec__32618_32779,(1),null);
encode_cols.call(null,infos_32781,source_idx_32750,line_32759,col_32780);

var G__32782 = cljs.core.next.call(null,seq__32611_32773__$1);
var G__32783 = null;
var G__32784 = (0);
var G__32785 = (0);
seq__32611_32761 = G__32782;
chunk__32612_32762 = G__32783;
count__32613_32763 = G__32784;
i__32614_32764 = G__32785;
continue;
}
} else {
}
}
break;
}

var G__32786 = seq__32604_32754;
var G__32787 = chunk__32605_32755;
var G__32788 = count__32606_32756;
var G__32789 = (i__32607_32757 + (1));
seq__32604_32754 = G__32786;
chunk__32605_32755 = G__32787;
count__32606_32756 = G__32788;
i__32607_32757 = G__32789;
continue;
} else {
var temp__4657__auto___32790__$1 = cljs.core.seq.call(null,seq__32604_32754);
if(temp__4657__auto___32790__$1){
var seq__32604_32791__$1 = temp__4657__auto___32790__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32604_32791__$1)){
var c__28828__auto___32792 = cljs.core.chunk_first.call(null,seq__32604_32791__$1);
var G__32793 = cljs.core.chunk_rest.call(null,seq__32604_32791__$1);
var G__32794 = c__28828__auto___32792;
var G__32795 = cljs.core.count.call(null,c__28828__auto___32792);
var G__32796 = (0);
seq__32604_32754 = G__32793;
chunk__32605_32755 = G__32794;
count__32606_32756 = G__32795;
i__32607_32757 = G__32796;
continue;
} else {
var vec__32621_32797 = cljs.core.first.call(null,seq__32604_32791__$1);
var line_32798 = cljs.core.nth.call(null,vec__32621_32797,(0),null);
var cols_32799 = cljs.core.nth.call(null,vec__32621_32797,(1),null);
var seq__32624_32800 = cljs.core.seq.call(null,cols_32799);
var chunk__32625_32801 = null;
var count__32626_32802 = (0);
var i__32627_32803 = (0);
while(true){
if((i__32627_32803 < count__32626_32802)){
var vec__32628_32804 = cljs.core._nth.call(null,chunk__32625_32801,i__32627_32803);
var col_32805 = cljs.core.nth.call(null,vec__32628_32804,(0),null);
var infos_32806 = cljs.core.nth.call(null,vec__32628_32804,(1),null);
encode_cols.call(null,infos_32806,source_idx_32750,line_32798,col_32805);

var G__32807 = seq__32624_32800;
var G__32808 = chunk__32625_32801;
var G__32809 = count__32626_32802;
var G__32810 = (i__32627_32803 + (1));
seq__32624_32800 = G__32807;
chunk__32625_32801 = G__32808;
count__32626_32802 = G__32809;
i__32627_32803 = G__32810;
continue;
} else {
var temp__4657__auto___32811__$2 = cljs.core.seq.call(null,seq__32624_32800);
if(temp__4657__auto___32811__$2){
var seq__32624_32812__$1 = temp__4657__auto___32811__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32624_32812__$1)){
var c__28828__auto___32813 = cljs.core.chunk_first.call(null,seq__32624_32812__$1);
var G__32814 = cljs.core.chunk_rest.call(null,seq__32624_32812__$1);
var G__32815 = c__28828__auto___32813;
var G__32816 = cljs.core.count.call(null,c__28828__auto___32813);
var G__32817 = (0);
seq__32624_32800 = G__32814;
chunk__32625_32801 = G__32815;
count__32626_32802 = G__32816;
i__32627_32803 = G__32817;
continue;
} else {
var vec__32631_32818 = cljs.core.first.call(null,seq__32624_32812__$1);
var col_32819 = cljs.core.nth.call(null,vec__32631_32818,(0),null);
var infos_32820 = cljs.core.nth.call(null,vec__32631_32818,(1),null);
encode_cols.call(null,infos_32820,source_idx_32750,line_32798,col_32819);

var G__32821 = cljs.core.next.call(null,seq__32624_32812__$1);
var G__32822 = null;
var G__32823 = (0);
var G__32824 = (0);
seq__32624_32800 = G__32821;
chunk__32625_32801 = G__32822;
count__32626_32802 = G__32823;
i__32627_32803 = G__32824;
continue;
}
} else {
}
}
break;
}

var G__32825 = cljs.core.next.call(null,seq__32604_32791__$1);
var G__32826 = null;
var G__32827 = (0);
var G__32828 = (0);
seq__32604_32754 = G__32825;
chunk__32605_32755 = G__32826;
count__32606_32756 = G__32827;
i__32607_32757 = G__32828;
continue;
}
} else {
}
}
break;
}

var G__32829 = cljs.core.next.call(null,seq__32558_32743__$1);
var G__32830 = null;
var G__32831 = (0);
var G__32832 = (0);
seq__32558_32654 = G__32829;
chunk__32559_32655 = G__32830;
count__32560_32656 = G__32831;
i__32561_32657 = G__32832;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__32634 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys.call(null,m);
var f = cljs.core.comp.call(null,((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?((function (paths,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (p1__32551_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__32551_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
});})(paths,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
:cljs.core.identity),((function (paths,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (p1__32552_SHARP_){
return cljs.core.last.call(null,clojure.string.split.call(null,p1__32552_SHARP_,/\//));
});})(paths,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
);
return cljs.core.into_array.call(null,cljs.core.map.call(null,f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.call(null,";",cljs.core.map.call(null,((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (p1__32553_SHARP_){
return clojure.string.join.call(null,",",p1__32553_SHARP_);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,cljs.source_map.lines__GT_segs.call(null,cljs.core.concat.call(null,preamble_lines,cljs.core.deref.call(null,lines))))), "names": cljs.core.into_array.call(null,cljs.core.map.call(null,clojure.set.map_invert.call(null,cljs.core.deref.call(null,names__GT_idx)),cljs.core.range.call(null,cljs.core.count.call(null,cljs.core.deref.call(null,names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__32635 = G__32634;
goog.object.set(G__32635,"sourcesContent",cljs.core.into_array.call(null,new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts)));

return G__32635;
} else {
return G__32634;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq.call(null,cljs_map);
var new_lines = cljs.core.sorted_map.call(null);
while(true){
if(line_map_seq){
var vec__32833 = cljs.core.first.call(null,line_map_seq);
var line = cljs.core.nth.call(null,vec__32833,(0),null);
var col_map = cljs.core.nth.call(null,vec__32833,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq.call(null,col_map);
var new_cols = cljs.core.sorted_map.call(null);
while(true){
if(col_map_seq){
var vec__32836 = cljs.core.first.call(null,col_map_seq);
var col = cljs.core.nth.call(null,vec__32836,(0),null);
var infos = cljs.core.nth.call(null,vec__32836,(1),null);
var G__32842 = cljs.core.next.call(null,col_map_seq);
var G__32843 = cljs.core.assoc.call(null,new_cols,col,cljs.core.reduce.call(null,((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__32836,col,infos,vec__32833,line,col_map){
return (function (v,p__32839){
var map__32840 = p__32839;
var map__32840__$1 = ((((!((map__32840 == null)))?((((map__32840.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32840.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32840):map__32840);
var gline = cljs.core.get.call(null,map__32840__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.call(null,map__32840__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.call(null,v,cljs.core.get_in.call(null,js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__32836,col,infos,vec__32833,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__32842;
new_cols = G__32843;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__32844 = cljs.core.next.call(null,line_map_seq);
var G__32845 = cljs.core.assoc.call(null,new_lines,line,new_cols);
line_map_seq = G__32844;
new_lines = G__32845;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.call(null,cljs.core.sorted_map.call(null));
var seq__32846_32908 = cljs.core.seq.call(null,reverse_map);
var chunk__32847_32909 = null;
var count__32848_32910 = (0);
var i__32849_32911 = (0);
while(true){
if((i__32849_32911 < count__32848_32910)){
var vec__32850_32912 = cljs.core._nth.call(null,chunk__32847_32909,i__32849_32911);
var line_32913 = cljs.core.nth.call(null,vec__32850_32912,(0),null);
var columns_32914 = cljs.core.nth.call(null,vec__32850_32912,(1),null);
var seq__32853_32915 = cljs.core.seq.call(null,columns_32914);
var chunk__32854_32916 = null;
var count__32855_32917 = (0);
var i__32856_32918 = (0);
while(true){
if((i__32856_32918 < count__32855_32917)){
var vec__32857_32919 = cljs.core._nth.call(null,chunk__32854_32916,i__32856_32918);
var column_32920 = cljs.core.nth.call(null,vec__32857_32919,(0),null);
var column_info_32921 = cljs.core.nth.call(null,vec__32857_32919,(1),null);
var seq__32860_32922 = cljs.core.seq.call(null,column_info_32921);
var chunk__32861_32923 = null;
var count__32862_32924 = (0);
var i__32863_32925 = (0);
while(true){
if((i__32863_32925 < count__32862_32924)){
var map__32864_32926 = cljs.core._nth.call(null,chunk__32861_32923,i__32863_32925);
var map__32864_32927__$1 = ((((!((map__32864_32926 == null)))?((((map__32864_32926.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32864_32926.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32864_32926):map__32864_32926);
var gline_32928 = cljs.core.get.call(null,map__32864_32927__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_32929 = cljs.core.get.call(null,map__32864_32927__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_32930 = cljs.core.get.call(null,map__32864_32927__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_32928], null),cljs.core.fnil.call(null,((function (seq__32860_32922,chunk__32861_32923,count__32862_32924,i__32863_32925,seq__32853_32915,chunk__32854_32916,count__32855_32917,i__32856_32918,seq__32846_32908,chunk__32847_32909,count__32848_32910,i__32849_32911,map__32864_32926,map__32864_32927__$1,gline_32928,gcol_32929,name_32930,vec__32857_32919,column_32920,column_info_32921,vec__32850_32912,line_32913,columns_32914,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_32929], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_32913,new cljs.core.Keyword(null,"col","col",-1959363084),column_32920,new cljs.core.Keyword(null,"name","name",1843675177),name_32930], null));
});})(seq__32860_32922,chunk__32861_32923,count__32862_32924,i__32863_32925,seq__32853_32915,chunk__32854_32916,count__32855_32917,i__32856_32918,seq__32846_32908,chunk__32847_32909,count__32848_32910,i__32849_32911,map__32864_32926,map__32864_32927__$1,gline_32928,gcol_32929,name_32930,vec__32857_32919,column_32920,column_info_32921,vec__32850_32912,line_32913,columns_32914,inverted))
,cljs.core.sorted_map.call(null)));

var G__32931 = seq__32860_32922;
var G__32932 = chunk__32861_32923;
var G__32933 = count__32862_32924;
var G__32934 = (i__32863_32925 + (1));
seq__32860_32922 = G__32931;
chunk__32861_32923 = G__32932;
count__32862_32924 = G__32933;
i__32863_32925 = G__32934;
continue;
} else {
var temp__4657__auto___32935 = cljs.core.seq.call(null,seq__32860_32922);
if(temp__4657__auto___32935){
var seq__32860_32936__$1 = temp__4657__auto___32935;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32860_32936__$1)){
var c__28828__auto___32937 = cljs.core.chunk_first.call(null,seq__32860_32936__$1);
var G__32938 = cljs.core.chunk_rest.call(null,seq__32860_32936__$1);
var G__32939 = c__28828__auto___32937;
var G__32940 = cljs.core.count.call(null,c__28828__auto___32937);
var G__32941 = (0);
seq__32860_32922 = G__32938;
chunk__32861_32923 = G__32939;
count__32862_32924 = G__32940;
i__32863_32925 = G__32941;
continue;
} else {
var map__32866_32942 = cljs.core.first.call(null,seq__32860_32936__$1);
var map__32866_32943__$1 = ((((!((map__32866_32942 == null)))?((((map__32866_32942.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32866_32942.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32866_32942):map__32866_32942);
var gline_32944 = cljs.core.get.call(null,map__32866_32943__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_32945 = cljs.core.get.call(null,map__32866_32943__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_32946 = cljs.core.get.call(null,map__32866_32943__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_32944], null),cljs.core.fnil.call(null,((function (seq__32860_32922,chunk__32861_32923,count__32862_32924,i__32863_32925,seq__32853_32915,chunk__32854_32916,count__32855_32917,i__32856_32918,seq__32846_32908,chunk__32847_32909,count__32848_32910,i__32849_32911,map__32866_32942,map__32866_32943__$1,gline_32944,gcol_32945,name_32946,seq__32860_32936__$1,temp__4657__auto___32935,vec__32857_32919,column_32920,column_info_32921,vec__32850_32912,line_32913,columns_32914,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_32945], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_32913,new cljs.core.Keyword(null,"col","col",-1959363084),column_32920,new cljs.core.Keyword(null,"name","name",1843675177),name_32946], null));
});})(seq__32860_32922,chunk__32861_32923,count__32862_32924,i__32863_32925,seq__32853_32915,chunk__32854_32916,count__32855_32917,i__32856_32918,seq__32846_32908,chunk__32847_32909,count__32848_32910,i__32849_32911,map__32866_32942,map__32866_32943__$1,gline_32944,gcol_32945,name_32946,seq__32860_32936__$1,temp__4657__auto___32935,vec__32857_32919,column_32920,column_info_32921,vec__32850_32912,line_32913,columns_32914,inverted))
,cljs.core.sorted_map.call(null)));

var G__32947 = cljs.core.next.call(null,seq__32860_32936__$1);
var G__32948 = null;
var G__32949 = (0);
var G__32950 = (0);
seq__32860_32922 = G__32947;
chunk__32861_32923 = G__32948;
count__32862_32924 = G__32949;
i__32863_32925 = G__32950;
continue;
}
} else {
}
}
break;
}

var G__32951 = seq__32853_32915;
var G__32952 = chunk__32854_32916;
var G__32953 = count__32855_32917;
var G__32954 = (i__32856_32918 + (1));
seq__32853_32915 = G__32951;
chunk__32854_32916 = G__32952;
count__32855_32917 = G__32953;
i__32856_32918 = G__32954;
continue;
} else {
var temp__4657__auto___32955 = cljs.core.seq.call(null,seq__32853_32915);
if(temp__4657__auto___32955){
var seq__32853_32956__$1 = temp__4657__auto___32955;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32853_32956__$1)){
var c__28828__auto___32957 = cljs.core.chunk_first.call(null,seq__32853_32956__$1);
var G__32958 = cljs.core.chunk_rest.call(null,seq__32853_32956__$1);
var G__32959 = c__28828__auto___32957;
var G__32960 = cljs.core.count.call(null,c__28828__auto___32957);
var G__32961 = (0);
seq__32853_32915 = G__32958;
chunk__32854_32916 = G__32959;
count__32855_32917 = G__32960;
i__32856_32918 = G__32961;
continue;
} else {
var vec__32868_32962 = cljs.core.first.call(null,seq__32853_32956__$1);
var column_32963 = cljs.core.nth.call(null,vec__32868_32962,(0),null);
var column_info_32964 = cljs.core.nth.call(null,vec__32868_32962,(1),null);
var seq__32871_32965 = cljs.core.seq.call(null,column_info_32964);
var chunk__32872_32966 = null;
var count__32873_32967 = (0);
var i__32874_32968 = (0);
while(true){
if((i__32874_32968 < count__32873_32967)){
var map__32875_32969 = cljs.core._nth.call(null,chunk__32872_32966,i__32874_32968);
var map__32875_32970__$1 = ((((!((map__32875_32969 == null)))?((((map__32875_32969.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32875_32969.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32875_32969):map__32875_32969);
var gline_32971 = cljs.core.get.call(null,map__32875_32970__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_32972 = cljs.core.get.call(null,map__32875_32970__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_32973 = cljs.core.get.call(null,map__32875_32970__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_32971], null),cljs.core.fnil.call(null,((function (seq__32871_32965,chunk__32872_32966,count__32873_32967,i__32874_32968,seq__32853_32915,chunk__32854_32916,count__32855_32917,i__32856_32918,seq__32846_32908,chunk__32847_32909,count__32848_32910,i__32849_32911,map__32875_32969,map__32875_32970__$1,gline_32971,gcol_32972,name_32973,vec__32868_32962,column_32963,column_info_32964,seq__32853_32956__$1,temp__4657__auto___32955,vec__32850_32912,line_32913,columns_32914,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_32972], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_32913,new cljs.core.Keyword(null,"col","col",-1959363084),column_32963,new cljs.core.Keyword(null,"name","name",1843675177),name_32973], null));
});})(seq__32871_32965,chunk__32872_32966,count__32873_32967,i__32874_32968,seq__32853_32915,chunk__32854_32916,count__32855_32917,i__32856_32918,seq__32846_32908,chunk__32847_32909,count__32848_32910,i__32849_32911,map__32875_32969,map__32875_32970__$1,gline_32971,gcol_32972,name_32973,vec__32868_32962,column_32963,column_info_32964,seq__32853_32956__$1,temp__4657__auto___32955,vec__32850_32912,line_32913,columns_32914,inverted))
,cljs.core.sorted_map.call(null)));

var G__32974 = seq__32871_32965;
var G__32975 = chunk__32872_32966;
var G__32976 = count__32873_32967;
var G__32977 = (i__32874_32968 + (1));
seq__32871_32965 = G__32974;
chunk__32872_32966 = G__32975;
count__32873_32967 = G__32976;
i__32874_32968 = G__32977;
continue;
} else {
var temp__4657__auto___32978__$1 = cljs.core.seq.call(null,seq__32871_32965);
if(temp__4657__auto___32978__$1){
var seq__32871_32979__$1 = temp__4657__auto___32978__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32871_32979__$1)){
var c__28828__auto___32980 = cljs.core.chunk_first.call(null,seq__32871_32979__$1);
var G__32981 = cljs.core.chunk_rest.call(null,seq__32871_32979__$1);
var G__32982 = c__28828__auto___32980;
var G__32983 = cljs.core.count.call(null,c__28828__auto___32980);
var G__32984 = (0);
seq__32871_32965 = G__32981;
chunk__32872_32966 = G__32982;
count__32873_32967 = G__32983;
i__32874_32968 = G__32984;
continue;
} else {
var map__32877_32985 = cljs.core.first.call(null,seq__32871_32979__$1);
var map__32877_32986__$1 = ((((!((map__32877_32985 == null)))?((((map__32877_32985.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32877_32985.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32877_32985):map__32877_32985);
var gline_32987 = cljs.core.get.call(null,map__32877_32986__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_32988 = cljs.core.get.call(null,map__32877_32986__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_32989 = cljs.core.get.call(null,map__32877_32986__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_32987], null),cljs.core.fnil.call(null,((function (seq__32871_32965,chunk__32872_32966,count__32873_32967,i__32874_32968,seq__32853_32915,chunk__32854_32916,count__32855_32917,i__32856_32918,seq__32846_32908,chunk__32847_32909,count__32848_32910,i__32849_32911,map__32877_32985,map__32877_32986__$1,gline_32987,gcol_32988,name_32989,seq__32871_32979__$1,temp__4657__auto___32978__$1,vec__32868_32962,column_32963,column_info_32964,seq__32853_32956__$1,temp__4657__auto___32955,vec__32850_32912,line_32913,columns_32914,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_32988], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_32913,new cljs.core.Keyword(null,"col","col",-1959363084),column_32963,new cljs.core.Keyword(null,"name","name",1843675177),name_32989], null));
});})(seq__32871_32965,chunk__32872_32966,count__32873_32967,i__32874_32968,seq__32853_32915,chunk__32854_32916,count__32855_32917,i__32856_32918,seq__32846_32908,chunk__32847_32909,count__32848_32910,i__32849_32911,map__32877_32985,map__32877_32986__$1,gline_32987,gcol_32988,name_32989,seq__32871_32979__$1,temp__4657__auto___32978__$1,vec__32868_32962,column_32963,column_info_32964,seq__32853_32956__$1,temp__4657__auto___32955,vec__32850_32912,line_32913,columns_32914,inverted))
,cljs.core.sorted_map.call(null)));

var G__32990 = cljs.core.next.call(null,seq__32871_32979__$1);
var G__32991 = null;
var G__32992 = (0);
var G__32993 = (0);
seq__32871_32965 = G__32990;
chunk__32872_32966 = G__32991;
count__32873_32967 = G__32992;
i__32874_32968 = G__32993;
continue;
}
} else {
}
}
break;
}

var G__32994 = cljs.core.next.call(null,seq__32853_32956__$1);
var G__32995 = null;
var G__32996 = (0);
var G__32997 = (0);
seq__32853_32915 = G__32994;
chunk__32854_32916 = G__32995;
count__32855_32917 = G__32996;
i__32856_32918 = G__32997;
continue;
}
} else {
}
}
break;
}

var G__32998 = seq__32846_32908;
var G__32999 = chunk__32847_32909;
var G__33000 = count__32848_32910;
var G__33001 = (i__32849_32911 + (1));
seq__32846_32908 = G__32998;
chunk__32847_32909 = G__32999;
count__32848_32910 = G__33000;
i__32849_32911 = G__33001;
continue;
} else {
var temp__4657__auto___33002 = cljs.core.seq.call(null,seq__32846_32908);
if(temp__4657__auto___33002){
var seq__32846_33003__$1 = temp__4657__auto___33002;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32846_33003__$1)){
var c__28828__auto___33004 = cljs.core.chunk_first.call(null,seq__32846_33003__$1);
var G__33005 = cljs.core.chunk_rest.call(null,seq__32846_33003__$1);
var G__33006 = c__28828__auto___33004;
var G__33007 = cljs.core.count.call(null,c__28828__auto___33004);
var G__33008 = (0);
seq__32846_32908 = G__33005;
chunk__32847_32909 = G__33006;
count__32848_32910 = G__33007;
i__32849_32911 = G__33008;
continue;
} else {
var vec__32879_33009 = cljs.core.first.call(null,seq__32846_33003__$1);
var line_33010 = cljs.core.nth.call(null,vec__32879_33009,(0),null);
var columns_33011 = cljs.core.nth.call(null,vec__32879_33009,(1),null);
var seq__32882_33012 = cljs.core.seq.call(null,columns_33011);
var chunk__32883_33013 = null;
var count__32884_33014 = (0);
var i__32885_33015 = (0);
while(true){
if((i__32885_33015 < count__32884_33014)){
var vec__32886_33016 = cljs.core._nth.call(null,chunk__32883_33013,i__32885_33015);
var column_33017 = cljs.core.nth.call(null,vec__32886_33016,(0),null);
var column_info_33018 = cljs.core.nth.call(null,vec__32886_33016,(1),null);
var seq__32889_33019 = cljs.core.seq.call(null,column_info_33018);
var chunk__32890_33020 = null;
var count__32891_33021 = (0);
var i__32892_33022 = (0);
while(true){
if((i__32892_33022 < count__32891_33021)){
var map__32893_33023 = cljs.core._nth.call(null,chunk__32890_33020,i__32892_33022);
var map__32893_33024__$1 = ((((!((map__32893_33023 == null)))?((((map__32893_33023.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32893_33023.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32893_33023):map__32893_33023);
var gline_33025 = cljs.core.get.call(null,map__32893_33024__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_33026 = cljs.core.get.call(null,map__32893_33024__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_33027 = cljs.core.get.call(null,map__32893_33024__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_33025], null),cljs.core.fnil.call(null,((function (seq__32889_33019,chunk__32890_33020,count__32891_33021,i__32892_33022,seq__32882_33012,chunk__32883_33013,count__32884_33014,i__32885_33015,seq__32846_32908,chunk__32847_32909,count__32848_32910,i__32849_32911,map__32893_33023,map__32893_33024__$1,gline_33025,gcol_33026,name_33027,vec__32886_33016,column_33017,column_info_33018,vec__32879_33009,line_33010,columns_33011,seq__32846_33003__$1,temp__4657__auto___33002,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_33026], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_33010,new cljs.core.Keyword(null,"col","col",-1959363084),column_33017,new cljs.core.Keyword(null,"name","name",1843675177),name_33027], null));
});})(seq__32889_33019,chunk__32890_33020,count__32891_33021,i__32892_33022,seq__32882_33012,chunk__32883_33013,count__32884_33014,i__32885_33015,seq__32846_32908,chunk__32847_32909,count__32848_32910,i__32849_32911,map__32893_33023,map__32893_33024__$1,gline_33025,gcol_33026,name_33027,vec__32886_33016,column_33017,column_info_33018,vec__32879_33009,line_33010,columns_33011,seq__32846_33003__$1,temp__4657__auto___33002,inverted))
,cljs.core.sorted_map.call(null)));

var G__33028 = seq__32889_33019;
var G__33029 = chunk__32890_33020;
var G__33030 = count__32891_33021;
var G__33031 = (i__32892_33022 + (1));
seq__32889_33019 = G__33028;
chunk__32890_33020 = G__33029;
count__32891_33021 = G__33030;
i__32892_33022 = G__33031;
continue;
} else {
var temp__4657__auto___33032__$1 = cljs.core.seq.call(null,seq__32889_33019);
if(temp__4657__auto___33032__$1){
var seq__32889_33033__$1 = temp__4657__auto___33032__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32889_33033__$1)){
var c__28828__auto___33034 = cljs.core.chunk_first.call(null,seq__32889_33033__$1);
var G__33035 = cljs.core.chunk_rest.call(null,seq__32889_33033__$1);
var G__33036 = c__28828__auto___33034;
var G__33037 = cljs.core.count.call(null,c__28828__auto___33034);
var G__33038 = (0);
seq__32889_33019 = G__33035;
chunk__32890_33020 = G__33036;
count__32891_33021 = G__33037;
i__32892_33022 = G__33038;
continue;
} else {
var map__32895_33039 = cljs.core.first.call(null,seq__32889_33033__$1);
var map__32895_33040__$1 = ((((!((map__32895_33039 == null)))?((((map__32895_33039.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32895_33039.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32895_33039):map__32895_33039);
var gline_33041 = cljs.core.get.call(null,map__32895_33040__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_33042 = cljs.core.get.call(null,map__32895_33040__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_33043 = cljs.core.get.call(null,map__32895_33040__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_33041], null),cljs.core.fnil.call(null,((function (seq__32889_33019,chunk__32890_33020,count__32891_33021,i__32892_33022,seq__32882_33012,chunk__32883_33013,count__32884_33014,i__32885_33015,seq__32846_32908,chunk__32847_32909,count__32848_32910,i__32849_32911,map__32895_33039,map__32895_33040__$1,gline_33041,gcol_33042,name_33043,seq__32889_33033__$1,temp__4657__auto___33032__$1,vec__32886_33016,column_33017,column_info_33018,vec__32879_33009,line_33010,columns_33011,seq__32846_33003__$1,temp__4657__auto___33002,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_33042], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_33010,new cljs.core.Keyword(null,"col","col",-1959363084),column_33017,new cljs.core.Keyword(null,"name","name",1843675177),name_33043], null));
});})(seq__32889_33019,chunk__32890_33020,count__32891_33021,i__32892_33022,seq__32882_33012,chunk__32883_33013,count__32884_33014,i__32885_33015,seq__32846_32908,chunk__32847_32909,count__32848_32910,i__32849_32911,map__32895_33039,map__32895_33040__$1,gline_33041,gcol_33042,name_33043,seq__32889_33033__$1,temp__4657__auto___33032__$1,vec__32886_33016,column_33017,column_info_33018,vec__32879_33009,line_33010,columns_33011,seq__32846_33003__$1,temp__4657__auto___33002,inverted))
,cljs.core.sorted_map.call(null)));

var G__33044 = cljs.core.next.call(null,seq__32889_33033__$1);
var G__33045 = null;
var G__33046 = (0);
var G__33047 = (0);
seq__32889_33019 = G__33044;
chunk__32890_33020 = G__33045;
count__32891_33021 = G__33046;
i__32892_33022 = G__33047;
continue;
}
} else {
}
}
break;
}

var G__33048 = seq__32882_33012;
var G__33049 = chunk__32883_33013;
var G__33050 = count__32884_33014;
var G__33051 = (i__32885_33015 + (1));
seq__32882_33012 = G__33048;
chunk__32883_33013 = G__33049;
count__32884_33014 = G__33050;
i__32885_33015 = G__33051;
continue;
} else {
var temp__4657__auto___33052__$1 = cljs.core.seq.call(null,seq__32882_33012);
if(temp__4657__auto___33052__$1){
var seq__32882_33053__$1 = temp__4657__auto___33052__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32882_33053__$1)){
var c__28828__auto___33054 = cljs.core.chunk_first.call(null,seq__32882_33053__$1);
var G__33055 = cljs.core.chunk_rest.call(null,seq__32882_33053__$1);
var G__33056 = c__28828__auto___33054;
var G__33057 = cljs.core.count.call(null,c__28828__auto___33054);
var G__33058 = (0);
seq__32882_33012 = G__33055;
chunk__32883_33013 = G__33056;
count__32884_33014 = G__33057;
i__32885_33015 = G__33058;
continue;
} else {
var vec__32897_33059 = cljs.core.first.call(null,seq__32882_33053__$1);
var column_33060 = cljs.core.nth.call(null,vec__32897_33059,(0),null);
var column_info_33061 = cljs.core.nth.call(null,vec__32897_33059,(1),null);
var seq__32900_33062 = cljs.core.seq.call(null,column_info_33061);
var chunk__32901_33063 = null;
var count__32902_33064 = (0);
var i__32903_33065 = (0);
while(true){
if((i__32903_33065 < count__32902_33064)){
var map__32904_33066 = cljs.core._nth.call(null,chunk__32901_33063,i__32903_33065);
var map__32904_33067__$1 = ((((!((map__32904_33066 == null)))?((((map__32904_33066.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32904_33066.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32904_33066):map__32904_33066);
var gline_33068 = cljs.core.get.call(null,map__32904_33067__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_33069 = cljs.core.get.call(null,map__32904_33067__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_33070 = cljs.core.get.call(null,map__32904_33067__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_33068], null),cljs.core.fnil.call(null,((function (seq__32900_33062,chunk__32901_33063,count__32902_33064,i__32903_33065,seq__32882_33012,chunk__32883_33013,count__32884_33014,i__32885_33015,seq__32846_32908,chunk__32847_32909,count__32848_32910,i__32849_32911,map__32904_33066,map__32904_33067__$1,gline_33068,gcol_33069,name_33070,vec__32897_33059,column_33060,column_info_33061,seq__32882_33053__$1,temp__4657__auto___33052__$1,vec__32879_33009,line_33010,columns_33011,seq__32846_33003__$1,temp__4657__auto___33002,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_33069], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_33010,new cljs.core.Keyword(null,"col","col",-1959363084),column_33060,new cljs.core.Keyword(null,"name","name",1843675177),name_33070], null));
});})(seq__32900_33062,chunk__32901_33063,count__32902_33064,i__32903_33065,seq__32882_33012,chunk__32883_33013,count__32884_33014,i__32885_33015,seq__32846_32908,chunk__32847_32909,count__32848_32910,i__32849_32911,map__32904_33066,map__32904_33067__$1,gline_33068,gcol_33069,name_33070,vec__32897_33059,column_33060,column_info_33061,seq__32882_33053__$1,temp__4657__auto___33052__$1,vec__32879_33009,line_33010,columns_33011,seq__32846_33003__$1,temp__4657__auto___33002,inverted))
,cljs.core.sorted_map.call(null)));

var G__33071 = seq__32900_33062;
var G__33072 = chunk__32901_33063;
var G__33073 = count__32902_33064;
var G__33074 = (i__32903_33065 + (1));
seq__32900_33062 = G__33071;
chunk__32901_33063 = G__33072;
count__32902_33064 = G__33073;
i__32903_33065 = G__33074;
continue;
} else {
var temp__4657__auto___33075__$2 = cljs.core.seq.call(null,seq__32900_33062);
if(temp__4657__auto___33075__$2){
var seq__32900_33076__$1 = temp__4657__auto___33075__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32900_33076__$1)){
var c__28828__auto___33077 = cljs.core.chunk_first.call(null,seq__32900_33076__$1);
var G__33078 = cljs.core.chunk_rest.call(null,seq__32900_33076__$1);
var G__33079 = c__28828__auto___33077;
var G__33080 = cljs.core.count.call(null,c__28828__auto___33077);
var G__33081 = (0);
seq__32900_33062 = G__33078;
chunk__32901_33063 = G__33079;
count__32902_33064 = G__33080;
i__32903_33065 = G__33081;
continue;
} else {
var map__32906_33082 = cljs.core.first.call(null,seq__32900_33076__$1);
var map__32906_33083__$1 = ((((!((map__32906_33082 == null)))?((((map__32906_33082.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32906_33082.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32906_33082):map__32906_33082);
var gline_33084 = cljs.core.get.call(null,map__32906_33083__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_33085 = cljs.core.get.call(null,map__32906_33083__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_33086 = cljs.core.get.call(null,map__32906_33083__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_33084], null),cljs.core.fnil.call(null,((function (seq__32900_33062,chunk__32901_33063,count__32902_33064,i__32903_33065,seq__32882_33012,chunk__32883_33013,count__32884_33014,i__32885_33015,seq__32846_32908,chunk__32847_32909,count__32848_32910,i__32849_32911,map__32906_33082,map__32906_33083__$1,gline_33084,gcol_33085,name_33086,seq__32900_33076__$1,temp__4657__auto___33075__$2,vec__32897_33059,column_33060,column_info_33061,seq__32882_33053__$1,temp__4657__auto___33052__$1,vec__32879_33009,line_33010,columns_33011,seq__32846_33003__$1,temp__4657__auto___33002,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_33085], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_33010,new cljs.core.Keyword(null,"col","col",-1959363084),column_33060,new cljs.core.Keyword(null,"name","name",1843675177),name_33086], null));
});})(seq__32900_33062,chunk__32901_33063,count__32902_33064,i__32903_33065,seq__32882_33012,chunk__32883_33013,count__32884_33014,i__32885_33015,seq__32846_32908,chunk__32847_32909,count__32848_32910,i__32849_32911,map__32906_33082,map__32906_33083__$1,gline_33084,gcol_33085,name_33086,seq__32900_33076__$1,temp__4657__auto___33075__$2,vec__32897_33059,column_33060,column_info_33061,seq__32882_33053__$1,temp__4657__auto___33052__$1,vec__32879_33009,line_33010,columns_33011,seq__32846_33003__$1,temp__4657__auto___33002,inverted))
,cljs.core.sorted_map.call(null)));

var G__33087 = cljs.core.next.call(null,seq__32900_33076__$1);
var G__33088 = null;
var G__33089 = (0);
var G__33090 = (0);
seq__32900_33062 = G__33087;
chunk__32901_33063 = G__33088;
count__32902_33064 = G__33089;
i__32903_33065 = G__33090;
continue;
}
} else {
}
}
break;
}

var G__33091 = cljs.core.next.call(null,seq__32882_33053__$1);
var G__33092 = null;
var G__33093 = (0);
var G__33094 = (0);
seq__32882_33012 = G__33091;
chunk__32883_33013 = G__33092;
count__32884_33014 = G__33093;
i__32885_33015 = G__33094;
continue;
}
} else {
}
}
break;
}

var G__33095 = cljs.core.next.call(null,seq__32846_33003__$1);
var G__33096 = null;
var G__33097 = (0);
var G__33098 = (0);
seq__32846_32908 = G__33095;
chunk__32847_32909 = G__33096;
count__32848_32910 = G__33097;
i__32849_32911 = G__33098;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref.call(null,inverted);
});

//# sourceMappingURL=source_map.js.map?rel=1503590905424
