// Compiled by ClojureScript 1.9.908 {}
goog.provide('cljs.core$macros');
goog.require('cljs.core');
goog.require('clojure.walk');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('cljs.compiler');
goog.require('cljs.env');
goog.require('cljs.core');
goog.require('cljs.analyzer');
var ret__29198__auto___34253 = (function (){
/**
 * Threads the expr through the forms. Inserts x as the
 *   second item in the first form, making a list of it if it is not a
 *   list already. If there are more forms, inserts the first form as the
 *   second item in second form, etc.
 */
cljs.core$macros.__GT_ = (function cljs$core$macros$__GT_(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34254 = arguments.length;
var i__29159__auto___34255 = (0);
while(true){
if((i__29159__auto___34255 < len__29158__auto___34254)){
args__29165__auto__.push((arguments[i__29159__auto___34255]));

var G__34256 = (i__29159__auto___34255 + (1));
i__29159__auto___34255 = G__34256;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((3) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29166__auto__);
});

cljs.core$macros.__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,forms){
var x__$1 = x;
var forms__$1 = forms;
while(true){
if(cljs.core.truth_(forms__$1)){
var form = cljs.core.first.call(null,forms__$1);
var threaded = ((cljs.core.seq_QMARK_.call(null,form))?cljs.core.with_meta.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = cljs.core.first.call(null,form);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = x__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core.next.call(null,form)))),cljs.core.meta.call(null,form)):(function (){var x__28851__auto__ = form;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = x__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})());
var G__34257 = threaded;
var G__34258 = cljs.core.next.call(null,forms__$1);
x__$1 = G__34257;
forms__$1 = G__34258;
continue;
} else {
return x__$1;
}
break;
}
});

cljs.core$macros.__GT_.cljs$lang$maxFixedArity = (3);

cljs.core$macros.__GT_.cljs$lang$applyTo = (function (seq34249){
var G__34250 = cljs.core.first.call(null,seq34249);
var seq34249__$1 = cljs.core.next.call(null,seq34249);
var G__34251 = cljs.core.first.call(null,seq34249__$1);
var seq34249__$2 = cljs.core.next.call(null,seq34249__$1);
var G__34252 = cljs.core.first.call(null,seq34249__$2);
var seq34249__$3 = cljs.core.next.call(null,seq34249__$2);
return cljs.core$macros.__GT_.cljs$core$IFn$_invoke$arity$variadic(G__34250,G__34251,G__34252,seq34249__$3);
});

return null;
})()
;
cljs.core$macros.__GT_.cljs$lang$macro = true;

var ret__29198__auto___34263 = (function (){
/**
 * Threads the expr through the forms. Inserts x as the
 *   last item in the first form, making a list of it if it is not a
 *   list already. If there are more forms, inserts the first form as the
 *   last item in second form, etc.
 */
cljs.core$macros.__GT__GT_ = (function cljs$core$macros$__GT__GT_(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34264 = arguments.length;
var i__29159__auto___34265 = (0);
while(true){
if((i__29159__auto___34265 < len__29158__auto___34264)){
args__29165__auto__.push((arguments[i__29159__auto___34265]));

var G__34266 = (i__29159__auto___34265 + (1));
i__29159__auto___34265 = G__34266;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((3) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.__GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29166__auto__);
});

cljs.core$macros.__GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,forms){
var x__$1 = x;
var forms__$1 = forms;
while(true){
if(cljs.core.truth_(forms__$1)){
var form = cljs.core.first.call(null,forms__$1);
var threaded = ((cljs.core.seq_QMARK_.call(null,form))?cljs.core.with_meta.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = cljs.core.first.call(null,form);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core.next.call(null,form),(function (){var x__28851__auto__ = x__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))),cljs.core.meta.call(null,form)):(function (){var x__28851__auto__ = form;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = x__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})());
var G__34267 = threaded;
var G__34268 = cljs.core.next.call(null,forms__$1);
x__$1 = G__34267;
forms__$1 = G__34268;
continue;
} else {
return x__$1;
}
break;
}
});

cljs.core$macros.__GT__GT_.cljs$lang$maxFixedArity = (3);

cljs.core$macros.__GT__GT_.cljs$lang$applyTo = (function (seq34259){
var G__34260 = cljs.core.first.call(null,seq34259);
var seq34259__$1 = cljs.core.next.call(null,seq34259);
var G__34261 = cljs.core.first.call(null,seq34259__$1);
var seq34259__$2 = cljs.core.next.call(null,seq34259__$1);
var G__34262 = cljs.core.first.call(null,seq34259__$2);
var seq34259__$3 = cljs.core.next.call(null,seq34259__$2);
return cljs.core$macros.__GT__GT_.cljs$core$IFn$_invoke$arity$variadic(G__34260,G__34261,G__34262,seq34259__$3);
});

return null;
})()
;
cljs.core$macros.__GT__GT_.cljs$lang$macro = true;

var ret__29198__auto___34276 = (function (){
/**
 * form => fieldName-symbol or (instanceMethodName-symbol args*)
 * 
 *   Expands into a member access (.) of the first member on the first
 *   argument, followed by the next member on the result, etc. For
 *   instance:
 * 
 *   (.. System (getProperties) (get "os.name"))
 * 
 *   expands to:
 * 
 *   (. (. System (getProperties)) (get "os.name"))
 * 
 *   but is easier to write, read, and understand.
 */
cljs.core$macros._DOT__DOT_ = (function cljs$core$macros$_DOT__DOT_(var_args){
var G__34275 = arguments.length;
switch (G__34275) {
case 4:
return cljs.core$macros._DOT__DOT_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__29177__auto__ = [];
var len__29158__auto___34278 = arguments.length;
var i__29159__auto___34279 = (0);
while(true){
if((i__29159__auto___34279 < len__29158__auto___34278)){
args_arr__29177__auto__.push((arguments[i__29159__auto___34279]));

var G__34280 = (i__29159__auto___34279 + (1));
i__29159__auto___34279 = G__34280;
continue;
} else {
}
break;
}

var argseq__29178__auto__ = (new cljs.core.IndexedSeq(args_arr__29177__auto__.slice((4)),(0),null));
return cljs.core$macros._DOT__DOT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__29178__auto__);

}
});

cljs.core$macros._DOT__DOT_.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,form){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = form;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros._DOT__DOT_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,form,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"..","..",-300507420,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = form;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),more)));
});

cljs.core$macros._DOT__DOT_.cljs$lang$applyTo = (function (seq34270){
var G__34271 = cljs.core.first.call(null,seq34270);
var seq34270__$1 = cljs.core.next.call(null,seq34270);
var G__34272 = cljs.core.first.call(null,seq34270__$1);
var seq34270__$2 = cljs.core.next.call(null,seq34270__$1);
var G__34273 = cljs.core.first.call(null,seq34270__$2);
var seq34270__$3 = cljs.core.next.call(null,seq34270__$2);
var G__34274 = cljs.core.first.call(null,seq34270__$3);
var seq34270__$4 = cljs.core.next.call(null,seq34270__$3);
return cljs.core$macros._DOT__DOT_.cljs$core$IFn$_invoke$arity$variadic(G__34271,G__34272,G__34273,G__34274,seq34270__$4);
});

cljs.core$macros._DOT__DOT_.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros._DOT__DOT_.cljs$lang$macro = true;

var ret__29198__auto___34284 = (function (){
/**
 * Ignores body, yields nil
 */
cljs.core$macros.comment = (function cljs$core$macros$comment(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34285 = arguments.length;
var i__29159__auto___34286 = (0);
while(true){
if((i__29159__auto___34286 < len__29158__auto___34285)){
args__29165__auto__.push((arguments[i__29159__auto___34286]));

var G__34287 = (i__29159__auto___34286 + (1));
i__29159__auto___34286 = G__34287;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((2) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.comment.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29166__auto__);
});

cljs.core$macros.comment.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,body){
return null;
});

cljs.core$macros.comment.cljs$lang$maxFixedArity = (2);

cljs.core$macros.comment.cljs$lang$applyTo = (function (seq34281){
var G__34282 = cljs.core.first.call(null,seq34281);
var seq34281__$1 = cljs.core.next.call(null,seq34281);
var G__34283 = cljs.core.first.call(null,seq34281__$1);
var seq34281__$2 = cljs.core.next.call(null,seq34281__$1);
return cljs.core$macros.comment.cljs$core$IFn$_invoke$arity$variadic(G__34282,G__34283,seq34281__$2);
});

return null;
})()
;
cljs.core$macros.comment.cljs$lang$macro = true;

var ret__29198__auto___34291 = (function (){
/**
 * Takes a set of test/expr pairs. It evaluates each test one at a
 *   time.  If a test returns logical true, cond evaluates and returns
 *   the value of the corresponding expr and doesn't evaluate any of the
 *   other tests or exprs. (cond) returns nil.
 */
cljs.core$macros.cond = (function cljs$core$macros$cond(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34292 = arguments.length;
var i__29159__auto___34293 = (0);
while(true){
if((i__29159__auto___34293 < len__29158__auto___34292)){
args__29165__auto__.push((arguments[i__29159__auto___34293]));

var G__34294 = (i__29159__auto___34293 + (1));
i__29159__auto___34293 = G__34294;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((2) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.cond.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29166__auto__);
});

cljs.core$macros.cond.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,clauses){
if(cljs.core.truth_(clauses)){
return cljs.core._conj.call(null,(function (){var x__28851__auto__ = cljs.core.first.call(null,clauses);
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = ((cljs.core.next.call(null,clauses))?cljs.core.second.call(null,clauses):(function(){throw (new Error("cond requires an even number of forms"))})());
return cljs.core._conj.call(null,(function (){var x__28851__auto____$2 = cljs.core.cons.call(null,new cljs.core.Symbol("cljs.core","cond","cljs.core/cond",2005388338,null),cljs.core.next.call(null,cljs.core.next.call(null,clauses)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$2);
})(),x__28851__auto____$1);
})(),x__28851__auto__);
})(),new cljs.core.Symbol(null,"if","if",1181717262,null));
} else {
return null;
}
});

cljs.core$macros.cond.cljs$lang$maxFixedArity = (2);

cljs.core$macros.cond.cljs$lang$applyTo = (function (seq34288){
var G__34289 = cljs.core.first.call(null,seq34288);
var seq34288__$1 = cljs.core.next.call(null,seq34288);
var G__34290 = cljs.core.first.call(null,seq34288__$1);
var seq34288__$2 = cljs.core.next.call(null,seq34288__$1);
return cljs.core$macros.cond.cljs$core$IFn$_invoke$arity$variadic(G__34289,G__34290,seq34288__$2);
});

return null;
})()
;
cljs.core$macros.cond.cljs$lang$macro = true;

var ret__29198__auto___34299 = (function (){
/**
 * defs the supplied var names with no bindings, useful for making forward declarations.
 */
cljs.core$macros.declare = (function cljs$core$macros$declare(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34300 = arguments.length;
var i__29159__auto___34301 = (0);
while(true){
if((i__29159__auto___34301 < len__29158__auto___34300)){
args__29165__auto__.push((arguments[i__29159__auto___34301]));

var G__34302 = (i__29159__auto___34301 + (1));
i__29159__auto___34301 = G__34302;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((2) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.declare.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29166__auto__);
});

cljs.core$macros.declare.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,names){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),cljs.core.map.call(null,(function (p1__34295_SHARP_){
return cljs.core._conj.call(null,(function (){var x__28851__auto__ = cljs.core.vary_meta.call(null,p1__34295_SHARP_,cljs.core.assoc,new cljs.core.Keyword(null,"declared","declared",92336021),true);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),new cljs.core.Symbol(null,"def","def",597100991,null));
}),names))));
});

cljs.core$macros.declare.cljs$lang$maxFixedArity = (2);

cljs.core$macros.declare.cljs$lang$applyTo = (function (seq34296){
var G__34297 = cljs.core.first.call(null,seq34296);
var seq34296__$1 = cljs.core.next.call(null,seq34296);
var G__34298 = cljs.core.first.call(null,seq34296__$1);
var seq34296__$2 = cljs.core.next.call(null,seq34296__$1);
return cljs.core$macros.declare.cljs$core$IFn$_invoke$arity$variadic(G__34297,G__34298,seq34296__$2);
});

return null;
})()
;
cljs.core$macros.declare.cljs$lang$macro = true;

var ret__29198__auto___34307 = (function (){
/**
 * Evaluates x then calls all of the methods and functions with the
 *   value of x supplied at the front of the given arguments.  The forms
 *   are evaluated in order.  Returns x.
 * 
 *   (doto (new java.util.HashMap) (.put "a" 1) (.put "b" 2))
 */
cljs.core$macros.doto = (function cljs$core$macros$doto(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34308 = arguments.length;
var i__29159__auto___34309 = (0);
while(true){
if((i__29159__auto___34309 < len__29158__auto___34308)){
args__29165__auto__.push((arguments[i__29159__auto___34309]));

var G__34310 = (i__29159__auto___34309 + (1));
i__29159__auto___34309 = G__34310;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((3) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.doto.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29166__auto__);
});

cljs.core$macros.doto.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,forms){
var gx = cljs.core.gensym.call(null);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = gx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core.map.call(null,((function (gx){
return (function (f){
if(cljs.core.seq_QMARK_.call(null,f)){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = cljs.core.first.call(null,f);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = gx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core.next.call(null,f))));
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = f;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = gx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
}
});})(gx))
,forms),(function (){var x__28851__auto__ = gx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.doto.cljs$lang$maxFixedArity = (3);

cljs.core$macros.doto.cljs$lang$applyTo = (function (seq34303){
var G__34304 = cljs.core.first.call(null,seq34303);
var seq34303__$1 = cljs.core.next.call(null,seq34303);
var G__34305 = cljs.core.first.call(null,seq34303__$1);
var seq34303__$2 = cljs.core.next.call(null,seq34303__$1);
var G__34306 = cljs.core.first.call(null,seq34303__$2);
var seq34303__$3 = cljs.core.next.call(null,seq34303__$2);
return cljs.core$macros.doto.cljs$core$IFn$_invoke$arity$variadic(G__34304,G__34305,G__34306,seq34303__$3);
});

return null;
})()
;
cljs.core$macros.doto.cljs$lang$macro = true;

cljs.core$macros.parse_impls = (function cljs$core$macros$parse_impls(specs){
var ret = cljs.core.PersistentArrayMap.EMPTY;
var s = specs;
while(true){
if(cljs.core.seq.call(null,s)){
var G__34311 = cljs.core.assoc.call(null,ret,cljs.core.first.call(null,s),cljs.core.take_while.call(null,cljs.core.seq_QMARK_,cljs.core.next.call(null,s)));
var G__34312 = cljs.core.drop_while.call(null,cljs.core.seq_QMARK_,cljs.core.next.call(null,s));
ret = G__34311;
s = G__34312;
continue;
} else {
return ret;
}
break;
}
});
cljs.core$macros.emit_extend_protocol = (function cljs$core$macros$emit_extend_protocol(p,specs){
var impls = cljs.core$macros.parse_impls.call(null,specs);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),cljs.core.map.call(null,((function (impls){
return (function (p__34313){
var vec__34314 = p__34313;
var t = cljs.core.nth.call(null,vec__34314,(0),null);
var fs = cljs.core.nth.call(null,vec__34314,(1),null);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","extend-type","cljs.core$macros/extend-type",1713295201,null)),(function (){var x__28851__auto__ = t;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = p;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),fs)));
});})(impls))
,impls))));
});
var ret__29198__auto___34321 = (function (){
/**
 * Useful when you want to provide several implementations of the same
 *   protocol all at once. Takes a single protocol and the implementation
 *   of that protocol for one or more types. Expands into calls to
 *   extend-type:
 * 
 *   (extend-protocol Protocol
 *     AType
 *       (foo [x] ...)
 *       (bar [x y] ...)
 *     BType
 *       (foo [x] ...)
 *       (bar [x y] ...)
 *     AClass
 *       (foo [x] ...)
 *       (bar [x y] ...)
 *     nil
 *       (foo [x] ...)
 *       (bar [x y] ...))
 * 
 *   expands into:
 * 
 *   (do
 *    (clojure.core/extend-type AType Protocol
 *      (foo [x] ...)
 *      (bar [x y] ...))
 *    (clojure.core/extend-type BType Protocol
 *      (foo [x] ...)
 *      (bar [x y] ...))
 *    (clojure.core/extend-type AClass Protocol
 *      (foo [x] ...)
 *      (bar [x y] ...))
 *    (clojure.core/extend-type nil Protocol
 *      (foo [x] ...)
 *      (bar [x y] ...)))
 */
cljs.core$macros.extend_protocol = (function cljs$core$macros$extend_protocol(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34322 = arguments.length;
var i__29159__auto___34323 = (0);
while(true){
if((i__29159__auto___34323 < len__29158__auto___34322)){
args__29165__auto__.push((arguments[i__29159__auto___34323]));

var G__34324 = (i__29159__auto___34323 + (1));
i__29159__auto___34323 = G__34324;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((3) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.extend_protocol.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29166__auto__);
});

cljs.core$macros.extend_protocol.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,p,specs){
return cljs.core$macros.emit_extend_protocol.call(null,p,specs);
});

cljs.core$macros.extend_protocol.cljs$lang$maxFixedArity = (3);

cljs.core$macros.extend_protocol.cljs$lang$applyTo = (function (seq34317){
var G__34318 = cljs.core.first.call(null,seq34317);
var seq34317__$1 = cljs.core.next.call(null,seq34317);
var G__34319 = cljs.core.first.call(null,seq34317__$1);
var seq34317__$2 = cljs.core.next.call(null,seq34317__$1);
var G__34320 = cljs.core.first.call(null,seq34317__$2);
var seq34317__$3 = cljs.core.next.call(null,seq34317__$2);
return cljs.core$macros.extend_protocol.cljs$core$IFn$_invoke$arity$variadic(G__34318,G__34319,G__34320,seq34317__$3);
});

return null;
})()
;
cljs.core$macros.extend_protocol.cljs$lang$macro = true;

cljs.core$macros.maybe_destructured = (function cljs$core$macros$maybe_destructured(params,body){
if(cljs.core.every_QMARK_.call(null,cljs.core.symbol_QMARK_,params)){
return cljs.core.cons.call(null,params,body);
} else {
var params__$1 = params;
var new_params = cljs.core.with_meta.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.meta.call(null,params__$1));
var lets = cljs.core.PersistentVector.EMPTY;
while(true){
if(cljs.core.truth_(params__$1)){
if((cljs.core.first.call(null,params__$1) instanceof cljs.core.Symbol)){
var G__34325 = cljs.core.next.call(null,params__$1);
var G__34326 = cljs.core.conj.call(null,new_params,cljs.core.first.call(null,params__$1));
var G__34327 = lets;
params__$1 = G__34325;
new_params = G__34326;
lets = G__34327;
continue;
} else {
var gparam = cljs.core.gensym.call(null,"p__");
var G__34328 = cljs.core.next.call(null,params__$1);
var G__34329 = cljs.core.conj.call(null,new_params,gparam);
var G__34330 = cljs.core.conj.call(null,cljs.core.conj.call(null,lets,cljs.core.first.call(null,params__$1)),gparam);
params__$1 = G__34328;
new_params = G__34329;
lets = G__34330;
continue;
}
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = new_params;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = lets;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),body)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
}
break;
}
}
});
var ret__29198__auto___34337 = (function (){
/**
 * params => positional-params* , or positional-params* & next-param
 *   positional-param => binding-form
 *   next-param => binding-form
 *   name => symbol
 * 
 *   Defines a function
 */
cljs.core$macros.fn = (function cljs$core$macros$fn(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34338 = arguments.length;
var i__29159__auto___34339 = (0);
while(true){
if((i__29159__auto___34339 < len__29158__auto___34338)){
args__29165__auto__.push((arguments[i__29159__auto___34339]));

var G__34340 = (i__29159__auto___34339 + (1));
i__29159__auto___34339 = G__34340;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((2) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.fn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29166__auto__);
});

cljs.core$macros.fn.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,sigs){
var name = (((cljs.core.first.call(null,sigs) instanceof cljs.core.Symbol))?cljs.core.first.call(null,sigs):null);
var sigs__$1 = (cljs.core.truth_(name)?cljs.core.next.call(null,sigs):sigs);
var sigs__$2 = ((cljs.core.vector_QMARK_.call(null,cljs.core.first.call(null,sigs__$1)))?(function (){var x__28851__auto__ = sigs__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})():((cljs.core.seq_QMARK_.call(null,cljs.core.first.call(null,sigs__$1)))?sigs__$1:(function(){throw (new Error(((cljs.core.seq.call(null,sigs__$1))?["Parameter declaration ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,sigs__$1))," should be a vector"].join(''):["Parameter declaration missing"].join(''))))})()));
var psig = ((function (name,sigs__$1,sigs__$2){
return (function (sig){
if(!(cljs.core.seq_QMARK_.call(null,sig))){
throw (new Error(["Invalid signature ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(sig)," should be a list"].join('')));
} else {
}

var vec__34334 = sig;
var seq__34335 = cljs.core.seq.call(null,vec__34334);
var first__34336 = cljs.core.first.call(null,seq__34335);
var seq__34335__$1 = cljs.core.next.call(null,seq__34335);
var params = first__34336;
var body = seq__34335__$1;
var _ = ((!(cljs.core.vector_QMARK_.call(null,params)))?(function(){throw (new Error(((cljs.core.seq_QMARK_.call(null,cljs.core.first.call(null,sigs__$2)))?["Parameter declaration ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(params)," should be a vector"].join(''):["Invalid signature ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(sig)," should be a list"].join(''))))})():null);
var conds = (((cljs.core.next.call(null,body)) && (cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))))?cljs.core.first.call(null,body):null);
var body__$1 = (cljs.core.truth_(conds)?cljs.core.next.call(null,body):body);
var conds__$1 = (function (){var or__27989__auto__ = conds;
if(cljs.core.truth_(or__27989__auto__)){
return or__27989__auto__;
} else {
return cljs.core.meta.call(null,params);
}
})();
var pre = new cljs.core.Keyword(null,"pre","pre",2118456869).cljs$core$IFn$_invoke$arity$1(conds__$1);
var post = new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(conds__$1);
var body__$2 = (cljs.core.truth_(post)?cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"%","%",-950237169,null)),(function (){var x__28851__auto__ = ((((1) < cljs.core.count.call(null,body__$1)))?cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),body__$1))):cljs.core.first.call(null,body__$1));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core.map.call(null,((function (vec__34334,seq__34335,first__34336,seq__34335__$1,params,body,_,conds,body__$1,conds__$1,pre,post,name,sigs__$1,sigs__$2){
return (function (c){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","assert","cljs.core$macros/assert",1333198789,null)),(function (){var x__28851__auto__ = c;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});})(vec__34334,seq__34335,first__34336,seq__34335__$1,params,body,_,conds,body__$1,conds__$1,pre,post,name,sigs__$1,sigs__$2))
,post),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"%","%",-950237169,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))):body__$1);
var body__$3 = (cljs.core.truth_(pre)?cljs.core.concat.call(null,cljs.core.map.call(null,((function (vec__34334,seq__34335,first__34336,seq__34335__$1,params,body,_,conds,body__$1,conds__$1,pre,post,body__$2,name,sigs__$1,sigs__$2){
return (function (c){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","assert","cljs.core$macros/assert",1333198789,null)),(function (){var x__28851__auto__ = c;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});})(vec__34334,seq__34335,first__34336,seq__34335__$1,params,body,_,conds,body__$1,conds__$1,pre,post,body__$2,name,sigs__$1,sigs__$2))
,pre),body__$2):body__$2);
return cljs.core$macros.maybe_destructured.call(null,params,body__$3);
});})(name,sigs__$1,sigs__$2))
;
var new_sigs = cljs.core.map.call(null,psig,sigs__$2);
return cljs.core.with_meta.call(null,(cljs.core.truth_(name)?cljs.core.list_STAR_.call(null,new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),name,new_sigs):cljs.core.cons.call(null,new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new_sigs)),cljs.core.meta.call(null,_AMPERSAND_form));
});

cljs.core$macros.fn.cljs$lang$maxFixedArity = (2);

cljs.core$macros.fn.cljs$lang$applyTo = (function (seq34331){
var G__34332 = cljs.core.first.call(null,seq34331);
var seq34331__$1 = cljs.core.next.call(null,seq34331);
var G__34333 = cljs.core.first.call(null,seq34331__$1);
var seq34331__$2 = cljs.core.next.call(null,seq34331__$1);
return cljs.core$macros.fn.cljs$core$IFn$_invoke$arity$variadic(G__34332,G__34333,seq34331__$2);
});

return null;
})()
;
cljs.core$macros.fn.cljs$lang$macro = true;

var ret__29198__auto___34345 = (function (){
/**
 * same as defn, yielding non-public def
 */
cljs.core$macros.defn_ = (function cljs$core$macros$defn_(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34346 = arguments.length;
var i__29159__auto___34347 = (0);
while(true){
if((i__29159__auto___34347 < len__29158__auto___34346)){
args__29165__auto__.push((arguments[i__29159__auto___34347]));

var G__34348 = (i__29159__auto___34347 + (1));
i__29159__auto___34347 = G__34348;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((3) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.defn_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29166__auto__);
});

cljs.core$macros.defn_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,name,decls){
return cljs.core.list_STAR_.call(null,new cljs.core.Symbol("cljs.core$macros","defn","cljs.core$macros/defn",-728332354,null),cljs.core.with_meta.call(null,name,cljs.core.assoc.call(null,cljs.core.meta.call(null,name),new cljs.core.Keyword(null,"private","private",-558947994),true)),decls);
});

cljs.core$macros.defn_.cljs$lang$maxFixedArity = (3);

cljs.core$macros.defn_.cljs$lang$applyTo = (function (seq34341){
var G__34342 = cljs.core.first.call(null,seq34341);
var seq34341__$1 = cljs.core.next.call(null,seq34341);
var G__34343 = cljs.core.first.call(null,seq34341__$1);
var seq34341__$2 = cljs.core.next.call(null,seq34341__$1);
var G__34344 = cljs.core.first.call(null,seq34341__$2);
var seq34341__$3 = cljs.core.next.call(null,seq34341__$2);
return cljs.core$macros.defn_.cljs$core$IFn$_invoke$arity$variadic(G__34342,G__34343,G__34344,seq34341__$3);
});

return null;
})()
;
cljs.core$macros.defn_.cljs$lang$macro = true;

var ret__29198__auto___34358 = (function (){
/**
 * bindings => binding-form test
 * 
 *   If test is true, evaluates then with binding-form bound to the value of
 *   test, if not, yields else
 */
cljs.core$macros.if_let = (function cljs$core$macros$if_let(var_args){
var G__34357 = arguments.length;
switch (G__34357) {
case 4:
return cljs.core$macros.if_let.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__29177__auto__ = [];
var len__29158__auto___34360 = arguments.length;
var i__29159__auto___34361 = (0);
while(true){
if((i__29159__auto___34361 < len__29158__auto___34360)){
args_arr__29177__auto__.push((arguments[i__29159__auto___34361]));

var G__34362 = (i__29159__auto___34361 + (1));
i__29159__auto___34361 = G__34362;
continue;
} else {
}
break;
}

var argseq__29178__auto__ = (new cljs.core.IndexedSeq(args_arr__29177__auto__.slice((5)),(0),null));
return cljs.core$macros.if_let.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__29178__auto__);

}
});

cljs.core$macros.if_let.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,bindings,then){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","if-let","cljs.core$macros/if-let",1291543946,null)),(function (){var x__28851__auto__ = bindings;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = then;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
});

cljs.core$macros.if_let.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,bindings,then,else$,oldform){
if(cljs.core.vector_QMARK_.call(null,bindings)){
} else {
throw cljs.core.ex_info.call(null,"if-let requires a vector for its binding",cljs.core.PersistentArrayMap.EMPTY);
}

if(cljs.core.empty_QMARK_.call(null,oldform)){
} else {
throw cljs.core.ex_info.call(null,"if-let requires 1 or 2 forms after binding vector",cljs.core.PersistentArrayMap.EMPTY);
}

if(cljs.core._EQ_.call(null,(2),cljs.core.count.call(null,bindings))){
} else {
throw cljs.core.ex_info.call(null,"if-let requires exactly 2 forms in binding vector",cljs.core.PersistentArrayMap.EMPTY);
}


var form = bindings.call(null,(0));
var tst = bindings.call(null,(1));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"temp__34349__auto__","temp__34349__auto__",1503987120,null)),(function (){var x__28851__auto__ = tst;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"temp__34349__auto__","temp__34349__auto__",1503987120,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = form;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"temp__34349__auto__","temp__34349__auto__",1503987120,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = then;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = else$;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.if_let.cljs$lang$applyTo = (function (seq34351){
var G__34352 = cljs.core.first.call(null,seq34351);
var seq34351__$1 = cljs.core.next.call(null,seq34351);
var G__34353 = cljs.core.first.call(null,seq34351__$1);
var seq34351__$2 = cljs.core.next.call(null,seq34351__$1);
var G__34354 = cljs.core.first.call(null,seq34351__$2);
var seq34351__$3 = cljs.core.next.call(null,seq34351__$2);
var G__34355 = cljs.core.first.call(null,seq34351__$3);
var seq34351__$4 = cljs.core.next.call(null,seq34351__$3);
var G__34356 = cljs.core.first.call(null,seq34351__$4);
var seq34351__$5 = cljs.core.next.call(null,seq34351__$4);
return cljs.core$macros.if_let.cljs$core$IFn$_invoke$arity$variadic(G__34352,G__34353,G__34354,G__34355,G__34356,seq34351__$5);
});

cljs.core$macros.if_let.cljs$lang$maxFixedArity = (5);

return null;
})()
;
cljs.core$macros.if_let.cljs$lang$macro = true;

var ret__29198__auto___34365 = (function (){
/**
 * Evaluates test. If logical false, evaluates and returns then expr,
 *   otherwise else expr, if supplied, else nil.
 */
cljs.core$macros.if_not = (function cljs$core$macros$if_not(var_args){
var G__34364 = arguments.length;
switch (G__34364) {
case 4:
return cljs.core$macros.if_not.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core$macros.if_not.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (2)))].join('')));

}
});

cljs.core$macros.if_not.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,test,then){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","if-not","cljs.core$macros/if-not",-1825285737,null)),(function (){var x__28851__auto__ = test;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = then;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
});

cljs.core$macros.if_not.cljs$core$IFn$_invoke$arity$5 = (function (_AMPERSAND_form,_AMPERSAND_env,test,then,else$){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null)),(function (){var x__28851__auto__ = test;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = then;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = else$;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.if_not.cljs$lang$maxFixedArity = 5;

return null;
})()
;
cljs.core$macros.if_not.cljs$lang$macro = true;

var ret__29198__auto___34372 = (function (){
/**
 * fnspec ==> (fname [params*] exprs) or (fname ([params*] exprs)+)
 * 
 *   Takes a vector of function specs and a body, and generates a set of
 *   bindings of functions to their names. All of the names are available
 *   in all of the definitions of the functions, as well as the body.
 */
cljs.core$macros.letfn = (function cljs$core$macros$letfn(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34373 = arguments.length;
var i__29159__auto___34374 = (0);
while(true){
if((i__29159__auto___34374 < len__29158__auto___34373)){
args__29165__auto__.push((arguments[i__29159__auto___34374]));

var G__34375 = (i__29159__auto___34374 + (1));
i__29159__auto___34374 = G__34375;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((3) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.letfn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29166__auto__);
});

cljs.core$macros.letfn.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,fnspecs,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"letfn*","letfn*",-110097810,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.interleave.call(null,cljs.core.map.call(null,cljs.core.first,fnspecs),cljs.core.map.call(null,(function (p1__34367_SHARP_){
return cljs.core.cons.call(null,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null),p1__34367_SHARP_);
}),fnspecs)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),body)));
});

cljs.core$macros.letfn.cljs$lang$maxFixedArity = (3);

cljs.core$macros.letfn.cljs$lang$applyTo = (function (seq34368){
var G__34369 = cljs.core.first.call(null,seq34368);
var seq34368__$1 = cljs.core.next.call(null,seq34368);
var G__34370 = cljs.core.first.call(null,seq34368__$1);
var seq34368__$2 = cljs.core.next.call(null,seq34368__$1);
var G__34371 = cljs.core.first.call(null,seq34368__$2);
var seq34368__$3 = cljs.core.next.call(null,seq34368__$2);
return cljs.core$macros.letfn.cljs$core$IFn$_invoke$arity$variadic(G__34369,G__34370,G__34371,seq34368__$3);
});

return null;
})()
;
cljs.core$macros.letfn.cljs$lang$macro = true;

var ret__29198__auto___34380 = (function (){
/**
 * Expands into code that creates a fn that expects to be passed an
 *   object and any args and calls the named instance method on the
 *   object passing the args. Use when you want to treat a JavaScript
 *   method as a first-class fn.
 */
cljs.core$macros.memfn = (function cljs$core$macros$memfn(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34381 = arguments.length;
var i__29159__auto___34382 = (0);
while(true){
if((i__29159__auto___34382 < len__29158__auto___34381)){
args__29165__auto__.push((arguments[i__29159__auto___34382]));

var G__34383 = (i__29159__auto___34382 + (1));
i__29159__auto___34382 = G__34383;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((3) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.memfn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29166__auto__);
});

cljs.core$macros.memfn.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,name,args){
var t = cljs.core.with_meta.call(null,cljs.core.gensym.call(null,"target"),cljs.core.meta.call(null,name));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = t;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),args))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__28851__auto__ = t;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),args)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.memfn.cljs$lang$maxFixedArity = (3);

cljs.core$macros.memfn.cljs$lang$applyTo = (function (seq34376){
var G__34377 = cljs.core.first.call(null,seq34376);
var seq34376__$1 = cljs.core.next.call(null,seq34376);
var G__34378 = cljs.core.first.call(null,seq34376__$1);
var seq34376__$2 = cljs.core.next.call(null,seq34376__$1);
var G__34379 = cljs.core.first.call(null,seq34376__$2);
var seq34376__$3 = cljs.core.next.call(null,seq34376__$2);
return cljs.core$macros.memfn.cljs$core$IFn$_invoke$arity$variadic(G__34377,G__34378,G__34379,seq34376__$3);
});

return null;
})()
;
cljs.core$macros.memfn.cljs$lang$macro = true;

var ret__29198__auto___34388 = (function (){
/**
 * Evaluates test. If logical true, evaluates body in an implicit do.
 */
cljs.core$macros.when = (function cljs$core$macros$when(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34389 = arguments.length;
var i__29159__auto___34390 = (0);
while(true){
if((i__29159__auto___34390 < len__29158__auto___34389)){
args__29165__auto__.push((arguments[i__29159__auto___34390]));

var G__34391 = (i__29159__auto___34390 + (1));
i__29159__auto___34390 = G__34391;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((3) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.when.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29166__auto__);
});

cljs.core$macros.when.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,test,body){
return cljs.core._conj.call(null,(function (){var x__28851__auto__ = test;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = cljs.core.cons.call(null,new cljs.core.Symbol(null,"do","do",1686842252,null),body);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),new cljs.core.Symbol(null,"if","if",1181717262,null));
});

cljs.core$macros.when.cljs$lang$maxFixedArity = (3);

cljs.core$macros.when.cljs$lang$applyTo = (function (seq34384){
var G__34385 = cljs.core.first.call(null,seq34384);
var seq34384__$1 = cljs.core.next.call(null,seq34384);
var G__34386 = cljs.core.first.call(null,seq34384__$1);
var seq34384__$2 = cljs.core.next.call(null,seq34384__$1);
var G__34387 = cljs.core.first.call(null,seq34384__$2);
var seq34384__$3 = cljs.core.next.call(null,seq34384__$2);
return cljs.core$macros.when.cljs$core$IFn$_invoke$arity$variadic(G__34385,G__34386,G__34387,seq34384__$3);
});

return null;
})()
;
cljs.core$macros.when.cljs$lang$macro = true;

var ret__29198__auto___34400 = (function (){
/**
 * bindings => x xs
 * 
 *   Roughly the same as (when (seq xs) (let [x (first xs)] body)) but xs is evaluated only once
 */
cljs.core$macros.when_first = (function cljs$core$macros$when_first(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34401 = arguments.length;
var i__29159__auto___34402 = (0);
while(true){
if((i__29159__auto___34402 < len__29158__auto___34401)){
args__29165__auto__.push((arguments[i__29159__auto___34402]));

var G__34403 = (i__29159__auto___34402 + (1));
i__29159__auto___34402 = G__34403;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((3) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.when_first.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29166__auto__);
});

cljs.core$macros.when_first.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,bindings,body){
if(cljs.core.vector_QMARK_.call(null,bindings)){
} else {
throw cljs.core.ex_info.call(null,"when-first requires a vector for its binding",cljs.core.PersistentArrayMap.EMPTY);
}

if(cljs.core._EQ_.call(null,(2),cljs.core.count.call(null,bindings))){
} else {
throw cljs.core.ex_info.call(null,"when-first requires exactly 2 forms in binding vector",cljs.core.PersistentArrayMap.EMPTY);
}


var vec__34397 = bindings;
var x = cljs.core.nth.call(null,vec__34397,(0),null);
var xs = cljs.core.nth.call(null,vec__34397,(1),null);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when-let","cljs.core$macros/when-let",-2004472648,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"xs__34392__auto__","xs__34392__auto__",188859589,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","seq","cljs.core/seq",-1649497689,null)),(function (){var x__28851__auto__ = xs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","first","cljs.core/first",-752535972,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"xs__34392__auto__","xs__34392__auto__",188859589,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),body)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.when_first.cljs$lang$maxFixedArity = (3);

cljs.core$macros.when_first.cljs$lang$applyTo = (function (seq34393){
var G__34394 = cljs.core.first.call(null,seq34393);
var seq34393__$1 = cljs.core.next.call(null,seq34393);
var G__34395 = cljs.core.first.call(null,seq34393__$1);
var seq34393__$2 = cljs.core.next.call(null,seq34393__$1);
var G__34396 = cljs.core.first.call(null,seq34393__$2);
var seq34393__$3 = cljs.core.next.call(null,seq34393__$2);
return cljs.core$macros.when_first.cljs$core$IFn$_invoke$arity$variadic(G__34394,G__34395,G__34396,seq34393__$3);
});

return null;
})()
;
cljs.core$macros.when_first.cljs$lang$macro = true;

var ret__29198__auto___34409 = (function (){
/**
 * bindings => binding-form test
 * 
 *   When test is true, evaluates body with binding-form bound to the value of test
 */
cljs.core$macros.when_let = (function cljs$core$macros$when_let(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34410 = arguments.length;
var i__29159__auto___34411 = (0);
while(true){
if((i__29159__auto___34411 < len__29158__auto___34410)){
args__29165__auto__.push((arguments[i__29159__auto___34411]));

var G__34412 = (i__29159__auto___34411 + (1));
i__29159__auto___34411 = G__34412;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((3) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.when_let.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29166__auto__);
});

cljs.core$macros.when_let.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,bindings,body){
if(cljs.core.vector_QMARK_.call(null,bindings)){
} else {
throw cljs.core.ex_info.call(null,"when-let requires a vector for its binding",cljs.core.PersistentArrayMap.EMPTY);
}

if(cljs.core._EQ_.call(null,(2),cljs.core.count.call(null,bindings))){
} else {
throw cljs.core.ex_info.call(null,"when-let requires exactly 2 forms in binding vector",cljs.core.PersistentArrayMap.EMPTY);
}


var form = bindings.call(null,(0));
var tst = bindings.call(null,(1));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"temp__34404__auto__","temp__34404__auto__",30575036,null)),(function (){var x__28851__auto__ = tst;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when","cljs.core$macros/when",328457725,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"temp__34404__auto__","temp__34404__auto__",30575036,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = form;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"temp__34404__auto__","temp__34404__auto__",30575036,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),body)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.when_let.cljs$lang$maxFixedArity = (3);

cljs.core$macros.when_let.cljs$lang$applyTo = (function (seq34405){
var G__34406 = cljs.core.first.call(null,seq34405);
var seq34405__$1 = cljs.core.next.call(null,seq34405);
var G__34407 = cljs.core.first.call(null,seq34405__$1);
var seq34405__$2 = cljs.core.next.call(null,seq34405__$1);
var G__34408 = cljs.core.first.call(null,seq34405__$2);
var seq34405__$3 = cljs.core.next.call(null,seq34405__$2);
return cljs.core$macros.when_let.cljs$core$IFn$_invoke$arity$variadic(G__34406,G__34407,G__34408,seq34405__$3);
});

return null;
})()
;
cljs.core$macros.when_let.cljs$lang$macro = true;

var ret__29198__auto___34417 = (function (){
/**
 * Evaluates test. If logical false, evaluates body in an implicit do.
 */
cljs.core$macros.when_not = (function cljs$core$macros$when_not(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34418 = arguments.length;
var i__29159__auto___34419 = (0);
while(true){
if((i__29159__auto___34419 < len__29158__auto___34418)){
args__29165__auto__.push((arguments[i__29159__auto___34419]));

var G__34420 = (i__29159__auto___34419 + (1));
i__29159__auto___34419 = G__34420;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((3) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.when_not.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29166__auto__);
});

cljs.core$macros.when_not.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,test,body){
return cljs.core._conj.call(null,(function (){var x__28851__auto__ = test;
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = cljs.core.cons.call(null,new cljs.core.Symbol(null,"do","do",1686842252,null),body);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),null),x__28851__auto__);
})(),new cljs.core.Symbol(null,"if","if",1181717262,null));
});

cljs.core$macros.when_not.cljs$lang$maxFixedArity = (3);

cljs.core$macros.when_not.cljs$lang$applyTo = (function (seq34413){
var G__34414 = cljs.core.first.call(null,seq34413);
var seq34413__$1 = cljs.core.next.call(null,seq34413);
var G__34415 = cljs.core.first.call(null,seq34413__$1);
var seq34413__$2 = cljs.core.next.call(null,seq34413__$1);
var G__34416 = cljs.core.first.call(null,seq34413__$2);
var seq34413__$3 = cljs.core.next.call(null,seq34413__$2);
return cljs.core$macros.when_not.cljs$core$IFn$_invoke$arity$variadic(G__34414,G__34415,G__34416,seq34413__$3);
});

return null;
})()
;
cljs.core$macros.when_not.cljs$lang$macro = true;

var ret__29198__auto___34425 = (function (){
/**
 * Repeatedly executes body while test expression is true. Presumes
 *   some side-effect will cause test to become false/nil. Returns nil
 */
cljs.core$macros.while$ = (function cljs$core$macros$while(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34426 = arguments.length;
var i__29159__auto___34427 = (0);
while(true){
if((i__29159__auto___34427 < len__29158__auto___34426)){
args__29165__auto__.push((arguments[i__29159__auto___34427]));

var G__34428 = (i__29159__auto___34427 + (1));
i__29159__auto___34427 = G__34428;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((3) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.while$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29166__auto__);
});

cljs.core$macros.while$.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,test,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","loop","cljs.core$macros/loop",1731108390,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when","cljs.core$macros/when",328457725,null)),(function (){var x__28851__auto__ = test;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),body,(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"recur","recur",1202958259,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.while$.cljs$lang$maxFixedArity = (3);

cljs.core$macros.while$.cljs$lang$applyTo = (function (seq34421){
var G__34422 = cljs.core.first.call(null,seq34421);
var seq34421__$1 = cljs.core.next.call(null,seq34421);
var G__34423 = cljs.core.first.call(null,seq34421__$1);
var seq34421__$2 = cljs.core.next.call(null,seq34421__$1);
var G__34424 = cljs.core.first.call(null,seq34421__$2);
var seq34421__$3 = cljs.core.next.call(null,seq34421__$2);
return cljs.core$macros.while$.cljs$core$IFn$_invoke$arity$variadic(G__34422,G__34423,G__34424,seq34421__$3);
});

return null;
})()
;
cljs.core$macros.while$.cljs$lang$macro = true;

var ret__29198__auto___34437 = (function (){
/**
 * Takes an expression and a set of test/form pairs. Threads expr (via ->)
 *   through each form for which the corresponding test
 *   expression is true. Note that, unlike cond branching, cond-> threading does
 *   not short circuit after the first true test expression.
 */
cljs.core$macros.cond__GT_ = (function cljs$core$macros$cond__GT_(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34438 = arguments.length;
var i__29159__auto___34439 = (0);
while(true){
if((i__29159__auto___34439 < len__29158__auto___34438)){
args__29165__auto__.push((arguments[i__29159__auto___34439]));

var G__34440 = (i__29159__auto___34439 + (1));
i__29159__auto___34439 = G__34440;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((3) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.cond__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29166__auto__);
});

cljs.core$macros.cond__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,expr,clauses){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,clauses))){
} else {
throw (new Error("Assert failed: (even? (count clauses))"));
}

var g = cljs.core.gensym.call(null);
var steps = cljs.core.map.call(null,((function (g){
return (function (p__34433){
var vec__34434 = p__34433;
var test = cljs.core.nth.call(null,vec__34434,(0),null);
var step = cljs.core.nth.call(null,vec__34434,(1),null);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = test;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","->","cljs.core$macros/->",-1519455206,null)),(function (){var x__28851__auto__ = g;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = step;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = g;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});})(g))
,cljs.core.partition.call(null,(2),clauses));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = g;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = expr;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core.interleave.call(null,cljs.core.repeat.call(null,g),cljs.core.butlast.call(null,steps))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = ((cljs.core.empty_QMARK_.call(null,steps))?g:cljs.core.last.call(null,steps));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.cond__GT_.cljs$lang$maxFixedArity = (3);

cljs.core$macros.cond__GT_.cljs$lang$applyTo = (function (seq34429){
var G__34430 = cljs.core.first.call(null,seq34429);
var seq34429__$1 = cljs.core.next.call(null,seq34429);
var G__34431 = cljs.core.first.call(null,seq34429__$1);
var seq34429__$2 = cljs.core.next.call(null,seq34429__$1);
var G__34432 = cljs.core.first.call(null,seq34429__$2);
var seq34429__$3 = cljs.core.next.call(null,seq34429__$2);
return cljs.core$macros.cond__GT_.cljs$core$IFn$_invoke$arity$variadic(G__34430,G__34431,G__34432,seq34429__$3);
});

return null;
})()
;
cljs.core$macros.cond__GT_.cljs$lang$macro = true;

var ret__29198__auto___34449 = (function (){
/**
 * Takes an expression and a set of test/form pairs. Threads expr (via ->>)
 *   through each form for which the corresponding test expression
 *   is true.  Note that, unlike cond branching, cond->> threading does not short circuit
 *   after the first true test expression.
 */
cljs.core$macros.cond__GT__GT_ = (function cljs$core$macros$cond__GT__GT_(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34450 = arguments.length;
var i__29159__auto___34451 = (0);
while(true){
if((i__29159__auto___34451 < len__29158__auto___34450)){
args__29165__auto__.push((arguments[i__29159__auto___34451]));

var G__34452 = (i__29159__auto___34451 + (1));
i__29159__auto___34451 = G__34452;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((3) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.cond__GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29166__auto__);
});

cljs.core$macros.cond__GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,expr,clauses){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,clauses))){
} else {
throw (new Error("Assert failed: (even? (count clauses))"));
}

var g = cljs.core.gensym.call(null);
var steps = cljs.core.map.call(null,((function (g){
return (function (p__34445){
var vec__34446 = p__34445;
var test = cljs.core.nth.call(null,vec__34446,(0),null);
var step = cljs.core.nth.call(null,vec__34446,(1),null);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = test;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","->>","cljs.core$macros/->>",-1353108561,null)),(function (){var x__28851__auto__ = g;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = step;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = g;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});})(g))
,cljs.core.partition.call(null,(2),clauses));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = g;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = expr;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core.interleave.call(null,cljs.core.repeat.call(null,g),cljs.core.butlast.call(null,steps))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = ((cljs.core.empty_QMARK_.call(null,steps))?g:cljs.core.last.call(null,steps));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.cond__GT__GT_.cljs$lang$maxFixedArity = (3);

cljs.core$macros.cond__GT__GT_.cljs$lang$applyTo = (function (seq34441){
var G__34442 = cljs.core.first.call(null,seq34441);
var seq34441__$1 = cljs.core.next.call(null,seq34441);
var G__34443 = cljs.core.first.call(null,seq34441__$1);
var seq34441__$2 = cljs.core.next.call(null,seq34441__$1);
var G__34444 = cljs.core.first.call(null,seq34441__$2);
var seq34441__$3 = cljs.core.next.call(null,seq34441__$2);
return cljs.core$macros.cond__GT__GT_.cljs$core$IFn$_invoke$arity$variadic(G__34442,G__34443,G__34444,seq34441__$3);
});

return null;
})()
;
cljs.core$macros.cond__GT__GT_.cljs$lang$macro = true;

var ret__29198__auto___34458 = (function (){
/**
 * Binds name to expr, evaluates the first form in the lexical context
 *   of that binding, then binds name to that result, repeating for each
 *   successive form, returning the result of the last form.
 */
cljs.core$macros.as__GT_ = (function cljs$core$macros$as__GT_(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34459 = arguments.length;
var i__29159__auto___34460 = (0);
while(true){
if((i__29159__auto___34460 < len__29158__auto___34459)){
args__29165__auto__.push((arguments[i__29159__auto___34460]));

var G__34461 = (i__29159__auto___34460 + (1));
i__29159__auto___34460 = G__34461;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((4) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((4)),(0),null)):null);
return cljs.core$macros.as__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__29166__auto__);
});

cljs.core$macros.as__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,expr,name,forms){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = expr;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core.interleave.call(null,cljs.core.repeat.call(null,name),cljs.core.butlast.call(null,forms))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = ((cljs.core.empty_QMARK_.call(null,forms))?name:cljs.core.last.call(null,forms));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.as__GT_.cljs$lang$maxFixedArity = (4);

cljs.core$macros.as__GT_.cljs$lang$applyTo = (function (seq34453){
var G__34454 = cljs.core.first.call(null,seq34453);
var seq34453__$1 = cljs.core.next.call(null,seq34453);
var G__34455 = cljs.core.first.call(null,seq34453__$1);
var seq34453__$2 = cljs.core.next.call(null,seq34453__$1);
var G__34456 = cljs.core.first.call(null,seq34453__$2);
var seq34453__$3 = cljs.core.next.call(null,seq34453__$2);
var G__34457 = cljs.core.first.call(null,seq34453__$3);
var seq34453__$4 = cljs.core.next.call(null,seq34453__$3);
return cljs.core$macros.as__GT_.cljs$core$IFn$_invoke$arity$variadic(G__34454,G__34455,G__34456,G__34457,seq34453__$4);
});

return null;
})()
;
cljs.core$macros.as__GT_.cljs$lang$macro = true;

var ret__29198__auto___34466 = (function (){
/**
 * When expr is not nil, threads it into the first form (via ->),
 *   and when that result is not nil, through the next etc
 */
cljs.core$macros.some__GT_ = (function cljs$core$macros$some__GT_(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34467 = arguments.length;
var i__29159__auto___34468 = (0);
while(true){
if((i__29159__auto___34468 < len__29158__auto___34467)){
args__29165__auto__.push((arguments[i__29159__auto___34468]));

var G__34469 = (i__29159__auto___34468 + (1));
i__29159__auto___34468 = G__34469;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((3) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.some__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29166__auto__);
});

cljs.core$macros.some__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,expr,forms){
var g = cljs.core.gensym.call(null);
var steps = cljs.core.map.call(null,((function (g){
return (function (step){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","nil?","cljs.core$macros/nil?",83624258,null)),(function (){var x__28851__auto__ = g;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","->","cljs.core$macros/->",-1519455206,null)),(function (){var x__28851__auto__ = g;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = step;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});})(g))
,forms);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = g;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = expr;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core.interleave.call(null,cljs.core.repeat.call(null,g),cljs.core.butlast.call(null,steps))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = ((cljs.core.empty_QMARK_.call(null,steps))?g:cljs.core.last.call(null,steps));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.some__GT_.cljs$lang$maxFixedArity = (3);

cljs.core$macros.some__GT_.cljs$lang$applyTo = (function (seq34462){
var G__34463 = cljs.core.first.call(null,seq34462);
var seq34462__$1 = cljs.core.next.call(null,seq34462);
var G__34464 = cljs.core.first.call(null,seq34462__$1);
var seq34462__$2 = cljs.core.next.call(null,seq34462__$1);
var G__34465 = cljs.core.first.call(null,seq34462__$2);
var seq34462__$3 = cljs.core.next.call(null,seq34462__$2);
return cljs.core$macros.some__GT_.cljs$core$IFn$_invoke$arity$variadic(G__34463,G__34464,G__34465,seq34462__$3);
});

return null;
})()
;
cljs.core$macros.some__GT_.cljs$lang$macro = true;

var ret__29198__auto___34474 = (function (){
/**
 * When expr is not nil, threads it into the first form (via ->>),
 *   and when that result is not nil, through the next etc
 */
cljs.core$macros.some__GT__GT_ = (function cljs$core$macros$some__GT__GT_(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34475 = arguments.length;
var i__29159__auto___34476 = (0);
while(true){
if((i__29159__auto___34476 < len__29158__auto___34475)){
args__29165__auto__.push((arguments[i__29159__auto___34476]));

var G__34477 = (i__29159__auto___34476 + (1));
i__29159__auto___34476 = G__34477;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((3) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.some__GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29166__auto__);
});

cljs.core$macros.some__GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,expr,forms){
var g = cljs.core.gensym.call(null);
var steps = cljs.core.map.call(null,((function (g){
return (function (step){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","nil?","cljs.core$macros/nil?",83624258,null)),(function (){var x__28851__auto__ = g;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","->>","cljs.core$macros/->>",-1353108561,null)),(function (){var x__28851__auto__ = g;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = step;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});})(g))
,forms);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = g;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = expr;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core.interleave.call(null,cljs.core.repeat.call(null,g),cljs.core.butlast.call(null,steps))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = ((cljs.core.empty_QMARK_.call(null,steps))?g:cljs.core.last.call(null,steps));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.some__GT__GT_.cljs$lang$maxFixedArity = (3);

cljs.core$macros.some__GT__GT_.cljs$lang$applyTo = (function (seq34470){
var G__34471 = cljs.core.first.call(null,seq34470);
var seq34470__$1 = cljs.core.next.call(null,seq34470);
var G__34472 = cljs.core.first.call(null,seq34470__$1);
var seq34470__$2 = cljs.core.next.call(null,seq34470__$1);
var G__34473 = cljs.core.first.call(null,seq34470__$2);
var seq34470__$3 = cljs.core.next.call(null,seq34470__$2);
return cljs.core$macros.some__GT__GT_.cljs$core$IFn$_invoke$arity$variadic(G__34471,G__34472,G__34473,seq34470__$3);
});

return null;
})()
;
cljs.core$macros.some__GT__GT_.cljs$lang$macro = true;

var ret__29198__auto___34487 = (function (){
/**
 * bindings => binding-form test
 * 
 *    If test is not nil, evaluates then with binding-form bound to the
 *    value of test, if not, yields else
 */
cljs.core$macros.if_some = (function cljs$core$macros$if_some(var_args){
var G__34486 = arguments.length;
switch (G__34486) {
case 4:
return cljs.core$macros.if_some.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__29177__auto__ = [];
var len__29158__auto___34489 = arguments.length;
var i__29159__auto___34490 = (0);
while(true){
if((i__29159__auto___34490 < len__29158__auto___34489)){
args_arr__29177__auto__.push((arguments[i__29159__auto___34490]));

var G__34491 = (i__29159__auto___34490 + (1));
i__29159__auto___34490 = G__34491;
continue;
} else {
}
break;
}

var argseq__29178__auto__ = (new cljs.core.IndexedSeq(args_arr__29177__auto__.slice((5)),(0),null));
return cljs.core$macros.if_some.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__29178__auto__);

}
});

cljs.core$macros.if_some.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,bindings,then){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","if-some","cljs.core$macros/if-some",1405341529,null)),(function (){var x__28851__auto__ = bindings;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = then;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
});

cljs.core$macros.if_some.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,bindings,then,else$,oldform){
if(cljs.core.vector_QMARK_.call(null,bindings)){
} else {
throw cljs.core.ex_info.call(null,"if-some requires a vector for its binding",cljs.core.PersistentArrayMap.EMPTY);
}

if(cljs.core.empty_QMARK_.call(null,oldform)){
} else {
throw cljs.core.ex_info.call(null,"if-some requires 1 or 2 forms after binding vector",cljs.core.PersistentArrayMap.EMPTY);
}

if(cljs.core._EQ_.call(null,(2),cljs.core.count.call(null,bindings))){
} else {
throw cljs.core.ex_info.call(null,"if-some requires exactly 2 forms in binding vector",cljs.core.PersistentArrayMap.EMPTY);
}


var form = bindings.call(null,(0));
var tst = bindings.call(null,(1));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"temp__34478__auto__","temp__34478__auto__",875919936,null)),(function (){var x__28851__auto__ = tst;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","nil?","cljs.core$macros/nil?",83624258,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"temp__34478__auto__","temp__34478__auto__",875919936,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = else$;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = form;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"temp__34478__auto__","temp__34478__auto__",875919936,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = then;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.if_some.cljs$lang$applyTo = (function (seq34480){
var G__34481 = cljs.core.first.call(null,seq34480);
var seq34480__$1 = cljs.core.next.call(null,seq34480);
var G__34482 = cljs.core.first.call(null,seq34480__$1);
var seq34480__$2 = cljs.core.next.call(null,seq34480__$1);
var G__34483 = cljs.core.first.call(null,seq34480__$2);
var seq34480__$3 = cljs.core.next.call(null,seq34480__$2);
var G__34484 = cljs.core.first.call(null,seq34480__$3);
var seq34480__$4 = cljs.core.next.call(null,seq34480__$3);
var G__34485 = cljs.core.first.call(null,seq34480__$4);
var seq34480__$5 = cljs.core.next.call(null,seq34480__$4);
return cljs.core$macros.if_some.cljs$core$IFn$_invoke$arity$variadic(G__34481,G__34482,G__34483,G__34484,G__34485,seq34480__$5);
});

cljs.core$macros.if_some.cljs$lang$maxFixedArity = (5);

return null;
})()
;
cljs.core$macros.if_some.cljs$lang$macro = true;

var ret__29198__auto___34497 = (function (){
/**
 * bindings => binding-form test
 * 
 *    When test is not nil, evaluates body with binding-form bound to the
 *    value of test
 */
cljs.core$macros.when_some = (function cljs$core$macros$when_some(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34498 = arguments.length;
var i__29159__auto___34499 = (0);
while(true){
if((i__29159__auto___34499 < len__29158__auto___34498)){
args__29165__auto__.push((arguments[i__29159__auto___34499]));

var G__34500 = (i__29159__auto___34499 + (1));
i__29159__auto___34499 = G__34500;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((3) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.when_some.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29166__auto__);
});

cljs.core$macros.when_some.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,bindings,body){
if(cljs.core.vector_QMARK_.call(null,bindings)){
} else {
throw cljs.core.ex_info.call(null,"when-some requires a vector for its binding",cljs.core.PersistentArrayMap.EMPTY);
}

if(cljs.core._EQ_.call(null,(2),cljs.core.count.call(null,bindings))){
} else {
throw cljs.core.ex_info.call(null,"when-some requires exactly 2 forms in binding vector",cljs.core.PersistentArrayMap.EMPTY);
}


var form = bindings.call(null,(0));
var tst = bindings.call(null,(1));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"temp__34492__auto__","temp__34492__auto__",-891653742,null)),(function (){var x__28851__auto__ = tst;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","nil?","cljs.core$macros/nil?",83624258,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"temp__34492__auto__","temp__34492__auto__",-891653742,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = form;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"temp__34492__auto__","temp__34492__auto__",-891653742,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),body)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.when_some.cljs$lang$maxFixedArity = (3);

cljs.core$macros.when_some.cljs$lang$applyTo = (function (seq34493){
var G__34494 = cljs.core.first.call(null,seq34493);
var seq34493__$1 = cljs.core.next.call(null,seq34493);
var G__34495 = cljs.core.first.call(null,seq34493__$1);
var seq34493__$2 = cljs.core.next.call(null,seq34493__$1);
var G__34496 = cljs.core.first.call(null,seq34493__$2);
var seq34493__$3 = cljs.core.next.call(null,seq34493__$2);
return cljs.core$macros.when_some.cljs$core$IFn$_invoke$arity$variadic(G__34494,G__34495,G__34496,seq34493__$3);
});

return null;
})()
;
cljs.core$macros.when_some.cljs$lang$macro = true;

/**
 * A good fdecl looks like (([a] ...) ([a b] ...)) near the end of defn.
 */
cljs.core$macros.assert_valid_fdecl = (function cljs$core$macros$assert_valid_fdecl(fdecl){
if(cljs.core.empty_QMARK_.call(null,fdecl)){
throw (new Error("Parameter declaration missing"));
} else {
}

var argdecls = cljs.core.map.call(null,(function (p1__34501_SHARP_){
if(cljs.core.seq_QMARK_.call(null,p1__34501_SHARP_)){
return cljs.core.first.call(null,p1__34501_SHARP_);
} else {
throw (new Error(((cljs.core.seq_QMARK_.call(null,cljs.core.first.call(null,fdecl)))?["Invalid signature \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__34501_SHARP_),"\" should be a list"].join(''):["Parameter declaration \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__34501_SHARP_),"\" should be a vector"].join(''))));
}
}),fdecl);
var bad_args = cljs.core.seq.call(null,cljs.core.remove.call(null,((function (argdecls){
return (function (p1__34502_SHARP_){
return cljs.core.vector_QMARK_.call(null,p1__34502_SHARP_);
});})(argdecls))
,argdecls));
if(bad_args){
throw (new Error(["Parameter declaration \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,bad_args)),"\" should be a vector"].join('')));
} else {
return null;
}
});
cljs.core$macros.sigs = (function cljs$core$macros$sigs(fdecl){
cljs.core$macros.assert_valid_fdecl.call(null,fdecl);

var asig = (function (fdecl__$1){
var arglist = cljs.core.first.call(null,fdecl__$1);
var arglist__$1 = ((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"&form","&form",1482799337,null),cljs.core.first.call(null,arglist)))?cljs.core.subvec.call(null,arglist,(2),cljs.core.count.call(null,arglist)):arglist);
var body = cljs.core.next.call(null,fdecl__$1);
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
if(cljs.core.next.call(null,body)){
return cljs.core.with_meta.call(null,arglist__$1,cljs.core.conj.call(null,(cljs.core.truth_(cljs.core.meta.call(null,arglist__$1))?cljs.core.meta.call(null,arglist__$1):cljs.core.PersistentArrayMap.EMPTY),cljs.core.first.call(null,body)));
} else {
return arglist__$1;
}
} else {
return arglist__$1;
}
});
if(cljs.core.seq_QMARK_.call(null,cljs.core.first.call(null,fdecl))){
var ret = cljs.core.PersistentVector.EMPTY;
var fdecls = fdecl;
while(true){
if(cljs.core.truth_(fdecls)){
var G__34503 = cljs.core.conj.call(null,ret,asig.call(null,cljs.core.first.call(null,fdecls)));
var G__34504 = cljs.core.next.call(null,fdecls);
ret = G__34503;
fdecls = G__34504;
continue;
} else {
return cljs.core.seq.call(null,ret);
}
break;
}
} else {
var x__28851__auto__ = asig.call(null,fdecl);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
}
});
var ret__29198__auto___34505 = /**
 * defs name to have the root value of init iff the named var has no root value,
 *   else init is unevaluated
 */
cljs.core$macros.defonce = (function cljs$core$macros$defonce(_AMPERSAND_form,_AMPERSAND_env,x,init){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when-not","cljs.core$macros/when-not",-764302244,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","exists?","cljs.core$macros/exists?",-1828590389,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"def","def",597100991,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = init;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
cljs.core$macros.defonce.cljs$lang$macro = true;

cljs.core$macros.destructure = (function cljs$core$macros$destructure(bindings){
var bents = cljs.core.partition.call(null,(2),bindings);
var pb = ((function (bents){
return (function cljs$core$macros$destructure_$_pb(bvec,b,v){
var pvec = ((function (bents){
return (function (bvec__$1,b__$1,val){
var gvec = cljs.core.gensym.call(null,"vec__");
var gseq = cljs.core.gensym.call(null,"seq__");
var gfirst = cljs.core.gensym.call(null,"first__");
var has_rest = cljs.core.some.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"&","&",-2144855648,null),null], null), null),b__$1);
var ret = (function (){var ret = cljs.core.conj.call(null,bvec__$1,gvec,val);
if(cljs.core.truth_(has_rest)){
return cljs.core.conj.call(null,ret,gseq,cljs.core._conj.call(null,(function (){var x__28851__auto__ = gvec;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),new cljs.core.Symbol("cljs.core","seq","cljs.core/seq",-1649497689,null)));
} else {
return ret;
}
})();
var n = (0);
var bs = b__$1;
var seen_rest_QMARK_ = false;
while(true){
if(cljs.core.seq.call(null,bs)){
var firstb = cljs.core.first.call(null,bs);
if(cljs.core._EQ_.call(null,firstb,new cljs.core.Symbol(null,"&","&",-2144855648,null))){
var G__34512 = cljs$core$macros$destructure_$_pb.call(null,ret,cljs.core.second.call(null,bs),gseq);
var G__34513 = n;
var G__34514 = cljs.core.nnext.call(null,bs);
var G__34515 = true;
ret = G__34512;
n = G__34513;
bs = G__34514;
seen_rest_QMARK_ = G__34515;
continue;
} else {
if(cljs.core._EQ_.call(null,firstb,new cljs.core.Keyword(null,"as","as",1148689641))){
return cljs$core$macros$destructure_$_pb.call(null,ret,cljs.core.second.call(null,bs),gvec);
} else {
if(seen_rest_QMARK_){
throw (new Error("Unsupported binding form, only :as can follow & parameter"));
} else {
var G__34516 = cljs$core$macros$destructure_$_pb.call(null,(cljs.core.truth_(has_rest)?cljs.core.conj.call(null,ret,gfirst,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","first","cljs.core/first",-752535972,null)),(function (){var x__28851__auto__ = gseq;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))),gseq,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","next","cljs.core/next",-1291438473,null)),(function (){var x__28851__auto__ = gseq;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())))):ret),firstb,(cljs.core.truth_(has_rest)?gfirst:cljs.core._conj.call(null,(function (){var x__28851__auto__ = gvec;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = n;
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,null),x__28851__auto____$1);
})(),x__28851__auto__);
})(),new cljs.core.Symbol("cljs.core","nth","cljs.core/nth",1961052085,null))));
var G__34517 = (n + (1));
var G__34518 = cljs.core.next.call(null,bs);
var G__34519 = seen_rest_QMARK_;
ret = G__34516;
n = G__34517;
bs = G__34518;
seen_rest_QMARK_ = G__34519;
continue;
}

}
}
} else {
return ret;
}
break;
}
});})(bents))
;
var pmap = ((function (pvec,bents){
return (function (bvec__$1,b__$1,v__$1){
var gmap = cljs.core.gensym.call(null,"map__");
var defaults = new cljs.core.Keyword(null,"or","or",235744169).cljs$core$IFn$_invoke$arity$1(b__$1);
var ret = ((function (gmap,defaults,pvec,bents){
return (function (ret){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(b__$1))){
return cljs.core.conj.call(null,ret,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(b__$1),gmap);
} else {
return ret;
}
});})(gmap,defaults,pvec,bents))
.call(null,cljs.core.conj.call(null,cljs.core.conj.call(null,cljs.core.conj.call(null,cljs.core.conj.call(null,bvec__$1,gmap),v__$1),gmap),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","implements?","cljs.core$macros/implements?",-94762250,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","ISeq","cljs.core/ISeq",230133392,null)),(function (){var x__28851__auto__ = gmap;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","apply","cljs.core/apply",1757277831,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","hash-map","cljs.core/hash-map",303385767,null)),(function (){var x__28851__auto__ = gmap;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = gmap;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())))));
var bes = (function (){var transforms = cljs.core.reduce.call(null,((function (ret,gmap,defaults,pvec,bents){
return (function (transforms,mk){
if((mk instanceof cljs.core.Keyword)){
var mkns = cljs.core.namespace.call(null,mk);
var mkn = cljs.core.name.call(null,mk);
if(cljs.core._EQ_.call(null,mkn,"keys")){
return cljs.core.assoc.call(null,transforms,mk,((function (mkns,mkn,ret,gmap,defaults,pvec,bents){
return (function (p1__34506_SHARP_){
return cljs.core.keyword.call(null,(function (){var or__27989__auto__ = mkns;
if(cljs.core.truth_(or__27989__auto__)){
return or__27989__auto__;
} else {
return cljs.core.namespace.call(null,p1__34506_SHARP_);
}
})(),cljs.core.name.call(null,p1__34506_SHARP_));
});})(mkns,mkn,ret,gmap,defaults,pvec,bents))
);
} else {
if(cljs.core._EQ_.call(null,mkn,"syms")){
return cljs.core.assoc.call(null,transforms,mk,((function (mkns,mkn,ret,gmap,defaults,pvec,bents){
return (function (p1__34507_SHARP_){
return cljs.core._conj.call(null,(function (){var x__28851__auto__ = cljs.core.symbol.call(null,(function (){var or__27989__auto__ = mkns;
if(cljs.core.truth_(or__27989__auto__)){
return or__27989__auto__;
} else {
return cljs.core.namespace.call(null,p1__34507_SHARP_);
}
})(),cljs.core.name.call(null,p1__34507_SHARP_));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),new cljs.core.Symbol(null,"quote","quote",1377916282,null));
});})(mkns,mkn,ret,gmap,defaults,pvec,bents))
);
} else {
if(cljs.core._EQ_.call(null,mkn,"strs")){
return cljs.core.assoc.call(null,transforms,mk,cljs.core.str);
} else {
return transforms;

}
}
}
} else {
return transforms;
}
});})(ret,gmap,defaults,pvec,bents))
,cljs.core.PersistentArrayMap.EMPTY,cljs.core.keys.call(null,b__$1));
return cljs.core.reduce.call(null,((function (transforms,ret,gmap,defaults,pvec,bents){
return (function (bes,entry){
return cljs.core.reduce.call(null,((function (transforms,ret,gmap,defaults,pvec,bents){
return (function (p1__34508_SHARP_,p2__34509_SHARP_){
return cljs.core.assoc.call(null,p1__34508_SHARP_,p2__34509_SHARP_,cljs.core.val.call(null,entry).call(null,p2__34509_SHARP_));
});})(transforms,ret,gmap,defaults,pvec,bents))
,cljs.core.dissoc.call(null,bes,cljs.core.key.call(null,entry)),cljs.core.key.call(null,entry).call(null,bes));
});})(transforms,ret,gmap,defaults,pvec,bents))
,cljs.core.dissoc.call(null,b__$1,new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Keyword(null,"or","or",235744169)),transforms);
})();
while(true){
if(cljs.core.seq.call(null,bes)){
var bb = cljs.core.key.call(null,cljs.core.first.call(null,bes));
var bk = cljs.core.val.call(null,cljs.core.first.call(null,bes));
var local = ((((!((bb == null)))?((((bb.cljs$lang$protocol_mask$partition1$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === bb.cljs$core$INamed$)))?true:false):false))?cljs.core.with_meta.call(null,cljs.core.symbol.call(null,null,cljs.core.name.call(null,bb)),cljs.core.meta.call(null,bb)):bb);
var bv = ((cljs.core.contains_QMARK_.call(null,defaults,local))?cljs.core._conj.call(null,(function (){var x__28851__auto__ = gmap;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = bk;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$2 = defaults.call(null,local);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$2);
})(),x__28851__auto____$1);
})(),x__28851__auto__);
})(),new cljs.core.Symbol("cljs.core","get","cljs.core/get",-296075407,null)):cljs.core._conj.call(null,(function (){var x__28851__auto__ = gmap;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = bk;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),new cljs.core.Symbol("cljs.core","get","cljs.core/get",-296075407,null)));
var G__34520 = ((((bb instanceof cljs.core.Keyword)) || ((bb instanceof cljs.core.Symbol)))?cljs.core.conj.call(null,ret,local,bv):cljs$core$macros$destructure_$_pb.call(null,ret,bb,bv));
var G__34521 = cljs.core.next.call(null,bes);
ret = G__34520;
bes = G__34521;
continue;
} else {
return ret;
}
break;
}
});})(pvec,bents))
;
if((b instanceof cljs.core.Symbol)){
return cljs.core.conj.call(null,cljs.core.conj.call(null,bvec,(cljs.core.truth_(cljs.core.namespace.call(null,b))?cljs.core.symbol.call(null,cljs.core.name.call(null,b)):b)),v);
} else {
if((b instanceof cljs.core.Keyword)){
return cljs.core.conj.call(null,cljs.core.conj.call(null,bvec,cljs.core.symbol.call(null,cljs.core.name.call(null,b))),v);
} else {
if(cljs.core.vector_QMARK_.call(null,b)){
return pvec.call(null,bvec,b,v);
} else {
if(cljs.core.map_QMARK_.call(null,b)){
return pmap.call(null,bvec,b,v);
} else {
throw (new Error(["Unsupported binding form: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(b)].join('')));

}
}
}
}
});})(bents))
;
var process_entry = ((function (bents,pb){
return (function (bvec,b){
return pb.call(null,bvec,cljs.core.first.call(null,b),cljs.core.second.call(null,b));
});})(bents,pb))
;
if(cljs.core.every_QMARK_.call(null,cljs.core.symbol_QMARK_,cljs.core.map.call(null,cljs.core.first,bents))){
return bindings;
} else {
var temp__4655__auto__ = cljs.core.seq.call(null,cljs.core.filter.call(null,((function (bents,pb,process_entry){
return (function (p1__34510_SHARP_){
return (cljs.core.first.call(null,p1__34510_SHARP_) instanceof cljs.core.Keyword);
});})(bents,pb,process_entry))
,bents));
if(temp__4655__auto__){
var kwbs = temp__4655__auto__;
throw (new Error(["Unsupported binding key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.ffirst.call(null,kwbs))].join('')));
} else {
return cljs.core.reduce.call(null,process_entry,cljs.core.PersistentVector.EMPTY,bents);
}
}
});
var ret__29198__auto___34522 = /**
 * Defines a var using `goog.define`. Passed default value must be
 *   string, number or boolean.
 * 
 *   Default value can be overridden at compile time using the
 *   compiler option `:closure-defines`.
 * 
 *   Example:
 *  (ns your-app.core)
 *  (goog-define DEBUG! false)
 *  ;; can be overridden with
 *  :closure-defines {"your_app.core.DEBUG_BANG_" true}
 *  or
 *  :closure-defines {'your-app.core/DEBUG! true}
 */
cljs.core$macros.goog_define = (function cljs$core$macros$goog_define(_AMPERSAND_form,_AMPERSAND_env,sym,default$){
if((typeof default$ === 'string') || (typeof default$ === 'number') || (default$ === true) || (default$ === false)){
} else {
throw cljs.core.ex_info.call(null,"goog-define requires a string, number or boolean as default value",cljs.core.PersistentArrayMap.EMPTY);
}


var defname = cljs.compiler.munge.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core._STAR_ns_STAR_),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(sym)].join(''));
var type = ((typeof default$ === 'string')?"string":((typeof default$ === 'number')?"number":(((default$ === true) || (default$ === false))?"boolean":null)));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","declare","cljs.core$macros/declare",1172642527,null)),(function (){var x__28851__auto__ = cljs.core.symbol.call(null,sym);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"js*","js*",-1134233646,null)),(function (){var x__28851__auto__ = ["/** @define {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type),"} */"].join('');
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("goog","define","goog/define",-352722538,null)),(function (){var x__28851__auto__ = defname;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = default$;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
cljs.core$macros.goog_define.cljs$lang$macro = true;

var ret__29198__auto___34527 = (function (){
/**
 * binding => binding-form init-expr
 * 
 *   Evaluates the exprs in a lexical context in which the symbols in
 *   the binding-forms are bound to their respective init-exprs or parts
 *   therein.
 */
cljs.core$macros.let$ = (function cljs$core$macros$let(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34528 = arguments.length;
var i__29159__auto___34529 = (0);
while(true){
if((i__29159__auto___34529 < len__29158__auto___34528)){
args__29165__auto__.push((arguments[i__29159__auto___34529]));

var G__34530 = (i__29159__auto___34529 + (1));
i__29159__auto___34529 = G__34530;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((3) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.let$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29166__auto__);
});

cljs.core$macros.let$.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,bindings,body){
if(cljs.core.vector_QMARK_.call(null,bindings)){
} else {
throw cljs.core.ex_info.call(null,"let requires a vector for its binding",cljs.core.PersistentArrayMap.EMPTY);
}

if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,bindings))){
} else {
throw cljs.core.ex_info.call(null,"let requires an even number of forms in binding vector",cljs.core.PersistentArrayMap.EMPTY);
}


return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"let*","let*",1920721458,null)),(function (){var x__28851__auto__ = cljs.core$macros.destructure.call(null,bindings);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),body)));
});

cljs.core$macros.let$.cljs$lang$maxFixedArity = (3);

cljs.core$macros.let$.cljs$lang$applyTo = (function (seq34523){
var G__34524 = cljs.core.first.call(null,seq34523);
var seq34523__$1 = cljs.core.next.call(null,seq34523);
var G__34525 = cljs.core.first.call(null,seq34523__$1);
var seq34523__$2 = cljs.core.next.call(null,seq34523__$1);
var G__34526 = cljs.core.first.call(null,seq34523__$2);
var seq34523__$3 = cljs.core.next.call(null,seq34523__$2);
return cljs.core$macros.let$.cljs$core$IFn$_invoke$arity$variadic(G__34524,G__34525,G__34526,seq34523__$3);
});

return null;
})()
;
cljs.core$macros.let$.cljs$lang$macro = true;

var ret__29198__auto___34539 = (function (){
/**
 * Evaluates the exprs in a lexical context in which the symbols in
 *   the binding-forms are bound to their respective init-exprs or parts
 *   therein. Acts as a recur target.
 */
cljs.core$macros.loop = (function cljs$core$macros$loop(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34540 = arguments.length;
var i__29159__auto___34541 = (0);
while(true){
if((i__29159__auto___34541 < len__29158__auto___34540)){
args__29165__auto__.push((arguments[i__29159__auto___34541]));

var G__34542 = (i__29159__auto___34541 + (1));
i__29159__auto___34541 = G__34542;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((3) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.loop.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29166__auto__);
});

cljs.core$macros.loop.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,bindings,body){
if(cljs.core.vector_QMARK_.call(null,bindings)){
} else {
throw cljs.core.ex_info.call(null,"loop requires a vector for its binding",cljs.core.PersistentArrayMap.EMPTY);
}

if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,bindings))){
} else {
throw cljs.core.ex_info.call(null,"loop requires an even number of forms in binding vector",cljs.core.PersistentArrayMap.EMPTY);
}


var db = cljs.core$macros.destructure.call(null,bindings);
if(cljs.core._EQ_.call(null,db,bindings)){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"loop*","loop*",615029416,null)),(function (){var x__28851__auto__ = bindings;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),body)));
} else {
var vs = cljs.core.take_nth.call(null,(2),cljs.core.drop.call(null,(1),bindings));
var bs = cljs.core.take_nth.call(null,(2),bindings);
var gs = cljs.core.map.call(null,((function (vs,bs,db){
return (function (b){
if((b instanceof cljs.core.Symbol)){
return b;
} else {
return cljs.core.gensym.call(null);
}
});})(vs,bs,db))
,bs);
var bfs = cljs.core.reduce.call(null,((function (vs,bs,gs,db){
return (function (ret,p__34535){
var vec__34536 = p__34535;
var b = cljs.core.nth.call(null,vec__34536,(0),null);
var v = cljs.core.nth.call(null,vec__34536,(1),null);
var g = cljs.core.nth.call(null,vec__34536,(2),null);
if((b instanceof cljs.core.Symbol)){
return cljs.core.conj.call(null,ret,g,v);
} else {
return cljs.core.conj.call(null,ret,g,v,b,g);
}
});})(vs,bs,gs,db))
,cljs.core.PersistentVector.EMPTY,cljs.core.map.call(null,cljs.core.vector,bs,vs,gs));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = bfs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"loop*","loop*",615029416,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.interleave.call(null,gs,gs));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.interleave.call(null,bs,gs));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),body)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
}
});

cljs.core$macros.loop.cljs$lang$maxFixedArity = (3);

cljs.core$macros.loop.cljs$lang$applyTo = (function (seq34531){
var G__34532 = cljs.core.first.call(null,seq34531);
var seq34531__$1 = cljs.core.next.call(null,seq34531);
var G__34533 = cljs.core.first.call(null,seq34531__$1);
var seq34531__$2 = cljs.core.next.call(null,seq34531__$1);
var G__34534 = cljs.core.first.call(null,seq34531__$2);
var seq34531__$3 = cljs.core.next.call(null,seq34531__$2);
return cljs.core$macros.loop.cljs$core$IFn$_invoke$arity$variadic(G__34532,G__34533,G__34534,seq34531__$3);
});

return null;
})()
;
cljs.core$macros.loop.cljs$lang$macro = true;

/**
 * protocol fqn -> [partition number, bit]
 */
cljs.core$macros.fast_path_protocols = cljs.core.zipmap.call(null,cljs.core.map.call(null,(function (p1__34543_SHARP_){
return cljs.core.symbol.call(null,"cljs.core",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__34543_SHARP_)].join(''));
}),cljs.core.PersistentVector.fromArray([new cljs.core.Symbol(null,"IFn","IFn",-244881638,null),new cljs.core.Symbol(null,"ICounted","ICounted",-1705786327,null),new cljs.core.Symbol(null,"IEmptyableCollection","IEmptyableCollection",1477271438,null),new cljs.core.Symbol(null,"ICollection","ICollection",-686709190,null),new cljs.core.Symbol(null,"IIndexed","IIndexed",-574812826,null),new cljs.core.Symbol(null,"ASeq","ASeq",266390234,null),new cljs.core.Symbol(null,"ISeq","ISeq",1517365813,null),new cljs.core.Symbol(null,"INext","INext",562211849,null),new cljs.core.Symbol(null,"ILookup","ILookup",784647298,null),new cljs.core.Symbol(null,"IAssociative","IAssociative",-1306431882,null),new cljs.core.Symbol(null,"IMap","IMap",992876629,null),new cljs.core.Symbol(null,"IMapEntry","IMapEntry",-943754199,null),new cljs.core.Symbol(null,"ISet","ISet",-1398072657,null),new cljs.core.Symbol(null,"IStack","IStack",1136769449,null),new cljs.core.Symbol(null,"IVector","IVector",-1120721434,null),new cljs.core.Symbol(null,"IDeref","IDeref",1738423197,null),new cljs.core.Symbol(null,"IDerefWithTimeout","IDerefWithTimeout",2140974319,null),new cljs.core.Symbol(null,"IMeta","IMeta",1095313672,null),new cljs.core.Symbol(null,"IWithMeta","IWithMeta",-509493158,null),new cljs.core.Symbol(null,"IReduce","IReduce",-440384974,null),new cljs.core.Symbol(null,"IKVReduce","IKVReduce",-870856862,null),new cljs.core.Symbol(null,"IEquiv","IEquiv",-1912850869,null),new cljs.core.Symbol(null,"IHash","IHash",-1495374645,null),new cljs.core.Symbol(null,"ISeqable","ISeqable",1349682102,null),new cljs.core.Symbol(null,"ISequential","ISequential",-1626174217,null),new cljs.core.Symbol(null,"IList","IList",1682281311,null),new cljs.core.Symbol(null,"IRecord","IRecord",-903221169,null),new cljs.core.Symbol(null,"IReversible","IReversible",-723048599,null),new cljs.core.Symbol(null,"ISorted","ISorted",-253627362,null),new cljs.core.Symbol(null,"IPrintWithWriter","IPrintWithWriter",-1205316154,null),new cljs.core.Symbol(null,"IWriter","IWriter",-1681087107,null),new cljs.core.Symbol(null,"IPrintWithWriter","IPrintWithWriter",-1205316154,null),new cljs.core.Symbol(null,"IPending","IPending",1229113039,null),new cljs.core.Symbol(null,"IWatchable","IWatchable",-1929659016,null),new cljs.core.Symbol(null,"IEditableCollection","IEditableCollection",-906687187,null),new cljs.core.Symbol(null,"ITransientCollection","ITransientCollection",252832402,null),new cljs.core.Symbol(null,"ITransientAssociative","ITransientAssociative",-1612754624,null),new cljs.core.Symbol(null,"ITransientMap","ITransientMap",298423651,null),new cljs.core.Symbol(null,"ITransientVector","ITransientVector",1978793164,null),new cljs.core.Symbol(null,"ITransientSet","ITransientSet",-575559912,null),new cljs.core.Symbol(null,"IMultiFn","IMultiFn",-1848282794,null),new cljs.core.Symbol(null,"IChunkedSeq","IChunkedSeq",-1299765705,null),new cljs.core.Symbol(null,"IChunkedNext","IChunkedNext",1193289532,null),new cljs.core.Symbol(null,"IComparable","IComparable",1834481627,null),new cljs.core.Symbol(null,"INamed","INamed",357992946,null),new cljs.core.Symbol(null,"ICloneable","ICloneable",1882653160,null),new cljs.core.Symbol(null,"IAtom","IAtom",-1411134312,null),new cljs.core.Symbol(null,"IReset","IReset",-1893729426,null),new cljs.core.Symbol(null,"ISwap","ISwap",484378193,null),new cljs.core.Symbol(null,"IIterable","IIterable",577191430,null)], true)),cljs.core.iterate.call(null,(function (p__34544){
var vec__34545 = p__34544;
var p = cljs.core.nth.call(null,vec__34545,(0),null);
var b = cljs.core.nth.call(null,vec__34545,(1),null);
if(((2147483648) === b)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(p + (1)),(1)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,((2) * b)], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null)));
/**
 * total number of partitions
 */
cljs.core$macros.fast_path_protocol_partitions_count = (function (){var c = cljs.core.count.call(null,cljs.core$macros.fast_path_protocols);
var m = cljs.core.mod.call(null,c,(32));
if((m === (0))){
return cljs.core.quot.call(null,c,(32));
} else {
return (cljs.core.quot.call(null,c,(32)) + (1));
}
})();
var ret__29198__auto___34551 = (function (){
cljs.core$macros.str = (function cljs$core$macros$str(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34552 = arguments.length;
var i__29159__auto___34553 = (0);
while(true){
if((i__29159__auto___34553 < len__29158__auto___34552)){
args__29165__auto__.push((arguments[i__29159__auto___34553]));

var G__34554 = (i__29159__auto___34553 + (1));
i__29159__auto___34553 = G__34554;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((2) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29166__auto__);
});

cljs.core$macros.str.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,xs){
var interpolate = (function (x){
if(typeof x === 'string'){
return "~{}";
} else {
return "cljs.core.str.cljs$core$IFn$_invoke$arity$1(~{})";
}
});
var strs = cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null,",",cljs.core.map.call(null,interpolate,xs)));
return cljs.core.list_STAR_.call(null,new cljs.core.Symbol(null,"js*","js*",-1134233646,null),["[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(strs),"].join('')"].join(''),xs);
});

cljs.core$macros.str.cljs$lang$maxFixedArity = (2);

cljs.core$macros.str.cljs$lang$applyTo = (function (seq34548){
var G__34549 = cljs.core.first.call(null,seq34548);
var seq34548__$1 = cljs.core.next.call(null,seq34548);
var G__34550 = cljs.core.first.call(null,seq34548__$1);
var seq34548__$2 = cljs.core.next.call(null,seq34548__$1);
return cljs.core$macros.str.cljs$core$IFn$_invoke$arity$variadic(G__34549,G__34550,seq34548__$2);
});

return null;
})()
;
cljs.core$macros.str.cljs$lang$macro = true;

cljs.core$macros.bool_expr = (function cljs$core$macros$bool_expr(e){
return cljs.core.vary_meta.call(null,e,cljs.core.assoc,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null));
});
cljs.core$macros.simple_test_expr_QMARK_ = (function cljs$core$macros$simple_test_expr_QMARK_(env,ast){
var and__27977__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"js","js",1768080579),null,new cljs.core.Keyword(null,"constant","constant",-379609303),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"invoke","invoke",1145927159),null,new cljs.core.Keyword(null,"dot","dot",1442709401),null], null), null).call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast));
if(cljs.core.truth_(and__27977__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null).call(null,cljs.analyzer.infer_tag.call(null,env,ast));
} else {
return and__27977__auto__;
}
});
var ret__29198__auto___34565 = (function (){
/**
 * Evaluates exprs one at a time, from left to right. If a form
 *   returns logical false (nil or false), and returns that value and
 *   doesn't evaluate any of the other expressions, otherwise it returns
 *   the value of the last expr. (and) returns true.
 */
cljs.core$macros.and = (function cljs$core$macros$and(var_args){
var G__34563 = arguments.length;
switch (G__34563) {
case 2:
return cljs.core$macros.and.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core$macros.and.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__29177__auto__ = [];
var len__29158__auto___34567 = arguments.length;
var i__29159__auto___34568 = (0);
while(true){
if((i__29159__auto___34568 < len__29158__auto___34567)){
args_arr__29177__auto__.push((arguments[i__29159__auto___34568]));

var G__34569 = (i__29159__auto___34568 + (1));
i__29159__auto___34568 = G__34569;
continue;
} else {
}
break;
}

var argseq__29178__auto__ = (new cljs.core.IndexedSeq(args_arr__29177__auto__.slice((3)),(0),null));
return cljs.core$macros.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29178__auto__);

}
});

cljs.core$macros.and.cljs$core$IFn$_invoke$arity$2 = (function (_AMPERSAND_form,_AMPERSAND_env){
return true;
});

cljs.core$macros.and.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return x;
});

cljs.core$macros.and.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,next){
var forms = cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [x], null),next);
if(cljs.core.every_QMARK_.call(null,((function (forms){
return (function (p1__34555_SHARP_){
return cljs.core$macros.simple_test_expr_QMARK_.call(null,_AMPERSAND_env,p1__34555_SHARP_);
});})(forms))
,cljs.core.map.call(null,((function (forms){
return (function (p1__34556_SHARP_){
var _STAR_cljs_warnings_STAR_34564 = cljs.analyzer._STAR_cljs_warnings_STAR_;
cljs.analyzer._STAR_cljs_warnings_STAR_ = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"invoke-ctor","invoke-ctor",-756052704),new cljs.core.Keyword(null,"extending-base-js-type","extending-base-js-type",432787264),new cljs.core.Keyword(null,"unsupported-preprocess-value","unsupported-preprocess-value",1635147105),new cljs.core.Keyword(null,"redef","redef",1032704258),new cljs.core.Keyword(null,"js-shadowed-by-local","js-shadowed-by-local",198048291),new cljs.core.Keyword(null,"unsupported-js-module-type","unsupported-js-module-type",1806206180),new cljs.core.Keyword(null,"invalid-protocol-symbol","invalid-protocol-symbol",86246948),new cljs.core.Keyword(null,"protocol-duped-method","protocol-duped-method",15128166),new cljs.core.Keyword(null,"munged-namespace","munged-namespace",-101986199),new cljs.core.Keyword(null,"single-segment-namespace","single-segment-namespace",-491924469),new cljs.core.Keyword(null,"fn-arity","fn-arity",-403576501),new cljs.core.Keyword(null,"infer-warning","infer-warning",-1600671410),new cljs.core.Keyword(null,"variadic-max-arity","variadic-max-arity",-14288402),new cljs.core.Keyword(null,"protocol-with-variadic-method","protocol-with-variadic-method",-693368178),new cljs.core.Keyword(null,"fn-deprecated","fn-deprecated",626877647),new cljs.core.Keyword(null,"undeclared-var","undeclared-var",-1624364944),new cljs.core.Keyword(null,"preamble-missing","preamble-missing",220974801),new cljs.core.Keyword(null,"undeclared-protocol-symbol","undeclared-protocol-symbol",462882867),new cljs.core.Keyword(null,"dynamic","dynamic",704819571),new cljs.core.Keyword(null,"invalid-array-access","invalid-array-access",-1747132236),new cljs.core.Keyword(null,"unprovided","unprovided",-652330764),new cljs.core.Keyword(null,"ns-var-clash","ns-var-clash",-280494668),new cljs.core.Keyword(null,"undeclared-ns","undeclared-ns",-1589012812),new cljs.core.Keyword(null,"undeclared-ns-form","undeclared-ns-form",-248024137),new cljs.core.Keyword(null,"invalid-arithmetic","invalid-arithmetic",1917075065),new cljs.core.Keyword(null,"protocol-deprecated","protocol-deprecated",103233497),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"protocol-impl-recur-with-target","protocol-impl-recur-with-target",-1648321574),new cljs.core.Keyword(null,"overload-arity","overload-arity",823206044),new cljs.core.Keyword(null,"protocol-multiple-impls","protocol-multiple-impls",794179260),new cljs.core.Keyword(null,"redef-in-file","redef-in-file",-476530788),new cljs.core.Keyword(null,"protocol-invalid-method","protocol-invalid-method",522647516),new cljs.core.Keyword(null,"extend-type-invalid-method-shape","extend-type-invalid-method-shape",1424103549),new cljs.core.Keyword(null,"multiple-variadic-overloads","multiple-variadic-overloads",1110059837),new cljs.core.Keyword(null,"protocol-impl-with-variadic-method","protocol-impl-with-variadic-method",-319321217)],[false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false]);

try{return cljs.analyzer.analyze.call(null,_AMPERSAND_env,p1__34556_SHARP_);
}finally {cljs.analyzer._STAR_cljs_warnings_STAR_ = _STAR_cljs_warnings_STAR_34564;
}});})(forms))
,forms))){
var and_str = cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null," && ",cljs.core.repeat.call(null,cljs.core.count.call(null,forms),"(~{})")));
return cljs.core$macros.bool_expr.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"js*","js*",-1134233646,null)),(function (){var x__28851__auto__ = and_str;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),forms))));
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"and__34557__auto__","and__34557__auto__",-408074215,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"and__34557__auto__","and__34557__auto__",-408074215,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","and","cljs.core$macros/and",48320334,null)),next)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"and__34557__auto__","and__34557__auto__",-408074215,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
}
});

cljs.core$macros.and.cljs$lang$applyTo = (function (seq34559){
var G__34560 = cljs.core.first.call(null,seq34559);
var seq34559__$1 = cljs.core.next.call(null,seq34559);
var G__34561 = cljs.core.first.call(null,seq34559__$1);
var seq34559__$2 = cljs.core.next.call(null,seq34559__$1);
var G__34562 = cljs.core.first.call(null,seq34559__$2);
var seq34559__$3 = cljs.core.next.call(null,seq34559__$2);
return cljs.core$macros.and.cljs$core$IFn$_invoke$arity$variadic(G__34560,G__34561,G__34562,seq34559__$3);
});

cljs.core$macros.and.cljs$lang$maxFixedArity = (3);

return null;
})()
;
cljs.core$macros.and.cljs$lang$macro = true;

var ret__29198__auto___34580 = (function (){
/**
 * Evaluates exprs one at a time, from left to right. If a form
 *   returns a logical true value, or returns that value and doesn't
 *   evaluate any of the other expressions, otherwise it returns the
 *   value of the last expression. (or) returns nil.
 */
cljs.core$macros.or = (function cljs$core$macros$or(var_args){
var G__34578 = arguments.length;
switch (G__34578) {
case 2:
return cljs.core$macros.or.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core$macros.or.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__29177__auto__ = [];
var len__29158__auto___34582 = arguments.length;
var i__29159__auto___34583 = (0);
while(true){
if((i__29159__auto___34583 < len__29158__auto___34582)){
args_arr__29177__auto__.push((arguments[i__29159__auto___34583]));

var G__34584 = (i__29159__auto___34583 + (1));
i__29159__auto___34583 = G__34584;
continue;
} else {
}
break;
}

var argseq__29178__auto__ = (new cljs.core.IndexedSeq(args_arr__29177__auto__.slice((3)),(0),null));
return cljs.core$macros.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29178__auto__);

}
});

cljs.core$macros.or.cljs$core$IFn$_invoke$arity$2 = (function (_AMPERSAND_form,_AMPERSAND_env){
return null;
});

cljs.core$macros.or.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return x;
});

cljs.core$macros.or.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,next){
var forms = cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [x], null),next);
if(cljs.core.every_QMARK_.call(null,((function (forms){
return (function (p1__34570_SHARP_){
return cljs.core$macros.simple_test_expr_QMARK_.call(null,_AMPERSAND_env,p1__34570_SHARP_);
});})(forms))
,cljs.core.map.call(null,((function (forms){
return (function (p1__34571_SHARP_){
var _STAR_cljs_warnings_STAR_34579 = cljs.analyzer._STAR_cljs_warnings_STAR_;
cljs.analyzer._STAR_cljs_warnings_STAR_ = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"invoke-ctor","invoke-ctor",-756052704),new cljs.core.Keyword(null,"extending-base-js-type","extending-base-js-type",432787264),new cljs.core.Keyword(null,"unsupported-preprocess-value","unsupported-preprocess-value",1635147105),new cljs.core.Keyword(null,"redef","redef",1032704258),new cljs.core.Keyword(null,"js-shadowed-by-local","js-shadowed-by-local",198048291),new cljs.core.Keyword(null,"unsupported-js-module-type","unsupported-js-module-type",1806206180),new cljs.core.Keyword(null,"invalid-protocol-symbol","invalid-protocol-symbol",86246948),new cljs.core.Keyword(null,"protocol-duped-method","protocol-duped-method",15128166),new cljs.core.Keyword(null,"munged-namespace","munged-namespace",-101986199),new cljs.core.Keyword(null,"single-segment-namespace","single-segment-namespace",-491924469),new cljs.core.Keyword(null,"fn-arity","fn-arity",-403576501),new cljs.core.Keyword(null,"infer-warning","infer-warning",-1600671410),new cljs.core.Keyword(null,"variadic-max-arity","variadic-max-arity",-14288402),new cljs.core.Keyword(null,"protocol-with-variadic-method","protocol-with-variadic-method",-693368178),new cljs.core.Keyword(null,"fn-deprecated","fn-deprecated",626877647),new cljs.core.Keyword(null,"undeclared-var","undeclared-var",-1624364944),new cljs.core.Keyword(null,"preamble-missing","preamble-missing",220974801),new cljs.core.Keyword(null,"undeclared-protocol-symbol","undeclared-protocol-symbol",462882867),new cljs.core.Keyword(null,"dynamic","dynamic",704819571),new cljs.core.Keyword(null,"invalid-array-access","invalid-array-access",-1747132236),new cljs.core.Keyword(null,"unprovided","unprovided",-652330764),new cljs.core.Keyword(null,"ns-var-clash","ns-var-clash",-280494668),new cljs.core.Keyword(null,"undeclared-ns","undeclared-ns",-1589012812),new cljs.core.Keyword(null,"undeclared-ns-form","undeclared-ns-form",-248024137),new cljs.core.Keyword(null,"invalid-arithmetic","invalid-arithmetic",1917075065),new cljs.core.Keyword(null,"protocol-deprecated","protocol-deprecated",103233497),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"protocol-impl-recur-with-target","protocol-impl-recur-with-target",-1648321574),new cljs.core.Keyword(null,"overload-arity","overload-arity",823206044),new cljs.core.Keyword(null,"protocol-multiple-impls","protocol-multiple-impls",794179260),new cljs.core.Keyword(null,"redef-in-file","redef-in-file",-476530788),new cljs.core.Keyword(null,"protocol-invalid-method","protocol-invalid-method",522647516),new cljs.core.Keyword(null,"extend-type-invalid-method-shape","extend-type-invalid-method-shape",1424103549),new cljs.core.Keyword(null,"multiple-variadic-overloads","multiple-variadic-overloads",1110059837),new cljs.core.Keyword(null,"protocol-impl-with-variadic-method","protocol-impl-with-variadic-method",-319321217)],[false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false]);

try{return cljs.analyzer.analyze.call(null,_AMPERSAND_env,p1__34571_SHARP_);
}finally {cljs.analyzer._STAR_cljs_warnings_STAR_ = _STAR_cljs_warnings_STAR_34579;
}});})(forms))
,forms))){
var or_str = cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null," || ",cljs.core.repeat.call(null,cljs.core.count.call(null,forms),"(~{})")));
return cljs.core$macros.bool_expr.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"js*","js*",-1134233646,null)),(function (){var x__28851__auto__ = or_str;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),forms))));
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"or__34572__auto__","or__34572__auto__",-1766759490,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"or__34572__auto__","or__34572__auto__",-1766759490,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"or__34572__auto__","or__34572__auto__",-1766759490,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","or","cljs.core$macros/or",1346243648,null)),next)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
}
});

cljs.core$macros.or.cljs$lang$applyTo = (function (seq34574){
var G__34575 = cljs.core.first.call(null,seq34574);
var seq34574__$1 = cljs.core.next.call(null,seq34574);
var G__34576 = cljs.core.first.call(null,seq34574__$1);
var seq34574__$2 = cljs.core.next.call(null,seq34574__$1);
var G__34577 = cljs.core.first.call(null,seq34574__$2);
var seq34574__$3 = cljs.core.next.call(null,seq34574__$2);
return cljs.core$macros.or.cljs$core$IFn$_invoke$arity$variadic(G__34575,G__34576,G__34577,seq34574__$3);
});

cljs.core$macros.or.cljs$lang$maxFixedArity = (3);

return null;
})()
;
cljs.core$macros.or.cljs$lang$macro = true;

var ret__29198__auto___34585 = cljs.core$macros.nil_QMARK_ = (function cljs$core$macros$nil_QMARK_(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","coercive-=","cljs.core$macros/coercive-=",-1655776086,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
});
cljs.core$macros.nil_QMARK_.cljs$lang$macro = true;

var ret__29198__auto___34586 = cljs.core$macros.some_QMARK_ = (function cljs$core$macros$some_QMARK_(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","nil?","cljs.core$macros/nil?",83624258,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
cljs.core$macros.some_QMARK_.cljs$lang$macro = true;

var ret__29198__auto___34587 = cljs.core$macros.coercive_not = (function cljs$core$macros$coercive_not(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),"(!~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});
cljs.core$macros.coercive_not.cljs$lang$macro = true;

var ret__29198__auto___34588 = cljs.core$macros.coercive_not_EQ_ = (function cljs$core$macros$coercive_not_EQ_(_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"(~{} != ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});
cljs.core$macros.coercive_not_EQ_.cljs$lang$macro = true;

var ret__29198__auto___34589 = cljs.core$macros.coercive__EQ_ = (function cljs$core$macros$coercive__EQ_(_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"(~{} == ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});
cljs.core$macros.coercive__EQ_.cljs$lang$macro = true;

var ret__29198__auto___34590 = cljs.core$macros.coercive_boolean = (function cljs$core$macros$coercive_boolean(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.with_meta.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),"~{}"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null)], null));
});
cljs.core$macros.coercive_boolean.cljs$lang$macro = true;

var ret__29198__auto___34591 = cljs.core$macros.truth_ = (function cljs$core$macros$truth_(_AMPERSAND_form,_AMPERSAND_env,x){
if((x instanceof cljs.core.Symbol)){
} else {
throw (new Error(["Assert failed: ","x is substituted twice","\n","(core/symbol? x)"].join('')));
}

return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"(~{} != null && ~{} !== false)"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.truth_.cljs$lang$macro = true;

var ret__29198__auto___34592 = cljs.core$macros.js_arguments = (function cljs$core$macros$js_arguments(_AMPERSAND_form,_AMPERSAND_env){
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,"arguments"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.js_arguments.cljs$lang$macro = true;

var ret__29198__auto___34593 = cljs.core$macros.js_delete = (function cljs$core$macros$js_delete(_AMPERSAND_form,_AMPERSAND_env,obj,key){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = obj;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = key;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"delete ~{}[~{}]"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.js_delete.cljs$lang$macro = true;

var ret__29198__auto___34594 = cljs.core$macros.js_in = (function cljs$core$macros$js_in(_AMPERSAND_form,_AMPERSAND_env,key,obj){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = key;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = obj;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"~{} in ~{}"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.js_in.cljs$lang$macro = true;

var ret__29198__auto___34595 = /**
 * Emit JavaScript "debugger;" statement
 */
cljs.core$macros.js_debugger = (function cljs$core$macros$js_debugger(_AMPERSAND_form,_AMPERSAND_env){
return cljs.core._conj.call(null,(function (){var x__28851__auto__ = cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,"debugger"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,null),x__28851__auto__);
})(),new cljs.core.Symbol(null,"do","do",1686842252,null));
});
cljs.core$macros.js_debugger.cljs$lang$macro = true;

var ret__29198__auto___34600 = /**
 * Emit a top-level JavaScript multi-line comment. New lines will create a
 *   new comment line. Comment block will be preceded and followed by a newline
 */
cljs.core$macros.js_comment = (function cljs$core$macros$js_comment(_AMPERSAND_form,_AMPERSAND_env,comment){
var vec__34597 = clojure.string.split.call(null,comment,/\n/);
var seq__34598 = cljs.core.seq.call(null,vec__34597);
var first__34599 = cljs.core.first.call(null,seq__34598);
var seq__34598__$1 = cljs.core.next.call(null,seq__34598);
var x = first__34599;
var ys = seq__34598__$1;
return cljs.core._conj.call(null,(function (){var x__28851__auto__ = ["\n/**\n",cljs.core.str.cljs$core$IFn$_invoke$arity$1([" * ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\n"].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.reduce.call(null,cljs.core.str,"",cljs.core.map.call(null,((function (vec__34597,seq__34598,first__34599,seq__34598__$1,x,ys){
return (function (p1__34596_SHARP_){
return [" * ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.replace.call(null,p1__34596_SHARP_,/^   /,"")),"\n"].join('');
});})(vec__34597,seq__34598,first__34599,seq__34598__$1,x,ys))
,ys)))," */\n"].join('');
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.js_comment.cljs$lang$macro = true;

var ret__29198__auto___34601 = /**
 * EXPERIMENTAL: Subject to change. Unsafely cast a value to a different type.
 */
cljs.core$macros.unsafe_cast = (function cljs$core$macros$unsafe_cast(_AMPERSAND_form,_AMPERSAND_env,t,x){
var cast_expr = ["~{} = /** @type {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(t),"} */ (~{})"].join('');
return cljs.core._conj.call(null,(function (){var x__28851__auto__ = cast_expr;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = x;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$2 = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$2);
})(),x__28851__auto____$1);
})(),x__28851__auto__);
})(),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.unsafe_cast.cljs$lang$macro = true;

var ret__29198__auto___34602 = /**
 * Emit an inline JavaScript comment.
 */
cljs.core$macros.js_inline_comment = (function cljs$core$macros$js_inline_comment(_AMPERSAND_form,_AMPERSAND_env,comment){
return cljs.core._conj.call(null,(function (){var x__28851__auto__ = ["/**",cljs.core.str.cljs$core$IFn$_invoke$arity$1(comment),"*/"].join('');
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.js_inline_comment.cljs$lang$macro = true;

var ret__29198__auto___34603 = cljs.core$macros.true_QMARK_ = (function cljs$core$macros$true_QMARK_(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),"~{} === true"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});
cljs.core$macros.true_QMARK_.cljs$lang$macro = true;

var ret__29198__auto___34604 = cljs.core$macros.false_QMARK_ = (function cljs$core$macros$false_QMARK_(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),"~{} === false"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});
cljs.core$macros.false_QMARK_.cljs$lang$macro = true;

var ret__29198__auto___34605 = cljs.core$macros.string_QMARK_ = (function cljs$core$macros$string_QMARK_(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),"typeof ~{} === 'string'"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});
cljs.core$macros.string_QMARK_.cljs$lang$macro = true;

var ret__29198__auto___34606 = /**
 * Return true if argument exists, analogous to usage of typeof operator
 * in JavaScript.
 */
cljs.core$macros.exists_QMARK_ = (function cljs$core$macros$exists_QMARK_(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = cljs.core.vary_meta.call(null,x,cljs.core.assoc,new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),"typeof ~{} !== 'undefined'"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});
cljs.core$macros.exists_QMARK_.cljs$lang$macro = true;

var ret__29198__auto___34607 = /**
 * Return true if argument is identical to the JavaScript undefined value.
 */
cljs.core$macros.undefined_QMARK_ = (function cljs$core$macros$undefined_QMARK_(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),"(void 0 === ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});
cljs.core$macros.undefined_QMARK_.cljs$lang$macro = true;

var ret__29198__auto___34608 = cljs.core$macros.identical_QMARK_ = (function cljs$core$macros$identical_QMARK_(_AMPERSAND_form,_AMPERSAND_env,a,b){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = a;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = b;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"(~{} === ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});
cljs.core$macros.identical_QMARK_.cljs$lang$macro = true;

var ret__29198__auto___34611 = cljs.core$macros.instance_QMARK_ = (function cljs$core$macros$instance_QMARK_(_AMPERSAND_form,_AMPERSAND_env,c,x){
return cljs.core$macros.bool_expr.call(null,(((c instanceof cljs.core.Symbol))?cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = c;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"(~{} instanceof ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)):cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"c__34609__auto__","c__34609__auto__",-488175237,null)),(function (){var x__28851__auto__ = c;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"x__34610__auto__","x__34610__auto__",-1470812231,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"js*","js*",-1134233646,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,"(~{} instanceof ~{})"),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"x__34610__auto__","x__34610__auto__",-1470812231,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"c__34609__auto__","c__34609__auto__",-488175237,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())))));
});
cljs.core$macros.instance_QMARK_.cljs$lang$macro = true;

var ret__29198__auto___34612 = cljs.core$macros.number_QMARK_ = (function cljs$core$macros$number_QMARK_(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),"typeof ~{} === 'number'"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});
cljs.core$macros.number_QMARK_.cljs$lang$macro = true;

var ret__29198__auto___34613 = cljs.core$macros.symbol_QMARK_ = (function cljs$core$macros$symbol_QMARK_(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core$macros.bool_expr.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","instance?","cljs.core$macros/instance?",1829750179,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","Symbol","cljs.core/Symbol",292989338,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
});
cljs.core$macros.symbol_QMARK_.cljs$lang$macro = true;

var ret__29198__auto___34614 = cljs.core$macros.keyword_QMARK_ = (function cljs$core$macros$keyword_QMARK_(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core$macros.bool_expr.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","instance?","cljs.core$macros/instance?",1829750179,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
});
cljs.core$macros.keyword_QMARK_.cljs$lang$macro = true;

var ret__29198__auto___34624 = (function (){
cljs.core$macros.aget = (function cljs$core$macros$aget(var_args){
var G__34621 = arguments.length;
switch (G__34621) {
case 4:
return cljs.core$macros.aget.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__29177__auto__ = [];
var len__29158__auto___34626 = arguments.length;
var i__29159__auto___34627 = (0);
while(true){
if((i__29159__auto___34627 < len__29158__auto___34626)){
args_arr__29177__auto__.push((arguments[i__29159__auto___34627]));

var G__34628 = (i__29159__auto___34627 + (1));
i__29159__auto___34627 = G__34628;
continue;
} else {
}
break;
}

var argseq__29178__auto__ = (new cljs.core.IndexedSeq(args_arr__29177__auto__.slice((4)),(0),null));
return cljs.core$macros.aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__29178__auto__);

}
});

cljs.core$macros.aget.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,array,idx){
var G__34622 = cljs.analyzer.checked_arrays.call(null);
var G__34622__$1 = (((G__34622 instanceof cljs.core.Keyword))?G__34622.fqn:null);
switch (G__34622__$1) {
case "warn":
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","checked-aget","cljs.core/checked-aget",24024561,null)),(function (){var x__28851__auto__ = array;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));

break;
case "error":
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","checked-aget'","cljs.core/checked-aget'",1960922245,null)),(function (){var x__28851__auto__ = array;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));

break;
default:
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = array;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"(~{}[~{}])"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));

}
});

cljs.core$macros.aget.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,array,idx,idxs){
var G__34623 = cljs.analyzer.checked_arrays.call(null);
var G__34623__$1 = (((G__34623 instanceof cljs.core.Keyword))?G__34623.fqn:null);
switch (G__34623__$1) {
case "warn":
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","checked-aget","cljs.core/checked-aget",24024561,null)),(function (){var x__28851__auto__ = array;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),idxs)));

break;
case "error":
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","checked-aget'","cljs.core/checked-aget'",1960922245,null)),(function (){var x__28851__auto__ = array;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),idxs)));

break;
default:
var astr = cljs.core.apply.call(null,cljs.core.str,cljs.core.repeat.call(null,cljs.core.count.call(null,idxs),"[~{}]"));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"js*","js*",-1134233646,null)),(function (){var x__28851__auto__ = ["(~{}[~{}]",cljs.core.str.cljs$core$IFn$_invoke$arity$1(astr),")"].join('');
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = array;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),idxs)));

}
});

cljs.core$macros.aget.cljs$lang$applyTo = (function (seq34616){
var G__34617 = cljs.core.first.call(null,seq34616);
var seq34616__$1 = cljs.core.next.call(null,seq34616);
var G__34618 = cljs.core.first.call(null,seq34616__$1);
var seq34616__$2 = cljs.core.next.call(null,seq34616__$1);
var G__34619 = cljs.core.first.call(null,seq34616__$2);
var seq34616__$3 = cljs.core.next.call(null,seq34616__$2);
var G__34620 = cljs.core.first.call(null,seq34616__$3);
var seq34616__$4 = cljs.core.next.call(null,seq34616__$3);
return cljs.core$macros.aget.cljs$core$IFn$_invoke$arity$variadic(G__34617,G__34618,G__34619,G__34620,seq34616__$4);
});

cljs.core$macros.aget.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros.aget.cljs$lang$macro = true;

var ret__29198__auto___34641 = (function (){
cljs.core$macros.aset = (function cljs$core$macros$aset(var_args){
var G__34638 = arguments.length;
switch (G__34638) {
case 5:
return cljs.core$macros.aset.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__29177__auto__ = [];
var len__29158__auto___34643 = arguments.length;
var i__29159__auto___34644 = (0);
while(true){
if((i__29159__auto___34644 < len__29158__auto___34643)){
args_arr__29177__auto__.push((arguments[i__29159__auto___34644]));

var G__34645 = (i__29159__auto___34644 + (1));
i__29159__auto___34644 = G__34645;
continue;
} else {
}
break;
}

var argseq__29178__auto__ = (new cljs.core.IndexedSeq(args_arr__29177__auto__.slice((5)),(0),null));
return cljs.core$macros.aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__29178__auto__);

}
});

cljs.core$macros.aset.cljs$core$IFn$_invoke$arity$5 = (function (_AMPERSAND_form,_AMPERSAND_env,array,idx,val){
var G__34639 = cljs.analyzer.checked_arrays.call(null);
var G__34639__$1 = (((G__34639 instanceof cljs.core.Keyword))?G__34639.fqn:null);
switch (G__34639__$1) {
case "warn":
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","checked-aset","cljs.core/checked-aset",-2080232353,null)),(function (){var x__28851__auto__ = array;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = val;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));

break;
case "error":
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","checked-aset'","cljs.core/checked-aset'",163859714,null)),(function (){var x__28851__auto__ = array;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = val;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));

break;
default:
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = array;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = idx;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$2 = val;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$2);
})(),x__28851__auto____$1);
})(),x__28851__auto__);
})(),"(~{}[~{}] = ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));

}
});

cljs.core$macros.aset.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,array,idx,idx2,idxv){
var G__34640 = cljs.analyzer.checked_arrays.call(null);
var G__34640__$1 = (((G__34640 instanceof cljs.core.Keyword))?G__34640.fqn:null);
switch (G__34640__$1) {
case "warn":
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","checked-aset","cljs.core/checked-aset",-2080232353,null)),(function (){var x__28851__auto__ = array;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = idx2;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),idxv)));

break;
case "error":
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","checked-aset'","cljs.core/checked-aset'",163859714,null)),(function (){var x__28851__auto__ = array;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = idx2;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),idxv)));

break;
default:
var n = (cljs.core.count.call(null,idxv) - (1));
var astr = cljs.core.apply.call(null,cljs.core.str,cljs.core.repeat.call(null,n,"[~{}]"));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"js*","js*",-1134233646,null)),(function (){var x__28851__auto__ = ["(~{}[~{}][~{}]",cljs.core.str.cljs$core$IFn$_invoke$arity$1(astr)," = ~{})"].join('');
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = array;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = idx2;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),idxv)));

}
});

cljs.core$macros.aset.cljs$lang$applyTo = (function (seq34632){
var G__34633 = cljs.core.first.call(null,seq34632);
var seq34632__$1 = cljs.core.next.call(null,seq34632);
var G__34634 = cljs.core.first.call(null,seq34632__$1);
var seq34632__$2 = cljs.core.next.call(null,seq34632__$1);
var G__34635 = cljs.core.first.call(null,seq34632__$2);
var seq34632__$3 = cljs.core.next.call(null,seq34632__$2);
var G__34636 = cljs.core.first.call(null,seq34632__$3);
var seq34632__$4 = cljs.core.next.call(null,seq34632__$3);
var G__34637 = cljs.core.first.call(null,seq34632__$4);
var seq34632__$5 = cljs.core.next.call(null,seq34632__$4);
return cljs.core$macros.aset.cljs$core$IFn$_invoke$arity$variadic(G__34633,G__34634,G__34635,G__34636,G__34637,seq34632__$5);
});

cljs.core$macros.aset.cljs$lang$maxFixedArity = (5);

return null;
})()
;
cljs.core$macros.aset.cljs$lang$macro = true;

var ret__29198__auto___34648 = /**
 * INTERNAL. Compiles to JavaScript property access using bracket notation. Does
 *   not distinguish between object and array types and not subject to compiler
 *   static analysis.
 */
cljs.core$macros.unchecked_get = (function cljs$core$macros$unchecked_get(_AMPERSAND_form,_AMPERSAND_env,obj,key){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = obj;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = key;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"(~{}[~{}])"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.unchecked_get.cljs$lang$macro = true;

var ret__29198__auto___34649 = /**
 * INTERNAL. Compiles to JavaScript property access using bracket notation. Does
 *   not distinguish between object and array types and not subject to compiler
 *   static analysis.
 */
cljs.core$macros.unchecked_set = (function cljs$core$macros$unchecked_set(_AMPERSAND_form,_AMPERSAND_env,obj,key,val){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = obj;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = key;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$2 = val;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$2);
})(),x__28851__auto____$1);
})(),x__28851__auto__);
})(),"(~{}[~{}] = ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.unchecked_set.cljs$lang$macro = true;

var ret__29198__auto___34657 = (function (){
cljs.core$macros._PLUS_ = (function cljs$core$macros$_PLUS_(var_args){
var G__34656 = arguments.length;
switch (G__34656) {
case 2:
return cljs.core$macros._PLUS_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core$macros._PLUS_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core$macros._PLUS_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__29177__auto__ = [];
var len__29158__auto___34659 = arguments.length;
var i__29159__auto___34660 = (0);
while(true){
if((i__29159__auto___34660 < len__29158__auto___34659)){
args_arr__29177__auto__.push((arguments[i__29159__auto___34660]));

var G__34661 = (i__29159__auto___34660 + (1));
i__29159__auto___34660 = G__34661;
continue;
} else {
}
break;
}

var argseq__29178__auto__ = (new cljs.core.IndexedSeq(args_arr__29177__auto__.slice((4)),(0),null));
return cljs.core$macros._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__29178__auto__);

}
});

cljs.core$macros._PLUS_.cljs$core$IFn$_invoke$arity$2 = (function (_AMPERSAND_form,_AMPERSAND_env){
return (0);
});

cljs.core$macros._PLUS_.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return x;
});

cljs.core$macros._PLUS_.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"(~{} + ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});

cljs.core$macros._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","+","cljs.core$macros/+",-18260342,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","+","cljs.core$macros/+",-18260342,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),more)));
});

cljs.core$macros._PLUS_.cljs$lang$applyTo = (function (seq34651){
var G__34652 = cljs.core.first.call(null,seq34651);
var seq34651__$1 = cljs.core.next.call(null,seq34651);
var G__34653 = cljs.core.first.call(null,seq34651__$1);
var seq34651__$2 = cljs.core.next.call(null,seq34651__$1);
var G__34654 = cljs.core.first.call(null,seq34651__$2);
var seq34651__$3 = cljs.core.next.call(null,seq34651__$2);
var G__34655 = cljs.core.first.call(null,seq34651__$3);
var seq34651__$4 = cljs.core.next.call(null,seq34651__$3);
return cljs.core$macros._PLUS_.cljs$core$IFn$_invoke$arity$variadic(G__34652,G__34653,G__34654,G__34655,seq34651__$4);
});

cljs.core$macros._PLUS_.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros._PLUS_.cljs$lang$macro = true;

var ret__29198__auto___34662 = cljs.core$macros.byte$ = (function cljs$core$macros$byte(_AMPERSAND_form,_AMPERSAND_env,x){
return x;
});
cljs.core$macros.byte$.cljs$lang$macro = true;

var ret__29198__auto___34663 = cljs.core$macros.short$ = (function cljs$core$macros$short(_AMPERSAND_form,_AMPERSAND_env,x){
return x;
});
cljs.core$macros.short$.cljs$lang$macro = true;

var ret__29198__auto___34664 = cljs.core$macros.float$ = (function cljs$core$macros$float(_AMPERSAND_form,_AMPERSAND_env,x){
return x;
});
cljs.core$macros.float$.cljs$lang$macro = true;

var ret__29198__auto___34665 = cljs.core$macros.double$ = (function cljs$core$macros$double(_AMPERSAND_form,_AMPERSAND_env,x){
return x;
});
cljs.core$macros.double$.cljs$lang$macro = true;

var ret__29198__auto___34666 = cljs.core$macros.unchecked_byte = (function cljs$core$macros$unchecked_byte(_AMPERSAND_form,_AMPERSAND_env,x){
return x;
});
cljs.core$macros.unchecked_byte.cljs$lang$macro = true;

var ret__29198__auto___34667 = cljs.core$macros.unchecked_char = (function cljs$core$macros$unchecked_char(_AMPERSAND_form,_AMPERSAND_env,x){
return x;
});
cljs.core$macros.unchecked_char.cljs$lang$macro = true;

var ret__29198__auto___34668 = cljs.core$macros.unchecked_short = (function cljs$core$macros$unchecked_short(_AMPERSAND_form,_AMPERSAND_env,x){
return x;
});
cljs.core$macros.unchecked_short.cljs$lang$macro = true;

var ret__29198__auto___34669 = cljs.core$macros.unchecked_float = (function cljs$core$macros$unchecked_float(_AMPERSAND_form,_AMPERSAND_env,x){
return x;
});
cljs.core$macros.unchecked_float.cljs$lang$macro = true;

var ret__29198__auto___34670 = cljs.core$macros.unchecked_double = (function cljs$core$macros$unchecked_double(_AMPERSAND_form,_AMPERSAND_env,x){
return x;
});
cljs.core$macros.unchecked_double.cljs$lang$macro = true;

var ret__29198__auto___34674 = (function (){
cljs.core$macros.unchecked_add = (function cljs$core$macros$unchecked_add(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34675 = arguments.length;
var i__29159__auto___34676 = (0);
while(true){
if((i__29159__auto___34676 < len__29158__auto___34675)){
args__29165__auto__.push((arguments[i__29159__auto___34676]));

var G__34677 = (i__29159__auto___34676 + (1));
i__29159__auto___34676 = G__34677;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((2) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.unchecked_add.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29166__auto__);
});

cljs.core$macros.unchecked_add.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,xs){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","+","cljs.core$macros/+",-18260342,null)),xs)));
});

cljs.core$macros.unchecked_add.cljs$lang$maxFixedArity = (2);

cljs.core$macros.unchecked_add.cljs$lang$applyTo = (function (seq34671){
var G__34672 = cljs.core.first.call(null,seq34671);
var seq34671__$1 = cljs.core.next.call(null,seq34671);
var G__34673 = cljs.core.first.call(null,seq34671__$1);
var seq34671__$2 = cljs.core.next.call(null,seq34671__$1);
return cljs.core$macros.unchecked_add.cljs$core$IFn$_invoke$arity$variadic(G__34672,G__34673,seq34671__$2);
});

return null;
})()
;
cljs.core$macros.unchecked_add.cljs$lang$macro = true;

var ret__29198__auto___34681 = (function (){
cljs.core$macros.unchecked_add_int = (function cljs$core$macros$unchecked_add_int(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34682 = arguments.length;
var i__29159__auto___34683 = (0);
while(true){
if((i__29159__auto___34683 < len__29158__auto___34682)){
args__29165__auto__.push((arguments[i__29159__auto___34683]));

var G__34684 = (i__29159__auto___34683 + (1));
i__29159__auto___34683 = G__34684;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((2) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29166__auto__);
});

cljs.core$macros.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,xs){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","+","cljs.core$macros/+",-18260342,null)),xs)));
});

cljs.core$macros.unchecked_add_int.cljs$lang$maxFixedArity = (2);

cljs.core$macros.unchecked_add_int.cljs$lang$applyTo = (function (seq34678){
var G__34679 = cljs.core.first.call(null,seq34678);
var seq34678__$1 = cljs.core.next.call(null,seq34678);
var G__34680 = cljs.core.first.call(null,seq34678__$1);
var seq34678__$2 = cljs.core.next.call(null,seq34678__$1);
return cljs.core$macros.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic(G__34679,G__34680,seq34678__$2);
});

return null;
})()
;
cljs.core$macros.unchecked_add_int.cljs$lang$macro = true;

var ret__29198__auto___34685 = cljs.core$macros.unchecked_dec = (function cljs$core$macros$unchecked_dec(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","dec","cljs.core$macros/dec",-247694061,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
cljs.core$macros.unchecked_dec.cljs$lang$macro = true;

var ret__29198__auto___34686 = cljs.core$macros.unchecked_dec_int = (function cljs$core$macros$unchecked_dec_int(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","dec","cljs.core$macros/dec",-247694061,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
cljs.core$macros.unchecked_dec_int.cljs$lang$macro = true;

var ret__29198__auto___34690 = (function (){
cljs.core$macros.unchecked_divide_int = (function cljs$core$macros$unchecked_divide_int(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34691 = arguments.length;
var i__29159__auto___34692 = (0);
while(true){
if((i__29159__auto___34692 < len__29158__auto___34691)){
args__29165__auto__.push((arguments[i__29159__auto___34692]));

var G__34693 = (i__29159__auto___34692 + (1));
i__29159__auto___34692 = G__34693;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((2) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29166__auto__);
});

cljs.core$macros.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,xs){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","/","cljs.core$macros//",-893374331,null)),xs)));
});

cljs.core$macros.unchecked_divide_int.cljs$lang$maxFixedArity = (2);

cljs.core$macros.unchecked_divide_int.cljs$lang$applyTo = (function (seq34687){
var G__34688 = cljs.core.first.call(null,seq34687);
var seq34687__$1 = cljs.core.next.call(null,seq34687);
var G__34689 = cljs.core.first.call(null,seq34687__$1);
var seq34687__$2 = cljs.core.next.call(null,seq34687__$1);
return cljs.core$macros.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic(G__34688,G__34689,seq34687__$2);
});

return null;
})()
;
cljs.core$macros.unchecked_divide_int.cljs$lang$macro = true;

var ret__29198__auto___34694 = cljs.core$macros.unchecked_inc = (function cljs$core$macros$unchecked_inc(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","inc","cljs.core$macros/inc",876629257,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
cljs.core$macros.unchecked_inc.cljs$lang$macro = true;

var ret__29198__auto___34695 = cljs.core$macros.unchecked_inc_int = (function cljs$core$macros$unchecked_inc_int(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","inc","cljs.core$macros/inc",876629257,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
cljs.core$macros.unchecked_inc_int.cljs$lang$macro = true;

var ret__29198__auto___34699 = (function (){
cljs.core$macros.unchecked_multiply = (function cljs$core$macros$unchecked_multiply(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34700 = arguments.length;
var i__29159__auto___34701 = (0);
while(true){
if((i__29159__auto___34701 < len__29158__auto___34700)){
args__29165__auto__.push((arguments[i__29159__auto___34701]));

var G__34702 = (i__29159__auto___34701 + (1));
i__29159__auto___34701 = G__34702;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((2) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29166__auto__);
});

cljs.core$macros.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,xs){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","*","cljs.core$macros/*",946321529,null)),xs)));
});

cljs.core$macros.unchecked_multiply.cljs$lang$maxFixedArity = (2);

cljs.core$macros.unchecked_multiply.cljs$lang$applyTo = (function (seq34696){
var G__34697 = cljs.core.first.call(null,seq34696);
var seq34696__$1 = cljs.core.next.call(null,seq34696);
var G__34698 = cljs.core.first.call(null,seq34696__$1);
var seq34696__$2 = cljs.core.next.call(null,seq34696__$1);
return cljs.core$macros.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic(G__34697,G__34698,seq34696__$2);
});

return null;
})()
;
cljs.core$macros.unchecked_multiply.cljs$lang$macro = true;

var ret__29198__auto___34706 = (function (){
cljs.core$macros.unchecked_multiply_int = (function cljs$core$macros$unchecked_multiply_int(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34707 = arguments.length;
var i__29159__auto___34708 = (0);
while(true){
if((i__29159__auto___34708 < len__29158__auto___34707)){
args__29165__auto__.push((arguments[i__29159__auto___34708]));

var G__34709 = (i__29159__auto___34708 + (1));
i__29159__auto___34708 = G__34709;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((2) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29166__auto__);
});

cljs.core$macros.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,xs){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","*","cljs.core$macros/*",946321529,null)),xs)));
});

cljs.core$macros.unchecked_multiply_int.cljs$lang$maxFixedArity = (2);

cljs.core$macros.unchecked_multiply_int.cljs$lang$applyTo = (function (seq34703){
var G__34704 = cljs.core.first.call(null,seq34703);
var seq34703__$1 = cljs.core.next.call(null,seq34703);
var G__34705 = cljs.core.first.call(null,seq34703__$1);
var seq34703__$2 = cljs.core.next.call(null,seq34703__$1);
return cljs.core$macros.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic(G__34704,G__34705,seq34703__$2);
});

return null;
})()
;
cljs.core$macros.unchecked_multiply_int.cljs$lang$macro = true;

var ret__29198__auto___34710 = cljs.core$macros.unchecked_negate = (function cljs$core$macros$unchecked_negate(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","-","cljs.core$macros/-",13526976,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
cljs.core$macros.unchecked_negate.cljs$lang$macro = true;

var ret__29198__auto___34711 = cljs.core$macros.unchecked_negate_int = (function cljs$core$macros$unchecked_negate_int(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","-","cljs.core$macros/-",13526976,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
cljs.core$macros.unchecked_negate_int.cljs$lang$macro = true;

var ret__29198__auto___34712 = cljs.core$macros.unchecked_remainder_int = (function cljs$core$macros$unchecked_remainder_int(_AMPERSAND_form,_AMPERSAND_env,x,n){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","mod","cljs.core/mod",1925370196,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = n;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
cljs.core$macros.unchecked_remainder_int.cljs$lang$macro = true;

var ret__29198__auto___34716 = (function (){
cljs.core$macros.unchecked_subtract = (function cljs$core$macros$unchecked_subtract(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34717 = arguments.length;
var i__29159__auto___34718 = (0);
while(true){
if((i__29159__auto___34718 < len__29158__auto___34717)){
args__29165__auto__.push((arguments[i__29159__auto___34718]));

var G__34719 = (i__29159__auto___34718 + (1));
i__29159__auto___34718 = G__34719;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((2) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29166__auto__);
});

cljs.core$macros.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,xs){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","-","cljs.core$macros/-",13526976,null)),xs)));
});

cljs.core$macros.unchecked_subtract.cljs$lang$maxFixedArity = (2);

cljs.core$macros.unchecked_subtract.cljs$lang$applyTo = (function (seq34713){
var G__34714 = cljs.core.first.call(null,seq34713);
var seq34713__$1 = cljs.core.next.call(null,seq34713);
var G__34715 = cljs.core.first.call(null,seq34713__$1);
var seq34713__$2 = cljs.core.next.call(null,seq34713__$1);
return cljs.core$macros.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic(G__34714,G__34715,seq34713__$2);
});

return null;
})()
;
cljs.core$macros.unchecked_subtract.cljs$lang$macro = true;

var ret__29198__auto___34723 = (function (){
cljs.core$macros.unchecked_subtract_int = (function cljs$core$macros$unchecked_subtract_int(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34724 = arguments.length;
var i__29159__auto___34725 = (0);
while(true){
if((i__29159__auto___34725 < len__29158__auto___34724)){
args__29165__auto__.push((arguments[i__29159__auto___34725]));

var G__34726 = (i__29159__auto___34725 + (1));
i__29159__auto___34725 = G__34726;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((2) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29166__auto__);
});

cljs.core$macros.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,xs){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","-","cljs.core$macros/-",13526976,null)),xs)));
});

cljs.core$macros.unchecked_subtract_int.cljs$lang$maxFixedArity = (2);

cljs.core$macros.unchecked_subtract_int.cljs$lang$applyTo = (function (seq34720){
var G__34721 = cljs.core.first.call(null,seq34720);
var seq34720__$1 = cljs.core.next.call(null,seq34720);
var G__34722 = cljs.core.first.call(null,seq34720__$1);
var seq34720__$2 = cljs.core.next.call(null,seq34720__$1);
return cljs.core$macros.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic(G__34721,G__34722,seq34720__$2);
});

return null;
})()
;
cljs.core$macros.unchecked_subtract_int.cljs$lang$macro = true;

var ret__29198__auto___34734 = (function (){
cljs.core$macros._ = (function cljs$core$macros$_(var_args){
var G__34733 = arguments.length;
switch (G__34733) {
case 3:
return cljs.core$macros._.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core$macros._.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__29177__auto__ = [];
var len__29158__auto___34736 = arguments.length;
var i__29159__auto___34737 = (0);
while(true){
if((i__29159__auto___34737 < len__29158__auto___34736)){
args_arr__29177__auto__.push((arguments[i__29159__auto___34737]));

var G__34738 = (i__29159__auto___34737 + (1));
i__29159__auto___34737 = G__34738;
continue;
} else {
}
break;
}

var argseq__29178__auto__ = (new cljs.core.IndexedSeq(args_arr__29177__auto__.slice((4)),(0),null));
return cljs.core$macros._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__29178__auto__);

}
});

cljs.core$macros._.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),"(- ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});

cljs.core$macros._.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"(~{} - ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});

cljs.core$macros._.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","-","cljs.core$macros/-",13526976,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","-","cljs.core$macros/-",13526976,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),more)));
});

cljs.core$macros._.cljs$lang$applyTo = (function (seq34728){
var G__34729 = cljs.core.first.call(null,seq34728);
var seq34728__$1 = cljs.core.next.call(null,seq34728);
var G__34730 = cljs.core.first.call(null,seq34728__$1);
var seq34728__$2 = cljs.core.next.call(null,seq34728__$1);
var G__34731 = cljs.core.first.call(null,seq34728__$2);
var seq34728__$3 = cljs.core.next.call(null,seq34728__$2);
var G__34732 = cljs.core.first.call(null,seq34728__$3);
var seq34728__$4 = cljs.core.next.call(null,seq34728__$3);
return cljs.core$macros._.cljs$core$IFn$_invoke$arity$variadic(G__34729,G__34730,G__34731,G__34732,seq34728__$4);
});

cljs.core$macros._.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros._.cljs$lang$macro = true;

var ret__29198__auto___34746 = (function (){
cljs.core$macros._STAR_ = (function cljs$core$macros$_STAR_(var_args){
var G__34745 = arguments.length;
switch (G__34745) {
case 2:
return cljs.core$macros._STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core$macros._STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core$macros._STAR_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__29177__auto__ = [];
var len__29158__auto___34748 = arguments.length;
var i__29159__auto___34749 = (0);
while(true){
if((i__29159__auto___34749 < len__29158__auto___34748)){
args_arr__29177__auto__.push((arguments[i__29159__auto___34749]));

var G__34750 = (i__29159__auto___34749 + (1));
i__29159__auto___34749 = G__34750;
continue;
} else {
}
break;
}

var argseq__29178__auto__ = (new cljs.core.IndexedSeq(args_arr__29177__auto__.slice((4)),(0),null));
return cljs.core$macros._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__29178__auto__);

}
});

cljs.core$macros._STAR_.cljs$core$IFn$_invoke$arity$2 = (function (_AMPERSAND_form,_AMPERSAND_env){
return (1);
});

cljs.core$macros._STAR_.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return x;
});

cljs.core$macros._STAR_.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"(~{} * ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});

cljs.core$macros._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","*","cljs.core$macros/*",946321529,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","*","cljs.core$macros/*",946321529,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),more)));
});

cljs.core$macros._STAR_.cljs$lang$applyTo = (function (seq34740){
var G__34741 = cljs.core.first.call(null,seq34740);
var seq34740__$1 = cljs.core.next.call(null,seq34740);
var G__34742 = cljs.core.first.call(null,seq34740__$1);
var seq34740__$2 = cljs.core.next.call(null,seq34740__$1);
var G__34743 = cljs.core.first.call(null,seq34740__$2);
var seq34740__$3 = cljs.core.next.call(null,seq34740__$2);
var G__34744 = cljs.core.first.call(null,seq34740__$3);
var seq34740__$4 = cljs.core.next.call(null,seq34740__$3);
return cljs.core$macros._STAR_.cljs$core$IFn$_invoke$arity$variadic(G__34741,G__34742,G__34743,G__34744,seq34740__$4);
});

cljs.core$macros._STAR_.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros._STAR_.cljs$lang$macro = true;

var ret__29198__auto___34758 = (function (){
cljs.core$macros._SLASH_ = (function cljs$core$macros$_SLASH_(var_args){
var G__34757 = arguments.length;
switch (G__34757) {
case 3:
return cljs.core$macros._SLASH_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core$macros._SLASH_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__29177__auto__ = [];
var len__29158__auto___34760 = arguments.length;
var i__29159__auto___34761 = (0);
while(true){
if((i__29159__auto___34761 < len__29158__auto___34760)){
args_arr__29177__auto__.push((arguments[i__29159__auto___34761]));

var G__34762 = (i__29159__auto___34761 + (1));
i__29159__auto___34761 = G__34762;
continue;
} else {
}
break;
}

var argseq__29178__auto__ = (new cljs.core.IndexedSeq(args_arr__29177__auto__.slice((4)),(0),null));
return cljs.core$macros._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__29178__auto__);

}
});

cljs.core$macros._SLASH_.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","/","cljs.core$macros//",-893374331,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,(1)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros._SLASH_.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"(~{} / ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});

cljs.core$macros._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","/","cljs.core$macros//",-893374331,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","/","cljs.core$macros//",-893374331,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),more)));
});

cljs.core$macros._SLASH_.cljs$lang$applyTo = (function (seq34752){
var G__34753 = cljs.core.first.call(null,seq34752);
var seq34752__$1 = cljs.core.next.call(null,seq34752);
var G__34754 = cljs.core.first.call(null,seq34752__$1);
var seq34752__$2 = cljs.core.next.call(null,seq34752__$1);
var G__34755 = cljs.core.first.call(null,seq34752__$2);
var seq34752__$3 = cljs.core.next.call(null,seq34752__$2);
var G__34756 = cljs.core.first.call(null,seq34752__$3);
var seq34752__$4 = cljs.core.next.call(null,seq34752__$3);
return cljs.core$macros._SLASH_.cljs$core$IFn$_invoke$arity$variadic(G__34753,G__34754,G__34755,G__34756,seq34752__$4);
});

cljs.core$macros._SLASH_.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros._SLASH_.cljs$lang$macro = true;

var ret__29198__auto___34770 = (function (){
cljs.core$macros.divide = (function cljs$core$macros$divide(var_args){
var G__34769 = arguments.length;
switch (G__34769) {
case 3:
return cljs.core$macros.divide.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core$macros.divide.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__29177__auto__ = [];
var len__29158__auto___34772 = arguments.length;
var i__29159__auto___34773 = (0);
while(true){
if((i__29159__auto___34773 < len__29158__auto___34772)){
args_arr__29177__auto__.push((arguments[i__29159__auto___34773]));

var G__34774 = (i__29159__auto___34773 + (1));
i__29159__auto___34773 = G__34774;
continue;
} else {
}
break;
}

var argseq__29178__auto__ = (new cljs.core.IndexedSeq(args_arr__29177__auto__.slice((4)),(0),null));
return cljs.core$macros.divide.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__29178__auto__);

}
});

cljs.core$macros.divide.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","/","cljs.core$macros//",-893374331,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,(1)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.divide.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"(~{} / ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});

cljs.core$macros.divide.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","/","cljs.core$macros//",-893374331,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","/","cljs.core$macros//",-893374331,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),more)));
});

cljs.core$macros.divide.cljs$lang$applyTo = (function (seq34764){
var G__34765 = cljs.core.first.call(null,seq34764);
var seq34764__$1 = cljs.core.next.call(null,seq34764);
var G__34766 = cljs.core.first.call(null,seq34764__$1);
var seq34764__$2 = cljs.core.next.call(null,seq34764__$1);
var G__34767 = cljs.core.first.call(null,seq34764__$2);
var seq34764__$3 = cljs.core.next.call(null,seq34764__$2);
var G__34768 = cljs.core.first.call(null,seq34764__$3);
var seq34764__$4 = cljs.core.next.call(null,seq34764__$3);
return cljs.core$macros.divide.cljs$core$IFn$_invoke$arity$variadic(G__34765,G__34766,G__34767,G__34768,seq34764__$4);
});

cljs.core$macros.divide.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros.divide.cljs$lang$macro = true;

var ret__29198__auto___34782 = (function (){
cljs.core$macros._LT_ = (function cljs$core$macros$_LT_(var_args){
var G__34781 = arguments.length;
switch (G__34781) {
case 3:
return cljs.core$macros._LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core$macros._LT_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__29177__auto__ = [];
var len__29158__auto___34784 = arguments.length;
var i__29159__auto___34785 = (0);
while(true){
if((i__29159__auto___34785 < len__29158__auto___34784)){
args_arr__29177__auto__.push((arguments[i__29159__auto___34785]));

var G__34786 = (i__29159__auto___34785 + (1));
i__29159__auto___34785 = G__34786;
continue;
} else {
}
break;
}

var argseq__29178__auto__ = (new cljs.core.IndexedSeq(args_arr__29177__auto__.slice((4)),(0),null));
return cljs.core$macros._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__29178__auto__);

}
});

cljs.core$macros._LT_.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return true;
});

cljs.core$macros._LT_.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"(~{} < ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});

cljs.core$macros._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","and","cljs.core$macros/and",48320334,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","<","cljs.core$macros/<",371512596,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","<","cljs.core$macros/<",371512596,null)),(function (){var x__28851__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),more)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros._LT_.cljs$lang$applyTo = (function (seq34776){
var G__34777 = cljs.core.first.call(null,seq34776);
var seq34776__$1 = cljs.core.next.call(null,seq34776);
var G__34778 = cljs.core.first.call(null,seq34776__$1);
var seq34776__$2 = cljs.core.next.call(null,seq34776__$1);
var G__34779 = cljs.core.first.call(null,seq34776__$2);
var seq34776__$3 = cljs.core.next.call(null,seq34776__$2);
var G__34780 = cljs.core.first.call(null,seq34776__$3);
var seq34776__$4 = cljs.core.next.call(null,seq34776__$3);
return cljs.core$macros._LT_.cljs$core$IFn$_invoke$arity$variadic(G__34777,G__34778,G__34779,G__34780,seq34776__$4);
});

cljs.core$macros._LT_.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros._LT_.cljs$lang$macro = true;

var ret__29198__auto___34794 = (function (){
cljs.core$macros._LT__EQ_ = (function cljs$core$macros$_LT__EQ_(var_args){
var G__34793 = arguments.length;
switch (G__34793) {
case 3:
return cljs.core$macros._LT__EQ_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core$macros._LT__EQ_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__29177__auto__ = [];
var len__29158__auto___34796 = arguments.length;
var i__29159__auto___34797 = (0);
while(true){
if((i__29159__auto___34797 < len__29158__auto___34796)){
args_arr__29177__auto__.push((arguments[i__29159__auto___34797]));

var G__34798 = (i__29159__auto___34797 + (1));
i__29159__auto___34797 = G__34798;
continue;
} else {
}
break;
}

var argseq__29178__auto__ = (new cljs.core.IndexedSeq(args_arr__29177__auto__.slice((4)),(0),null));
return cljs.core$macros._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__29178__auto__);

}
});

cljs.core$macros._LT__EQ_.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return true;
});

cljs.core$macros._LT__EQ_.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"(~{} <= ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});

cljs.core$macros._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","and","cljs.core$macros/and",48320334,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","<=","cljs.core$macros/<=",1865244377,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","<=","cljs.core$macros/<=",1865244377,null)),(function (){var x__28851__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),more)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros._LT__EQ_.cljs$lang$applyTo = (function (seq34788){
var G__34789 = cljs.core.first.call(null,seq34788);
var seq34788__$1 = cljs.core.next.call(null,seq34788);
var G__34790 = cljs.core.first.call(null,seq34788__$1);
var seq34788__$2 = cljs.core.next.call(null,seq34788__$1);
var G__34791 = cljs.core.first.call(null,seq34788__$2);
var seq34788__$3 = cljs.core.next.call(null,seq34788__$2);
var G__34792 = cljs.core.first.call(null,seq34788__$3);
var seq34788__$4 = cljs.core.next.call(null,seq34788__$3);
return cljs.core$macros._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__34789,G__34790,G__34791,G__34792,seq34788__$4);
});

cljs.core$macros._LT__EQ_.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros._LT__EQ_.cljs$lang$macro = true;

var ret__29198__auto___34806 = (function (){
cljs.core$macros._GT_ = (function cljs$core$macros$_GT_(var_args){
var G__34805 = arguments.length;
switch (G__34805) {
case 3:
return cljs.core$macros._GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core$macros._GT_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__29177__auto__ = [];
var len__29158__auto___34808 = arguments.length;
var i__29159__auto___34809 = (0);
while(true){
if((i__29159__auto___34809 < len__29158__auto___34808)){
args_arr__29177__auto__.push((arguments[i__29159__auto___34809]));

var G__34810 = (i__29159__auto___34809 + (1));
i__29159__auto___34809 = G__34810;
continue;
} else {
}
break;
}

var argseq__29178__auto__ = (new cljs.core.IndexedSeq(args_arr__29177__auto__.slice((4)),(0),null));
return cljs.core$macros._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__29178__auto__);

}
});

cljs.core$macros._GT_.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return true;
});

cljs.core$macros._GT_.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"(~{} > ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});

cljs.core$macros._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","and","cljs.core$macros/and",48320334,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros",">","cljs.core$macros/>",1703297853,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros",">","cljs.core$macros/>",1703297853,null)),(function (){var x__28851__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),more)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros._GT_.cljs$lang$applyTo = (function (seq34800){
var G__34801 = cljs.core.first.call(null,seq34800);
var seq34800__$1 = cljs.core.next.call(null,seq34800);
var G__34802 = cljs.core.first.call(null,seq34800__$1);
var seq34800__$2 = cljs.core.next.call(null,seq34800__$1);
var G__34803 = cljs.core.first.call(null,seq34800__$2);
var seq34800__$3 = cljs.core.next.call(null,seq34800__$2);
var G__34804 = cljs.core.first.call(null,seq34800__$3);
var seq34800__$4 = cljs.core.next.call(null,seq34800__$3);
return cljs.core$macros._GT_.cljs$core$IFn$_invoke$arity$variadic(G__34801,G__34802,G__34803,G__34804,seq34800__$4);
});

cljs.core$macros._GT_.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros._GT_.cljs$lang$macro = true;

var ret__29198__auto___34818 = (function (){
cljs.core$macros._GT__EQ_ = (function cljs$core$macros$_GT__EQ_(var_args){
var G__34817 = arguments.length;
switch (G__34817) {
case 3:
return cljs.core$macros._GT__EQ_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core$macros._GT__EQ_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__29177__auto__ = [];
var len__29158__auto___34820 = arguments.length;
var i__29159__auto___34821 = (0);
while(true){
if((i__29159__auto___34821 < len__29158__auto___34820)){
args_arr__29177__auto__.push((arguments[i__29159__auto___34821]));

var G__34822 = (i__29159__auto___34821 + (1));
i__29159__auto___34821 = G__34822;
continue;
} else {
}
break;
}

var argseq__29178__auto__ = (new cljs.core.IndexedSeq(args_arr__29177__auto__.slice((4)),(0),null));
return cljs.core$macros._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__29178__auto__);

}
});

cljs.core$macros._GT__EQ_.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return true;
});

cljs.core$macros._GT__EQ_.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"(~{} >= ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});

cljs.core$macros._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","and","cljs.core$macros/and",48320334,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros",">=","cljs.core$macros/>=",527849062,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros",">=","cljs.core$macros/>=",527849062,null)),(function (){var x__28851__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),more)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros._GT__EQ_.cljs$lang$applyTo = (function (seq34812){
var G__34813 = cljs.core.first.call(null,seq34812);
var seq34812__$1 = cljs.core.next.call(null,seq34812);
var G__34814 = cljs.core.first.call(null,seq34812__$1);
var seq34812__$2 = cljs.core.next.call(null,seq34812__$1);
var G__34815 = cljs.core.first.call(null,seq34812__$2);
var seq34812__$3 = cljs.core.next.call(null,seq34812__$2);
var G__34816 = cljs.core.first.call(null,seq34812__$3);
var seq34812__$4 = cljs.core.next.call(null,seq34812__$3);
return cljs.core$macros._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__34813,G__34814,G__34815,G__34816,seq34812__$4);
});

cljs.core$macros._GT__EQ_.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros._GT__EQ_.cljs$lang$macro = true;

var ret__29198__auto___34830 = (function (){
cljs.core$macros._EQ__EQ_ = (function cljs$core$macros$_EQ__EQ_(var_args){
var G__34829 = arguments.length;
switch (G__34829) {
case 3:
return cljs.core$macros._EQ__EQ_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core$macros._EQ__EQ_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__29177__auto__ = [];
var len__29158__auto___34832 = arguments.length;
var i__29159__auto___34833 = (0);
while(true){
if((i__29159__auto___34833 < len__29158__auto___34832)){
args_arr__29177__auto__.push((arguments[i__29159__auto___34833]));

var G__34834 = (i__29159__auto___34833 + (1));
i__29159__auto___34833 = G__34834;
continue;
} else {
}
break;
}

var argseq__29178__auto__ = (new cljs.core.IndexedSeq(args_arr__29177__auto__.slice((4)),(0),null));
return cljs.core$macros._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__29178__auto__);

}
});

cljs.core$macros._EQ__EQ_.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return true;
});

cljs.core$macros._EQ__EQ_.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"(~{} === ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});

cljs.core$macros._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","and","cljs.core$macros/and",48320334,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","==","cljs.core$macros/==",-818551413,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","==","cljs.core$macros/==",-818551413,null)),(function (){var x__28851__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),more)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros._EQ__EQ_.cljs$lang$applyTo = (function (seq34824){
var G__34825 = cljs.core.first.call(null,seq34824);
var seq34824__$1 = cljs.core.next.call(null,seq34824);
var G__34826 = cljs.core.first.call(null,seq34824__$1);
var seq34824__$2 = cljs.core.next.call(null,seq34824__$1);
var G__34827 = cljs.core.first.call(null,seq34824__$2);
var seq34824__$3 = cljs.core.next.call(null,seq34824__$2);
var G__34828 = cljs.core.first.call(null,seq34824__$3);
var seq34824__$4 = cljs.core.next.call(null,seq34824__$3);
return cljs.core$macros._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__34825,G__34826,G__34827,G__34828,seq34824__$4);
});

cljs.core$macros._EQ__EQ_.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros._EQ__EQ_.cljs$lang$macro = true;

var ret__29198__auto___34835 = cljs.core$macros.dec = (function cljs$core$macros$dec(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","-","cljs.core$macros/-",13526976,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(1)))));
});
cljs.core$macros.dec.cljs$lang$macro = true;

var ret__29198__auto___34836 = cljs.core$macros.inc = (function cljs$core$macros$inc(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","+","cljs.core$macros/+",-18260342,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(1)))));
});
cljs.core$macros.inc.cljs$lang$macro = true;

var ret__29198__auto___34837 = cljs.core$macros.zero_QMARK_ = (function cljs$core$macros$zero_QMARK_(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","==","cljs.core$macros/==",-818551413,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0)))));
});
cljs.core$macros.zero_QMARK_.cljs$lang$macro = true;

var ret__29198__auto___34838 = cljs.core$macros.pos_QMARK_ = (function cljs$core$macros$pos_QMARK_(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros",">","cljs.core$macros/>",1703297853,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0)))));
});
cljs.core$macros.pos_QMARK_.cljs$lang$macro = true;

var ret__29198__auto___34839 = cljs.core$macros.neg_QMARK_ = (function cljs$core$macros$neg_QMARK_(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","<","cljs.core$macros/<",371512596,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0)))));
});
cljs.core$macros.neg_QMARK_.cljs$lang$macro = true;

var ret__29198__auto___34849 = (function (){
cljs.core$macros.max = (function cljs$core$macros$max(var_args){
var G__34848 = arguments.length;
switch (G__34848) {
case 3:
return cljs.core$macros.max.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core$macros.max.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__29177__auto__ = [];
var len__29158__auto___34851 = arguments.length;
var i__29159__auto___34852 = (0);
while(true){
if((i__29159__auto___34852 < len__29158__auto___34851)){
args_arr__29177__auto__.push((arguments[i__29159__auto___34852]));

var G__34853 = (i__29159__auto___34852 + (1));
i__29159__auto___34852 = G__34853;
continue;
} else {
}
break;
}

var argseq__29178__auto__ = (new cljs.core.IndexedSeq(args_arr__29177__auto__.slice((4)),(0),null));
return cljs.core$macros.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__29178__auto__);

}
});

cljs.core$macros.max.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return x;
});

cljs.core$macros.max.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"x__34840__auto__","x__34840__auto__",-1669511028,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"y__34841__auto__","y__34841__auto__",1189553108,null)),(function (){var x__28851__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"js*","js*",-1134233646,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,"((~{} > ~{}) ? ~{} : ~{})"),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"x__34840__auto__","x__34840__auto__",-1669511028,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"y__34841__auto__","y__34841__auto__",1189553108,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"x__34840__auto__","x__34840__auto__",-1669511028,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"y__34841__auto__","y__34841__auto__",1189553108,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.max.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","max","cljs.core$macros/max",1176150699,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","max","cljs.core$macros/max",1176150699,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),more)));
});

cljs.core$macros.max.cljs$lang$applyTo = (function (seq34843){
var G__34844 = cljs.core.first.call(null,seq34843);
var seq34843__$1 = cljs.core.next.call(null,seq34843);
var G__34845 = cljs.core.first.call(null,seq34843__$1);
var seq34843__$2 = cljs.core.next.call(null,seq34843__$1);
var G__34846 = cljs.core.first.call(null,seq34843__$2);
var seq34843__$3 = cljs.core.next.call(null,seq34843__$2);
var G__34847 = cljs.core.first.call(null,seq34843__$3);
var seq34843__$4 = cljs.core.next.call(null,seq34843__$3);
return cljs.core$macros.max.cljs$core$IFn$_invoke$arity$variadic(G__34844,G__34845,G__34846,G__34847,seq34843__$4);
});

cljs.core$macros.max.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros.max.cljs$lang$macro = true;

var ret__29198__auto___34863 = (function (){
cljs.core$macros.min = (function cljs$core$macros$min(var_args){
var G__34862 = arguments.length;
switch (G__34862) {
case 3:
return cljs.core$macros.min.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core$macros.min.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__29177__auto__ = [];
var len__29158__auto___34865 = arguments.length;
var i__29159__auto___34866 = (0);
while(true){
if((i__29159__auto___34866 < len__29158__auto___34865)){
args_arr__29177__auto__.push((arguments[i__29159__auto___34866]));

var G__34867 = (i__29159__auto___34866 + (1));
i__29159__auto___34866 = G__34867;
continue;
} else {
}
break;
}

var argseq__29178__auto__ = (new cljs.core.IndexedSeq(args_arr__29177__auto__.slice((4)),(0),null));
return cljs.core$macros.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__29178__auto__);

}
});

cljs.core$macros.min.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return x;
});

cljs.core$macros.min.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"x__34854__auto__","x__34854__auto__",424036783,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"y__34855__auto__","y__34855__auto__",-2021251895,null)),(function (){var x__28851__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"js*","js*",-1134233646,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,"((~{} < ~{}) ? ~{} : ~{})"),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"x__34854__auto__","x__34854__auto__",424036783,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"y__34855__auto__","y__34855__auto__",-2021251895,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"x__34854__auto__","x__34854__auto__",424036783,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"y__34855__auto__","y__34855__auto__",-2021251895,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.min.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","min","cljs.core$macros/min",1499775161,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","min","cljs.core$macros/min",1499775161,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),more)));
});

cljs.core$macros.min.cljs$lang$applyTo = (function (seq34857){
var G__34858 = cljs.core.first.call(null,seq34857);
var seq34857__$1 = cljs.core.next.call(null,seq34857);
var G__34859 = cljs.core.first.call(null,seq34857__$1);
var seq34857__$2 = cljs.core.next.call(null,seq34857__$1);
var G__34860 = cljs.core.first.call(null,seq34857__$2);
var seq34857__$3 = cljs.core.next.call(null,seq34857__$2);
var G__34861 = cljs.core.first.call(null,seq34857__$3);
var seq34857__$4 = cljs.core.next.call(null,seq34857__$3);
return cljs.core$macros.min.cljs$core$IFn$_invoke$arity$variadic(G__34858,G__34859,G__34860,G__34861,seq34857__$4);
});

cljs.core$macros.min.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros.min.cljs$lang$macro = true;

var ret__29198__auto___34868 = cljs.core$macros.js_mod = (function cljs$core$macros$js_mod(_AMPERSAND_form,_AMPERSAND_env,num,div){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = num;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = div;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"(~{} % ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.js_mod.cljs$lang$macro = true;

var ret__29198__auto___34869 = cljs.core$macros.bit_not = (function cljs$core$macros$bit_not(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),"(~ ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.bit_not.cljs$lang$macro = true;

var ret__29198__auto___34877 = (function (){
cljs.core$macros.bit_and = (function cljs$core$macros$bit_and(var_args){
var G__34876 = arguments.length;
switch (G__34876) {
case 4:
return cljs.core$macros.bit_and.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__29177__auto__ = [];
var len__29158__auto___34879 = arguments.length;
var i__29159__auto___34880 = (0);
while(true){
if((i__29159__auto___34880 < len__29158__auto___34879)){
args_arr__29177__auto__.push((arguments[i__29159__auto___34880]));

var G__34881 = (i__29159__auto___34880 + (1));
i__29159__auto___34880 = G__34881;
continue;
} else {
}
break;
}

var argseq__29178__auto__ = (new cljs.core.IndexedSeq(args_arr__29177__auto__.slice((4)),(0),null));
return cljs.core$macros.bit_and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__29178__auto__);

}
});

cljs.core$macros.bit_and.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"(~{} & ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});

cljs.core$macros.bit_and.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","bit-and","cljs.core$macros/bit-and",-1069060797,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","bit-and","cljs.core$macros/bit-and",-1069060797,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),more)));
});

cljs.core$macros.bit_and.cljs$lang$applyTo = (function (seq34871){
var G__34872 = cljs.core.first.call(null,seq34871);
var seq34871__$1 = cljs.core.next.call(null,seq34871);
var G__34873 = cljs.core.first.call(null,seq34871__$1);
var seq34871__$2 = cljs.core.next.call(null,seq34871__$1);
var G__34874 = cljs.core.first.call(null,seq34871__$2);
var seq34871__$3 = cljs.core.next.call(null,seq34871__$2);
var G__34875 = cljs.core.first.call(null,seq34871__$3);
var seq34871__$4 = cljs.core.next.call(null,seq34871__$3);
return cljs.core$macros.bit_and.cljs$core$IFn$_invoke$arity$variadic(G__34872,G__34873,G__34874,G__34875,seq34871__$4);
});

cljs.core$macros.bit_and.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros.bit_and.cljs$lang$macro = true;

var ret__29198__auto___34889 = (function (){
cljs.core$macros.unsafe_bit_and = (function cljs$core$macros$unsafe_bit_and(var_args){
var G__34888 = arguments.length;
switch (G__34888) {
case 4:
return cljs.core$macros.unsafe_bit_and.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__29177__auto__ = [];
var len__29158__auto___34891 = arguments.length;
var i__29159__auto___34892 = (0);
while(true){
if((i__29159__auto___34892 < len__29158__auto___34891)){
args_arr__29177__auto__.push((arguments[i__29159__auto___34892]));

var G__34893 = (i__29159__auto___34892 + (1));
i__29159__auto___34892 = G__34893;
continue;
} else {
}
break;
}

var argseq__29178__auto__ = (new cljs.core.IndexedSeq(args_arr__29177__auto__.slice((4)),(0),null));
return cljs.core$macros.unsafe_bit_and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__29178__auto__);

}
});

cljs.core$macros.unsafe_bit_and.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"(~{} & ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});

cljs.core$macros.unsafe_bit_and.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","unsafe-bit-and","cljs.core$macros/unsafe-bit-and",1803731600,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","unsafe-bit-and","cljs.core$macros/unsafe-bit-and",1803731600,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),more)));
});

cljs.core$macros.unsafe_bit_and.cljs$lang$applyTo = (function (seq34883){
var G__34884 = cljs.core.first.call(null,seq34883);
var seq34883__$1 = cljs.core.next.call(null,seq34883);
var G__34885 = cljs.core.first.call(null,seq34883__$1);
var seq34883__$2 = cljs.core.next.call(null,seq34883__$1);
var G__34886 = cljs.core.first.call(null,seq34883__$2);
var seq34883__$3 = cljs.core.next.call(null,seq34883__$2);
var G__34887 = cljs.core.first.call(null,seq34883__$3);
var seq34883__$4 = cljs.core.next.call(null,seq34883__$3);
return cljs.core$macros.unsafe_bit_and.cljs$core$IFn$_invoke$arity$variadic(G__34884,G__34885,G__34886,G__34887,seq34883__$4);
});

cljs.core$macros.unsafe_bit_and.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros.unsafe_bit_and.cljs$lang$macro = true;

var ret__29198__auto___34901 = (function (){
cljs.core$macros.bit_or = (function cljs$core$macros$bit_or(var_args){
var G__34900 = arguments.length;
switch (G__34900) {
case 4:
return cljs.core$macros.bit_or.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__29177__auto__ = [];
var len__29158__auto___34903 = arguments.length;
var i__29159__auto___34904 = (0);
while(true){
if((i__29159__auto___34904 < len__29158__auto___34903)){
args_arr__29177__auto__.push((arguments[i__29159__auto___34904]));

var G__34905 = (i__29159__auto___34904 + (1));
i__29159__auto___34904 = G__34905;
continue;
} else {
}
break;
}

var argseq__29178__auto__ = (new cljs.core.IndexedSeq(args_arr__29177__auto__.slice((4)),(0),null));
return cljs.core$macros.bit_or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__29178__auto__);

}
});

cljs.core$macros.bit_or.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"(~{} | ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});

cljs.core$macros.bit_or.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","bit-or","cljs.core$macros/bit-or",1463236165,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","bit-or","cljs.core$macros/bit-or",1463236165,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),more)));
});

cljs.core$macros.bit_or.cljs$lang$applyTo = (function (seq34895){
var G__34896 = cljs.core.first.call(null,seq34895);
var seq34895__$1 = cljs.core.next.call(null,seq34895);
var G__34897 = cljs.core.first.call(null,seq34895__$1);
var seq34895__$2 = cljs.core.next.call(null,seq34895__$1);
var G__34898 = cljs.core.first.call(null,seq34895__$2);
var seq34895__$3 = cljs.core.next.call(null,seq34895__$2);
var G__34899 = cljs.core.first.call(null,seq34895__$3);
var seq34895__$4 = cljs.core.next.call(null,seq34895__$3);
return cljs.core$macros.bit_or.cljs$core$IFn$_invoke$arity$variadic(G__34896,G__34897,G__34898,G__34899,seq34895__$4);
});

cljs.core$macros.bit_or.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros.bit_or.cljs$lang$macro = true;

var ret__29198__auto___34906 = cljs.core$macros.int$ = (function cljs$core$macros$int(_AMPERSAND_form,_AMPERSAND_env,x){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","bit-or","cljs.core$macros/bit-or",1463236165,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0)))));
});
cljs.core$macros.int$.cljs$lang$macro = true;

var ret__29198__auto___34914 = (function (){
cljs.core$macros.bit_xor = (function cljs$core$macros$bit_xor(var_args){
var G__34913 = arguments.length;
switch (G__34913) {
case 4:
return cljs.core$macros.bit_xor.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__29177__auto__ = [];
var len__29158__auto___34916 = arguments.length;
var i__29159__auto___34917 = (0);
while(true){
if((i__29159__auto___34917 < len__29158__auto___34916)){
args_arr__29177__auto__.push((arguments[i__29159__auto___34917]));

var G__34918 = (i__29159__auto___34917 + (1));
i__29159__auto___34917 = G__34918;
continue;
} else {
}
break;
}

var argseq__29178__auto__ = (new cljs.core.IndexedSeq(args_arr__29177__auto__.slice((4)),(0),null));
return cljs.core$macros.bit_xor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__29178__auto__);

}
});

cljs.core$macros.bit_xor.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"(~{} ^ ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});

cljs.core$macros.bit_xor.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","bit-xor","cljs.core$macros/bit-xor",1284619191,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","bit-xor","cljs.core$macros/bit-xor",1284619191,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),more)));
});

cljs.core$macros.bit_xor.cljs$lang$applyTo = (function (seq34908){
var G__34909 = cljs.core.first.call(null,seq34908);
var seq34908__$1 = cljs.core.next.call(null,seq34908);
var G__34910 = cljs.core.first.call(null,seq34908__$1);
var seq34908__$2 = cljs.core.next.call(null,seq34908__$1);
var G__34911 = cljs.core.first.call(null,seq34908__$2);
var seq34908__$3 = cljs.core.next.call(null,seq34908__$2);
var G__34912 = cljs.core.first.call(null,seq34908__$3);
var seq34908__$4 = cljs.core.next.call(null,seq34908__$3);
return cljs.core$macros.bit_xor.cljs$core$IFn$_invoke$arity$variadic(G__34909,G__34910,G__34911,G__34912,seq34908__$4);
});

cljs.core$macros.bit_xor.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros.bit_xor.cljs$lang$macro = true;

var ret__29198__auto___34926 = (function (){
cljs.core$macros.bit_and_not = (function cljs$core$macros$bit_and_not(var_args){
var G__34925 = arguments.length;
switch (G__34925) {
case 4:
return cljs.core$macros.bit_and_not.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__29177__auto__ = [];
var len__29158__auto___34928 = arguments.length;
var i__29159__auto___34929 = (0);
while(true){
if((i__29159__auto___34929 < len__29158__auto___34928)){
args_arr__29177__auto__.push((arguments[i__29159__auto___34929]));

var G__34930 = (i__29159__auto___34929 + (1));
i__29159__auto___34929 = G__34930;
continue;
} else {
}
break;
}

var argseq__29178__auto__ = (new cljs.core.IndexedSeq(args_arr__29177__auto__.slice((4)),(0),null));
return cljs.core$macros.bit_and_not.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__29178__auto__);

}
});

cljs.core$macros.bit_and_not.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,y){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"(~{} & ~~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});

cljs.core$macros.bit_and_not.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,y,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","bit-and-not","cljs.core$macros/bit-and-not",-537076037,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","bit-and-not","cljs.core$macros/bit-and-not",-537076037,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = y;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),more)));
});

cljs.core$macros.bit_and_not.cljs$lang$applyTo = (function (seq34920){
var G__34921 = cljs.core.first.call(null,seq34920);
var seq34920__$1 = cljs.core.next.call(null,seq34920);
var G__34922 = cljs.core.first.call(null,seq34920__$1);
var seq34920__$2 = cljs.core.next.call(null,seq34920__$1);
var G__34923 = cljs.core.first.call(null,seq34920__$2);
var seq34920__$3 = cljs.core.next.call(null,seq34920__$2);
var G__34924 = cljs.core.first.call(null,seq34920__$3);
var seq34920__$4 = cljs.core.next.call(null,seq34920__$3);
return cljs.core$macros.bit_and_not.cljs$core$IFn$_invoke$arity$variadic(G__34921,G__34922,G__34923,G__34924,seq34920__$4);
});

cljs.core$macros.bit_and_not.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros.bit_and_not.cljs$lang$macro = true;

var ret__29198__auto___34931 = cljs.core$macros.bit_clear = (function cljs$core$macros$bit_clear(_AMPERSAND_form,_AMPERSAND_env,x,n){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = n;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"(~{} & ~(1 << ~{}))"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.bit_clear.cljs$lang$macro = true;

var ret__29198__auto___34932 = cljs.core$macros.bit_flip = (function cljs$core$macros$bit_flip(_AMPERSAND_form,_AMPERSAND_env,x,n){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = n;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"(~{} ^ (1 << ~{}))"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.bit_flip.cljs$lang$macro = true;

var ret__29198__auto___34933 = cljs.core$macros.bit_test = (function cljs$core$macros$bit_test(_AMPERSAND_form,_AMPERSAND_env,x,n){
return cljs.core$macros.bool_expr.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = n;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"((~{} & (1 << ~{})) != 0)"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)));
});
cljs.core$macros.bit_test.cljs$lang$macro = true;

var ret__29198__auto___34934 = cljs.core$macros.bit_shift_left = (function cljs$core$macros$bit_shift_left(_AMPERSAND_form,_AMPERSAND_env,x,n){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = n;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"(~{} << ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.bit_shift_left.cljs$lang$macro = true;

var ret__29198__auto___34935 = cljs.core$macros.bit_shift_right = (function cljs$core$macros$bit_shift_right(_AMPERSAND_form,_AMPERSAND_env,x,n){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = n;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"(~{} >> ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.bit_shift_right.cljs$lang$macro = true;

var ret__29198__auto___34936 = cljs.core$macros.bit_shift_right_zero_fill = (function cljs$core$macros$bit_shift_right_zero_fill(_AMPERSAND_form,_AMPERSAND_env,x,n){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = n;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"(~{} >>> ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.bit_shift_right_zero_fill.cljs$lang$macro = true;

var ret__29198__auto___34937 = cljs.core$macros.unsigned_bit_shift_right = (function cljs$core$macros$unsigned_bit_shift_right(_AMPERSAND_form,_AMPERSAND_env,x,n){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = n;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"(~{} >>> ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.unsigned_bit_shift_right.cljs$lang$macro = true;

var ret__29198__auto___34938 = cljs.core$macros.bit_set = (function cljs$core$macros$bit_set(_AMPERSAND_form,_AMPERSAND_env,x,n){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = n;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"(~{} | (1 << ~{}))"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.bit_set.cljs$lang$macro = true;

var ret__29198__auto___34939 = cljs.core$macros.mask = (function cljs$core$macros$mask(_AMPERSAND_form,_AMPERSAND_env,hash,shift){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = hash;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = shift;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),"((~{} >>> ~{}) & 0x01f)"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.mask.cljs$lang$macro = true;

var ret__29198__auto___34940 = cljs.core$macros.bitpos = (function cljs$core$macros$bitpos(_AMPERSAND_form,_AMPERSAND_env,hash,shift){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","mask","cljs.core$macros/mask",1575319768,null)),(function (){var x__28851__auto__ = hash;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = shift;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),"(1 << ~{})"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.bitpos.cljs$lang$macro = true;

var ret__29198__auto___34942 = cljs.core$macros.caching_hash = (function cljs$core$macros$caching_hash(_AMPERSAND_form,_AMPERSAND_env,coll,hash_fn,hash_key){
if((hash_key instanceof cljs.core.Symbol)){
} else {
throw (new Error(["Assert failed: ","hash-key is substituted twice","\n","(clojure.core/symbol? hash-key)"].join('')));
}

return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"h__34941__auto__","h__34941__auto__",-1530623306,null)),(function (){var x__28851__auto__ = hash_key;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","if-not","cljs.core$macros/if-not",-1825285737,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","nil?","cljs.core$macros/nil?",83624258,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"h__34941__auto__","h__34941__auto__",-1530623306,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"h__34941__auto__","h__34941__auto__",-1530623306,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"h__34941__auto__","h__34941__auto__",-1530623306,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = hash_fn;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = coll;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__28851__auto__ = hash_key;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"h__34941__auto__","h__34941__auto__",-1530623306,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"h__34941__auto__","h__34941__auto__",-1530623306,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
cljs.core$macros.caching_hash.cljs$lang$macro = true;

cljs.core$macros.do_curried = (function cljs$core$macros$do_curried(name,doc,meta,args,body){
var cargs = cljs.core.vec.call(null,cljs.core.butlast.call(null,args));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","defn","cljs.core$macros/defn",-728332354,null)),(function (){var x__28851__auto__ = name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = doc;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = meta;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = cargs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"x__34943__auto__","x__34943__auto__",-1512795612,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cargs,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"x__34943__auto__","x__34943__auto__",-1512795612,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = args;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),body)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
var ret__29198__auto___34951 = (function (){
/**
 * Builds another arity of the fn that returns a fn awaiting the last
 *   param
 */
cljs.core$macros.defcurried = (function cljs$core$macros$defcurried(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34952 = arguments.length;
var i__29159__auto___34953 = (0);
while(true){
if((i__29159__auto___34953 < len__29158__auto___34952)){
args__29165__auto__.push((arguments[i__29159__auto___34953]));

var G__34954 = (i__29159__auto___34953 + (1));
i__29159__auto___34953 = G__34954;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((6) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((6)),(0),null)):null);
return cljs.core$macros.defcurried.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__29166__auto__);
});

cljs.core$macros.defcurried.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,name,doc,meta,args,body){
return cljs.core$macros.do_curried.call(null,name,doc,meta,args,body);
});

cljs.core$macros.defcurried.cljs$lang$maxFixedArity = (6);

cljs.core$macros.defcurried.cljs$lang$applyTo = (function (seq34944){
var G__34945 = cljs.core.first.call(null,seq34944);
var seq34944__$1 = cljs.core.next.call(null,seq34944);
var G__34946 = cljs.core.first.call(null,seq34944__$1);
var seq34944__$2 = cljs.core.next.call(null,seq34944__$1);
var G__34947 = cljs.core.first.call(null,seq34944__$2);
var seq34944__$3 = cljs.core.next.call(null,seq34944__$2);
var G__34948 = cljs.core.first.call(null,seq34944__$3);
var seq34944__$4 = cljs.core.next.call(null,seq34944__$3);
var G__34949 = cljs.core.first.call(null,seq34944__$4);
var seq34944__$5 = cljs.core.next.call(null,seq34944__$4);
var G__34950 = cljs.core.first.call(null,seq34944__$5);
var seq34944__$6 = cljs.core.next.call(null,seq34944__$5);
return cljs.core$macros.defcurried.cljs$core$IFn$_invoke$arity$variadic(G__34945,G__34946,G__34947,G__34948,G__34949,G__34950,seq34944__$6);
});

return null;
})()
;
cljs.core$macros.defcurried.cljs$lang$macro = true;

cljs.core$macros.do_rfn = (function cljs$core$macros$do_rfn(f1,k,fkv){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = f1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = clojure.walk.postwalk.call(null,(function (p1__34955_SHARP_){
if(cljs.core.sequential_QMARK_.call(null,p1__34955_SHARP_)){
return ((cljs.core.vector_QMARK_.call(null,p1__34955_SHARP_))?cljs.core.vec:cljs.core.identity).call(null,cljs.core.remove.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([k]),p1__34955_SHARP_));
} else {
return p1__34955_SHARP_;
}
}),fkv);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = fkv;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
var ret__29198__auto___34960 = /**
 * Builds 3-arity reducing fn given names of wrapped fn and key, and k/v impl.
 */
cljs.core$macros.rfn = (function cljs$core$macros$rfn(_AMPERSAND_form,_AMPERSAND_env,p__34956,fkv){
var vec__34957 = p__34956;
var f1 = cljs.core.nth.call(null,vec__34957,(0),null);
var k = cljs.core.nth.call(null,vec__34957,(1),null);
return cljs.core$macros.do_rfn.call(null,f1,k,fkv);
});
cljs.core$macros.rfn.cljs$lang$macro = true;

cljs.core$macros.protocol_prefix = (function cljs$core$macros$protocol_prefix(psym){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym)].join('').replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join('');
});
cljs.core$macros.base_type = new cljs.core.PersistentArrayMap(null, 8, [null,"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"object",new cljs.core.Symbol(null,"string","string",-349010059,null),"string",new cljs.core.Symbol(null,"number","number",-1084057331,null),"number",new cljs.core.Symbol(null,"array","array",-440182315,null),"array",new cljs.core.Symbol(null,"function","function",-486723946,null),"function",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"boolean",new cljs.core.Symbol(null,"default","default",-347290801,null),"_"], null);
cljs.core$macros.js_base_type = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Symbol("js","Boolean","js/Boolean",1661145260,null),"boolean",new cljs.core.Symbol("js","String","js/String",-2070054036,null),"string",new cljs.core.Symbol("js","Array","js/Array",-423508366,null),"array",new cljs.core.Symbol("js","Object","js/Object",61215323,null),"object",new cljs.core.Symbol("js","Number","js/Number",-508133572,null),"number",new cljs.core.Symbol("js","Function","js/Function",-749892063,null),"function"], null);
var ret__29198__auto___34964 = (function (){
/**
 * reify is a macro with the following structure:
 * 
 *  (reify options* specs*)
 * 
 *   Currently there are no options.
 * 
 *   Each spec consists of the protocol name followed by zero
 *   or more method bodies:
 * 
 *   protocol
 *   (methodName [args+] body)*
 * 
 *   Methods should be supplied for all methods of the desired
 *   protocol(s). You can also define overrides for Object methods. Note that
 *   the first parameter must be supplied to correspond to the target object
 *   ('this' in JavaScript parlance). Note also that recur calls
 *   to the method head should *not* pass the target object, it will be supplied
 *   automatically and can not be substituted.
 * 
 *   recur works to method heads The method bodies of reify are lexical
 *   closures, and can refer to the surrounding local scope:
 * 
 *   (str (let [f "foo"]
 *     (reify Object
 *       (toString [this] f))))
 *   == "foo"
 * 
 *   (seq (let [f "foo"]
 *     (reify ISeqable
 *       (-seq [this] (seq f)))))
 *   == ("f" "o" "o"))
 * 
 *   reify always implements IMeta and IWithMeta and transfers meta
 *   data of the form to the created object.
 * 
 *   (meta ^{:k :v} (reify Object (toString [this] "foo")))
 *   == {:k :v}
 */
cljs.core$macros.reify = (function cljs$core$macros$reify(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34965 = arguments.length;
var i__29159__auto___34966 = (0);
while(true){
if((i__29159__auto___34966 < len__29158__auto___34965)){
args__29165__auto__.push((arguments[i__29159__auto___34966]));

var G__34967 = (i__29159__auto___34966 + (1));
i__29159__auto___34966 = G__34967;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((2) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.reify.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29166__auto__);
});

cljs.core$macros.reify.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,impls){
var t = cljs.core.with_meta.call(null,cljs.core.gensym.call(null,["t_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.replace.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.munge.call(null,cljs.analyzer._STAR_cljs_ns_STAR_))].join(''),".","$"))].join('')),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"anonymous","anonymous",447897231),true], null));
var meta_sym = cljs.core.gensym.call(null,"meta");
var this_sym = cljs.core.gensym.call(null,"_");
var locals = cljs.core.keys.call(null,new cljs.core.Keyword(null,"locals","locals",535295783).cljs$core$IFn$_invoke$arity$1(_AMPERSAND_env));
var ns = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(_AMPERSAND_env));
var munge = cljs.compiler.munge;
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when-not","cljs.core$macros/when-not",-764302244,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","exists?","cljs.core$macros/exists?",-1828590389,null)),(function (){var x__28851__auto__ = cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)].join(''),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(t)].join(''));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","deftype","cljs.core$macros/deftype",1799045688,null)),(function (){var x__28851__auto__ = t;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,locals,(function (){var x__28851__auto__ = meta_sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","IWithMeta","cljs.core/IWithMeta",-1981666051,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-with-meta","-with-meta",-1610713823,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = this_sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = meta_sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"new","new",-444906321,null)),(function (){var x__28851__auto__ = t;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),locals,(function (){var x__28851__auto__ = meta_sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","IMeta","cljs.core/IMeta",-1459057517,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-meta","-meta",494863156,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = this_sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = meta_sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),impls)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"new","new",-444906321,null)),(function (){var x__28851__auto__ = t;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),locals,(function (){var x__28851__auto__ = cljs.analyzer.elide_reader_meta.call(null,cljs.core.meta.call(null,_AMPERSAND_form));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.reify.cljs$lang$maxFixedArity = (2);

cljs.core$macros.reify.cljs$lang$applyTo = (function (seq34961){
var G__34962 = cljs.core.first.call(null,seq34961);
var seq34961__$1 = cljs.core.next.call(null,seq34961);
var G__34963 = cljs.core.first.call(null,seq34961__$1);
var seq34961__$2 = cljs.core.next.call(null,seq34961__$1);
return cljs.core$macros.reify.cljs$core$IFn$_invoke$arity$variadic(G__34962,G__34963,seq34961__$2);
});

return null;
})()
;
cljs.core$macros.reify.cljs$lang$macro = true;

var ret__29198__auto___34972 = (function (){
/**
 * Identical to reify but mutates its first argument.
 */
cljs.core$macros.specify_BANG_ = (function cljs$core$macros$specify_BANG_(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34973 = arguments.length;
var i__29159__auto___34974 = (0);
while(true){
if((i__29159__auto___34974 < len__29158__auto___34973)){
args__29165__auto__.push((arguments[i__29159__auto___34974]));

var G__34975 = (i__29159__auto___34974 + (1));
i__29159__auto___34974 = G__34975;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((3) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.specify_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29166__auto__);
});

cljs.core$macros.specify_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,expr,impls){
var x = cljs.core.with_meta.call(null,cljs.core.gensym.call(null,"x"),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"extend","extend",1836484006),new cljs.core.Keyword(null,"instance","instance",-2121349050)], null));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = expr;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","extend-type","cljs.core$macros/extend-type",1713295201,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),impls)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.specify_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core$macros.specify_BANG_.cljs$lang$applyTo = (function (seq34968){
var G__34969 = cljs.core.first.call(null,seq34968);
var seq34968__$1 = cljs.core.next.call(null,seq34968);
var G__34970 = cljs.core.first.call(null,seq34968__$1);
var seq34968__$2 = cljs.core.next.call(null,seq34968__$1);
var G__34971 = cljs.core.first.call(null,seq34968__$2);
var seq34968__$3 = cljs.core.next.call(null,seq34968__$2);
return cljs.core$macros.specify_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__34969,G__34970,G__34971,seq34968__$3);
});

return null;
})()
;
cljs.core$macros.specify_BANG_.cljs$lang$macro = true;

var ret__29198__auto___34980 = (function (){
/**
 * Identical to specify! but does not mutate its first argument. The first
 *   argument must be an ICloneable instance.
 */
cljs.core$macros.specify = (function cljs$core$macros$specify(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34981 = arguments.length;
var i__29159__auto___34982 = (0);
while(true){
if((i__29159__auto___34982 < len__29158__auto___34981)){
args__29165__auto__.push((arguments[i__29159__auto___34982]));

var G__34983 = (i__29159__auto___34982 + (1));
i__29159__auto___34982 = G__34983;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((3) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.specify.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29166__auto__);
});

cljs.core$macros.specify.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,expr,impls){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","specify!","cljs.core/specify!",-585401629,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","clone","cljs.core/clone",1417120092,null)),(function (){var x__28851__auto__ = expr;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),impls)));
});

cljs.core$macros.specify.cljs$lang$maxFixedArity = (3);

cljs.core$macros.specify.cljs$lang$applyTo = (function (seq34976){
var G__34977 = cljs.core.first.call(null,seq34976);
var seq34976__$1 = cljs.core.next.call(null,seq34976);
var G__34978 = cljs.core.first.call(null,seq34976__$1);
var seq34976__$2 = cljs.core.next.call(null,seq34976__$1);
var G__34979 = cljs.core.first.call(null,seq34976__$2);
var seq34976__$3 = cljs.core.next.call(null,seq34976__$2);
return cljs.core$macros.specify.cljs$core$IFn$_invoke$arity$variadic(G__34977,G__34978,G__34979,seq34976__$3);
});

return null;
})()
;
cljs.core$macros.specify.cljs$lang$macro = true;

var ret__29198__auto___34984 = cljs.core$macros.js_this = (function cljs$core$macros$js_this(_AMPERSAND_form,_AMPERSAND_env){
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,"this"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.js_this.cljs$lang$macro = true;

var ret__29198__auto___34989 = (function (){
/**
 * Defines a scope where JavaScript's implicit "this" is bound to the name provided.
 */
cljs.core$macros.this_as = (function cljs$core$macros$this_as(var_args){
var args__29165__auto__ = [];
var len__29158__auto___34990 = arguments.length;
var i__29159__auto___34991 = (0);
while(true){
if((i__29159__auto___34991 < len__29158__auto___34990)){
args__29165__auto__.push((arguments[i__29159__auto___34991]));

var G__34992 = (i__29159__auto___34991 + (1));
i__29159__auto___34991 = G__34992;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((3) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.this_as.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29166__auto__);
});

cljs.core$macros.this_as.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,name,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","js-this","cljs.core$macros/js-this",353597180,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),body)));
});

cljs.core$macros.this_as.cljs$lang$maxFixedArity = (3);

cljs.core$macros.this_as.cljs$lang$applyTo = (function (seq34985){
var G__34986 = cljs.core.first.call(null,seq34985);
var seq34985__$1 = cljs.core.next.call(null,seq34985);
var G__34987 = cljs.core.first.call(null,seq34985__$1);
var seq34985__$2 = cljs.core.next.call(null,seq34985__$1);
var G__34988 = cljs.core.first.call(null,seq34985__$2);
var seq34985__$3 = cljs.core.next.call(null,seq34985__$2);
return cljs.core$macros.this_as.cljs$core$IFn$_invoke$arity$variadic(G__34986,G__34987,G__34988,seq34985__$3);
});

return null;
})()
;
cljs.core$macros.this_as.cljs$lang$macro = true;

cljs.core$macros.to_property = (function cljs$core$macros$to_property(sym){
return cljs.core.symbol.call(null,["-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(sym)].join(''));
});
cljs.core$macros.warn_and_update_protocol = (function cljs$core$macros$warn_and_update_protocol(p,type,env){
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"Object","Object",61210754,null),p)){
return null;
} else {
var temp__4655__auto__ = cljs.analyzer.resolve_existing_var.call(null,cljs.core.dissoc.call(null,env,new cljs.core.Keyword(null,"locals","locals",535295783)),p);
if(cljs.core.truth_(temp__4655__auto__)){
var var$ = temp__4655__auto__;
if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol-symbol","protocol-symbol",1279552198).cljs$core$IFn$_invoke$arity$1(var$))){
} else {
cljs.analyzer.warning.call(null,new cljs.core.Keyword(null,"invalid-protocol-symbol","invalid-protocol-symbol",86246948),env,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"protocol","protocol",652470118),p], null));
}

if(cljs.core.truth_((function (){var and__27977__auto__ = new cljs.core.Keyword(null,"protocol-deprecated","protocol-deprecated",103233497).cljs$core$IFn$_invoke$arity$1(cljs.analyzer._STAR_cljs_warnings_STAR_);
if(cljs.core.truth_(and__27977__auto__)){
var and__27977__auto____$1 = new cljs.core.Keyword(null,"deprecated","deprecated",1498275348).cljs$core$IFn$_invoke$arity$1(var$);
if(cljs.core.truth_(and__27977__auto____$1)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"deprecation-nowarn","deprecation-nowarn",-1762828044).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,p)));
} else {
return and__27977__auto____$1;
}
} else {
return and__27977__auto__;
}
})())){
cljs.analyzer.warning.call(null,new cljs.core.Keyword(null,"protocol-deprecated","protocol-deprecated",103233497),env,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"protocol","protocol",652470118),p], null));
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol-symbol","protocol-symbol",1279552198).cljs$core$IFn$_invoke$arity$1(var$))){
return cljs.core.swap_BANG_.call(null,cljs.env._STAR_compiler_STAR_,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927)], null),((function (var$,temp__4655__auto__){
return (function (ns){
return cljs.core.update_in.call(null,ns,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(var$),new cljs.core.Keyword(null,"defs","defs",1398449717),cljs.core.symbol.call(null,cljs.core.name.call(null,p)),new cljs.core.Keyword(null,"impls","impls",-1314014853)], null),cljs.core.conj,type);
});})(var$,temp__4655__auto__))
);
} else {
return null;
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"undeclared","undeclared",1446667347).cljs$core$IFn$_invoke$arity$1(cljs.analyzer._STAR_cljs_warnings_STAR_))){
return cljs.analyzer.warning.call(null,new cljs.core.Keyword(null,"undeclared-protocol-symbol","undeclared-protocol-symbol",462882867),env,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"protocol","protocol",652470118),p], null));
} else {
return null;
}
}
}
});
cljs.core$macros.resolve_var = (function cljs$core$macros$resolve_var(env,sym){
var ret = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.call(null,env,sym));
if(cljs.core.truth_(ret)){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["Can't resolve: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(sym)].join('')),"\n","ret"].join('')));
}

return ret;
});
cljs.core$macros.__GT_impl_map = (function cljs$core$macros$__GT_impl_map(impls){
var ret = cljs.core.PersistentArrayMap.EMPTY;
var s = impls;
while(true){
if(cljs.core.seq.call(null,s)){
var G__34993 = cljs.core.assoc.call(null,ret,cljs.core.first.call(null,s),cljs.core.take_while.call(null,cljs.core.seq_QMARK_,cljs.core.next.call(null,s)));
var G__34994 = cljs.core.drop_while.call(null,cljs.core.seq_QMARK_,cljs.core.next.call(null,s));
ret = G__34993;
s = G__34994;
continue;
} else {
return ret;
}
break;
}
});
cljs.core$macros.base_assign_impls = (function cljs$core$macros$base_assign_impls(env,resolve,tsym,type,p__34995){
var vec__34996 = p__34995;
var p = cljs.core.nth.call(null,vec__34996,(0),null);
var sigs = cljs.core.nth.call(null,vec__34996,(1),null);
cljs.core$macros.warn_and_update_protocol.call(null,p,tsym,env);

var psym = resolve.call(null,p);
var pfn_prefix = cljs.core.subs.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym)].join(''),(0),([cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym)].join('').indexOf("/") + (1)));
return cljs.core.cons.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("goog.object","set","goog.object/set",-2123361230,null)),(function (){var x__28851__auto__ = psym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = type;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,true)))),cljs.core.map.call(null,((function (psym,pfn_prefix,vec__34996,p,sigs){
return (function (p__34999){
var vec__35000 = p__34999;
var seq__35001 = cljs.core.seq.call(null,vec__35000);
var first__35002 = cljs.core.first.call(null,seq__35001);
var seq__35001__$1 = cljs.core.next.call(null,seq__35001);
var f = first__35002;
var meths = seq__35001__$1;
var form = vec__35000;
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("goog.object","set","goog.object/set",-2123361230,null)),(function (){var x__28851__auto__ = cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfn_prefix),cljs.core.str.cljs$core$IFn$_invoke$arity$1(f)].join(''));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = type;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.with_meta.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),meths))),cljs.core.meta.call(null,form));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});})(psym,pfn_prefix,vec__34996,p,sigs))
,sigs));
});
if(typeof cljs.core$macros.extend_prefix !== 'undefined'){
} else {
cljs.core$macros.extend_prefix = (function (){var method_table__28944__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__28945__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__28946__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__28947__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__28948__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"cljs.core$macros","extend-prefix"),((function (method_table__28944__auto__,prefer_table__28945__auto__,method_cache__28946__auto__,cached_hierarchy__28947__auto__,hierarchy__28948__auto__){
return (function (tsym,sym){
return new cljs.core.Keyword(null,"extend","extend",1836484006).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,tsym));
});})(method_table__28944__auto__,prefer_table__28945__auto__,method_cache__28946__auto__,cached_hierarchy__28947__auto__,hierarchy__28948__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__28948__auto__,method_table__28944__auto__,prefer_table__28945__auto__,method_cache__28946__auto__,cached_hierarchy__28947__auto__));
})();
}
cljs.core._add_method.call(null,cljs.core$macros.extend_prefix,new cljs.core.Keyword(null,"instance","instance",-2121349050),(function (tsym,sym){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"..","..",-300507420,null)),(function (){var x__28851__auto__ = tsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core$macros.to_property.call(null,sym);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
}));
cljs.core._add_method.call(null,cljs.core$macros.extend_prefix,new cljs.core.Keyword(null,"default","default",-1987822328),(function (tsym,sym){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"..","..",-300507420,null)),(function (){var x__28851__auto__ = tsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-prototype","-prototype",-450831903,null)),(function (){var x__28851__auto__ = cljs.core$macros.to_property.call(null,sym);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
}));
cljs.core$macros.adapt_obj_params = (function cljs$core$macros$adapt_obj_params(type,p__35003){
var vec__35004 = p__35003;
var seq__35005 = cljs.core.seq.call(null,vec__35004);
var first__35006 = cljs.core.first.call(null,seq__35005);
var seq__35005__$1 = cljs.core.next.call(null,seq__35005);
var vec__35007 = first__35006;
var seq__35008 = cljs.core.seq.call(null,vec__35007);
var first__35009 = cljs.core.first.call(null,seq__35008);
var seq__35008__$1 = cljs.core.next.call(null,seq__35008);
var this$ = first__35009;
var args = seq__35008__$1;
var sig = vec__35007;
var body = seq__35005__$1;
var x__28851__auto__ = cljs.core.vec.call(null,args);
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = cljs.core.list_STAR_.call(null,new cljs.core.Symbol(null,"this-as","this-as",-848995740,null),cljs.core.vary_meta.call(null,this$,cljs.core.assoc,new cljs.core.Keyword(null,"tag","tag",-1290361223),type),body);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
});
cljs.core$macros.adapt_ifn_params = (function cljs$core$macros$adapt_ifn_params(type,p__35010){
var vec__35011 = p__35010;
var seq__35012 = cljs.core.seq.call(null,vec__35011);
var first__35013 = cljs.core.first.call(null,seq__35012);
var seq__35012__$1 = cljs.core.next.call(null,seq__35012);
var vec__35014 = first__35013;
var seq__35015 = cljs.core.seq.call(null,vec__35014);
var first__35016 = cljs.core.first.call(null,seq__35015);
var seq__35015__$1 = cljs.core.next.call(null,seq__35015);
var this$ = first__35016;
var args = seq__35015__$1;
var sig = vec__35014;
var body = seq__35012__$1;
var self_sym = cljs.core.with_meta.call(null,new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),type], null));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.cons.call(null,self_sym,args));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","this-as","cljs.core$macros/this-as",-799075148,null)),(function (){var x__28851__auto__ = self_sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = this$;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = self_sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),body)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
cljs.core$macros.adapt_ifn_invoke_params = (function cljs$core$macros$adapt_ifn_invoke_params(type,p__35017){
var vec__35018 = p__35017;
var seq__35019 = cljs.core.seq.call(null,vec__35018);
var first__35020 = cljs.core.first.call(null,seq__35019);
var seq__35019__$1 = cljs.core.next.call(null,seq__35019);
var vec__35021 = first__35020;
var seq__35022 = cljs.core.seq.call(null,vec__35021);
var first__35023 = cljs.core.first.call(null,seq__35022);
var seq__35022__$1 = cljs.core.next.call(null,seq__35022);
var this$ = first__35023;
var args = seq__35022__$1;
var sig = vec__35021;
var body = seq__35019__$1;
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = cljs.core.vec.call(null,args);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","this-as","cljs.core$macros/this-as",-799075148,null)),(function (){var x__28851__auto__ = cljs.core.vary_meta.call(null,this$,cljs.core.assoc,new cljs.core.Keyword(null,"tag","tag",-1290361223),type);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),body)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
cljs.core$macros.adapt_proto_params = (function cljs$core$macros$adapt_proto_params(type,p__35024){
var vec__35025 = p__35024;
var seq__35026 = cljs.core.seq.call(null,vec__35025);
var first__35027 = cljs.core.first.call(null,seq__35026);
var seq__35026__$1 = cljs.core.next.call(null,seq__35026);
var vec__35028 = first__35027;
var seq__35029 = cljs.core.seq.call(null,vec__35028);
var first__35030 = cljs.core.first.call(null,seq__35029);
var seq__35029__$1 = cljs.core.next.call(null,seq__35029);
var this$ = first__35030;
var args = seq__35029__$1;
var sig = vec__35028;
var body = seq__35026__$1;
var this_SINGLEQUOTE_ = cljs.core.vary_meta.call(null,this$,cljs.core.assoc,new cljs.core.Keyword(null,"tag","tag",-1290361223),type);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.cons.call(null,this_SINGLEQUOTE_,args));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","this-as","cljs.core$macros/this-as",-799075148,null)),(function (){var x__28851__auto__ = this_SINGLEQUOTE_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),body)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
cljs.core$macros.add_obj_methods = (function cljs$core$macros$add_obj_methods(type,type_sym,sigs){
return cljs.core.map.call(null,(function (p__35032){
var vec__35033 = p__35032;
var seq__35034 = cljs.core.seq.call(null,vec__35033);
var first__35035 = cljs.core.first.call(null,seq__35034);
var seq__35034__$1 = cljs.core.next.call(null,seq__35034);
var f = first__35035;
var meths = seq__35034__$1;
var form = vec__35033;
var vec__35036 = ((cljs.core.vector_QMARK_.call(null,cljs.core.first.call(null,meths)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.rest.call(null,form)], null)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,meths], null));
var f__$1 = cljs.core.nth.call(null,vec__35036,(0),null);
var meths__$1 = cljs.core.nth.call(null,vec__35036,(1),null);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__28851__auto__ = cljs.core$macros.extend_prefix.call(null,type_sym,f__$1);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.with_meta.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),cljs.core.map.call(null,((function (vec__35036,f__$1,meths__$1,vec__35033,seq__35034,first__35035,seq__35034__$1,f,meths,form){
return (function (p1__35031_SHARP_){
return cljs.core$macros.adapt_obj_params.call(null,type,p1__35031_SHARP_);
});})(vec__35036,f__$1,meths__$1,vec__35033,seq__35034,first__35035,seq__35034__$1,f,meths,form))
,meths__$1)))),cljs.core.meta.call(null,form));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
}),sigs);
});
cljs.core$macros.ifn_invoke_methods = (function cljs$core$macros$ifn_invoke_methods(type,type_sym,p__35040){
var vec__35041 = p__35040;
var seq__35042 = cljs.core.seq.call(null,vec__35041);
var first__35043 = cljs.core.first.call(null,seq__35042);
var seq__35042__$1 = cljs.core.next.call(null,seq__35042);
var f = first__35043;
var meths = seq__35042__$1;
var form = vec__35041;
return cljs.core.map.call(null,((function (vec__35041,seq__35042,first__35043,seq__35042__$1,f,meths,form){
return (function (meth){
var arity = cljs.core.count.call(null,cljs.core.first.call(null,meth));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__28851__auto__ = cljs.core$macros.extend_prefix.call(null,type_sym,cljs.core.symbol.call(null,["cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join('')));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.with_meta.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__28851__auto__ = meth;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))),cljs.core.meta.call(null,form));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});})(vec__35041,seq__35042,first__35043,seq__35042__$1,f,meths,form))
,cljs.core.map.call(null,((function (vec__35041,seq__35042,first__35043,seq__35042__$1,f,meths,form){
return (function (p1__35039_SHARP_){
return cljs.core$macros.adapt_ifn_invoke_params.call(null,type,p1__35039_SHARP_);
});})(vec__35041,seq__35042,first__35043,seq__35042__$1,f,meths,form))
,meths));
});
cljs.core$macros.add_ifn_methods = (function cljs$core$macros$add_ifn_methods(type,type_sym,p__35045){
var vec__35046 = p__35045;
var seq__35047 = cljs.core.seq.call(null,vec__35046);
var first__35048 = cljs.core.first.call(null,seq__35047);
var seq__35047__$1 = cljs.core.next.call(null,seq__35047);
var f = first__35048;
var meths = seq__35047__$1;
var form = vec__35046;
var meths__$1 = cljs.core.map.call(null,((function (vec__35046,seq__35047,first__35048,seq__35047__$1,f,meths,form){
return (function (p1__35044_SHARP_){
return cljs.core$macros.adapt_ifn_params.call(null,type,p1__35044_SHARP_);
});})(vec__35046,seq__35047,first__35048,seq__35047__$1,f,meths,form))
,meths);
var this_sym = cljs.core.with_meta.call(null,new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),type], null));
var argsym = cljs.core.gensym.call(null,"args");
return cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__28851__auto__ = cljs.core$macros.extend_prefix.call(null,type_sym,new cljs.core.Symbol(null,"call","call",1120531661,null));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.with_meta.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),meths__$1))),cljs.core.meta.call(null,form));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__28851__auto__ = cljs.core$macros.extend_prefix.call(null,type_sym,new cljs.core.Symbol(null,"apply","apply",-1334050276,null));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.with_meta.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__28851__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [this_sym,argsym], null);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","this-as","cljs.core$macros/this-as",-799075148,null)),(function (){var x__28851__auto__ = this_sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".apply",".apply",-1176201338,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-call",".-call",1760541695,null)),(function (){var x__28851__auto__ = this_sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = this_sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".concat",".concat",1180408684,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","array","cljs.core$macros/array",49650437,null)),(function (){var x__28851__auto__ = this_sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","aclone","cljs.core/aclone",-758078968,null)),(function (){var x__28851__auto__ = argsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))),cljs.core.meta.call(null,form));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())))], null),cljs.core$macros.ifn_invoke_methods.call(null,type,type_sym,form));
});
cljs.core$macros.add_proto_methods_STAR_ = (function cljs$core$macros$add_proto_methods_STAR_(pprefix,type,type_sym,p__35049){
var vec__35050 = p__35049;
var seq__35051 = cljs.core.seq.call(null,vec__35050);
var first__35052 = cljs.core.first.call(null,seq__35051);
var seq__35051__$1 = cljs.core.next.call(null,seq__35051);
var f = first__35052;
var meths = seq__35051__$1;
var form = vec__35050;
var pf = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(pprefix),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,f))].join('');
if(cljs.core.vector_QMARK_.call(null,cljs.core.first.call(null,meths))){
var meth = meths;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__28851__auto__ = cljs.core$macros.extend_prefix.call(null,type_sym,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(pf),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,cljs.core.first.call(null,meth)))].join(''));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.with_meta.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),cljs.core$macros.adapt_proto_params.call(null,type,meth)))),cljs.core.meta.call(null,form));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())))], null);
} else {
return cljs.core.map.call(null,((function (pf,vec__35050,seq__35051,first__35052,seq__35051__$1,f,meths,form){
return (function (p__35053){
var vec__35054 = p__35053;
var seq__35055 = cljs.core.seq.call(null,vec__35054);
var first__35056 = cljs.core.first.call(null,seq__35055);
var seq__35055__$1 = cljs.core.next.call(null,seq__35055);
var sig = first__35056;
var body = seq__35055__$1;
var meth = vec__35054;
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__28851__auto__ = cljs.core$macros.extend_prefix.call(null,type_sym,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(pf),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,sig))].join(''));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.with_meta.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__28851__auto__ = cljs.core$macros.adapt_proto_params.call(null,type,meth);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))),cljs.core.meta.call(null,form));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});})(pf,vec__35050,seq__35051,first__35052,seq__35051__$1,f,meths,form))
,meths);
}
});
cljs.core$macros.proto_assign_impls = (function cljs$core$macros$proto_assign_impls(env,resolve,type_sym,type,p__35057){
var vec__35058 = p__35057;
var p = cljs.core.nth.call(null,vec__35058,(0),null);
var sigs = cljs.core.nth.call(null,vec__35058,(1),null);
cljs.core$macros.warn_and_update_protocol.call(null,p,type,env);

var psym = resolve.call(null,p);
var pprefix = cljs.core$macros.protocol_prefix.call(null,psym);
var skip_flag = cljs.core.set.call(null,new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,type_sym)));
if(cljs.core._EQ_.call(null,p,new cljs.core.Symbol(null,"Object","Object",61210754,null))){
return cljs.core$macros.add_obj_methods.call(null,type,type_sym,sigs);
} else {
return cljs.core.concat.call(null,(cljs.core.truth_(skip_flag.call(null,psym))?null:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__28851__auto__ = cljs.core$macros.extend_prefix.call(null,type_sym,pprefix);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","PROTOCOL_SENTINEL","cljs.core/PROTOCOL_SENTINEL",210209696,null)))))], null)),cljs.core.mapcat.call(null,((function (psym,pprefix,skip_flag,vec__35058,p,sigs){
return (function (sig){
if(cljs.core._EQ_.call(null,psym,new cljs.core.Symbol("cljs.core","IFn","cljs.core/IFn",-920223129,null))){
return cljs.core$macros.add_ifn_methods.call(null,type,type_sym,sig);
} else {
return cljs.core$macros.add_proto_methods_STAR_.call(null,pprefix,type,type_sym,sig);
}
});})(psym,pprefix,skip_flag,vec__35058,p,sigs))
,sigs));
}
});
cljs.core$macros.validate_impl_sigs = (function cljs$core$macros$validate_impl_sigs(env,p,method){
if(cljs.core._EQ_.call(null,p,new cljs.core.Symbol(null,"Object","Object",61210754,null))){
return null;
} else {
var var$ = cljs.analyzer.resolve_var.call(null,cljs.core.dissoc.call(null,env,new cljs.core.Keyword(null,"locals","locals",535295783)),p);
var minfo = new cljs.core.Keyword(null,"methods","methods",453930866).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"protocol-info","protocol-info",1471745843).cljs$core$IFn$_invoke$arity$1(var$));
var method_name = cljs.core.first.call(null,method);
var __GT_name = cljs.core.comp.call(null,cljs.core.symbol,cljs.core.name);
var vec__35061 = ((cljs.core.vector_QMARK_.call(null,cljs.core.second.call(null,method)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [__GT_name.call(null,method_name),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.second.call(null,method)], null)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [__GT_name.call(null,method_name),cljs.core.map.call(null,cljs.core.first,cljs.core.rest.call(null,method))], null));
var fname = cljs.core.nth.call(null,vec__35061,(0),null);
var sigs = cljs.core.nth.call(null,vec__35061,(1),null);
var decmeths = cljs.core.get.call(null,minfo,fname,new cljs.core.Keyword("cljs.core$macros","not-found","cljs.core$macros/not-found",-1226326556));
if(cljs.core._EQ_.call(null,decmeths,new cljs.core.Keyword("cljs.core$macros","not-found","cljs.core$macros/not-found",-1226326556))){
cljs.analyzer.warning.call(null,new cljs.core.Keyword(null,"protocol-invalid-method","protocol-invalid-method",522647516),env,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"protocol","protocol",652470118),p,new cljs.core.Keyword(null,"fname","fname",1500291491),fname,new cljs.core.Keyword(null,"no-such-method","no-such-method",1087422840),true], null));
} else {
}

if(cljs.core.truth_(cljs.core.namespace.call(null,method_name))){
var method_var_35064 = cljs.analyzer.resolve_var.call(null,cljs.core.dissoc.call(null,env,new cljs.core.Keyword(null,"locals","locals",535295783)),method_name,cljs.analyzer.confirm_var_exist_warning);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(var$),new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(method_var_35064))){
} else {
cljs.analyzer.warning.call(null,new cljs.core.Keyword(null,"protocol-invalid-method","protocol-invalid-method",522647516),env,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"protocol","protocol",652470118),p,new cljs.core.Keyword(null,"fname","fname",1500291491),method_name,new cljs.core.Keyword(null,"no-such-method","no-such-method",1087422840),true], null));
}
} else {
}

var sigs__$1 = sigs;
var seen = cljs.core.PersistentHashSet.EMPTY;
while(true){
if(cljs.core.seq.call(null,sigs__$1)){
var sig = cljs.core.first.call(null,sigs__$1);
var c = cljs.core.count.call(null,sig);
if(cljs.core.contains_QMARK_.call(null,seen,c)){
cljs.analyzer.warning.call(null,new cljs.core.Keyword(null,"protocol-duped-method","protocol-duped-method",15128166),env,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"protocol","protocol",652470118),p,new cljs.core.Keyword(null,"fname","fname",1500291491),fname], null));
} else {
}

if(cljs.core.truth_(cljs.core.some.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"&","&",-2144855648,null),null], null), null),sig))){
cljs.analyzer.warning.call(null,new cljs.core.Keyword(null,"protocol-impl-with-variadic-method","protocol-impl-with-variadic-method",-319321217),env,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"protocol","protocol",652470118),p,new cljs.core.Keyword(null,"name","name",1843675177),fname], null));
} else {
}

if((cljs.core.not_EQ_.call(null,decmeths,new cljs.core.Keyword("cljs.core$macros","not-found","cljs.core$macros/not-found",-1226326556))) && (cljs.core.not.call(null,cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([c]),cljs.core.map.call(null,cljs.core.count,decmeths))))){
cljs.analyzer.warning.call(null,new cljs.core.Keyword(null,"protocol-invalid-method","protocol-invalid-method",522647516),env,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"protocol","protocol",652470118),p,new cljs.core.Keyword(null,"fname","fname",1500291491),fname,new cljs.core.Keyword(null,"invalid-arity","invalid-arity",1335461949),c], null));
} else {
}

var G__35065 = cljs.core.next.call(null,sigs__$1);
var G__35066 = cljs.core.conj.call(null,seen,c);
sigs__$1 = G__35065;
seen = G__35066;
continue;
} else {
return null;
}
break;
}
}
});
cljs.core$macros.validate_impls = (function cljs$core$macros$validate_impls(env,impls){
var protos = cljs.core.PersistentHashSet.EMPTY;
var impls__$1 = impls;
while(true){
if(cljs.core.seq.call(null,impls__$1)){
var proto = cljs.core.first.call(null,impls__$1);
var methods$ = cljs.core.take_while.call(null,cljs.core.seq_QMARK_,cljs.core.next.call(null,impls__$1));
var impls__$2 = cljs.core.drop_while.call(null,cljs.core.seq_QMARK_,cljs.core.next.call(null,impls__$1));
if(cljs.core.contains_QMARK_.call(null,protos,proto)){
cljs.analyzer.warning.call(null,new cljs.core.Keyword(null,"protocol-multiple-impls","protocol-multiple-impls",794179260),env,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"protocol","protocol",652470118),proto], null));
} else {
}

var seen_35070 = cljs.core.PersistentHashSet.EMPTY;
var methods_35071__$1 = methods$;
while(true){
if(cljs.core.seq.call(null,methods_35071__$1)){
var vec__35067_35072 = cljs.core.first.call(null,methods_35071__$1);
var fname_35073 = cljs.core.nth.call(null,vec__35067_35072,(0),null);
var method_35074 = vec__35067_35072;
if(cljs.core.contains_QMARK_.call(null,seen_35070,fname_35073)){
cljs.analyzer.warning.call(null,new cljs.core.Keyword(null,"extend-type-invalid-method-shape","extend-type-invalid-method-shape",1424103549),env,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"protocol","protocol",652470118),proto,new cljs.core.Keyword(null,"method","method",55703592),fname_35073], null));
} else {
}

cljs.core$macros.validate_impl_sigs.call(null,env,proto,method_35074);

var G__35075 = cljs.core.conj.call(null,seen_35070,fname_35073);
var G__35076 = cljs.core.next.call(null,methods_35071__$1);
seen_35070 = G__35075;
methods_35071__$1 = G__35076;
continue;
} else {
}
break;
}

var G__35077 = cljs.core.conj.call(null,protos,proto);
var G__35078 = impls__$2;
protos = G__35077;
impls__$1 = G__35078;
continue;
} else {
return null;
}
break;
}
});
cljs.core$macros.type_hint_first_arg = (function cljs$core$macros$type_hint_first_arg(type_sym,argv){
return cljs.core.assoc.call(null,argv,(0),cljs.core.vary_meta.call(null,argv.call(null,(0)),cljs.core.assoc,new cljs.core.Keyword(null,"tag","tag",-1290361223),type_sym));
});
cljs.core$macros.type_hint_single_arity_sig = (function cljs$core$macros$type_hint_single_arity_sig(type_sym,sig){
return cljs.core.list_STAR_.call(null,cljs.core.first.call(null,sig),cljs.core$macros.type_hint_first_arg.call(null,type_sym,cljs.core.second.call(null,sig)),cljs.core.nnext.call(null,sig));
});
cljs.core$macros.type_hint_multi_arity_sig = (function cljs$core$macros$type_hint_multi_arity_sig(type_sym,sig){
return cljs.core.list_STAR_.call(null,cljs.core$macros.type_hint_first_arg.call(null,type_sym,cljs.core.first.call(null,sig)),cljs.core.next.call(null,sig));
});
cljs.core$macros.type_hint_multi_arity_sigs = (function cljs$core$macros$type_hint_multi_arity_sigs(type_sym,sigs){
return cljs.core.list_STAR_.call(null,cljs.core.first.call(null,sigs),cljs.core.map.call(null,cljs.core.partial.call(null,cljs.core$macros.type_hint_multi_arity_sig,type_sym),cljs.core.rest.call(null,sigs)));
});
cljs.core$macros.type_hint_sigs = (function cljs$core$macros$type_hint_sigs(type_sym,sig){
if(cljs.core.vector_QMARK_.call(null,cljs.core.second.call(null,sig))){
return cljs.core$macros.type_hint_single_arity_sig.call(null,type_sym,sig);
} else {
return cljs.core$macros.type_hint_multi_arity_sigs.call(null,type_sym,sig);
}
});
cljs.core$macros.type_hint_impl_map = (function cljs$core$macros$type_hint_impl_map(type_sym,impl_map){
return cljs.core.reduce_kv.call(null,(function (m,proto,sigs){
return cljs.core.assoc.call(null,m,proto,cljs.core.map.call(null,cljs.core.partial.call(null,cljs.core$macros.type_hint_sigs,type_sym),sigs));
}),cljs.core.PersistentArrayMap.EMPTY,impl_map);
});
var ret__29198__auto___35087 = (function (){
/**
 * Extend a type to a series of protocols. Useful when you are
 *   supplying the definitions explicitly inline. Propagates the
 *   type as a type hint on the first argument of all fns.
 * 
 *   type-sym may be
 * 
 * * default, meaning the definitions will apply for any value,
 *   unless an extend-type exists for one of the more specific
 *   cases below.
 * * nil, meaning the definitions will apply for the nil value.
 * * any of object, boolean, number, string, array, or function,
 *   indicating the definitions will apply for values of the
 *   associated base JavaScript types. Note that, for example,
 *   string should be used instead of js/String.
 * * a JavaScript type not covered by the previous list, such
 *   as js/RegExp.
 * * a type defined by deftype or defrecord.
 * 
 *   (extend-type MyType
 *  ICounted
 *  (-count [c] ...)
 *  Foo
 *  (bar [x y] ...)
 *  (baz ([x] ...) ([x y] ...) ...)
 */
cljs.core$macros.extend_type = (function cljs$core$macros$extend_type(var_args){
var args__29165__auto__ = [];
var len__29158__auto___35088 = arguments.length;
var i__29159__auto___35089 = (0);
while(true){
if((i__29159__auto___35089 < len__29158__auto___35088)){
args__29165__auto__.push((arguments[i__29159__auto___35089]));

var G__35090 = (i__29159__auto___35089 + (1));
i__29159__auto___35089 = G__35090;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((3) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.extend_type.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29166__auto__);
});

cljs.core$macros.extend_type.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,type_sym,impls){
var env = _AMPERSAND_env;
var _ = cljs.core$macros.validate_impls.call(null,env,impls);
var resolve = cljs.core.partial.call(null,cljs.core$macros.resolve_var,env);
var impl_map = cljs.core$macros.__GT_impl_map.call(null,impls);
var impl_map__$1 = (cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null,new cljs.core.Symbol(null,"number","number",-1084057331,null),null], null), null).call(null,type_sym))?cljs.core$macros.type_hint_impl_map.call(null,type_sym,impl_map):impl_map);
var vec__35084 = (function (){var temp__4655__auto__ = cljs.core$macros.base_type.call(null,type_sym);
if(cljs.core.truth_(temp__4655__auto__)){
var type = temp__4655__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [type,cljs.core$macros.base_assign_impls], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [resolve.call(null,type_sym),cljs.core$macros.proto_assign_impls], null);
}
})();
var type = cljs.core.nth.call(null,vec__35084,(0),null);
var assign_impls = cljs.core.nth.call(null,vec__35084,(1),null);
if(cljs.core.truth_((function (){var and__27977__auto__ = new cljs.core.Keyword(null,"extending-base-js-type","extending-base-js-type",432787264).cljs$core$IFn$_invoke$arity$1(cljs.analyzer._STAR_cljs_warnings_STAR_);
if(cljs.core.truth_(and__27977__auto__)){
return cljs.core$macros.js_base_type.call(null,type_sym);
} else {
return and__27977__auto__;
}
})())){
cljs.analyzer.warning.call(null,new cljs.core.Keyword(null,"extending-base-js-type","extending-base-js-type",432787264),env,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"current-symbol","current-symbol",-932381075),type_sym,new cljs.core.Keyword(null,"suggested-symbol","suggested-symbol",-1329631875),cljs.core$macros.js_base_type.call(null,type_sym)], null));
} else {
}

return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),cljs.core.mapcat.call(null,((function (env,_,resolve,impl_map,impl_map__$1,vec__35084,type,assign_impls){
return (function (p1__35079_SHARP_){
return assign_impls.call(null,env,resolve,type_sym,type,p1__35079_SHARP_);
});})(env,_,resolve,impl_map,impl_map__$1,vec__35084,type,assign_impls))
,impl_map__$1))));
});

cljs.core$macros.extend_type.cljs$lang$maxFixedArity = (3);

cljs.core$macros.extend_type.cljs$lang$applyTo = (function (seq35080){
var G__35081 = cljs.core.first.call(null,seq35080);
var seq35080__$1 = cljs.core.next.call(null,seq35080);
var G__35082 = cljs.core.first.call(null,seq35080__$1);
var seq35080__$2 = cljs.core.next.call(null,seq35080__$1);
var G__35083 = cljs.core.first.call(null,seq35080__$2);
var seq35080__$3 = cljs.core.next.call(null,seq35080__$2);
return cljs.core$macros.extend_type.cljs$core$IFn$_invoke$arity$variadic(G__35081,G__35082,G__35083,seq35080__$3);
});

return null;
})()
;
cljs.core$macros.extend_type.cljs$lang$macro = true;

cljs.core$macros.prepare_protocol_masks = (function cljs$core$macros$prepare_protocol_masks(env,impls){
var resolve = cljs.core.partial.call(null,cljs.core$macros.resolve_var,env);
var impl_map = cljs.core$macros.__GT_impl_map.call(null,impls);
var fpp_pbs = cljs.core.seq.call(null,cljs.core.keep.call(null,cljs.core$macros.fast_path_protocols,cljs.core.map.call(null,resolve,cljs.core.keys.call(null,impl_map))));
if(fpp_pbs){
var fpps = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.filter.call(null,cljs.core.partial.call(null,cljs.core.contains_QMARK_,cljs.core$macros.fast_path_protocols),cljs.core.map.call(null,resolve,cljs.core.keys.call(null,impl_map))));
var parts = (function (){var parts = cljs.core.group_by.call(null,cljs.core.first,fpp_pbs);
var parts__$1 = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,cljs.core.juxt.call(null,cljs.core.key,cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,cljs.core.peek),cljs.core.val)),parts));
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,cljs.core.juxt.call(null,cljs.core.key,cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.reduce,cljs.core.bit_or),cljs.core.val)),parts__$1));
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fpps,cljs.core.reduce.call(null,((function (fpps,parts,resolve,impl_map,fpp_pbs){
return (function (ps,p){
return cljs.core.update_in.call(null,ps,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p], null),cljs.core.fnil.call(null,cljs.core.identity,(0)));
});})(fpps,parts,resolve,impl_map,fpp_pbs))
,parts,cljs.core.range.call(null,cljs.core$macros.fast_path_protocol_partitions_count))], null);
} else {
return null;
}
});
cljs.core$macros.annotate_specs = (function cljs$core$macros$annotate_specs(annots,v,p__35092){
var vec__35093 = p__35092;
var f = cljs.core.nth.call(null,vec__35093,(0),null);
var sigs = cljs.core.nth.call(null,vec__35093,(1),null);
return cljs.core.conj.call(null,v,cljs.core.vary_meta.call(null,cljs.core.cons.call(null,f,cljs.core.map.call(null,((function (vec__35093,f,sigs){
return (function (p1__35091_SHARP_){
return cljs.core.cons.call(null,cljs.core.second.call(null,p1__35091_SHARP_),cljs.core.nnext.call(null,p1__35091_SHARP_));
});})(vec__35093,f,sigs))
,sigs)),cljs.core.merge,annots));
});
cljs.core$macros.dt__GT_et = (function cljs$core$macros$dt__GT_et(var_args){
var G__35097 = arguments.length;
switch (G__35097) {
case 3:
return cljs.core$macros.dt__GT_et.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core$macros.dt__GT_et.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core$macros.dt__GT_et.cljs$core$IFn$_invoke$arity$3 = (function (type,specs,fields){
return cljs.core$macros.dt__GT_et.call(null,type,specs,fields,false);
});

cljs.core$macros.dt__GT_et.cljs$core$IFn$_invoke$arity$4 = (function (type,specs,fields,inline){
var annots = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("cljs.analyzer","type","cljs.analyzer/type",478749742),type,new cljs.core.Keyword("cljs.analyzer","protocol-impl","cljs.analyzer/protocol-impl",-1523935409),true,new cljs.core.Keyword("cljs.analyzer","protocol-inline","cljs.analyzer/protocol-inline",-1611519026),inline], null);
var ret = cljs.core.PersistentVector.EMPTY;
var specs__$1 = specs;
while(true){
if(cljs.core.seq.call(null,specs__$1)){
var p = cljs.core.first.call(null,specs__$1);
var ret__$1 = cljs.core.into.call(null,cljs.core.conj.call(null,ret,p),cljs.core.reduce.call(null,cljs.core.partial.call(null,cljs.core$macros.annotate_specs,annots),cljs.core.PersistentVector.EMPTY,cljs.core.group_by.call(null,cljs.core.first,cljs.core.take_while.call(null,cljs.core.seq_QMARK_,cljs.core.next.call(null,specs__$1)))));
var specs__$2 = cljs.core.drop_while.call(null,cljs.core.seq_QMARK_,cljs.core.next.call(null,specs__$1));
var G__35099 = ret__$1;
var G__35100 = specs__$2;
ret = G__35099;
specs__$1 = G__35100;
continue;
} else {
return ret;
}
break;
}
});

cljs.core$macros.dt__GT_et.cljs$lang$maxFixedArity = 4;

cljs.core$macros.collect_protocols = (function cljs$core$macros$collect_protocols(impls,env){
return cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,(function (p1__35101_SHARP_){
return new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.call(null,cljs.core.dissoc.call(null,env,new cljs.core.Keyword(null,"locals","locals",535295783)),p1__35101_SHARP_));
}),cljs.core.filter.call(null,cljs.core.symbol_QMARK_,impls)));
});
cljs.core$macros.build_positional_factory = (function cljs$core$macros$build_positional_factory(rsym,rname,fields){
var fn_name = cljs.core.with_meta.call(null,cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"->","->",-2139605430,null)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(rsym)].join('')),cljs.core.assoc.call(null,cljs.core.meta.call(null,rsym),new cljs.core.Keyword(null,"factory","factory",63933746),new cljs.core.Keyword(null,"positional","positional",-203580463)));
var field_values = (cljs.core.truth_(new cljs.core.Keyword(null,"internal-ctor","internal-ctor",937392560).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,rsym)))?cljs.core.conj.call(null,fields,null,null,null):fields);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","defn","cljs.core$macros/defn",-728332354,null)),(function (){var x__28851__auto__ = fn_name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,fields))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"new","new",-444906321,null)),(function (){var x__28851__auto__ = rname;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),field_values)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
cljs.core$macros.validate_fields = (function cljs$core$macros$validate_fields(case$,name,fields){
if(cljs.core.vector_QMARK_.call(null,fields)){
return null;
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1(case$)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),", no fields vector given."].join('')));
}
});
var ret__29198__auto___35113 = (function (){
/**
 * (deftype name [fields*]  options* specs*)
 * 
 *   Currently there are no options.
 * 
 *   Each spec consists of a protocol or interface name followed by zero
 *   or more method bodies:
 * 
 *   protocol-or-Object
 *   (methodName [args*] body)*
 * 
 *   The type will have the (by default, immutable) fields named by
 *   fields, which can have type hints. Protocols and methods
 *   are optional. The only methods that can be supplied are those
 *   declared in the protocols/interfaces.  Note that method bodies are
 *   not closures, the local environment includes only the named fields,
 *   and those fields can be accessed directly. Fields can be qualified
 *   with the metadata :mutable true at which point (set! afield aval) will be
 *   supported in method bodies. Note well that mutable fields are extremely
 *   difficult to use correctly, and are present only to facilitate the building
 *   of higherlevel constructs, such as ClojureScript's reference types, in
 *   ClojureScript itself. They are for experts only - if the semantics and
 *   implications of :mutable are not immediately apparent to you, you should not
 *   be using them.
 * 
 *   Method definitions take the form:
 * 
 *   (methodname [args*] body)
 * 
 *   The argument and return types can be hinted on the arg and
 *   methodname symbols. If not supplied, they will be inferred, so type
 *   hints should be reserved for disambiguation.
 * 
 *   Methods should be supplied for all methods of the desired
 *   protocol(s). You can also define overrides for methods of Object. Note that
 *   a parameter must be supplied to correspond to the target object
 *   ('this' in JavaScript parlance). Note also that recur calls to the method
 *   head should *not* pass the target object, it will be supplied
 *   automatically and can not be substituted.
 * 
 *   In the method bodies, the (unqualified) name can be used to name the
 *   class (for calls to new, instance? etc).
 * 
 *   One constructor will be defined, taking the designated fields.  Note
 *   that the field names __meta and __extmap are currently reserved and
 *   should not be used when defining your own types.
 * 
 *   Given (deftype TypeName ...), a factory function called ->TypeName
 *   will be defined, taking positional parameters for the fields
 */
cljs.core$macros.deftype = (function cljs$core$macros$deftype(var_args){
var args__29165__auto__ = [];
var len__29158__auto___35114 = arguments.length;
var i__29159__auto___35115 = (0);
while(true){
if((i__29159__auto___35115 < len__29158__auto___35114)){
args__29165__auto__.push((arguments[i__29159__auto___35115]));

var G__35116 = (i__29159__auto___35115 + (1));
i__29159__auto___35115 = G__35116;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((4) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((4)),(0),null)):null);
return cljs.core$macros.deftype.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__29166__auto__);
});

cljs.core$macros.deftype.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,t,fields,impls){
cljs.core$macros.validate_fields.call(null,"deftype",t,fields);

var env = _AMPERSAND_env;
var r = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.call(null,cljs.core.dissoc.call(null,env,new cljs.core.Keyword(null,"locals","locals",535295783)),t));
var vec__35110 = cljs.core$macros.prepare_protocol_masks.call(null,env,impls);
var fpps = cljs.core.nth.call(null,vec__35110,(0),null);
var pmasks = cljs.core.nth.call(null,vec__35110,(1),null);
var protocols = cljs.core$macros.collect_protocols.call(null,impls,env);
var t__$1 = cljs.core.vary_meta.call(null,t,cljs.core.assoc,new cljs.core.Keyword(null,"protocols","protocols",-5615896),protocols,new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630),fpps);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"deftype*","deftype*",962659890,null)),(function (){var x__28851__auto__ = t__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = fields;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = pmasks;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = ((cljs.core.seq.call(null,impls))?cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","extend-type","cljs.core$macros/extend-type",1713295201,null)),(function (){var x__28851__auto__ = t__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core$macros.dt__GT_et.call(null,t__$1,impls,fields)))):null);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-getBasis",".-getBasis",-1306451468,null)),(function (){var x__28851__auto__ = t__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"quote","quote",1377916282,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,fields))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-cljs$lang$type",".-cljs$lang$type",-1029307724,null)),(function (){var x__28851__auto__ = t__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,true))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-cljs$lang$ctorStr",".-cljs$lang$ctorStr",-1820706991,null)),(function (){var x__28851__auto__ = t__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(r)].join('');
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-cljs$lang$ctorPrWriter",".-cljs$lang$ctorPrWriter",255834464,null)),(function (){var x__28851__auto__ = t__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__35102__auto__","this__35102__auto__",986490210,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"writer__35103__auto__","writer__35103__auto__",384993508,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"opt__35104__auto__","opt__35104__auto__",-190627899,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-write","cljs.core/-write",527220517,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"writer__35103__auto__","writer__35103__auto__",384993508,null)),(function (){var x__28851__auto__ = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(r)].join('');
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core$macros.build_positional_factory.call(null,t__$1,r,fields);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = t__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.deftype.cljs$lang$maxFixedArity = (4);

cljs.core$macros.deftype.cljs$lang$applyTo = (function (seq35105){
var G__35106 = cljs.core.first.call(null,seq35105);
var seq35105__$1 = cljs.core.next.call(null,seq35105);
var G__35107 = cljs.core.first.call(null,seq35105__$1);
var seq35105__$2 = cljs.core.next.call(null,seq35105__$1);
var G__35108 = cljs.core.first.call(null,seq35105__$2);
var seq35105__$3 = cljs.core.next.call(null,seq35105__$2);
var G__35109 = cljs.core.first.call(null,seq35105__$3);
var seq35105__$4 = cljs.core.next.call(null,seq35105__$3);
return cljs.core$macros.deftype.cljs$core$IFn$_invoke$arity$variadic(G__35106,G__35107,G__35108,G__35109,seq35105__$4);
});

return null;
})()
;
cljs.core$macros.deftype.cljs$lang$macro = true;

/**
 * Do not use this directly - use defrecord
 */
cljs.core$macros.emit_defrecord = (function cljs$core$macros$emit_defrecord(env,tagname,rname,fields,impls){
var hinted_fields = fields;
var fields__$1 = cljs.core.vec.call(null,cljs.core.map.call(null,((function (hinted_fields){
return (function (p1__35117_SHARP_){
return cljs.core.with_meta.call(null,p1__35117_SHARP_,null);
});})(hinted_fields))
,fields));
var base_fields = fields__$1;
var pr_open = ["#",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.namespace.call(null,rname)),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,rname)),"{"].join('');
var fields__$2 = cljs.core.conj.call(null,fields__$1,new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),cljs.core.with_meta.call(null,new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)));
var gs = cljs.core.gensym.call(null);
var ksym = cljs.core.gensym.call(null,"k");
var impls__$1 = cljs.core.concat.call(null,impls,new cljs.core.PersistentVector(null, 28, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"IRecord","IRecord",-903221169,null),new cljs.core.Symbol(null,"ICloneable","ICloneable",1882653160,null),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-clone","-clone",227130084,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__35118__auto__","this__35118__auto__",416463276,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"new","new",-444906321,null)),(function (){var x__28851__auto__ = tagname;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),fields__$2)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))),new cljs.core.Symbol(null,"IHash","IHash",-1495374645,null),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-hash","-hash",-630070274,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__35119__auto__","this__35119__auto__",-1875602665,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","caching-hash","cljs.core$macros/caching-hash",-1892393069,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__35119__auto__","this__35119__auto__",-1875602665,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"coll__35120__auto__","coll__35120__auto__",-1951466210,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","bit-xor","cljs.core$macros/bit-xor",1284619191,null)),(function (){var x__28851__auto__ = cljs.core.hash.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,rname))].join(''));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","hash-unordered-coll","cljs.core/hash-unordered-coll",-639086053,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"coll__35120__auto__","coll__35120__auto__",-1951466210,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))),new cljs.core.Symbol(null,"IEquiv","IEquiv",-1912850869,null),(function (){var this$ = cljs.core.gensym.call(null,new cljs.core.Symbol(null,"this","this",1028897902,null));
var other = cljs.core.gensym.call(null,new cljs.core.Symbol(null,"other","other",-1658642225,null));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-equiv","-equiv",320124272,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = this$;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = other;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","and","cljs.core$macros/and",48320334,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","some?","cljs.core$macros/some?",-253244523,null)),(function (){var x__28851__auto__ = other;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","identical?","cljs.core$macros/identical?",815580547,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-constructor",".-constructor",279801701,null)),(function (){var x__28851__auto__ = this$;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-constructor",".-constructor",279801701,null)),(function (){var x__28851__auto__ = other;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core.map.call(null,((function (this$,other,gs,ksym,hinted_fields,fields__$1,base_fields,pr_open,fields__$2){
return (function (field){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","=","cljs.core/=",-1891498332,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"..","..",-300507420,null)),(function (){var x__28851__auto__ = this$;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core$macros.to_property.call(null,field);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"..","..",-300507420,null)),(function (){var x__28851__auto__ = other;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core$macros.to_property.call(null,field);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});})(this$,other,gs,ksym,hinted_fields,fields__$1,base_fields,pr_open,fields__$2))
,base_fields),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","=","cljs.core/=",-1891498332,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-__extmap",".-__extmap",438409624,null)),(function (){var x__28851__auto__ = this$;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-__extmap",".-__extmap",438409624,null)),(function (){var x__28851__auto__ = other;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
})(),new cljs.core.Symbol(null,"IMeta","IMeta",1095313672,null),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-meta","-meta",494863156,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__35121__auto__","this__35121__auto__",498081,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"__meta","__meta",-946752628,null))))),new cljs.core.Symbol(null,"IWithMeta","IWithMeta",-509493158,null),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-with-meta","-with-meta",-1610713823,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__35122__auto__","this__35122__auto__",-796143175,null)),(function (){var x__28851__auto__ = gs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"new","new",-444906321,null)),(function (){var x__28851__auto__ = tagname;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core.replace.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),gs], null),fields__$2))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))),new cljs.core.Symbol(null,"ILookup","ILookup",784647298,null),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-lookup","-lookup",-1438393944,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__35123__auto__","this__35123__auto__",-419675413,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"k__35124__auto__","k__35124__auto__",1586648975,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-lookup","cljs.core/-lookup",-1845674443,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__35123__auto__","this__35123__auto__",-419675413,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"k__35124__auto__","k__35124__auto__",1586648975,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-lookup","-lookup",-1438393944,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__35125__auto__","this__35125__auto__",350927279,null)),(function (){var x__28851__auto__ = ksym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"else__35126__auto__","else__35126__auto__",-2043043780,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","case","cljs.core$macros/case",-2131866965,null)),(function (){var x__28851__auto__ = ksym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core.mapcat.call(null,((function (gs,ksym,hinted_fields,fields__$1,base_fields,pr_open,fields__$2){
return (function (f){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,f),f], null);
});})(gs,ksym,hinted_fields,fields__$1,base_fields,pr_open,fields__$2))
,base_fields),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","get","cljs.core/get",-296075407,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null)),(function (){var x__28851__auto__ = ksym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"else__35126__auto__","else__35126__auto__",-2043043780,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))),new cljs.core.Symbol(null,"ICounted","ICounted",-1705786327,null),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-count","-count",416049189,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__35127__auto__","this__35127__auto__",-933544943,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","+","cljs.core$macros/+",-18260342,null)),(function (){var x__28851__auto__ = cljs.core.count.call(null,base_fields);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))),new cljs.core.Symbol(null,"ICollection","ICollection",-686709190,null),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-conj","-conj",1373798691,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__35128__auto__","this__35128__auto__",703095408,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"entry__35129__auto__","entry__35129__auto__",-2000393046,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","vector?","cljs.core/vector?",-1550392028,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"entry__35129__auto__","entry__35129__auto__",-2000393046,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-assoc","cljs.core/-assoc",-814539323,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__35128__auto__","this__35128__auto__",703095408,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-nth","cljs.core/-nth",504234802,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"entry__35129__auto__","entry__35129__auto__",-2000393046,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-nth","cljs.core/-nth",504234802,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"entry__35129__auto__","entry__35129__auto__",-2000393046,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,(1)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","reduce","cljs.core/reduce",2025430439,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-conj","cljs.core/-conj",2040622670,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__35128__auto__","this__35128__auto__",703095408,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"entry__35129__auto__","entry__35129__auto__",-2000393046,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))),new cljs.core.Symbol(null,"IAssociative","IAssociative",-1306431882,null),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-assoc","-assoc",-416089758,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__35130__auto__","this__35130__auto__",618075720,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"k__35131__auto__","k__35131__auto__",-975321709,null)),(function (){var x__28851__auto__ = gs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","condp","cljs.core$macros/condp",431619047,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","keyword-identical?","cljs.core/keyword-identical?",1598491177,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"k__35131__auto__","k__35131__auto__",-975321709,null)),cljs.core.mapcat.call(null,((function (gs,ksym,hinted_fields,fields__$1,base_fields,pr_open,fields__$2){
return (function (fld){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,fld),cljs.core.list_STAR_.call(null,new cljs.core.Symbol(null,"new","new",-444906321,null),tagname,cljs.core.replace.call(null,cljs.core.PersistentArrayMap.createAsIfByAssoc([fld,gs,new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),null]),fields__$2))], null);
});})(gs,ksym,hinted_fields,fields__$1,base_fields,pr_open,fields__$2))
,base_fields),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"new","new",-444906321,null)),(function (){var x__28851__auto__ = tagname;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core.remove.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),null,new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),null], null), null),fields__$2),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","assoc","cljs.core/assoc",322326297,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"k__35131__auto__","k__35131__auto__",-975321709,null)),(function (){var x__28851__auto__ = gs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))),new cljs.core.Symbol(null,"IMap","IMap",992876629,null),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-dissoc","-dissoc",1638079447,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__35132__auto__","this__35132__auto__",1727234643,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"k__35133__auto__","k__35133__auto__",-1593739730,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","contains?","cljs.core/contains?",-976526835,null)),(function (){var x__28851__auto__ = cljs.core.apply.call(null,cljs.core.hash_set,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core.map.call(null,cljs.core.keyword,base_fields)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"k__35133__auto__","k__35133__auto__",-1593739730,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","dissoc","cljs.core/dissoc",-432349815,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-with-meta","cljs.core/-with-meta",-146937782,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","into","cljs.core/into",1879938733,null)),(function (){var x__28851__auto__ = cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__35132__auto__","this__35132__auto__",1727234643,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"__meta","__meta",-946752628,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"k__35133__auto__","k__35133__auto__",-1593739730,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"new","new",-444906321,null)),(function (){var x__28851__auto__ = tagname;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core.remove.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),null,new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),null], null), null),fields__$2),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","not-empty","cljs.core/not-empty",540057011,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","dissoc","cljs.core/dissoc",-432349815,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"k__35133__auto__","k__35133__auto__",-1593739730,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))),new cljs.core.Symbol(null,"ISeqable","ISeqable",1349682102,null),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-seq","-seq",1019896831,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__35135__auto__","this__35135__auto__",-2025971208,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","seq","cljs.core/seq",-1649497689,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","concat","cljs.core/concat",-1133584918,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core.map.call(null,((function (gs,ksym,hinted_fields,fields__$1,base_fields,pr_open,fields__$2){
return (function (p1__35134_SHARP_){
return cljs.core._conj.call(null,(function (){var x__28851__auto__ = cljs.core.keyword.call(null,p1__35134_SHARP_);
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = p1__35134_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),new cljs.core.Symbol("cljs.core$macros","vector","cljs.core$macros/vector",912237829,null));
});})(gs,ksym,hinted_fields,fields__$1,base_fields,pr_open,fields__$2))
,base_fields)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))),new cljs.core.Symbol(null,"IIterable","IIterable",577191430,null),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-iterator","-iterator",310937281,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = gs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"RecordIter.","RecordIter.",-265283060,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0)),(function (){var x__28851__auto__ = gs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.count.call(null,base_fields);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core.map.call(null,cljs.core.keyword,base_fields)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-iterator","cljs.core/-iterator",1833427494,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","nil-iter","cljs.core/nil-iter",-1712403690,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))),new cljs.core.Symbol(null,"IPrintWithWriter","IPrintWithWriter",-1205316154,null),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-pr-writer","-pr-writer",-445354136,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__35137__auto__","this__35137__auto__",-1752950419,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"writer__35138__auto__","writer__35138__auto__",4662730,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"opts__35139__auto__","opts__35139__auto__",779470646,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"pr-pair__35140__auto__","pr-pair__35140__auto__",1668551838,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"keyval__35141__auto__","keyval__35141__auto__",-981658442,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","pr-sequential-writer","cljs.core/pr-sequential-writer",-1101677821,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"writer__35138__auto__","writer__35138__auto__",4662730,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","pr-writer","cljs.core/pr-writer",133956070,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,""),cljs.core._conj.call(null,cljs.core.List.EMPTY," "),cljs.core._conj.call(null,cljs.core.List.EMPTY,""),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"opts__35139__auto__","opts__35139__auto__",779470646,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"keyval__35141__auto__","keyval__35141__auto__",-981658442,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","pr-sequential-writer","cljs.core/pr-sequential-writer",-1101677821,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"writer__35138__auto__","writer__35138__auto__",4662730,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"pr-pair__35140__auto__","pr-pair__35140__auto__",1668551838,null)),(function (){var x__28851__auto__ = pr_open;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,", "),cljs.core._conj.call(null,cljs.core.List.EMPTY,"}"),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"opts__35139__auto__","opts__35139__auto__",779470646,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","concat","cljs.core/concat",-1133584918,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core.map.call(null,((function (gs,ksym,hinted_fields,fields__$1,base_fields,pr_open,fields__$2){
return (function (p1__35136_SHARP_){
return cljs.core._conj.call(null,(function (){var x__28851__auto__ = cljs.core.keyword.call(null,p1__35136_SHARP_);
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = p1__35136_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),new cljs.core.Symbol("cljs.core$macros","vector","cljs.core$macros/vector",912237829,null));
});})(gs,ksym,hinted_fields,fields__$1,base_fields,pr_open,fields__$2))
,base_fields)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())))], null));
var vec__35142 = cljs.core$macros.prepare_protocol_masks.call(null,env,impls__$1);
var fpps = cljs.core.nth.call(null,vec__35142,(0),null);
var pmasks = cljs.core.nth.call(null,vec__35142,(1),null);
var protocols = cljs.core$macros.collect_protocols.call(null,impls__$1,env);
var tagname__$1 = cljs.core.vary_meta.call(null,tagname,cljs.core.assoc,new cljs.core.Keyword(null,"protocols","protocols",-5615896),protocols,new cljs.core.Keyword(null,"skip-protocol-flag","skip-protocol-flag",-1426798630),fpps);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"defrecord*","defrecord*",-1936366207,null)),(function (){var x__28851__auto__ = tagname__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = hinted_fields;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = pmasks;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","extend-type","cljs.core$macros/extend-type",1713295201,null)),(function (){var x__28851__auto__ = tagname__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core$macros.dt__GT_et.call(null,tagname__$1,impls__$1,fields__$2,true))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
cljs.core$macros.build_map_factory = (function cljs$core$macros$build_map_factory(rsym,rname,fields){
var fn_name = cljs.core.with_meta.call(null,cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"map->","map->",-999714600,null)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(rsym)].join('')),cljs.core.assoc.call(null,cljs.core.meta.call(null,rsym),new cljs.core.Keyword(null,"factory","factory",63933746),new cljs.core.Keyword(null,"map","map",1371690461)));
var ms = cljs.core.gensym.call(null);
var ks = cljs.core.map.call(null,cljs.core.keyword,fields);
var getters = cljs.core.map.call(null,((function (fn_name,ms,ks){
return (function (k){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = k;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = ms;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});})(fn_name,ms,ks))
,ks);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","defn","cljs.core$macros/defn",-728332354,null)),(function (){var x__28851__auto__ = fn_name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = ms;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"new","new",-444906321,null)),(function (){var x__28851__auto__ = rname;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),getters,cljs.core._conj.call(null,cljs.core.List.EMPTY,null),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","not-empty","cljs.core/not-empty",540057011,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","dissoc","cljs.core/dissoc",-432349815,null)),(function (){var x__28851__auto__ = ms;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),ks)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
var ret__29198__auto___35152 = (function (){
/**
 * (defrecord name [fields*]  options* specs*)
 * 
 *   Currently there are no options.
 * 
 *   Each spec consists of a protocol or interface name followed by zero
 *   or more method bodies:
 * 
 *   protocol-or-Object
 *   (methodName [args*] body)*
 * 
 *   The record will have the (immutable) fields named by
 *   fields, which can have type hints. Protocols and methods
 *   are optional. The only methods that can be supplied are those
 *   declared in the protocols.  Note that method bodies are
 *   not closures, the local environment includes only the named fields,
 *   and those fields can be accessed directly.
 * 
 *   Method definitions take the form:
 * 
 *   (methodname [args*] body)
 * 
 *   The argument and return types can be hinted on the arg and
 *   methodname symbols. If not supplied, they will be inferred, so type
 *   hints should be reserved for disambiguation.
 * 
 *   Methods should be supplied for all methods of the desired
 *   protocol(s). You can also define overrides for
 *   methods of Object. Note that a parameter must be supplied to
 *   correspond to the target object ('this' in JavaScript parlance). Note also
 *   that recur calls to the method head should *not* pass the target object, it
 *   will be supplied automatically and can not be substituted.
 * 
 *   In the method bodies, the (unqualified) name can be used to name the
 *   class (for calls to new, instance? etc).
 * 
 *   The type will have implementations of several ClojureScript
 *   protocol generated automatically: IMeta/IWithMeta (metadata support) and
 *   IMap, etc.
 * 
 *   In addition, defrecord will define type-and-value-based =,
 *   and will define ClojureScript IHash and IEquiv.
 * 
 *   Two constructors will be defined, one taking the designated fields
 *   followed by a metadata map (nil for none) and an extension field
 *   map (nil for none), and one taking only the fields (using nil for
 *   meta and extension fields). Note that the field names __meta
 *   and __extmap are currently reserved and should not be used when
 *   defining your own records.
 * 
 *   Given (defrecord TypeName ...), two factory functions will be
 *   defined: ->TypeName, taking positional parameters for the fields,
 *   and map->TypeName, taking a map of keywords to field values.
 */
cljs.core$macros.defrecord = (function cljs$core$macros$defrecord(var_args){
var args__29165__auto__ = [];
var len__29158__auto___35153 = arguments.length;
var i__29159__auto___35154 = (0);
while(true){
if((i__29159__auto___35154 < len__29158__auto___35153)){
args__29165__auto__.push((arguments[i__29159__auto___35154]));

var G__35155 = (i__29159__auto___35154 + (1));
i__29159__auto___35154 = G__35155;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((4) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((4)),(0),null)):null);
return cljs.core$macros.defrecord.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__29166__auto__);
});

cljs.core$macros.defrecord.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,rsym,fields,impls){
cljs.core$macros.validate_fields.call(null,"defrecord",rsym,fields);

var rsym__$1 = cljs.core.vary_meta.call(null,rsym,cljs.core.assoc,new cljs.core.Keyword(null,"internal-ctor","internal-ctor",937392560),true);
var r = cljs.core.vary_meta.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.call(null,cljs.core.dissoc.call(null,_AMPERSAND_env,new cljs.core.Keyword(null,"locals","locals",535295783)),rsym__$1)),cljs.core.assoc,new cljs.core.Keyword(null,"internal-ctor","internal-ctor",937392560),true);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core$macros.emit_defrecord.call(null,_AMPERSAND_env,rsym__$1,r,fields,impls);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-getBasis",".-getBasis",-1306451468,null)),(function (){var x__28851__auto__ = r;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"quote","quote",1377916282,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,fields))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-cljs$lang$type",".-cljs$lang$type",-1029307724,null)),(function (){var x__28851__auto__ = r;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,true))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-cljs$lang$ctorPrSeq",".-cljs$lang$ctorPrSeq",41132414,null)),(function (){var x__28851__auto__ = r;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__35145__auto__","this__35145__auto__",1225514749,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","list","cljs.core/list",-1331406371,null)),(function (){var x__28851__auto__ = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(r)].join('');
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-cljs$lang$ctorPrWriter",".-cljs$lang$ctorPrWriter",255834464,null)),(function (){var x__28851__auto__ = r;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__35145__auto__","this__35145__auto__",1225514749,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"writer__35146__auto__","writer__35146__auto__",-662698687,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-write","cljs.core/-write",527220517,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"writer__35146__auto__","writer__35146__auto__",-662698687,null)),(function (){var x__28851__auto__ = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(r)].join('');
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core$macros.build_positional_factory.call(null,rsym__$1,r,fields);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core$macros.build_map_factory.call(null,rsym__$1,r,fields);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = r;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.defrecord.cljs$lang$maxFixedArity = (4);

cljs.core$macros.defrecord.cljs$lang$applyTo = (function (seq35147){
var G__35148 = cljs.core.first.call(null,seq35147);
var seq35147__$1 = cljs.core.next.call(null,seq35147);
var G__35149 = cljs.core.first.call(null,seq35147__$1);
var seq35147__$2 = cljs.core.next.call(null,seq35147__$1);
var G__35150 = cljs.core.first.call(null,seq35147__$2);
var seq35147__$3 = cljs.core.next.call(null,seq35147__$2);
var G__35151 = cljs.core.first.call(null,seq35147__$3);
var seq35147__$4 = cljs.core.next.call(null,seq35147__$3);
return cljs.core$macros.defrecord.cljs$core$IFn$_invoke$arity$variadic(G__35148,G__35149,G__35150,G__35151,seq35147__$4);
});

return null;
})()
;
cljs.core$macros.defrecord.cljs$lang$macro = true;

var ret__29198__auto___35183 = (function (){
/**
 * A protocol is a named set of named methods and their signatures:
 * 
 *   (defprotocol AProtocolName
 *  ;optional doc string
 *  "A doc string for AProtocol abstraction"
 * 
 *   ;method signatures
 *  (bar [this a b] "bar docs")
 *  (baz [this a] [this a b] [this a b c] "baz docs"))
 * 
 *   No implementations are provided. Docs can be specified for the
 *   protocol overall and for each method. The above yields a set of
 *   polymorphic functions and a protocol object. All are
 *   namespace-qualified by the ns enclosing the definition The resulting
 *   functions dispatch on the type of their first argument, which is
 *   required and corresponds to the implicit target object ('this' in
 *   JavaScript parlance). defprotocol is dynamic, has no special compile-time
 *   effect, and defines no new types.
 * 
 *   (defprotocol P
 *  (foo [this])
 *  (bar-me [this] [this y]))
 * 
 *   (deftype Foo [a b c]
 *  P
 *  (foo [this] a)
 *  (bar-me [this] b)
 *  (bar-me [this y] (+ c y)))
 * 
 *   (bar-me (Foo. 1 2 3) 42)
 *   => 45
 * 
 *   (foo
 *  (let [x 42]
 *    (reify P
 *      (foo [this] 17)
 *      (bar-me [this] x)
 *      (bar-me [this y] x))))
 *   => 17
 */
cljs.core$macros.defprotocol = (function cljs$core$macros$defprotocol(var_args){
var args__29165__auto__ = [];
var len__29158__auto___35184 = arguments.length;
var i__29159__auto___35185 = (0);
while(true){
if((i__29159__auto___35185 < len__29158__auto___35184)){
args__29165__auto__.push((arguments[i__29159__auto___35185]));

var G__35186 = (i__29159__auto___35185 + (1));
i__29159__auto___35185 = G__35186;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((3) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.defprotocol.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29166__auto__);
});

cljs.core$macros.defprotocol.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,psym,doc_PLUS_methods){
var p = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.call(null,cljs.core.dissoc.call(null,_AMPERSAND_env,new cljs.core.Keyword(null,"locals","locals",535295783)),psym));
var vec__35162 = ((typeof cljs.core.first.call(null,doc_PLUS_methods) === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,doc_PLUS_methods),cljs.core.next.call(null,doc_PLUS_methods)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,doc_PLUS_methods], null));
var doc = cljs.core.nth.call(null,vec__35162,(0),null);
var methods$ = cljs.core.nth.call(null,vec__35162,(1),null);
var psym__$1 = cljs.core.vary_meta.call(null,psym,cljs.core.assoc,new cljs.core.Keyword(null,"doc","doc",1913296891),doc,new cljs.core.Keyword(null,"protocol-symbol","protocol-symbol",1279552198),true);
var ns_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(_AMPERSAND_env));
var fqn = ((function (p,vec__35162,doc,methods$,psym__$1,ns_name){
return (function (n){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)].join(''));
});})(p,vec__35162,doc,methods$,psym__$1,ns_name))
;
var prefix = cljs.core$macros.protocol_prefix.call(null,p);
var _ = (function (){var seq__35165 = cljs.core.seq.call(null,methods$);
var chunk__35166 = null;
var count__35167 = (0);
var i__35168 = (0);
while(true){
if((i__35168 < count__35167)){
var vec__35169 = cljs.core._nth.call(null,chunk__35166,i__35168);
var seq__35170 = cljs.core.seq.call(null,vec__35169);
var first__35171 = cljs.core.first.call(null,seq__35170);
var seq__35170__$1 = cljs.core.next.call(null,seq__35170);
var mname = first__35171;
var arities = seq__35170__$1;
if(cljs.core.truth_(cljs.core.some.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [(0),null], null), null),cljs.core.map.call(null,cljs.core.count,cljs.core.filter.call(null,cljs.core.vector_QMARK_,arities))))){
throw (new Error(["Invalid protocol, ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym__$1)," defines method ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)," with arity 0"].join('')));
} else {
}

var G__35187 = seq__35165;
var G__35188 = chunk__35166;
var G__35189 = count__35167;
var G__35190 = (i__35168 + (1));
seq__35165 = G__35187;
chunk__35166 = G__35188;
count__35167 = G__35189;
i__35168 = G__35190;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__35165);
if(temp__4657__auto__){
var seq__35165__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35165__$1)){
var c__28828__auto__ = cljs.core.chunk_first.call(null,seq__35165__$1);
var G__35191 = cljs.core.chunk_rest.call(null,seq__35165__$1);
var G__35192 = c__28828__auto__;
var G__35193 = cljs.core.count.call(null,c__28828__auto__);
var G__35194 = (0);
seq__35165 = G__35191;
chunk__35166 = G__35192;
count__35167 = G__35193;
i__35168 = G__35194;
continue;
} else {
var vec__35172 = cljs.core.first.call(null,seq__35165__$1);
var seq__35173 = cljs.core.seq.call(null,vec__35172);
var first__35174 = cljs.core.first.call(null,seq__35173);
var seq__35173__$1 = cljs.core.next.call(null,seq__35173);
var mname = first__35174;
var arities = seq__35173__$1;
if(cljs.core.truth_(cljs.core.some.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [(0),null], null), null),cljs.core.map.call(null,cljs.core.count,cljs.core.filter.call(null,cljs.core.vector_QMARK_,arities))))){
throw (new Error(["Invalid protocol, ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym__$1)," defines method ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)," with arity 0"].join('')));
} else {
}

var G__35195 = cljs.core.next.call(null,seq__35165__$1);
var G__35196 = null;
var G__35197 = (0);
var G__35198 = (0);
seq__35165 = G__35195;
chunk__35166 = G__35196;
count__35167 = G__35197;
i__35168 = G__35198;
continue;
}
} else {
return null;
}
}
break;
}
})();
var expand_sig = ((function (p,vec__35162,doc,methods$,psym__$1,ns_name,fqn,prefix,_){
return (function (fname,slot,sig){
var sig__$1 = ((!(cljs.core.every_QMARK_.call(null,cljs.core.symbol_QMARK_,sig)))?cljs.core.mapv.call(null,((function (p,vec__35162,doc,methods$,psym__$1,ns_name,fqn,prefix,_){
return (function (arg){
if((arg instanceof cljs.core.Symbol)){
return arg;
} else {
if((cljs.core.map_QMARK_.call(null,arg)) && (!((new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(arg) == null)))){
return new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(arg);
} else {
return cljs.core.gensym.call(null);

}
}
});})(p,vec__35162,doc,methods$,psym__$1,ns_name,fqn,prefix,_))
,sig):sig);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = sig__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","and","cljs.core$macros/and",48320334,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","nil?","cljs.core$macros/nil?",83624258,null)),(function (){var x__28851__auto__ = cljs.core.first.call(null,sig__$1);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","nil?","cljs.core$macros/nil?",83624258,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__28851__auto__ = cljs.core.first.call(null,sig__$1);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.symbol.call(null,["-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(slot)].join(''));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__28851__auto__ = cljs.core.first.call(null,sig__$1);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = slot;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),sig__$1)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"x__35156__auto__","x__35156__auto__",-1711316482,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","nil?","cljs.core$macros/nil?",83624258,null)),(function (){var x__28851__auto__ = cljs.core.first.call(null,sig__$1);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null),(function (){var x__28851__auto__ = cljs.core.first.call(null,sig__$1);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"m__35157__auto__","m__35157__auto__",-1539812412,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","unchecked-get","cljs.core$macros/unchecked-get",-1185166893,null)),(function (){var x__28851__auto__ = fqn.call(null,fname);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("goog","typeOf","goog/typeOf",539097255,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"x__35156__auto__","x__35156__auto__",-1711316482,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","if-not","cljs.core$macros/if-not",-1825285737,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","nil?","cljs.core$macros/nil?",83624258,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"m__35157__auto__","m__35157__auto__",-1539812412,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"m__35157__auto__","m__35157__auto__",-1539812412,null)),sig__$1)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"m__35157__auto__","m__35157__auto__",-1539812412,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","unchecked-get","cljs.core$macros/unchecked-get",-1185166893,null)),(function (){var x__28851__auto__ = fqn.call(null,fname);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,"_"))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","if-not","cljs.core$macros/if-not",-1825285737,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","nil?","cljs.core$macros/nil?",83624258,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"m__35157__auto__","m__35157__auto__",-1539812412,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"m__35157__auto__","m__35157__auto__",-1539812412,null)),sig__$1)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"throw","throw",595905694,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","missing-protocol","cljs.core/missing-protocol",531539732,null)),(function (){var x__28851__auto__ = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym__$1),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fname)].join('');
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.first.call(null,sig__$1);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});})(p,vec__35162,doc,methods$,psym__$1,ns_name,fqn,prefix,_))
;
var psym__$2 = cljs.core.vary_meta.call(null,cljs.core.vary_meta.call(null,psym__$1,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516)], null),cljs.core.conj,"@interface"),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"protocol-info","protocol-info",1471745843),new cljs.core.Keyword(null,"methods","methods",453930866)], null),cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,((function (p,vec__35162,doc,methods$,psym__$1,ns_name,fqn,prefix,_,expand_sig){
return (function (p__35175){
var vec__35176 = p__35175;
var seq__35177 = cljs.core.seq.call(null,vec__35176);
var first__35178 = cljs.core.first.call(null,seq__35177);
var seq__35177__$1 = cljs.core.next.call(null,seq__35177);
var fname = first__35178;
var sigs = seq__35177__$1;
var doc__$1 = (function (){var doc__$1 = cljs.core.last.call(null,sigs);
if(typeof doc__$1 === 'string'){
return doc__$1;
} else {
return null;
}
})();
var sigs__$1 = cljs.core.take_while.call(null,cljs.core.vector_QMARK_,sigs);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.vary_meta.call(null,fname,cljs.core.assoc,new cljs.core.Keyword(null,"doc","doc",1913296891),doc__$1),cljs.core.vec.call(null,sigs__$1)], null);
});})(p,vec__35162,doc,methods$,psym__$1,ns_name,fqn,prefix,_,expand_sig))
,methods$)));
var method = ((function (p,vec__35162,doc,methods$,psym__$1,ns_name,fqn,prefix,_,expand_sig,psym__$2){
return (function (p__35179){
var vec__35180 = p__35179;
var seq__35181 = cljs.core.seq.call(null,vec__35180);
var first__35182 = cljs.core.first.call(null,seq__35181);
var seq__35181__$1 = cljs.core.next.call(null,seq__35181);
var fname = first__35182;
var sigs = seq__35181__$1;
var doc__$1 = (function (){var doc__$1 = cljs.core.last.call(null,sigs);
if(typeof doc__$1 === 'string'){
return doc__$1;
} else {
return null;
}
})();
var sigs__$1 = cljs.core.take_while.call(null,cljs.core.vector_QMARK_,sigs);
var amp = (cljs.core.truth_(cljs.core.some.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"&","&",-2144855648,null),null], null), null),cljs.core.apply.call(null,cljs.core.concat,sigs__$1)))?cljs.analyzer.warning.call(null,new cljs.core.Keyword(null,"protocol-with-variadic-method","protocol-with-variadic-method",-693368178),_AMPERSAND_env,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"protocol","protocol",652470118),psym__$2,new cljs.core.Keyword(null,"name","name",1843675177),fname], null)):null);
var slot = cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefix),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,fname))].join(''));
var fname__$1 = cljs.core.vary_meta.call(null,fname,cljs.core.assoc,new cljs.core.Keyword(null,"protocol","protocol",652470118),p,new cljs.core.Keyword(null,"doc","doc",1913296891),doc__$1);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","defn","cljs.core$macros/defn",-728332354,null)),(function (){var x__28851__auto__ = fname__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core.map.call(null,((function (doc__$1,sigs__$1,amp,slot,fname__$1,vec__35180,seq__35181,first__35182,seq__35181__$1,fname,sigs,p,vec__35162,doc,methods$,psym__$1,ns_name,fqn,prefix,_,expand_sig,psym__$2){
return (function (sig){
return expand_sig.call(null,fname__$1,cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(slot),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,sig))].join('')),sig);
});})(doc__$1,sigs__$1,amp,slot,fname__$1,vec__35180,seq__35181,first__35182,seq__35181__$1,fname,sigs,p,vec__35162,doc,methods$,psym__$1,ns_name,fqn,prefix,_,expand_sig,psym__$2))
,sigs__$1))));
});})(p,vec__35162,doc,methods$,psym__$1,ns_name,fqn,prefix,_,expand_sig,psym__$2))
;
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"*unchecked-if*","*unchecked-if*",1542408350,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,true))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"def","def",597100991,null)),(function (){var x__28851__auto__ = psym__$2;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"js*","js*",-1134233646,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,"function(){}"))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core.map.call(null,method,methods$),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"*unchecked-if*","*unchecked-if*",1542408350,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,false))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.defprotocol.cljs$lang$maxFixedArity = (3);

cljs.core$macros.defprotocol.cljs$lang$applyTo = (function (seq35158){
var G__35159 = cljs.core.first.call(null,seq35158);
var seq35158__$1 = cljs.core.next.call(null,seq35158);
var G__35160 = cljs.core.first.call(null,seq35158__$1);
var seq35158__$2 = cljs.core.next.call(null,seq35158__$1);
var G__35161 = cljs.core.first.call(null,seq35158__$2);
var seq35158__$3 = cljs.core.next.call(null,seq35158__$2);
return cljs.core$macros.defprotocol.cljs$core$IFn$_invoke$arity$variadic(G__35159,G__35160,G__35161,seq35158__$3);
});

return null;
})()
;
cljs.core$macros.defprotocol.cljs$lang$macro = true;

var ret__29198__auto___35202 = /**
 * EXPERIMENTAL
 */
cljs.core$macros.implements_QMARK_ = (function cljs$core$macros$implements_QMARK_(_AMPERSAND_form,_AMPERSAND_env,psym,x){
var p = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.call(null,cljs.core.dissoc.call(null,_AMPERSAND_env,new cljs.core.Keyword(null,"locals","locals",535295783)),psym));
var prefix = cljs.core$macros.protocol_prefix.call(null,p);
var xsym = cljs.core$macros.bool_expr.call(null,cljs.core.gensym.call(null));
var vec__35199 = cljs.core$macros.fast_path_protocols.call(null,p);
var part = cljs.core.nth.call(null,vec__35199,(0),null);
var bit = cljs.core.nth.call(null,vec__35199,(1),null);
var msym = cljs.core.symbol.call(null,["-cljs$lang$protocol_mask$partition",cljs.core.str.cljs$core$IFn$_invoke$arity$1(part),"$"].join(''));
if(!((x instanceof cljs.core.Symbol))){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = xsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = xsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","or","cljs.core$macros/or",1346243648,null)),(function (){var x__28851__auto__ = (cljs.core.truth_(bit)?cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","unsafe-bit-and","cljs.core$macros/unsafe-bit-and",1803731600,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__28851__auto__ = xsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = msym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = bit;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))):false);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","identical?","cljs.core$macros/identical?",815580547,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","PROTOCOL_SENTINEL","cljs.core/PROTOCOL_SENTINEL",210209696,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__28851__auto__ = xsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.symbol.call(null,["-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefix)].join(''));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,true),cljs.core._conj.call(null,cljs.core.List.EMPTY,false))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,false))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","if-not","cljs.core$macros/if-not",-1825285737,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","nil?","cljs.core$macros/nil?",83624258,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","or","cljs.core$macros/or",1346243648,null)),(function (){var x__28851__auto__ = (cljs.core.truth_(bit)?cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","unsafe-bit-and","cljs.core$macros/unsafe-bit-and",1803731600,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = msym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = bit;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))):false);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","identical?","cljs.core$macros/identical?",815580547,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","PROTOCOL_SENTINEL","cljs.core/PROTOCOL_SENTINEL",210209696,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.symbol.call(null,["-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefix)].join(''));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,true),cljs.core._conj.call(null,cljs.core.List.EMPTY,false))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,false))));
}
});
cljs.core$macros.implements_QMARK_.cljs$lang$macro = true;

var ret__29198__auto___35206 = /**
 * Returns true if x satisfies the protocol
 */
cljs.core$macros.satisfies_QMARK_ = (function cljs$core$macros$satisfies_QMARK_(_AMPERSAND_form,_AMPERSAND_env,psym,x){
var p = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.call(null,cljs.core.dissoc.call(null,_AMPERSAND_env,new cljs.core.Keyword(null,"locals","locals",535295783)),psym));
var prefix = cljs.core$macros.protocol_prefix.call(null,p);
var xsym = cljs.core$macros.bool_expr.call(null,cljs.core.gensym.call(null));
var vec__35203 = cljs.core$macros.fast_path_protocols.call(null,p);
var part = cljs.core.nth.call(null,vec__35203,(0),null);
var bit = cljs.core.nth.call(null,vec__35203,(1),null);
var msym = cljs.core.symbol.call(null,["-cljs$lang$protocol_mask$partition",cljs.core.str.cljs$core$IFn$_invoke$arity$1(part),"$"].join(''));
if(!((x instanceof cljs.core.Symbol))){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = xsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","if-not","cljs.core$macros/if-not",-1825285737,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","nil?","cljs.core$macros/nil?",83624258,null)),(function (){var x__28851__auto__ = xsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","or","cljs.core$macros/or",1346243648,null)),(function (){var x__28851__auto__ = (cljs.core.truth_(bit)?cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","unsafe-bit-and","cljs.core$macros/unsafe-bit-and",1803731600,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__28851__auto__ = xsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = msym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = bit;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))):false);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","identical?","cljs.core$macros/identical?",815580547,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","PROTOCOL_SENTINEL","cljs.core/PROTOCOL_SENTINEL",210209696,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__28851__auto__ = xsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.symbol.call(null,["-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefix)].join(''));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,true),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","coercive-not","cljs.core$macros/coercive-not",115999987,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__28851__auto__ = xsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = msym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","native-satisfies?","cljs.core/native-satisfies?",1482305036,null)),(function (){var x__28851__auto__ = psym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = xsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,false))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","native-satisfies?","cljs.core/native-satisfies?",1482305036,null)),(function (){var x__28851__auto__ = psym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = xsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","if-not","cljs.core$macros/if-not",-1825285737,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","nil?","cljs.core$macros/nil?",83624258,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","or","cljs.core$macros/or",1346243648,null)),(function (){var x__28851__auto__ = (cljs.core.truth_(bit)?cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","unsafe-bit-and","cljs.core$macros/unsafe-bit-and",1803731600,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = msym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = bit;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))):false);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","identical?","cljs.core$macros/identical?",815580547,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","PROTOCOL_SENTINEL","cljs.core/PROTOCOL_SENTINEL",210209696,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.symbol.call(null,["-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefix)].join(''));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,true),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","coercive-not","cljs.core$macros/coercive-not",115999987,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = msym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","native-satisfies?","cljs.core/native-satisfies?",1482305036,null)),(function (){var x__28851__auto__ = psym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,false))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","native-satisfies?","cljs.core/native-satisfies?",1482305036,null)),(function (){var x__28851__auto__ = psym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
}
});
cljs.core$macros.satisfies_QMARK_.cljs$lang$macro = true;

var ret__29198__auto___35210 = (function (){
/**
 * Takes a body of expressions that returns an ISeq or nil, and yields
 *   a ISeqable object that will invoke the body only the first time seq
 *   is called, and will cache the result and return it on all subsequent
 *   seq calls.
 */
cljs.core$macros.lazy_seq = (function cljs$core$macros$lazy_seq(var_args){
var args__29165__auto__ = [];
var len__29158__auto___35211 = arguments.length;
var i__29159__auto___35212 = (0);
while(true){
if((i__29159__auto___35212 < len__29158__auto___35211)){
args__29165__auto__.push((arguments[i__29159__auto___35212]));

var G__35213 = (i__29159__auto___35212 + (1));
i__29159__auto___35212 = G__35213;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((2) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.lazy_seq.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29166__auto__);
});

cljs.core$macros.lazy_seq.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"new","new",-444906321,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","LazySeq","cljs.core/LazySeq",1986389673,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,null),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),body)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
});

cljs.core$macros.lazy_seq.cljs$lang$maxFixedArity = (2);

cljs.core$macros.lazy_seq.cljs$lang$applyTo = (function (seq35207){
var G__35208 = cljs.core.first.call(null,seq35207);
var seq35207__$1 = cljs.core.next.call(null,seq35207);
var G__35209 = cljs.core.first.call(null,seq35207__$1);
var seq35207__$2 = cljs.core.next.call(null,seq35207__$1);
return cljs.core$macros.lazy_seq.cljs$core$IFn$_invoke$arity$variadic(G__35208,G__35209,seq35207__$2);
});

return null;
})()
;
cljs.core$macros.lazy_seq.cljs$lang$macro = true;

var ret__29198__auto___35217 = (function (){
/**
 * Takes a body of expressions and yields a Delay object that will
 *   invoke the body only the first time it is forced (with force or deref/@), and
 *   will cache the result and return it on all subsequent force
 *   calls.
 */
cljs.core$macros.delay = (function cljs$core$macros$delay(var_args){
var args__29165__auto__ = [];
var len__29158__auto___35218 = arguments.length;
var i__29159__auto___35219 = (0);
while(true){
if((i__29159__auto___35219 < len__29158__auto___35218)){
args__29165__auto__.push((arguments[i__29159__auto___35219]));

var G__35220 = (i__29159__auto___35219 + (1));
i__29159__auto___35219 = G__35220;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((2) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.delay.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29166__auto__);
});

cljs.core$macros.delay.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"new","new",-444906321,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","Delay","cljs.core/Delay",-21574999,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),body)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
});

cljs.core$macros.delay.cljs$lang$maxFixedArity = (2);

cljs.core$macros.delay.cljs$lang$applyTo = (function (seq35214){
var G__35215 = cljs.core.first.call(null,seq35214);
var seq35214__$1 = cljs.core.next.call(null,seq35214);
var G__35216 = cljs.core.first.call(null,seq35214__$1);
var seq35214__$2 = cljs.core.next.call(null,seq35214__$1);
return cljs.core$macros.delay.cljs$core$IFn$_invoke$arity$variadic(G__35215,G__35216,seq35214__$2);
});

return null;
})()
;
cljs.core$macros.delay.cljs$lang$macro = true;

var ret__29198__auto___35229 = (function (){
/**
 * binding => var-symbol temp-value-expr
 * 
 *   Temporarily redefines vars while executing the body.  The
 *   temp-value-exprs will be evaluated and each resulting value will
 *   replace in parallel the root value of its var.  After the body is
 *   executed, the root values of all the vars will be set back to their
 *   old values. Useful for mocking out functions during testing.
 */
cljs.core$macros.with_redefs = (function cljs$core$macros$with_redefs(var_args){
var args__29165__auto__ = [];
var len__29158__auto___35230 = arguments.length;
var i__29159__auto___35231 = (0);
while(true){
if((i__29159__auto___35231 < len__29158__auto___35230)){
args__29165__auto__.push((arguments[i__29159__auto___35231]));

var G__35232 = (i__29159__auto___35231 + (1));
i__29159__auto___35231 = G__35232;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((3) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.with_redefs.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29166__auto__);
});

cljs.core$macros.with_redefs.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,bindings,body){
var names = cljs.core.take_nth.call(null,(2),bindings);
var vals = cljs.core.take_nth.call(null,(2),cljs.core.drop.call(null,(1),bindings));
var tempnames = cljs.core.map.call(null,cljs.core.comp.call(null,cljs.core.gensym,cljs.core.name),names);
var binds = cljs.core.map.call(null,cljs.core.vector,names,vals);
var resets = cljs.core.reverse.call(null,cljs.core.map.call(null,cljs.core.vector,names,tempnames));
var bind_value = ((function (names,vals,tempnames,binds,resets){
return (function (p__35225){
var vec__35226 = p__35225;
var k = cljs.core.nth.call(null,vec__35226,(0),null);
var v = cljs.core.nth.call(null,vec__35226,(1),null);
return cljs.core._conj.call(null,(function (){var x__28851__auto__ = k;
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = v;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),new cljs.core.Symbol(null,"set!","set!",250714521,null));
});})(names,vals,tempnames,binds,resets))
;
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core.interleave.call(null,tempnames,names)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core.map.call(null,bind_value,binds),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"try","try",-1273693247,null)),body,(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"finally","finally",-1065347064,null)),cljs.core.map.call(null,bind_value,resets))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.with_redefs.cljs$lang$maxFixedArity = (3);

cljs.core$macros.with_redefs.cljs$lang$applyTo = (function (seq35221){
var G__35222 = cljs.core.first.call(null,seq35221);
var seq35221__$1 = cljs.core.next.call(null,seq35221);
var G__35223 = cljs.core.first.call(null,seq35221__$1);
var seq35221__$2 = cljs.core.next.call(null,seq35221__$1);
var G__35224 = cljs.core.first.call(null,seq35221__$2);
var seq35221__$3 = cljs.core.next.call(null,seq35221__$2);
return cljs.core$macros.with_redefs.cljs$core$IFn$_invoke$arity$variadic(G__35222,G__35223,G__35224,seq35221__$3);
});

return null;
})()
;
cljs.core$macros.with_redefs.cljs$lang$macro = true;

var ret__29198__auto___35237 = (function (){
/**
 * binding => var-symbol init-expr
 * 
 *   Creates new bindings for the (already-existing) vars, with the
 *   supplied initial values, executes the exprs in an implicit do, then
 *   re-establishes the bindings that existed before.  The new bindings
 *   are made in parallel (unlike let); all init-exprs are evaluated
 *   before the vars are bound to their new values.
 */
cljs.core$macros.binding = (function cljs$core$macros$binding(var_args){
var args__29165__auto__ = [];
var len__29158__auto___35238 = arguments.length;
var i__29159__auto___35239 = (0);
while(true){
if((i__29159__auto___35239 < len__29158__auto___35238)){
args__29165__auto__.push((arguments[i__29159__auto___35239]));

var G__35240 = (i__29159__auto___35239 + (1));
i__29159__auto___35239 = G__35240;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((3) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.binding.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29166__auto__);
});

cljs.core$macros.binding.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,bindings,body){
var names = cljs.core.take_nth.call(null,(2),bindings);
cljs.analyzer.confirm_bindings.call(null,_AMPERSAND_env,names);

return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","with-redefs","cljs.core$macros/with-redefs",1489217801,null)),(function (){var x__28851__auto__ = bindings;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),body)));
});

cljs.core$macros.binding.cljs$lang$maxFixedArity = (3);

cljs.core$macros.binding.cljs$lang$applyTo = (function (seq35233){
var G__35234 = cljs.core.first.call(null,seq35233);
var seq35233__$1 = cljs.core.next.call(null,seq35233);
var G__35235 = cljs.core.first.call(null,seq35233__$1);
var seq35233__$2 = cljs.core.next.call(null,seq35233__$1);
var G__35236 = cljs.core.first.call(null,seq35233__$2);
var seq35233__$3 = cljs.core.next.call(null,seq35233__$2);
return cljs.core$macros.binding.cljs$core$IFn$_invoke$arity$variadic(G__35234,G__35235,G__35236,seq35233__$3);
});

return null;
})()
;
cljs.core$macros.binding.cljs$lang$macro = true;

var ret__29198__auto___35253 = (function (){
/**
 * Takes a binary predicate, an expression, and a set of clauses.
 *   Each clause can take the form of either:
 * 
 *   test-expr result-expr
 * 
 *   test-expr :>> result-fn
 * 
 *   Note :>> is an ordinary keyword.
 * 
 *   For each clause, (pred test-expr expr) is evaluated. If it returns
 *   logical true, the clause is a match. If a binary clause matches, the
 *   result-expr is returned, if a ternary clause matches, its result-fn,
 *   which must be a unary function, is called with the result of the
 *   predicate as its argument, the result of that call being the return
 *   value of condp. A single default expression can follow the clauses,
 *   and its value will be returned if no clause matches. If no default
 *   expression is provided and no clause matches, an
 *   IllegalArgumentException is thrown.
 */
cljs.core$macros.condp = (function cljs$core$macros$condp(var_args){
var args__29165__auto__ = [];
var len__29158__auto___35254 = arguments.length;
var i__29159__auto___35255 = (0);
while(true){
if((i__29159__auto___35255 < len__29158__auto___35254)){
args__29165__auto__.push((arguments[i__29159__auto___35255]));

var G__35256 = (i__29159__auto___35255 + (1));
i__29159__auto___35255 = G__35256;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((4) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((4)),(0),null)):null);
return cljs.core$macros.condp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__29166__auto__);
});

cljs.core$macros.condp.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,pred,expr,clauses){
var gpred = cljs.core.gensym.call(null,"pred__");
var gexpr = cljs.core.gensym.call(null,"expr__");
var emit = ((function (gpred,gexpr){
return (function cljs$core$macros$emit(pred__$1,expr__$1,args){
var vec__35247 = cljs.core.split_at.call(null,((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,">>",">>",-277509267),cljs.core.second.call(null,args)))?(3):(2)),args);
var vec__35250 = cljs.core.nth.call(null,vec__35247,(0),null);
var a = cljs.core.nth.call(null,vec__35250,(0),null);
var b = cljs.core.nth.call(null,vec__35250,(1),null);
var c = cljs.core.nth.call(null,vec__35250,(2),null);
var clause = vec__35250;
var more = cljs.core.nth.call(null,vec__35247,(1),null);
var n = cljs.core.count.call(null,clause);
if(cljs.core._EQ_.call(null,(0),n)){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"throw","throw",595905694,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("js","Error.","js/Error.",750655924,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","str","cljs.core/str",-1971828991,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,"No matching clause: "),(function (){var x__28851__auto__ = expr__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
} else {
if(cljs.core._EQ_.call(null,(1),n)){
return a;
} else {
if(cljs.core._EQ_.call(null,(2),n)){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = pred__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = a;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = expr__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = b;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs$core$macros$emit.call(null,pred__$1,expr__$1,more);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","if-let","cljs.core$macros/if-let",1291543946,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"p__35241__auto__","p__35241__auto__",-348270031,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = pred__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = a;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = expr__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = c;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"p__35241__auto__","p__35241__auto__",-348270031,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs$core$macros$emit.call(null,pred__$1,expr__$1,more);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));

}
}
}
});})(gpred,gexpr))
;
var gres = cljs.core.gensym.call(null,"res__");
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = gpred;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = pred;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = gexpr;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = expr;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = emit.call(null,gpred,gexpr,clauses);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.condp.cljs$lang$maxFixedArity = (4);

cljs.core$macros.condp.cljs$lang$applyTo = (function (seq35242){
var G__35243 = cljs.core.first.call(null,seq35242);
var seq35242__$1 = cljs.core.next.call(null,seq35242);
var G__35244 = cljs.core.first.call(null,seq35242__$1);
var seq35242__$2 = cljs.core.next.call(null,seq35242__$1);
var G__35245 = cljs.core.first.call(null,seq35242__$2);
var seq35242__$3 = cljs.core.next.call(null,seq35242__$2);
var G__35246 = cljs.core.first.call(null,seq35242__$3);
var seq35242__$4 = cljs.core.next.call(null,seq35242__$3);
return cljs.core$macros.condp.cljs$core$IFn$_invoke$arity$variadic(G__35243,G__35244,G__35245,G__35246,seq35242__$4);
});

return null;
})()
;
cljs.core$macros.condp.cljs$lang$macro = true;

cljs.core$macros.assoc_test = (function cljs$core$macros$assoc_test(m,test,expr,env){
if(cljs.core.contains_QMARK_.call(null,m,test)){
throw (new Error(["Duplicate case test constant '",cljs.core.str.cljs$core$IFn$_invoke$arity$1(test),"'",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env))?[" on line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env))," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.analyzer._STAR_cljs_file_STAR_)].join(''):null))].join('')));
} else {
return cljs.core.assoc.call(null,m,test,expr);
}
});
cljs.core$macros.const_QMARK_ = (function cljs$core$macros$const_QMARK_(env,x){
var m = (function (){var and__27977__auto__ = cljs.core.list_QMARK_.call(null,x);
if(and__27977__auto__){
return cljs.analyzer.resolve_var.call(null,env,cljs.core.last.call(null,x));
} else {
return and__27977__auto__;
}
})();
if(cljs.core.truth_(m)){
return cljs.core.get.call(null,m,new cljs.core.Keyword(null,"const","const",1709929842));
} else {
return null;
}
});
var ret__29198__auto___35277 = (function (){
/**
 * Takes an expression, and a set of clauses.
 * 
 *   Each clause can take the form of either:
 * 
 *   test-constant result-expr
 * 
 *   (test-constant1 ... test-constantN)  result-expr
 * 
 *   The test-constants are not evaluated. They must be compile-time
 *   literals, and need not be quoted.  If the expression is equal to a
 *   test-constant, the corresponding result-expr is returned. A single
 *   default expression can follow the clauses, and its value will be
 *   returned if no clause matches. If no default expression is provided
 *   and no clause matches, an Error is thrown.
 * 
 *   Unlike cond and condp, case does a constant-time dispatch, the
 *   clauses are not considered sequentially.  All manner of constant
 *   expressions are acceptable in case, including numbers, strings,
 *   symbols, keywords, and (ClojureScript) composites thereof. Note that since
 *   lists are used to group multiple constants that map to the same
 *   expression, a vector can be used to match a list if needed. The
 *   test-constants need not be all of the same type.
 */
cljs.core$macros.case$ = (function cljs$core$macros$case(var_args){
var args__29165__auto__ = [];
var len__29158__auto___35278 = arguments.length;
var i__29159__auto___35279 = (0);
while(true){
if((i__29159__auto___35279 < len__29158__auto___35278)){
args__29165__auto__.push((arguments[i__29159__auto___35279]));

var G__35280 = (i__29159__auto___35279 + (1));
i__29159__auto___35279 = G__35280;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((3) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.case$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29166__auto__);
});

cljs.core$macros.case$.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,e,clauses){
var esym = cljs.core.gensym.call(null);
var default$ = ((cljs.core.odd_QMARK_.call(null,cljs.core.count.call(null,clauses)))?cljs.core.last.call(null,clauses):cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"throw","throw",595905694,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("js","Error.","js/Error.",750655924,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","str","cljs.core/str",-1971828991,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,"No matching clause: "),(function (){var x__28851__auto__ = esym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
var env = _AMPERSAND_env;
var pairs = cljs.core.reduce.call(null,((function (esym,default$,env){
return (function (m,p__35265){
var vec__35266 = p__35265;
var test = cljs.core.nth.call(null,vec__35266,(0),null);
var expr = cljs.core.nth.call(null,vec__35266,(1),null);
if(cljs.core.seq_QMARK_.call(null,test)){
return cljs.core.reduce.call(null,((function (vec__35266,test,expr,esym,default$,env){
return (function (m__$1,test__$1){
var test__$2 = (((test__$1 instanceof cljs.core.Symbol))?cljs.core._conj.call(null,(function (){var x__28851__auto__ = test__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),new cljs.core.Symbol(null,"quote","quote",1377916282,null)):test__$1);
return cljs.core$macros.assoc_test.call(null,m__$1,test__$2,expr,env);
});})(vec__35266,test,expr,esym,default$,env))
,m,test);
} else {
if((test instanceof cljs.core.Symbol)){
return cljs.core$macros.assoc_test.call(null,m,cljs.core._conj.call(null,(function (){var x__28851__auto__ = test;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),new cljs.core.Symbol(null,"quote","quote",1377916282,null)),expr,env);
} else {
return cljs.core$macros.assoc_test.call(null,m,test,expr,env);

}
}
});})(esym,default$,env))
,cljs.core.PersistentArrayMap.EMPTY,cljs.core.partition.call(null,(2),clauses));
var tests = cljs.core.keys.call(null,pairs);
if(cljs.core.every_QMARK_.call(null,cljs.core.some_fn.call(null,cljs.core.number_QMARK_,cljs.core.string_QMARK_,cljs.core.fnil.call(null,cljs.core.char_QMARK_,new cljs.core.Keyword(null,"nonchar","nonchar",-421759703)),((function (esym,default$,env,pairs,tests){
return (function (p1__35257_SHARP_){
return cljs.core$macros.const_QMARK_.call(null,env,p1__35257_SHARP_);
});})(esym,default$,env,pairs,tests))
),tests)){
var no_default = ((cljs.core.odd_QMARK_.call(null,cljs.core.count.call(null,clauses)))?cljs.core.butlast.call(null,clauses):clauses);
var tests__$1 = cljs.core.mapv.call(null,((function (no_default,esym,default$,env,pairs,tests){
return (function (p1__35258_SHARP_){
if(cljs.core.seq_QMARK_.call(null,p1__35258_SHARP_)){
return cljs.core.vec.call(null,p1__35258_SHARP_);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__35258_SHARP_], null);
}
});})(no_default,esym,default$,env,pairs,tests))
,cljs.core.take_nth.call(null,(2),no_default));
var thens = cljs.core.vec.call(null,cljs.core.take_nth.call(null,(2),cljs.core.drop.call(null,(1),no_default)));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = esym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = e;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"case*","case*",-1938255072,null)),(function (){var x__28851__auto__ = esym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = tests__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = thens;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = default$;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
} else {
if(cljs.core.every_QMARK_.call(null,cljs.core.keyword_QMARK_,tests)){
var no_default = ((cljs.core.odd_QMARK_.call(null,cljs.core.count.call(null,clauses)))?cljs.core.butlast.call(null,clauses):clauses);
var kw_str = ((function (no_default,esym,default$,env,pairs,tests){
return (function (p1__35259_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__35259_SHARP_)].join('').substring((1));
});})(no_default,esym,default$,env,pairs,tests))
;
var tests__$1 = cljs.core.mapv.call(null,((function (no_default,kw_str,esym,default$,env,pairs,tests){
return (function (p1__35260_SHARP_){
if(cljs.core.seq_QMARK_.call(null,p1__35260_SHARP_)){
return cljs.core.mapv.call(null,kw_str,p1__35260_SHARP_);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [kw_str.call(null,p1__35260_SHARP_)], null);
}
});})(no_default,kw_str,esym,default$,env,pairs,tests))
,cljs.core.take_nth.call(null,(2),no_default));
var thens = cljs.core.vec.call(null,cljs.core.take_nth.call(null,(2),cljs.core.drop.call(null,(1),no_default)));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = esym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = e;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = esym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","keyword?","cljs.core$macros/keyword?",1362730141,null)),(function (){var x__28851__auto__ = esym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-fqn",".-fqn",1246113027,null)),(function (){var x__28851__auto__ = esym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"case*","case*",-1938255072,null)),(function (){var x__28851__auto__ = esym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = tests__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = thens;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = default$;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = esym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = e;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","cond","cljs.core$macros/cond",1626318471,null)),cljs.core.mapcat.call(null,((function (esym,default$,env,pairs,tests){
return (function (p__35273){
var vec__35274 = p__35273;
var m = cljs.core.nth.call(null,vec__35274,(0),null);
var c = cljs.core.nth.call(null,vec__35274,(1),null);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","=","cljs.core/=",-1891498332,null)),(function (){var x__28851__auto__ = m;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = esym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = c;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});})(esym,default$,env,pairs,tests))
,pairs),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"else","else",-1508377146)),(function (){var x__28851__auto__ = default$;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));

}
}
});

cljs.core$macros.case$.cljs$lang$maxFixedArity = (3);

cljs.core$macros.case$.cljs$lang$applyTo = (function (seq35261){
var G__35262 = cljs.core.first.call(null,seq35261);
var seq35261__$1 = cljs.core.next.call(null,seq35261);
var G__35263 = cljs.core.first.call(null,seq35261__$1);
var seq35261__$2 = cljs.core.next.call(null,seq35261__$1);
var G__35264 = cljs.core.first.call(null,seq35261__$2);
var seq35261__$3 = cljs.core.next.call(null,seq35261__$2);
return cljs.core$macros.case$.cljs$core$IFn$_invoke$arity$variadic(G__35262,G__35263,G__35264,seq35261__$3);
});

return null;
})()
;
cljs.core$macros.case$.cljs$lang$macro = true;

var ret__29198__auto___35281 = cljs.core$macros.when_assert = (function cljs$core$macros$when_assert(_AMPERSAND_form,_AMPERSAND_env,x){
if(cljs.core._STAR_assert_STAR_){
return x;
} else {
return null;
}
});
cljs.core$macros.when_assert.cljs$lang$macro = true;

var ret__29198__auto___35284 = (function (){
/**
 * Evaluates expr and throws an exception if it does not evaluate to
 *   logical true.
 */
cljs.core$macros.assert = (function cljs$core$macros$assert(var_args){
var G__35283 = arguments.length;
switch (G__35283) {
case 3:
return cljs.core$macros.assert.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core$macros.assert.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (2)))].join('')));

}
});

cljs.core$macros.assert.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
if(cljs.core._STAR_assert_STAR_){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when-not","cljs.core$macros/when-not",-764302244,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"throw","throw",595905694,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("js","Error.","js/Error.",750655924,null)),(function (){var x__28851__auto__ = ["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,x))].join('');
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
} else {
return null;
}
});

cljs.core$macros.assert.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,x,message){
if(cljs.core._STAR_assert_STAR_){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when-not","cljs.core$macros/when-not",-764302244,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"throw","throw",595905694,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("js","Error.","js/Error.",750655924,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","str","cljs.core/str",-1971828991,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,"Assert failed: "),(function (){var x__28851__auto__ = message;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,"\n"),(function (){var x__28851__auto__ = cljs.core.pr_str.call(null,x);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
} else {
return null;
}
});

cljs.core$macros.assert.cljs$lang$maxFixedArity = 4;

return null;
})()
;
cljs.core$macros.assert.cljs$lang$macro = true;

var ret__29198__auto___35324 = /**
 * List comprehension. Takes a vector of one or more
 * binding-form/collection-expr pairs, each followed by zero or more
 * modifiers, and yields a lazy sequence of evaluations of expr.
 * Collections are iterated in a nested fashion, rightmost fastest,
 * and nested coll-exprs can refer to bindings created in prior
 * binding-forms.  Supported modifiers are: :let [binding-form expr ...],
 * :while test, :when test.
 * 
 *   (take 100 (for [x (range 100000000) y (range 1000000) :while (< y x)]  [x y]))
 */
cljs.core$macros.for$ = (function cljs$core$macros$for(_AMPERSAND_form,_AMPERSAND_env,seq_exprs,body_expr){
if(cljs.core.vector_QMARK_.call(null,seq_exprs)){
} else {
throw cljs.core.ex_info.call(null,"for requires a vector for its binding",cljs.core.PersistentArrayMap.EMPTY);
}

if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,seq_exprs))){
} else {
throw cljs.core.ex_info.call(null,"for requires an even number of forms in binding vector",cljs.core.PersistentArrayMap.EMPTY);
}


var to_groups = (function (seq_exprs__$1){
return cljs.core.reduce.call(null,(function (groups,p__35291){
var vec__35292 = p__35291;
var k = cljs.core.nth.call(null,vec__35292,(0),null);
var v = cljs.core.nth.call(null,vec__35292,(1),null);
if((k instanceof cljs.core.Keyword)){
return cljs.core.conj.call(null,cljs.core.pop.call(null,groups),cljs.core.conj.call(null,cljs.core.peek.call(null,groups),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null)));
} else {
return cljs.core.conj.call(null,groups,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));
}
}),cljs.core.PersistentVector.EMPTY,cljs.core.partition.call(null,(2),seq_exprs__$1));
});
var err = ((function (to_groups){
return (function() { 
var G__35325__delegate = function (msg){
throw cljs.core.ex_info.call(null,cljs.core.apply.call(null,cljs.core.str,msg),cljs.core.PersistentArrayMap.EMPTY);
};
var G__35325 = function (var_args){
var msg = null;
if (arguments.length > 0) {
var G__35326__i = 0, G__35326__a = new Array(arguments.length -  0);
while (G__35326__i < G__35326__a.length) {G__35326__a[G__35326__i] = arguments[G__35326__i + 0]; ++G__35326__i;}
  msg = new cljs.core.IndexedSeq(G__35326__a,0,null);
} 
return G__35325__delegate.call(this,msg);};
G__35325.cljs$lang$maxFixedArity = 0;
G__35325.cljs$lang$applyTo = (function (arglist__35327){
var msg = cljs.core.seq(arglist__35327);
return G__35325__delegate(msg);
});
G__35325.cljs$core$IFn$_invoke$arity$variadic = G__35325__delegate;
return G__35325;
})()
;})(to_groups))
;
var emit_bind = ((function (to_groups,err){
return (function cljs$core$macros$for_$_emit_bind(p__35295){
var vec__35296 = p__35295;
var seq__35297 = cljs.core.seq.call(null,vec__35296);
var first__35298 = cljs.core.first.call(null,seq__35297);
var seq__35297__$1 = cljs.core.next.call(null,seq__35297);
var vec__35299 = first__35298;
var seq__35300 = cljs.core.seq.call(null,vec__35299);
var first__35301 = cljs.core.first.call(null,seq__35300);
var seq__35300__$1 = cljs.core.next.call(null,seq__35300);
var bind = first__35301;
var first__35301__$1 = cljs.core.first.call(null,seq__35300__$1);
var seq__35300__$2 = cljs.core.next.call(null,seq__35300__$1);
var expr = first__35301__$1;
var mod_pairs = seq__35300__$2;
var vec__35302 = seq__35297__$1;
var vec__35305 = cljs.core.nth.call(null,vec__35302,(0),null);
var _ = cljs.core.nth.call(null,vec__35305,(0),null);
var next_expr = cljs.core.nth.call(null,vec__35305,(1),null);
var next_groups = vec__35302;
var giter = cljs.core.gensym.call(null,"iter__");
var gxs = cljs.core.gensym.call(null,"s__");
var do_mod = ((function (giter,gxs,vec__35296,seq__35297,first__35298,seq__35297__$1,vec__35299,seq__35300,first__35301,seq__35300__$1,bind,first__35301__$1,seq__35300__$2,expr,mod_pairs,vec__35302,vec__35305,_,next_expr,next_groups,to_groups,err){
return (function cljs$core$macros$for_$_emit_bind_$_do_mod(p__35308){
var vec__35309 = p__35308;
var seq__35310 = cljs.core.seq.call(null,vec__35309);
var first__35311 = cljs.core.first.call(null,seq__35310);
var seq__35310__$1 = cljs.core.next.call(null,seq__35310);
var vec__35312 = first__35311;
var k = cljs.core.nth.call(null,vec__35312,(0),null);
var v = cljs.core.nth.call(null,vec__35312,(1),null);
var pair = vec__35312;
var etc = seq__35310__$1;
if(cljs.core._EQ_.call(null,k,new cljs.core.Keyword(null,"let","let",-1282412701))){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = v;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs$core$macros$for_$_emit_bind_$_do_mod.call(null,etc);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
} else {
if(cljs.core._EQ_.call(null,k,new cljs.core.Keyword(null,"while","while",963117786))){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when","cljs.core$macros/when",328457725,null)),(function (){var x__28851__auto__ = v;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs$core$macros$for_$_emit_bind_$_do_mod.call(null,etc);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
} else {
if(cljs.core._EQ_.call(null,k,new cljs.core.Keyword(null,"when","when",-576417306))){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = v;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs$core$macros$for_$_emit_bind_$_do_mod.call(null,etc);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"recur","recur",1202958259,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","rest","cljs.core/rest",-285075455,null)),(function (){var x__28851__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
} else {
if((k instanceof cljs.core.Keyword)){
return err.call(null,"Invalid 'for' keyword ",k);
} else {
if(next_groups){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"iterys__35286__auto__","iterys__35286__auto__",-290039646,null)),(function (){var x__28851__auto__ = cljs$core$macros$for_$_emit_bind.call(null,next_groups);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"fs__35287__auto__","fs__35287__auto__",121843711,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","seq","cljs.core/seq",-1649497689,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"iterys__35286__auto__","iterys__35286__auto__",-290039646,null)),(function (){var x__28851__auto__ = next_expr;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"fs__35287__auto__","fs__35287__auto__",121843711,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","concat","cljs.core/concat",-1133584918,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"fs__35287__auto__","fs__35287__auto__",121843711,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = giter;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","rest","cljs.core/rest",-285075455,null)),(function (){var x__28851__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"recur","recur",1202958259,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","rest","cljs.core/rest",-285075455,null)),(function (){var x__28851__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","cons","cljs.core/cons",96507417,null)),(function (){var x__28851__auto__ = body_expr;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = giter;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","rest","cljs.core/rest",-285075455,null)),(function (){var x__28851__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));

}
}
}
}
}
});})(giter,gxs,vec__35296,seq__35297,first__35298,seq__35297__$1,vec__35299,seq__35300,first__35301,seq__35300__$1,bind,first__35301__$1,seq__35300__$2,expr,mod_pairs,vec__35302,vec__35305,_,next_expr,next_groups,to_groups,err))
;
if(next_groups){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__28851__auto__ = giter;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","lazy-seq","cljs.core$macros/lazy-seq",806482650,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","loop","cljs.core$macros/loop",1731108390,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when-first","cljs.core$macros/when-first",-840670160,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = bind;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = do_mod.call(null,mod_pairs);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
} else {
var gi = cljs.core.gensym.call(null,"i__");
var gb = cljs.core.gensym.call(null,"b__");
var do_cmod = ((function (gi,gb,giter,gxs,do_mod,vec__35296,seq__35297,first__35298,seq__35297__$1,vec__35299,seq__35300,first__35301,seq__35300__$1,bind,first__35301__$1,seq__35300__$2,expr,mod_pairs,vec__35302,vec__35305,_,next_expr,next_groups,to_groups,err){
return (function cljs$core$macros$for_$_emit_bind_$_do_cmod(p__35315){
var vec__35316 = p__35315;
var seq__35317 = cljs.core.seq.call(null,vec__35316);
var first__35318 = cljs.core.first.call(null,seq__35317);
var seq__35317__$1 = cljs.core.next.call(null,seq__35317);
var vec__35319 = first__35318;
var k = cljs.core.nth.call(null,vec__35319,(0),null);
var v = cljs.core.nth.call(null,vec__35319,(1),null);
var pair = vec__35319;
var etc = seq__35317__$1;
if(cljs.core._EQ_.call(null,k,new cljs.core.Keyword(null,"let","let",-1282412701))){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = v;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs$core$macros$for_$_emit_bind_$_do_cmod.call(null,etc);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
} else {
if(cljs.core._EQ_.call(null,k,new cljs.core.Keyword(null,"while","while",963117786))){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when","cljs.core$macros/when",328457725,null)),(function (){var x__28851__auto__ = v;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs$core$macros$for_$_emit_bind_$_do_cmod.call(null,etc);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
} else {
if(cljs.core._EQ_.call(null,k,new cljs.core.Keyword(null,"when","when",-576417306))){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = v;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs$core$macros$for_$_emit_bind_$_do_cmod.call(null,etc);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"recur","recur",1202958259,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","unchecked-inc","cljs.core$macros/unchecked-inc",-1615365330,null)),(function (){var x__28851__auto__ = gi;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
} else {
if((k instanceof cljs.core.Keyword)){
return err.call(null,"Invalid 'for' keyword ",k);
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","chunk-append","cljs.core/chunk-append",-243671470,null)),(function (){var x__28851__auto__ = gb;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = body_expr;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"recur","recur",1202958259,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","unchecked-inc","cljs.core$macros/unchecked-inc",-1615365330,null)),(function (){var x__28851__auto__ = gi;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));

}
}
}
}
});})(gi,gb,giter,gxs,do_mod,vec__35296,seq__35297,first__35298,seq__35297__$1,vec__35299,seq__35300,first__35301,seq__35300__$1,bind,first__35301__$1,seq__35300__$2,expr,mod_pairs,vec__35302,vec__35305,_,next_expr,next_groups,to_groups,err))
;
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__28851__auto__ = giter;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","lazy-seq","cljs.core$macros/lazy-seq",806482650,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","loop","cljs.core$macros/loop",1731108390,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when-let","cljs.core$macros/when-let",-2004472648,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","seq","cljs.core/seq",-1649497689,null)),(function (){var x__28851__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","chunked-seq?","cljs.core/chunked-seq?",-712922369,null)),(function (){var x__28851__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"c__35288__auto__","c__35288__auto__",-734339558,null)),(function (){var x__28851__auto__ = cljs.core.with_meta.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","chunk-first","cljs.core/chunk-first",-1157877305,null)),(function (){var x__28851__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))),cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"file","file",-1269645878)),cljs.core._conj.call(null,cljs.core.List.EMPTY,"/Users/prepor/work/orcl-open/backend-naive/resources/public/js/out/cljs/core.cljc"),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"line","line",212345235)),cljs.core._conj.call(null,cljs.core.List.EMPTY,2383),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"column","column",2078222095)),cljs.core._conj.call(null,cljs.core.List.EMPTY,52),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"end-line","end-line",1837326455)),cljs.core._conj.call(null,cljs.core.List.EMPTY,2383),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"end-column","end-column",1425389514)),cljs.core._conj.call(null,cljs.core.List.EMPTY,82),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"tag","tag",-1290361223)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","not-native","cljs.core/not-native",-1716909265,null)))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"size__35289__auto__","size__35289__auto__",-613192099,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"c__35288__auto__","c__35288__auto__",-734339558,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = gb;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","chunk-buffer","cljs.core/chunk-buffer",14093626,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"size__35289__auto__","size__35289__auto__",-613192099,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","coercive-boolean","cljs.core$macros/coercive-boolean",-450758280,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","loop","cljs.core$macros/loop",1731108390,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = gi;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","<","cljs.core$macros/<",371512596,null)),(function (){var x__28851__auto__ = gi;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"size__35289__auto__","size__35289__auto__",-613192099,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = bind;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-nth","cljs.core/-nth",504234802,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"c__35288__auto__","c__35288__auto__",-734339558,null)),(function (){var x__28851__auto__ = gi;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = do_cmod.call(null,mod_pairs);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,true))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","chunk-cons","cljs.core/chunk-cons",-250075688,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","chunk","cljs.core/chunk",847936424,null)),(function (){var x__28851__auto__ = gb;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = giter;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","chunk-rest","cljs.core/chunk-rest",-398161143,null)),(function (){var x__28851__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","chunk-cons","cljs.core/chunk-cons",-250075688,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","chunk","cljs.core/chunk",847936424,null)),(function (){var x__28851__auto__ = gb;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = bind;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","first","cljs.core/first",-752535972,null)),(function (){var x__28851__auto__ = gxs;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = do_mod.call(null,mod_pairs);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
}
});})(to_groups,err))
;
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"iter__35290__auto__","iter__35290__auto__",-228338226,null)),(function (){var x__28851__auto__ = emit_bind.call(null,to_groups.call(null,seq_exprs));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"iter__35290__auto__","iter__35290__auto__",-228338226,null)),(function (){var x__28851__auto__ = cljs.core.second.call(null,seq_exprs);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
cljs.core$macros.for$.cljs$lang$macro = true;

var ret__29198__auto___35333 = (function (){
/**
 * Repeatedly executes body (presumably for side-effects) with
 *   bindings and filtering as provided by "for".  Does not retain
 *   the head of the sequence. Returns nil.
 */
cljs.core$macros.doseq = (function cljs$core$macros$doseq(var_args){
var args__29165__auto__ = [];
var len__29158__auto___35334 = arguments.length;
var i__29159__auto___35335 = (0);
while(true){
if((i__29159__auto___35335 < len__29158__auto___35334)){
args__29165__auto__.push((arguments[i__29159__auto___35335]));

var G__35336 = (i__29159__auto___35335 + (1));
i__29159__auto___35335 = G__35336;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((3) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.doseq.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29166__auto__);
});

cljs.core$macros.doseq.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,seq_exprs,body){
if(cljs.core.vector_QMARK_.call(null,seq_exprs)){
} else {
throw cljs.core.ex_info.call(null,"doseq requires a vector for its binding",cljs.core.PersistentArrayMap.EMPTY);
}

if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,seq_exprs))){
} else {
throw cljs.core.ex_info.call(null,"doseq requires an even number of forms in binding vector",cljs.core.PersistentArrayMap.EMPTY);
}


var err = (function() { 
var G__35337__delegate = function (msg){
throw cljs.core.ex_info.call(null,cljs.core.apply.call(null,cljs.core.str,msg),cljs.core.PersistentArrayMap.EMPTY);
};
var G__35337 = function (var_args){
var msg = null;
if (arguments.length > 0) {
var G__35338__i = 0, G__35338__a = new Array(arguments.length -  0);
while (G__35338__i < G__35338__a.length) {G__35338__a[G__35338__i] = arguments[G__35338__i + 0]; ++G__35338__i;}
  msg = new cljs.core.IndexedSeq(G__35338__a,0,null);
} 
return G__35337__delegate.call(this,msg);};
G__35337.cljs$lang$maxFixedArity = 0;
G__35337.cljs$lang$applyTo = (function (arglist__35339){
var msg = cljs.core.seq(arglist__35339);
return G__35337__delegate(msg);
});
G__35337.cljs$core$IFn$_invoke$arity$variadic = G__35337__delegate;
return G__35337;
})()
;
var step = ((function (err){
return (function cljs$core$macros$step(recform,exprs){
if(cljs.core.not.call(null,exprs)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),body)))], null);
} else {
var k = cljs.core.first.call(null,exprs);
var v = cljs.core.second.call(null,exprs);
var seqsym = cljs.core.gensym.call(null,"seq__");
var recform__$1 = (((k instanceof cljs.core.Keyword))?recform:cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"recur","recur",1202958259,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","next","cljs.core/next",-1291438473,null)),(function (){var x__28851__auto__ = seqsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0)),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0))))));
var steppair = cljs$core$macros$step.call(null,recform__$1,cljs.core.nnext.call(null,exprs));
var needrec = steppair.call(null,(0));
var subform = steppair.call(null,(1));
if(cljs.core._EQ_.call(null,k,new cljs.core.Keyword(null,"let","let",-1282412701))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [needrec,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = v;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = subform;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())))], null);
} else {
if(cljs.core._EQ_.call(null,k,new cljs.core.Keyword(null,"while","while",963117786))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when","cljs.core$macros/when",328457725,null)),(function (){var x__28851__auto__ = v;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = subform;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(cljs.core.truth_(needrec)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [recform__$1], null):null))))], null);
} else {
if(cljs.core._EQ_.call(null,k,new cljs.core.Keyword(null,"when","when",-576417306))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = v;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),(function (){var x__28851__auto__ = subform;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(cljs.core.truth_(needrec)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [recform__$1], null):null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = recform__$1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())))], null);
} else {
if((k instanceof cljs.core.Keyword)){
return err.call(null,"Invalid 'doseq' keyword",k);
} else {
var chunksym = cljs.core.with_meta.call(null,cljs.core.gensym.call(null,"chunk__"),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"not-native","not-native",-236392494,null)], null));
var countsym = cljs.core.gensym.call(null,"count__");
var isym = cljs.core.gensym.call(null,"i__");
var recform_chunk = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"recur","recur",1202958259,null)),(function (){var x__28851__auto__ = seqsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = chunksym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = countsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","unchecked-inc","cljs.core$macros/unchecked-inc",-1615365330,null)),(function (){var x__28851__auto__ = isym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
var steppair_chunk = cljs$core$macros$step.call(null,recform_chunk,cljs.core.nnext.call(null,exprs));
var subform_chunk = steppair_chunk.call(null,(1));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","loop","cljs.core$macros/loop",1731108390,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = seqsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","seq","cljs.core/seq",-1649497689,null)),(function (){var x__28851__auto__ = v;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = chunksym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null),(function (){var x__28851__auto__ = countsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0)),(function (){var x__28851__auto__ = isym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","coercive-boolean","cljs.core$macros/coercive-boolean",-450758280,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","<","cljs.core$macros/<",371512596,null)),(function (){var x__28851__auto__ = isym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = countsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = k;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-nth","cljs.core/-nth",504234802,null)),(function (){var x__28851__auto__ = chunksym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = isym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = subform_chunk;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(cljs.core.truth_(needrec)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [recform_chunk], null):null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when-let","cljs.core$macros/when-let",-2004472648,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = seqsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","seq","cljs.core/seq",-1649497689,null)),(function (){var x__28851__auto__ = seqsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","chunked-seq?","cljs.core/chunked-seq?",-712922369,null)),(function (){var x__28851__auto__ = seqsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"c__35328__auto__","c__35328__auto__",-211408234,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","chunk-first","cljs.core/chunk-first",-1157877305,null)),(function (){var x__28851__auto__ = seqsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"recur","recur",1202958259,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","chunk-rest","cljs.core/chunk-rest",-398161143,null)),(function (){var x__28851__auto__ = seqsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"c__35328__auto__","c__35328__auto__",-211408234,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"c__35328__auto__","c__35328__auto__",-211408234,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = k;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","first","cljs.core/first",-752535972,null)),(function (){var x__28851__auto__ = seqsym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = subform;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(cljs.core.truth_(needrec)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [recform__$1], null):null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())))], null);

}
}
}
}
}
});})(err))
;
return cljs.core.nth.call(null,step.call(null,null,cljs.core.seq.call(null,seq_exprs)),(1));
});

cljs.core$macros.doseq.cljs$lang$maxFixedArity = (3);

cljs.core$macros.doseq.cljs$lang$applyTo = (function (seq35329){
var G__35330 = cljs.core.first.call(null,seq35329);
var seq35329__$1 = cljs.core.next.call(null,seq35329);
var G__35331 = cljs.core.first.call(null,seq35329__$1);
var seq35329__$2 = cljs.core.next.call(null,seq35329__$1);
var G__35332 = cljs.core.first.call(null,seq35329__$2);
var seq35329__$3 = cljs.core.next.call(null,seq35329__$2);
return cljs.core$macros.doseq.cljs$core$IFn$_invoke$arity$variadic(G__35330,G__35331,G__35332,seq35329__$3);
});

return null;
})()
;
cljs.core$macros.doseq.cljs$lang$macro = true;

var ret__29198__auto___35343 = (function (){
cljs.core$macros.array = (function cljs$core$macros$array(var_args){
var args__29165__auto__ = [];
var len__29158__auto___35344 = arguments.length;
var i__29159__auto___35345 = (0);
while(true){
if((i__29159__auto___35345 < len__29158__auto___35344)){
args__29165__auto__.push((arguments[i__29159__auto___35345]));

var G__35346 = (i__29159__auto___35345 + (1));
i__29159__auto___35345 = G__35346;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((2) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.array.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29166__auto__);
});

cljs.core$macros.array.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,rest){
var xs_str = cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null,",",cljs.core.take.call(null,cljs.core.count.call(null,rest),cljs.core.repeat.call(null,"~{}"))));
return cljs.core.vary_meta.call(null,cljs.core.list_STAR_.call(null,new cljs.core.Symbol(null,"js*","js*",-1134233646,null),["[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(xs_str),"]"].join(''),rest),cljs.core.assoc,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"array","array",-440182315,null));
});

cljs.core$macros.array.cljs$lang$maxFixedArity = (2);

cljs.core$macros.array.cljs$lang$applyTo = (function (seq35340){
var G__35341 = cljs.core.first.call(null,seq35340);
var seq35340__$1 = cljs.core.next.call(null,seq35340);
var G__35342 = cljs.core.first.call(null,seq35340__$1);
var seq35340__$2 = cljs.core.next.call(null,seq35340__$1);
return cljs.core$macros.array.cljs$core$IFn$_invoke$arity$variadic(G__35341,G__35342,seq35340__$2);
});

return null;
})()
;
cljs.core$macros.array.cljs$lang$macro = true;

var ret__29198__auto___35357 = (function (){
cljs.core$macros.make_array = (function cljs$core$macros$make_array(var_args){
var G__35356 = arguments.length;
switch (G__35356) {
case 3:
return cljs.core$macros.make_array.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core$macros.make_array.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__29177__auto__ = [];
var len__29158__auto___35359 = arguments.length;
var i__29159__auto___35360 = (0);
while(true){
if((i__29159__auto___35360 < len__29158__auto___35359)){
args_arr__29177__auto__.push((arguments[i__29159__auto___35360]));

var G__35361 = (i__29159__auto___35360 + (1));
i__29159__auto___35360 = G__35361;
continue;
} else {
}
break;
}

var argseq__29178__auto__ = (new cljs.core.IndexedSeq(args_arr__29177__auto__.slice((4)),(0),null));
return cljs.core$macros.make_array.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__29178__auto__);

}
});

cljs.core$macros.make_array.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,size){
return cljs.core.vary_meta.call(null,((typeof size === 'number')?cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","array","cljs.core$macros/array",49650437,null)),cljs.core.take.call(null,size,cljs.core.repeat.call(null,null))))):cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("js","Array.","js/Array.",1235645307,null)),(function (){var x__28851__auto__ = size;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())))),cljs.core.assoc,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"array","array",-440182315,null));
});

cljs.core$macros.make_array.cljs$core$IFn$_invoke$arity$4 = (function (_AMPERSAND_form,_AMPERSAND_env,type,size){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","make-array","cljs.core/make-array",-1802166799,null)),(function (){var x__28851__auto__ = size;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.make_array.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,type,size,more_sizes){
return cljs.core.vary_meta.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"dims__35347__auto__","dims__35347__auto__",1938657571,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","list","cljs.core$macros/list",-1408486806,null)),more_sizes)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"dimarray__35348__auto__","dimarray__35348__auto__",1980598379,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","make-array","cljs.core/make-array",-1802166799,null)),(function (){var x__28851__auto__ = size;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","dotimes","cljs.core$macros/dotimes",-1407597661,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"i__35349__auto__","i__35349__auto__",-440958978,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","alength","cljs.core$macros/alength",-683052937,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"dimarray__35348__auto__","dimarray__35348__auto__",1980598379,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","aset","cljs.core$macros/aset",-693176374,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"dimarray__35348__auto__","dimarray__35348__auto__",1980598379,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"i__35349__auto__","i__35349__auto__",-440958978,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","apply","cljs.core/apply",1757277831,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","make-array","cljs.core/make-array",-1802166799,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,null),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"dims__35347__auto__","dims__35347__auto__",1938657571,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"dimarray__35348__auto__","dimarray__35348__auto__",1980598379,null))))),cljs.core.assoc,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"array","array",-440182315,null));
});

cljs.core$macros.make_array.cljs$lang$applyTo = (function (seq35351){
var G__35352 = cljs.core.first.call(null,seq35351);
var seq35351__$1 = cljs.core.next.call(null,seq35351);
var G__35353 = cljs.core.first.call(null,seq35351__$1);
var seq35351__$2 = cljs.core.next.call(null,seq35351__$1);
var G__35354 = cljs.core.first.call(null,seq35351__$2);
var seq35351__$3 = cljs.core.next.call(null,seq35351__$2);
var G__35355 = cljs.core.first.call(null,seq35351__$3);
var seq35351__$4 = cljs.core.next.call(null,seq35351__$3);
return cljs.core$macros.make_array.cljs$core$IFn$_invoke$arity$variadic(G__35352,G__35353,G__35354,G__35355,seq35351__$4);
});

cljs.core$macros.make_array.cljs$lang$maxFixedArity = (4);

return null;
})()
;
cljs.core$macros.make_array.cljs$lang$macro = true;

var ret__29198__auto___35370 = (function (){
cljs.core$macros.list = (function cljs$core$macros$list(var_args){
var G__35368 = arguments.length;
switch (G__35368) {
case 2:
return cljs.core$macros.list.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__29177__auto__ = [];
var len__29158__auto___35372 = arguments.length;
var i__29159__auto___35373 = (0);
while(true){
if((i__29159__auto___35373 < len__29158__auto___35372)){
args_arr__29177__auto__.push((arguments[i__29159__auto___35373]));

var G__35374 = (i__29159__auto___35373 + (1));
i__29159__auto___35373 = G__35374;
continue;
} else {
}
break;
}

var argseq__29178__auto__ = (new cljs.core.IndexedSeq(args_arr__29177__auto__.slice((3)),(0),null));
return cljs.core$macros.list.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29178__auto__);

}
});

cljs.core$macros.list.cljs$core$IFn$_invoke$arity$2 = (function (_AMPERSAND_form,_AMPERSAND_env){
return cljs.core.list(new cljs.core.Symbol(null,".-EMPTY",".-EMPTY",-471586691,null),new cljs.core.Symbol("cljs.core","List","cljs.core/List",1708954352,null));
});

cljs.core$macros.list.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,xs){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"constant","constant",-379609303),new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1((function (){var _STAR_cljs_warnings_STAR_35369 = cljs.analyzer._STAR_cljs_warnings_STAR_;
cljs.analyzer._STAR_cljs_warnings_STAR_ = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"invoke-ctor","invoke-ctor",-756052704),new cljs.core.Keyword(null,"extending-base-js-type","extending-base-js-type",432787264),new cljs.core.Keyword(null,"unsupported-preprocess-value","unsupported-preprocess-value",1635147105),new cljs.core.Keyword(null,"redef","redef",1032704258),new cljs.core.Keyword(null,"js-shadowed-by-local","js-shadowed-by-local",198048291),new cljs.core.Keyword(null,"unsupported-js-module-type","unsupported-js-module-type",1806206180),new cljs.core.Keyword(null,"invalid-protocol-symbol","invalid-protocol-symbol",86246948),new cljs.core.Keyword(null,"protocol-duped-method","protocol-duped-method",15128166),new cljs.core.Keyword(null,"munged-namespace","munged-namespace",-101986199),new cljs.core.Keyword(null,"single-segment-namespace","single-segment-namespace",-491924469),new cljs.core.Keyword(null,"fn-arity","fn-arity",-403576501),new cljs.core.Keyword(null,"infer-warning","infer-warning",-1600671410),new cljs.core.Keyword(null,"variadic-max-arity","variadic-max-arity",-14288402),new cljs.core.Keyword(null,"protocol-with-variadic-method","protocol-with-variadic-method",-693368178),new cljs.core.Keyword(null,"fn-deprecated","fn-deprecated",626877647),new cljs.core.Keyword(null,"undeclared-var","undeclared-var",-1624364944),new cljs.core.Keyword(null,"preamble-missing","preamble-missing",220974801),new cljs.core.Keyword(null,"undeclared-protocol-symbol","undeclared-protocol-symbol",462882867),new cljs.core.Keyword(null,"dynamic","dynamic",704819571),new cljs.core.Keyword(null,"invalid-array-access","invalid-array-access",-1747132236),new cljs.core.Keyword(null,"unprovided","unprovided",-652330764),new cljs.core.Keyword(null,"ns-var-clash","ns-var-clash",-280494668),new cljs.core.Keyword(null,"undeclared-ns","undeclared-ns",-1589012812),new cljs.core.Keyword(null,"undeclared-ns-form","undeclared-ns-form",-248024137),new cljs.core.Keyword(null,"invalid-arithmetic","invalid-arithmetic",1917075065),new cljs.core.Keyword(null,"protocol-deprecated","protocol-deprecated",103233497),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"protocol-impl-recur-with-target","protocol-impl-recur-with-target",-1648321574),new cljs.core.Keyword(null,"overload-arity","overload-arity",823206044),new cljs.core.Keyword(null,"protocol-multiple-impls","protocol-multiple-impls",794179260),new cljs.core.Keyword(null,"redef-in-file","redef-in-file",-476530788),new cljs.core.Keyword(null,"protocol-invalid-method","protocol-invalid-method",522647516),new cljs.core.Keyword(null,"extend-type-invalid-method-shape","extend-type-invalid-method-shape",1424103549),new cljs.core.Keyword(null,"multiple-variadic-overloads","multiple-variadic-overloads",1110059837),new cljs.core.Keyword(null,"protocol-impl-with-variadic-method","protocol-impl-with-variadic-method",-319321217)],[false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false]);

try{return cljs.analyzer.analyze.call(null,_AMPERSAND_env,x);
}finally {cljs.analyzer._STAR_cljs_warnings_STAR_ = _STAR_cljs_warnings_STAR_35369;
}})()))){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-conj","cljs.core/-conj",2040622670,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","list","cljs.core$macros/list",-1408486806,null)),xs)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"x__35362__auto__","x__35362__auto__",-1927507409,null)),(function (){var x__28851__auto__ = x;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-conj","cljs.core/-conj",2040622670,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","list","cljs.core$macros/list",-1408486806,null)),xs)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"x__35362__auto__","x__35362__auto__",-1927507409,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
}
});

cljs.core$macros.list.cljs$lang$applyTo = (function (seq35364){
var G__35365 = cljs.core.first.call(null,seq35364);
var seq35364__$1 = cljs.core.next.call(null,seq35364);
var G__35366 = cljs.core.first.call(null,seq35364__$1);
var seq35364__$2 = cljs.core.next.call(null,seq35364__$1);
var G__35367 = cljs.core.first.call(null,seq35364__$2);
var seq35364__$3 = cljs.core.next.call(null,seq35364__$2);
return cljs.core$macros.list.cljs$core$IFn$_invoke$arity$variadic(G__35365,G__35366,G__35367,seq35364__$3);
});

cljs.core$macros.list.cljs$lang$maxFixedArity = (3);

return null;
})()
;
cljs.core$macros.list.cljs$lang$macro = true;

var ret__29198__auto___35380 = (function (){
cljs.core$macros.vector = (function cljs$core$macros$vector(var_args){
var G__35379 = arguments.length;
switch (G__35379) {
case 2:
return cljs.core$macros.vector.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__29177__auto__ = [];
var len__29158__auto___35382 = arguments.length;
var i__29159__auto___35383 = (0);
while(true){
if((i__29159__auto___35383 < len__29158__auto___35382)){
args_arr__29177__auto__.push((arguments[i__29159__auto___35383]));

var G__35384 = (i__29159__auto___35383 + (1));
i__29159__auto___35383 = G__35384;
continue;
} else {
}
break;
}

var argseq__29178__auto__ = (new cljs.core.IndexedSeq(args_arr__29177__auto__.slice((2)),(0),null));
return cljs.core$macros.vector.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29178__auto__);

}
});

cljs.core$macros.vector.cljs$core$IFn$_invoke$arity$2 = (function (_AMPERSAND_form,_AMPERSAND_env){
return cljs.core.list(new cljs.core.Symbol(null,".-EMPTY",".-EMPTY",-471586691,null),new cljs.core.Symbol("cljs.core","PersistentVector","cljs.core/PersistentVector",-1211028272,null));
});

cljs.core$macros.vector.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,xs){
var cnt = cljs.core.count.call(null,xs);
if((cnt < (32))){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","PersistentVector.","cljs.core/PersistentVector.",-1074647876,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,null),(function (){var x__28851__auto__ = cnt;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(5)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-EMPTY-NODE",".-EMPTY-NODE",-1333332641,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","PersistentVector","cljs.core/PersistentVector",-1211028272,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","array","cljs.core$macros/array",49650437,null)),xs)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
} else {
return cljs.core.vary_meta.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".fromArray",".fromArray",1053499311,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","PersistentVector","cljs.core/PersistentVector",-1211028272,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","array","cljs.core$macros/array",49650437,null)),xs)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,true)))),cljs.core.assoc,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core","PersistentVector","cljs.core/PersistentVector",-1211028272,null));
}
});

cljs.core$macros.vector.cljs$lang$applyTo = (function (seq35376){
var G__35377 = cljs.core.first.call(null,seq35376);
var seq35376__$1 = cljs.core.next.call(null,seq35376);
var G__35378 = cljs.core.first.call(null,seq35376__$1);
var seq35376__$2 = cljs.core.next.call(null,seq35376__$1);
return cljs.core$macros.vector.cljs$core$IFn$_invoke$arity$variadic(G__35377,G__35378,seq35376__$2);
});

cljs.core$macros.vector.cljs$lang$maxFixedArity = (2);

return null;
})()
;
cljs.core$macros.vector.cljs$lang$macro = true;

var ret__29198__auto___35394 = (function (){
cljs.core$macros.array_map = (function cljs$core$macros$array_map(var_args){
var G__35391 = arguments.length;
switch (G__35391) {
case 2:
return cljs.core$macros.array_map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__29177__auto__ = [];
var len__29158__auto___35396 = arguments.length;
var i__29159__auto___35397 = (0);
while(true){
if((i__29159__auto___35397 < len__29158__auto___35396)){
args_arr__29177__auto__.push((arguments[i__29159__auto___35397]));

var G__35398 = (i__29159__auto___35397 + (1));
i__29159__auto___35397 = G__35398;
continue;
} else {
}
break;
}

var argseq__29178__auto__ = (new cljs.core.IndexedSeq(args_arr__29177__auto__.slice((2)),(0),null));
return cljs.core$macros.array_map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29178__auto__);

}
});

cljs.core$macros.array_map.cljs$core$IFn$_invoke$arity$2 = (function (_AMPERSAND_form,_AMPERSAND_env){
return cljs.core.list(new cljs.core.Symbol(null,".-EMPTY",".-EMPTY",-471586691,null),new cljs.core.Symbol("cljs.core","PersistentArrayMap","cljs.core/PersistentArrayMap",1025194468,null));
});

cljs.core$macros.array_map.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,kvs){
var keys = cljs.core.map.call(null,cljs.core.first,cljs.core.partition.call(null,(2),kvs));
if((cljs.core.every_QMARK_.call(null,((function (keys){
return (function (p1__35385_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__35385_SHARP_),new cljs.core.Keyword(null,"constant","constant",-379609303));
});})(keys))
,cljs.core.map.call(null,((function (keys){
return (function (p1__35386_SHARP_){
var _STAR_cljs_warnings_STAR_35393 = cljs.analyzer._STAR_cljs_warnings_STAR_;
cljs.analyzer._STAR_cljs_warnings_STAR_ = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"invoke-ctor","invoke-ctor",-756052704),new cljs.core.Keyword(null,"extending-base-js-type","extending-base-js-type",432787264),new cljs.core.Keyword(null,"unsupported-preprocess-value","unsupported-preprocess-value",1635147105),new cljs.core.Keyword(null,"redef","redef",1032704258),new cljs.core.Keyword(null,"js-shadowed-by-local","js-shadowed-by-local",198048291),new cljs.core.Keyword(null,"unsupported-js-module-type","unsupported-js-module-type",1806206180),new cljs.core.Keyword(null,"invalid-protocol-symbol","invalid-protocol-symbol",86246948),new cljs.core.Keyword(null,"protocol-duped-method","protocol-duped-method",15128166),new cljs.core.Keyword(null,"munged-namespace","munged-namespace",-101986199),new cljs.core.Keyword(null,"single-segment-namespace","single-segment-namespace",-491924469),new cljs.core.Keyword(null,"fn-arity","fn-arity",-403576501),new cljs.core.Keyword(null,"infer-warning","infer-warning",-1600671410),new cljs.core.Keyword(null,"variadic-max-arity","variadic-max-arity",-14288402),new cljs.core.Keyword(null,"protocol-with-variadic-method","protocol-with-variadic-method",-693368178),new cljs.core.Keyword(null,"fn-deprecated","fn-deprecated",626877647),new cljs.core.Keyword(null,"undeclared-var","undeclared-var",-1624364944),new cljs.core.Keyword(null,"preamble-missing","preamble-missing",220974801),new cljs.core.Keyword(null,"undeclared-protocol-symbol","undeclared-protocol-symbol",462882867),new cljs.core.Keyword(null,"dynamic","dynamic",704819571),new cljs.core.Keyword(null,"invalid-array-access","invalid-array-access",-1747132236),new cljs.core.Keyword(null,"unprovided","unprovided",-652330764),new cljs.core.Keyword(null,"ns-var-clash","ns-var-clash",-280494668),new cljs.core.Keyword(null,"undeclared-ns","undeclared-ns",-1589012812),new cljs.core.Keyword(null,"undeclared-ns-form","undeclared-ns-form",-248024137),new cljs.core.Keyword(null,"invalid-arithmetic","invalid-arithmetic",1917075065),new cljs.core.Keyword(null,"protocol-deprecated","protocol-deprecated",103233497),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"protocol-impl-recur-with-target","protocol-impl-recur-with-target",-1648321574),new cljs.core.Keyword(null,"overload-arity","overload-arity",823206044),new cljs.core.Keyword(null,"protocol-multiple-impls","protocol-multiple-impls",794179260),new cljs.core.Keyword(null,"redef-in-file","redef-in-file",-476530788),new cljs.core.Keyword(null,"protocol-invalid-method","protocol-invalid-method",522647516),new cljs.core.Keyword(null,"extend-type-invalid-method-shape","extend-type-invalid-method-shape",1424103549),new cljs.core.Keyword(null,"multiple-variadic-overloads","multiple-variadic-overloads",1110059837),new cljs.core.Keyword(null,"protocol-impl-with-variadic-method","protocol-impl-with-variadic-method",-319321217)],[false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false]);

try{return cljs.analyzer.analyze.call(null,_AMPERSAND_env,p1__35386_SHARP_);
}finally {cljs.analyzer._STAR_cljs_warnings_STAR_ = _STAR_cljs_warnings_STAR_35393;
}});})(keys))
,keys))) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,keys)),cljs.core.count.call(null,keys)))){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","PersistentArrayMap.","cljs.core/PersistentArrayMap.",-471979341,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,null),(function (){var x__28851__auto__ = (cljs.core.count.call(null,kvs) / (2));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","array","cljs.core$macros/array",49650437,null)),kvs)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".createAsIfByAssoc",".createAsIfByAssoc",18554053,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","PersistentArrayMap","cljs.core/PersistentArrayMap",1025194468,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","array","cljs.core$macros/array",49650437,null)),kvs)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
}
});

cljs.core$macros.array_map.cljs$lang$applyTo = (function (seq35388){
var G__35389 = cljs.core.first.call(null,seq35388);
var seq35388__$1 = cljs.core.next.call(null,seq35388);
var G__35390 = cljs.core.first.call(null,seq35388__$1);
var seq35388__$2 = cljs.core.next.call(null,seq35388__$1);
return cljs.core$macros.array_map.cljs$core$IFn$_invoke$arity$variadic(G__35389,G__35390,seq35388__$2);
});

cljs.core$macros.array_map.cljs$lang$maxFixedArity = (2);

return null;
})()
;
cljs.core$macros.array_map.cljs$lang$macro = true;

var ret__29198__auto___35404 = (function (){
cljs.core$macros.hash_map = (function cljs$core$macros$hash_map(var_args){
var G__35403 = arguments.length;
switch (G__35403) {
case 2:
return cljs.core$macros.hash_map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__29177__auto__ = [];
var len__29158__auto___35406 = arguments.length;
var i__29159__auto___35407 = (0);
while(true){
if((i__29159__auto___35407 < len__29158__auto___35406)){
args_arr__29177__auto__.push((arguments[i__29159__auto___35407]));

var G__35408 = (i__29159__auto___35407 + (1));
i__29159__auto___35407 = G__35408;
continue;
} else {
}
break;
}

var argseq__29178__auto__ = (new cljs.core.IndexedSeq(args_arr__29177__auto__.slice((2)),(0),null));
return cljs.core$macros.hash_map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29178__auto__);

}
});

cljs.core$macros.hash_map.cljs$core$IFn$_invoke$arity$2 = (function (_AMPERSAND_form,_AMPERSAND_env){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-EMPTY",".-EMPTY",-471586691,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","PersistentHashMap","cljs.core/PersistentHashMap",-454120575,null)))));
});

cljs.core$macros.hash_map.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,kvs){
var pairs = cljs.core.partition.call(null,(2),kvs);
var ks = cljs.core.map.call(null,cljs.core.first,pairs);
var vs = cljs.core.map.call(null,cljs.core.second,pairs);
return cljs.core.vary_meta.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".fromArrays",".fromArrays",1110244209,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","PersistentHashMap","cljs.core/PersistentHashMap",-454120575,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","array","cljs.core$macros/array",49650437,null)),ks)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","array","cljs.core$macros/array",49650437,null)),vs)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))),cljs.core.assoc,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core","PersistentHashMap","cljs.core/PersistentHashMap",-454120575,null));
});

cljs.core$macros.hash_map.cljs$lang$applyTo = (function (seq35400){
var G__35401 = cljs.core.first.call(null,seq35400);
var seq35400__$1 = cljs.core.next.call(null,seq35400);
var G__35402 = cljs.core.first.call(null,seq35400__$1);
var seq35400__$2 = cljs.core.next.call(null,seq35400__$1);
return cljs.core$macros.hash_map.cljs$core$IFn$_invoke$arity$variadic(G__35401,G__35402,seq35400__$2);
});

cljs.core$macros.hash_map.cljs$lang$maxFixedArity = (2);

return null;
})()
;
cljs.core$macros.hash_map.cljs$lang$macro = true;

var ret__29198__auto___35418 = (function (){
cljs.core$macros.hash_set = (function cljs$core$macros$hash_set(var_args){
var G__35415 = arguments.length;
switch (G__35415) {
case 2:
return cljs.core$macros.hash_set.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__29177__auto__ = [];
var len__29158__auto___35420 = arguments.length;
var i__29159__auto___35421 = (0);
while(true){
if((i__29159__auto___35421 < len__29158__auto___35420)){
args_arr__29177__auto__.push((arguments[i__29159__auto___35421]));

var G__35422 = (i__29159__auto___35421 + (1));
i__29159__auto___35421 = G__35422;
continue;
} else {
}
break;
}

var argseq__29178__auto__ = (new cljs.core.IndexedSeq(args_arr__29177__auto__.slice((2)),(0),null));
return cljs.core$macros.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29178__auto__);

}
});

cljs.core$macros.hash_set.cljs$core$IFn$_invoke$arity$2 = (function (_AMPERSAND_form,_AMPERSAND_env){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-EMPTY",".-EMPTY",-471586691,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","PersistentHashSet","cljs.core/PersistentHashSet",-967232330,null)))));
});

cljs.core$macros.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,xs){
if(((cljs.core.count.call(null,xs) <= (8))) && (cljs.core.every_QMARK_.call(null,(function (p1__35409_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__35409_SHARP_),new cljs.core.Keyword(null,"constant","constant",-379609303));
}),cljs.core.map.call(null,(function (p1__35410_SHARP_){
var _STAR_cljs_warnings_STAR_35417 = cljs.analyzer._STAR_cljs_warnings_STAR_;
cljs.analyzer._STAR_cljs_warnings_STAR_ = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"invoke-ctor","invoke-ctor",-756052704),new cljs.core.Keyword(null,"extending-base-js-type","extending-base-js-type",432787264),new cljs.core.Keyword(null,"unsupported-preprocess-value","unsupported-preprocess-value",1635147105),new cljs.core.Keyword(null,"redef","redef",1032704258),new cljs.core.Keyword(null,"js-shadowed-by-local","js-shadowed-by-local",198048291),new cljs.core.Keyword(null,"unsupported-js-module-type","unsupported-js-module-type",1806206180),new cljs.core.Keyword(null,"invalid-protocol-symbol","invalid-protocol-symbol",86246948),new cljs.core.Keyword(null,"protocol-duped-method","protocol-duped-method",15128166),new cljs.core.Keyword(null,"munged-namespace","munged-namespace",-101986199),new cljs.core.Keyword(null,"single-segment-namespace","single-segment-namespace",-491924469),new cljs.core.Keyword(null,"fn-arity","fn-arity",-403576501),new cljs.core.Keyword(null,"infer-warning","infer-warning",-1600671410),new cljs.core.Keyword(null,"variadic-max-arity","variadic-max-arity",-14288402),new cljs.core.Keyword(null,"protocol-with-variadic-method","protocol-with-variadic-method",-693368178),new cljs.core.Keyword(null,"fn-deprecated","fn-deprecated",626877647),new cljs.core.Keyword(null,"undeclared-var","undeclared-var",-1624364944),new cljs.core.Keyword(null,"preamble-missing","preamble-missing",220974801),new cljs.core.Keyword(null,"undeclared-protocol-symbol","undeclared-protocol-symbol",462882867),new cljs.core.Keyword(null,"dynamic","dynamic",704819571),new cljs.core.Keyword(null,"invalid-array-access","invalid-array-access",-1747132236),new cljs.core.Keyword(null,"unprovided","unprovided",-652330764),new cljs.core.Keyword(null,"ns-var-clash","ns-var-clash",-280494668),new cljs.core.Keyword(null,"undeclared-ns","undeclared-ns",-1589012812),new cljs.core.Keyword(null,"undeclared-ns-form","undeclared-ns-form",-248024137),new cljs.core.Keyword(null,"invalid-arithmetic","invalid-arithmetic",1917075065),new cljs.core.Keyword(null,"protocol-deprecated","protocol-deprecated",103233497),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"protocol-impl-recur-with-target","protocol-impl-recur-with-target",-1648321574),new cljs.core.Keyword(null,"overload-arity","overload-arity",823206044),new cljs.core.Keyword(null,"protocol-multiple-impls","protocol-multiple-impls",794179260),new cljs.core.Keyword(null,"redef-in-file","redef-in-file",-476530788),new cljs.core.Keyword(null,"protocol-invalid-method","protocol-invalid-method",522647516),new cljs.core.Keyword(null,"extend-type-invalid-method-shape","extend-type-invalid-method-shape",1424103549),new cljs.core.Keyword(null,"multiple-variadic-overloads","multiple-variadic-overloads",1110059837),new cljs.core.Keyword(null,"protocol-impl-with-variadic-method","protocol-impl-with-variadic-method",-319321217)],[false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false]);

try{return cljs.analyzer.analyze.call(null,_AMPERSAND_env,p1__35410_SHARP_);
}finally {cljs.analyzer._STAR_cljs_warnings_STAR_ = _STAR_cljs_warnings_STAR_35417;
}}),xs))) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,xs)),cljs.core.count.call(null,xs)))){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","PersistentHashSet.","cljs.core/PersistentHashSet.",300313251,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,null),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","PersistentArrayMap.","cljs.core/PersistentArrayMap.",-471979341,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,null),(function (){var x__28851__auto__ = cljs.core.count.call(null,xs);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","array","cljs.core$macros/array",49650437,null)),cljs.core.interleave.call(null,xs,cljs.core.repeat.call(null,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
} else {
return cljs.core.vary_meta.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".createAsIfByAssoc",".createAsIfByAssoc",18554053,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","PersistentHashSet","cljs.core/PersistentHashSet",-967232330,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","array","cljs.core$macros/array",49650437,null)),xs)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))),cljs.core.assoc,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core","PersistentHashSet","cljs.core/PersistentHashSet",-967232330,null));
}
});

cljs.core$macros.hash_set.cljs$lang$applyTo = (function (seq35412){
var G__35413 = cljs.core.first.call(null,seq35412);
var seq35412__$1 = cljs.core.next.call(null,seq35412);
var G__35414 = cljs.core.first.call(null,seq35412__$1);
var seq35412__$2 = cljs.core.next.call(null,seq35412__$1);
return cljs.core$macros.hash_set.cljs$core$IFn$_invoke$arity$variadic(G__35413,G__35414,seq35412__$2);
});

cljs.core$macros.hash_set.cljs$lang$maxFixedArity = (2);

return null;
})()
;
cljs.core$macros.hash_set.cljs$lang$macro = true;

cljs.core$macros.js_obj_STAR_ = (function cljs$core$macros$js_obj_STAR_(kvs){
var kvs_str = cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null,",",cljs.core.take.call(null,cljs.core.count.call(null,kvs),cljs.core.repeat.call(null,"~{}:~{}"))));
return cljs.core.vary_meta.call(null,cljs.core.list_STAR_.call(null,new cljs.core.Symbol(null,"js*","js*",-1134233646,null),["{",cljs.core.str.cljs$core$IFn$_invoke$arity$1(kvs_str),"}"].join(''),cljs.core.apply.call(null,cljs.core.concat,kvs)),cljs.core.assoc,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"object","object",-1179821820,null));
});
var ret__29198__auto___35438 = (function (){
cljs.core$macros.js_obj = (function cljs$core$macros$js_obj(var_args){
var args__29165__auto__ = [];
var len__29158__auto___35439 = arguments.length;
var i__29159__auto___35440 = (0);
while(true){
if((i__29159__auto___35440 < len__29158__auto___35439)){
args__29165__auto__.push((arguments[i__29159__auto___35440]));

var G__35441 = (i__29159__auto___35440 + (1));
i__29159__auto___35440 = G__35441;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((2) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.js_obj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29166__auto__);
});

cljs.core$macros.js_obj.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,rest){
var sym_or_str_QMARK_ = (function (x){
return ((x instanceof cljs.core.Symbol)) || (typeof x === 'string');
});
var filter_on_keys = ((function (sym_or_str_QMARK_){
return (function (f,coll){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.filter.call(null,((function (sym_or_str_QMARK_){
return (function (p__35426){
var vec__35427 = p__35426;
var k = cljs.core.nth.call(null,vec__35427,(0),null);
var _ = cljs.core.nth.call(null,vec__35427,(1),null);
return f.call(null,k);
});})(sym_or_str_QMARK_))
,coll));
});})(sym_or_str_QMARK_))
;
var kvs = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,cljs.core.vec,cljs.core.partition.call(null,(2),rest)));
var sym_pairs = filter_on_keys.call(null,cljs.core.symbol_QMARK_,kvs);
var expr__GT_local = cljs.core.zipmap.call(null,cljs.core.filter.call(null,cljs.core.complement.call(null,sym_or_str_QMARK_),cljs.core.keys.call(null,kvs)),cljs.core.repeatedly.call(null,cljs.core.gensym));
var obj = cljs.core.gensym.call(null,"obj");
if(cljs.core.empty_QMARK_.call(null,rest)){
return cljs.core$macros.js_obj_STAR_.call(null,cljs.core.List.EMPTY);
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core.apply.call(null,cljs.core.concat,clojure.set.map_invert.call(null,expr__GT_local)),(function (){var x__28851__auto__ = obj;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core$macros.js_obj_STAR_.call(null,filter_on_keys.call(null,cljs.core.string_QMARK_,kvs));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core.map.call(null,((function (sym_or_str_QMARK_,filter_on_keys,kvs,sym_pairs,expr__GT_local,obj){
return (function (p__35430){
var vec__35431 = p__35430;
var k = cljs.core.nth.call(null,vec__35431,(0),null);
var v = cljs.core.nth.call(null,vec__35431,(1),null);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("goog.object","set","goog.object/set",-2123361230,null)),(function (){var x__28851__auto__ = obj;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = k;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = v;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});})(sym_or_str_QMARK_,filter_on_keys,kvs,sym_pairs,expr__GT_local,obj))
,sym_pairs),cljs.core.map.call(null,((function (sym_or_str_QMARK_,filter_on_keys,kvs,sym_pairs,expr__GT_local,obj){
return (function (p__35434){
var vec__35435 = p__35434;
var k = cljs.core.nth.call(null,vec__35435,(0),null);
var v = cljs.core.nth.call(null,vec__35435,(1),null);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("goog.object","set","goog.object/set",-2123361230,null)),(function (){var x__28851__auto__ = obj;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = v;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.get.call(null,kvs,k);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});})(sym_or_str_QMARK_,filter_on_keys,kvs,sym_pairs,expr__GT_local,obj))
,expr__GT_local),(function (){var x__28851__auto__ = obj;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
}
});

cljs.core$macros.js_obj.cljs$lang$maxFixedArity = (2);

cljs.core$macros.js_obj.cljs$lang$applyTo = (function (seq35423){
var G__35424 = cljs.core.first.call(null,seq35423);
var seq35423__$1 = cljs.core.next.call(null,seq35423);
var G__35425 = cljs.core.first.call(null,seq35423__$1);
var seq35423__$2 = cljs.core.next.call(null,seq35423__$1);
return cljs.core$macros.js_obj.cljs$core$IFn$_invoke$arity$variadic(G__35424,G__35425,seq35423__$2);
});

return null;
})()
;
cljs.core$macros.js_obj.cljs$lang$macro = true;

var ret__29198__auto___35442 = cljs.core$macros.alength = (function cljs$core$macros$alength(_AMPERSAND_form,_AMPERSAND_env,a){
return cljs.core.vary_meta.call(null,cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = a;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),"~{}.length"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null)),cljs.core.assoc,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"number","number",-1084057331,null));
});
cljs.core$macros.alength.cljs$lang$macro = true;

var ret__29198__auto___35444 = /**
 * Maps an expression across an array a, using an index named idx, and
 *   return value named ret, initialized to a clone of a, then setting
 *   each element of ret to the evaluation of expr, returning the new
 *   array ret.
 */
cljs.core$macros.amap = (function cljs$core$macros$amap(_AMPERSAND_form,_AMPERSAND_env,a,idx,ret,expr){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"a__35443__auto__","a__35443__auto__",925300511,null)),(function (){var x__28851__auto__ = a;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = ret;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","aclone","cljs.core/aclone",-758078968,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"a__35443__auto__","a__35443__auto__",925300511,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","loop","cljs.core$macros/loop",1731108390,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","<","cljs.core$macros/<",371512596,null)),(function (){var x__28851__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","alength","cljs.core$macros/alength",-683052937,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"a__35443__auto__","a__35443__auto__",925300511,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","aset","cljs.core$macros/aset",-693176374,null)),(function (){var x__28851__auto__ = ret;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = expr;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"recur","recur",1202958259,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","inc","cljs.core$macros/inc",876629257,null)),(function (){var x__28851__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = ret;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
cljs.core$macros.amap.cljs$lang$macro = true;

var ret__29198__auto___35446 = /**
 * Reduces an expression across an array a, using an index named idx,
 *   and return value named ret, initialized to init, setting ret to the
 *   evaluation of expr at each step, returning ret.
 */
cljs.core$macros.areduce = (function cljs$core$macros$areduce(_AMPERSAND_form,_AMPERSAND_env,a,idx,ret,init,expr){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"a__35445__auto__","a__35445__auto__",1906174309,null)),(function (){var x__28851__auto__ = a;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","loop","cljs.core$macros/loop",1731108390,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0)),(function (){var x__28851__auto__ = ret;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = init;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","<","cljs.core$macros/<",371512596,null)),(function (){var x__28851__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","alength","cljs.core$macros/alength",-683052937,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"a__35445__auto__","a__35445__auto__",1906174309,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"recur","recur",1202958259,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","inc","cljs.core$macros/inc",876629257,null)),(function (){var x__28851__auto__ = idx;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = expr;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = ret;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
cljs.core$macros.areduce.cljs$lang$macro = true;

var ret__29198__auto___35452 = (function (){
/**
 * bindings => name n
 * 
 *   Repeatedly executes body (presumably for side-effects) with name
 *   bound to integers from 0 through n-1.
 */
cljs.core$macros.dotimes = (function cljs$core$macros$dotimes(var_args){
var args__29165__auto__ = [];
var len__29158__auto___35453 = arguments.length;
var i__29159__auto___35454 = (0);
while(true){
if((i__29159__auto___35454 < len__29158__auto___35453)){
args__29165__auto__.push((arguments[i__29159__auto___35454]));

var G__35455 = (i__29159__auto___35454 + (1));
i__29159__auto___35454 = G__35455;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((3) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.dotimes.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29166__auto__);
});

cljs.core$macros.dotimes.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,bindings,body){
var i = cljs.core.first.call(null,bindings);
var n = cljs.core.second.call(null,bindings);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"n__35447__auto__","n__35447__auto__",-1199336687,null)),(function (){var x__28851__auto__ = n;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","loop","cljs.core$macros/loop",1731108390,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = i;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when","cljs.core$macros/when",328457725,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","<","cljs.core$macros/<",371512596,null)),(function (){var x__28851__auto__ = i;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"n__35447__auto__","n__35447__auto__",-1199336687,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),body,(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"recur","recur",1202958259,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","inc","cljs.core$macros/inc",876629257,null)),(function (){var x__28851__auto__ = i;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.dotimes.cljs$lang$maxFixedArity = (3);

cljs.core$macros.dotimes.cljs$lang$applyTo = (function (seq35448){
var G__35449 = cljs.core.first.call(null,seq35448);
var seq35448__$1 = cljs.core.next.call(null,seq35448);
var G__35450 = cljs.core.first.call(null,seq35448__$1);
var seq35448__$2 = cljs.core.next.call(null,seq35448__$1);
var G__35451 = cljs.core.first.call(null,seq35448__$2);
var seq35448__$3 = cljs.core.next.call(null,seq35448__$2);
return cljs.core$macros.dotimes.cljs$core$IFn$_invoke$arity$variadic(G__35449,G__35450,G__35451,seq35448__$3);
});

return null;
})()
;
cljs.core$macros.dotimes.cljs$lang$macro = true;

/**
 * Throws an exception if the given option map contains keys not listed
 *   as valid, else returns nil.
 */
cljs.core$macros.check_valid_options = (function cljs$core$macros$check_valid_options(var_args){
var args__29165__auto__ = [];
var len__29158__auto___35459 = arguments.length;
var i__29159__auto___35460 = (0);
while(true){
if((i__29159__auto___35460 < len__29158__auto___35459)){
args__29165__auto__.push((arguments[i__29159__auto___35460]));

var G__35461 = (i__29159__auto___35460 + (1));
i__29159__auto___35460 = G__35461;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((1) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((1)),(0),null)):null);
return cljs.core$macros.check_valid_options.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29166__auto__);
});

cljs.core$macros.check_valid_options.cljs$core$IFn$_invoke$arity$variadic = (function (options,valid_keys){
if(cljs.core.seq.call(null,cljs.core.apply.call(null,cljs.core.disj,cljs.core.apply.call(null,cljs.core.hash_set,cljs.core.keys.call(null,options)),valid_keys))){
throw cljs.core.apply.call(null,cljs.core.str,"Only these options are valid: ",cljs.core.first.call(null,valid_keys),cljs.core.map.call(null,(function (p1__35456_SHARP_){
return [", ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__35456_SHARP_)].join('');
}),cljs.core.rest.call(null,valid_keys)));
} else {
return null;
}
});

cljs.core$macros.check_valid_options.cljs$lang$maxFixedArity = (1);

cljs.core$macros.check_valid_options.cljs$lang$applyTo = (function (seq35457){
var G__35458 = cljs.core.first.call(null,seq35457);
var seq35457__$1 = cljs.core.next.call(null,seq35457);
return cljs.core$macros.check_valid_options.cljs$core$IFn$_invoke$arity$variadic(G__35458,seq35457__$1);
});

var ret__29198__auto___35471 = (function (){
/**
 * Creates a new multimethod with the associated dispatch function.
 *   The docstring and attribute-map are optional.
 * 
 *   Options are key-value pairs and may be one of:
 *  :default    the default dispatch value, defaults to :default
 *  :hierarchy  the isa? hierarchy to use for dispatching
 *              defaults to the global hierarchy
 */
cljs.core$macros.defmulti = (function cljs$core$macros$defmulti(var_args){
var args__29165__auto__ = [];
var len__29158__auto___35472 = arguments.length;
var i__29159__auto___35473 = (0);
while(true){
if((i__29159__auto___35473 < len__29158__auto___35472)){
args__29165__auto__.push((arguments[i__29159__auto___35473]));

var G__35474 = (i__29159__auto___35473 + (1));
i__29159__auto___35473 = G__35474;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((3) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.defmulti.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29166__auto__);
});

cljs.core$macros.defmulti.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,mm_name,options){
var docstring = ((typeof cljs.core.first.call(null,options) === 'string')?cljs.core.first.call(null,options):null);
var options__$1 = ((typeof cljs.core.first.call(null,options) === 'string')?cljs.core.next.call(null,options):options);
var m = ((cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,options__$1)))?cljs.core.first.call(null,options__$1):cljs.core.PersistentArrayMap.EMPTY);
var options__$2 = ((cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,options__$1)))?cljs.core.next.call(null,options__$1):options__$1);
var dispatch_fn = cljs.core.first.call(null,options__$2);
var options__$3 = cljs.core.next.call(null,options__$2);
var m__$1 = (cljs.core.truth_(docstring)?cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"doc","doc",1913296891),docstring):m);
var m__$2 = (cljs.core.truth_(cljs.core.meta.call(null,mm_name))?cljs.core.conj.call(null,cljs.core.meta.call(null,mm_name),m__$1):m__$1);
var mm_ns = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(_AMPERSAND_env)))].join('');
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,options__$3),(1))){
throw (new Error("The syntax for defmulti has changed. Example: (defmulti name dispatch-fn :default dispatch-value)"));
} else {
}

var options__$4 = cljs.core.apply.call(null,cljs.core.hash_map,options__$3);
var default$ = cljs.core.get.call(null,options__$4,new cljs.core.Keyword(null,"default","default",-1987822328),new cljs.core.Keyword(null,"default","default",-1987822328));
cljs.core$macros.check_valid_options.call(null,options__$4,new cljs.core.Keyword(null,"default","default",-1987822328),new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341));

return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","defonce","cljs.core$macros/defonce",-1096231613,null)),(function (){var x__28851__auto__ = cljs.core.with_meta.call(null,mm_name,m__$2);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"method-table__35462__auto__","method-table__35462__auto__",1208152588,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","atom","cljs.core/atom",1943839529,null)),(function (){var x__28851__auto__ = cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"prefer-table__35463__auto__","prefer-table__35463__auto__",274707569,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","atom","cljs.core/atom",1943839529,null)),(function (){var x__28851__auto__ = cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"method-cache__35464__auto__","method-cache__35464__auto__",853778556,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","atom","cljs.core/atom",1943839529,null)),(function (){var x__28851__auto__ = cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"cached-hierarchy__35465__auto__","cached-hierarchy__35465__auto__",1092570658,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","atom","cljs.core/atom",1943839529,null)),(function (){var x__28851__auto__ = cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"hierarchy__35466__auto__","hierarchy__35466__auto__",-231193839,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","get","cljs.core/get",-296075407,null)),(function (){var x__28851__auto__ = options__$4;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","get-global-hierarchy","cljs.core/get-global-hierarchy",48052871,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","MultiFn.","cljs.core/MultiFn.",1073941573,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","symbol","cljs.core/symbol",195265748,null)),(function (){var x__28851__auto__ = mm_ns;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.name.call(null,mm_name);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = dispatch_fn;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = default$;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"hierarchy__35466__auto__","hierarchy__35466__auto__",-231193839,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"method-table__35462__auto__","method-table__35462__auto__",1208152588,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"prefer-table__35463__auto__","prefer-table__35463__auto__",274707569,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"method-cache__35464__auto__","method-cache__35464__auto__",853778556,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"cached-hierarchy__35465__auto__","cached-hierarchy__35465__auto__",1092570658,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.defmulti.cljs$lang$maxFixedArity = (3);

cljs.core$macros.defmulti.cljs$lang$applyTo = (function (seq35467){
var G__35468 = cljs.core.first.call(null,seq35467);
var seq35467__$1 = cljs.core.next.call(null,seq35467);
var G__35469 = cljs.core.first.call(null,seq35467__$1);
var seq35467__$2 = cljs.core.next.call(null,seq35467__$1);
var G__35470 = cljs.core.first.call(null,seq35467__$2);
var seq35467__$3 = cljs.core.next.call(null,seq35467__$2);
return cljs.core$macros.defmulti.cljs$core$IFn$_invoke$arity$variadic(G__35468,G__35469,G__35470,seq35467__$3);
});

return null;
})()
;
cljs.core$macros.defmulti.cljs$lang$macro = true;

var ret__29198__auto___35480 = (function (){
/**
 * Creates and installs a new method of multimethod associated with dispatch-value. 
 */
cljs.core$macros.defmethod = (function cljs$core$macros$defmethod(var_args){
var args__29165__auto__ = [];
var len__29158__auto___35481 = arguments.length;
var i__29159__auto___35482 = (0);
while(true){
if((i__29159__auto___35482 < len__29158__auto___35481)){
args__29165__auto__.push((arguments[i__29159__auto___35482]));

var G__35483 = (i__29159__auto___35482 + (1));
i__29159__auto___35482 = G__35483;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((4) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((4)),(0),null)):null);
return cljs.core$macros.defmethod.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__29166__auto__);
});

cljs.core$macros.defmethod.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,multifn,dispatch_val,fn_tail){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-add-method","cljs.core/-add-method",571092113,null)),(function (){var x__28851__auto__ = cljs.core.with_meta.call(null,multifn,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core","MultiFn","cljs.core/MultiFn",1487419554,null)], null));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = dispatch_val;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),fn_tail)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.defmethod.cljs$lang$maxFixedArity = (4);

cljs.core$macros.defmethod.cljs$lang$applyTo = (function (seq35475){
var G__35476 = cljs.core.first.call(null,seq35475);
var seq35475__$1 = cljs.core.next.call(null,seq35475);
var G__35477 = cljs.core.first.call(null,seq35475__$1);
var seq35475__$2 = cljs.core.next.call(null,seq35475__$1);
var G__35478 = cljs.core.first.call(null,seq35475__$2);
var seq35475__$3 = cljs.core.next.call(null,seq35475__$2);
var G__35479 = cljs.core.first.call(null,seq35475__$3);
var seq35475__$4 = cljs.core.next.call(null,seq35475__$3);
return cljs.core$macros.defmethod.cljs$core$IFn$_invoke$arity$variadic(G__35476,G__35477,G__35478,G__35479,seq35475__$4);
});

return null;
})()
;
cljs.core$macros.defmethod.cljs$lang$macro = true;

var ret__29198__auto___35486 = /**
 * Evaluates expr and prints the time it took. Returns the value of expr.
 */
cljs.core$macros.time = (function cljs$core$macros$time(_AMPERSAND_form,_AMPERSAND_env,expr){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"start__35484__auto__","start__35484__auto__",-2092873186,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","system-time","cljs.core/system-time",1562011930,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"ret__35485__auto__","ret__35485__auto__",1306803656,null)),(function (){var x__28851__auto__ = expr;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","prn","cljs.core/prn",1725204552,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","str","cljs.core/str",-1971828991,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,"Elapsed time: "),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".toFixed",".toFixed",-895046938,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","-","cljs.core$macros/-",13526976,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","system-time","cljs.core/system-time",1562011930,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"start__35484__auto__","start__35484__auto__",-2092873186,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(6)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY," msecs"))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"ret__35485__auto__","ret__35485__auto__",1306803656,null)))));
});
cljs.core$macros.time.cljs$lang$macro = true;

var ret__29198__auto___35501 = (function (){
/**
 * Runs expr iterations times in the context of a let expression with
 *   the given bindings, then prints out the bindings and the expr
 *   followed by number of iterations and total time. The optional
 *   argument print-fn, defaulting to println, sets function used to
 *   print the result. expr's string representation will be produced
 *   using pr-str in any case.
 */
cljs.core$macros.simple_benchmark = (function cljs$core$macros$simple_benchmark(var_args){
var args__29165__auto__ = [];
var len__29158__auto___35502 = arguments.length;
var i__29159__auto___35503 = (0);
while(true){
if((i__29159__auto___35503 < len__29158__auto___35502)){
args__29165__auto__.push((arguments[i__29159__auto___35503]));

var G__35504 = (i__29159__auto___35503 + (1));
i__29159__auto___35503 = G__35504;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((5) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((5)),(0),null)):null);
return cljs.core$macros.simple_benchmark.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__29166__auto__);
});

cljs.core$macros.simple_benchmark.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,bindings,expr,iterations,p__35498){
var map__35499 = p__35498;
var map__35499__$1 = ((((!((map__35499 == null)))?((((map__35499.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35499.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35499):map__35499);
var print_fn = cljs.core.get.call(null,map__35499__$1,new cljs.core.Keyword(null,"print-fn","print-fn",-1720960489),new cljs.core.Symbol(null,"println","println",-733595439,null));
var bs_str = cljs.core.pr_str.call(null,bindings);
var expr_str = cljs.core.pr_str.call(null,expr);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = bindings;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"start__35487__auto__","start__35487__auto__",-2093947938,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".getTime",".getTime",-1048557777,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("js","Date.","js/Date.",384205255,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"ret__35488__auto__","ret__35488__auto__",489018827,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","dotimes","cljs.core$macros/dotimes",-1407597661,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"___35489__auto__","___35489__auto__",-1582096055,null)),(function (){var x__28851__auto__ = iterations;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = expr;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"end__35490__auto__","end__35490__auto__",-629043877,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".getTime",".getTime",-1048557777,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("js","Date.","js/Date.",384205255,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"elapsed__35491__auto__","elapsed__35491__auto__",-838265053,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","-","cljs.core$macros/-",13526976,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"end__35490__auto__","end__35490__auto__",-629043877,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"start__35487__auto__","start__35487__auto__",-2093947938,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = print_fn;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","str","cljs.core$macros/str",-2019499702,null)),(function (){var x__28851__auto__ = bs_str;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,", "),(function (){var x__28851__auto__ = expr_str;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,", "),(function (){var x__28851__auto__ = iterations;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY," runs, "),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"elapsed__35491__auto__","elapsed__35491__auto__",-838265053,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY," msecs"))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.simple_benchmark.cljs$lang$maxFixedArity = (5);

cljs.core$macros.simple_benchmark.cljs$lang$applyTo = (function (seq35492){
var G__35493 = cljs.core.first.call(null,seq35492);
var seq35492__$1 = cljs.core.next.call(null,seq35492);
var G__35494 = cljs.core.first.call(null,seq35492__$1);
var seq35492__$2 = cljs.core.next.call(null,seq35492__$1);
var G__35495 = cljs.core.first.call(null,seq35492__$2);
var seq35492__$3 = cljs.core.next.call(null,seq35492__$2);
var G__35496 = cljs.core.first.call(null,seq35492__$3);
var seq35492__$4 = cljs.core.next.call(null,seq35492__$3);
var G__35497 = cljs.core.first.call(null,seq35492__$4);
var seq35492__$5 = cljs.core.next.call(null,seq35492__$4);
return cljs.core$macros.simple_benchmark.cljs$core$IFn$_invoke$arity$variadic(G__35493,G__35494,G__35495,G__35496,G__35497,seq35492__$5);
});

return null;
})()
;
cljs.core$macros.simple_benchmark.cljs$lang$macro = true;

cljs.core$macros.cs = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.map.call(null,cljs.core.comp.call(null,cljs.core.gensym,cljs.core.str,cljs.core.char$),cljs.core.range.call(null,(97),(118))));
cljs.core$macros.gen_apply_to_helper = (function cljs$core$macros$gen_apply_to_helper(var_args){
var G__35506 = arguments.length;
switch (G__35506) {
case 0:
return cljs.core$macros.gen_apply_to_helper.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core$macros.gen_apply_to_helper.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core$macros.gen_apply_to_helper.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core$macros.gen_apply_to_helper.call(null,(1));
});

cljs.core$macros.gen_apply_to_helper.cljs$core$IFn$_invoke$arity$1 = (function (n){
if((n <= (20))){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = cljs.core$macros.cs.call(null,(n - (1)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-first","cljs.core/-first",545297391,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"args","args",-1338879193,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"args","args",-1338879193,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-rest","cljs.core/-rest",-1829241664,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"args","args",-1338879193,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","==","cljs.core$macros/==",-818551413,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"argc","argc",187692008,null)),(function (){var x__28851__auto__ = n;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"f","f",43394975,null)),cljs.core.take.call(null,n,cljs.core$macros.cs))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core$macros.gen_apply_to_helper.call(null,(n + (1)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"throw","throw",595905694,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("js","Error.","js/Error.",750655924,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,"Only up to 20 arguments supported on functions"))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
}
});

cljs.core$macros.gen_apply_to_helper.cljs$lang$maxFixedArity = 1;

var ret__29198__auto___35508 = cljs.core$macros.gen_apply_to = (function cljs$core$macros$gen_apply_to(_AMPERSAND_form,_AMPERSAND_env){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"*unchecked-if*","*unchecked-if*",1542408350,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,true))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","defn","cljs.core$macros/defn",-728332354,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"apply-to","apply-to",-1858571928,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"f","f",43394975,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"argc","argc",187692008,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"args","args",-1338879193,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"args","args",-1338879193,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","seq","cljs.core/seq",-1649497689,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"args","args",-1338879193,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","zero?","cljs.core$macros/zero?",-65998367,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"argc","argc",187692008,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"f","f",43394975,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core$macros.gen_apply_to_helper.call(null);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"*unchecked-if*","*unchecked-if*",1542408350,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,false))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
cljs.core$macros.gen_apply_to.cljs$lang$macro = true;

cljs.core$macros.gen_apply_to_simple_helper = (function cljs$core$macros$gen_apply_to_simple_helper(f,num_args,args){
var new_arg_sym = cljs.core.symbol.call(null,["a",cljs.core.str.cljs$core$IFn$_invoke$arity$1(num_args)].join(''));
var proto_name = ["cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1((num_args + (1)))].join('');
var proto_prop = cljs.core.symbol.call(null,[".-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(proto_name)].join(''));
var proto_inv = cljs.core.symbol.call(null,[".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(proto_name)].join(''));
var next_sym = cljs.core.symbol.call(null,["next_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(num_args)].join(''));
var all_args = cljs.core.mapv.call(null,((function (new_arg_sym,proto_name,proto_prop,proto_inv,next_sym){
return (function (p1__35509_SHARP_){
return cljs.core.symbol.call(null,["a",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__35509_SHARP_)].join(''));
});})(new_arg_sym,proto_name,proto_prop,proto_inv,next_sym))
,cljs.core.range.call(null,(num_args + (1))));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = new_arg_sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-first","cljs.core/-first",545297391,null)),(function (){var x__28851__auto__ = args;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = next_sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","next","cljs.core/next",-1291438473,null)),(function (){var x__28851__auto__ = args;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","nil?","cljs.core$macros/nil?",83624258,null)),(function (){var x__28851__auto__ = next_sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = proto_prop;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = f;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = proto_inv;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = f;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),all_args)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".call",".call",1496874263,null)),(function (){var x__28851__auto__ = f;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = f;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),all_args)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = ((((19) <= num_args))?cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"arr__35510__auto__","arr__35510__auto__",2092041683,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","array","cljs.core/array",486685886,null)),all_args)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","loop","cljs.core$macros/loop",1731108390,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"s__35511__auto__","s__35511__auto__",755904149,null)),(function (){var x__28851__auto__ = next_sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when","cljs.core$macros/when",328457725,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"s__35511__auto__","s__35511__auto__",755904149,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".push",".push",-1497267248,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"arr__35510__auto__","arr__35510__auto__",2092041683,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-first","cljs.core/-first",545297391,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"s__35511__auto__","s__35511__auto__",755904149,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"recur","recur",1202958259,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","next","cljs.core/next",-1291438473,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"s__35511__auto__","s__35511__auto__",755904149,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".apply",".apply",-1176201338,null)),(function (){var x__28851__auto__ = f;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = f;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"arr__35510__auto__","arr__35510__auto__",2092041683,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))):cljs.core$macros.gen_apply_to_simple_helper.call(null,f,(num_args + (1)),next_sym));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
var ret__29198__auto___35512 = cljs.core$macros.gen_apply_to_simple = (function cljs$core$macros$gen_apply_to_simple(_AMPERSAND_form,_AMPERSAND_env,f,num_args,args){
return cljs.core$macros.gen_apply_to_simple_helper.call(null,f,num_args,args);
});
cljs.core$macros.gen_apply_to_simple.cljs$lang$macro = true;

var ret__29198__auto___35518 = (function (){
/**
 * Evaluates exprs in a context in which *print-fn* is bound to .append
 *   on a fresh StringBuffer.  Returns the string created by any nested
 *   printing calls.
 */
cljs.core$macros.with_out_str = (function cljs$core$macros$with_out_str(var_args){
var args__29165__auto__ = [];
var len__29158__auto___35519 = arguments.length;
var i__29159__auto___35520 = (0);
while(true){
if((i__29159__auto___35520 < len__29158__auto___35519)){
args__29165__auto__.push((arguments[i__29159__auto___35520]));

var G__35521 = (i__29159__auto___35520 + (1));
i__29159__auto___35520 = G__35521;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((2) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.with_out_str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29166__auto__);
});

cljs.core$macros.with_out_str.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"sb__35513__auto__","sb__35513__auto__",491412802,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("js","goog.string.StringBuffer.","js/goog.string.StringBuffer.",-1043451650,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","binding","cljs.core$macros/binding",1855847304,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","*print-newline*","cljs.core/*print-newline*",6231625,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,true),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","*print-fn*","cljs.core/*print-fn*",1342365176,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"x__35514__auto__","x__35514__auto__",-1417373810,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".append",".append",1595439852,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"sb__35513__auto__","sb__35513__auto__",491412802,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"x__35514__auto__","x__35514__auto__",-1417373810,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),body)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","str","cljs.core/str",-1971828991,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"sb__35513__auto__","sb__35513__auto__",491412802,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.with_out_str.cljs$lang$maxFixedArity = (2);

cljs.core$macros.with_out_str.cljs$lang$applyTo = (function (seq35515){
var G__35516 = cljs.core.first.call(null,seq35515);
var seq35515__$1 = cljs.core.next.call(null,seq35515);
var G__35517 = cljs.core.first.call(null,seq35515__$1);
var seq35515__$2 = cljs.core.next.call(null,seq35515__$1);
return cljs.core$macros.with_out_str.cljs$core$IFn$_invoke$arity$variadic(G__35516,G__35517,seq35515__$2);
});

return null;
})()
;
cljs.core$macros.with_out_str.cljs$lang$macro = true;

var ret__29198__auto___35526 = (function (){
/**
 * Expands to code which yields a lazy sequence of the concatenation
 *   of the supplied colls.  Each coll expr is not evaluated until it is
 *   needed.
 * 
 *   (lazy-cat xs ys zs) === (concat (lazy-seq xs) (lazy-seq ys) (lazy-seq zs))
 */
cljs.core$macros.lazy_cat = (function cljs$core$macros$lazy_cat(var_args){
var args__29165__auto__ = [];
var len__29158__auto___35527 = arguments.length;
var i__29159__auto___35528 = (0);
while(true){
if((i__29159__auto___35528 < len__29158__auto___35527)){
args__29165__auto__.push((arguments[i__29159__auto___35528]));

var G__35529 = (i__29159__auto___35528 + (1));
i__29159__auto___35528 = G__35529;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((2) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.lazy_cat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29166__auto__);
});

cljs.core$macros.lazy_cat.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,colls){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","concat","cljs.core/concat",-1133584918,null)),cljs.core.map.call(null,(function (p1__35522_SHARP_){
return cljs.core._conj.call(null,(function (){var x__28851__auto__ = p1__35522_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),new cljs.core.Symbol("cljs.core$macros","lazy-seq","cljs.core$macros/lazy-seq",806482650,null));
}),colls))));
});

cljs.core$macros.lazy_cat.cljs$lang$maxFixedArity = (2);

cljs.core$macros.lazy_cat.cljs$lang$applyTo = (function (seq35523){
var G__35524 = cljs.core.first.call(null,seq35523);
var seq35523__$1 = cljs.core.next.call(null,seq35523);
var G__35525 = cljs.core.first.call(null,seq35523__$1);
var seq35523__$2 = cljs.core.next.call(null,seq35523__$1);
return cljs.core$macros.lazy_cat.cljs$core$IFn$_invoke$arity$variadic(G__35524,G__35525,seq35523__$2);
});

return null;
})()
;
cljs.core$macros.lazy_cat.cljs$lang$macro = true;

var ret__29198__auto___35530 = cljs.core$macros.js_str = (function cljs$core$macros$js_str(_AMPERSAND_form,_AMPERSAND_env,s){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__28851__auto__ = s;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),"''+~{}"),new cljs.core.Symbol(null,"js*","js*",-1134233646,null));
});
cljs.core$macros.js_str.cljs$lang$macro = true;

var ret__29198__auto___35532 = cljs.core$macros.es6_iterable = (function cljs$core$macros$es6_iterable(_AMPERSAND_form,_AMPERSAND_env,ty){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("goog.object","set","goog.object/set",-2123361230,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".-prototype",".-prototype",-1562038608,null)),(function (){var x__28851__auto__ = ty;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","ITER_SYMBOL","cljs.core/ITER_SYMBOL",-2091399233,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","this-as","cljs.core$macros/this-as",-799075148,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__35531__auto__","this__35531__auto__",1823443,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","es6-iterator","cljs.core/es6-iterator",856007913,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"this__35531__auto__","this__35531__auto__",1823443,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
cljs.core$macros.es6_iterable.cljs$lang$macro = true;

var ret__29198__auto___35549 = /**
 * Returns a map of the public intern mappings for the namespace.
 */
cljs.core$macros.ns_publics = (function cljs$core$macros$ns_publics(_AMPERSAND_form,_AMPERSAND_env,quoted_ns){
if((cljs.core.seq_QMARK_.call(null,quoted_ns)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,quoted_ns),new cljs.core.Symbol(null,"quote","quote",1377916282,null))) && ((cljs.core.second.call(null,quoted_ns) instanceof cljs.core.Symbol))){
} else {
throw (new Error(["Assert failed: ","Argument to ns-publics must be a quoted symbol","\n","(core/and (seq? quoted-ns) (= (first quoted-ns) (quote quote)) (core/symbol? (second quoted-ns)))"].join('')));
}

var ns = cljs.core.second.call(null,quoted_ns);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","into","cljs.core/into",1879938733,null)),(function (){var x__28851__auto__ = cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core.map.call(null,((function (ns){
return (function (p__35541){
var vec__35542 = p__35541;
var sym = cljs.core.nth.call(null,vec__35542,(0),null);
var _ = cljs.core.nth.call(null,vec__35542,(1),null);
return cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","symbol","cljs.core/symbol",195265748,null)),(function (){var x__28851__auto__ = cljs.core.name.call(null,sym);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"var","var",870848730,null)),(function (){var x__28851__auto__ = cljs.core.symbol.call(null,cljs.core.name.call(null,ns),cljs.core.name.call(null,sym));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
});})(ns))
,cljs.core.filter.call(null,((function (ns){
return (function (p__35545){
var vec__35546 = p__35545;
var _ = cljs.core.nth.call(null,vec__35546,(0),null);
var info = cljs.core.nth.call(null,vec__35546,(1),null);
return cljs.core.not.call(null,new cljs.core.Keyword(null,"private","private",-558947994).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(info)));
});})(ns))
,cljs.core.get_in.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927),ns,new cljs.core.Keyword(null,"defs","defs",1398449717)], null))))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
cljs.core$macros.ns_publics.cljs$lang$macro = true;

var ret__29198__auto___35558 = /**
 * Returns a map of the import mappings for the namespace.
 */
cljs.core$macros.ns_imports = (function cljs$core$macros$ns_imports(_AMPERSAND_form,_AMPERSAND_env,quoted_ns){
if((cljs.core.seq_QMARK_.call(null,quoted_ns)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,quoted_ns),new cljs.core.Symbol(null,"quote","quote",1377916282,null))) && ((cljs.core.second.call(null,quoted_ns) instanceof cljs.core.Symbol))){
} else {
throw (new Error(["Assert failed: ","Argument to ns-imports must be a quoted symbol","\n","(core/and (seq? quoted-ns) (= (first quoted-ns) (quote quote)) (core/symbol? (second quoted-ns)))"].join('')));
}

var ns = cljs.core.second.call(null,quoted_ns);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","into","cljs.core/into",1879938733,null)),(function (){var x__28851__auto__ = cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core.map.call(null,((function (ns){
return (function (p__35554){
var vec__35555 = p__35554;
var ctor = cljs.core.nth.call(null,vec__35555,(0),null);
var qualified_ctor = cljs.core.nth.call(null,vec__35555,(1),null);
return cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","symbol","cljs.core/symbol",195265748,null)),(function (){var x__28851__auto__ = cljs.core.name.call(null,ctor);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.symbol.call(null,qualified_ctor);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
});})(ns))
,cljs.core.get_in.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927),ns,new cljs.core.Keyword(null,"imports","imports",-1249933394)], null)))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
cljs.core$macros.ns_imports.cljs$lang$macro = true;

var ret__29198__auto___35567 = /**
 * Returns a map of the intern mappings for the namespace.
 */
cljs.core$macros.ns_interns = (function cljs$core$macros$ns_interns(_AMPERSAND_form,_AMPERSAND_env,quoted_ns){
if((cljs.core.seq_QMARK_.call(null,quoted_ns)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,quoted_ns),new cljs.core.Symbol(null,"quote","quote",1377916282,null))) && ((cljs.core.second.call(null,quoted_ns) instanceof cljs.core.Symbol))){
} else {
throw (new Error(["Assert failed: ","Argument to ns-interns must be a quoted symbol","\n","(core/and (seq? quoted-ns) (= (first quoted-ns) (quote quote)) (core/symbol? (second quoted-ns)))"].join('')));
}

var ns = cljs.core.second.call(null,quoted_ns);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","into","cljs.core/into",1879938733,null)),(function (){var x__28851__auto__ = cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core.map.call(null,((function (ns){
return (function (p__35563){
var vec__35564 = p__35563;
var sym = cljs.core.nth.call(null,vec__35564,(0),null);
var _ = cljs.core.nth.call(null,vec__35564,(1),null);
return cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","symbol","cljs.core/symbol",195265748,null)),(function (){var x__28851__auto__ = cljs.core.name.call(null,sym);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"var","var",870848730,null)),(function (){var x__28851__auto__ = cljs.core.symbol.call(null,cljs.core.name.call(null,ns),cljs.core.name.call(null,sym));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
});})(ns))
,cljs.core.get_in.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927),ns,new cljs.core.Keyword(null,"defs","defs",1398449717)], null)))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
cljs.core$macros.ns_interns.cljs$lang$macro = true;

var ret__29198__auto___35568 = /**
 * Removes the mappings for the symbol from the namespace.
 */
cljs.core$macros.ns_unmap = (function cljs$core$macros$ns_unmap(_AMPERSAND_form,_AMPERSAND_env,quoted_ns,quoted_sym){
if((cljs.core.seq_QMARK_.call(null,quoted_ns)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,quoted_ns),new cljs.core.Symbol(null,"quote","quote",1377916282,null))) && ((cljs.core.second.call(null,quoted_ns) instanceof cljs.core.Symbol)) && (cljs.core.seq_QMARK_.call(null,quoted_sym)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,quoted_sym),new cljs.core.Symbol(null,"quote","quote",1377916282,null))) && ((cljs.core.second.call(null,quoted_sym) instanceof cljs.core.Symbol))){
} else {
throw (new Error(["Assert failed: ","Arguments to ns-unmap must be quoted symbols","\n","(core/and (seq? quoted-ns) (= (first quoted-ns) (quote quote)) (core/symbol? (second quoted-ns)) (seq? quoted-sym) (= (first quoted-sym) (quote quote)) (core/symbol? (second quoted-sym)))"].join('')));
}

var ns = cljs.core.second.call(null,quoted_ns);
var sym = cljs.core.second.call(null,quoted_sym);
cljs.core.swap_BANG_.call(null,cljs.env._STAR_compiler_STAR_,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927),ns,new cljs.core.Keyword(null,"defs","defs",1398449717)], null),cljs.core.dissoc,sym);

return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","js-delete","cljs.core$macros/js-delete",387769082,null)),(function (){var x__28851__auto__ = cljs.compiler.munge.call(null,ns);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.compiler.munge.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(sym)].join(''));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
cljs.core$macros.ns_unmap.cljs$lang$macro = true;

var ret__29198__auto___35574 = (function (){
/**
 * Non-atomically swaps the value of the volatile as if:
 * (apply f current-value-of-vol args). Returns the value that
 * was swapped in.
 */
cljs.core$macros.vswap_BANG_ = (function cljs$core$macros$vswap_BANG_(var_args){
var args__29165__auto__ = [];
var len__29158__auto___35575 = arguments.length;
var i__29159__auto___35576 = (0);
while(true){
if((i__29159__auto___35576 < len__29158__auto___35575)){
args__29165__auto__.push((arguments[i__29159__auto___35576]));

var G__35577 = (i__29159__auto___35576 + (1));
i__29159__auto___35576 = G__35577;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((4) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((4)),(0),null)):null);
return cljs.core$macros.vswap_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__29166__auto__);
});

cljs.core$macros.vswap_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,vol,f,args){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-vreset!","cljs.core/-vreset!",-1186516972,null)),(function (){var x__28851__auto__ = vol;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = f;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","-deref","cljs.core/-deref",-1260480154,null)),(function (){var x__28851__auto__ = vol;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),args)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.vswap_BANG_.cljs$lang$maxFixedArity = (4);

cljs.core$macros.vswap_BANG_.cljs$lang$applyTo = (function (seq35569){
var G__35570 = cljs.core.first.call(null,seq35569);
var seq35569__$1 = cljs.core.next.call(null,seq35569);
var G__35571 = cljs.core.first.call(null,seq35569__$1);
var seq35569__$2 = cljs.core.next.call(null,seq35569__$1);
var G__35572 = cljs.core.first.call(null,seq35569__$2);
var seq35569__$3 = cljs.core.next.call(null,seq35569__$2);
var G__35573 = cljs.core.first.call(null,seq35569__$3);
var seq35569__$4 = cljs.core.next.call(null,seq35569__$3);
return cljs.core$macros.vswap_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__35570,G__35571,G__35572,G__35573,seq35569__$4);
});

return null;
})()
;
cljs.core$macros.vswap_BANG_.cljs$lang$macro = true;

var ret__29198__auto___35582 = (function (){
cljs.core$macros.locking = (function cljs$core$macros$locking(var_args){
var args__29165__auto__ = [];
var len__29158__auto___35583 = arguments.length;
var i__29159__auto___35584 = (0);
while(true){
if((i__29159__auto___35584 < len__29158__auto___35583)){
args__29165__auto__.push((arguments[i__29159__auto___35584]));

var G__35585 = (i__29159__auto___35584 + (1));
i__29159__auto___35584 = G__35585;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((3) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.locking.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29166__auto__);
});

cljs.core$macros.locking.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,forms){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),forms)));
});

cljs.core$macros.locking.cljs$lang$maxFixedArity = (3);

cljs.core$macros.locking.cljs$lang$applyTo = (function (seq35578){
var G__35579 = cljs.core.first.call(null,seq35578);
var seq35578__$1 = cljs.core.next.call(null,seq35578);
var G__35580 = cljs.core.first.call(null,seq35578__$1);
var seq35578__$2 = cljs.core.next.call(null,seq35578__$1);
var G__35581 = cljs.core.first.call(null,seq35578__$2);
var seq35578__$3 = cljs.core.next.call(null,seq35578__$2);
return cljs.core$macros.locking.cljs$core$IFn$_invoke$arity$variadic(G__35579,G__35580,G__35581,seq35578__$3);
});

return null;
})()
;
cljs.core$macros.locking.cljs$lang$macro = true;

var ret__29198__auto___35589 = (function (){
/**
 * Loads libs, skipping any that are already loaded. Each argument is
 *   either a libspec that identifies a lib or a flag that modifies how all the identified
 *   libs are loaded. Use :require in the ns macro in preference to calling this
 *   directly.
 * 
 *   Libs
 * 
 *   A 'lib' is a named set of resources in classpath whose contents define a
 *   library of ClojureScript code. Lib names are symbols and each lib is associated
 *   with a ClojureScript namespace. A lib's name also locates its root directory
 *   within classpath using Java's package name to classpath-relative path mapping.
 *   All resources in a lib should be contained in the directory structure under its
 *   root directory. All definitions a lib makes should be in its associated namespace.
 * 
 *   'require loads a lib by loading its root resource. The root resource path
 *   is derived from the lib name in the following manner:
 *   Consider a lib named by the symbol 'x.y.z; it has the root directory
 *   <classpath>/x/y/, and its root resource is <classpath>/x/y/z.clj. The root
 *   resource should contain code to create the lib's namespace (usually by using
 *   the ns macro) and load any additional lib resources.
 * 
 *   Libspecs
 * 
 *   A libspec is a lib name or a vector containing a lib name followed by
 *   options expressed as sequential keywords and arguments.
 * 
 *   Recognized options:
 *   :as takes a symbol as its argument and makes that symbol an alias to the
 *  lib's namespace in the current namespace.
 *   :refer takes a list of symbols to refer from the namespace.
 *   :refer-macros takes a list of macro symbols to refer from the namespace.
 *   :include-macros true causes macros from the namespace to be required.
 *   :rename specifies a map from referred var names to different
 *  symbols (and can be used to prevent clashes)
 * 
 * 
 *   Flags
 * 
 *   A flag is a keyword.
 *   Recognized flags: :reload, :reload-all, :verbose
 *   :reload forces loading of all the identified libs even if they are
 *  already loaded
 *   :reload-all implies :reload and also forces loading of all libs that the
 *  identified libs directly or indirectly load via require or use
 *   :verbose triggers printing information about each load, alias, and refer
 * 
 *   Example:
 * 
 *   The following would load the library clojure.string :as string.
 * 
 *   (require '[clojure.string :as string])
 */
cljs.core$macros.require = (function cljs$core$macros$require(var_args){
var args__29165__auto__ = [];
var len__29158__auto___35590 = arguments.length;
var i__29159__auto___35591 = (0);
while(true){
if((i__29159__auto___35591 < len__29158__auto___35590)){
args__29165__auto__.push((arguments[i__29159__auto___35591]));

var G__35592 = (i__29159__auto___35591 + (1));
i__29159__auto___35591 = G__35592;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((2) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.require.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29166__auto__);
});

cljs.core$macros.require.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,args){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"ns*","ns*",1840949383,null)),(function (){var x__28851__auto__ = cljs.core.cons.call(null,new cljs.core.Keyword(null,"require","require",-468001333),args);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.require.cljs$lang$maxFixedArity = (2);

cljs.core$macros.require.cljs$lang$applyTo = (function (seq35586){
var G__35587 = cljs.core.first.call(null,seq35586);
var seq35586__$1 = cljs.core.next.call(null,seq35586);
var G__35588 = cljs.core.first.call(null,seq35586__$1);
var seq35586__$2 = cljs.core.next.call(null,seq35586__$1);
return cljs.core$macros.require.cljs$core$IFn$_invoke$arity$variadic(G__35587,G__35588,seq35586__$2);
});

return null;
})()
;
cljs.core$macros.require.cljs$lang$macro = true;

var ret__29198__auto___35596 = (function (){
/**
 * Similar to require but only for macros.
 */
cljs.core$macros.require_macros = (function cljs$core$macros$require_macros(var_args){
var args__29165__auto__ = [];
var len__29158__auto___35597 = arguments.length;
var i__29159__auto___35598 = (0);
while(true){
if((i__29159__auto___35598 < len__29158__auto___35597)){
args__29165__auto__.push((arguments[i__29159__auto___35598]));

var G__35599 = (i__29159__auto___35598 + (1));
i__29159__auto___35598 = G__35599;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((2) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.require_macros.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29166__auto__);
});

cljs.core$macros.require_macros.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,args){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"ns*","ns*",1840949383,null)),(function (){var x__28851__auto__ = cljs.core.cons.call(null,new cljs.core.Keyword(null,"require-macros","require-macros",707947416),args);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.require_macros.cljs$lang$maxFixedArity = (2);

cljs.core$macros.require_macros.cljs$lang$applyTo = (function (seq35593){
var G__35594 = cljs.core.first.call(null,seq35593);
var seq35593__$1 = cljs.core.next.call(null,seq35593);
var G__35595 = cljs.core.first.call(null,seq35593__$1);
var seq35593__$2 = cljs.core.next.call(null,seq35593__$1);
return cljs.core$macros.require_macros.cljs$core$IFn$_invoke$arity$variadic(G__35594,G__35595,seq35593__$2);
});

return null;
})()
;
cljs.core$macros.require_macros.cljs$lang$macro = true;

var ret__29198__auto___35603 = (function (){
/**
 * Like require, but referring vars specified by the mandatory
 *   :only option.
 * 
 *   Example:
 * 
 *   The following would load the library clojure.set while referring
 *   the intersection var.
 * 
 *   (use '[clojure.set :only [intersection]])
 */
cljs.core$macros.use = (function cljs$core$macros$use(var_args){
var args__29165__auto__ = [];
var len__29158__auto___35604 = arguments.length;
var i__29159__auto___35605 = (0);
while(true){
if((i__29159__auto___35605 < len__29158__auto___35604)){
args__29165__auto__.push((arguments[i__29159__auto___35605]));

var G__35606 = (i__29159__auto___35605 + (1));
i__29159__auto___35605 = G__35606;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((2) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.use.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29166__auto__);
});

cljs.core$macros.use.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,args){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"ns*","ns*",1840949383,null)),(function (){var x__28851__auto__ = cljs.core.cons.call(null,new cljs.core.Keyword(null,"use","use",-1846382424),args);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.use.cljs$lang$maxFixedArity = (2);

cljs.core$macros.use.cljs$lang$applyTo = (function (seq35600){
var G__35601 = cljs.core.first.call(null,seq35600);
var seq35600__$1 = cljs.core.next.call(null,seq35600);
var G__35602 = cljs.core.first.call(null,seq35600__$1);
var seq35600__$2 = cljs.core.next.call(null,seq35600__$1);
return cljs.core$macros.use.cljs$core$IFn$_invoke$arity$variadic(G__35601,G__35602,seq35600__$2);
});

return null;
})()
;
cljs.core$macros.use.cljs$lang$macro = true;

var ret__29198__auto___35610 = (function (){
/**
 * Similar to use but only for macros.
 */
cljs.core$macros.use_macros = (function cljs$core$macros$use_macros(var_args){
var args__29165__auto__ = [];
var len__29158__auto___35611 = arguments.length;
var i__29159__auto___35612 = (0);
while(true){
if((i__29159__auto___35612 < len__29158__auto___35611)){
args__29165__auto__.push((arguments[i__29159__auto___35612]));

var G__35613 = (i__29159__auto___35612 + (1));
i__29159__auto___35612 = G__35613;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((2) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.use_macros.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29166__auto__);
});

cljs.core$macros.use_macros.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,args){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"ns*","ns*",1840949383,null)),(function (){var x__28851__auto__ = cljs.core.cons.call(null,new cljs.core.Keyword(null,"use-macros","use-macros",-905638393),args);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.use_macros.cljs$lang$maxFixedArity = (2);

cljs.core$macros.use_macros.cljs$lang$applyTo = (function (seq35607){
var G__35608 = cljs.core.first.call(null,seq35607);
var seq35607__$1 = cljs.core.next.call(null,seq35607);
var G__35609 = cljs.core.first.call(null,seq35607__$1);
var seq35607__$2 = cljs.core.next.call(null,seq35607__$1);
return cljs.core$macros.use_macros.cljs$core$IFn$_invoke$arity$variadic(G__35608,G__35609,seq35607__$2);
});

return null;
})()
;
cljs.core$macros.use_macros.cljs$lang$macro = true;

var ret__29198__auto___35617 = (function (){
/**
 * import-list => (closure-namespace constructor-name-symbols*)
 * 
 *   For each name in constructor-name-symbols, adds a mapping from name to the
 *   constructor named by closure-namespace to the current namespace. Use :import in the ns
 *   macro in preference to calling this directly.
 */
cljs.core$macros.import$ = (function cljs$core$macros$import(var_args){
var args__29165__auto__ = [];
var len__29158__auto___35618 = arguments.length;
var i__29159__auto___35619 = (0);
while(true){
if((i__29159__auto___35619 < len__29158__auto___35618)){
args__29165__auto__.push((arguments[i__29159__auto___35619]));

var G__35620 = (i__29159__auto___35619 + (1));
i__29159__auto___35619 = G__35620;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((2) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.import$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29166__auto__);
});

cljs.core$macros.import$.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,import_symbols_or_lists){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"ns*","ns*",1840949383,null)),(function (){var x__28851__auto__ = cljs.core.cons.call(null,new cljs.core.Keyword(null,"import","import",-1399500709),import_symbols_or_lists);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.import$.cljs$lang$maxFixedArity = (2);

cljs.core$macros.import$.cljs$lang$applyTo = (function (seq35614){
var G__35615 = cljs.core.first.call(null,seq35614);
var seq35614__$1 = cljs.core.next.call(null,seq35614);
var G__35616 = cljs.core.first.call(null,seq35614__$1);
var seq35614__$2 = cljs.core.next.call(null,seq35614__$1);
return cljs.core$macros.import$.cljs$core$IFn$_invoke$arity$variadic(G__35615,G__35616,seq35614__$2);
});

return null;
})()
;
cljs.core$macros.import$.cljs$lang$macro = true;

var ret__29198__auto___35624 = (function (){
/**
 * Refers to all the public vars of `cljs.core`, subject to
 *   filters.
 *   Filters can include at most one each of:
 * 
 *   :exclude list-of-symbols
 *   :rename map-of-fromsymbol-tosymbol
 * 
 *   Filters can be used to select a subset, via exclusion, or to provide a mapping
 *   to a symbol different from the var's name, in order to prevent clashes.
 */
cljs.core$macros.refer_clojure = (function cljs$core$macros$refer_clojure(var_args){
var args__29165__auto__ = [];
var len__29158__auto___35625 = arguments.length;
var i__29159__auto___35626 = (0);
while(true){
if((i__29159__auto___35626 < len__29158__auto___35625)){
args__29165__auto__.push((arguments[i__29159__auto___35626]));

var G__35627 = (i__29159__auto___35626 + (1));
i__29159__auto___35626 = G__35627;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((2) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((2)),(0),null)):null);
return cljs.core$macros.refer_clojure.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29166__auto__);
});

cljs.core$macros.refer_clojure.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,args){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"ns*","ns*",1840949383,null)),(function (){var x__28851__auto__ = cljs.core.cons.call(null,new cljs.core.Keyword(null,"refer-clojure","refer-clojure",813784440),args);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.refer_clojure.cljs$lang$maxFixedArity = (2);

cljs.core$macros.refer_clojure.cljs$lang$applyTo = (function (seq35621){
var G__35622 = cljs.core.first.call(null,seq35621);
var seq35621__$1 = cljs.core.next.call(null,seq35621);
var G__35623 = cljs.core.first.call(null,seq35621__$1);
var seq35621__$2 = cljs.core.next.call(null,seq35621__$1);
return cljs.core$macros.refer_clojure.cljs$core$IFn$_invoke$arity$variadic(G__35622,G__35623,seq35621__$2);
});

return null;
})()
;
cljs.core$macros.refer_clojure.cljs$lang$macro = true;

var ret__29198__auto___35628 = cljs.core$macros.load_file_STAR_ = (function cljs$core$macros$load_file_STAR_(_AMPERSAND_form,_AMPERSAND_env,f){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("js","goog","js/goog",-70605150,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"nodeGlobalRequire","nodeGlobalRequire",167018599,null)),(function (){var x__28851__auto__ = f;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
cljs.core$macros.load_file_STAR_.cljs$lang$macro = true;

var ret__29198__auto___35629 = /**
 * If form represents a macro form, returns its expansion,
 *   else returns form.
 */
cljs.core$macros.macroexpand_1 = (function cljs$core$macros$macroexpand_1(_AMPERSAND_form,_AMPERSAND_env,quoted){
if(cljs.core._EQ_.call(null,cljs.core.first.call(null,quoted),new cljs.core.Symbol(null,"quote","quote",1377916282,null))){
} else {
throw (new Error(["Assert failed: ","Argument to macroexpand-1 must be quoted","\n","(core/= (core/first quoted) (quote quote))"].join('')));
}

var form = cljs.core.second.call(null,quoted);
if(cljs.core.seq_QMARK_.call(null,form)){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"quote","quote",1377916282,null)),(function (){var x__28851__auto__ = cljs.analyzer.macroexpand_1.call(null,_AMPERSAND_env,form);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
} else {
return form;
}
});
cljs.core$macros.macroexpand_1.cljs$lang$macro = true;

var ret__29198__auto___35630 = /**
 * Repeatedly calls macroexpand-1 on form until it no longer
 *   represents a macro form, then returns it.  Note neither
 *   macroexpand-1 nor macroexpand expand macros in subforms.
 */
cljs.core$macros.macroexpand = (function cljs$core$macros$macroexpand(_AMPERSAND_form,_AMPERSAND_env,quoted){
if(cljs.core._EQ_.call(null,cljs.core.first.call(null,quoted),new cljs.core.Symbol(null,"quote","quote",1377916282,null))){
} else {
throw (new Error(["Assert failed: ","Argument to macroexpand must be quoted","\n","(core/= (core/first quoted) (quote quote))"].join('')));
}

var form = cljs.core.second.call(null,quoted);
var env = _AMPERSAND_env;
if(cljs.core.seq_QMARK_.call(null,form)){
var form__$1 = form;
var form_SINGLEQUOTE_ = cljs.analyzer.macroexpand_1.call(null,env,form__$1);
while(true){
if(!((form__$1 === form_SINGLEQUOTE_))){
var G__35631 = form_SINGLEQUOTE_;
var G__35632 = cljs.analyzer.macroexpand_1.call(null,env,form_SINGLEQUOTE_);
form__$1 = G__35631;
form_SINGLEQUOTE_ = G__35632;
continue;
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"quote","quote",1377916282,null)),(function (){var x__28851__auto__ = form_SINGLEQUOTE_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
}
break;
}
} else {
return form;
}
});
cljs.core$macros.macroexpand.cljs$lang$macro = true;

cljs.core$macros.multi_arity_fn_QMARK_ = (function cljs$core$macros$multi_arity_fn_QMARK_(fdecl){
return ((1) < cljs.core.count.call(null,fdecl));
});
cljs.core$macros.variadic_fn_QMARK_ = (function cljs$core$macros$variadic_fn_QMARK_(fdecl){
var and__27977__auto__ = cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,fdecl));
if(and__27977__auto__){
return cljs.core.some.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"&","&",-2144855648,null),null], null), null),cljs.core.ffirst.call(null,fdecl));
} else {
return and__27977__auto__;
}
});
cljs.core$macros.variadic_fn_STAR_ = (function cljs$core$macros$variadic_fn_STAR_(var_args){
var G__35634 = arguments.length;
switch (G__35634) {
case 2:
return cljs.core$macros.variadic_fn_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core$macros.variadic_fn_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core$macros.variadic_fn_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (sym,method){
return cljs.core$macros.variadic_fn_STAR_.call(null,sym,method,true);
});

cljs.core$macros.variadic_fn_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (sym,p__35635,solo){
var vec__35636 = p__35635;
var seq__35637 = cljs.core.seq.call(null,vec__35636);
var first__35638 = cljs.core.first.call(null,seq__35637);
var seq__35637__$1 = cljs.core.next.call(null,seq__35637);
var arglist = first__35638;
var body = seq__35637__$1;
var method = vec__35636;
var sig = cljs.core.remove.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"&","&",-2144855648,null),null], null), null),arglist);
var restarg = cljs.core.gensym.call(null,"seq");
var get_delegate = ((function (sig,restarg,vec__35636,seq__35637,first__35638,seq__35637__$1,arglist,body,method){
return (function cljs$core$macros$get_delegate(){
return new cljs.core.Symbol(null,"cljs$core$IFn$_invoke$arity$variadic","cljs$core$IFn$_invoke$arity$variadic",-378825034,null);
});})(sig,restarg,vec__35636,seq__35637,first__35638,seq__35637__$1,arglist,body,method))
;
var get_delegate_prop = ((function (sig,restarg,vec__35636,seq__35637,first__35638,seq__35637__$1,arglist,body,method){
return (function cljs$core$macros$get_delegate_prop(){
return cljs.core.symbol.call(null,["-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(get_delegate.call(null))].join(''));
});})(sig,restarg,vec__35636,seq__35637,first__35638,seq__35637__$1,arglist,body,method))
;
var param_bind = ((function (sig,restarg,vec__35636,seq__35637,first__35638,seq__35637__$1,arglist,body,method){
return (function cljs$core$macros$param_bind(param){
return cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = param;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = cljs.core.with_meta.call(null,new cljs.core.Symbol("cljs.core","first","cljs.core/first",-752535972,null),cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"file","file",-1269645878)),cljs.core._conj.call(null,cljs.core.List.EMPTY,"/Users/prepor/work/orcl-open/backend-naive/resources/public/js/out/cljs/core.cljc"),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"line","line",212345235)),cljs.core._conj.call(null,cljs.core.List.EMPTY,2997),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"column","column",2078222095)),cljs.core._conj.call(null,cljs.core.List.EMPTY,49),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"end-line","end-line",1837326455)),cljs.core._conj.call(null,cljs.core.List.EMPTY,2997),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"end-column","end-column",1425389514)),cljs.core._conj.call(null,cljs.core.List.EMPTY,54),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017)),cljs.core._conj.call(null,cljs.core.List.EMPTY,true))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = restarg;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = restarg;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = cljs.core.with_meta.call(null,new cljs.core.Symbol("cljs.core","next","cljs.core/next",-1291438473,null),cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"file","file",-1269645878)),cljs.core._conj.call(null,cljs.core.List.EMPTY,"/Users/prepor/work/orcl-open/backend-naive/resources/public/js/out/cljs/core.cljc"),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"line","line",212345235)),cljs.core._conj.call(null,cljs.core.List.EMPTY,2998),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"column","column",2078222095)),cljs.core._conj.call(null,cljs.core.List.EMPTY,51),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"end-line","end-line",1837326455)),cljs.core._conj.call(null,cljs.core.List.EMPTY,2998),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"end-column","end-column",1425389514)),cljs.core._conj.call(null,cljs.core.List.EMPTY,55),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017)),cljs.core._conj.call(null,cljs.core.List.EMPTY,true))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = restarg;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
});})(sig,restarg,vec__35636,seq__35637,first__35638,seq__35637__$1,arglist,body,method))
;
var apply_to = ((function (sig,restarg,vec__35636,seq__35637,first__35638,seq__35637__$1,arglist,body,method){
return (function cljs$core$macros$apply_to(){
if(((1) < cljs.core.count.call(null,sig))){
var params = cljs.core.repeatedly.call(null,(cljs.core.count.call(null,sig) - (1)),cljs.core.gensym);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = restarg;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core.mapcat.call(null,param_bind,params)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__28851__auto__ = sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = get_delegate.call(null);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),params,(function (){var x__28851__auto__ = restarg;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = restarg;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__28851__auto__ = sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = get_delegate.call(null);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","seq","cljs.core/seq",-1649497689,null)),(function (){var x__28851__auto__ = restarg;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
}
});})(sig,restarg,vec__35636,seq__35637,first__35638,seq__35637__$1,arglist,body,method))
;
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__28851__auto__ = sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = get_delegate_prop.call(null);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = cljs.core.vec.call(null,sig);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),body)));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(cljs.core.truth_(solo)?cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__28851__auto__ = sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-cljs$lang$maxFixedArity","-cljs$lang$maxFixedArity",-1481434279,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = (cljs.core.count.call(null,sig) - (1));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())))):null),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__28851__auto__ = sym;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-cljs$lang$applyTo","-cljs$lang$applyTo",-225535181,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = apply_to.call(null);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});

cljs.core$macros.variadic_fn_STAR_.cljs$lang$maxFixedArity = 3;

var ret__29198__auto___35642 = cljs.core$macros.copy_arguments = (function cljs$core$macros$copy_arguments(_AMPERSAND_form,_AMPERSAND_env,dest){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"len__35640__auto__","len__35640__auto__",-1358280060,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","alength","cljs.core$macros/alength",-683052937,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","js-arguments","cljs.core$macros/js-arguments",390128540,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","loop","cljs.core$macros/loop",1731108390,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"i__35641__auto__","i__35641__auto__",-400825660,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when","cljs.core$macros/when",328457725,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","<","cljs.core$macros/<",371512596,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"i__35641__auto__","i__35641__auto__",-400825660,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"len__35640__auto__","len__35640__auto__",-1358280060,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".push",".push",-1497267248,null)),(function (){var x__28851__auto__ = dest;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","unchecked-get","cljs.core$macros/unchecked-get",-1185166893,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","js-arguments","cljs.core$macros/js-arguments",390128540,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"i__35641__auto__","i__35641__auto__",-400825660,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"recur","recur",1202958259,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","inc","cljs.core$macros/inc",876629257,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"i__35641__auto__","i__35641__auto__",-400825660,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
cljs.core$macros.copy_arguments.cljs$lang$macro = true;

cljs.core$macros.variadic_fn = (function cljs$core$macros$variadic_fn(name,meta,p__35645,emit_var_QMARK_){
var vec__35646 = p__35645;
var vec__35649 = cljs.core.nth.call(null,vec__35646,(0),null);
var seq__35650 = cljs.core.seq.call(null,vec__35649);
var first__35651 = cljs.core.first.call(null,seq__35650);
var seq__35650__$1 = cljs.core.next.call(null,seq__35650);
var arglist = first__35651;
var body = seq__35650__$1;
var method = vec__35649;
var fdecl = vec__35646;
var dest_args = ((function (vec__35646,vec__35649,seq__35650,first__35651,seq__35650__$1,arglist,body,method,fdecl){
return (function cljs$core$macros$variadic_fn_$_dest_args(c){
return cljs.core.map.call(null,((function (vec__35646,vec__35649,seq__35650,first__35651,seq__35650__$1,arglist,body,method,fdecl){
return (function (n){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","unchecked-get","cljs.core$macros/unchecked-get",-1185166893,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","js-arguments","cljs.core$macros/js-arguments",390128540,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = n;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});})(vec__35646,vec__35649,seq__35650,first__35651,seq__35650__$1,arglist,body,method,fdecl))
,cljs.core.range.call(null,c));
});})(vec__35646,vec__35649,seq__35650,first__35651,seq__35650__$1,arglist,body,method,fdecl))
;
var rname = cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.analyzer._STAR_cljs_ns_STAR_)].join(''),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''));
var sig = cljs.core.remove.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"&","&",-2144855648,null),null], null), null),arglist);
var c_1 = (cljs.core.count.call(null,sig) - (1));
var meta__$1 = cljs.core.assoc.call(null,meta,new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),true,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),c_1,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sig], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),(function (){var x__28851__auto__ = arglist;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.doall.call(null,cljs.core.map.call(null,meta,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [arglist], null)))], null));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"def","def",597100991,null)),(function (){var x__28851__auto__ = cljs.core.with_meta.call(null,name,meta__$1);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"var_args","var_args",1214280389,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"args__35643__auto__","args__35643__auto__",-668764510,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","array","cljs.core$macros/array",49650437,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","copy-arguments","cljs.core$macros/copy-arguments",-1675962356,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"args__35643__auto__","args__35643__auto__",-668764510,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"argseq__35644__auto__","argseq__35644__auto__",-323726431,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when","cljs.core$macros/when",328457725,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","<","cljs.core$macros/<",371512596,null)),(function (){var x__28851__auto__ = c_1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","alength","cljs.core$macros/alength",-683052937,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"args__35643__auto__","args__35643__auto__",-668764510,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"new","new",-444906321,null)),(function (){var x__28851__auto__ = cljs.core.with_meta.call(null,new cljs.core.Symbol("cljs.core","IndexedSeq","cljs.core/IndexedSeq",-228688698,null),cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"file","file",-1269645878)),cljs.core._conj.call(null,cljs.core.List.EMPTY,"/Users/prepor/work/orcl-open/backend-naive/resources/public/js/out/cljs/core.cljc"),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"line","line",212345235)),cljs.core._conj.call(null,cljs.core.List.EMPTY,3045),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"column","column",2078222095)),cljs.core._conj.call(null,cljs.core.List.EMPTY,55),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"end-line","end-line",1837326455)),cljs.core._conj.call(null,cljs.core.List.EMPTY,3045),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"end-column","end-column",1425389514)),cljs.core._conj.call(null,cljs.core.List.EMPTY,75),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017)),cljs.core._conj.call(null,cljs.core.List.EMPTY,true))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".slice",".slice",1874048374,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"args__35643__auto__","args__35643__auto__",-668764510,null)),(function (){var x__28851__auto__ = c_1;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0)),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__28851__auto__ = rname;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"cljs$core$IFn$_invoke$arity$variadic","cljs$core$IFn$_invoke$arity$variadic",-378825034,null)),dest_args.call(null,c_1),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"argseq__35644__auto__","argseq__35644__auto__",-323726431,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core$macros.variadic_fn_STAR_.call(null,rname,method);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = (cljs.core.truth_(emit_var_QMARK_)?cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"var","var",870848730,null)),(function (){var x__28851__auto__ = name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))):null);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
cljs.core$macros.multi_arity_fn = (function cljs$core$macros$multi_arity_fn(name,meta,fdecl,emit_var_QMARK_){
var dest_args = (function cljs$core$macros$multi_arity_fn_$_dest_args(c){
return cljs.core.map.call(null,(function (n){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","unchecked-get","cljs.core$macros/unchecked-get",-1185166893,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","js-arguments","cljs.core$macros/js-arguments",390128540,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = n;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
}),cljs.core.range.call(null,c));
});
var fixed_arity = (function cljs$core$macros$multi_arity_fn_$_fixed_arity(rname,sig){
var c = cljs.core.count.call(null,sig);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [c,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__28851__auto__ = rname;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__28851__auto__ = cljs.core.symbol.call(null,["cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(c)].join(''));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),dest_args.call(null,c))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())))], null);
});
var fn_method = (function cljs$core$macros$multi_arity_fn_$_fn_method(p__35660){
var vec__35661 = p__35660;
var seq__35662 = cljs.core.seq.call(null,vec__35661);
var first__35663 = cljs.core.first.call(null,seq__35662);
var seq__35662__$1 = cljs.core.next.call(null,seq__35662);
var sig = first__35663;
var body = seq__35662__$1;
var method = vec__35661;
if(cljs.core.truth_(cljs.core.some.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"&","&",-2144855648,null),null], null), null),sig))){
return cljs.core$macros.variadic_fn_STAR_.call(null,name,method,false);
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__28851__auto__ = name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.symbol.call(null,["-cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,sig))].join(''));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__28851__auto__ = method;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
}
});
var rname = cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.analyzer._STAR_cljs_ns_STAR_)].join(''),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''));
var arglists = cljs.core.map.call(null,cljs.core.first,fdecl);
var varsig_QMARK_ = ((function (rname,arglists){
return (function (p1__35652_SHARP_){
return cljs.core.some.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"&","&",-2144855648,null),null], null), null),p1__35652_SHARP_);
});})(rname,arglists))
;
var variadic = cljs.core.boolean$.call(null,cljs.core.some.call(null,varsig_QMARK_,arglists));
var sigs = cljs.core.remove.call(null,varsig_QMARK_,arglists);
var maxfa = cljs.core.apply.call(null,cljs.core.max,cljs.core.concat.call(null,cljs.core.map.call(null,cljs.core.count,sigs),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.count.call(null,cljs.core.first.call(null,cljs.core.filter.call(null,varsig_QMARK_,arglists))) - (2))], null)));
var meta__$1 = cljs.core.assoc.call(null,meta,new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"variadic","variadic",882626057),variadic,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),maxfa,new cljs.core.Keyword(null,"method-params","method-params",-980792179),sigs,new cljs.core.Keyword(null,"arglists","arglists",1661989754),arglists,new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.doall.call(null,cljs.core.map.call(null,meta,arglists))], null));
var args_sym = cljs.core.gensym.call(null,"args");
var param_counts = cljs.core.map.call(null,cljs.core.count,arglists);
if(cljs.core.not_EQ_.call(null,cljs.core.distinct.call(null,param_counts),param_counts)){
cljs.analyzer.warning.call(null,new cljs.core.Keyword(null,"overload-arity","overload-arity",823206044),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),name], null));
} else {
}

return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"def","def",597100991,null)),(function (){var x__28851__auto__ = cljs.core.with_meta.call(null,name,meta__$1);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"var_args","var_args",1214280389,null))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","case","cljs.core$macros/case",-2131866965,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","alength","cljs.core$macros/alength",-683052937,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","js-arguments","cljs.core$macros/js-arguments",390128540,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core.mapcat.call(null,((function (rname,arglists,varsig_QMARK_,variadic,sigs,maxfa,meta__$1,args_sym,param_counts){
return (function (p1__35653_SHARP_){
return fixed_arity.call(null,rname,p1__35653_SHARP_);
});})(rname,arglists,varsig_QMARK_,variadic,sigs,maxfa,meta__$1,args_sym,param_counts))
,sigs),(function (){var x__28851__auto__ = ((variadic)?cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"args-arr__35654__auto__","args-arr__35654__auto__",1837901879,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","array","cljs.core$macros/array",49650437,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","copy-arguments","cljs.core$macros/copy-arguments",-1675962356,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"args-arr__35654__auto__","args-arr__35654__auto__",1837901879,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"argseq__35655__auto__","argseq__35655__auto__",-61861194,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"new","new",-444906321,null)),(function (){var x__28851__auto__ = cljs.core.with_meta.call(null,new cljs.core.Symbol("cljs.core","IndexedSeq","cljs.core/IndexedSeq",-228688698,null),cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"file","file",-1269645878)),cljs.core._conj.call(null,cljs.core.List.EMPTY,"/Users/prepor/work/orcl-open/backend-naive/resources/public/js/out/cljs/core.cljc"),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"line","line",212345235)),cljs.core._conj.call(null,cljs.core.List.EMPTY,3106),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"column","column",2078222095)),cljs.core._conj.call(null,cljs.core.List.EMPTY,59),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"end-line","end-line",1837326455)),cljs.core._conj.call(null,cljs.core.List.EMPTY,3106),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"end-column","end-column",1425389514)),cljs.core._conj.call(null,cljs.core.List.EMPTY,79),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017)),cljs.core._conj.call(null,cljs.core.List.EMPTY,true))))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".slice",".slice",1874048374,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"args-arr__35654__auto__","args-arr__35654__auto__",1837901879,null)),(function (){var x__28851__auto__ = maxfa;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(0)),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__28851__auto__ = rname;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"cljs$core$IFn$_invoke$arity$variadic","cljs$core$IFn$_invoke$arity$variadic",-378825034,null)),dest_args.call(null,maxfa),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"argseq__35655__auto__","argseq__35655__auto__",-61861194,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))):(cljs.core.truth_(new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(meta__$1))?cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"throw","throw",595905694,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("js","Error.","js/Error.",750655924,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","str","cljs.core$macros/str",-2019499702,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,"Invalid arity: "),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","-","cljs.core$macros/-",13526976,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","alength","cljs.core$macros/alength",-683052937,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","js-arguments","cljs.core$macros/js-arguments",390128540,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,(2)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))):cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"throw","throw",595905694,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("js","Error.","js/Error.",750655924,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","str","cljs.core$macros/str",-2019499702,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,"Invalid arity: "),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","alength","cljs.core$macros/alength",-683052937,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","js-arguments","cljs.core$macros/js-arguments",390128540,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core.map.call(null,fn_method,fdecl),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__28851__auto__ = name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-cljs$lang$maxFixedArity","-cljs$lang$maxFixedArity",-1481434279,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = maxfa;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = (cljs.core.truth_(emit_var_QMARK_)?cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"var","var",870848730,null)),(function (){var x__28851__auto__ = name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))):null);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
/**
 * Same as (def name (core/fn [params* ] exprs*)) or (def
 *  name (core/fn ([params* ] exprs*)+)) with any doc-string or attrs added
 *  to the var metadata. prepost-map defines a map with optional keys
 *  :pre and :post that contain collections of pre or post conditions.
 * @param {...*} var_args
 */
cljs.core$macros.defn = (function() { 
var cljs$core$macros$defn__delegate = function (_AMPERSAND_form,_AMPERSAND_env,name,fdecl){
if((name instanceof cljs.core.Symbol)){
} else {
throw (new Error("First argument to defn must be a symbol"));
}

var m = ((typeof cljs.core.first.call(null,fdecl) === 'string')?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),cljs.core.first.call(null,fdecl)], null):cljs.core.PersistentArrayMap.EMPTY);
var fdecl__$1 = ((typeof cljs.core.first.call(null,fdecl) === 'string')?cljs.core.next.call(null,fdecl):fdecl);
var m__$1 = ((cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,fdecl__$1)))?cljs.core.conj.call(null,m,cljs.core.first.call(null,fdecl__$1)):m);
var fdecl__$2 = ((cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,fdecl__$1)))?cljs.core.next.call(null,fdecl__$1):fdecl__$1);
var fdecl__$3 = ((cljs.core.vector_QMARK_.call(null,cljs.core.first.call(null,fdecl__$2)))?(function (){var x__28851__auto__ = fdecl__$2;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})():fdecl__$2);
var m__$2 = ((cljs.core.map_QMARK_.call(null,cljs.core.last.call(null,fdecl__$3)))?cljs.core.conj.call(null,m__$1,cljs.core.last.call(null,fdecl__$3)):m__$1);
var fdecl__$4 = ((cljs.core.map_QMARK_.call(null,cljs.core.last.call(null,fdecl__$3)))?cljs.core.butlast.call(null,fdecl__$3):fdecl__$3);
var m__$3 = cljs.core.conj.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core._conj.call(null,(function (){var x__28851__auto__ = cljs.core$macros.sigs.call(null,fdecl__$4);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),new cljs.core.Symbol(null,"quote","quote",1377916282,null))], null),m__$2);
var m__$4 = cljs.core.conj.call(null,(cljs.core.truth_(cljs.core.meta.call(null,name))?cljs.core.meta.call(null,name):cljs.core.PersistentArrayMap.EMPTY),m__$3);
if(cljs.core.truth_(cljs.core$macros.multi_arity_fn_QMARK_.call(null,fdecl__$4))){
return cljs.core$macros.multi_arity_fn.call(null,name,(cljs.core.truth_(cljs.compiler.checking_types_QMARK_.call(null))?cljs.core.update_in.call(null,m__$4,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516)], null),cljs.core.conj,"@param {...*} var_args"):m__$4),fdecl__$4,new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(_AMPERSAND_env));
} else {
if(cljs.core.truth_(cljs.core$macros.variadic_fn_QMARK_.call(null,fdecl__$4))){
return cljs.core$macros.variadic_fn.call(null,name,(cljs.core.truth_(cljs.compiler.checking_types_QMARK_.call(null))?cljs.core.update_in.call(null,m__$4,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516)], null),cljs.core.conj,"@param {...*} var_args"):m__$4),fdecl__$4,new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(_AMPERSAND_env));
} else {
return cljs.core._conj.call(null,(function (){var x__28851__auto__ = cljs.core.with_meta.call(null,name,m__$4);
return cljs.core._conj.call(null,(function (){var x__28851__auto____$1 = cljs.core.cons.call(null,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null),fdecl__$4);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto____$1);
})(),x__28851__auto__);
})(),new cljs.core.Symbol(null,"def","def",597100991,null));

}
}
};
var cljs$core$macros$defn = function (_AMPERSAND_form,_AMPERSAND_env,name,var_args){
var fdecl = null;
if (arguments.length > 3) {
var G__35664__i = 0, G__35664__a = new Array(arguments.length -  3);
while (G__35664__i < G__35664__a.length) {G__35664__a[G__35664__i] = arguments[G__35664__i + 3]; ++G__35664__i;}
  fdecl = new cljs.core.IndexedSeq(G__35664__a,0,null);
} 
return cljs$core$macros$defn__delegate.call(this,_AMPERSAND_form,_AMPERSAND_env,name,fdecl);};
cljs$core$macros$defn.cljs$lang$maxFixedArity = 3;
cljs$core$macros$defn.cljs$lang$applyTo = (function (arglist__35665){
var _AMPERSAND_form = cljs.core.first(arglist__35665);
arglist__35665 = cljs.core.next(arglist__35665);
var _AMPERSAND_env = cljs.core.first(arglist__35665);
arglist__35665 = cljs.core.next(arglist__35665);
var name = cljs.core.first(arglist__35665);
var fdecl = cljs.core.rest(arglist__35665);
return cljs$core$macros$defn__delegate(_AMPERSAND_form,_AMPERSAND_env,name,fdecl);
});
cljs$core$macros$defn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$macros$defn__delegate;
return cljs$core$macros$defn;
})()
;
cljs.core$macros.defn.cljs$lang$macro = true;
/**
 * Like defn, but the resulting function name is declared as a
 *   macro and will be used as a macro by the compiler when it is
 *   called.
 */
cljs.core$macros.defmacro = (function cljs$core$macros$defmacro(var_args){
var args__29165__auto__ = [];
var len__29158__auto___35671 = arguments.length;
var i__29159__auto___35672 = (0);
while(true){
if((i__29159__auto___35672 < len__29158__auto___35671)){
args__29165__auto__.push((arguments[i__29159__auto___35672]));

var G__35673 = (i__29159__auto___35672 + (1));
i__29159__auto___35672 = G__35673;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((3) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((3)),(0),null)):null);
return cljs.core$macros.defmacro.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29166__auto__);
});

cljs.core$macros.defmacro.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,name,args){
var prefix = (function (){var p = (function (){var x__28851__auto__ = cljs.core.vary_meta.call(null,name,cljs.core.assoc,new cljs.core.Keyword(null,"macro","macro",-867863404),true);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})();
var args__$1 = args;
while(true){
var f = cljs.core.first.call(null,args__$1);
if(typeof f === 'string'){
var G__35674 = cljs.core.cons.call(null,f,p);
var G__35675 = cljs.core.next.call(null,args__$1);
p = G__35674;
args__$1 = G__35675;
continue;
} else {
if(cljs.core.map_QMARK_.call(null,f)){
var G__35676 = cljs.core.cons.call(null,f,p);
var G__35677 = cljs.core.next.call(null,args__$1);
p = G__35676;
args__$1 = G__35677;
continue;
} else {
return p;
}
}
break;
}
})();
var fdecl = (function (){var fd = args;
while(true){
if(typeof cljs.core.first.call(null,fd) === 'string'){
var G__35678 = cljs.core.next.call(null,fd);
fd = G__35678;
continue;
} else {
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,fd))){
var G__35679 = cljs.core.next.call(null,fd);
fd = G__35679;
continue;
} else {
return fd;
}
}
break;
}
})();
var fdecl__$1 = ((cljs.core.vector_QMARK_.call(null,cljs.core.first.call(null,fdecl)))?(function (){var x__28851__auto__ = fdecl;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})():fdecl);
var add_implicit_args = ((function (prefix,fdecl,fdecl__$1){
return (function (fd){
var args__$1 = cljs.core.first.call(null,fd);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"&form","&form",1482799337,null),cljs.core.cons.call(null,new cljs.core.Symbol(null,"&env","&env",-919163083,null),args__$1))),cljs.core.next.call(null,fd));
});})(prefix,fdecl,fdecl__$1))
;
var add_args = ((function (prefix,fdecl,fdecl__$1,add_implicit_args){
return (function (acc,ds){
while(true){
if((ds == null)){
return acc;
} else {
var d = cljs.core.first.call(null,ds);
if(cljs.core.map_QMARK_.call(null,d)){
return cljs.core.conj.call(null,acc,d);
} else {
var G__35680 = cljs.core.conj.call(null,acc,add_implicit_args.call(null,d));
var G__35681 = cljs.core.next.call(null,ds);
acc = G__35680;
ds = G__35681;
continue;
}
}
break;
}
});})(prefix,fdecl,fdecl__$1,add_implicit_args))
;
var fdecl__$2 = cljs.core.seq.call(null,add_args.call(null,cljs.core.PersistentVector.EMPTY,fdecl__$1));
var decl = (function (){var p = prefix;
var d = fdecl__$2;
while(true){
if(cljs.core.truth_(p)){
var G__35682 = cljs.core.next.call(null,p);
var G__35683 = cljs.core.cons.call(null,cljs.core.first.call(null,p),d);
p = G__35682;
d = G__35683;
continue;
} else {
return d;
}
break;
}
})();
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","let","cljs.core$macros/let",-160286726,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"ret__35666__auto__","ret__35666__auto__",1768577037,null)),(function (){var x__28851__auto__ = cljs.core.cons.call(null,new cljs.core.Symbol("cljs.core$macros","defn","cljs.core$macros/defn",-728332354,null),decl);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"set!","set!",250714521,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,".",".",1975675962,null)),(function (){var x__28851__auto__ = name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"-cljs$lang$macro","-cljs$lang$macro",443600924,null)))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,true))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"ret__35666__auto__","ret__35666__auto__",1768577037,null)))));
});

cljs.core$macros.defmacro.cljs$lang$maxFixedArity = (3);

cljs.core$macros.defmacro.cljs$lang$applyTo = (function (seq35667){
var G__35668 = cljs.core.first.call(null,seq35667);
var seq35667__$1 = cljs.core.next.call(null,seq35667);
var G__35669 = cljs.core.first.call(null,seq35667__$1);
var seq35667__$2 = cljs.core.next.call(null,seq35667__$1);
var G__35670 = cljs.core.first.call(null,seq35667__$2);
var seq35667__$3 = cljs.core.next.call(null,seq35667__$2);
return cljs.core$macros.defmacro.cljs$core$IFn$_invoke$arity$variadic(G__35668,G__35669,G__35670,seq35667__$3);
});

cljs.core$macros.defmacro.cljs$lang$macro = true;
var ret__29198__auto___35688 = /**
 * Returns the var to which a symbol will be resolved in the namespace else nil.
 */
cljs.core$macros.resolve = (function cljs$core$macros$resolve(_AMPERSAND_form,_AMPERSAND_env,quoted_sym){
if((cljs.core.seq_QMARK_.call(null,quoted_sym)) && (cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.first.call(null,quoted_sym)))){
} else {
throw (new Error(["Assert failed: ","Argument to resolve must be a quoted symbol","\n","(core/and (seq? quoted-sym) (= (quote quote) (first quoted-sym)))"].join('')));
}

var sym = cljs.core.second.call(null,quoted_sym);
var env = _AMPERSAND_env;
var vec__35684 = (function (){try{var var$ = cljs.analyzer.resolve_var.call(null,env,sym,cljs.analyzer.confirm_var_exists_throw.call(null));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [var$,cljs.analyzer.var_meta.call(null,var$)], null);
}catch (e35687){var e = e35687;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.analyzer.resolve_var.call(null,env,sym),null], null);
}})();
var var$ = cljs.core.nth.call(null,vec__35684,(0),null);
var meta = cljs.core.nth.call(null,vec__35684,(1),null);
var resolved = cljs.core.vary_meta.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(var$),cljs.core.assoc,new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","when","cljs.core$macros/when",328457725,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","exists?","cljs.core$macros/exists?",-1828590389,null)),(function (){var x__28851__auto__ = resolved;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","Var.","cljs.core/Var.",-242685277,null)),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core$macros","fn","cljs.core$macros/fn",-187522821,null)),(function (){var x__28851__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = resolved;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"quote","quote",1377916282,null)),(function (){var x__28851__auto__ = resolved;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),(function (){var x__28851__auto__ = meta;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})())));
});
cljs.core$macros.resolve.cljs$lang$macro = true;


//# sourceMappingURL=core$macros.js.map?rel=1503590924394
