// Compiled by ClojureScript 1.9.908 {}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.tools.reader');
goog.require('cljs.env');
goog.require('cljs.analyzer');
goog.require('cljs.source_map');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.call(null,cljs.core.mapcat.call(null,(function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.call(null,clojure.string.replace.call(null,cljs.core.name.call(null,lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)].join('');
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.call(null,ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv.call(null,(function (xs,ns,_){
if(cljs.core._EQ_.call(null,needle,cljs.compiler.get_first_ns_segment.call(null,ns))){
return cljs.core.reduced.call(null,needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__33117 = s;
var map__33117__$1 = ((((!((map__33117 == null)))?((((map__33117.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33117.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33117):map__33117);
var name = cljs.core.get.call(null,map__33117__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.call(null,map__33117__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__33120 = info;
var map__33121 = G__33120;
var map__33121__$1 = ((((!((map__33121 == null)))?((((map__33121.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33121.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33121):map__33121);
var shadow = cljs.core.get.call(null,map__33121__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__33120__$1 = G__33120;
while(true){
var d__$2 = d__$1;
var map__33123 = G__33120__$1;
var map__33123__$1 = ((((!((map__33123 == null)))?((((map__33123.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33123.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33123):map__33123);
var shadow__$1 = cljs.core.get.call(null,map__33123__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$1)){
var G__33125 = (d__$2 + (1));
var G__33126 = shadow__$1;
d__$1 = G__33125;
G__33120__$1 = G__33126;
continue;
} else {
if(cljs.core.truth_(cljs.compiler.find_ns_starts_with.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('')))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine.call(null,cljs.core._hash.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s)),cljs.compiler.shadow_depth.call(null,s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__33127){
var map__33128 = p__33127;
var map__33128__$1 = ((((!((map__33128 == null)))?((((map__33128.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33128.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33128):map__33128);
var name_var = map__33128__$1;
var name = cljs.core.get.call(null,map__33128__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.call(null,map__33128__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''),"..","_DOT__DOT_");
var map__33130 = info;
var map__33130__$1 = ((((!((map__33130 == null)))?((((map__33130.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33130.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33130):map__33130);
var ns = cljs.core.get.call(null,map__33130__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.call(null,map__33130__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null,"_$_",cljs.core.concat.call(null,cljs.core.map.call(null,cljs.core.comp.call(null,cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.call(null,cljs.compiler.munge.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.replace.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)].join(''),".","$")),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('')));
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if(!((cljs.core.get.call(null,reserved,s) == null))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__33133 = arguments.length;
switch (G__33133) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.call(null,s,cljs.compiler.js_reserved);
});

cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.cljs_map_QMARK_.call(null,s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if(!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null))){
return cljs.compiler.fn_self_name.call(null,s);
} else {
var depth = cljs.compiler.shadow_depth.call(null,s);
var code = cljs.compiler.hash_scope.call(null,s);
var renamed = cljs.core.get.call(null,cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):((!((renamed == null)))?renamed:name
));
var munged_name = cljs.compiler.munge.call(null,name__$1,reserved);
if((field === true) || ((depth === (0)))){
return munged_name;
} else {
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join(''),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace.call(null,ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved.call(null,reserved);
var ss__$2 = cljs.core.map.call(null,rf,clojure.string.split.call(null,ss__$1,/\./));
var ss__$3 = clojure.string.join.call(null,".",ss__$2);
var ms = cljs.core.munge_str.call(null,ss__$3);
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,ms);
} else {
return ms;
}
}
});

cljs.compiler.munge.cljs$lang$maxFixedArity = 2;

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.call(null,",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__33135 = cp;
switch (G__33135) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if((((31) < cp)) && ((cp < (127)))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.call(null,"0000",unpadded.length);
return ["\\u",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pad),cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__33137_33141 = cljs.core.seq.call(null,s);
var chunk__33138_33142 = null;
var count__33139_33143 = (0);
var i__33140_33144 = (0);
while(true){
if((i__33140_33144 < count__33139_33143)){
var c_33145 = cljs.core._nth.call(null,chunk__33138_33142,i__33140_33144);
sb.append(cljs.compiler.escape_char.call(null,c_33145));

var G__33146 = seq__33137_33141;
var G__33147 = chunk__33138_33142;
var G__33148 = count__33139_33143;
var G__33149 = (i__33140_33144 + (1));
seq__33137_33141 = G__33146;
chunk__33138_33142 = G__33147;
count__33139_33143 = G__33148;
i__33140_33144 = G__33149;
continue;
} else {
var temp__4657__auto___33150 = cljs.core.seq.call(null,seq__33137_33141);
if(temp__4657__auto___33150){
var seq__33137_33151__$1 = temp__4657__auto___33150;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33137_33151__$1)){
var c__28828__auto___33152 = cljs.core.chunk_first.call(null,seq__33137_33151__$1);
var G__33153 = cljs.core.chunk_rest.call(null,seq__33137_33151__$1);
var G__33154 = c__28828__auto___33152;
var G__33155 = cljs.core.count.call(null,c__28828__auto___33152);
var G__33156 = (0);
seq__33137_33141 = G__33153;
chunk__33138_33142 = G__33154;
count__33139_33143 = G__33155;
i__33140_33144 = G__33156;
continue;
} else {
var c_33157 = cljs.core.first.call(null,seq__33137_33151__$1);
sb.append(cljs.compiler.escape_char.call(null,c_33157));

var G__33158 = cljs.core.next.call(null,seq__33137_33151__$1);
var G__33159 = null;
var G__33160 = (0);
var G__33161 = (0);
seq__33137_33141 = G__33158;
chunk__33138_33142 = G__33159;
count__33139_33143 = G__33160;
i__33140_33144 = G__33161;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("\""),cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\"")].join('');
});
if(typeof cljs.compiler.emit_STAR_ !== 'undefined'){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__28944__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__28945__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__28946__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__28947__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__28948__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__28948__auto__,method_table__28944__auto__,prefer_table__28945__auto__,method_cache__28946__auto__,cached_hierarchy__28947__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
var val__31514__auto__ = cljs.env._STAR_compiler_STAR_;
if((val__31514__auto__ == null)){
cljs.env._STAR_compiler_STAR_ = cljs.env.default_compiler_env.call(null);
} else {
}

try{if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__33162_33167 = ast;
var map__33162_33168__$1 = ((((!((map__33162_33167 == null)))?((((map__33162_33167.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33162_33167.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33162_33167):map__33162_33167);
var env_33169 = cljs.core.get.call(null,map__33162_33168__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_33169))){
var map__33164_33170 = env_33169;
var map__33164_33171__$1 = ((((!((map__33164_33170 == null)))?((((map__33164_33170.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33164_33170.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33164_33170):map__33164_33170);
var line_33172 = cljs.core.get.call(null,map__33164_33171__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_33173 = cljs.core.get.call(null,map__33164_33171__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,((function (map__33164_33170,map__33164_33171__$1,line_33172,column_33173,map__33162_33167,map__33162_33168__$1,env_33169,val__31514__auto__){
return (function (m){
var minfo = (function (){var G__33166 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast),new cljs.core.Keyword(null,"var","var",-769682797))){
return cljs.core.assoc.call(null,G__33166,new cljs.core.Keyword(null,"name","name",1843675177),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast)))].join(''));
} else {
return G__33166;
}
})();
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_33172 - (1))], null),cljs.core.fnil.call(null,((function (minfo,map__33164_33170,map__33164_33171__$1,line_33172,column_33173,map__33162_33167,map__33162_33168__$1,env_33169,val__31514__auto__){
return (function (line__$1){
return cljs.core.update_in.call(null,line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_33173)?(column_33173 - (1)):(0))], null),cljs.core.fnil.call(null,((function (minfo,map__33164_33170,map__33164_33171__$1,line_33172,column_33173,map__33162_33167,map__33162_33168__$1,env_33169,val__31514__auto__){
return (function (column__$1){
return cljs.core.conj.call(null,column__$1,minfo);
});})(minfo,map__33164_33170,map__33164_33171__$1,line_33172,column_33173,map__33162_33167,map__33162_33168__$1,env_33169,val__31514__auto__))
,cljs.core.PersistentVector.EMPTY));
});})(minfo,map__33164_33170,map__33164_33171__$1,line_33172,column_33173,map__33162_33167,map__33162_33168__$1,env_33169,val__31514__auto__))
,cljs.core.sorted_map.call(null)));
});})(map__33164_33170,map__33164_33171__$1,line_33172,column_33173,map__33162_33167,map__33162_33168__$1,env_33169,val__31514__auto__))
);
} else {
}
} else {
}

return cljs.compiler.emit_STAR_.call(null,ast);
}finally {if((val__31514__auto__ == null)){
cljs.env._STAR_compiler_STAR_ = null;
} else {
}
}});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var args__29165__auto__ = [];
var len__29158__auto___33180 = arguments.length;
var i__29159__auto___33181 = (0);
while(true){
if((i__29159__auto___33181 < len__29158__auto___33180)){
args__29165__auto__.push((arguments[i__29159__auto___33181]));

var G__33182 = (i__29159__auto___33181 + (1));
i__29159__auto___33181 = G__33182;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((0) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((0)),(0),null)):null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(argseq__29166__auto__);
});

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
var seq__33176_33183 = cljs.core.seq.call(null,xs);
var chunk__33177_33184 = null;
var count__33178_33185 = (0);
var i__33179_33186 = (0);
while(true){
if((i__33179_33186 < count__33178_33185)){
var x_33187 = cljs.core._nth.call(null,chunk__33177_33184,i__33179_33186);
if((x_33187 == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_.call(null,x_33187)){
cljs.compiler.emit.call(null,x_33187);
} else {
if(cljs.analyzer.cljs_seq_QMARK_.call(null,x_33187)){
cljs.core.apply.call(null,cljs.compiler.emits,x_33187);
} else {
if(goog.isFunction(x_33187)){
x_33187.call(null);
} else {
var s_33188 = cljs.core.print_str.call(null,x_33187);
if((cljs.compiler._STAR_source_map_data_STAR_ == null)){
} else {
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gen-col","gen-col",1901918303)], null),((function (seq__33176_33183,chunk__33177_33184,count__33178_33185,i__33179_33186,s_33188,x_33187){
return (function (p1__33174_SHARP_){
return (p1__33174_SHARP_ + cljs.core.count.call(null,s_33188));
});})(seq__33176_33183,chunk__33177_33184,count__33178_33185,i__33179_33186,s_33188,x_33187))
);
}

cljs.core.print.call(null,s_33188);

}
}
}
}

var G__33189 = seq__33176_33183;
var G__33190 = chunk__33177_33184;
var G__33191 = count__33178_33185;
var G__33192 = (i__33179_33186 + (1));
seq__33176_33183 = G__33189;
chunk__33177_33184 = G__33190;
count__33178_33185 = G__33191;
i__33179_33186 = G__33192;
continue;
} else {
var temp__4657__auto___33193 = cljs.core.seq.call(null,seq__33176_33183);
if(temp__4657__auto___33193){
var seq__33176_33194__$1 = temp__4657__auto___33193;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33176_33194__$1)){
var c__28828__auto___33195 = cljs.core.chunk_first.call(null,seq__33176_33194__$1);
var G__33196 = cljs.core.chunk_rest.call(null,seq__33176_33194__$1);
var G__33197 = c__28828__auto___33195;
var G__33198 = cljs.core.count.call(null,c__28828__auto___33195);
var G__33199 = (0);
seq__33176_33183 = G__33196;
chunk__33177_33184 = G__33197;
count__33178_33185 = G__33198;
i__33179_33186 = G__33199;
continue;
} else {
var x_33200 = cljs.core.first.call(null,seq__33176_33194__$1);
if((x_33200 == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_.call(null,x_33200)){
cljs.compiler.emit.call(null,x_33200);
} else {
if(cljs.analyzer.cljs_seq_QMARK_.call(null,x_33200)){
cljs.core.apply.call(null,cljs.compiler.emits,x_33200);
} else {
if(goog.isFunction(x_33200)){
x_33200.call(null);
} else {
var s_33201 = cljs.core.print_str.call(null,x_33200);
if((cljs.compiler._STAR_source_map_data_STAR_ == null)){
} else {
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gen-col","gen-col",1901918303)], null),((function (seq__33176_33183,chunk__33177_33184,count__33178_33185,i__33179_33186,s_33201,x_33200,seq__33176_33194__$1,temp__4657__auto___33193){
return (function (p1__33174_SHARP_){
return (p1__33174_SHARP_ + cljs.core.count.call(null,s_33201));
});})(seq__33176_33183,chunk__33177_33184,count__33178_33185,i__33179_33186,s_33201,x_33200,seq__33176_33194__$1,temp__4657__auto___33193))
);
}

cljs.core.print.call(null,s_33201);

}
}
}
}

var G__33202 = cljs.core.next.call(null,seq__33176_33194__$1);
var G__33203 = null;
var G__33204 = (0);
var G__33205 = (0);
seq__33176_33183 = G__33202;
chunk__33177_33184 = G__33203;
count__33178_33185 = G__33204;
i__33179_33186 = G__33205;
continue;
}
} else {
}
}
break;
}

return null;
});

cljs.compiler.emits.cljs$lang$maxFixedArity = (0);

cljs.compiler.emits.cljs$lang$applyTo = (function (seq33175){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq33175));
});

cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var args__29165__auto__ = [];
var len__29158__auto___33211 = arguments.length;
var i__29159__auto___33212 = (0);
while(true){
if((i__29159__auto___33212 < len__29158__auto___33211)){
args__29165__auto__.push((arguments[i__29159__auto___33212]));

var G__33213 = (i__29159__auto___33212 + (1));
i__29159__auto___33212 = G__33213;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((0) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((0)),(0),null)):null);
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(argseq__29166__auto__);
});

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
cljs.core.apply.call(null,cljs.compiler.emits,xs);

var _STAR_flush_on_newline_STAR_33207_33214 = cljs.core._STAR_flush_on_newline_STAR_;
cljs.core._STAR_flush_on_newline_STAR_ = false;

try{cljs.core.println.call(null);
}finally {cljs.core._STAR_flush_on_newline_STAR_ = _STAR_flush_on_newline_STAR_33207_33214;
}
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,(function (p__33208){
var map__33209 = p__33208;
var map__33209__$1 = ((((!((map__33209 == null)))?((((map__33209.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33209.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33209):map__33209);
var m = map__33209__$1;
var gen_line = cljs.core.get.call(null,map__33209__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0));
}));
} else {
}

return null;
});

cljs.compiler.emitln.cljs$lang$maxFixedArity = (0);

cljs.compiler.emitln.cljs$lang$applyTo = (function (seq33206){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq33206));
});

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__29016__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR_33215_33217 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR_33216_33218 = cljs.core._STAR_print_fn_STAR_;
cljs.core._STAR_print_newline_STAR_ = true;

cljs.core._STAR_print_fn_STAR_ = ((function (_STAR_print_newline_STAR_33215_33217,_STAR_print_fn_STAR_33216_33218,sb__29016__auto__){
return (function (x__29017__auto__){
return sb__29016__auto__.append(x__29017__auto__);
});})(_STAR_print_newline_STAR_33215_33217,_STAR_print_fn_STAR_33216_33218,sb__29016__auto__))
;

try{cljs.compiler.emit.call(null,expr);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_33216_33218;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_33215_33217;
}
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__29016__auto__)].join('');
});
if(typeof cljs.compiler.emit_constant !== 'undefined'){
} else {
cljs.compiler.emit_constant = (function (){var method_table__28944__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__28945__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__28946__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__28947__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__28948__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"cljs.compiler","emit-constant"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__28948__auto__,method_table__28944__auto__,prefer_table__28945__auto__,method_cache__28946__auto__,cached_hierarchy__28947__auto__));
})();
}
cljs.core._add_method.call(null,cljs.compiler.emit_constant,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.call(null,["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,x))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type.call(null,x)], null));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,null,(function (x){
return cljs.compiler.emits.call(null,"null");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,Number,(function (x){
return cljs.compiler.emits.call(null,"(",x,")");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,String,(function (x){
return cljs.compiler.emits.call(null,cljs.compiler.wrap_in_double_quotes.call(null,cljs.compiler.escape_string.call(null,x)));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,Boolean,(function (x){
return cljs.compiler.emits.call(null,(cljs.core.truth_(x)?"true":"false"));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,RegExp,(function (x){
if(cljs.core._EQ_.call(null,"",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''))){
return cljs.compiler.emits.call(null,"(new RegExp(\"\"))");
} else {
var vec__33219 = cljs.core.re_find.call(null,/^(?:\(\?([idmsux]*)\))?(.*)/,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''));
var _ = cljs.core.nth.call(null,vec__33219,(0),null);
var flags = cljs.core.nth.call(null,vec__33219,(1),null);
var pattern = cljs.core.nth.call(null,vec__33219,(2),null);
return cljs.compiler.emits.call(null,pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace.call(null,kw);
var name = cljs.core.name.call(null,kw);
cljs.compiler.emits.call(null,"new cljs.core.Keyword(");

cljs.compiler.emit_constant.call(null,ns);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,name);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,(cljs.core.truth_(ns)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):name));

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,cljs.core.hash.call(null,kw));

return cljs.compiler.emits.call(null,")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace.call(null,sym);
var name = cljs.core.name.call(null,sym);
var symstr = ((!((ns == null)))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):name);
cljs.compiler.emits.call(null,"new cljs.core.Symbol(");

cljs.compiler.emit_constant.call(null,ns);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,name);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,symstr);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,cljs.core.hash.call(null,sym));

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,null);

return cljs.compiler.emits.call(null,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_constant,cljs.core.Keyword,(function (x){
var temp__4655__auto__ = (function (){var and__27977__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__27977__auto__)){
return x.call(null,new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
} else {
return and__27977__auto__;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var value = temp__4655__auto__;
return cljs.compiler.emits.call(null,"cljs.core.",value);
} else {
return cljs.compiler.emits_keyword.call(null,x);
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,cljs.core.Symbol,(function (x){
var temp__4655__auto__ = (function (){var and__27977__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__27977__auto__)){
return x.call(null,new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
} else {
return and__27977__auto__;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var value = temp__4655__auto__;
return cljs.compiler.emits.call(null,"cljs.core.",value);
} else {
return cljs.compiler.emits_symbol.call(null,x);
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,Date,(function (date){
return cljs.compiler.emits.call(null,"new Date(",date.getTime(),")");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.call(null,"new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash.call(null,uuid_str),")");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"var","var",-769682797),(function (p__33223){
var map__33224 = p__33223;
var map__33224__$1 = ((((!((map__33224 == null)))?((((map__33224.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33224.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33224):map__33224);
var ast = map__33224__$1;
var info = cljs.core.get.call(null,map__33224__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.call(null,map__33224__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.call(null,map__33224__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__4655__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__4655__auto__)){
var const_expr = temp__4655__auto__;
return cljs.compiler.emit.call(null,cljs.core.assoc.call(null,const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__33226 = cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_);
var map__33226__$1 = ((((!((map__33226 == null)))?((((map__33226.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33226.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33226):map__33226);
var cenv = map__33226__$1;
var options = cljs.core.get.call(null,map__33226__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.call(null,cljs.core.namespace.call(null,var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.call(null,cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name.call(null,var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__27989__auto__ = js_module_name;
if(cljs.core.truth_(or__27989__auto__)){
return or__27989__auto__;
} else {
return cljs.core.name.call(null,var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,ast));
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__33228 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__27977__auto__ = cljs.compiler.es5_GT__EQ_.call(null,new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options));
if(cljs.core.truth_(and__27977__auto__)){
return !((cljs.core.namespace.call(null,var_name) == null));
} else {
return and__27977__auto__;
}
})())){
return clojure.set.difference.call(null,G__33228,cljs.analyzer.es5_allowed);
} else {
return G__33228;
}
})();
var env__33109__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,(function (){var G__33229 = info__$1;
if(cljs.core.not_EQ_.call(null,form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.call(null,G__33229,reserved);
} else {
return G__33229;
}
})());

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"var-special","var-special",1131576802),(function (p__33230){
var map__33231 = p__33230;
var map__33231__$1 = ((((!((map__33231 == null)))?((((map__33231.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33231.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33231):map__33231);
var arg = map__33231__$1;
var env = cljs.core.get.call(null,map__33231__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.call(null,map__33231__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.call(null,map__33231__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.call(null,map__33231__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.analyzer.ast_QMARK_.call(null,sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_.call(null,meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__33233 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__33233__$1 = ((((!((map__33233 == null)))?((((map__33233.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33233.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33233):map__33233);
var name = cljs.core.get.call(null,map__33233__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__33109__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"new cljs.core.Var(function(){return ",cljs.compiler.munge.call(null,name),";},",sym,",",meta,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"meta","meta",1499536964),(function (p__33235){
var map__33236 = p__33235;
var map__33236__$1 = ((((!((map__33236 == null)))?((((map__33236.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33236.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33236):map__33236);
var expr = cljs.core.get.call(null,map__33236__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.call(null,map__33236__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.call(null,map__33236__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__33109__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"cljs.core.with_meta(",expr,",",meta,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.array_map_threshold = (8);
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
return (cljs.core.every_QMARK_.call(null,(function (p1__33238_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__33238_SHARP_),new cljs.core.Keyword(null,"constant","constant",-379609303));
}),keys)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,keys)),cljs.core.count.call(null,keys)));
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__33239){
var map__33240 = p__33239;
var map__33240__$1 = ((((!((map__33240 == null)))?((((map__33240.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33240.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33240):map__33240);
var env = cljs.core.get.call(null,map__33240__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.call(null,map__33240__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.call(null,map__33240__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__33109__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if((cljs.core.count.call(null,keys) === (0))){
cljs.compiler.emits.call(null,"cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count.call(null,keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_(cljs.compiler.distinct_keys_QMARK_.call(null,keys))){
cljs.compiler.emits.call(null,"new cljs.core.PersistentArrayMap(null, ",cljs.core.count.call(null,keys),", [",cljs.compiler.comma_sep.call(null,cljs.core.interleave.call(null,keys,vals)),"], null)");
} else {
cljs.compiler.emits.call(null,"cljs.core.PersistentArrayMap.createAsIfByAssoc([",cljs.compiler.comma_sep.call(null,cljs.core.interleave.call(null,keys,vals)),"])");
}
} else {
cljs.compiler.emits.call(null,"cljs.core.PersistentHashMap.fromArrays([",cljs.compiler.comma_sep.call(null,keys),"],[",cljs.compiler.comma_sep.call(null,vals),"])");

}
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"list","list",765357683),(function (p__33242){
var map__33243 = p__33242;
var map__33243__$1 = ((((!((map__33243 == null)))?((((map__33243.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33243.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33243):map__33243);
var items = cljs.core.get.call(null,map__33243__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__33243__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__33109__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.empty_QMARK_.call(null,items)){
cljs.compiler.emits.call(null,"cljs.core.List.EMPTY");
} else {
cljs.compiler.emits.call(null,"cljs.core.list(",cljs.compiler.comma_sep.call(null,items),")");
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__33245){
var map__33246 = p__33245;
var map__33246__$1 = ((((!((map__33246 == null)))?((((map__33246.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33246.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33246):map__33246);
var items = cljs.core.get.call(null,map__33246__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__33246__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__33109__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.empty_QMARK_.call(null,items)){
cljs.compiler.emits.call(null,"cljs.core.PersistentVector.EMPTY");
} else {
var cnt_33248 = cljs.core.count.call(null,items);
if((cnt_33248 < (32))){
cljs.compiler.emits.call(null,"new cljs.core.PersistentVector(null, ",cnt_33248,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",cljs.compiler.comma_sep.call(null,items),"], null)");
} else {
cljs.compiler.emits.call(null,"cljs.core.PersistentVector.fromArray([",cljs.compiler.comma_sep.call(null,items),"], true)");
}
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
return (cljs.core.every_QMARK_.call(null,(function (p1__33249_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__33249_SHARP_),new cljs.core.Keyword(null,"constant","constant",-379609303));
}),items)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,items)),cljs.core.count.call(null,items)));
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"set","set",304602554),(function (p__33250){
var map__33251 = p__33250;
var map__33251__$1 = ((((!((map__33251 == null)))?((((map__33251.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33251.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33251):map__33251);
var items = cljs.core.get.call(null,map__33251__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__33251__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__33109__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.empty_QMARK_.call(null,items)){
cljs.compiler.emits.call(null,"cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_(cljs.compiler.distinct_constants_QMARK_.call(null,items))){
cljs.compiler.emits.call(null,"new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count.call(null,items),", [",cljs.compiler.comma_sep.call(null,cljs.core.interleave.call(null,items,cljs.core.repeat.call(null,"null"))),"], null), null)");
} else {
cljs.compiler.emits.call(null,"cljs.core.PersistentHashSet.createAsIfByAssoc([",cljs.compiler.comma_sep.call(null,items),"])");

}
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-value","js-value",-758336661),(function (p__33253){
var map__33254 = p__33253;
var map__33254__$1 = ((((!((map__33254 == null)))?((((map__33254.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33254.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33254):map__33254);
var items = cljs.core.get.call(null,map__33254__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var js_type = cljs.core.get.call(null,map__33254__$1,new cljs.core.Keyword(null,"js-type","js-type",539386702));
var env = cljs.core.get.call(null,map__33254__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__33109__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core._EQ_.call(null,js_type,new cljs.core.Keyword(null,"object","object",1474613949))){
cljs.compiler.emits.call(null,"({");

var temp__4657__auto___33272 = cljs.core.seq.call(null,items);
if(temp__4657__auto___33272){
var items_33273__$1 = temp__4657__auto___33272;
var vec__33256_33274 = items_33273__$1;
var seq__33257_33275 = cljs.core.seq.call(null,vec__33256_33274);
var first__33258_33276 = cljs.core.first.call(null,seq__33257_33275);
var seq__33257_33277__$1 = cljs.core.next.call(null,seq__33257_33275);
var vec__33259_33278 = first__33258_33276;
var k_33279 = cljs.core.nth.call(null,vec__33259_33278,(0),null);
var v_33280 = cljs.core.nth.call(null,vec__33259_33278,(1),null);
var r_33281 = seq__33257_33277__$1;
cljs.compiler.emits.call(null,"\"",cljs.core.name.call(null,k_33279),"\": ",v_33280);

var seq__33262_33282 = cljs.core.seq.call(null,r_33281);
var chunk__33263_33283 = null;
var count__33264_33284 = (0);
var i__33265_33285 = (0);
while(true){
if((i__33265_33285 < count__33264_33284)){
var vec__33266_33286 = cljs.core._nth.call(null,chunk__33263_33283,i__33265_33285);
var k_33287__$1 = cljs.core.nth.call(null,vec__33266_33286,(0),null);
var v_33288__$1 = cljs.core.nth.call(null,vec__33266_33286,(1),null);
cljs.compiler.emits.call(null,", \"",cljs.core.name.call(null,k_33287__$1),"\": ",v_33288__$1);

var G__33289 = seq__33262_33282;
var G__33290 = chunk__33263_33283;
var G__33291 = count__33264_33284;
var G__33292 = (i__33265_33285 + (1));
seq__33262_33282 = G__33289;
chunk__33263_33283 = G__33290;
count__33264_33284 = G__33291;
i__33265_33285 = G__33292;
continue;
} else {
var temp__4657__auto___33293__$1 = cljs.core.seq.call(null,seq__33262_33282);
if(temp__4657__auto___33293__$1){
var seq__33262_33294__$1 = temp__4657__auto___33293__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33262_33294__$1)){
var c__28828__auto___33295 = cljs.core.chunk_first.call(null,seq__33262_33294__$1);
var G__33296 = cljs.core.chunk_rest.call(null,seq__33262_33294__$1);
var G__33297 = c__28828__auto___33295;
var G__33298 = cljs.core.count.call(null,c__28828__auto___33295);
var G__33299 = (0);
seq__33262_33282 = G__33296;
chunk__33263_33283 = G__33297;
count__33264_33284 = G__33298;
i__33265_33285 = G__33299;
continue;
} else {
var vec__33269_33300 = cljs.core.first.call(null,seq__33262_33294__$1);
var k_33301__$1 = cljs.core.nth.call(null,vec__33269_33300,(0),null);
var v_33302__$1 = cljs.core.nth.call(null,vec__33269_33300,(1),null);
cljs.compiler.emits.call(null,", \"",cljs.core.name.call(null,k_33301__$1),"\": ",v_33302__$1);

var G__33303 = cljs.core.next.call(null,seq__33262_33294__$1);
var G__33304 = null;
var G__33305 = (0);
var G__33306 = (0);
seq__33262_33282 = G__33303;
chunk__33263_33283 = G__33304;
count__33264_33284 = G__33305;
i__33265_33285 = G__33306;
continue;
}
} else {
}
}
break;
}
} else {
}

cljs.compiler.emits.call(null,"})");
} else {
cljs.compiler.emits.call(null,"[",cljs.compiler.comma_sep.call(null,items),"]");
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"record-value","record-value",-367500392),(function (p__33307){
var map__33308 = p__33307;
var map__33308__$1 = ((((!((map__33308 == null)))?((((map__33308.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33308.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33308):map__33308);
var items = cljs.core.get.call(null,map__33308__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var ns = cljs.core.get.call(null,map__33308__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var name = cljs.core.get.call(null,map__33308__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.call(null,map__33308__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__33109__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,ns,".map__GT_",name,"(",items,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"constant","constant",-379609303),(function (p__33310){
var map__33311 = p__33310;
var map__33311__$1 = ((((!((map__33311 == null)))?((((map__33311.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33311.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33311):map__33311);
var form = cljs.core.get.call(null,map__33311__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.call(null,map__33311__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__33109__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_constant.call(null,form);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(p__33313){
var map__33314 = p__33313;
var map__33314__$1 = ((((!((map__33314 == null)))?((((map__33314.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33314.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33314):map__33314);
var op = cljs.core.get.call(null,map__33314__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.call(null,map__33314__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.call(null,map__33314__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__27989__auto__ = (function (){var and__27977__auto__ = cljs.core._EQ_.call(null,op,new cljs.core.Keyword(null,"constant","constant",-379609303));
if(and__27977__auto__){
var and__27977__auto____$1 = form;
if(cljs.core.truth_(and__27977__auto____$1)){
return !(((typeof form === 'string') && (cljs.core._EQ_.call(null,form,""))) || ((typeof form === 'number') && ((form === (0)))));
} else {
return and__27977__auto____$1;
}
} else {
return and__27977__auto__;
}
})();
if(cljs.core.truth_(or__27989__auto__)){
return or__27989__auto__;
} else {
var and__27977__auto__ = !((const_expr == null));
if(and__27977__auto__){
return cljs.compiler.truthy_constant_QMARK_.call(null,const_expr);
} else {
return and__27977__auto__;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(p__33316){
var map__33317 = p__33316;
var map__33317__$1 = ((((!((map__33317 == null)))?((((map__33317.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33317.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33317):map__33317);
var op = cljs.core.get.call(null,map__33317__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.call(null,map__33317__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.call(null,map__33317__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__27989__auto__ = (cljs.core._EQ_.call(null,op,new cljs.core.Keyword(null,"constant","constant",-379609303))) && ((form === false) || ((form == null)));
if(or__27989__auto__){
return or__27989__auto__;
} else {
var and__27977__auto__ = !((const_expr == null));
if(and__27977__auto__){
return cljs.compiler.falsey_constant_QMARK_.call(null,const_expr);
} else {
return and__27977__auto__;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag.call(null,env,e);
var or__27989__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null).call(null,tag);
if(cljs.core.truth_(or__27989__auto__)){
return or__27989__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_.call(null,e);
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__33319){
var map__33320 = p__33319;
var map__33320__$1 = ((((!((map__33320 == null)))?((((map__33320.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33320.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33320):map__33320);
var test = cljs.core.get.call(null,map__33320__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.call(null,map__33320__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.call(null,map__33320__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.call(null,map__33320__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.call(null,map__33320__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not.call(null,(function (){var or__27989__auto__ = unchecked;
if(cljs.core.truth_(or__27989__auto__)){
return or__27989__auto__;
} else {
return cljs.compiler.safe_test_QMARK_.call(null,env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_.call(null,test))){
return cljs.compiler.emitln.call(null,then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_.call(null,test))){
return cljs.compiler.emitln.call(null,else$);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"(",((checked)?"cljs.core.truth_":null),"(",test,")?",then,":",else$,")");
} else {
if(checked){
cljs.compiler.emitln.call(null,"if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.call(null,"if(",test,"){");
}

cljs.compiler.emitln.call(null,then,"} else {");

return cljs.compiler.emitln.call(null,else$,"}");
}

}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"case*","case*",716180697),(function (p__33322){
var map__33323 = p__33322;
var map__33323__$1 = ((((!((map__33323 == null)))?((((map__33323.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33323.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33323):map__33323);
var v = cljs.core.get.call(null,map__33323__$1,new cljs.core.Keyword(null,"v","v",21465059));
var tests = cljs.core.get.call(null,map__33323__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var thens = cljs.core.get.call(null,map__33323__$1,new cljs.core.Keyword(null,"thens","thens",226631442));
var default$ = cljs.core.get.call(null,map__33323__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.call(null,map__33323__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.call(null,"(function(){");
} else {
}

var gs = cljs.core.gensym.call(null,"caseval__");
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"var ",gs,";");
} else {
}

cljs.compiler.emitln.call(null,"switch (",v,") {");

var seq__33325_33343 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),cljs.core.interleave.call(null,tests,thens)));
var chunk__33326_33344 = null;
var count__33327_33345 = (0);
var i__33328_33346 = (0);
while(true){
if((i__33328_33346 < count__33327_33345)){
var vec__33329_33347 = cljs.core._nth.call(null,chunk__33326_33344,i__33328_33346);
var ts_33348 = cljs.core.nth.call(null,vec__33329_33347,(0),null);
var then_33349 = cljs.core.nth.call(null,vec__33329_33347,(1),null);
var seq__33332_33350 = cljs.core.seq.call(null,ts_33348);
var chunk__33333_33351 = null;
var count__33334_33352 = (0);
var i__33335_33353 = (0);
while(true){
if((i__33335_33353 < count__33334_33352)){
var test_33354 = cljs.core._nth.call(null,chunk__33333_33351,i__33335_33353);
cljs.compiler.emitln.call(null,"case ",test_33354,":");

var G__33355 = seq__33332_33350;
var G__33356 = chunk__33333_33351;
var G__33357 = count__33334_33352;
var G__33358 = (i__33335_33353 + (1));
seq__33332_33350 = G__33355;
chunk__33333_33351 = G__33356;
count__33334_33352 = G__33357;
i__33335_33353 = G__33358;
continue;
} else {
var temp__4657__auto___33359 = cljs.core.seq.call(null,seq__33332_33350);
if(temp__4657__auto___33359){
var seq__33332_33360__$1 = temp__4657__auto___33359;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33332_33360__$1)){
var c__28828__auto___33361 = cljs.core.chunk_first.call(null,seq__33332_33360__$1);
var G__33362 = cljs.core.chunk_rest.call(null,seq__33332_33360__$1);
var G__33363 = c__28828__auto___33361;
var G__33364 = cljs.core.count.call(null,c__28828__auto___33361);
var G__33365 = (0);
seq__33332_33350 = G__33362;
chunk__33333_33351 = G__33363;
count__33334_33352 = G__33364;
i__33335_33353 = G__33365;
continue;
} else {
var test_33366 = cljs.core.first.call(null,seq__33332_33360__$1);
cljs.compiler.emitln.call(null,"case ",test_33366,":");

var G__33367 = cljs.core.next.call(null,seq__33332_33360__$1);
var G__33368 = null;
var G__33369 = (0);
var G__33370 = (0);
seq__33332_33350 = G__33367;
chunk__33333_33351 = G__33368;
count__33334_33352 = G__33369;
i__33335_33353 = G__33370;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",then_33349);
} else {
cljs.compiler.emitln.call(null,then_33349);
}

cljs.compiler.emitln.call(null,"break;");

var G__33371 = seq__33325_33343;
var G__33372 = chunk__33326_33344;
var G__33373 = count__33327_33345;
var G__33374 = (i__33328_33346 + (1));
seq__33325_33343 = G__33371;
chunk__33326_33344 = G__33372;
count__33327_33345 = G__33373;
i__33328_33346 = G__33374;
continue;
} else {
var temp__4657__auto___33375 = cljs.core.seq.call(null,seq__33325_33343);
if(temp__4657__auto___33375){
var seq__33325_33376__$1 = temp__4657__auto___33375;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33325_33376__$1)){
var c__28828__auto___33377 = cljs.core.chunk_first.call(null,seq__33325_33376__$1);
var G__33378 = cljs.core.chunk_rest.call(null,seq__33325_33376__$1);
var G__33379 = c__28828__auto___33377;
var G__33380 = cljs.core.count.call(null,c__28828__auto___33377);
var G__33381 = (0);
seq__33325_33343 = G__33378;
chunk__33326_33344 = G__33379;
count__33327_33345 = G__33380;
i__33328_33346 = G__33381;
continue;
} else {
var vec__33336_33382 = cljs.core.first.call(null,seq__33325_33376__$1);
var ts_33383 = cljs.core.nth.call(null,vec__33336_33382,(0),null);
var then_33384 = cljs.core.nth.call(null,vec__33336_33382,(1),null);
var seq__33339_33385 = cljs.core.seq.call(null,ts_33383);
var chunk__33340_33386 = null;
var count__33341_33387 = (0);
var i__33342_33388 = (0);
while(true){
if((i__33342_33388 < count__33341_33387)){
var test_33389 = cljs.core._nth.call(null,chunk__33340_33386,i__33342_33388);
cljs.compiler.emitln.call(null,"case ",test_33389,":");

var G__33390 = seq__33339_33385;
var G__33391 = chunk__33340_33386;
var G__33392 = count__33341_33387;
var G__33393 = (i__33342_33388 + (1));
seq__33339_33385 = G__33390;
chunk__33340_33386 = G__33391;
count__33341_33387 = G__33392;
i__33342_33388 = G__33393;
continue;
} else {
var temp__4657__auto___33394__$1 = cljs.core.seq.call(null,seq__33339_33385);
if(temp__4657__auto___33394__$1){
var seq__33339_33395__$1 = temp__4657__auto___33394__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33339_33395__$1)){
var c__28828__auto___33396 = cljs.core.chunk_first.call(null,seq__33339_33395__$1);
var G__33397 = cljs.core.chunk_rest.call(null,seq__33339_33395__$1);
var G__33398 = c__28828__auto___33396;
var G__33399 = cljs.core.count.call(null,c__28828__auto___33396);
var G__33400 = (0);
seq__33339_33385 = G__33397;
chunk__33340_33386 = G__33398;
count__33341_33387 = G__33399;
i__33342_33388 = G__33400;
continue;
} else {
var test_33401 = cljs.core.first.call(null,seq__33339_33395__$1);
cljs.compiler.emitln.call(null,"case ",test_33401,":");

var G__33402 = cljs.core.next.call(null,seq__33339_33395__$1);
var G__33403 = null;
var G__33404 = (0);
var G__33405 = (0);
seq__33339_33385 = G__33402;
chunk__33340_33386 = G__33403;
count__33341_33387 = G__33404;
i__33342_33388 = G__33405;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",then_33384);
} else {
cljs.compiler.emitln.call(null,then_33384);
}

cljs.compiler.emitln.call(null,"break;");

var G__33406 = cljs.core.next.call(null,seq__33325_33376__$1);
var G__33407 = null;
var G__33408 = (0);
var G__33409 = (0);
seq__33325_33343 = G__33406;
chunk__33326_33344 = G__33407;
count__33327_33345 = G__33408;
i__33328_33346 = G__33409;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.call(null,"default:");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",default$);
} else {
cljs.compiler.emitln.call(null,default$);
}
} else {
}

cljs.compiler.emitln.call(null,"}");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.call(null,"return ",gs,";})()");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__33410){
var map__33411 = p__33410;
var map__33411__$1 = ((((!((map__33411 == null)))?((((map__33411.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33411.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33411):map__33411);
var throw$ = cljs.core.get.call(null,map__33411__$1,new cljs.core.Keyword(null,"throw","throw",-1044625833));
var env = cljs.core.get.call(null,map__33411__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.call(null,"(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.call(null,"throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.call(null,cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.call(null,cljs.compiler.mapped_types,t))){
return cljs.core.get.call(null,cljs.compiler.mapped_types,t);
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"!"))){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.resolve_type.call(null,env,cljs.core.subs.call(null,t,(1))))].join('');
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"{"))){
return t;
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"function"))){
var idx = t.lastIndexOf(":");
var vec__33414 = ((!(((-1) === idx)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.call(null,t,(0),idx),cljs.core.subs.call(null,t,(idx + (1)),cljs.core.count.call(null,t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.call(null,vec__33414,(0),null);
var rstr = cljs.core.nth.call(null,vec__33414,(1),null);
var ret_t = (cljs.core.truth_(rstr)?cljs.compiler.resolve_type.call(null,env,rstr):null);
var axstr = cljs.core.subs.call(null,fstr,(9),(cljs.core.count.call(null,fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_.call(null,axstr))?null:cljs.core.map.call(null,cljs.core.comp.call(null,((function (idx,vec__33414,fstr,rstr,ret_t,axstr){
return (function (p1__33413_SHARP_){
return cljs.compiler.resolve_type.call(null,env,p1__33413_SHARP_);
});})(idx,vec__33414,fstr,rstr,ret_t,axstr))
,clojure.string.trim),clojure.string.split.call(null,axstr,/,/)));
var G__33417 = ["function(",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.call(null,",",args_ts)),")"].join('');
if(cljs.core.truth_(ret_t)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__33417),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__33417;
}
} else {
if(cljs.core.truth_(goog.string.endsWith(t,"="))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.resolve_type.call(null,env,cljs.core.subs.call(null,t,(0),(cljs.core.count.call(null,t) - (1))))),"="].join('');
} else {
return cljs.compiler.munge.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.call(null,env,cljs.core.symbol.call(null,t))))].join(''));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.call(null,clojure.string.trim.call(null,ts),(1),(cljs.core.count.call(null,ts) - (1)));
var xs = clojure.string.split.call(null,ts__$1,/\|/);
return ["{",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.call(null,"|",cljs.core.map.call(null,((function (ts__$1,xs){
return (function (p1__33418_SHARP_){
return cljs.compiler.resolve_type.call(null,env,p1__33418_SHARP_);
});})(ts__$1,xs))
,xs))),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find.call(null,/@param/,line))){
var vec__33419 = cljs.core.map.call(null,clojure.string.trim,clojure.string.split.call(null,clojure.string.trim.call(null,line),/ /));
var seq__33420 = cljs.core.seq.call(null,vec__33419);
var first__33421 = cljs.core.first.call(null,seq__33420);
var seq__33420__$1 = cljs.core.next.call(null,seq__33420);
var p = first__33421;
var first__33421__$1 = cljs.core.first.call(null,seq__33420__$1);
var seq__33420__$2 = cljs.core.next.call(null,seq__33420__$1);
var ts = first__33421__$1;
var first__33421__$2 = cljs.core.first.call(null,seq__33420__$2);
var seq__33420__$3 = cljs.core.next.call(null,seq__33420__$2);
var n = first__33421__$2;
var xs = seq__33420__$3;
if(cljs.core.truth_((function (){var and__27977__auto__ = cljs.core._EQ_.call(null,"@param",p);
if(and__27977__auto__){
var and__27977__auto____$1 = ts;
if(cljs.core.truth_(and__27977__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__27977__auto____$1;
}
} else {
return and__27977__auto__;
}
})())){
return clojure.string.join.call(null," ",cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types.call(null,env,ts),cljs.compiler.munge.call(null,n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find.call(null,/@return/,line))){
var vec__33422 = cljs.core.map.call(null,clojure.string.trim,clojure.string.split.call(null,clojure.string.trim.call(null,line),/ /));
var seq__33423 = cljs.core.seq.call(null,vec__33422);
var first__33424 = cljs.core.first.call(null,seq__33423);
var seq__33423__$1 = cljs.core.next.call(null,seq__33423);
var p = first__33424;
var first__33424__$1 = cljs.core.first.call(null,seq__33423__$1);
var seq__33423__$2 = cljs.core.next.call(null,seq__33423__$1);
var ts = first__33424__$1;
var xs = seq__33423__$2;
if(cljs.core.truth_((function (){var and__27977__auto__ = cljs.core._EQ_.call(null,"@return",p);
if(and__27977__auto__){
var and__27977__auto____$1 = ts;
if(cljs.core.truth_(and__27977__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__27977__auto____$1;
}
} else {
return and__27977__auto__;
}
})())){
return clojure.string.join.call(null," ",cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types.call(null,env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null).call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null)));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__33427 = arguments.length;
switch (G__33427) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.call(null,null,doc,jsdoc);
});

cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.call(null,docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = ((function (docs,docs__$1,docs__$2){
return (function cljs$compiler$print_comment_lines(e){
var vec__33435 = cljs.core.map.call(null,((function (docs,docs__$1,docs__$2){
return (function (p1__33425_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_.call(null))){
return cljs.compiler.munge_param_return.call(null,env,p1__33425_SHARP_);
} else {
return p1__33425_SHARP_;
}
});})(docs,docs__$1,docs__$2))
,clojure.string.split_lines.call(null,e));
var seq__33436 = cljs.core.seq.call(null,vec__33435);
var first__33437 = cljs.core.first.call(null,seq__33436);
var seq__33436__$1 = cljs.core.next.call(null,seq__33436);
var x = first__33437;
var ys = seq__33436__$1;
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,x,"*/","* /"));

var seq__33438 = cljs.core.seq.call(null,ys);
var chunk__33439 = null;
var count__33440 = (0);
var i__33441 = (0);
while(true){
if((i__33441 < count__33440)){
var next_line = cljs.core._nth.call(null,chunk__33439,i__33441);
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,clojure.string.replace.call(null,next_line,/^   /,""),"*/","* /"));

var G__33447 = seq__33438;
var G__33448 = chunk__33439;
var G__33449 = count__33440;
var G__33450 = (i__33441 + (1));
seq__33438 = G__33447;
chunk__33439 = G__33448;
count__33440 = G__33449;
i__33441 = G__33450;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__33438);
if(temp__4657__auto__){
var seq__33438__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33438__$1)){
var c__28828__auto__ = cljs.core.chunk_first.call(null,seq__33438__$1);
var G__33451 = cljs.core.chunk_rest.call(null,seq__33438__$1);
var G__33452 = c__28828__auto__;
var G__33453 = cljs.core.count.call(null,c__28828__auto__);
var G__33454 = (0);
seq__33438 = G__33451;
chunk__33439 = G__33452;
count__33440 = G__33453;
i__33441 = G__33454;
continue;
} else {
var next_line = cljs.core.first.call(null,seq__33438__$1);
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,clojure.string.replace.call(null,next_line,/^   /,""),"*/","* /"));

var G__33455 = cljs.core.next.call(null,seq__33438__$1);
var G__33456 = null;
var G__33457 = (0);
var G__33458 = (0);
seq__33438 = G__33455;
chunk__33439 = G__33456;
count__33440 = G__33457;
i__33441 = G__33458;
continue;
}
} else {
return null;
}
}
break;
}
});})(docs,docs__$1,docs__$2))
;
if(cljs.core.seq.call(null,docs__$2)){
cljs.compiler.emitln.call(null,"/**");

var seq__33442_33459 = cljs.core.seq.call(null,docs__$2);
var chunk__33443_33460 = null;
var count__33444_33461 = (0);
var i__33445_33462 = (0);
while(true){
if((i__33445_33462 < count__33444_33461)){
var e_33463 = cljs.core._nth.call(null,chunk__33443_33460,i__33445_33462);
if(cljs.core.truth_(e_33463)){
print_comment_lines.call(null,e_33463);
} else {
}

var G__33464 = seq__33442_33459;
var G__33465 = chunk__33443_33460;
var G__33466 = count__33444_33461;
var G__33467 = (i__33445_33462 + (1));
seq__33442_33459 = G__33464;
chunk__33443_33460 = G__33465;
count__33444_33461 = G__33466;
i__33445_33462 = G__33467;
continue;
} else {
var temp__4657__auto___33468 = cljs.core.seq.call(null,seq__33442_33459);
if(temp__4657__auto___33468){
var seq__33442_33469__$1 = temp__4657__auto___33468;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33442_33469__$1)){
var c__28828__auto___33470 = cljs.core.chunk_first.call(null,seq__33442_33469__$1);
var G__33471 = cljs.core.chunk_rest.call(null,seq__33442_33469__$1);
var G__33472 = c__28828__auto___33470;
var G__33473 = cljs.core.count.call(null,c__28828__auto___33470);
var G__33474 = (0);
seq__33442_33459 = G__33471;
chunk__33443_33460 = G__33472;
count__33444_33461 = G__33473;
i__33445_33462 = G__33474;
continue;
} else {
var e_33475 = cljs.core.first.call(null,seq__33442_33469__$1);
if(cljs.core.truth_(e_33475)){
print_comment_lines.call(null,e_33475);
} else {
}

var G__33476 = cljs.core.next.call(null,seq__33442_33469__$1);
var G__33477 = null;
var G__33478 = (0);
var G__33479 = (0);
seq__33442_33459 = G__33476;
chunk__33443_33460 = G__33477;
count__33444_33461 = G__33478;
i__33445_33462 = G__33479;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.call(null," */");
} else {
return null;
}
});

cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3;

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return (typeof x === 'string') || (x === true) || (x === false) || (typeof x === 'number');
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__27977__auto__ = cljs.core.some.call(null,((function (opts){
return (function (p1__33481_SHARP_){
return goog.string.startsWith(p1__33481_SHARP_,"@define");
});})(opts))
,jsdoc);
if(cljs.core.truth_(and__27977__auto__)){
var and__27977__auto____$1 = opts;
if(cljs.core.truth_(and__27977__auto____$1)){
var and__27977__auto____$2 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478));
if(and__27977__auto____$2){
var define = cljs.core.get_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)].join('')], null));
if(cljs.core.truth_(cljs.compiler.valid_define_value_QMARK_.call(null,define))){
return cljs.core.pr_str.call(null,define);
} else {
return null;
}
} else {
return and__27977__auto____$2;
}
} else {
return and__27977__auto____$1;
}
} else {
return and__27977__auto__;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__33482){
var map__33483 = p__33482;
var map__33483__$1 = ((((!((map__33483 == null)))?((((map__33483.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33483.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33483):map__33483);
var name = cljs.core.get.call(null,map__33483__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var var$ = cljs.core.get.call(null,map__33483__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var init = cljs.core.get.call(null,map__33483__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var env = cljs.core.get.call(null,map__33483__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var doc = cljs.core.get.call(null,map__33483__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.call(null,map__33483__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var export$ = cljs.core.get.call(null,map__33483__$1,new cljs.core.Keyword(null,"export","export",214356590));
var test = cljs.core.get.call(null,map__33483__$1,new cljs.core.Keyword(null,"test","test",577538877));
var var_ast = cljs.core.get.call(null,map__33483__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__27989__auto__ = init;
if(cljs.core.truth_(or__27989__auto__)){
return or__27989__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.call(null,name);
cljs.compiler.emit_comment.call(null,env,doc,cljs.core.concat.call(null,jsdoc,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"(function (){");
} else {
}

cljs.compiler.emits.call(null,var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.call(null," = ",(function (){var temp__4655__auto__ = cljs.compiler.get_define.call(null,mname,jsdoc);
if(cljs.core.truth_(temp__4655__auto__)){
var define = temp__4655__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"; return (");

cljs.compiler.emits.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"var-special","var-special",1131576802),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.call(null,env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast));

cljs.compiler.emitln.call(null,");})()");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,")");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.call(null,";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.call(null,"goog.exportSymbol('",cljs.compiler.munge.call(null,export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__27977__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(and__27977__auto__){
return test;
} else {
return and__27977__auto__;
}
})())){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,";");
} else {
}

return cljs.compiler.emitln.call(null,var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__33485){
var map__33486 = p__33485;
var map__33486__$1 = ((((!((map__33486 == null)))?((((map__33486.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33486.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33486):map__33486);
var name = cljs.core.get.call(null,map__33486__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__33486__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__33486__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.call(null,"arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,name)),"__delegate"].join('');
cljs.compiler.emitln.call(null,"(function (",arglist,"){");

var seq__33488_33506 = cljs.core.seq.call(null,cljs.core.map_indexed.call(null,cljs.core.vector,cljs.core.drop_last.call(null,(2),params)));
var chunk__33489_33507 = null;
var count__33490_33508 = (0);
var i__33491_33509 = (0);
while(true){
if((i__33491_33509 < count__33490_33508)){
var vec__33492_33510 = cljs.core._nth.call(null,chunk__33489_33507,i__33491_33509);
var i_33511 = cljs.core.nth.call(null,vec__33492_33510,(0),null);
var param_33512 = cljs.core.nth.call(null,vec__33492_33510,(1),null);
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,param_33512);

cljs.compiler.emits.call(null," = cljs.core.first(");

cljs.compiler.emitln.call(null,arglist,");");

cljs.compiler.emitln.call(null,arglist," = cljs.core.next(",arglist,");");

var G__33513 = seq__33488_33506;
var G__33514 = chunk__33489_33507;
var G__33515 = count__33490_33508;
var G__33516 = (i__33491_33509 + (1));
seq__33488_33506 = G__33513;
chunk__33489_33507 = G__33514;
count__33490_33508 = G__33515;
i__33491_33509 = G__33516;
continue;
} else {
var temp__4657__auto___33517 = cljs.core.seq.call(null,seq__33488_33506);
if(temp__4657__auto___33517){
var seq__33488_33518__$1 = temp__4657__auto___33517;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33488_33518__$1)){
var c__28828__auto___33519 = cljs.core.chunk_first.call(null,seq__33488_33518__$1);
var G__33520 = cljs.core.chunk_rest.call(null,seq__33488_33518__$1);
var G__33521 = c__28828__auto___33519;
var G__33522 = cljs.core.count.call(null,c__28828__auto___33519);
var G__33523 = (0);
seq__33488_33506 = G__33520;
chunk__33489_33507 = G__33521;
count__33490_33508 = G__33522;
i__33491_33509 = G__33523;
continue;
} else {
var vec__33495_33524 = cljs.core.first.call(null,seq__33488_33518__$1);
var i_33525 = cljs.core.nth.call(null,vec__33495_33524,(0),null);
var param_33526 = cljs.core.nth.call(null,vec__33495_33524,(1),null);
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,param_33526);

cljs.compiler.emits.call(null," = cljs.core.first(");

cljs.compiler.emitln.call(null,arglist,");");

cljs.compiler.emitln.call(null,arglist," = cljs.core.next(",arglist,");");

var G__33527 = cljs.core.next.call(null,seq__33488_33518__$1);
var G__33528 = null;
var G__33529 = (0);
var G__33530 = (0);
seq__33488_33506 = G__33527;
chunk__33489_33507 = G__33528;
count__33490_33508 = G__33529;
i__33491_33509 = G__33530;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count.call(null,params))){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,cljs.core.butlast.call(null,params)));

cljs.compiler.emitln.call(null," = cljs.core.first(",arglist,");");

cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = cljs.core.rest(",arglist,");");

cljs.compiler.emits.call(null,"return ",delegate_name,"(");

var seq__33498_33531 = cljs.core.seq.call(null,params);
var chunk__33499_33532 = null;
var count__33500_33533 = (0);
var i__33501_33534 = (0);
while(true){
if((i__33501_33534 < count__33500_33533)){
var param_33535 = cljs.core._nth.call(null,chunk__33499_33532,i__33501_33534);
cljs.compiler.emit.call(null,param_33535);

if(cljs.core._EQ_.call(null,param_33535,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__33536 = seq__33498_33531;
var G__33537 = chunk__33499_33532;
var G__33538 = count__33500_33533;
var G__33539 = (i__33501_33534 + (1));
seq__33498_33531 = G__33536;
chunk__33499_33532 = G__33537;
count__33500_33533 = G__33538;
i__33501_33534 = G__33539;
continue;
} else {
var temp__4657__auto___33540 = cljs.core.seq.call(null,seq__33498_33531);
if(temp__4657__auto___33540){
var seq__33498_33541__$1 = temp__4657__auto___33540;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33498_33541__$1)){
var c__28828__auto___33542 = cljs.core.chunk_first.call(null,seq__33498_33541__$1);
var G__33543 = cljs.core.chunk_rest.call(null,seq__33498_33541__$1);
var G__33544 = c__28828__auto___33542;
var G__33545 = cljs.core.count.call(null,c__28828__auto___33542);
var G__33546 = (0);
seq__33498_33531 = G__33543;
chunk__33499_33532 = G__33544;
count__33500_33533 = G__33545;
i__33501_33534 = G__33546;
continue;
} else {
var param_33547 = cljs.core.first.call(null,seq__33498_33541__$1);
cljs.compiler.emit.call(null,param_33547);

if(cljs.core._EQ_.call(null,param_33547,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__33548 = cljs.core.next.call(null,seq__33498_33541__$1);
var G__33549 = null;
var G__33550 = (0);
var G__33551 = (0);
seq__33498_33531 = G__33548;
chunk__33499_33532 = G__33549;
count__33500_33533 = G__33550;
i__33501_33534 = G__33551;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,");");
} else {
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = cljs.core.seq(",arglist,");");

cljs.compiler.emits.call(null,"return ",delegate_name,"(");

var seq__33502_33552 = cljs.core.seq.call(null,params);
var chunk__33503_33553 = null;
var count__33504_33554 = (0);
var i__33505_33555 = (0);
while(true){
if((i__33505_33555 < count__33504_33554)){
var param_33556 = cljs.core._nth.call(null,chunk__33503_33553,i__33505_33555);
cljs.compiler.emit.call(null,param_33556);

if(cljs.core._EQ_.call(null,param_33556,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__33557 = seq__33502_33552;
var G__33558 = chunk__33503_33553;
var G__33559 = count__33504_33554;
var G__33560 = (i__33505_33555 + (1));
seq__33502_33552 = G__33557;
chunk__33503_33553 = G__33558;
count__33504_33554 = G__33559;
i__33505_33555 = G__33560;
continue;
} else {
var temp__4657__auto___33561 = cljs.core.seq.call(null,seq__33502_33552);
if(temp__4657__auto___33561){
var seq__33502_33562__$1 = temp__4657__auto___33561;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33502_33562__$1)){
var c__28828__auto___33563 = cljs.core.chunk_first.call(null,seq__33502_33562__$1);
var G__33564 = cljs.core.chunk_rest.call(null,seq__33502_33562__$1);
var G__33565 = c__28828__auto___33563;
var G__33566 = cljs.core.count.call(null,c__28828__auto___33563);
var G__33567 = (0);
seq__33502_33552 = G__33564;
chunk__33503_33553 = G__33565;
count__33504_33554 = G__33566;
i__33505_33555 = G__33567;
continue;
} else {
var param_33568 = cljs.core.first.call(null,seq__33502_33562__$1);
cljs.compiler.emit.call(null,param_33568);

if(cljs.core._EQ_.call(null,param_33568,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__33569 = cljs.core.next.call(null,seq__33502_33562__$1);
var G__33570 = null;
var G__33571 = (0);
var G__33572 = (0);
seq__33502_33552 = G__33569;
chunk__33503_33553 = G__33570;
count__33504_33554 = G__33571;
i__33505_33555 = G__33572;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,");");
}

return cljs.compiler.emits.call(null,"})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__33573 = cljs.core.seq.call(null,params);
var chunk__33574 = null;
var count__33575 = (0);
var i__33576 = (0);
while(true){
if((i__33576 < count__33575)){
var param = cljs.core._nth.call(null,chunk__33574,i__33576);
cljs.compiler.emit.call(null,param);

if(cljs.core._EQ_.call(null,param,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__33577 = seq__33573;
var G__33578 = chunk__33574;
var G__33579 = count__33575;
var G__33580 = (i__33576 + (1));
seq__33573 = G__33577;
chunk__33574 = G__33578;
count__33575 = G__33579;
i__33576 = G__33580;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__33573);
if(temp__4657__auto__){
var seq__33573__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33573__$1)){
var c__28828__auto__ = cljs.core.chunk_first.call(null,seq__33573__$1);
var G__33581 = cljs.core.chunk_rest.call(null,seq__33573__$1);
var G__33582 = c__28828__auto__;
var G__33583 = cljs.core.count.call(null,c__28828__auto__);
var G__33584 = (0);
seq__33573 = G__33581;
chunk__33574 = G__33582;
count__33575 = G__33583;
i__33576 = G__33584;
continue;
} else {
var param = cljs.core.first.call(null,seq__33573__$1);
cljs.compiler.emit.call(null,param);

if(cljs.core._EQ_.call(null,param,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__33585 = cljs.core.next.call(null,seq__33573__$1);
var G__33586 = null;
var G__33587 = (0);
var G__33588 = (0);
seq__33573 = G__33585;
chunk__33574 = G__33586;
count__33575 = G__33587;
i__33576 = G__33588;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__33589){
var map__33590 = p__33589;
var map__33590__$1 = ((((!((map__33590 == null)))?((((map__33590.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33590.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33590):map__33590);
var type = cljs.core.get.call(null,map__33590__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.call(null,map__33590__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var variadic = cljs.core.get.call(null,map__33590__$1,new cljs.core.Keyword(null,"variadic","variadic",882626057));
var params = cljs.core.get.call(null,map__33590__$1,new cljs.core.Keyword(null,"params","params",710516235));
var expr = cljs.core.get.call(null,map__33590__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var env = cljs.core.get.call(null,map__33590__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.call(null,map__33590__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var max_fixed_arity = cljs.core.get.call(null,map__33590__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var env__33109__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(function ",cljs.compiler.munge.call(null,name),"(");

cljs.compiler.emit_fn_params.call(null,params);

cljs.compiler.emitln.call(null,"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}

cljs.compiler.emits.call(null,"})");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if(((startslice >= (0))) && (cljs.core.integer_QMARK_.call(null,startslice))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.call(null,"var ",i," = 0, ",a," = new Array(arguments.length -  ",startslice,");");

cljs.compiler.emitln.call(null,"while (",i," < ",a,".length) {",a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}");

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__33592){
var map__33593 = p__33592;
var map__33593__$1 = ((((!((map__33593 == null)))?((((map__33593.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33593.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33593):map__33593);
var f = map__33593__$1;
var type = cljs.core.get.call(null,map__33593__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.call(null,map__33593__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var variadic = cljs.core.get.call(null,map__33593__$1,new cljs.core.Keyword(null,"variadic","variadic",882626057));
var params = cljs.core.get.call(null,map__33593__$1,new cljs.core.Keyword(null,"params","params",710516235));
var expr = cljs.core.get.call(null,map__33593__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var env = cljs.core.get.call(null,map__33593__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.call(null,map__33593__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var max_fixed_arity = cljs.core.get.call(null,map__33593__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var env__33109__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

var name_33603__$1 = (function (){var or__27989__auto__ = name;
if(cljs.core.truth_(or__27989__auto__)){
return or__27989__auto__;
} else {
return cljs.core.gensym.call(null);
}
})();
var mname_33604 = cljs.compiler.munge.call(null,name_33603__$1);
var delegate_name_33605 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_33604),"__delegate"].join('');
cljs.compiler.emitln.call(null,"(function() { ");

cljs.compiler.emits.call(null,"var ",delegate_name_33605," = function (");

var seq__33595_33606 = cljs.core.seq.call(null,params);
var chunk__33596_33607 = null;
var count__33597_33608 = (0);
var i__33598_33609 = (0);
while(true){
if((i__33598_33609 < count__33597_33608)){
var param_33610 = cljs.core._nth.call(null,chunk__33596_33607,i__33598_33609);
cljs.compiler.emit.call(null,param_33610);

if(cljs.core._EQ_.call(null,param_33610,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__33611 = seq__33595_33606;
var G__33612 = chunk__33596_33607;
var G__33613 = count__33597_33608;
var G__33614 = (i__33598_33609 + (1));
seq__33595_33606 = G__33611;
chunk__33596_33607 = G__33612;
count__33597_33608 = G__33613;
i__33598_33609 = G__33614;
continue;
} else {
var temp__4657__auto___33615 = cljs.core.seq.call(null,seq__33595_33606);
if(temp__4657__auto___33615){
var seq__33595_33616__$1 = temp__4657__auto___33615;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33595_33616__$1)){
var c__28828__auto___33617 = cljs.core.chunk_first.call(null,seq__33595_33616__$1);
var G__33618 = cljs.core.chunk_rest.call(null,seq__33595_33616__$1);
var G__33619 = c__28828__auto___33617;
var G__33620 = cljs.core.count.call(null,c__28828__auto___33617);
var G__33621 = (0);
seq__33595_33606 = G__33618;
chunk__33596_33607 = G__33619;
count__33597_33608 = G__33620;
i__33598_33609 = G__33621;
continue;
} else {
var param_33622 = cljs.core.first.call(null,seq__33595_33616__$1);
cljs.compiler.emit.call(null,param_33622);

if(cljs.core._EQ_.call(null,param_33622,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__33623 = cljs.core.next.call(null,seq__33595_33616__$1);
var G__33624 = null;
var G__33625 = (0);
var G__33626 = (0);
seq__33595_33606 = G__33623;
chunk__33596_33607 = G__33624;
count__33597_33608 = G__33625;
i__33598_33609 = G__33626;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}

cljs.compiler.emitln.call(null,"};");

cljs.compiler.emitln.call(null,"var ",mname_33604," = function (",cljs.compiler.comma_sep.call(null,(cljs.core.truth_(variadic)?cljs.core.concat.call(null,cljs.core.butlast.call(null,params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",(cljs.core.count.call(null,params) - (1)),") {");

var a_33627 = cljs.compiler.emit_arguments_to_array.call(null,(cljs.core.count.call(null,params) - (1)));
cljs.compiler.emitln.call(null,"  ",cljs.core.last.call(null,params)," = new cljs.core.IndexedSeq(",a_33627,",0,null);");

cljs.compiler.emitln.call(null,"} ");
} else {
}

cljs.compiler.emits.call(null,"return ",delegate_name_33605,".call(this,");

var seq__33599_33628 = cljs.core.seq.call(null,params);
var chunk__33600_33629 = null;
var count__33601_33630 = (0);
var i__33602_33631 = (0);
while(true){
if((i__33602_33631 < count__33601_33630)){
var param_33632 = cljs.core._nth.call(null,chunk__33600_33629,i__33602_33631);
cljs.compiler.emit.call(null,param_33632);

if(cljs.core._EQ_.call(null,param_33632,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__33633 = seq__33599_33628;
var G__33634 = chunk__33600_33629;
var G__33635 = count__33601_33630;
var G__33636 = (i__33602_33631 + (1));
seq__33599_33628 = G__33633;
chunk__33600_33629 = G__33634;
count__33601_33630 = G__33635;
i__33602_33631 = G__33636;
continue;
} else {
var temp__4657__auto___33637 = cljs.core.seq.call(null,seq__33599_33628);
if(temp__4657__auto___33637){
var seq__33599_33638__$1 = temp__4657__auto___33637;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33599_33638__$1)){
var c__28828__auto___33639 = cljs.core.chunk_first.call(null,seq__33599_33638__$1);
var G__33640 = cljs.core.chunk_rest.call(null,seq__33599_33638__$1);
var G__33641 = c__28828__auto___33639;
var G__33642 = cljs.core.count.call(null,c__28828__auto___33639);
var G__33643 = (0);
seq__33599_33628 = G__33640;
chunk__33600_33629 = G__33641;
count__33601_33630 = G__33642;
i__33602_33631 = G__33643;
continue;
} else {
var param_33644 = cljs.core.first.call(null,seq__33599_33638__$1);
cljs.compiler.emit.call(null,param_33644);

if(cljs.core._EQ_.call(null,param_33644,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__33645 = cljs.core.next.call(null,seq__33599_33638__$1);
var G__33646 = null;
var G__33647 = (0);
var G__33648 = (0);
seq__33599_33628 = G__33645;
chunk__33600_33629 = G__33646;
count__33601_33630 = G__33647;
i__33602_33631 = G__33648;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.call(null,");");

cljs.compiler.emitln.call(null,"};");

cljs.compiler.emitln.call(null,mname_33604,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.call(null,mname_33604,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to.call(null,cljs.core.assoc.call(null,f,new cljs.core.Keyword(null,"name","name",1843675177),name_33603__$1));

cljs.compiler.emitln.call(null,";");

cljs.compiler.emitln.call(null,mname_33604,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_33605,";");

cljs.compiler.emitln.call(null,"return ",mname_33604,";");

cljs.compiler.emitln.call(null,"})()");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__33652){
var map__33653 = p__33652;
var map__33653__$1 = ((((!((map__33653 == null)))?((((map__33653.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33653.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33653):map__33653);
var name = cljs.core.get.call(null,map__33653__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.call(null,map__33653__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.call(null,map__33653__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.call(null,map__33653__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var variadic = cljs.core.get.call(null,map__33653__$1,new cljs.core.Keyword(null,"variadic","variadic",882626057));
var recur_frames = cljs.core.get.call(null,map__33653__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var loop_lets = cljs.core.get.call(null,map__33653__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var loop_locals = cljs.core.seq.call(null,cljs.core.map.call(null,cljs.compiler.munge,cljs.core.concat.call(null,cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"params","params",710516235),cljs.core.filter.call(null,((function (map__33653,map__33653__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets){
return (function (p1__33649_SHARP_){
var and__27977__auto__ = p1__33649_SHARP_;
if(cljs.core.truth_(and__27977__auto__)){
return cljs.core.deref.call(null,new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__33649_SHARP_));
} else {
return and__27977__auto__;
}
});})(map__33653,map__33653__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets))
,recur_frames)),cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"params","params",710516235),loop_lets))));
if(loop_locals){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emitln.call(null,"((function (",cljs.compiler.comma_sep.call(null,cljs.core.map.call(null,cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.call(null,"return ");
}
} else {
}

if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method.call(null,cljs.core.assoc.call(null,cljs.core.first.call(null,methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method.call(null,cljs.core.assoc.call(null,cljs.core.first.call(null,methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_33688__$1 = (function (){var or__27989__auto__ = name;
if(cljs.core.truth_(or__27989__auto__)){
return or__27989__auto__;
} else {
return cljs.core.gensym.call(null);
}
})();
var mname_33689 = cljs.compiler.munge.call(null,name_33688__$1);
var maxparams_33690 = cljs.core.apply.call(null,cljs.core.max_key,cljs.core.count,cljs.core.map.call(null,new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_33691 = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,((function (name_33688__$1,mname_33689,maxparams_33690,loop_locals,map__33653,map__33653__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets){
return (function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.call(null,cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_33689),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
});})(name_33688__$1,mname_33689,maxparams_33690,loop_locals,map__33653,map__33653__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets))
,methods$));
var ms_33692 = cljs.core.sort_by.call(null,((function (name_33688__$1,mname_33689,maxparams_33690,mmap_33691,loop_locals,map__33653,map__33653__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets){
return (function (p1__33650_SHARP_){
return cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,p1__33650_SHARP_)));
});})(name_33688__$1,mname_33689,maxparams_33690,mmap_33691,loop_locals,map__33653,map__33653__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets))
,cljs.core.seq.call(null,mmap_33691));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emitln.call(null,"(function() {");

cljs.compiler.emitln.call(null,"var ",mname_33689," = null;");

var seq__33655_33693 = cljs.core.seq.call(null,ms_33692);
var chunk__33656_33694 = null;
var count__33657_33695 = (0);
var i__33658_33696 = (0);
while(true){
if((i__33658_33696 < count__33657_33695)){
var vec__33659_33697 = cljs.core._nth.call(null,chunk__33656_33694,i__33658_33696);
var n_33698 = cljs.core.nth.call(null,vec__33659_33697,(0),null);
var meth_33699 = cljs.core.nth.call(null,vec__33659_33697,(1),null);
cljs.compiler.emits.call(null,"var ",n_33698," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(meth_33699))){
cljs.compiler.emit_variadic_fn_method.call(null,meth_33699);
} else {
cljs.compiler.emit_fn_method.call(null,meth_33699);
}

cljs.compiler.emitln.call(null,";");

var G__33700 = seq__33655_33693;
var G__33701 = chunk__33656_33694;
var G__33702 = count__33657_33695;
var G__33703 = (i__33658_33696 + (1));
seq__33655_33693 = G__33700;
chunk__33656_33694 = G__33701;
count__33657_33695 = G__33702;
i__33658_33696 = G__33703;
continue;
} else {
var temp__4657__auto___33704 = cljs.core.seq.call(null,seq__33655_33693);
if(temp__4657__auto___33704){
var seq__33655_33705__$1 = temp__4657__auto___33704;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33655_33705__$1)){
var c__28828__auto___33706 = cljs.core.chunk_first.call(null,seq__33655_33705__$1);
var G__33707 = cljs.core.chunk_rest.call(null,seq__33655_33705__$1);
var G__33708 = c__28828__auto___33706;
var G__33709 = cljs.core.count.call(null,c__28828__auto___33706);
var G__33710 = (0);
seq__33655_33693 = G__33707;
chunk__33656_33694 = G__33708;
count__33657_33695 = G__33709;
i__33658_33696 = G__33710;
continue;
} else {
var vec__33662_33711 = cljs.core.first.call(null,seq__33655_33705__$1);
var n_33712 = cljs.core.nth.call(null,vec__33662_33711,(0),null);
var meth_33713 = cljs.core.nth.call(null,vec__33662_33711,(1),null);
cljs.compiler.emits.call(null,"var ",n_33712," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(meth_33713))){
cljs.compiler.emit_variadic_fn_method.call(null,meth_33713);
} else {
cljs.compiler.emit_fn_method.call(null,meth_33713);
}

cljs.compiler.emitln.call(null,";");

var G__33714 = cljs.core.next.call(null,seq__33655_33705__$1);
var G__33715 = null;
var G__33716 = (0);
var G__33717 = (0);
seq__33655_33693 = G__33714;
chunk__33656_33694 = G__33715;
count__33657_33695 = G__33716;
i__33658_33696 = G__33717;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,mname_33689," = function(",cljs.compiler.comma_sep.call(null,(cljs.core.truth_(variadic)?cljs.core.concat.call(null,cljs.core.butlast.call(null,maxparams_33690),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_33690)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,maxparams_33690));

cljs.compiler.emitln.call(null," = var_args;");
} else {
}

cljs.compiler.emitln.call(null,"switch(arguments.length){");

var seq__33665_33718 = cljs.core.seq.call(null,ms_33692);
var chunk__33666_33719 = null;
var count__33667_33720 = (0);
var i__33668_33721 = (0);
while(true){
if((i__33668_33721 < count__33667_33720)){
var vec__33669_33722 = cljs.core._nth.call(null,chunk__33666_33719,i__33668_33721);
var n_33723 = cljs.core.nth.call(null,vec__33669_33722,(0),null);
var meth_33724 = cljs.core.nth.call(null,vec__33669_33722,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(meth_33724))){
cljs.compiler.emitln.call(null,"default:");

var restarg_33725 = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
cljs.compiler.emitln.call(null,"var ",restarg_33725," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",max_fixed_arity,") {");

var a_33726 = cljs.compiler.emit_arguments_to_array.call(null,max_fixed_arity);
cljs.compiler.emitln.call(null,restarg_33725," = new cljs.core.IndexedSeq(",a_33726,",0,null);");

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"return ",n_33723,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep.call(null,cljs.core.butlast.call(null,maxparams_33690)),(((cljs.core.count.call(null,maxparams_33690) > (1)))?", ":null),restarg_33725,");");
} else {
var pcnt_33727 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_33724));
cljs.compiler.emitln.call(null,"case ",pcnt_33727,":");

cljs.compiler.emitln.call(null,"return ",n_33723,".call(this",(((pcnt_33727 === (0)))?null:cljs.core._conj.call(null,(function (){var x__28851__auto__ = cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,pcnt_33727,maxparams_33690));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),",")),");");
}

var G__33728 = seq__33665_33718;
var G__33729 = chunk__33666_33719;
var G__33730 = count__33667_33720;
var G__33731 = (i__33668_33721 + (1));
seq__33665_33718 = G__33728;
chunk__33666_33719 = G__33729;
count__33667_33720 = G__33730;
i__33668_33721 = G__33731;
continue;
} else {
var temp__4657__auto___33732 = cljs.core.seq.call(null,seq__33665_33718);
if(temp__4657__auto___33732){
var seq__33665_33733__$1 = temp__4657__auto___33732;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33665_33733__$1)){
var c__28828__auto___33734 = cljs.core.chunk_first.call(null,seq__33665_33733__$1);
var G__33735 = cljs.core.chunk_rest.call(null,seq__33665_33733__$1);
var G__33736 = c__28828__auto___33734;
var G__33737 = cljs.core.count.call(null,c__28828__auto___33734);
var G__33738 = (0);
seq__33665_33718 = G__33735;
chunk__33666_33719 = G__33736;
count__33667_33720 = G__33737;
i__33668_33721 = G__33738;
continue;
} else {
var vec__33672_33739 = cljs.core.first.call(null,seq__33665_33733__$1);
var n_33740 = cljs.core.nth.call(null,vec__33672_33739,(0),null);
var meth_33741 = cljs.core.nth.call(null,vec__33672_33739,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(meth_33741))){
cljs.compiler.emitln.call(null,"default:");

var restarg_33742 = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
cljs.compiler.emitln.call(null,"var ",restarg_33742," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",max_fixed_arity,") {");

var a_33743 = cljs.compiler.emit_arguments_to_array.call(null,max_fixed_arity);
cljs.compiler.emitln.call(null,restarg_33742," = new cljs.core.IndexedSeq(",a_33743,",0,null);");

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"return ",n_33740,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep.call(null,cljs.core.butlast.call(null,maxparams_33690)),(((cljs.core.count.call(null,maxparams_33690) > (1)))?", ":null),restarg_33742,");");
} else {
var pcnt_33744 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_33741));
cljs.compiler.emitln.call(null,"case ",pcnt_33744,":");

cljs.compiler.emitln.call(null,"return ",n_33740,".call(this",(((pcnt_33744 === (0)))?null:cljs.core._conj.call(null,(function (){var x__28851__auto__ = cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,pcnt_33744,maxparams_33690));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28851__auto__);
})(),",")),");");
}

var G__33745 = cljs.core.next.call(null,seq__33665_33733__$1);
var G__33746 = null;
var G__33747 = (0);
var G__33748 = (0);
seq__33665_33718 = G__33745;
chunk__33666_33719 = G__33746;
count__33667_33720 = G__33747;
i__33668_33721 = G__33748;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"throw(new Error('Invalid arity: ' + (arguments.length - 1)));");

cljs.compiler.emitln.call(null,"};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.call(null,mname_33689,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.call(null,mname_33689,".cljs$lang$applyTo = ",cljs.core.some.call(null,((function (name_33688__$1,mname_33689,maxparams_33690,mmap_33691,ms_33692,loop_locals,map__33653,map__33653__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets){
return (function (p1__33651_SHARP_){
var vec__33675 = p1__33651_SHARP_;
var n = cljs.core.nth.call(null,vec__33675,(0),null);
var m = cljs.core.nth.call(null,vec__33675,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
});})(name_33688__$1,mname_33689,maxparams_33690,mmap_33691,ms_33692,loop_locals,map__33653,map__33653__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets))
,ms_33692),".cljs$lang$applyTo;");
} else {
}

var seq__33678_33749 = cljs.core.seq.call(null,ms_33692);
var chunk__33679_33750 = null;
var count__33680_33751 = (0);
var i__33681_33752 = (0);
while(true){
if((i__33681_33752 < count__33680_33751)){
var vec__33682_33753 = cljs.core._nth.call(null,chunk__33679_33750,i__33681_33752);
var n_33754 = cljs.core.nth.call(null,vec__33682_33753,(0),null);
var meth_33755 = cljs.core.nth.call(null,vec__33682_33753,(1),null);
var c_33756 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_33755));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(meth_33755))){
cljs.compiler.emitln.call(null,mname_33689,".cljs$core$IFn$_invoke$arity$variadic = ",n_33754,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.call(null,mname_33689,".cljs$core$IFn$_invoke$arity$",c_33756," = ",n_33754,";");
}

var G__33757 = seq__33678_33749;
var G__33758 = chunk__33679_33750;
var G__33759 = count__33680_33751;
var G__33760 = (i__33681_33752 + (1));
seq__33678_33749 = G__33757;
chunk__33679_33750 = G__33758;
count__33680_33751 = G__33759;
i__33681_33752 = G__33760;
continue;
} else {
var temp__4657__auto___33761 = cljs.core.seq.call(null,seq__33678_33749);
if(temp__4657__auto___33761){
var seq__33678_33762__$1 = temp__4657__auto___33761;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33678_33762__$1)){
var c__28828__auto___33763 = cljs.core.chunk_first.call(null,seq__33678_33762__$1);
var G__33764 = cljs.core.chunk_rest.call(null,seq__33678_33762__$1);
var G__33765 = c__28828__auto___33763;
var G__33766 = cljs.core.count.call(null,c__28828__auto___33763);
var G__33767 = (0);
seq__33678_33749 = G__33764;
chunk__33679_33750 = G__33765;
count__33680_33751 = G__33766;
i__33681_33752 = G__33767;
continue;
} else {
var vec__33685_33768 = cljs.core.first.call(null,seq__33678_33762__$1);
var n_33769 = cljs.core.nth.call(null,vec__33685_33768,(0),null);
var meth_33770 = cljs.core.nth.call(null,vec__33685_33768,(1),null);
var c_33771 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_33770));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(meth_33770))){
cljs.compiler.emitln.call(null,mname_33689,".cljs$core$IFn$_invoke$arity$variadic = ",n_33769,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.call(null,mname_33689,".cljs$core$IFn$_invoke$arity$",c_33771," = ",n_33769,";");
}

var G__33772 = cljs.core.next.call(null,seq__33678_33762__$1);
var G__33773 = null;
var G__33774 = (0);
var G__33775 = (0);
seq__33678_33749 = G__33772;
chunk__33679_33750 = G__33773;
count__33680_33751 = G__33774;
i__33681_33752 = G__33775;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"return ",mname_33689,";");

cljs.compiler.emitln.call(null,"})()");
}

if(loop_locals){
return cljs.compiler.emitln.call(null,";})(",cljs.compiler.comma_sep.call(null,loop_locals),"))");
} else {
return null;
}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"do","do",46310725),(function (p__33776){
var map__33777 = p__33776;
var map__33777__$1 = ((((!((map__33777 == null)))?((((map__33777.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33777.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33777):map__33777);
var statements = cljs.core.get.call(null,map__33777__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.call(null,map__33777__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.call(null,map__33777__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var and__27977__auto__ = statements;
if(cljs.core.truth_(and__27977__auto__)){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context);
} else {
return and__27977__auto__;
}
})())){
cljs.compiler.emitln.call(null,"(function (){");
} else {
}

var seq__33779_33783 = cljs.core.seq.call(null,statements);
var chunk__33780_33784 = null;
var count__33781_33785 = (0);
var i__33782_33786 = (0);
while(true){
if((i__33782_33786 < count__33781_33785)){
var s_33787 = cljs.core._nth.call(null,chunk__33780_33784,i__33782_33786);
cljs.compiler.emitln.call(null,s_33787);

var G__33788 = seq__33779_33783;
var G__33789 = chunk__33780_33784;
var G__33790 = count__33781_33785;
var G__33791 = (i__33782_33786 + (1));
seq__33779_33783 = G__33788;
chunk__33780_33784 = G__33789;
count__33781_33785 = G__33790;
i__33782_33786 = G__33791;
continue;
} else {
var temp__4657__auto___33792 = cljs.core.seq.call(null,seq__33779_33783);
if(temp__4657__auto___33792){
var seq__33779_33793__$1 = temp__4657__auto___33792;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33779_33793__$1)){
var c__28828__auto___33794 = cljs.core.chunk_first.call(null,seq__33779_33793__$1);
var G__33795 = cljs.core.chunk_rest.call(null,seq__33779_33793__$1);
var G__33796 = c__28828__auto___33794;
var G__33797 = cljs.core.count.call(null,c__28828__auto___33794);
var G__33798 = (0);
seq__33779_33783 = G__33795;
chunk__33780_33784 = G__33796;
count__33781_33785 = G__33797;
i__33782_33786 = G__33798;
continue;
} else {
var s_33799 = cljs.core.first.call(null,seq__33779_33793__$1);
cljs.compiler.emitln.call(null,s_33799);

var G__33800 = cljs.core.next.call(null,seq__33779_33793__$1);
var G__33801 = null;
var G__33802 = (0);
var G__33803 = (0);
seq__33779_33783 = G__33800;
chunk__33780_33784 = G__33801;
count__33781_33785 = G__33802;
i__33782_33786 = G__33803;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit.call(null,ret);

if(cljs.core.truth_((function (){var and__27977__auto__ = statements;
if(cljs.core.truth_(and__27977__auto__)){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context);
} else {
return and__27977__auto__;
}
})())){
return cljs.compiler.emitln.call(null,"})()");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__33804){
var map__33805 = p__33804;
var map__33805__$1 = ((((!((map__33805 == null)))?((((map__33805.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33805.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33805):map__33805);
var env = cljs.core.get.call(null,map__33805__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var try$ = cljs.core.get.call(null,map__33805__$1,new cljs.core.Keyword(null,"try","try",1380742522));
var catch$ = cljs.core.get.call(null,map__33805__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.call(null,map__33805__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.call(null,map__33805__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__27989__auto__ = name;
if(cljs.core.truth_(or__27989__auto__)){
return or__27989__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

cljs.compiler.emits.call(null,"try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.call(null,"catch (",cljs.compiler.munge.call(null,name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"constant","constant",-379609303),new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(finally$))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :constant (:op finally))"].join('')));
}

cljs.compiler.emits.call(null,"finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.call(null,try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__33807,is_loop){
var map__33808 = p__33807;
var map__33808__$1 = ((((!((map__33808 == null)))?((((map__33808.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33808.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33808):map__33808);
var bindings = cljs.core.get.call(null,map__33808__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var expr = cljs.core.get.call(null,map__33808__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var env = cljs.core.get.call(null,map__33808__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

var _STAR_lexical_renames_STAR_33810_33819 = cljs.compiler._STAR_lexical_renames_STAR_;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.into.call(null,cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.call(null,((function (_STAR_lexical_renames_STAR_33810_33819,context,map__33808,map__33808__$1,bindings,expr,env){
return (function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope.call(null,binding),cljs.core.gensym.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
});})(_STAR_lexical_renames_STAR_33810_33819,context,map__33808,map__33808__$1,bindings,expr,env))
,bindings):null));

try{var seq__33811_33820 = cljs.core.seq.call(null,bindings);
var chunk__33812_33821 = null;
var count__33813_33822 = (0);
var i__33814_33823 = (0);
while(true){
if((i__33814_33823 < count__33813_33822)){
var map__33815_33824 = cljs.core._nth.call(null,chunk__33812_33821,i__33814_33823);
var map__33815_33825__$1 = ((((!((map__33815_33824 == null)))?((((map__33815_33824.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33815_33824.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33815_33824):map__33815_33824);
var binding_33826 = map__33815_33825__$1;
var init_33827 = cljs.core.get.call(null,map__33815_33825__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,binding_33826);

cljs.compiler.emitln.call(null," = ",init_33827,";");

var G__33828 = seq__33811_33820;
var G__33829 = chunk__33812_33821;
var G__33830 = count__33813_33822;
var G__33831 = (i__33814_33823 + (1));
seq__33811_33820 = G__33828;
chunk__33812_33821 = G__33829;
count__33813_33822 = G__33830;
i__33814_33823 = G__33831;
continue;
} else {
var temp__4657__auto___33832 = cljs.core.seq.call(null,seq__33811_33820);
if(temp__4657__auto___33832){
var seq__33811_33833__$1 = temp__4657__auto___33832;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33811_33833__$1)){
var c__28828__auto___33834 = cljs.core.chunk_first.call(null,seq__33811_33833__$1);
var G__33835 = cljs.core.chunk_rest.call(null,seq__33811_33833__$1);
var G__33836 = c__28828__auto___33834;
var G__33837 = cljs.core.count.call(null,c__28828__auto___33834);
var G__33838 = (0);
seq__33811_33820 = G__33835;
chunk__33812_33821 = G__33836;
count__33813_33822 = G__33837;
i__33814_33823 = G__33838;
continue;
} else {
var map__33817_33839 = cljs.core.first.call(null,seq__33811_33833__$1);
var map__33817_33840__$1 = ((((!((map__33817_33839 == null)))?((((map__33817_33839.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33817_33839.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33817_33839):map__33817_33839);
var binding_33841 = map__33817_33840__$1;
var init_33842 = cljs.core.get.call(null,map__33817_33840__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,binding_33841);

cljs.compiler.emitln.call(null," = ",init_33842,";");

var G__33843 = cljs.core.next.call(null,seq__33811_33833__$1);
var G__33844 = null;
var G__33845 = (0);
var G__33846 = (0);
seq__33811_33820 = G__33843;
chunk__33812_33821 = G__33844;
count__33813_33822 = G__33845;
i__33814_33823 = G__33846;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}
}finally {cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR_33810_33819;
}
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let.call(null,ast,false);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let.call(null,ast,true);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__33847){
var map__33848 = p__33847;
var map__33848__$1 = ((((!((map__33848 == null)))?((((map__33848.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33848.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33848):map__33848);
var frame = cljs.core.get.call(null,map__33848__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.call(null,map__33848__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.call(null,map__33848__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec.call(null,cljs.core.take.call(null,cljs.core.count.call(null,exprs),cljs.core.repeatedly.call(null,cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__28934__auto___33850 = cljs.core.count.call(null,exprs);
var i_33851 = (0);
while(true){
if((i_33851 < n__28934__auto___33850)){
cljs.compiler.emitln.call(null,"var ",temps.call(null,i_33851)," = ",exprs.call(null,i_33851),";");

var G__33852 = (i_33851 + (1));
i_33851 = G__33852;
continue;
} else {
}
break;
}

var n__28934__auto___33853 = cljs.core.count.call(null,exprs);
var i_33854 = (0);
while(true){
if((i_33854 < n__28934__auto___33853)){
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,params.call(null,i_33854))," = ",temps.call(null,i_33854),";");

var G__33855 = (i_33854 + (1));
i_33854 = G__33855;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.call(null,"continue;");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__33856){
var map__33857 = p__33856;
var map__33857__$1 = ((((!((map__33857 == null)))?((((map__33857.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33857.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33857):map__33857);
var bindings = cljs.core.get.call(null,map__33857__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var expr = cljs.core.get.call(null,map__33857__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var env = cljs.core.get.call(null,map__33857__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

var seq__33859_33867 = cljs.core.seq.call(null,bindings);
var chunk__33860_33868 = null;
var count__33861_33869 = (0);
var i__33862_33870 = (0);
while(true){
if((i__33862_33870 < count__33861_33869)){
var map__33863_33871 = cljs.core._nth.call(null,chunk__33860_33868,i__33862_33870);
var map__33863_33872__$1 = ((((!((map__33863_33871 == null)))?((((map__33863_33871.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33863_33871.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33863_33871):map__33863_33871);
var binding_33873 = map__33863_33872__$1;
var init_33874 = cljs.core.get.call(null,map__33863_33872__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.call(null,"var ",cljs.compiler.munge.call(null,binding_33873)," = ",init_33874,";");

var G__33875 = seq__33859_33867;
var G__33876 = chunk__33860_33868;
var G__33877 = count__33861_33869;
var G__33878 = (i__33862_33870 + (1));
seq__33859_33867 = G__33875;
chunk__33860_33868 = G__33876;
count__33861_33869 = G__33877;
i__33862_33870 = G__33878;
continue;
} else {
var temp__4657__auto___33879 = cljs.core.seq.call(null,seq__33859_33867);
if(temp__4657__auto___33879){
var seq__33859_33880__$1 = temp__4657__auto___33879;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33859_33880__$1)){
var c__28828__auto___33881 = cljs.core.chunk_first.call(null,seq__33859_33880__$1);
var G__33882 = cljs.core.chunk_rest.call(null,seq__33859_33880__$1);
var G__33883 = c__28828__auto___33881;
var G__33884 = cljs.core.count.call(null,c__28828__auto___33881);
var G__33885 = (0);
seq__33859_33867 = G__33882;
chunk__33860_33868 = G__33883;
count__33861_33869 = G__33884;
i__33862_33870 = G__33885;
continue;
} else {
var map__33865_33886 = cljs.core.first.call(null,seq__33859_33880__$1);
var map__33865_33887__$1 = ((((!((map__33865_33886 == null)))?((((map__33865_33886.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33865_33886.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33865_33886):map__33865_33886);
var binding_33888 = map__33865_33887__$1;
var init_33889 = cljs.core.get.call(null,map__33865_33887__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.call(null,"var ",cljs.compiler.munge.call(null,binding_33888)," = ",init_33889,";");

var G__33890 = cljs.core.next.call(null,seq__33859_33880__$1);
var G__33891 = null;
var G__33892 = (0);
var G__33893 = (0);
seq__33859_33867 = G__33890;
chunk__33860_33868 = G__33891;
count__33861_33869 = G__33892;
i__33862_33870 = G__33893;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.call(null,expr);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym)].join('').replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__33896){
var map__33897 = p__33896;
var map__33897__$1 = ((((!((map__33897 == null)))?((((map__33897.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33897.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33897):map__33897);
var expr = map__33897__$1;
var f = cljs.core.get.call(null,map__33897__$1,new cljs.core.Keyword(null,"f","f",-1597136552));
var args = cljs.core.get.call(null,map__33897__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__33897__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__27977__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(and__27977__auto__){
var and__27977__auto____$1 = cljs.core.not.call(null,new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info));
if(and__27977__auto____$1){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return and__27977__auto____$1;
}
} else {
return and__27977__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag.call(null,env,cljs.core.first.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__27977__auto__ = protocol;
if(cljs.core.truth_(and__27977__auto__)){
var and__27977__auto____$1 = tag;
if(cljs.core.truth_(and__27977__auto____$1)){
var or__27989__auto__ = (function (){var and__27977__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(and__27977__auto____$2){
var and__27977__auto____$3 = protocol;
if(cljs.core.truth_(and__27977__auto____$3)){
return cljs.core._EQ_.call(null,tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__27977__auto____$3;
}
} else {
return and__27977__auto____$2;
}
})();
if(cljs.core.truth_(or__27989__auto__)){
return or__27989__auto__;
} else {
var and__27977__auto____$2 = (function (){var or__27989__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(or__27989__auto____$1){
return or__27989__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__27977__auto____$2)){
var or__27989__auto____$1 = cljs.core._EQ_.call(null,protocol,tag);
if(or__27989__auto____$1){
return or__27989__auto____$1;
} else {
var and__27977__auto____$3 = !(cljs.core.set_QMARK_.call(null,tag));
if(and__27977__auto____$3){
var and__27977__auto____$4 = cljs.core.not.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null,new cljs.core.Symbol(null,"object","object",-1179821820,null),null,new cljs.core.Symbol(null,"any","any",-948528346,null),null,new cljs.core.Symbol(null,"js","js",-886355190,null),null,new cljs.core.Symbol(null,"number","number",-1084057331,null),null,new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),null,new cljs.core.Symbol(null,"array","array",-440182315,null),null,new cljs.core.Symbol(null,"string","string",-349010059,null),null,new cljs.core.Symbol(null,"function","function",-486723946,null),null,new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),null], null), null).call(null,tag));
if(and__27977__auto____$4){
var temp__4657__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var.call(null,env,tag));
if(cljs.core.truth_(temp__4657__auto__)){
var ps = temp__4657__auto__;
return ps.call(null,protocol);
} else {
return null;
}
} else {
return and__27977__auto____$4;
}
} else {
return and__27977__auto____$3;
}
}
} else {
return and__27977__auto____$2;
}
}
} else {
return and__27977__auto____$1;
}
} else {
return and__27977__auto__;
}
})();
var opt_not_QMARK_ = (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.call(null,cljs.analyzer.infer_tag.call(null,env,cljs.core.first.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr))),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null)));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var js_QMARK_ = (cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"js","js",-886355190,null))) || (cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null)));
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__27989__auto__ = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__27989__auto__){
return or__27989__auto__;
} else {
var or__27989__auto____$1 = (function (){var temp__4657__auto__ = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)].join('');
if(cljs.core.truth_(temp__4657__auto__)){
var ns_str = temp__4657__auto__;
return cljs.core._EQ_.call(null,cljs.core.get.call(null,clojure.string.split.call(null,ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__27989__auto____$1)){
return or__27989__auto____$1;
} else {
return !(cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)),ns));
}
}
})():null);
var keyword_QMARK_ = (cljs.core._EQ_.call(null,new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),cljs.analyzer.infer_tag.call(null,env,f))) || ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f),new cljs.core.Keyword(null,"constant","constant",-379609303))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f) instanceof cljs.core.Keyword)));
var vec__33899 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count.call(null,args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if((cljs.core.not.call(null,variadic_QMARK_)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,mps),(1)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__27977__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__27977__auto__)){
return (arity > mfa);
} else {
return and__27977__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.call(null,f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),((function (arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__33897,map__33897__$1,expr,f,args,env){
return (function (info__$1){
return cljs.core.update_in.call(null,cljs.core.assoc.call(null,info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),((function (arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__33897,map__33897__$1,expr,f,args,env){
return (function (p1__33894_SHARP_){
return cljs.core.dissoc.call(null,cljs.core.dissoc.call(null,p1__33894_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
});})(arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__33897,map__33897__$1,expr,f,args,env))
);
});})(arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__33897,map__33897__$1,expr,f,args,env))
),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.call(null,cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.call(null,f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),((function (arities,arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__33897,map__33897__$1,expr,f,args,env){
return (function (info__$1){
return cljs.core.update_in.call(null,cljs.core.assoc.call(null,info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),((function (arities,arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__33897,map__33897__$1,expr,f,args,env){
return (function (p1__33895_SHARP_){
return cljs.core.dissoc.call(null,cljs.core.dissoc.call(null,p1__33895_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
});})(arities,arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__33897,map__33897__$1,expr,f,args,env))
);
});})(arities,arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__33897,map__33897__$1,expr,f,args,env))
),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.call(null,vec__33899,(0),null);
var variadic_invoke = cljs.core.nth.call(null,vec__33899,(1),null);
var env__33109__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.call(null,"!(",cljs.core.first.call(null,args),")");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_33902 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,cljs.compiler.protocol_prefix.call(null,protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,cljs.core.name.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,args))].join('');
cljs.compiler.emits.call(null,cljs.core.first.call(null,args),".",pimpl_33902,"(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",cljs.core.rest.call(null,args))),")");
} else {
if(keyword_QMARK_){
cljs.compiler.emits.call(null,f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count.call(null,args),"(",cljs.compiler.comma_sep.call(null,args),")");
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_33903 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.call(null,f__$1,"(",cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,mfa_33903,args)),(((mfa_33903 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.compiler.comma_sep.call(null,cljs.core.drop.call(null,mfa_33903,args)),"], 0))");
} else {
if(cljs.core.truth_((function (){var or__27989__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__27989__auto__)){
return or__27989__auto__;
} else {
var or__27989__auto____$1 = js_QMARK_;
if(or__27989__auto____$1){
return or__27989__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.call(null,f__$1,"(",cljs.compiler.comma_sep.call(null,args),")");
} else {
if((cljs.analyzer._STAR_cljs_static_fns_STAR_) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"var","var",-769682797)))){
var fprop_33904 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,args))].join('');
if(cljs.analyzer._STAR_fn_invoke_direct_STAR_){
cljs.compiler.emits.call(null,"(",f__$1,fprop_33904," ? ",f__$1,fprop_33904,"(",cljs.compiler.comma_sep.call(null,args),") : ",f__$1,"(",cljs.compiler.comma_sep.call(null,args),"))");
} else {
cljs.compiler.emits.call(null,"(",f__$1,fprop_33904," ? ",f__$1,fprop_33904,"(",cljs.compiler.comma_sep.call(null,args),") : ",f__$1,".call(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",args)),"))");
}
} else {
cljs.compiler.emits.call(null,f__$1,".call(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",args)),")");
}

}
}
}
}
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__33905){
var map__33906 = p__33905;
var map__33906__$1 = ((((!((map__33906 == null)))?((((map__33906.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33906.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33906):map__33906);
var ctor = cljs.core.get.call(null,map__33906__$1,new cljs.core.Keyword(null,"ctor","ctor",1750864802));
var args = cljs.core.get.call(null,map__33906__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__33906__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__33109__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(new ",ctor,"(",cljs.compiler.comma_sep.call(null,args),"))");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__33908){
var map__33909 = p__33908;
var map__33909__$1 = ((((!((map__33909 == null)))?((((map__33909.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33909.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33909):map__33909);
var target = cljs.core.get.call(null,map__33909__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.call(null,map__33909__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.call(null,map__33909__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__33109__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,target," = ",val);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__33911 = cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_);
var map__33911__$1 = ((((!((map__33911 == null)))?((((map__33911.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33911.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33911):map__33911);
var options = cljs.core.get.call(null,map__33911__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.call(null,map__33911__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__33912 = options;
var map__33912__$1 = ((((!((map__33912 == null)))?((((map__33912.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33912.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33912):map__33912);
var target = cljs.core.get.call(null,map__33912__$1,new cljs.core.Keyword(null,"target","target",253001721));
var optimizations = cljs.core.get.call(null,map__33912__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.call(null,new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.call(null,cljs.core.gensym.call(null,new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__33913 = (function (){var libs__$1 = cljs.core.remove.call(null,cljs.core.set.call(null,cljs.core.vals.call(null,seen)),cljs.core.filter.call(null,cljs.core.set.call(null,cljs.core.vals.call(null,libs)),deps));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__33919 = cljs.core.group_by.call(null,cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__33919__$1 = ((((!((map__33919 == null)))?((((map__33919.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33919.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33919):map__33919);
var node_libs = cljs.core.get.call(null,map__33919__$1,true);
var libs_to_load = cljs.core.get.call(null,map__33919__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.call(null,vec__33913,(0),null);
var libs_to_load = cljs.core.nth.call(null,vec__33913,(1),null);
var map__33916 = cljs.core.group_by.call(null,cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
var map__33916__$1 = ((((!((map__33916 == null)))?((((map__33916.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33916.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33916):map__33916);
var global_exports_libs = cljs.core.get.call(null,map__33916__$1,true);
var libs_to_load__$1 = cljs.core.get.call(null,map__33916__$1,false);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs)))){
cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__33922_33938 = cljs.core.seq.call(null,libs_to_load__$1);
var chunk__33923_33939 = null;
var count__33924_33940 = (0);
var i__33925_33941 = (0);
while(true){
if((i__33925_33941 < count__33924_33940)){
var lib_33942 = cljs.core._nth.call(null,chunk__33923_33939,i__33925_33941);
if((cljs.analyzer.foreign_dep_QMARK_.call(null,lib_33942)) && (!(cljs.core.keyword_identical_QMARK_.call(null,optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))){
} else {
if(cljs.core.truth_((function (){var or__27989__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__27989__auto__)){
return or__27989__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_33942),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_33942),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__27989__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__27989__auto__)){
return or__27989__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_33942),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_33942),"', 'reload-all');");
} else {
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_33942),"');");

}
}
}

var G__33943 = seq__33922_33938;
var G__33944 = chunk__33923_33939;
var G__33945 = count__33924_33940;
var G__33946 = (i__33925_33941 + (1));
seq__33922_33938 = G__33943;
chunk__33923_33939 = G__33944;
count__33924_33940 = G__33945;
i__33925_33941 = G__33946;
continue;
} else {
var temp__4657__auto___33947 = cljs.core.seq.call(null,seq__33922_33938);
if(temp__4657__auto___33947){
var seq__33922_33948__$1 = temp__4657__auto___33947;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33922_33948__$1)){
var c__28828__auto___33949 = cljs.core.chunk_first.call(null,seq__33922_33948__$1);
var G__33950 = cljs.core.chunk_rest.call(null,seq__33922_33948__$1);
var G__33951 = c__28828__auto___33949;
var G__33952 = cljs.core.count.call(null,c__28828__auto___33949);
var G__33953 = (0);
seq__33922_33938 = G__33950;
chunk__33923_33939 = G__33951;
count__33924_33940 = G__33952;
i__33925_33941 = G__33953;
continue;
} else {
var lib_33954 = cljs.core.first.call(null,seq__33922_33948__$1);
if((cljs.analyzer.foreign_dep_QMARK_.call(null,lib_33954)) && (!(cljs.core.keyword_identical_QMARK_.call(null,optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))){
} else {
if(cljs.core.truth_((function (){var or__27989__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__27989__auto__)){
return or__27989__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_33954),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_33954),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__27989__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__27989__auto__)){
return or__27989__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_33954),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_33954),"', 'reload-all');");
} else {
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_33954),"');");

}
}
}

var G__33955 = cljs.core.next.call(null,seq__33922_33948__$1);
var G__33956 = null;
var G__33957 = (0);
var G__33958 = (0);
seq__33922_33938 = G__33955;
chunk__33923_33939 = G__33956;
count__33924_33940 = G__33957;
i__33925_33941 = G__33958;
continue;
}
} else {
}
}
break;
}

var seq__33926_33959 = cljs.core.seq.call(null,node_libs);
var chunk__33927_33960 = null;
var count__33928_33961 = (0);
var i__33929_33962 = (0);
while(true){
if((i__33929_33962 < count__33928_33961)){
var lib_33963 = cljs.core._nth.call(null,chunk__33927_33960,i__33929_33962);
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_node_lib.call(null,lib_33963)," = require('",lib_33963,"');");

var G__33964 = seq__33926_33959;
var G__33965 = chunk__33927_33960;
var G__33966 = count__33928_33961;
var G__33967 = (i__33929_33962 + (1));
seq__33926_33959 = G__33964;
chunk__33927_33960 = G__33965;
count__33928_33961 = G__33966;
i__33929_33962 = G__33967;
continue;
} else {
var temp__4657__auto___33968 = cljs.core.seq.call(null,seq__33926_33959);
if(temp__4657__auto___33968){
var seq__33926_33969__$1 = temp__4657__auto___33968;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33926_33969__$1)){
var c__28828__auto___33970 = cljs.core.chunk_first.call(null,seq__33926_33969__$1);
var G__33971 = cljs.core.chunk_rest.call(null,seq__33926_33969__$1);
var G__33972 = c__28828__auto___33970;
var G__33973 = cljs.core.count.call(null,c__28828__auto___33970);
var G__33974 = (0);
seq__33926_33959 = G__33971;
chunk__33927_33960 = G__33972;
count__33928_33961 = G__33973;
i__33929_33962 = G__33974;
continue;
} else {
var lib_33975 = cljs.core.first.call(null,seq__33926_33969__$1);
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_node_lib.call(null,lib_33975)," = require('",lib_33975,"');");

var G__33976 = cljs.core.next.call(null,seq__33926_33969__$1);
var G__33977 = null;
var G__33978 = (0);
var G__33979 = (0);
seq__33926_33959 = G__33976;
chunk__33927_33960 = G__33977;
count__33928_33961 = G__33978;
i__33929_33962 = G__33979;
continue;
}
} else {
}
}
break;
}

var seq__33930_33980 = cljs.core.seq.call(null,global_exports_libs);
var chunk__33931_33981 = null;
var count__33932_33982 = (0);
var i__33933_33983 = (0);
while(true){
if((i__33933_33983 < count__33932_33982)){
var lib_33984 = cljs.core._nth.call(null,chunk__33931_33981,i__33933_33983);
var map__33934_33985 = cljs.core.get.call(null,js_dependency_index,cljs.core.name.call(null,lib_33984));
var map__33934_33986__$1 = ((((!((map__33934_33985 == null)))?((((map__33934_33985.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33934_33985.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33934_33985):map__33934_33985);
var global_exports_33987 = cljs.core.get.call(null,map__33934_33986__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_global_export.call(null,lib_33984)," = goog.global.",cljs.core.get.call(null,global_exports_33987,cljs.core.symbol.call(null,lib_33984)),";");

var G__33988 = seq__33930_33980;
var G__33989 = chunk__33931_33981;
var G__33990 = count__33932_33982;
var G__33991 = (i__33933_33983 + (1));
seq__33930_33980 = G__33988;
chunk__33931_33981 = G__33989;
count__33932_33982 = G__33990;
i__33933_33983 = G__33991;
continue;
} else {
var temp__4657__auto___33992 = cljs.core.seq.call(null,seq__33930_33980);
if(temp__4657__auto___33992){
var seq__33930_33993__$1 = temp__4657__auto___33992;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33930_33993__$1)){
var c__28828__auto___33994 = cljs.core.chunk_first.call(null,seq__33930_33993__$1);
var G__33995 = cljs.core.chunk_rest.call(null,seq__33930_33993__$1);
var G__33996 = c__28828__auto___33994;
var G__33997 = cljs.core.count.call(null,c__28828__auto___33994);
var G__33998 = (0);
seq__33930_33980 = G__33995;
chunk__33931_33981 = G__33996;
count__33932_33982 = G__33997;
i__33933_33983 = G__33998;
continue;
} else {
var lib_33999 = cljs.core.first.call(null,seq__33930_33993__$1);
var map__33936_34000 = cljs.core.get.call(null,js_dependency_index,cljs.core.name.call(null,lib_33999));
var map__33936_34001__$1 = ((((!((map__33936_34000 == null)))?((((map__33936_34000.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33936_34000.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33936_34000):map__33936_34000);
var global_exports_34002 = cljs.core.get.call(null,map__33936_34001__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_global_export.call(null,lib_33999)," = goog.global.",cljs.core.get.call(null,global_exports_34002,cljs.core.symbol.call(null,lib_33999)),";");

var G__34003 = cljs.core.next.call(null,seq__33930_33993__$1);
var G__34004 = null;
var G__34005 = (0);
var G__34006 = (0);
seq__33930_33980 = G__34003;
chunk__33931_33981 = G__34004;
count__33932_33982 = G__34005;
i__33933_33983 = G__34006;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs)))){
return cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",loaded_libs,");");
} else {
return null;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__34007){
var map__34008 = p__34007;
var map__34008__$1 = ((((!((map__34008 == null)))?((((map__34008.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34008.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34008):map__34008);
var name = cljs.core.get.call(null,map__34008__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.call(null,map__34008__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.call(null,map__34008__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.call(null,map__34008__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.call(null,map__34008__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.call(null,map__34008__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.call(null,map__34008__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs.call(null,requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs.call(null,uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.call(null,"null;");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__34010){
var map__34011 = p__34010;
var map__34011__$1 = ((((!((map__34011 == null)))?((((map__34011.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34011.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34011):map__34011);
var name = cljs.core.get.call(null,map__34011__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.call(null,map__34011__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.call(null,map__34011__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.call(null,map__34011__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.call(null,map__34011__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.call(null,map__34011__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.call(null,map__34011__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.call(null,"goog.provide('",cljs.compiler.munge.call(null,name),"');");

if(cljs.core._EQ_.call(null,name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs.call(null,requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs.call(null,uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"deftype*","deftype*",-677871637),(function (p__34013){
var map__34014 = p__34013;
var map__34014__$1 = ((((!((map__34014 == null)))?((((map__34014.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34014.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34014):map__34014);
var t = cljs.core.get.call(null,map__34014__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.call(null,map__34014__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.call(null,map__34014__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.call(null,map__34014__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.call(null,map__34014__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.call(null,cljs.compiler.munge,fields);
cljs.compiler.emitln.call(null,"");

cljs.compiler.emitln.call(null,"/**");

cljs.compiler.emitln.call(null,"* @constructor");

var seq__34016_34034 = cljs.core.seq.call(null,protocols);
var chunk__34017_34035 = null;
var count__34018_34036 = (0);
var i__34019_34037 = (0);
while(true){
if((i__34019_34037 < count__34018_34036)){
var protocol_34038 = cljs.core._nth.call(null,chunk__34017_34035,i__34019_34037);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_34038)].join('')),"}");

var G__34039 = seq__34016_34034;
var G__34040 = chunk__34017_34035;
var G__34041 = count__34018_34036;
var G__34042 = (i__34019_34037 + (1));
seq__34016_34034 = G__34039;
chunk__34017_34035 = G__34040;
count__34018_34036 = G__34041;
i__34019_34037 = G__34042;
continue;
} else {
var temp__4657__auto___34043 = cljs.core.seq.call(null,seq__34016_34034);
if(temp__4657__auto___34043){
var seq__34016_34044__$1 = temp__4657__auto___34043;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34016_34044__$1)){
var c__28828__auto___34045 = cljs.core.chunk_first.call(null,seq__34016_34044__$1);
var G__34046 = cljs.core.chunk_rest.call(null,seq__34016_34044__$1);
var G__34047 = c__28828__auto___34045;
var G__34048 = cljs.core.count.call(null,c__28828__auto___34045);
var G__34049 = (0);
seq__34016_34034 = G__34046;
chunk__34017_34035 = G__34047;
count__34018_34036 = G__34048;
i__34019_34037 = G__34049;
continue;
} else {
var protocol_34050 = cljs.core.first.call(null,seq__34016_34044__$1);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_34050)].join('')),"}");

var G__34051 = cljs.core.next.call(null,seq__34016_34044__$1);
var G__34052 = null;
var G__34053 = (0);
var G__34054 = (0);
seq__34016_34034 = G__34051;
chunk__34017_34035 = G__34052;
count__34018_34036 = G__34053;
i__34019_34037 = G__34054;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"*/");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,t)," = (function (",cljs.compiler.comma_sep.call(null,fields__$1),"){");

var seq__34020_34055 = cljs.core.seq.call(null,fields__$1);
var chunk__34021_34056 = null;
var count__34022_34057 = (0);
var i__34023_34058 = (0);
while(true){
if((i__34023_34058 < count__34022_34057)){
var fld_34059 = cljs.core._nth.call(null,chunk__34021_34056,i__34023_34058);
cljs.compiler.emitln.call(null,"this.",fld_34059," = ",fld_34059,";");

var G__34060 = seq__34020_34055;
var G__34061 = chunk__34021_34056;
var G__34062 = count__34022_34057;
var G__34063 = (i__34023_34058 + (1));
seq__34020_34055 = G__34060;
chunk__34021_34056 = G__34061;
count__34022_34057 = G__34062;
i__34023_34058 = G__34063;
continue;
} else {
var temp__4657__auto___34064 = cljs.core.seq.call(null,seq__34020_34055);
if(temp__4657__auto___34064){
var seq__34020_34065__$1 = temp__4657__auto___34064;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34020_34065__$1)){
var c__28828__auto___34066 = cljs.core.chunk_first.call(null,seq__34020_34065__$1);
var G__34067 = cljs.core.chunk_rest.call(null,seq__34020_34065__$1);
var G__34068 = c__28828__auto___34066;
var G__34069 = cljs.core.count.call(null,c__28828__auto___34066);
var G__34070 = (0);
seq__34020_34055 = G__34067;
chunk__34021_34056 = G__34068;
count__34022_34057 = G__34069;
i__34023_34058 = G__34070;
continue;
} else {
var fld_34071 = cljs.core.first.call(null,seq__34020_34065__$1);
cljs.compiler.emitln.call(null,"this.",fld_34071," = ",fld_34071,";");

var G__34072 = cljs.core.next.call(null,seq__34020_34065__$1);
var G__34073 = null;
var G__34074 = (0);
var G__34075 = (0);
seq__34020_34055 = G__34072;
chunk__34021_34056 = G__34073;
count__34022_34057 = G__34074;
i__34023_34058 = G__34075;
continue;
}
} else {
}
}
break;
}

var seq__34024_34076 = cljs.core.seq.call(null,pmasks);
var chunk__34025_34077 = null;
var count__34026_34078 = (0);
var i__34027_34079 = (0);
while(true){
if((i__34027_34079 < count__34026_34078)){
var vec__34028_34080 = cljs.core._nth.call(null,chunk__34025_34077,i__34027_34079);
var pno_34081 = cljs.core.nth.call(null,vec__34028_34080,(0),null);
var pmask_34082 = cljs.core.nth.call(null,vec__34028_34080,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_34081,"$ = ",pmask_34082,";");

var G__34083 = seq__34024_34076;
var G__34084 = chunk__34025_34077;
var G__34085 = count__34026_34078;
var G__34086 = (i__34027_34079 + (1));
seq__34024_34076 = G__34083;
chunk__34025_34077 = G__34084;
count__34026_34078 = G__34085;
i__34027_34079 = G__34086;
continue;
} else {
var temp__4657__auto___34087 = cljs.core.seq.call(null,seq__34024_34076);
if(temp__4657__auto___34087){
var seq__34024_34088__$1 = temp__4657__auto___34087;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34024_34088__$1)){
var c__28828__auto___34089 = cljs.core.chunk_first.call(null,seq__34024_34088__$1);
var G__34090 = cljs.core.chunk_rest.call(null,seq__34024_34088__$1);
var G__34091 = c__28828__auto___34089;
var G__34092 = cljs.core.count.call(null,c__28828__auto___34089);
var G__34093 = (0);
seq__34024_34076 = G__34090;
chunk__34025_34077 = G__34091;
count__34026_34078 = G__34092;
i__34027_34079 = G__34093;
continue;
} else {
var vec__34031_34094 = cljs.core.first.call(null,seq__34024_34088__$1);
var pno_34095 = cljs.core.nth.call(null,vec__34031_34094,(0),null);
var pmask_34096 = cljs.core.nth.call(null,vec__34031_34094,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_34095,"$ = ",pmask_34096,";");

var G__34097 = cljs.core.next.call(null,seq__34024_34088__$1);
var G__34098 = null;
var G__34099 = (0);
var G__34100 = (0);
seq__34024_34076 = G__34097;
chunk__34025_34077 = G__34098;
count__34026_34078 = G__34099;
i__34027_34079 = G__34100;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"});");

return cljs.compiler.emit.call(null,body);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"defrecord*","defrecord*",718069562),(function (p__34101){
var map__34102 = p__34101;
var map__34102__$1 = ((((!((map__34102 == null)))?((((map__34102.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34102.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34102):map__34102);
var t = cljs.core.get.call(null,map__34102__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.call(null,map__34102__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.call(null,map__34102__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.call(null,map__34102__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.call(null,map__34102__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.call(null,cljs.core.map.call(null,cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.call(null,"");

cljs.compiler.emitln.call(null,"/**");

cljs.compiler.emitln.call(null,"* @constructor");

var seq__34104_34122 = cljs.core.seq.call(null,protocols);
var chunk__34105_34123 = null;
var count__34106_34124 = (0);
var i__34107_34125 = (0);
while(true){
if((i__34107_34125 < count__34106_34124)){
var protocol_34126 = cljs.core._nth.call(null,chunk__34105_34123,i__34107_34125);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_34126)].join('')),"}");

var G__34127 = seq__34104_34122;
var G__34128 = chunk__34105_34123;
var G__34129 = count__34106_34124;
var G__34130 = (i__34107_34125 + (1));
seq__34104_34122 = G__34127;
chunk__34105_34123 = G__34128;
count__34106_34124 = G__34129;
i__34107_34125 = G__34130;
continue;
} else {
var temp__4657__auto___34131 = cljs.core.seq.call(null,seq__34104_34122);
if(temp__4657__auto___34131){
var seq__34104_34132__$1 = temp__4657__auto___34131;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34104_34132__$1)){
var c__28828__auto___34133 = cljs.core.chunk_first.call(null,seq__34104_34132__$1);
var G__34134 = cljs.core.chunk_rest.call(null,seq__34104_34132__$1);
var G__34135 = c__28828__auto___34133;
var G__34136 = cljs.core.count.call(null,c__28828__auto___34133);
var G__34137 = (0);
seq__34104_34122 = G__34134;
chunk__34105_34123 = G__34135;
count__34106_34124 = G__34136;
i__34107_34125 = G__34137;
continue;
} else {
var protocol_34138 = cljs.core.first.call(null,seq__34104_34132__$1);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_34138)].join('')),"}");

var G__34139 = cljs.core.next.call(null,seq__34104_34132__$1);
var G__34140 = null;
var G__34141 = (0);
var G__34142 = (0);
seq__34104_34122 = G__34139;
chunk__34105_34123 = G__34140;
count__34106_34124 = G__34141;
i__34107_34125 = G__34142;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"*/");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,t)," = (function (",cljs.compiler.comma_sep.call(null,fields__$1),"){");

var seq__34108_34143 = cljs.core.seq.call(null,fields__$1);
var chunk__34109_34144 = null;
var count__34110_34145 = (0);
var i__34111_34146 = (0);
while(true){
if((i__34111_34146 < count__34110_34145)){
var fld_34147 = cljs.core._nth.call(null,chunk__34109_34144,i__34111_34146);
cljs.compiler.emitln.call(null,"this.",fld_34147," = ",fld_34147,";");

var G__34148 = seq__34108_34143;
var G__34149 = chunk__34109_34144;
var G__34150 = count__34110_34145;
var G__34151 = (i__34111_34146 + (1));
seq__34108_34143 = G__34148;
chunk__34109_34144 = G__34149;
count__34110_34145 = G__34150;
i__34111_34146 = G__34151;
continue;
} else {
var temp__4657__auto___34152 = cljs.core.seq.call(null,seq__34108_34143);
if(temp__4657__auto___34152){
var seq__34108_34153__$1 = temp__4657__auto___34152;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34108_34153__$1)){
var c__28828__auto___34154 = cljs.core.chunk_first.call(null,seq__34108_34153__$1);
var G__34155 = cljs.core.chunk_rest.call(null,seq__34108_34153__$1);
var G__34156 = c__28828__auto___34154;
var G__34157 = cljs.core.count.call(null,c__28828__auto___34154);
var G__34158 = (0);
seq__34108_34143 = G__34155;
chunk__34109_34144 = G__34156;
count__34110_34145 = G__34157;
i__34111_34146 = G__34158;
continue;
} else {
var fld_34159 = cljs.core.first.call(null,seq__34108_34153__$1);
cljs.compiler.emitln.call(null,"this.",fld_34159," = ",fld_34159,";");

var G__34160 = cljs.core.next.call(null,seq__34108_34153__$1);
var G__34161 = null;
var G__34162 = (0);
var G__34163 = (0);
seq__34108_34143 = G__34160;
chunk__34109_34144 = G__34161;
count__34110_34145 = G__34162;
i__34111_34146 = G__34163;
continue;
}
} else {
}
}
break;
}

var seq__34112_34164 = cljs.core.seq.call(null,pmasks);
var chunk__34113_34165 = null;
var count__34114_34166 = (0);
var i__34115_34167 = (0);
while(true){
if((i__34115_34167 < count__34114_34166)){
var vec__34116_34168 = cljs.core._nth.call(null,chunk__34113_34165,i__34115_34167);
var pno_34169 = cljs.core.nth.call(null,vec__34116_34168,(0),null);
var pmask_34170 = cljs.core.nth.call(null,vec__34116_34168,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_34169,"$ = ",pmask_34170,";");

var G__34171 = seq__34112_34164;
var G__34172 = chunk__34113_34165;
var G__34173 = count__34114_34166;
var G__34174 = (i__34115_34167 + (1));
seq__34112_34164 = G__34171;
chunk__34113_34165 = G__34172;
count__34114_34166 = G__34173;
i__34115_34167 = G__34174;
continue;
} else {
var temp__4657__auto___34175 = cljs.core.seq.call(null,seq__34112_34164);
if(temp__4657__auto___34175){
var seq__34112_34176__$1 = temp__4657__auto___34175;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34112_34176__$1)){
var c__28828__auto___34177 = cljs.core.chunk_first.call(null,seq__34112_34176__$1);
var G__34178 = cljs.core.chunk_rest.call(null,seq__34112_34176__$1);
var G__34179 = c__28828__auto___34177;
var G__34180 = cljs.core.count.call(null,c__28828__auto___34177);
var G__34181 = (0);
seq__34112_34164 = G__34178;
chunk__34113_34165 = G__34179;
count__34114_34166 = G__34180;
i__34115_34167 = G__34181;
continue;
} else {
var vec__34119_34182 = cljs.core.first.call(null,seq__34112_34176__$1);
var pno_34183 = cljs.core.nth.call(null,vec__34119_34182,(0),null);
var pmask_34184 = cljs.core.nth.call(null,vec__34119_34182,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_34183,"$ = ",pmask_34184,";");

var G__34185 = cljs.core.next.call(null,seq__34112_34176__$1);
var G__34186 = null;
var G__34187 = (0);
var G__34188 = (0);
seq__34112_34164 = G__34185;
chunk__34113_34165 = G__34186;
count__34114_34166 = G__34187;
i__34115_34167 = G__34188;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"});");

return cljs.compiler.emit.call(null,body);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"dot","dot",1442709401),(function (p__34189){
var map__34190 = p__34189;
var map__34190__$1 = ((((!((map__34190 == null)))?((((map__34190.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34190.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34190):map__34190);
var target = cljs.core.get.call(null,map__34190__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.call(null,map__34190__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.call(null,map__34190__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.call(null,map__34190__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__34190__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__33109__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.call(null,target,".",cljs.compiler.munge.call(null,field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.call(null,target,".",cljs.compiler.munge.call(null,method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep.call(null,args),")");
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__34192){
var map__34193 = p__34192;
var map__34193__$1 = ((((!((map__34193 == null)))?((((map__34193.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34193.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34193):map__34193);
var op = cljs.core.get.call(null,map__34193__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.call(null,map__34193__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.call(null,map__34193__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.call(null,map__34193__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.call(null,map__34193__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__27977__auto__ = code;
if(cljs.core.truth_(and__27977__auto__)){
return goog.string.startsWith(clojure.string.trim.call(null,code),"/*");
} else {
return and__27977__auto__;
}
})())){
return cljs.compiler.emits.call(null,code);
} else {
var env__33109__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.call(null,code);
} else {
cljs.compiler.emits.call(null,cljs.core.interleave.call(null,cljs.core.concat.call(null,segs,cljs.core.repeat.call(null,null)),cljs.core.concat.call(null,args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__33109__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}));
cljs.compiler.build_affecting_options = (function cljs$compiler$build_affecting_options(opts){
return cljs.core.select_keys.call(null,opts,new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"static-fns","static-fns",-501950748),new cljs.core.Keyword(null,"fn-invoke-direct","fn-invoke-direct",-1537311210),new cljs.core.Keyword(null,"optimize-constants","optimize-constants",232704518),new cljs.core.Keyword(null,"elide-asserts","elide-asserts",537063272),new cljs.core.Keyword(null,"target","target",253001721),new cljs.core.Keyword(null,"cache-key","cache-key",-565448732),new cljs.core.Keyword(null,"checked-arrays","checked-arrays",-139154445),new cljs.core.Keyword(null,"language-out","language-out",334619882)], null));
});
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.call(null,"goog.provide('",cljs.compiler.munge.call(null,cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.call(null,"goog.require('cljs.core');");

var seq__34198 = cljs.core.seq.call(null,table);
var chunk__34199 = null;
var count__34200 = (0);
var i__34201 = (0);
while(true){
if((i__34201 < count__34200)){
var vec__34202 = cljs.core._nth.call(null,chunk__34199,i__34201);
var sym = cljs.core.nth.call(null,vec__34202,(0),null);
var value = cljs.core.nth.call(null,vec__34202,(1),null);
var ns_34208 = cljs.core.namespace.call(null,sym);
var name_34209 = cljs.core.name.call(null,sym);
cljs.compiler.emits.call(null,"cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword.call(null,sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol.call(null,sym);
} else {
throw cljs.core.ex_info.call(null,["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,sym))].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471)], null));

}
}

cljs.compiler.emits.call(null,";\n");

var G__34210 = seq__34198;
var G__34211 = chunk__34199;
var G__34212 = count__34200;
var G__34213 = (i__34201 + (1));
seq__34198 = G__34210;
chunk__34199 = G__34211;
count__34200 = G__34212;
i__34201 = G__34213;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__34198);
if(temp__4657__auto__){
var seq__34198__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34198__$1)){
var c__28828__auto__ = cljs.core.chunk_first.call(null,seq__34198__$1);
var G__34214 = cljs.core.chunk_rest.call(null,seq__34198__$1);
var G__34215 = c__28828__auto__;
var G__34216 = cljs.core.count.call(null,c__28828__auto__);
var G__34217 = (0);
seq__34198 = G__34214;
chunk__34199 = G__34215;
count__34200 = G__34216;
i__34201 = G__34217;
continue;
} else {
var vec__34205 = cljs.core.first.call(null,seq__34198__$1);
var sym = cljs.core.nth.call(null,vec__34205,(0),null);
var value = cljs.core.nth.call(null,vec__34205,(1),null);
var ns_34218 = cljs.core.namespace.call(null,sym);
var name_34219 = cljs.core.name.call(null,sym);
cljs.compiler.emits.call(null,"cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword.call(null,sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol.call(null,sym);
} else {
throw cljs.core.ex_info.call(null,["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,sym))].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471)], null));

}
}

cljs.compiler.emits.call(null,";\n");

var G__34220 = cljs.core.next.call(null,seq__34198__$1);
var G__34221 = null;
var G__34222 = (0);
var G__34223 = (0);
seq__34198 = G__34220;
chunk__34199 = G__34221;
count__34200 = G__34222;
i__34201 = G__34223;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__34225 = arguments.length;
switch (G__34225) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.call(null,cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?new cljs.core.Keyword("cljs.analyzer","externs","cljs.analyzer/externs",893359239).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)):null));
});

cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq.call(null,cljs.core.keys.call(null,externs));
while(true){
if(ks){
var k_34230 = cljs.core.first.call(null,ks);
var vec__34226_34231 = cljs.core.conj.call(null,prefix,k_34230);
var top_34232 = cljs.core.nth.call(null,vec__34226_34231,(0),null);
var prefix_SINGLEQUOTE__34233 = vec__34226_34231;
if((cljs.core.not_EQ_.call(null,new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_34230)) && ((cljs.core.get_in.call(null,known_externs,prefix_SINGLEQUOTE__34233) == null))){
if(!((cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,top_level),top_34232)) || (cljs.core.contains_QMARK_.call(null,known_externs,top_34232)))){
cljs.compiler.emitln.call(null,"var ",clojure.string.join.call(null,".",cljs.core.map.call(null,cljs.compiler.munge,prefix_SINGLEQUOTE__34233)),";");

cljs.core.swap_BANG_.call(null,top_level,cljs.core.conj,top_34232);
} else {
cljs.compiler.emitln.call(null,clojure.string.join.call(null,".",cljs.core.map.call(null,cljs.compiler.munge,prefix_SINGLEQUOTE__34233)),";");
}
} else {
}

var m_34234 = cljs.core.get.call(null,externs,k_34230);
if(cljs.core.empty_QMARK_.call(null,m_34234)){
} else {
cljs.compiler.emit_externs.call(null,prefix_SINGLEQUOTE__34233,m_34234,top_level,known_externs);
}

var G__34235 = cljs.core.next.call(null,ks);
ks = G__34235;
continue;
} else {
return null;
}
break;
}
});

cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4;


//# sourceMappingURL=compiler.js.map?rel=1503590906352
