// Compiled by ClojureScript 1.9.908 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.userAgent.product');
goog.require('goog.object');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.utils');
goog.require('figwheel.client.heads_up');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('cljs.repl');
figwheel.client._figwheel_version_ = "0.5.13";
figwheel.client.js_stringify = (((typeof JSON !== 'undefined') && (!((JSON.stringify == null))))?(function (x){
return ["#js ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(JSON.stringify(x,null," "))].join('');
}):(function (x){
try{return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}catch (e41702){if((e41702 instanceof Error)){
var e = e41702;
return "Error: Unable to stringify";
} else {
throw e41702;

}
}}));
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var G__41705 = arguments.length;
switch (G__41705) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.mapv.call(null,(function (p1__41703_SHARP_){
if(typeof p1__41703_SHARP_ === 'string'){
return p1__41703_SHARP_;
} else {
return figwheel.client.js_stringify.call(null,p1__41703_SHARP_);
}
}),args)], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__29165__auto__ = [];
var len__29158__auto___41708 = arguments.length;
var i__29159__auto___41709 = (0);
while(true){
if((i__29159__auto___41709 < len__29158__auto___41708)){
args__29165__auto__.push((arguments[i__29159__auto___41709]));

var G__41710 = (i__29159__auto___41709 + (1));
i__29159__auto___41709 = G__41710;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((0) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__29166__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq41707){
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq41707));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__29165__auto__ = [];
var len__29158__auto___41712 = arguments.length;
var i__29159__auto___41713 = (0);
while(true){
if((i__29159__auto___41713 < len__29158__auto___41712)){
args__29165__auto__.push((arguments[i__29159__auto___41713]));

var G__41714 = (i__29159__auto___41713 + (1));
i__29159__auto___41713 = G__41714;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((0) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__29166__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq41711){
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq41711));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)"].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Figwheel autoloading ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method.
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 * 
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__41715){
var map__41716 = p__41715;
var map__41716__$1 = ((((!((map__41716 == null)))?((((map__41716.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41716.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41716):map__41716);
var message = cljs.core.get.call(null,map__41716__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__41716__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)," : ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__27989__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__27989__auto__)){
return or__27989__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__27977__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__27977__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__27977__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return (cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts)));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__38817__auto___41795 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38817__auto___41795,ch){
return (function (){
var f__38818__auto__ = (function (){var switch__38764__auto__ = ((function (c__38817__auto___41795,ch){
return (function (state_41767){
var state_val_41768 = (state_41767[(1)]);
if((state_val_41768 === (7))){
var inst_41763 = (state_41767[(2)]);
var state_41767__$1 = state_41767;
var statearr_41769_41796 = state_41767__$1;
(statearr_41769_41796[(2)] = inst_41763);

(statearr_41769_41796[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41768 === (1))){
var state_41767__$1 = state_41767;
var statearr_41770_41797 = state_41767__$1;
(statearr_41770_41797[(2)] = null);

(statearr_41770_41797[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41768 === (4))){
var inst_41720 = (state_41767[(7)]);
var inst_41720__$1 = (state_41767[(2)]);
var state_41767__$1 = (function (){var statearr_41771 = state_41767;
(statearr_41771[(7)] = inst_41720__$1);

return statearr_41771;
})();
if(cljs.core.truth_(inst_41720__$1)){
var statearr_41772_41798 = state_41767__$1;
(statearr_41772_41798[(1)] = (5));

} else {
var statearr_41773_41799 = state_41767__$1;
(statearr_41773_41799[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41768 === (15))){
var inst_41727 = (state_41767[(8)]);
var inst_41742 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_41727);
var inst_41743 = cljs.core.first.call(null,inst_41742);
var inst_41744 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_41743);
var inst_41745 = ["Figwheel: Not loading code with warnings - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_41744)].join('');
var inst_41746 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_41745);
var state_41767__$1 = state_41767;
var statearr_41774_41800 = state_41767__$1;
(statearr_41774_41800[(2)] = inst_41746);

(statearr_41774_41800[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41768 === (13))){
var inst_41751 = (state_41767[(2)]);
var state_41767__$1 = state_41767;
var statearr_41775_41801 = state_41767__$1;
(statearr_41775_41801[(2)] = inst_41751);

(statearr_41775_41801[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41768 === (6))){
var state_41767__$1 = state_41767;
var statearr_41776_41802 = state_41767__$1;
(statearr_41776_41802[(2)] = null);

(statearr_41776_41802[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41768 === (17))){
var inst_41749 = (state_41767[(2)]);
var state_41767__$1 = state_41767;
var statearr_41777_41803 = state_41767__$1;
(statearr_41777_41803[(2)] = inst_41749);

(statearr_41777_41803[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41768 === (3))){
var inst_41765 = (state_41767[(2)]);
var state_41767__$1 = state_41767;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_41767__$1,inst_41765);
} else {
if((state_val_41768 === (12))){
var inst_41726 = (state_41767[(9)]);
var inst_41740 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_41726,opts);
var state_41767__$1 = state_41767;
if(cljs.core.truth_(inst_41740)){
var statearr_41778_41804 = state_41767__$1;
(statearr_41778_41804[(1)] = (15));

} else {
var statearr_41779_41805 = state_41767__$1;
(statearr_41779_41805[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41768 === (2))){
var state_41767__$1 = state_41767;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41767__$1,(4),ch);
} else {
if((state_val_41768 === (11))){
var inst_41727 = (state_41767[(8)]);
var inst_41732 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41733 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_41727);
var inst_41734 = cljs.core.async.timeout.call(null,(1000));
var inst_41735 = [inst_41733,inst_41734];
var inst_41736 = (new cljs.core.PersistentVector(null,2,(5),inst_41732,inst_41735,null));
var state_41767__$1 = state_41767;
return cljs.core.async.ioc_alts_BANG_.call(null,state_41767__$1,(14),inst_41736);
} else {
if((state_val_41768 === (9))){
var inst_41727 = (state_41767[(8)]);
var inst_41753 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_41754 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_41727);
var inst_41755 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_41754);
var inst_41756 = ["Not loading: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_41755)].join('');
var inst_41757 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_41756);
var state_41767__$1 = (function (){var statearr_41780 = state_41767;
(statearr_41780[(10)] = inst_41753);

return statearr_41780;
})();
var statearr_41781_41806 = state_41767__$1;
(statearr_41781_41806[(2)] = inst_41757);

(statearr_41781_41806[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41768 === (5))){
var inst_41720 = (state_41767[(7)]);
var inst_41722 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_41723 = (new cljs.core.PersistentArrayMap(null,2,inst_41722,null));
var inst_41724 = (new cljs.core.PersistentHashSet(null,inst_41723,null));
var inst_41725 = figwheel.client.focus_msgs.call(null,inst_41724,inst_41720);
var inst_41726 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_41725);
var inst_41727 = cljs.core.first.call(null,inst_41725);
var inst_41728 = figwheel.client.autoload_QMARK_.call(null);
var state_41767__$1 = (function (){var statearr_41782 = state_41767;
(statearr_41782[(8)] = inst_41727);

(statearr_41782[(9)] = inst_41726);

return statearr_41782;
})();
if(cljs.core.truth_(inst_41728)){
var statearr_41783_41807 = state_41767__$1;
(statearr_41783_41807[(1)] = (8));

} else {
var statearr_41784_41808 = state_41767__$1;
(statearr_41784_41808[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41768 === (14))){
var inst_41738 = (state_41767[(2)]);
var state_41767__$1 = state_41767;
var statearr_41785_41809 = state_41767__$1;
(statearr_41785_41809[(2)] = inst_41738);

(statearr_41785_41809[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41768 === (16))){
var state_41767__$1 = state_41767;
var statearr_41786_41810 = state_41767__$1;
(statearr_41786_41810[(2)] = null);

(statearr_41786_41810[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41768 === (10))){
var inst_41759 = (state_41767[(2)]);
var state_41767__$1 = (function (){var statearr_41787 = state_41767;
(statearr_41787[(11)] = inst_41759);

return statearr_41787;
})();
var statearr_41788_41811 = state_41767__$1;
(statearr_41788_41811[(2)] = null);

(statearr_41788_41811[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41768 === (8))){
var inst_41726 = (state_41767[(9)]);
var inst_41730 = figwheel.client.reload_file_state_QMARK_.call(null,inst_41726,opts);
var state_41767__$1 = state_41767;
if(cljs.core.truth_(inst_41730)){
var statearr_41789_41812 = state_41767__$1;
(statearr_41789_41812[(1)] = (11));

} else {
var statearr_41790_41813 = state_41767__$1;
(statearr_41790_41813[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38817__auto___41795,ch))
;
return ((function (switch__38764__auto__,c__38817__auto___41795,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__38765__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__38765__auto____0 = (function (){
var statearr_41791 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41791[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__38765__auto__);

(statearr_41791[(1)] = (1));

return statearr_41791;
});
var figwheel$client$file_reloader_plugin_$_state_machine__38765__auto____1 = (function (state_41767){
while(true){
var ret_value__38766__auto__ = (function (){try{while(true){
var result__38767__auto__ = switch__38764__auto__.call(null,state_41767);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38767__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38767__auto__;
}
break;
}
}catch (e41792){if((e41792 instanceof Object)){
var ex__38768__auto__ = e41792;
var statearr_41793_41814 = state_41767;
(statearr_41793_41814[(5)] = ex__38768__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_41767);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e41792;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38766__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41815 = state_41767;
state_41767 = G__41815;
continue;
} else {
return ret_value__38766__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__38765__auto__ = function(state_41767){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__38765__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__38765__auto____1.call(this,state_41767);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloader_plugin_$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__38765__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__38765__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__38765__auto__;
})()
;})(switch__38764__auto__,c__38817__auto___41795,ch))
})();
var state__38819__auto__ = (function (){var statearr_41794 = f__38818__auto__.call(null);
(statearr_41794[(6)] = c__38817__auto___41795);

return statearr_41794;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38819__auto__);
});})(c__38817__auto___41795,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__41816_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__41816_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_41818 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_41818){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{figwheel.client.enable_repl_print_BANG_.call(null);

var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value], null));
}catch (e41817){if((e41817 instanceof Error)){
var e = e41817;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_41818], null));
} else {
var e = e41817;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}finally {figwheel.client.enable_repl_print_BANG_.call(null);
}});})(base_path_41818))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__41819){
var map__41820 = p__41819;
var map__41820__$1 = ((((!((map__41820 == null)))?((((map__41820.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41820.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41820):map__41820);
var opts = map__41820__$1;
var build_id = cljs.core.get.call(null,map__41820__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__41820,map__41820__$1,opts,build_id){
return (function (p__41822){
var vec__41823 = p__41822;
var seq__41824 = cljs.core.seq.call(null,vec__41823);
var first__41825 = cljs.core.first.call(null,seq__41824);
var seq__41824__$1 = cljs.core.next.call(null,seq__41824);
var map__41826 = first__41825;
var map__41826__$1 = ((((!((map__41826 == null)))?((((map__41826.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41826.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41826):map__41826);
var msg = map__41826__$1;
var msg_name = cljs.core.get.call(null,map__41826__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__41824__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__41823,seq__41824,first__41825,seq__41824__$1,map__41826,map__41826__$1,msg,msg_name,_,map__41820,map__41820__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__41823,seq__41824,first__41825,seq__41824__$1,map__41826,map__41826__$1,msg,msg_name,_,map__41820,map__41820__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__41820,map__41820__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__41828){
var vec__41829 = p__41828;
var seq__41830 = cljs.core.seq.call(null,vec__41829);
var first__41831 = cljs.core.first.call(null,seq__41830);
var seq__41830__$1 = cljs.core.next.call(null,seq__41830);
var map__41832 = first__41831;
var map__41832__$1 = ((((!((map__41832 == null)))?((((map__41832.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41832.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41832):map__41832);
var msg = map__41832__$1;
var msg_name = cljs.core.get.call(null,map__41832__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__41830__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__41834){
var map__41835 = p__41834;
var map__41835__$1 = ((((!((map__41835 == null)))?((((map__41835.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41835.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41835):map__41835);
var on_compile_warning = cljs.core.get.call(null,map__41835__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__41835__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__41835,map__41835__$1,on_compile_warning,on_compile_fail){
return (function (p__41837){
var vec__41838 = p__41837;
var seq__41839 = cljs.core.seq.call(null,vec__41838);
var first__41840 = cljs.core.first.call(null,seq__41839);
var seq__41839__$1 = cljs.core.next.call(null,seq__41839);
var map__41841 = first__41840;
var map__41841__$1 = ((((!((map__41841 == null)))?((((map__41841.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41841.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41841):map__41841);
var msg = map__41841__$1;
var msg_name = cljs.core.get.call(null,map__41841__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__41839__$1;
var pred__41843 = cljs.core._EQ_;
var expr__41844 = msg_name;
if(cljs.core.truth_(pred__41843.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__41844))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__41843.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__41844))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__41835,map__41835__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__38817__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38817__auto__,msg_hist,msg_names,msg){
return (function (){
var f__38818__auto__ = (function (){var switch__38764__auto__ = ((function (c__38817__auto__,msg_hist,msg_names,msg){
return (function (state_41933){
var state_val_41934 = (state_41933[(1)]);
if((state_val_41934 === (7))){
var inst_41853 = (state_41933[(2)]);
var state_41933__$1 = state_41933;
if(cljs.core.truth_(inst_41853)){
var statearr_41935_41982 = state_41933__$1;
(statearr_41935_41982[(1)] = (8));

} else {
var statearr_41936_41983 = state_41933__$1;
(statearr_41936_41983[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41934 === (20))){
var inst_41927 = (state_41933[(2)]);
var state_41933__$1 = state_41933;
var statearr_41937_41984 = state_41933__$1;
(statearr_41937_41984[(2)] = inst_41927);

(statearr_41937_41984[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41934 === (27))){
var inst_41923 = (state_41933[(2)]);
var state_41933__$1 = state_41933;
var statearr_41938_41985 = state_41933__$1;
(statearr_41938_41985[(2)] = inst_41923);

(statearr_41938_41985[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41934 === (1))){
var inst_41846 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_41933__$1 = state_41933;
if(cljs.core.truth_(inst_41846)){
var statearr_41939_41986 = state_41933__$1;
(statearr_41939_41986[(1)] = (2));

} else {
var statearr_41940_41987 = state_41933__$1;
(statearr_41940_41987[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41934 === (24))){
var inst_41925 = (state_41933[(2)]);
var state_41933__$1 = state_41933;
var statearr_41941_41988 = state_41933__$1;
(statearr_41941_41988[(2)] = inst_41925);

(statearr_41941_41988[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41934 === (4))){
var inst_41931 = (state_41933[(2)]);
var state_41933__$1 = state_41933;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_41933__$1,inst_41931);
} else {
if((state_val_41934 === (15))){
var inst_41929 = (state_41933[(2)]);
var state_41933__$1 = state_41933;
var statearr_41942_41989 = state_41933__$1;
(statearr_41942_41989[(2)] = inst_41929);

(statearr_41942_41989[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41934 === (21))){
var inst_41882 = (state_41933[(2)]);
var inst_41883 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_41884 = figwheel.client.auto_jump_to_error.call(null,opts,inst_41883);
var state_41933__$1 = (function (){var statearr_41943 = state_41933;
(statearr_41943[(7)] = inst_41882);

return statearr_41943;
})();
var statearr_41944_41990 = state_41933__$1;
(statearr_41944_41990[(2)] = inst_41884);

(statearr_41944_41990[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41934 === (31))){
var inst_41912 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_41933__$1 = state_41933;
if(cljs.core.truth_(inst_41912)){
var statearr_41945_41991 = state_41933__$1;
(statearr_41945_41991[(1)] = (34));

} else {
var statearr_41946_41992 = state_41933__$1;
(statearr_41946_41992[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41934 === (32))){
var inst_41921 = (state_41933[(2)]);
var state_41933__$1 = state_41933;
var statearr_41947_41993 = state_41933__$1;
(statearr_41947_41993[(2)] = inst_41921);

(statearr_41947_41993[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41934 === (33))){
var inst_41908 = (state_41933[(2)]);
var inst_41909 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_41910 = figwheel.client.auto_jump_to_error.call(null,opts,inst_41909);
var state_41933__$1 = (function (){var statearr_41948 = state_41933;
(statearr_41948[(8)] = inst_41908);

return statearr_41948;
})();
var statearr_41949_41994 = state_41933__$1;
(statearr_41949_41994[(2)] = inst_41910);

(statearr_41949_41994[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41934 === (13))){
var inst_41867 = figwheel.client.heads_up.clear.call(null);
var state_41933__$1 = state_41933;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41933__$1,(16),inst_41867);
} else {
if((state_val_41934 === (22))){
var inst_41888 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_41889 = figwheel.client.heads_up.append_warning_message.call(null,inst_41888);
var state_41933__$1 = state_41933;
var statearr_41950_41995 = state_41933__$1;
(statearr_41950_41995[(2)] = inst_41889);

(statearr_41950_41995[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41934 === (36))){
var inst_41919 = (state_41933[(2)]);
var state_41933__$1 = state_41933;
var statearr_41951_41996 = state_41933__$1;
(statearr_41951_41996[(2)] = inst_41919);

(statearr_41951_41996[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41934 === (29))){
var inst_41899 = (state_41933[(2)]);
var inst_41900 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_41901 = figwheel.client.auto_jump_to_error.call(null,opts,inst_41900);
var state_41933__$1 = (function (){var statearr_41952 = state_41933;
(statearr_41952[(9)] = inst_41899);

return statearr_41952;
})();
var statearr_41953_41997 = state_41933__$1;
(statearr_41953_41997[(2)] = inst_41901);

(statearr_41953_41997[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41934 === (6))){
var inst_41848 = (state_41933[(10)]);
var state_41933__$1 = state_41933;
var statearr_41954_41998 = state_41933__$1;
(statearr_41954_41998[(2)] = inst_41848);

(statearr_41954_41998[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41934 === (28))){
var inst_41895 = (state_41933[(2)]);
var inst_41896 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_41897 = figwheel.client.heads_up.display_warning.call(null,inst_41896);
var state_41933__$1 = (function (){var statearr_41955 = state_41933;
(statearr_41955[(11)] = inst_41895);

return statearr_41955;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41933__$1,(29),inst_41897);
} else {
if((state_val_41934 === (25))){
var inst_41893 = figwheel.client.heads_up.clear.call(null);
var state_41933__$1 = state_41933;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41933__$1,(28),inst_41893);
} else {
if((state_val_41934 === (34))){
var inst_41914 = figwheel.client.heads_up.flash_loaded.call(null);
var state_41933__$1 = state_41933;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41933__$1,(37),inst_41914);
} else {
if((state_val_41934 === (17))){
var inst_41873 = (state_41933[(2)]);
var inst_41874 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_41875 = figwheel.client.auto_jump_to_error.call(null,opts,inst_41874);
var state_41933__$1 = (function (){var statearr_41956 = state_41933;
(statearr_41956[(12)] = inst_41873);

return statearr_41956;
})();
var statearr_41957_41999 = state_41933__$1;
(statearr_41957_41999[(2)] = inst_41875);

(statearr_41957_41999[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41934 === (3))){
var inst_41865 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_41933__$1 = state_41933;
if(cljs.core.truth_(inst_41865)){
var statearr_41958_42000 = state_41933__$1;
(statearr_41958_42000[(1)] = (13));

} else {
var statearr_41959_42001 = state_41933__$1;
(statearr_41959_42001[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41934 === (12))){
var inst_41861 = (state_41933[(2)]);
var state_41933__$1 = state_41933;
var statearr_41960_42002 = state_41933__$1;
(statearr_41960_42002[(2)] = inst_41861);

(statearr_41960_42002[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41934 === (2))){
var inst_41848 = (state_41933[(10)]);
var inst_41848__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_41933__$1 = (function (){var statearr_41961 = state_41933;
(statearr_41961[(10)] = inst_41848__$1);

return statearr_41961;
})();
if(cljs.core.truth_(inst_41848__$1)){
var statearr_41962_42003 = state_41933__$1;
(statearr_41962_42003[(1)] = (5));

} else {
var statearr_41963_42004 = state_41933__$1;
(statearr_41963_42004[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41934 === (23))){
var inst_41891 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_41933__$1 = state_41933;
if(cljs.core.truth_(inst_41891)){
var statearr_41964_42005 = state_41933__$1;
(statearr_41964_42005[(1)] = (25));

} else {
var statearr_41965_42006 = state_41933__$1;
(statearr_41965_42006[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41934 === (35))){
var state_41933__$1 = state_41933;
var statearr_41966_42007 = state_41933__$1;
(statearr_41966_42007[(2)] = null);

(statearr_41966_42007[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41934 === (19))){
var inst_41886 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_41933__$1 = state_41933;
if(cljs.core.truth_(inst_41886)){
var statearr_41967_42008 = state_41933__$1;
(statearr_41967_42008[(1)] = (22));

} else {
var statearr_41968_42009 = state_41933__$1;
(statearr_41968_42009[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41934 === (11))){
var inst_41857 = (state_41933[(2)]);
var state_41933__$1 = state_41933;
var statearr_41969_42010 = state_41933__$1;
(statearr_41969_42010[(2)] = inst_41857);

(statearr_41969_42010[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41934 === (9))){
var inst_41859 = figwheel.client.heads_up.clear.call(null);
var state_41933__$1 = state_41933;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41933__$1,(12),inst_41859);
} else {
if((state_val_41934 === (5))){
var inst_41850 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_41933__$1 = state_41933;
var statearr_41970_42011 = state_41933__$1;
(statearr_41970_42011[(2)] = inst_41850);

(statearr_41970_42011[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41934 === (14))){
var inst_41877 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_41933__$1 = state_41933;
if(cljs.core.truth_(inst_41877)){
var statearr_41971_42012 = state_41933__$1;
(statearr_41971_42012[(1)] = (18));

} else {
var statearr_41972_42013 = state_41933__$1;
(statearr_41972_42013[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41934 === (26))){
var inst_41903 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_41933__$1 = state_41933;
if(cljs.core.truth_(inst_41903)){
var statearr_41973_42014 = state_41933__$1;
(statearr_41973_42014[(1)] = (30));

} else {
var statearr_41974_42015 = state_41933__$1;
(statearr_41974_42015[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41934 === (16))){
var inst_41869 = (state_41933[(2)]);
var inst_41870 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_41871 = figwheel.client.heads_up.display_exception.call(null,inst_41870);
var state_41933__$1 = (function (){var statearr_41975 = state_41933;
(statearr_41975[(13)] = inst_41869);

return statearr_41975;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41933__$1,(17),inst_41871);
} else {
if((state_val_41934 === (30))){
var inst_41905 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_41906 = figwheel.client.heads_up.display_warning.call(null,inst_41905);
var state_41933__$1 = state_41933;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41933__$1,(33),inst_41906);
} else {
if((state_val_41934 === (10))){
var inst_41863 = (state_41933[(2)]);
var state_41933__$1 = state_41933;
var statearr_41976_42016 = state_41933__$1;
(statearr_41976_42016[(2)] = inst_41863);

(statearr_41976_42016[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41934 === (18))){
var inst_41879 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_41880 = figwheel.client.heads_up.display_exception.call(null,inst_41879);
var state_41933__$1 = state_41933;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41933__$1,(21),inst_41880);
} else {
if((state_val_41934 === (37))){
var inst_41916 = (state_41933[(2)]);
var state_41933__$1 = state_41933;
var statearr_41977_42017 = state_41933__$1;
(statearr_41977_42017[(2)] = inst_41916);

(statearr_41977_42017[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41934 === (8))){
var inst_41855 = figwheel.client.heads_up.flash_loaded.call(null);
var state_41933__$1 = state_41933;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41933__$1,(11),inst_41855);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38817__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__38764__auto__,c__38817__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__38765__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__38765__auto____0 = (function (){
var statearr_41978 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41978[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__38765__auto__);

(statearr_41978[(1)] = (1));

return statearr_41978;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__38765__auto____1 = (function (state_41933){
while(true){
var ret_value__38766__auto__ = (function (){try{while(true){
var result__38767__auto__ = switch__38764__auto__.call(null,state_41933);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38767__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38767__auto__;
}
break;
}
}catch (e41979){if((e41979 instanceof Object)){
var ex__38768__auto__ = e41979;
var statearr_41980_42018 = state_41933;
(statearr_41980_42018[(5)] = ex__38768__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_41933);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e41979;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38766__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42019 = state_41933;
state_41933 = G__42019;
continue;
} else {
return ret_value__38766__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__38765__auto__ = function(state_41933){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__38765__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__38765__auto____1.call(this,state_41933);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__38765__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__38765__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__38765__auto__;
})()
;})(switch__38764__auto__,c__38817__auto__,msg_hist,msg_names,msg))
})();
var state__38819__auto__ = (function (){var statearr_41981 = f__38818__auto__.call(null);
(statearr_41981[(6)] = c__38817__auto__);

return statearr_41981;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38819__auto__);
});})(c__38817__auto__,msg_hist,msg_names,msg))
);

return c__38817__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__38817__auto___42048 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38817__auto___42048,ch){
return (function (){
var f__38818__auto__ = (function (){var switch__38764__auto__ = ((function (c__38817__auto___42048,ch){
return (function (state_42034){
var state_val_42035 = (state_42034[(1)]);
if((state_val_42035 === (1))){
var state_42034__$1 = state_42034;
var statearr_42036_42049 = state_42034__$1;
(statearr_42036_42049[(2)] = null);

(statearr_42036_42049[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42035 === (2))){
var state_42034__$1 = state_42034;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42034__$1,(4),ch);
} else {
if((state_val_42035 === (3))){
var inst_42032 = (state_42034[(2)]);
var state_42034__$1 = state_42034;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42034__$1,inst_42032);
} else {
if((state_val_42035 === (4))){
var inst_42022 = (state_42034[(7)]);
var inst_42022__$1 = (state_42034[(2)]);
var state_42034__$1 = (function (){var statearr_42037 = state_42034;
(statearr_42037[(7)] = inst_42022__$1);

return statearr_42037;
})();
if(cljs.core.truth_(inst_42022__$1)){
var statearr_42038_42050 = state_42034__$1;
(statearr_42038_42050[(1)] = (5));

} else {
var statearr_42039_42051 = state_42034__$1;
(statearr_42039_42051[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42035 === (5))){
var inst_42022 = (state_42034[(7)]);
var inst_42024 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_42022);
var state_42034__$1 = state_42034;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42034__$1,(8),inst_42024);
} else {
if((state_val_42035 === (6))){
var state_42034__$1 = state_42034;
var statearr_42040_42052 = state_42034__$1;
(statearr_42040_42052[(2)] = null);

(statearr_42040_42052[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42035 === (7))){
var inst_42030 = (state_42034[(2)]);
var state_42034__$1 = state_42034;
var statearr_42041_42053 = state_42034__$1;
(statearr_42041_42053[(2)] = inst_42030);

(statearr_42041_42053[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42035 === (8))){
var inst_42026 = (state_42034[(2)]);
var state_42034__$1 = (function (){var statearr_42042 = state_42034;
(statearr_42042[(8)] = inst_42026);

return statearr_42042;
})();
var statearr_42043_42054 = state_42034__$1;
(statearr_42043_42054[(2)] = null);

(statearr_42043_42054[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__38817__auto___42048,ch))
;
return ((function (switch__38764__auto__,c__38817__auto___42048,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__38765__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__38765__auto____0 = (function (){
var statearr_42044 = [null,null,null,null,null,null,null,null,null];
(statearr_42044[(0)] = figwheel$client$heads_up_plugin_$_state_machine__38765__auto__);

(statearr_42044[(1)] = (1));

return statearr_42044;
});
var figwheel$client$heads_up_plugin_$_state_machine__38765__auto____1 = (function (state_42034){
while(true){
var ret_value__38766__auto__ = (function (){try{while(true){
var result__38767__auto__ = switch__38764__auto__.call(null,state_42034);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38767__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38767__auto__;
}
break;
}
}catch (e42045){if((e42045 instanceof Object)){
var ex__38768__auto__ = e42045;
var statearr_42046_42055 = state_42034;
(statearr_42046_42055[(5)] = ex__38768__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_42034);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e42045;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38766__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42056 = state_42034;
state_42034 = G__42056;
continue;
} else {
return ret_value__38766__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__38765__auto__ = function(state_42034){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__38765__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__38765__auto____1.call(this,state_42034);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__38765__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__38765__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__38765__auto__;
})()
;})(switch__38764__auto__,c__38817__auto___42048,ch))
})();
var state__38819__auto__ = (function (){var statearr_42047 = f__38818__auto__.call(null);
(statearr_42047[(6)] = c__38817__auto___42048);

return statearr_42047;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38819__auto__);
});})(c__38817__auto___42048,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__38817__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38817__auto__){
return (function (){
var f__38818__auto__ = (function (){var switch__38764__auto__ = ((function (c__38817__auto__){
return (function (state_42062){
var state_val_42063 = (state_42062[(1)]);
if((state_val_42063 === (1))){
var inst_42057 = cljs.core.async.timeout.call(null,(3000));
var state_42062__$1 = state_42062;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42062__$1,(2),inst_42057);
} else {
if((state_val_42063 === (2))){
var inst_42059 = (state_42062[(2)]);
var inst_42060 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_42062__$1 = (function (){var statearr_42064 = state_42062;
(statearr_42064[(7)] = inst_42059);

return statearr_42064;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42062__$1,inst_42060);
} else {
return null;
}
}
});})(c__38817__auto__))
;
return ((function (switch__38764__auto__,c__38817__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__38765__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__38765__auto____0 = (function (){
var statearr_42065 = [null,null,null,null,null,null,null,null];
(statearr_42065[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__38765__auto__);

(statearr_42065[(1)] = (1));

return statearr_42065;
});
var figwheel$client$enforce_project_plugin_$_state_machine__38765__auto____1 = (function (state_42062){
while(true){
var ret_value__38766__auto__ = (function (){try{while(true){
var result__38767__auto__ = switch__38764__auto__.call(null,state_42062);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38767__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38767__auto__;
}
break;
}
}catch (e42066){if((e42066 instanceof Object)){
var ex__38768__auto__ = e42066;
var statearr_42067_42069 = state_42062;
(statearr_42067_42069[(5)] = ex__38768__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_42062);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e42066;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38766__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42070 = state_42062;
state_42062 = G__42070;
continue;
} else {
return ret_value__38766__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__38765__auto__ = function(state_42062){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__38765__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__38765__auto____1.call(this,state_42062);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_project_plugin_$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__38765__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__38765__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__38765__auto__;
})()
;})(switch__38764__auto__,c__38817__auto__))
})();
var state__38819__auto__ = (function (){var statearr_42068 = f__38818__auto__.call(null);
(statearr_42068[(6)] = c__38817__auto__);

return statearr_42068;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38819__auto__);
});})(c__38817__auto__))
);

return c__38817__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__4657__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__4657__auto__)){
var figwheel_version = temp__4657__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__38817__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38817__auto__,figwheel_version,temp__4657__auto__){
return (function (){
var f__38818__auto__ = (function (){var switch__38764__auto__ = ((function (c__38817__auto__,figwheel_version,temp__4657__auto__){
return (function (state_42077){
var state_val_42078 = (state_42077[(1)]);
if((state_val_42078 === (1))){
var inst_42071 = cljs.core.async.timeout.call(null,(2000));
var state_42077__$1 = state_42077;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42077__$1,(2),inst_42071);
} else {
if((state_val_42078 === (2))){
var inst_42073 = (state_42077[(2)]);
var inst_42074 = ["Figwheel Client Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client._figwheel_version_),"</strong> is not equal to ","Figwheel Sidecar Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel_version),"</strong>",".  Shutting down Websocket Connection!","<h4>To fix try:</h4>","<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>","<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>","<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>"].join('');
var inst_42075 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_42074);
var state_42077__$1 = (function (){var statearr_42079 = state_42077;
(statearr_42079[(7)] = inst_42073);

return statearr_42079;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42077__$1,inst_42075);
} else {
return null;
}
}
});})(c__38817__auto__,figwheel_version,temp__4657__auto__))
;
return ((function (switch__38764__auto__,c__38817__auto__,figwheel_version,temp__4657__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__38765__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__38765__auto____0 = (function (){
var statearr_42080 = [null,null,null,null,null,null,null,null];
(statearr_42080[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__38765__auto__);

(statearr_42080[(1)] = (1));

return statearr_42080;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__38765__auto____1 = (function (state_42077){
while(true){
var ret_value__38766__auto__ = (function (){try{while(true){
var result__38767__auto__ = switch__38764__auto__.call(null,state_42077);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38767__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38767__auto__;
}
break;
}
}catch (e42081){if((e42081 instanceof Object)){
var ex__38768__auto__ = e42081;
var statearr_42082_42084 = state_42077;
(statearr_42082_42084[(5)] = ex__38768__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_42077);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e42081;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38766__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42085 = state_42077;
state_42077 = G__42085;
continue;
} else {
return ret_value__38766__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__38765__auto__ = function(state_42077){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__38765__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__38765__auto____1.call(this,state_42077);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__38765__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__38765__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__38765__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__38765__auto__;
})()
;})(switch__38764__auto__,c__38817__auto__,figwheel_version,temp__4657__auto__))
})();
var state__38819__auto__ = (function (){var statearr_42083 = f__38818__auto__.call(null);
(statearr_42083[(6)] = c__38817__auto__);

return statearr_42083;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38819__auto__);
});})(c__38817__auto__,figwheel_version,temp__4657__auto__))
);

return c__38817__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__42086){
var map__42087 = p__42086;
var map__42087__$1 = ((((!((map__42087 == null)))?((((map__42087.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42087.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42087):map__42087);
var file = cljs.core.get.call(null,map__42087__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__42087__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__42087__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__42089 = "";
var G__42089__$1 = (cljs.core.truth_(file)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__42089),"file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__42089);
var G__42089__$2 = (cljs.core.truth_(line)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__42089__$1)," at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__42089__$1);
if(cljs.core.truth_((function (){var and__27977__auto__ = line;
if(cljs.core.truth_(and__27977__auto__)){
return column;
} else {
return and__27977__auto__;
}
})())){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__42089__$2),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__42089__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__42090){
var map__42091 = p__42090;
var map__42091__$1 = ((((!((map__42091 == null)))?((((map__42091.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42091.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42091):map__42091);
var ed = map__42091__$1;
var formatted_exception = cljs.core.get.call(null,map__42091__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__42091__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__42091__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__42093_42097 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__42094_42098 = null;
var count__42095_42099 = (0);
var i__42096_42100 = (0);
while(true){
if((i__42096_42100 < count__42095_42099)){
var msg_42101 = cljs.core._nth.call(null,chunk__42094_42098,i__42096_42100);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_42101);

var G__42102 = seq__42093_42097;
var G__42103 = chunk__42094_42098;
var G__42104 = count__42095_42099;
var G__42105 = (i__42096_42100 + (1));
seq__42093_42097 = G__42102;
chunk__42094_42098 = G__42103;
count__42095_42099 = G__42104;
i__42096_42100 = G__42105;
continue;
} else {
var temp__4657__auto___42106 = cljs.core.seq.call(null,seq__42093_42097);
if(temp__4657__auto___42106){
var seq__42093_42107__$1 = temp__4657__auto___42106;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__42093_42107__$1)){
var c__28828__auto___42108 = cljs.core.chunk_first.call(null,seq__42093_42107__$1);
var G__42109 = cljs.core.chunk_rest.call(null,seq__42093_42107__$1);
var G__42110 = c__28828__auto___42108;
var G__42111 = cljs.core.count.call(null,c__28828__auto___42108);
var G__42112 = (0);
seq__42093_42097 = G__42109;
chunk__42094_42098 = G__42110;
count__42095_42099 = G__42111;
i__42096_42100 = G__42112;
continue;
} else {
var msg_42113 = cljs.core.first.call(null,seq__42093_42107__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_42113);

var G__42114 = cljs.core.next.call(null,seq__42093_42107__$1);
var G__42115 = null;
var G__42116 = (0);
var G__42117 = (0);
seq__42093_42097 = G__42114;
chunk__42094_42098 = G__42115;
count__42095_42099 = G__42116;
i__42096_42100 = G__42117;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Error on ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,ed))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__42118){
var map__42119 = p__42118;
var map__42119__$1 = ((((!((map__42119 == null)))?((((map__42119.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42119.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42119):map__42119);
var w = map__42119__$1;
var message = cljs.core.get.call(null,map__42119__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),["Figwheel: Compile Warning - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message))," in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,message))].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"resources/public/js/out/figwheel/client.cljs",33,1,363,363,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"resources/public/js/out/figwheel/client.cljs",30,1,355,355,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"formatted-exception","formatted-exception",1524042501,null),new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,["ws://",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),"/figwheel-ws"].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__27977__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__27977__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__27977__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__42121 = cljs.core.seq.call(null,plugins);
var chunk__42122 = null;
var count__42123 = (0);
var i__42124 = (0);
while(true){
if((i__42124 < count__42123)){
var vec__42125 = cljs.core._nth.call(null,chunk__42122,i__42124);
var k = cljs.core.nth.call(null,vec__42125,(0),null);
var plugin = cljs.core.nth.call(null,vec__42125,(1),null);
if(cljs.core.truth_(plugin)){
var pl_42131 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__42121,chunk__42122,count__42123,i__42124,pl_42131,vec__42125,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_42131.call(null,msg_hist);
});})(seq__42121,chunk__42122,count__42123,i__42124,pl_42131,vec__42125,k,plugin))
);
} else {
}

var G__42132 = seq__42121;
var G__42133 = chunk__42122;
var G__42134 = count__42123;
var G__42135 = (i__42124 + (1));
seq__42121 = G__42132;
chunk__42122 = G__42133;
count__42123 = G__42134;
i__42124 = G__42135;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__42121);
if(temp__4657__auto__){
var seq__42121__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__42121__$1)){
var c__28828__auto__ = cljs.core.chunk_first.call(null,seq__42121__$1);
var G__42136 = cljs.core.chunk_rest.call(null,seq__42121__$1);
var G__42137 = c__28828__auto__;
var G__42138 = cljs.core.count.call(null,c__28828__auto__);
var G__42139 = (0);
seq__42121 = G__42136;
chunk__42122 = G__42137;
count__42123 = G__42138;
i__42124 = G__42139;
continue;
} else {
var vec__42128 = cljs.core.first.call(null,seq__42121__$1);
var k = cljs.core.nth.call(null,vec__42128,(0),null);
var plugin = cljs.core.nth.call(null,vec__42128,(1),null);
if(cljs.core.truth_(plugin)){
var pl_42140 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__42121,chunk__42122,count__42123,i__42124,pl_42140,vec__42128,k,plugin,seq__42121__$1,temp__4657__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_42140.call(null,msg_hist);
});})(seq__42121,chunk__42122,count__42123,i__42124,pl_42140,vec__42128,k,plugin,seq__42121__$1,temp__4657__auto__))
);
} else {
}

var G__42141 = cljs.core.next.call(null,seq__42121__$1);
var G__42142 = null;
var G__42143 = (0);
var G__42144 = (0);
seq__42121 = G__42141;
chunk__42122 = G__42142;
count__42123 = G__42143;
i__42124 = G__42144;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var G__42146 = arguments.length;
switch (G__42146) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__42147_42152 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__42148_42153 = null;
var count__42149_42154 = (0);
var i__42150_42155 = (0);
while(true){
if((i__42150_42155 < count__42149_42154)){
var msg_42156 = cljs.core._nth.call(null,chunk__42148_42153,i__42150_42155);
figwheel.client.socket.handle_incoming_message.call(null,msg_42156);

var G__42157 = seq__42147_42152;
var G__42158 = chunk__42148_42153;
var G__42159 = count__42149_42154;
var G__42160 = (i__42150_42155 + (1));
seq__42147_42152 = G__42157;
chunk__42148_42153 = G__42158;
count__42149_42154 = G__42159;
i__42150_42155 = G__42160;
continue;
} else {
var temp__4657__auto___42161 = cljs.core.seq.call(null,seq__42147_42152);
if(temp__4657__auto___42161){
var seq__42147_42162__$1 = temp__4657__auto___42161;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__42147_42162__$1)){
var c__28828__auto___42163 = cljs.core.chunk_first.call(null,seq__42147_42162__$1);
var G__42164 = cljs.core.chunk_rest.call(null,seq__42147_42162__$1);
var G__42165 = c__28828__auto___42163;
var G__42166 = cljs.core.count.call(null,c__28828__auto___42163);
var G__42167 = (0);
seq__42147_42152 = G__42164;
chunk__42148_42153 = G__42165;
count__42149_42154 = G__42166;
i__42150_42155 = G__42167;
continue;
} else {
var msg_42168 = cljs.core.first.call(null,seq__42147_42162__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_42168);

var G__42169 = cljs.core.next.call(null,seq__42147_42162__$1);
var G__42170 = null;
var G__42171 = (0);
var G__42172 = (0);
seq__42147_42152 = G__42169;
chunk__42148_42153 = G__42170;
count__42149_42154 = G__42171;
i__42150_42155 = G__42172;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__29165__auto__ = [];
var len__29158__auto___42177 = arguments.length;
var i__29159__auto___42178 = (0);
while(true){
if((i__29159__auto___42178 < len__29158__auto___42177)){
args__29165__auto__.push((arguments[i__29159__auto___42178]));

var G__42179 = (i__29159__auto___42178 + (1));
i__29159__auto___42178 = G__42179;
continue;
} else {
}
break;
}

var argseq__29166__auto__ = ((((0) < args__29165__auto__.length))?(new cljs.core.IndexedSeq(args__29165__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__29166__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__42174){
var map__42175 = p__42174;
var map__42175__$1 = ((((!((map__42175 == null)))?((((map__42175.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42175.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42175):map__42175);
var opts = map__42175__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq42173){
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq42173));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e42180){if((e42180 instanceof Error)){
var e = e42180;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e42180;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),((function (config){
return (function (p__42181){
var map__42182 = p__42181;
var map__42182__$1 = ((((!((map__42182 == null)))?((((map__42182.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42182.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42182):map__42182);
var msg_name = cljs.core.get.call(null,map__42182__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1503590938668
